
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/cfg/CTR/detail/cfg_Default.h>
#include <nn/cfg/CTR/detail/cfg_Keys.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include "Cal2Cfg.h"

using namespace uji::sys;
using namespace nn::cfg::CTR::detail;
using namespace nn::cfg::CTR::init;
using namespace nn::drivers::cal::CTR;


namespace uji {
namespace sec {

namespace
{
    GraphicsDrawing *gfx = GraphicsDrawing::GetInstance();
    WindowManager  WindowManager;
    TextWindow*    DebugWindow;
}

static void Eva_CreateDebugWindow()
{
    // 
    // \p Window p
    const int FONT_SIZE = 14;
    DebugWindow = new TextWindow( 45, 16, FONT_SIZE );
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    (void)WindowManager.CreateWindow(DebugWindow, NN_GX_DISPLAY1, 0, 0);
    DebugWindow->SetTitle("Debug");
}
static void Eva_UpdateDebugWindow()
{
    WindowManager.Update();
    WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}
static void Eva_DestroyDebugWindow()
{
    // Window j
    WindowManager.DestroyWindow(DebugWindow);
}
static bool Eva_WaitInputKey()
{
    // 
    // ʊmFp
    uji::sys::Pad pad;
    do {
        pad.UpdatePad();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
        
        if(pad.IsButtonDown(Pad::BUTTON_B)) return false;
        
    } while(!pad.IsButtonDown(Pad::BUTTON_A));
    
    return true;
}


//===========================================================================
//===========================================================================
//                  CAL  CFG ɒlRs[֐
//===========================================================================
//===========================================================================
void CalToCfg()
{
    // bZ[W
    {
        Eva_CreateDebugWindow();
        DebugWindow->Gotoxy(0,0);
        DebugWindow->SetTextColor(ATTR_COLOR_WHITE);
        DebugWindow->Printf(" - CAL to CFG -\n");
        DebugWindow->Printf("  Press (A): copy from CAL to CFG. \n");
        DebugWindow->Printf("        (B): back to Menu. \n");
        DebugWindow->SetTextColor(ATTR_COLOR_CYAN);
        DebugWindow->Printf("  Please press (A) when you confirmed.\n");
        DebugWindow->Printf("\n");
        Eva_UpdateDebugWindow();
        if(false == Eva_WaitInputKey() )
        {
            // LZ
            DebugWindow->SetTextColor(ATTR_COLOR_RED);
            DebugWindow->Printf("\n  CANCELED");
            Eva_UpdateDebugWindow();
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1000));
            return;
        }
    }
    
    bool ret = false;

    // C-ARM̂Ƃ̓tbJ[A{[A^b`plAXChpbhCALl̂CFGɈڂ
    CAL2CFG_SUBJECT sbj;
    if( PASS != RetCalToCfg(CalToCfg_LCD_FLICKER(),  LCD_FLICKER)  )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_TOUCH_PANEL(),  TOUCH_PANEL)  )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_ANALOG_STICK(), ANALOG_STICK) )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_MCU(),          MCU)          )  goto FIN;
#ifndef EVA_CAL2CFG_CARM
    if( PASS != RetCalToCfg(CalToCfg_FCRAM(),        FCRAM)        )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_GYRO_SCOPE(),   GYRO_SCOPE)   )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_RTC(),          RTC)          )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_ACCEL(),        ACCEL)        )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_CAMERA(),       CAMERA)       )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_BL_PWM(),       BL_PWM)       )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_ABL(),          ABL)          )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_ABL_LGY(),      ABL_LGY)      )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_ULCD(),         ULCD)         )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_SURROUND(),     SURROUND)     )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_CODEC(),        CODEC)        )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_ULCD_DELAY(),   ULCD_DELAY)   )  goto FIN;
    if( PASS != RetCalToCfg(CalToCfg_ECHO_CANCEL(),  ECHO_CANCEL)  )  goto FIN;
#endif
    
    ret = true;
    Eva_UpdateDebugWindow();
    
FIN:
    if( ret == false )
    {
        // s
        DebugWindow->SetTextColor(ATTR_COLOR_RED);
        DebugWindow->Printf("\n  NG");
    }
    else
    {
        // 
        DebugWindow->SetTextColor(ATTR_COLOR_GREEN);
        DebugWindow->Printf("\n  OK");
    }
    
    // IbZ[W
    {
        DebugWindow->SetTextColor(ATTR_COLOR_CYAN);
        DebugWindow->Printf(" (Press any key to go back to Menu.)");
        Eva_UpdateDebugWindow();
        Eva_WaitInputKey();
        Eva_DestroyDebugWindow();
    }
}

s32 RetCalToCfg( s32 ret_Cal2Cfg, CAL2CFG_SUBJECT sbj )
{
    char ret_c = '_';
    
    if( ret_Cal2Cfg == PASS )
    {
        DebugWindow->SetTextColor(ATTR_COLOR_GREEN);
        ret_c = 'O';
    }
    else
    {
        DebugWindow->SetTextColor(ATTR_COLOR_RED);
        ret_c = 'X';
    }
    
    switch( sbj )
    {
    case LCD_FLICKER:  DebugWindow->Printf("  LCD_FLICKER   %c"  , ret_c);  break;
    case TOUCH_PANEL:  DebugWindow->Printf("  TOUCH_PANEL   %c\n", ret_c);  break;
    case ANALOG_STICK: DebugWindow->Printf("  ANALOG_STICK  %c"  , ret_c);  break;
    case MCU:          DebugWindow->Printf("  MCU           %c\n", ret_c);  break;
    case FCRAM:        DebugWindow->Printf("  FCRAM         %c"  , ret_c);  break;
    case GYRO_SCOPE:   DebugWindow->Printf("  GYRO_SCOPE    %c\n", ret_c);  break;
    case RTC:          DebugWindow->Printf("  RTC           %c"  , ret_c);  break;
    case ACCEL:        DebugWindow->Printf("  ACCEL         %c\n", ret_c);  break;
    case CAMERA:       DebugWindow->Printf("  CAMERA        %c"  , ret_c);  break;
    case BL_PWM:       DebugWindow->Printf("  BL_PWM        %c\n", ret_c);  break;
    case ABL:          DebugWindow->Printf("  ABL           %c"  , ret_c);  break;
    case ABL_LGY:      DebugWindow->Printf("  ABL_LGY       %c\n", ret_c);  break;
    case ULCD:         DebugWindow->Printf("  ULCD          %c"  , ret_c);  break;
    case SURROUND:     DebugWindow->Printf("  SURROUND      %c\n", ret_c);  break;
    case CODEC:        DebugWindow->Printf("  CODEC         %c"  , ret_c);  break;
    case ULCD_DELAY:   DebugWindow->Printf("  ULCD_DELAY    %c\n", ret_c);  break;
    case ECHO_CANCEL:  DebugWindow->Printf("  ECHO_CANCEL   %c\n", ret_c);  break;
    }
    Eva_UpdateDebugWindow();
    
    return ret_Cal2Cfg;
}

//===========================================================================
//===========================================================================
//                  CAL  CFG ɒlRs[ieڕʁj
//===========================================================================
//===========================================================================
/*---------------------------------------------------------------------------
  Desc: FCRAM Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_FCRAM()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    FcramCalData  fcramCalData;
    cal.Get(&fcramCalData, CAL_DATA_FCRAM);
    
    //
    // CFG ɒlݒ
    FcramCfgData  data;
    data.FcramDelayValue = fcramCalData.FcramDelayValue;
    size_t size          = sizeof(FcramCfgData);
    bit32 cfgKey         = GET_CFG_KEY(NN_CFG_FCRAM, NN_CFG_FCRAM_CAL_DELAY);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: LCD_FLICKER Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_LCD_FLICKER()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    LcdFlickerInfo  lcdFlickerInfo;
    cal.Get(&lcdFlickerInfo, CAL_DATA_LCD_FLICKER);

    //
    // CFG ɒlݒ
    LcdFlickerCfgData  data;
    data.vcomTop    = lcdFlickerInfo.vcomTop;
    data.vcomBottom = lcdFlickerInfo.vcomBottom;
    size_t size     = sizeof(LcdFlickerCfgData);
    bit32 cfgKey    = GET_CFG_KEY(NN_CFG_LCD, NN_CFG_LCD_CAL_FLICKER);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: TOUCH_PANEL Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_TOUCH_PANEL()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    TouchPanelCalDataCore  touchPanelCalDataCore;
    cal.Get(&touchPanelCalDataCore, CAL_DATA_TOUCH_PANEL);
    
    //
    // CFG ɒlݒ
    TouchPanelCfgData  data;
    data.point0.raw_x  = touchPanelCalDataCore.point0.raw_x;
    data.point0.raw_y  = touchPanelCalDataCore.point0.raw_y;
    data.point0.dx     = touchPanelCalDataCore.point0.dx;
    data.point0.dy     = touchPanelCalDataCore.point0.dy;
    data.point1.raw_x  = touchPanelCalDataCore.point1.raw_x;
    data.point1.raw_y  = touchPanelCalDataCore.point1.raw_y;
    data.point1.dx     = touchPanelCalDataCore.point1.dx;
    data.point1.dy     = touchPanelCalDataCore.point1.dy;
    size_t size        = sizeof(TouchPanelCfgData);
    bit32 cfgKey       = GET_CFG_KEY(NN_CFG_HID, NN_CFG_HID_CAL_TOUCHPANEL);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: GYRO_SCOPE Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_GYRO_SCOPE()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    GyroscopeCalDataCore  gyroscopeCalDataCore;
    cal.Get(&gyroscopeCalDataCore, CAL_DATA_GYRO_SCOPE);
    
    //
    // CFG ɒlݒ
    GyroscopeCfgData  data;
    data.x.raw_rpm_0            = gyroscopeCalDataCore.x.raw_rpm_0;
    data.x.raw_rpm_positive_78  = gyroscopeCalDataCore.x.raw_rpm_positive_78;
    data.x.raw_rpm_negative_78  = gyroscopeCalDataCore.x.raw_rpm_negative_78;
    data.y.raw_rpm_0            = gyroscopeCalDataCore.y.raw_rpm_0;
    data.y.raw_rpm_positive_78  = gyroscopeCalDataCore.y.raw_rpm_positive_78;
    data.y.raw_rpm_negative_78  = gyroscopeCalDataCore.y.raw_rpm_negative_78;
    data.z.raw_rpm_0            = gyroscopeCalDataCore.z.raw_rpm_0;
    data.z.raw_rpm_positive_78  = gyroscopeCalDataCore.z.raw_rpm_positive_78;
    data.z.raw_rpm_negative_78  = gyroscopeCalDataCore.z.raw_rpm_negative_78;
    size_t size  = sizeof(GyroscopeCfgData);
    bit32 cfgKey = GET_CFG_KEY(NN_CFG_HID, NN_CFG_HID_CAL_GYROSCOPE);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: RTC Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_RTC()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    RtcCompensation  rtcCompensation;
    cal.Get(&rtcCompensation, CAL_DATA_RTC);
    
    //
    // CFG ɒlݒ
    RtcCfgData  data;
    data.RTCCompensationValue = rtcCompensation.RTCCompensationValue;
    size_t size               = sizeof(RtcCfgData);
    bit32 cfgKey              = GET_CFG_KEY(NN_CFG_RTC, NN_CFG_RTC_CAL_COMPENSATION);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: ACCEL Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_ACCEL()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    AccelCalDataCore  accelCalDataCore;
    cal.Get(&accelCalDataCore, CAL_DATA_ACCEL);
    
    //
    // CFG ɒlݒ
    AccelCfgData  data;
    data.x.offset  = accelCalDataCore.x.offset;
    data.x.scale   = accelCalDataCore.x.scale;
    data.y.offset  = accelCalDataCore.y.offset;
    data.y.scale   = accelCalDataCore.y.scale;
    data.z.offset  = accelCalDataCore.z.offset;
    data.z.scale   = accelCalDataCore.z.scale;
    size_t size  = sizeof(AccelCfgData);
    bit32 cfgKey = GET_CFG_KEY(NN_CFG_HID, NN_CFG_HID_CAL_ACCELEROMETER);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: CAMERA Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_CAMERA()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    CameraCalDataCore       cameraCalDataCore;
    CameraCalAppendCore     cameraCalAppendCore;
    cal.Get(&cameraCalDataCore,   CAL_DATA_CAMERA);
    cal.Get(&cameraCalAppendCore, CAL_DATA_CAMERA_APPEND);
    
    //
    // CFG ɒlݒ
    CameraCfgData  data = CAMERA_CFG_DEFAULT;
    data.position.flags.isValidRotationXY = (cameraCalDataCore.position.flags ? true : false );
    data.position.scale             = cameraCalDataCore.position.scale;
    data.position.rotationZ         = cameraCalDataCore.position.rotationZ;
    data.position.translationX      = cameraCalDataCore.position.translationX;
    data.position.translationY      = cameraCalDataCore.position.translationY;
    data.position.rotationX         = cameraCalDataCore.position.rotationX;
    data.position.rotationY         = cameraCalDataCore.position.rotationY;
    data.position.angleOfViewRight  = cameraCalDataCore.position.angleOfViewRight;
    data.position.angleOfViewLeft   = cameraCalDataCore.position.angleOfViewLeft;
    data.position.distanceToChart   = cameraCalDataCore.position.distanceToChart;
    data.position.distanceCameras   = cameraCalDataCore.position.distanceCameras;
    data.position.imageWidth        = cameraCalDataCore.position.imageWidth;
    data.position.imageHeight       = cameraCalDataCore.position.imageHeight;
    
    data.quality.aeBaseTarget       = cameraCalDataCore.quality.aeBaseTarget;
    data.quality.kRL                = cameraCalDataCore.quality.kRL;
    data.quality.kGL                = cameraCalDataCore.quality.kGL;
    data.quality.kBL                = cameraCalDataCore.quality.kBL;
    data.quality.ccmPosition        = cameraCalDataCore.quality.ccmPosition;
    
    data.quality.awbCcmL9Right      = cameraCalAppendCore.awbCcmL9Right;
    data.quality.awbCcmL9Left       = cameraCalAppendCore.awbCcmL9Left;
    data.quality.awbCcmL10Right     = cameraCalAppendCore.awbCcmL10Right;
    data.quality.awbCcmL10Left      = cameraCalAppendCore.awbCcmL10Left;
    data.quality.awbX0Right         = cameraCalAppendCore.awbX0Right;
    data.quality.awbX0Left          = cameraCalAppendCore.awbX0Left;
    
    size_t size  = sizeof(CameraCfgData);
    bit32 cfgKey = GET_CFG_KEY(NN_CFG_CAMERA, NN_CFG_CAMERA_CAL);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: ANALOG_STICK Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_ANALOG_STICK()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    AnalogStickCalDataCore      calDataCore;
    AnalogStickCalAppendCore    calAppendCore;
    cal.Get(&calDataCore,   CAL_DATA_ANALOG_STICK);
    cal.Get(&calAppendCore, CAL_DATA_ANALOG_STICK_APPEND);
    
    //
    // CFG ɒlݒ
    AnalogStickCfgData  data = ANALOG_STICK_CFG_DEFAULT;
    data.scale_x   = calAppendCore.scale_x;
    data.scale_y   = calAppendCore.scale_y;
    data.center_x  = calDataCore.center_x;
    data.center_y  = calDataCore.center_y;
    data.max_x     = calAppendCore.max_x;
    data.min_x     = calAppendCore.min_x;
    data.max_y     = calAppendCore.max_y;
    data.min_y     = calAppendCore.min_y;
    data.type      = calAppendCore.type;
    size_t size    = sizeof(AnalogStickCfgData);
    bit32 cfgKey   = GET_CFG_KEY(NN_CFG_HID, NN_CFG_HID_CAL_ANALOGSTICK);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: BL_PWM Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_BL_PWM()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    BacklightCalDataCore  backlightCalDataCore;
    cal.Get(&backlightCalDataCore, CAL_DATA_BL_PWM);
    
    //
    // CFG ɒlݒ
    BacklightPwmTableCfgData  data = BACKLIGHT_PWM_TABLE_CFG_DEFAULT;
    for(int i=0; i<3; i++){
        for(int j=0; j<3; j++){
            data.coef[i][j] = backlightCalDataCore.coef[i][j];
        }
    }
    data.numLevels          = backlightCalDataCore.numLevels;
    for(int i=0; i<7; i++){
        data.luminanceLevel[i] = backlightCalDataCore.luminanceLevel[i];
    }
    data.brightnessBase     = backlightCalDataCore.brightnessBase;
    data.brightnessMinimum  = backlightCalDataCore.brightnessMinimum;
    size_t size  = sizeof(BacklightPwmTableCfgData);
    bit32 cfgKey = GET_CFG_KEY(NN_CFG_LCD, NN_CFG_LCD_BACKLIGHT_PWM_TABLE);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: ABL Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_ABL()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    AblDetailCalDataCore  ablDetailCalDataCore;
    cal.Get(&ablDetailCalDataCore, CAL_DATA_ABL);
    
    //
    // CFG ɒlݒ
    AblDetailCfgData  data = ABL_DETAIL_CFG_DEFAULT;
    data.ditherPattern  = ablDetailCalDataCore.ditherPattern;
    data.xStart         = ablDetailCalDataCore.xStart;
    data.yStart         = ablDetailCalDataCore.yStart;
    data.xWidth         = ablDetailCalDataCore.xWidth;
    data.yWidth         = ablDetailCalDataCore.yWidth;
    data.gthRatio       = ablDetailCalDataCore.gthRatio;
    data.ditherMode     = ablDetailCalDataCore.ditherMode;
    data.rsMin          = ablDetailCalDataCore.rsMin;
    data.rsMax          = ablDetailCalDataCore.rsMax;
    data.gthMin         = ablDetailCalDataCore.gthMin;
    data.maxMin         = ablDetailCalDataCore.maxMin;
    data.maxEx          = ablDetailCalDataCore.maxEx;
    data.inertia        = ablDetailCalDataCore.inertia;
    for(int i=0; i<9; i++){
        data.rsLut[i]   = ablDetailCalDataCore.rsLut[i];
    }
    size_t size      = sizeof(AblDetailCfgData);
    bit32 cfgKey     = GET_CFG_KEY(NN_CFG_LCD, NN_CFG_LCD_ABL_DETAIL);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: ABL_LGY Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_ABL_LGY()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    AblLgyDetailCalDataCore  ablLgyDetailCalDataCore;
    cal.Get(&ablLgyDetailCalDataCore, CAL_DATA_ABL);
    
    //
    // CFG ɒlݒ
    AblDetailCfgData  data = ABL_DETAIL_CFG_DEFAULT;
    data.ditherPattern  = ablLgyDetailCalDataCore.ditherPattern;
    data.xStart         = ablLgyDetailCalDataCore.xStart;
    data.yStart         = ablLgyDetailCalDataCore.yStart;
    data.xWidth         = ablLgyDetailCalDataCore.xWidth;
    data.yWidth         = ablLgyDetailCalDataCore.yWidth;
    data.gthRatio       = ablLgyDetailCalDataCore.gthRatio;
    data.ditherMode     = ablLgyDetailCalDataCore.ditherMode;
    data.rsMin          = ablLgyDetailCalDataCore.rsMin;
    data.rsMax          = ablLgyDetailCalDataCore.rsMax;
    data.gthMin         = ablLgyDetailCalDataCore.gthMin;
    data.maxMin         = ablLgyDetailCalDataCore.maxMin;
    data.maxEx          = ablLgyDetailCalDataCore.maxEx;
    data.inertia        = ablLgyDetailCalDataCore.inertia;
    for(int i=0; i<9; i++){
        data.rsLut[i]   = ablLgyDetailCalDataCore.rsLut[i];
    }
    size_t size         = sizeof(AblDetailCfgData);
    bit32 cfgKey        = GET_CFG_KEY(NN_CFG_LCD, NN_CFG_LCD_ABL_DETAIL_LGY);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: ULCD Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_ULCD()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    UlcdAssumptionCalDataCore  ulcdAssumptionCalDataCore;
    cal.Get(&ulcdAssumptionCalDataCore, CAL_DATA_ULCD);
    
    //
    // CFG ɒlݒ
    UlcdLibAssumptionCfgData  data = ULCDLIB_ASSUMPTION_CFG_DEFAULT;
    data.pupillaryDist       = ulcdAssumptionCalDataCore.pupillaryDist;
    data.distEyeAndDisp      = ulcdAssumptionCalDataCore.distEyeAndDisp;
    data.wideSideLen         = ulcdAssumptionCalDataCore.wideSideLen;
    data.narrowSideLen       = ulcdAssumptionCalDataCore.narrowSideLen;
    data.maxParallaxBack     = ulcdAssumptionCalDataCore.maxParallaxBack;
    data.maxParallaxFront    = ulcdAssumptionCalDataCore.maxParallaxFront;
    data.maxDepthRangeBack   = ulcdAssumptionCalDataCore.maxDepthRangeBack;
    data.maxDepthRangeFront  = ulcdAssumptionCalDataCore.maxDepthRangeFront;
    size_t size  = sizeof(UlcdLibAssumptionCfgData);
    bit32 cfgKey = GET_CFG_KEY(NN_CFG_LCD, NN_CFG_LCD_ULCDLIB_ASSUMPTION);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: MCU Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_MCU()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    McuCalDataCore  mcuCalDataCore;
    cal.Get(&mcuCalDataCore, CAL_DATA_MCU);
    
    //
    // CFG ɒlݒ
    McuSlideVolumeRangeCfgData  data = MCU_SLIDE_VOLUME_RANGE_CFG_DEFAULT;
    data.svr2.min   = mcuCalDataCore.svr2.min;
    data.svr2.max   = mcuCalDataCore.svr2.max;
    data.sound.min  = mcuCalDataCore.sound.min;
    data.sound.max  = mcuCalDataCore.sound.max;
    size_t size  = sizeof(McuSlideVolumeRangeCfgData);
    bit32 cfgKey = GET_CFG_KEY(NN_CFG_MCU, NN_CFG_MCU_SLIDE_VOLUME);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: SURROUND Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_SURROUND()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    Surround  surround;
    cal.Get(&surround, CAL_DATA_SURROUND);
    
    //
    // CFG ɒlݒ
    SurroundCfgData  data = SURROUND_CFG_DEFAULT;
    for(int i=0; i<256; i++){
        data.specialFilter[i]  = surround.specialFilter[i];
    }
    for(int i=0; i<5; i++){
        data.iirFilter[i]      = surround.iirFilter[i];
    }
    size_t size  = sizeof(SurroundCfgData);
    bit32 cfgKey = GET_CFG_KEY(NN_CFG_SOUND, NN_CFG_SOUND_SURROUND_CAL);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: CODEC Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_CODEC()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    CodecCalDataCore  codecCalDataCore;
    cal.Get(&codecCalDataCore, CAL_DATA_CODEC);
    
    //
    // CFG ɒlݒ
    CodecCfgData *pData = &codecCalDataCore;
    size_t size         = sizeof(CodecCfgData);
    bit32 cfgKey        = GET_CFG_KEY(NN_CFG_CODEC, NN_CFG_CODEC_CAL);
    
    if(SetConfig(cfgKey, pData, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: ULCD_DELAY Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_ULCD_DELAY()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    UlcdDelayCalDataCore  ulcdDelayCalDataCore;
    cal.Get(&ulcdDelayCalDataCore, CAL_DATA_ULCD_DELAY);
    
    //
    // CFG ɒlݒ
    UlcdDelayCfgData data = ULCD_DELAY_CFG_DEFAULT;
    data.to2D       = ulcdDelayCalDataCore.to2D;
    data.to3D       = ulcdDelayCalDataCore.to3D;
    size_t size     = sizeof(UlcdDelayCfgData);
    bit32 cfgKey    = GET_CFG_KEY(NN_CFG_LCD, NN_CFG_LCD_ULCD_DELAY);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: ECHO_CANCEL Lu[VlRs[
---------------------------------------------------------------------------*/
s32 CalToCfg_ECHO_CANCEL()
{
    Calibration cal;
    cal.Initialize();
    
    //
    // CAL l擾
    EchoCancelCalDataCore  echoCancelCalDataCore;
    cal.Get(&echoCancelCalDataCore, CAL_DATA_ECHO_CANCEL);
    
    //
    // CFG ɒlݒ
    EchoCancelCfgData data = ECHO_CANCEL_CFG_DEFAULT;
    for(int i=0; i<8; i++){
        data.rsv[i]      = echoCancelCalDataCore.param[i];
    }
    size_t size     = sizeof(EchoCancelCfgData);
    bit32 cfgKey    = GET_CFG_KEY(NN_CFG_SOUND, NN_CFG_SOUND_ECHO_CANCEL);
    
    if(SetConfig(cfgKey, &data, size).IsFailure()) return FAIL_SET_CFG;
    if(FlushConfig().IsFailure())                  return FAIL_FLUSH_CFG;
    
    return PASS;
}


}
}
