/************************************************************************

 TestWlAudiovO

 *************************************************************************/
/* dCN[h */
#ifndef TEST_WLAUDIO_H_INCLUDED
#define TEST_WLAUDIO_H_INCLUDED

#include <string.h>
#include <nn.h>
#include <nn/ac.h>
#include <nn/socket.h>
#pragma diag_suppress 1301,2530
#include <nn/uds.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include "sys.h"
#include "../seq/Config.h"
#include "../seq/TestResult.h"
#include "../seq/TestSample.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../sys/sys_TextWindow.h"
#include "../wireless/CommandUtil.h"
#include "../seq/CommCamera.h"
#include "../mic/mic_TesterRegister.h"
#include "../mic/mic_TesterCommand.h"
#include "../mic/mic_TesterCalibrator.h"
#include "../mic/mic_Lib.h"
#include "../mic/mic_Tester.h"
#include "../sound/TestSound.h"
#include "../codec/TestCodec.h"
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>

#include <nn/ac/CTR/private/ac_Internal.h>
#include <nn/ac/CTR/private/ac_InternalApi.h>
#include <nn/ac/CTR/private/ac_PrivateApi.h>
#include <nn/ac/CTR/private/ac_NetworkSetting.h>
#include <nn/mp.h>
#include <nn/nwm/CTR/nwm_ExtHwAPI.h>

//// pfBOɊւxvO}
//#pragma diag_warning 1301,2530

namespace uji{
namespace eva{
    
//void WlAudioMenu();

enum TEST_RESULT
{
    RESULT_DEFAULT  = 0,
    RESULT_OK,
    RESULT_NG
};


class TestWlAudio
{
public:
    
    // ֐Xg\\
    struct FuncMapping
    {
        u16  opcode;                  // IyR[hiR}hID̓X|XIDj
        char funcname[40];           // ֐
        const char* (TestWlAudio::*func)(const char *);  // ֐|C^
        bool PADDING[2];
    };
    
    struct DebugTxParam
    {
        u32  startPacketNum;
        u32  startPacketWait;
        u32  startPacketInterval;
        u32  dataPacketWait;
    };
    
    
    TestWlAudio():  m_CommWindow(400/(FONT_SIZE/2), 160/FONT_SIZE, FONT_SIZE),
                    m_StatWindow(311/(FONT_SIZE/2), 239/FONT_SIZE, FONT_SIZE),  //ŏIs\Ȃ̂239ɉݒ
                    m_InfoWindow(400/(FONT_SIZE/2),  80/FONT_SIZE, FONT_SIZE),
                    gfx(uji::sys::GraphicsDrawing::GetInstance()),
                    m_isRecvStart(false),
                    m_isTestFin(false),
                    m_isBackUp(false),
                    m_MyChannel(0),
                    m_TestMode(uji::seq::pl::DEBUG),
                    m_TestResult(RESULT_DEFAULT),
                    m_AP_SSID(""),
                    m_SendCommCount(0),
                    m_RecvCommCount(0),
                    m_ActuallyRecvNum(0),
                    m_RecvPacketNum(0),
                    m_RecvPacketLength(0),
                    m_RxTimeOutSec(15),
                    //ȉ}CN֘A    vȂΏ
                    m_StableTime(0),
                    m_AmpSilent(0),
                    m_AmpImput(0),
                    m_AmpSens(0),
                    m_CurrentPgaGainF32(0.f),
                    m_CurrentPgaGainHex(0x0),
                    m_isAtherosInit(false),
                    m_isMPInit(false),
                    m_isAUDIOInit(false),
                    m_isSampling(false),
                    m_isPlaying(false),
                    m_isF2USBActive(false),
                    m_isCardPowerActive(true),
                    m_isAthTesting(false),
                    m_SamplingType(MicLib::MIC_SAMPLING_TYPE_8BIT),
                    m_SamplingRate(MicLib::MIC_SAMPLING_RATE_32730)
    {
        // NIPAhX
        m_MyIpAddress.addr = 0;
        
        // MAyуvOp̃obt@mۂ0ŏ
        m_RecvCommandBuf = new char[ MAX_COMMAND_SIZE ];
        m_SendCommandBuf = new char[ MAX_COMMAND_SIZE ];
        m_WorkBuf        = new char[ MAX_COMMAND_SIZE ];

        std::memset(m_RecvCommandBuf, 0x00, MAX_COMMAND_SIZE);
        std::memset(m_SendCommandBuf, 0x00, MAX_COMMAND_SIZE);
        std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);

        // J[hSPȈ
        m_CommSpi.Initialize(uji::seq::CommCamera::SpiType_1Mx1);
        
        {
            debTxParam.startPacketNum = 10;
            debTxParam.startPacketInterval = 10;
            debTxParam.startPacketWait = 100;
            debTxParam.dataPacketWait = 10;
        }
        
    }
    
    ~TestWlAudio()
    {
        delete[] m_RecvCommandBuf;
        delete[] m_SendCommandBuf;
        delete[] m_WorkBuf;
        
        //delete[] m_SocketBuf;
    }
    
    // {̂N郉bp[
    static void ExecuteTestWlAudio()
    {
        TestWlAudio tw;
        tw.TestWlAudioCommon();
    }
    
    //--------------------------------------------------------------------------
    // p֐
    //--------------------------------------------------------------------------
    
    const char* ATH_Init(const char* arg);
    const char* ATH_End(const char* arg);
    const char* ATH_Connect(const char* arg);
    const char* ATH_Disconnect(const char* arg);
    const char* ATH_GetLinkStatus(const char* arg);
    const char* ATH_GetChannel(const char* arg);
    const char* ATH_SetIPAddress(const char* arg);
    const char* ATH_SetNetmask(const char* arg);
    const char* ATH_SetDefaultGateway(const char* arg);
    const char* ATH_SetSSID(const char* arg);
    const char* ATH_GetIPAddress(const char* arg);
    
    const char* ATH_SetPortnum(const char* arg);
    
    const char* ATH_SetSendIPAddress(const char* arg);
    const char* ATH_SetSendPacketNum(const char* arg);
    const char* ATH_SetSendPacketLength(const char* arg);
    
    const char* ATH_StartTxTest(const char* arg);
    const char* ATH_StartRxTest(const char* arg);
    const char* ATH_SetRxTimeOut(const char* arg);
    const char* ATH_GetRSSI(const char* arg);
    
    const char* AUDIO_Init(const char* arg);
    const char* AUDIO_End(const char* arg);
    const char* AUDIO_SetSamplingType(const char* arg);
    const char* AUDIO_SetSamplingRate(const char* arg);
    const char* AUDIO_SetAmpGain(const char* arg);
    const char* AUDIO_GetAmpGain(const char* arg);
    const char* AUDIO_SetCodecMicCal(const char* arg);
    const char* AUDIO_GetCodecMicCal(const char* arg);
    const char* AUDIO_WriteMicCal(const char* arg);
    const char* AUDIO_StartMicSampling(const char* arg);
    const char* AUDIO_StopMicSampling(const char* arg);
    const char* AUDIO_GetMicAmplitude(const char* arg);
    const char* AUDIO_CheckMicStableTime(const char* arg);
    const char* AUDIO_PlaySound(const char* arg);
    const char* AUDIO_StopSound(const char* arg);
    const char* AUDIO_SetSoundVolume(const char* arg);
    const char* AUDIO_ApplyMicCal(const char* arg);
    
    const char* MP_Init(const char* arg);
    const char* MP_End(const char* arg);
    const char* MP_SetChannel(const char* arg);
    const char* MP_StartActiveScan(const char* arg);
    const char* MP_SetSSID(const char* arg);
    const char* MP_StartBeacon(const char* arg);
    const char* MP_StartPassiveScan(const char* arg);
    
    const char* CTR_GetMacAddress(const char* arg);
    const char* CTR_GetModuleID(const char* arg);
    const char* CTR_GetFirmwareType(const char* arg);
    const char* CTR_GetSerialNumber(const char* arg);
    const char* CTR_WriteSerialNumber(const char* arg);
    const char* CTR_GetFirmwareVersion(const char* arg);
    const char* CTR_GetRegion(const char* arg);
    const char* CTR_SetReset(const char* arg);
    const char* CTR_SetPowerOff(const char* arg);
    
    const char* TESTER_GetVersion(const char* arg);
    const char* TESTER_GetBuildDate(const char* arg);
    const char* TESTER_SetTime(const char* arg);
    const char* TESTER_SetTestMode(const char* arg);
    const char* TESTER_WriteStartLog(const char* arg);
    const char* TESTER_WriteOKLog(const char* arg);
    const char* TESTER_WriteNGLog(const char* arg);
    
    const char* TESTER_GetTimeCounter(const char* arg);
    
    const char* DEBUG_SetChannel(const char* arg);
    const char* DEBUG_ScanlessConnect(const char* arg);
    
    const char* DEBUG_SetStartPacketNum(const char* arg);
    const char* DEBUG_SetStartPacketWait(const char* arg);
    const char* DEBUG_SetStartPacketInterval(const char* arg);
    const char* DEBUG_SetDataPacketWait(const char* arg);
    
    bool ExecuteGetCalPgaGain(nn::drivers::cal::CTR::CodecCalDataCore* pc); //CALǂݍ
    
private:
    //--------------------------------------------------------------------------
    // ֐
    //--------------------------------------------------------------------------
    
    void TestWlAudioCommon();
    
    static void WrappingExecuteCommandThread(void* param);
    void ExecuteCommandThread();
    
    //--------------------------------------------------------------------------
    // R}hM&sp֐
    static int GetGroupIDFromCommandID(const u16 &commID);
    bool ScanCardSlot();
    bool ReceiveCommand();
    void SendCommand(const char* str);
    
    const char* ExecuteCommandFunction(const CommPack &commPack);
    const char* GetCommandName(const CommPack &commPack);
    
    // ܂
    //--------------------------------------------------------------------------
    
    //--------------------------------------------------------------------------
    // p֐
    void WlAudioUpdatePgaGain(void);
    void WlAudio_TurnOnMic(void);
    void WlAudio_TurnOffMic(void);
    // ܂
    //--------------------------------------------------------------------------
    
    void SendStartPacket(const u32 &sendCount, const u32 &sendSize);
    void SendDataFramePacket(const u32 &sendCount, const u32 &sendSize);
    void SendEndPacket();
    
    void U32ToU8Matrix(const nn::socket::InAddr &inAddr, u8 outAddr[]);
    void PrintRecvCommand(const CommPack commPack);
    void PrintSendCommand(const char* str);
    
    bool CheckRecvData(const char* RecvBuf, int &PacketLength);
    bool CreateSocket();
    bool InitSocket();
    bool DestroySocket();
    
    const char* CreateOKLogMessage(const char* arg);
    
    u8 GetRssi8(u8 rssi);
    
    
    //--------------------------------------------------------------------------
    // 萔
    //--------------------------------------------------------------------------
    
    static const u8 MAX_DOT10_SIZE   = 15;
    static const u8 MAX_SSID_SIZE    = 32;
    static const u8 MAX_COMMAND_SIZE = 128;
    static const u8 FONT_SIZE        = 12;
    static const u8 BUFFER_SIZE      = FONT_SIZE*5;
    static const u8 RSSI_CHECK_NUM   = 5;
    
    static const u8 START_DATE_SIZE  = 11;
    static const u8 START_TIME_SIZE  = 6;
    static const u8 NG_CODE_SIZE     = 20;
    static const u8 TESTER_ID_SIZE   = 24;
    
    static const s32 SOCKET_SESSION_COUNT = 4;
    static const size_t SOCKET_BUFFER_SIZE = 65536;


    //--------------------------------------------------------------------------
    // ϐ
    //--------------------------------------------------------------------------
    
    uji::sys::TextWindow m_CommWindow;
    uji::sys::TextWindow m_StatWindow;
    uji::sys::TextWindow m_InfoWindow;
    
    uji::sys::GraphicsDrawing* gfx;
    
    nn::socket::InAddr m_SetIpAddress;
    nn::socket::InAddr m_SetNetmask;
    nn::socket::InAddr m_SetDefaultGateway;
    nn::socket::InAddr m_SendIpAddress;
    nn::socket::InAddr m_MyIpAddress;
    
    nn::socket::SockAddrIn m_Server_addr;
    nn::socket::SockAddrIn m_Send_Addr;
    
    uji::seq::CommCamera  m_CommSpi;
    uji::eva::TimeCounter m_TimeCounter;
    
    
    bool  m_isEndRxTest;
    bool  m_isActiveRxThread;
    bool  m_isRecvStart;
    bool  m_isGetMacAddress;
    bool  m_isTestFin;
    bool  m_isBackUp;
    
    bit8  m_MacAddress[ nn::uds::MAC_ADDRESS_SIZE ];
    u8    m_MyChannel;
    u8    m_TestMode;
    u8    m_TestResult;
    
    
    char* m_RecvCommandBuf;
    char* m_SendCommandBuf;
    char* m_WorkBuf;
    
    u8*   m_SocketBuf;
    uptr  m_SocketBufAligned;
    
    char  m_AP_SSID[ MAX_SSID_SIZE ];
    char  m_MP_AP_SSID[ MAX_SSID_SIZE ];
    char  m_StartTestDate[ START_DATE_SIZE ];
    char  m_StartTestTime[ START_TIME_SIZE ];
    char  m_NGCode[ NG_CODE_SIZE ];
    char  m_TesterID[ TESTER_ID_SIZE ];
    
    int   m_SendCommCount;
    int   m_RecvCommCount;
    int   m_PortNum;
    int   m_SendPacketNum;
    int   m_SendPacketLength;
    int   m_SequencerID;
    int   m_MPChannel;
    
    int   m_ActuallyRecvNum;
    int   m_RecvPacketNum;
    int   m_RecvPacketLength;
    int   m_RxTimeOutSec;
    s32   m_Socket;
    
    DebugTxParam debTxParam;
    
    size_t m_WorkBufSizeForSocketLib;
    
    int   m_TestID;
    
    s64   m_StableTime;         // }CN̈莞
    u16   m_AmpSilent;          // ̐U
    u16   m_AmpImput;           // }CNO}CNւ̐ؑ֔莞̐U
    u16   m_AmpSens;            // x̌ʁi\EOo͗pj
    f32   m_CurrentPgaGainF32;  // PGA Gain ␳l(f32)
    u8    m_CurrentPgaGainHex;  // PGA Gain ␳l(hex)
    
    u16 STABLE_THRESHOLD_MIN;   // 莞Ԍ     Uŏ臒l
    u16 STABLE_THRESHOLD_MAX;   // 莞Ԍ     Uő臒l
    u64 STABLE_TIMEOUT;         // 莞Ԍ     ^CAEg
    u16 INPUT_TEST_DECIBEL;     // ͌             fVx
    u16 INPUT_TEST_THRESHOLD;   // ͌             U臒l
    u16 PGA_GAIN_AMP_TARGET;    // Lu[V   QCڕWl
    u16 PGA_GAIN_AMP_MARGIN;    // Lu[V   ڕWl̗]
    u16 SENSITIVITY_THRESH_MIN; // x         U臒lilj
    u16 SENSITIVITY_THRESH_MAX; // x         U臒lilj
    
    bool m_isAtherosInit;       //WiFi2.4GHz֘ȀtO
    bool m_isMPInit;            //MPʐM֘ȀtO
    bool m_isAUDIOInit;         //֘ȀtO
    bool m_isSampling;          //TvOԃtO
    bool m_isPlaying;           //ĐtO
    bool m_isF2USBActive;       //F2USBSPIڑłĂ邩̃tO
    bool m_isCardPowerActive;   //J[hhĂĒʓdĂ邩̃tO
    bool m_isAthTesting;        //ATH̃tO ΈFʂ̔Ɏg
    
    MicLib::SamplingType m_SamplingType;
    MicLib::SamplingRate m_SamplingRate;
    
    //--------------------------------------------------------------------------
    // gp֐
    //--------------------------------------------------------------------------
    

};

//// pfBOɊւxɖ߂
//#pragma diag_suppress 1301,2530

} // namespace eva
} // namespace uji

#endif /* TEST_WLAUDIO_H_INCLUDED */
