/****************************************************************************
    FLOWERi

    VERSION = 0.01 V[PTΉ\

****************************************************************************/

#include <nn.h>
#include <nn/gx.h>

//DFTp
#define M_PI 3.1415926535897932384626433832795
#include <math.h>

#include "../seq/TestResult.h"
#include "sys.h"
#include "sys_GetSerialNumber.h"
#include "sys_GetRegionCode.h"
#include "sys_WriteSerialNumber.h"
#include "TestWlAudio.h"
#include "../wireless/CommandUtil.h"
#include "../Application.h"
#include "../wireless/CommandTestTool.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../mcu/McuInitializer.h"
#include "../mcu/TestMcuNotification.h"
#include "../mcu/TestPowerOff.h"
#include "sys_GetBondingOption.h"

static void ShowPicture( wchar_t *file );

#include <nn/nwm.h>
#include <nn/cfg.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/cfg/CTR/cfg_ApiNor.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji;
using namespace uji::sys;
using namespace nn::ac::CTR::detail;
using namespace std;

namespace uji{
namespace eva{


namespace
{
    const TestWlAudio::FuncMapping FuncMap[] =
    {
        { 0x0101,   "ATH_Init"                  ,&TestWlAudio::ATH_Init                 },
        { 0x0102,   "ATH_End"                   ,&TestWlAudio::ATH_End                  },
        { 0x0103,   "ATH_Connect"               ,&TestWlAudio::ATH_Connect              },
        { 0x0104,   "ATH_Disconnect"            ,&TestWlAudio::ATH_Disconnect           },
        { 0x0105,   "ATH_GetLinkStatus"         ,&TestWlAudio::ATH_GetLinkStatus        },
        { 0x0106,   "ATH_SetSSID"               ,&TestWlAudio::ATH_SetSSID              },
        { 0x0107,   "ATH_GetIPAddress"          ,&TestWlAudio::ATH_GetIPAddress         },
        { 0x0108,   "ATH_GetChannel"            ,&TestWlAudio::ATH_GetChannel           },
        { 0x0110,   "ATH_SetIPAddress"          ,&TestWlAudio::ATH_SetIPAddress         },
        { 0x0111,   "ATH_SetNetmask"            ,&TestWlAudio::ATH_SetNetmask           },
        { 0x0112,   "ATH_SetPortnum"            ,&TestWlAudio::ATH_SetPortnum           },
        { 0x0113,   "ATH_SetDefaultGateway"     ,&TestWlAudio::ATH_SetDefaultGateway    },
        { 0x0114,   "ATH_SetSendIPAddress"      ,&TestWlAudio::ATH_SetSendIPAddress     },
        { 0x0115,   "ATH_SetSendPacketNum"      ,&TestWlAudio::ATH_SetSendPacketNum     },
        { 0x0116,   "ATH_SetSendPacketLength"   ,&TestWlAudio::ATH_SetSendPacketLength  },
        { 0x0117,   "ATH_StartTxTest"           ,&TestWlAudio::ATH_StartTxTest          },
        { 0x0118,   "ATH_StartRxTest"           ,&TestWlAudio::ATH_StartRxTest          },
        { 0x0119,   "ATH_SetRxTimeOut"          ,&TestWlAudio::ATH_SetRxTimeOut         },
        { 0x0120,   "ATH_GetRSSI"               ,&TestWlAudio::ATH_GetRSSI              },

        { 0x0201,   "AUDIO_Init"                ,&TestWlAudio::AUDIO_Init               },
        { 0x0202,   "AUDIO_End"                 ,&TestWlAudio::AUDIO_End                },
        { 0x0203,   "AUDIO_SetSamplingType"     ,&TestWlAudio::AUDIO_SetSamplingType    },
        { 0x0204,   "AUDIO_SetSamplingRate"     ,&TestWlAudio::AUDIO_SetSamplingRate    },
        { 0x0205,   "AUDIO_SetAmpGain"          ,&TestWlAudio::AUDIO_SetAmpGain         },
        { 0x0206,   "AUDIO_GetAmpGain"          ,&TestWlAudio::AUDIO_GetAmpGain         },
        { 0x0207,   "AUDIO_SetCodecMicCal"      ,&TestWlAudio::AUDIO_SetCodecMicCal     },
        { 0x0208,   "AUDIO_GetCodecMicCal"      ,&TestWlAudio::AUDIO_GetCodecMicCal     },
        { 0x0209,   "AUDIO_WriteMicCal"         ,&TestWlAudio::AUDIO_WriteMicCal        },
        { 0x0210,   "AUDIO_StartMicSampling"    ,&TestWlAudio::AUDIO_StartMicSampling   },
        { 0x0211,   "AUDIO_StopMicSampling"     ,&TestWlAudio::AUDIO_StopMicSampling    },
        { 0x0212,   "AUDIO_GetMicAmplitude"     ,&TestWlAudio::AUDIO_GetMicAmplitude    },
        { 0x0213,   "AUDIO_CheckMicStableTime"  ,&TestWlAudio::AUDIO_CheckMicStableTime },
        { 0x0214,   "AUDIO_PlaySound"           ,&TestWlAudio::AUDIO_PlaySound          },
        { 0x0215,   "AUDIO_StopSound"           ,&TestWlAudio::AUDIO_StopSound          },
        { 0x0216,   "AUDIO_SetSoundVolume"      ,&TestWlAudio::AUDIO_SetSoundVolume     },
        { 0x0217,   "AUDIO_ApplyMicCal"         ,&TestWlAudio::AUDIO_ApplyMicCal        },

        { 0x0301,   "MP_Init"                   ,&TestWlAudio::MP_Init                  },
        { 0x0302,   "MP_End"                    ,&TestWlAudio::MP_End                   },
        { 0x0303,   "MP_SetChannel"             ,&TestWlAudio::MP_SetChannel            },
        { 0x0304,   "MP_SetSSID"                ,&TestWlAudio::MP_SetSSID               },
        { 0x0305,   "MP_StartActiveScan"        ,&TestWlAudio::MP_StartActiveScan       },
        { 0x0310,   "MP_StartBeacon"            ,&TestWlAudio::MP_StartBeacon           },
        { 0x0311,   "MP_StartPassiveScan"       ,&TestWlAudio::MP_StartPassiveScan      },

        { 0x0801,   "CTR_GetMacAddress"         ,&TestWlAudio::CTR_GetMacAddress        },
        { 0x0802,   "CTR_GetModuleID"           ,&TestWlAudio::CTR_GetModuleID          },
        { 0x0803,   "CTR_GetFirmwareType"       ,&TestWlAudio::CTR_GetFirmwareType      },
        { 0x0804,   "CTR_GetFirmwareVersion"    ,&TestWlAudio::CTR_GetFirmwareVersion   },
        { 0x0805,   "CTR_GetRegion"             ,&TestWlAudio::CTR_GetRegion            },
        { 0x0806,   "CTR_GetSerialNumber"       ,&TestWlAudio::CTR_GetSerialNumber      },
        { 0x0807,   "CTR_WriteSerialNumber"     ,&TestWlAudio::CTR_WriteSerialNumber    },
        { 0x0813,   "CTR_SetReset"              ,&TestWlAudio::CTR_SetReset             },
        { 0x0814,   "CTR_SetPowerOff"           ,&TestWlAudio::CTR_SetPowerOff          },

        { 0x0901,   "TESTER_GetVersion"         ,&TestWlAudio::TESTER_GetVersion        },
        { 0x0902,   "TESTER_GetBuildDate"       ,&TestWlAudio::TESTER_GetBuildDate      },
        { 0x0903,   "TESTER_SetTime"            ,&TestWlAudio::TESTER_SetTime           },
        { 0x0904,   "TESTER_SetTestMode"        ,&TestWlAudio::TESTER_SetTestMode       },
        { 0x0905,   "TESTER_WriteStartLog"      ,&TestWlAudio::TESTER_WriteStartLog     },
        { 0x0906,   "TESTER_WriteOKLog"         ,&TestWlAudio::TESTER_WriteOKLog        },
        { 0x0907,   "TESTER_WriteNGLog"         ,&TestWlAudio::TESTER_WriteNGLog        },
        { 0x0908,   "TESTER_GetTimeCounter"     ,&TestWlAudio::TESTER_GetTimeCounter    },

        //{ 0x1000,   "DEBUG_SetChannel"          ,&TestWlAudio::DEBUG_SetChannel        },
        //{ 0x1001,   "DEBUG_ScanlessConnect"     ,&TestWlAudio::DEBUG_ScanlessConnect   },
        { 0x1001,   "DEBUG_SetStartPacketNum"       ,&TestWlAudio::DEBUG_SetStartPacketNum          },
        { 0x1002,   "DEBUG_SetStartPacketWait"      ,&TestWlAudio::DEBUG_SetStartPacketWait         },
        { 0x1003,   "DEBUG_SetStartPacketInterval"  ,&TestWlAudio::DEBUG_SetStartPacketInterval     },
        { 0x1004,   "DEBUG_SetDataPacketWait"       ,&TestWlAudio::DEBUG_SetDataPacketWait          },
    };

    static MicLib*          pMicLib;          //}CNCu

}

//------------------------------------------------------------------------------
// {
//------------------------------------------------------------------------------
#if 1
void TestWlAudio::TestWlAudioCommon()
{
    //MACAhX̎擾
    uji::sys::GetMacAddress(m_MacAddress);

    //XCb`OFFȂȂONɂĂĂʏođ҂
    CommandUtil::CheckWifiMode();

    //SPIʐMpXbh
    nn::os::Thread execCommThread;
    execCommThread.StartUsingAutoStack(WrappingExecuteCommandThread, this, 8192, nn::os::DEFAULT_THREAD_PRIORITY - 1);

    //EBhE}l[W
    uji::sys::WindowManager windowManager;

    //EBhE^Cgݒ
    //CommWindow㕔ɂWUPƓ悤Ƀ^Cgo܂
    {
        char title[uji::sys::Window::TITLE_LEN_MAX];
        
        std::sprintf(title, "Wireless&Audio Tester Ver:%s  (%s)", UJI_APPVER_WL_AUDIO, VERSION_DATE);
        m_CommWindow.SetTitle(title);
    }
    m_StatWindow.SetTitle("TestWlAudio&Audio Status");
    m_InfoWindow.SetTitle("Test Info");

    //EBhE쐻
    windowManager.CreateWindow(&m_CommWindow, NN_GX_DISPLAY0, 0, 0);
    windowManager.CreateWindow(&m_StatWindow, NN_GX_DISPLAY1, 2, 0);    //ԂEɕU邽XW2
    windowManager.CreateWindow(&m_InfoWindow, NN_GX_DISPLAY0, 0, 160);

    //TimeCounter̊ԂZbg
    m_TimeCounter.InitTime();

    while(true)
    {
        //L[
        Pad().UpdatePad();
        //L{R{STARTŌIăj[ɔ
        if(Pad().IsButtonPress(Pad::BUTTON_L) && Pad().IsButtonPress(Pad::BUTTON_R) && Pad().IsButtonPress(Pad::BUTTON_START))
        {
            m_isTestFin = true;
        }
        if(m_isTestFin)  // R}heXgIł悤ɔ蕔𕪂܂B
        {
            m_StatWindow.Printf("Test is finished.\n");
            break;
        }
#ifndef EVA_COMPOSITE
        //ȉ2̑̓C|[gsɖ\ƕsւȂ̂ŏĂ
        //{AŖ{̃Zbg
        if(Pad().IsButtonPress(Pad::BUTTON_DOWN) && Pad().IsButtonPress(Pad::BUTTON_A))
        {
            uji::eva::mcu::EvaReset();
        }
        
        //{BŖ{̓dOFF
        if(Pad().IsButtonPress(Pad::BUTTON_DOWN) && Pad().IsButtonPress(Pad::BUTTON_B))
        {
            uji::eva::mcu::EvaPowerOff();
        }
#endif
        //L+RŃEBhESPIʐMp̕ϐNA
        if(Pad().IsButtonPress(Pad::BUTTON_L) && Pad().IsButtonPress(Pad::BUTTON_R))
        {
            m_CommWindow.Printf("\f");
            m_StatWindow.Printf("\f");
            m_SendCommCount = 0;
            m_RecvCommCount = 0;
            m_RecvPacketNum = 0;
            m_RecvPacketLength = 0;
            m_ActuallyRecvNum = 0;
        }
        
        //ʕ\mFpA{^ŗΈFʂ𔲂
        if(Pad().IsButtonPress(Pad::BUTTON_A))
        {
            m_isAthTesting = false;
        }
        
        if(m_isF2USBActive && !m_isAtherosInit)
        {
            m_InfoWindow.Printf("\f");
            m_InfoWindow.Printf("MacAddress = %02X:%02X:%02X:%02X:%02X:%02X   ",
                                m_MacAddress[0], m_MacAddress[1], m_MacAddress[2],
                                m_MacAddress[3], m_MacAddress[4], m_MacAddress[5]);
            m_InfoWindow.Printf("SSID = %s\n", m_AP_SSID);
            m_InfoWindow.Printf("TimeCount  = %s         ",
                                CommandUtil::ConvertStringFromTimeSpan(m_TimeCounter.GetTimeSpan()));
            
            m_InfoWindow.Printf("IP Address = %s\n",                  nn::socket::InetNtoA(m_MyIpAddress));
            m_InfoWindow.Printf("Channel = %2d                     ", m_MyChannel);
            m_InfoWindow.Printf("StartPacketNum = %03d\n",            m_RecvPacketNum);
            m_InfoWindow.Printf("StartPacketLength = %03d          ", m_RecvPacketLength);
            m_InfoWindow.Printf("RecvDataFrame = %d\n",               m_ActuallyRecvNum);
            
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->Clear();
            windowManager.Update();
            windowManager.DrawDisplay0();
            gfx->m_DrawFramework->SwapBuffers();
            
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
            gfx->m_DrawFramework->Clear();
            windowManager.Update();
            windowManager.DrawDisplay1();
            gfx->m_DrawFramework->SwapBuffers();
        }
        else if(!m_isCardPowerActive)
        {
            //BGNAJ[ݒ肷
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 1.0f, 0.0f, 0.0f, 1.0f );
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 1.0f, 0.0f, 0.0f, 1.0f );
            
            //ʃNA
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->Clear();
            gfx->m_DrawFramework->SwapBuffers();
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
            gfx->m_DrawFramework->Clear();
            gfx->m_DrawFramework->SwapBuffers();
            
            //BGNAJ[ɖ߂
            gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
            gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
        }
        else if(m_isAtherosInit)
        {
            nw::ut::Color8 barColor;
            /* J[o[ɔĎcĂ ̃oϐ͍폜
            if(m_isAthTesting)
            {
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->Clear();
                
                // i 0x80@0x80,@0x80j
                barColor = 0x808080FF;
                gfx->SetColor( barColor );
                gfx->FillRectangle( 0, 0, 45, 240 );
                
                // Fi 0xFF,@0xFF,@0x00j
                barColor = 0xFFFF00FF;
                gfx->SetColor( barColor );
                gfx->FillRectangle( 45, 0, 45, 240 );
                
                // Fi 0x00,@0xFF,@0xFFj
                barColor = 0x00FFFFFF;
                gfx->SetColor( barColor );
                gfx->FillRectangle( 90, 0, 45, 240 );
                
                // ΁i 0x00,@0xFF,@0x00j
                barColor = 0x00FF00FF;
                gfx->SetColor( barColor );
                gfx->FillRectangle( 135, 0, 45, 240 );
                
                // i 0xFF,@0x00,@0xFFj
                barColor = 0xFF00FFFF;
                gfx->SetColor( barColor );
                gfx->FillRectangle( 180, 0, 45, 240 );
                
                // ԁi 0xFF,@0x00,@0x00j
                barColor = 0xFF0000FF;
                gfx->SetColor( barColor );
                gfx->FillRectangle( 225, 0, 45, 240 );
                
                // i 0x00,@0x00,@0xFFj
                barColor = 0x0000FFFF;
                gfx->SetColor( barColor );
                gfx->FillRectangle( 270, 0, 45, 240 );
                
                gfx->m_DrawFramework->SwapBuffers();
            }
            else*/
            {
                //BGNAJ[ݒ肷
                gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 0.0f, 1.0f, 0.0f, 1.0f );
                
                //ʂΈFŃNA
                gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
                gfx->m_DrawFramework->Clear();
                gfx->m_DrawFramework->SwapBuffers();
                
                //BGNAJ[ɖ߂
                gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
            }
            
            //ʂ͒ʏ\
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
            gfx->m_DrawFramework->Clear();
            windowManager.Update();
            windowManager.DrawDisplay1();
            gfx->m_DrawFramework->SwapBuffers();
            
        }
        else
        {
            //BGNAJ[ݒ肷
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 1.0f, 1.0f, 1.0f, 1.0f );
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 1.0f, 1.0f, 1.0f, 1.0f );
            
            //ʃNA
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->Clear();
            gfx->m_DrawFramework->SwapBuffers();
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
            gfx->m_DrawFramework->Clear();
            gfx->m_DrawFramework->SwapBuffers();
            
            //BGNAJ[ɖ߂
            gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
            gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
        }
        
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }
    
    switch(m_TestResult)
    {
        case RESULT_OK:
            ShowPicture( L"rom:/jpeg/Pass.jpg" );
        break;
        
        case RESULT_NG:
            ShowPicture( L"rom:/jpeg/Fail.jpg" );
        break;
    }
    
    execCommThread.Join();
    execCommThread.Finalize();
}

#else
void TestWlAudio::TestWlAudioCommon()
{

    NN_LOG("Test Start!\n");
    m_StatWindow.Printf("Test Start!\n");

    const char TestResArg[] = "TestArg";

    const char* TestRes = CommandUtil::CreateRSCAndResponseArgString(CommandUtil::ILLEGAL_MODE, TestResArg);

    NN_LOG("resRSC = %s\n", TestRes);

    {   // ATH_InitTest
        const char ATH_InitCommand[] = "0122010100";

        CommPack ATH_InitComm = CommandUtil::AnalysisCommand(ATH_InitCommand);

        NN_LOG("TestComm CheckSum = %04X\n ", ATH_InitComm.CheckSum);
        NN_LOG("TestComm CommID = %04X\n ", ATH_InitComm.CommID);
        NN_LOG("TestComm ArgNum = %02X\n", ATH_InitComm.ArgNum);
        NN_LOG("TestComm Arg = %s\n", ATH_InitComm.Arg);

        NN_LOG("Response = %s\n", CommandUtil::CreateResponseString(ATH_InitComm, TestRes));

        NN_LOG("Response = %s\n", ExecuteCommandFunction(ATH_InitComm));
    }

    {   // ATH_SetSSID
        CommPack ATH_SetSSIDComm = CommandUtil::AnalysisCommand("03D5010609PE-WLTEST");
        NN_LOG("Response = %s\n", ExecuteCommandFunction(ATH_SetSSIDComm));
    }

    {   // ATH_SetIPAddressTest
        CommPack ATH_SetIPAddressComm = CommandUtil::AnalysisCommand("039101100F192.168.11.2");
        NN_LOG("Response = %s\n", ExecuteCommandFunction(ATH_SetIPAddressComm));
    }

    {   //ATH_ConnectTest
        CommPack ATH_ConnectComm = CommandUtil::AnalysisCommand("0124010300");
        NN_LOG("Response = %s\n", ExecuteCommandFunction(ATH_ConnectComm));
    }

    {   // ATH_SetPortnum
        CommPack ATH_SetPortnumComm = CommandUtil::AnalysisCommand("01D10112034D2");
        NN_LOG("Response = %s\n", ExecuteCommandFunction(ATH_SetPortnumComm));
    }

    {   // ATH_CreateSocket
        CommPack ATH_CreateSocketComm = CommandUtil::AnalysisCommand("0124012100");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction(ATH_CreateSocketComm));
    }

    {   // ATH_SetSendIPAddress
        CommPack ATH_SetSendIPAddressComm = CommandUtil::AnalysisCommand("039201140C192.168.11.2");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction(ATH_SetSendIPAddressComm));
    }
    {   // ATH_SetSendPacketNum
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("01CB01150300A");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction(ATH_TestComm));
    }
    {   // ATH_SetSendPacketLength
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("01CC01160300A");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction(ATH_TestComm));
    }

    {   // ATH_StartTxTest
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("0129011700");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction(ATH_TestComm));
    }

    {   // ATH_StartRxTest
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("012A011800");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction(ATH_TestComm));
    }

    {
        const int MAX_RES_SIZE = 10;
        while(true)
        {
            CommPack ATH_TestComm = CommandUtil::AnalysisCommand("012B011900");
            char ResTest[ MAX_RES_SIZE ] = "";
            const char* pRes = ExecuteCommandFunction(ATH_TestComm);
            std::memcpy(ResTest, pRes, MAX_RES_SIZE);
            if(CommandUtil::ConvertNumFromString(ResTest, 2) == CommandUtil::SUCCESS)
            {
                NN_LOG("Response = %s\n", ResTest);
                break;
            }
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1000));
        }
    }

    {   // ATH_StartRxTest
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("012A011800");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction(ATH_TestComm));
    }

    {
        const int MAX_RES_SIZE = 10;
        while(true)
        {
            CommPack ATH_TestComm = CommandUtil::AnalysisCommand("012B011900");
            char ResTest[ MAX_RES_SIZE ] = "";
            const char* pRes = ExecuteCommandFunction(ATH_TestComm);
            std::memcpy(ResTest, pRes, MAX_RES_SIZE);
            if(CommandUtil::ConvertNumFromString(ResTest, 2) == CommandUtil::SUCCESS)
            {
                NN_LOG("Response = %s\n", ResTest);
                break;
            }
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1000));
        }
    }


    {   //ATH_DestroySocket
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("0125012200");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction(ATH_TestComm));
    }

    {   // ATH_Disconnect
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("0125010400");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction(ATH_TestComm));
    }

    {   // ATH_End
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("0123010200");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction(ATH_TestComm));
    }
}
#endif

//------------------------------------------------------------------------------
// ɓdāAJ[h̑}Ԃ𒲍B
//------------------------------------------------------------------------------
bool TestWlAudio::ScanCardSlot()
{
    u8 PowerState, CardState;
    
    //dĂ݂
    nn::fs::CardSlotPowerOn(&PowerState);
    
    //Jڒ߂
    do
    {
        nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
    }while(CardState == 0x0C);
    
    //Jڌ̏ԂmF
    nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
    if(!CardState) return false;
    else if(CardState == 0x04)
    {
        nn::fs::CardSlotPowerOff(&PowerState);
        
        return false;
    }
    else if(CardState == 0x08) return true;
    
    //ɗ̂s
    nn::fs::CardSlotPowerOff(&PowerState);
    return false;
}

//------------------------------------------------------------------------------
// R}h̑M֐
//------------------------------------------------------------------------------
void TestWlAudio::SendCommand(const char* str)
{
    u32 outFIFOCount;

COMMAND_SEND_RETRY :  // obt@ɋ󂫂Ȃꍇ͂烊gC
    outFIFOCount = m_CommSpi.GetWriteFifoCount();

    // FIFŐ󂫂0x0FFF-0x0F38=200Byteȏ㖳ꍇ͋󂭂܂ő҂B
    if(outFIFOCount >= 0x0F38)
    {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
        goto COMMAND_SEND_RETRY;
    }

    m_CommSpi.WriteFifo(reinterpret_cast< const u8* >(str), std::strlen(str));
    m_CommWindow.SetTextColor(ATTR_COLOR_YELLOW);
    m_CommWindow.Printf("->%02x:", m_SendCommCount);
    PrintSendCommand(str);
    m_SendCommCount++;
}

//------------------------------------------------------------------------------
// f[^MBf[^FIFOɂȂꍇfalseԂ
//------------------------------------------------------------------------------
bool TestWlAudio::ReceiveCommand()
{
    u8 CardState;
    u32 inFIFOCount = 0;
    
    //J[hd̊mF
    nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
    if(!CardState || CardState == 0x0C)
    {
        //J[hdĂȂA͏ԑJڒ̏ꍇ
        m_isCardPowerActive = false;
        
        //J[hď
        while(!m_isCardPowerActive)
        {
            //J[hd̏Ԏ擾
            nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
            
            if(!CardState)  //J[hdOFF
            {
                //xdĂ݂āAXe[gǂ]Ԃ`FbN
                if(ScanCardSlot())  m_isCardPowerActive = true;
                else                m_isCardPowerActive = false;
            }
            else if(CardState == 0x04 || CardState == 0x08)
            {
                //0x08̏ꍇ͐ɒʓdA0x04ɂȂXe[g͖mFON̖͗l
                m_isCardPowerActive = true;
            }
            else if(CardState == 0x0C)
            {
                //JڒȂ̂ōă[v
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
            }
            else
            {
                //ɗXe[g͖͂H
            }
        }
    }
    else m_isCardPowerActive = true;    //̍s0x04zȌԂłȂΗvȂ͂
    
    //ɓB_ŁẢ̎MɂĂ͓dONO
    
    inFIFOCount = m_CommSpi.GetReadFifoCount();
    // R}h10(ŏR}h)Zꍇ͒Ȃ܂ő҂
    if(inFIFOCount < 10)
    {
        //F2USBFłĂ邱ƂtOɊi[Ă
        m_isF2USBActive = true;
        return false;
    }
    else if(inFIFOCount > MAX_COMMAND_SIZE)
    {
        //F2USBƂSPIʐMɈُ킪Ăꍇ
        m_isF2USBActive = false;
        return false;
    }
    
    // R}h܂ĂꍇAxԂuĂǂ݂Ȃ
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
    inFIFOCount = m_CommSpi.GetReadFifoCount();

    // ۂFifoǂݏoAeʂɕ\
    std::memset(m_RecvCommandBuf, 0x00, MAX_COMMAND_SIZE);
    m_CommSpi.ReadFifo(reinterpret_cast< u8* >(m_RecvCommandBuf), inFIFOCount);

    m_CommWindow.SetTextColor(ATTR_COLOR_WHITE);
    m_CommWindow.Printf("  %02x:", m_RecvCommCount);
    //PrintRecvCommand(m_RecvCommandBuf);

    // R}hǂݍ݃tOZbgAR}hJEg𑝂₷
    m_RecvCommCount++;
    return true;

}


//------------------------------------------------------------------------------
// o֐XbhƂċN邽߂̃bp[
//------------------------------------------------------------------------------
void TestWlAudio::WrappingExecuteCommandThread(void* param)
{
    TestWlAudio* pTW = reinterpret_cast< TestWlAudio* >(param);
    pTW->ExecuteCommandThread();
}

//------------------------------------------------------------------------------
// R}h猟NXbhB
//------------------------------------------------------------------------------
void TestWlAudio::ExecuteCommandThread()
{

    CommPack commPack;
    NN_LOG("ExecuteCommandThread\n");

    const char CHECKSUM_ERROR_COMMAND[] = "0000000000";

    while(true)
    {
        if(m_isTestFin)
        {
            break;
        }
        if(ReceiveCommand()) // R}hMmF
        {
            if(!CommandUtil::isCorrectCheckSum(m_RecvCommandBuf, std::strlen(m_RecvCommandBuf)))
            {
                NN_LOG("CheckSum Error!\n");
                m_StatWindow.Printf("%02x: Command CheckSum Error!\n", m_RecvCommCount - 1);
                m_StatWindow.Printf("%s\n", m_RecvCommandBuf);

                commPack = CommandUtil::AnalysisCommand(CHECKSUM_ERROR_COMMAND);

                const char* RSCStr = CommandUtil::CreateResponseString(commPack,
                                                  CommandUtil::CreateRSCAndResponseArgString(CommandUtil::CHECKSUM));
                SendCommand(RSCStr);
                continue;
            }

            commPack = CommandUtil::AnalysisCommand(m_RecvCommandBuf);
            PrintRecvCommand(commPack);
            const char* RSCStr = CommandUtil::CreateResponseString(commPack, ExecuteCommandFunction(commPack));
            SendCommand(RSCStr);
            if(m_TestResult) m_isTestFin = true;
        }else
        {
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMicroSeconds(1000));
        }
    }
}

//------------------------------------------------------------------------------
// R}hpPbg猟֐sAԂlԂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ExecuteCommandFunction(const CommPack &commPack)
{
    m_TestID = GetGroupIDFromCommandID(commPack.CommID);
    if(m_TestID < 0)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }
    else
    {
        return (this->*(FuncMap[ m_TestID ].func))(commPack.Arg);
    }
}

//------------------------------------------------------------------------------
// R}hpPbg猟֐Ԃ
//------------------------------------------------------------------------------
const char* TestWlAudio::GetCommandName(const CommPack &commPack)
{
    m_TestID = GetGroupIDFromCommandID(commPack.CommID);
    if(m_TestID < 0)
    {
        return "No Command";
    }
    else
    {
        return FuncMap[ m_TestID ].funcname;
    }
}

//------------------------------------------------------------------------------
// R}hpPbgCommIĎ̔ԍԂ
//------------------------------------------------------------------------------
int TestWlAudio::GetGroupIDFromCommandID(const u16 &commID)
{
    int groupID;
    u32 max_GroupID = (sizeof(FuncMap) / sizeof(FuncMap[0]));

    for(groupID = 0; groupID <= max_GroupID; groupID++)
    {
        if(commID == FuncMap[ groupID ].opcode)
        {
            return groupID;
        }
    }
    NN_LOG("Bad Return! %d\n", __LINE__);
    const int ERROR_NUMBER = -1;
    return ERROR_NUMBER;
}


//------------------------------------------------------------------------------
// ȉA֐
// Return FȂƂȂĂ̂́ARSĈ݂Ԃ
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
// Desc   F
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_Init(const char* arg)
{
    NN_UNUSED_VAR(arg)

    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);

    //ɏς̏ꍇ
    if(m_isAtherosInit)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);

    nn::Result result;

    result = nn::ac::CTR::InitializeInternal(); // nn::ac̃C^[ȉ
    if(result.IsFailure())
    {
        m_StatWindow.Printf("ac InternalInit Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    m_isAtherosInit = true;
    m_isAthTesting = true;
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FI
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_End(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);

    //ɏIς̏ꍇ
    if(!m_isAtherosInit)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);

    nn::Result result;
    // J@AobNAbvɎsꍇ
    // lbg[Nݒ
    if(uji::sys::GetBondingOption() || !m_isBackUp)
    {
        nn::ac::CTR::RemoveNetworkSetting(0);
        nn::ac::CTR::FlushNetworkSetting();
    }

    result = nn::ac::FinalizeInternal();
    if(result.IsFailure())
    {
        m_StatWindow.Printf("ac InternalFinalize Error\n");
        m_StatWindow.Printf("Level   = %d\n", result.GetLevel());
        m_StatWindow.Printf("Summary = %d\n", result.GetSummary());
        m_StatWindow.Printf("Module  = %d\n", result.GetModule());  //acԂĂȂ
        m_StatWindow.Printf("Desc    = %d\n", result.GetDescription());
        
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    m_isAtherosInit = false;
    m_isAthTesting  = false;

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);

}

//------------------------------------------------------------------------------
// Desc   FڑĂ`l̎擾
// Arg    FȂ
// Return F`l
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_GetChannel(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);


    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
    std::sprintf(m_WorkBuf, "%02d", m_MyChannel);
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);
}

//------------------------------------------------------------------------------
// Desc   FCTR{̂IPAhXݒ
// Arg    FZbgIPAhX
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_SetIPAddress(const char* arg)
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);

    if(!nn::socket::InetAtoN(arg, &m_SetIpAddress))
    {
        m_StatWindow.Printf("SetIPAddress Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }
    m_StatWindow.Printf("Set IP Address = %s\n", nn::socket::InetNtoA(m_SetIpAddress));
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FCTR{̂̃lbg}XNݒ
// Arg    FZbglbg}XN
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_SetNetmask(const char* arg)
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);

    if(!nn::socket::InetAtoN(arg, &m_SetNetmask))
    {
        m_StatWindow.Printf("SetNetMask Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }
    NN_LOG("Set Netmask = %s\n", nn::socket::InetNtoA(m_SetNetmask));
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FCTR{̂̃ftHgQ[gEFCݒ
// Arg    FZbgftHgQ[gEFC
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_SetDefaultGateway(const char* arg)
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);

    if(!nn::socket::InetAtoN(arg, &m_SetDefaultGateway))
    {
        m_StatWindow.Printf("SetDefaultGateway Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }
    NN_LOG("Set m_SetDefaultGateway = %s\n", nn::socket::InetNtoA(m_SetDefaultGateway));
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FAPSSIDݒ
// Arg    FZbgSSID
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_SetSSID(const char* arg)
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);
    std::memset(m_AP_SSID, 0x00, MAX_SSID_SIZE);
    std::strcpy(m_AP_SSID, arg);
    NN_LOG("Set SSID = %s\n", m_AP_SSID);

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FCTRIPAhX擾
// Arg    FȂ
// Return FCTRIPAhX
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_GetIPAddress(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, nn::socket::InetNtoA(m_MyIpAddress));
}
//------------------------------------------------------------------------------
// Desc   FAPւ̐ڑ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_Connect(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);


    nn::Result result;

    nn::ac::CTR::NetworkSetting backupSetting;
    std::memset(&backupSetting, 0x00, sizeof(backupSetting));
    
    // LINE[hȊȌꍇ͖{̂̃lbg[Nݒ̃obNAbvs
    if(uji::seq::pl::LINE != m_TestMode && uji::seq::pl::SUBMIT != m_TestMode) 
    {
        result = nn::ac::CTR::LoadNetworkSetting(0, backupSetting);
        if(result.IsFailure())
        {
            m_StatWindow.Printf("No Data\n");
            nn::dbg::PrintResult(result);
        }else
        {
            if(0 != std::strcmp(m_AP_SSID, reinterpret_cast<char*>(backupSetting.wireless.essidSecurity.ssid)))
            {
                m_StatWindow.Printf("Backup SSID = %s\n", backupSetting.wireless.essidSecurity.ssid);
                m_isBackUp = true;
            }else
            {
                m_StatWindow.Printf("Test SSID\n");
            }
        }
    }
    
    nn::ac::CTR::NetworkSetting networkSetting;
    {
        {
            networkSetting.wireless.enable = true;
            networkSetting.wireless.editableEssidSecurity = true;
            {
                std::memcpy(networkSetting.wireless.essidSecurity.ssid, m_AP_SSID, std::strlen(m_AP_SSID));
                networkSetting.wireless.essidSecurity.ssidLength    = std::strlen(m_AP_SSID);
                networkSetting.wireless.essidSecurity.securityMode  = nn::ac::OPEN;
            }
            {
                networkSetting.wireless.multiSsid.enable = false;
            }
        }
        {
            networkSetting.ip.enableDHCP        = false;
            networkSetting.ip.autoDNSSetting    = true;
            U32ToU8Matrix(m_SetIpAddress, networkSetting.ip.ipAddress);
            U32ToU8Matrix(m_SetDefaultGateway, networkSetting.ip.defaultGateway);
            U32ToU8Matrix(m_SetNetmask, networkSetting.ip.netmask);
            networkSetting.other.mtu = 1400;
        }
    }
    result = nn::ac::CTR::UpdateNetworkSetting(0, networkSetting);
    if(result.IsFailure())
    {
        m_StatWindow.Printf("Update Error\n");
        nn::dbg::PrintResult(result);
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }
    

    nn::ac::Config config;
    nn::ac::CreateDefaultConfig(&config);
    nn::ac::CTR::SetNetworkArea(&config, nn::ac::NETWORK_AREA_LAN);

    result = nn::ac::ConnectWithoutEula(config);
    if(result.IsFailure())
    {
        m_StatWindow.Printf("Connect Failed.\n");
        m_StatWindow.Printf("Level   = %d\n", result.GetLevel());
        m_StatWindow.Printf("Summary = %d\n", result.GetSummary());
        m_StatWindow.Printf("Module  = %d\n", result.GetModule());  //acԂĂȂ
        m_StatWindow.Printf("Desc    = %d\n", result.GetDescription());
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x99);
    }
        
    NN_LOG("Call ConnectWithoutEula\n");
    
    // LINE[hȊOŁA
    if(m_isBackUp && uji::seq::pl::LINE != m_TestMode && uji::seq::pl::SUBMIT != m_TestMode)
    {
        result = nn::ac::CTR::UpdateNetworkSetting(0, backupSetting);
        if(result.IsFailure())
        {
            nn::dbg::PrintResult(result);
            m_StatWindow.Printf("Restore Error\n");
        }
        
        result = nn::ac::CTR::FlushNetworkSetting();
        if(result.IsFailure())
        {
            nn::dbg::PrintResult(result);
            m_StatWindow.Printf("Flush Error\n");
        }
    }
    

    NN_LOG("Connect Success!\n");


    if(!CreateSocket())
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    }
    // IPȂꍇAڑ̂sĂƂ݂ȂAؒfsB
    if(m_MyIpAddress.addr == 0)
    {
        nn::ac::Close();
        m_StatWindow.Printf("Can't Get IP Addr\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x02);
    }

    {   // ڑĂ`l̎擾
        nn::ac::AccessPoint AP;
        nn::ac::GetConnectingAccessPoint(&AP);

        m_MyChannel = AP.channel;
        NN_LOG("Channel = %d\n", m_MyChannel);
    }

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);

}
//------------------------------------------------------------------------------
// Desc   FAP̐ؒf
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_Disconnect(const char* arg)
{
    NN_UNUSED_VAR(arg)

    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);

    DestroySocket();

    nn::Result result;
    result = nn::ac::Close();
    if(result.IsFailure())
    {
        nn::dbg::PrintResult(result);
        m_StatWindow.Printf("ac Close Error\n");
        m_StatWindow.Printf("Level   = %d\n", result.GetLevel());
        m_StatWindow.Printf("Summary = %d\n", result.GetSummary());
        m_StatWindow.Printf("Module  = %d\n", result.GetModule());  //acԂĂȂ
        m_StatWindow.Printf("Desc    = %d\n", result.GetDescription());
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }
    m_MyIpAddress.addr = 0; //IPAhXƃ`l0(ڑĂȂ\)
    m_MyChannel        = 0;
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FCTR̐ڑԊmF
// Arg    FȂ
// Return FCTR̐ڑ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_GetLinkStatus(const char* arg)
{
    NN_UNUSED_VAR(arg)

    nn::Result result;
    nn::ac::Status status;
    result = nn::ac::GetStatus(&status);
    if(result.IsFailure())
    {
        m_StatWindow.Printf("ac GetStatus Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }
    
    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
    std::sprintf(m_WorkBuf, "%03X", status);
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);
}

//------------------------------------------------------------------------------
// Desc   FSocket̃|[gݒ
// Arg    Fݒ肷|[g
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_SetPortnum(const char* arg)
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);

    m_PortNum = CommandUtil::ConvertNumFromString(arg, std::strlen(arg));
    NN_LOG("Port = %d\n", m_PortNum);

    if(m_PortNum == CommandUtil::CONVERT_ERROR_NUM)
    {
        m_StatWindow.Printf("Socket PortNumber Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   FTxeXgɂđMIPAhXw
// Arg    Fݒ肷IPAhX
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_SetSendIPAddress(const char* arg)
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);

    if(!nn::socket::InetAtoN(arg, &m_SendIpAddress))
    {
        m_StatWindow.Printf("Set Send IPAddress Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }
    NN_LOG("Send IP Address = %s\n", nn::socket::InetNtoA(m_SendIpAddress));
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FTxeXgɂđMpPbg̎w
// Arg    FMpPbg
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_SetSendPacketNum(const char* arg)
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);


    m_SendPacketNum = CommandUtil::ConvertNumFromString(arg, std::strlen(arg));
    NN_LOG("PacketNum = %d\n", m_SendPacketNum);

    if(m_SendPacketNum == CommandUtil::CONVERT_ERROR_NUM)
    {
        m_StatWindow.Printf("Set Packet Num Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FTxeXgɂđMpPbg̒
// Arg    FMpPbg
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_SetSendPacketLength(const char* arg)
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);


    m_SendPacketLength = CommandUtil::ConvertNumFromString(arg, std::strlen(arg));
    NN_LOG("PacketLength = %d\n", m_SendPacketLength);

    if(m_SendPacketLength == CommandUtil::CONVERT_ERROR_NUM)
    {
        m_StatWindow.Printf("Set Packet Length Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FTxeXgJn
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_StartTxTest(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);


    // pPbg̐AK͈͓ł鎖mFB
    if(m_SendPacketNum < 0 || 1024 < m_SendPacketNum)
    {
        m_StatWindow.Printf("Packet Num Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    if(m_SendPacketLength < 0 || 1024 < m_SendPacketLength)
    {
        m_StatWindow.Printf("Packet Length Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    }

    m_Socket = nn::socket::Socket(nn::socket::PF_INET, nn::socket::SOCK_DGRAM, 0);

    {
        m_Server_addr.len = sizeof(nn::socket::SockAddrIn);
        m_Server_addr.family = nn::socket::AF_INET;
        m_Server_addr.addr.addr = 0;
        m_Server_addr.port = nn::socket::HtoNs(m_PortNum);
    }

    s32 ret = nn::socket::Bind(m_Socket, &m_Server_addr);

    if(ret)
    {
        m_StatWindow.Printf("Bind Error. ret = %d\n", ret);
        if(ret == nn::socket::ENETRESET)
        {
            m_StatWindow.Printf("ENETRESET\n");
        }
        
        if(ret == nn::socket::EBADF)
        {
            m_StatWindow.Printf("EBADF\n");
        }
        
        if(ret == nn::socket::EOPNOTSUPP)
        {
            m_StatWindow.Printf("EOPNOTSUPP\n");
        }
        
        if(ret == nn::socket::EINVAL)
        {
            m_StatWindow.Printf("EINVAL\n");
        }
        
        if(ret == nn::socket::EAFNOSUPPORT)
        {
            m_StatWindow.Printf("EAFNOSUPPORT\n");
        }
        
        if(ret == nn::socket::EADDRINUSE)
        {
            m_StatWindow.Printf("EADDRINUSE\n");
        }
        
        
    }

    m_Send_Addr.len    = sizeof(nn::socket::SockAddrIn);
    m_Send_Addr.family = nn::socket::AF_INET;
    m_Send_Addr.addr   = m_SendIpAddress;
    m_Send_Addr.port   = nn::socket::HtoNs(m_PortNum);

    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(debTxParam.startPacketWait));

    // X^[gpPbg̑M
    for(int i = 0; i < debTxParam.startPacketNum; i++)
    {
        SendStartPacket(m_SendPacketNum, m_SendPacketLength);
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(debTxParam.startPacketInterval));
    }

    // STARTpPbgf[^pPbg܂ł̊Ԋu
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(debTxParam.dataPacketWait));

    SendDataFramePacket(m_SendPacketNum, m_SendPacketLength);

    // f[^pPbgENDpPbg܂ł̊Ԋu
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));

    // GhpPbg̑M
    for(int i = 0; i < 5; i++)
    {
        SendEndPacket();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));
    }

    nn::socket::Close(m_Socket);


    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   FRxeXgJn
// Arg    FȂ
// Return FM
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_StartRxTest(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);


    //m_Socket = nn::socket::Socket(nn::socket::PF_INET, nn::socket::SOCK_DGRAM, 0);
    s32 rval = 0;
    nn::Result result = nn::socket::detail::Socket(&rval, nn::socket::PF_INET, nn::socket::SOCK_DGRAM, 0);
    if(result.IsFailure())
    {
        m_StatWindow.Printf("Socket error. %X\n", result.GetPrintableBits());
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }
    else
    {
        m_Socket = rval;
        m_Server_addr.len = sizeof(nn::socket::SockAddrIn);
        m_Server_addr.family = nn::socket::AF_INET;
        m_Server_addr.addr.addr = 0;
        m_Server_addr.port = nn::socket::HtoNs(m_PortNum);
    }

    s32 ret = nn::socket::Bind(m_Socket, &m_Server_addr);

    if(ret)
    {
        m_StatWindow.Printf("Bind Error. ret = %d\n", ret);
    }


    m_RecvPacketNum    = 0;
    m_RecvPacketLength = 0;
    m_isRecvStart      = false;
    m_isEndRxTest      = false;
    m_ActuallyRecvNum  = 0;


    // Ɨp̃obt@쐬
    const int SOCKET_RECV_BUF_SIZE = 4096;
    const int CHECK_BUF_SIZE       = 10;
    char* RecvBuf  = new char[ SOCKET_RECV_BUF_SIZE ];

    std::memset(RecvBuf, 0x00, SOCKET_RECV_BUF_SIZE);

    const nn::fnd::TimeSpan RxTimeOutSpan = nn::fnd::TimeSpan::FromSeconds(m_RxTimeOutSec);
    nn::os::Tick StartRxTick = nn::os::Tick::GetSystemCurrent();

    s32 ReturnRecv;

    while(true)
    {
        if((nn::os::Tick::GetSystemCurrent() - StartRxTick).ToTimeSpan().GetMilliSeconds() > RxTimeOutSpan.GetMilliSeconds())
        {
            m_StatWindow.Printf("TimeOut Time = %d\n", m_RxTimeOutSec);
            DestroySocket();
            delete[] RecvBuf;
            std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
            std::sprintf(m_WorkBuf, "%d#%d", m_ActuallyRecvNum, m_RecvPacketNum);
            return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::TIME_OUT, m_WorkBuf);
        }
        //if(0 > nn::socket::RecvFrom(m_Socket, RecvBuf, SOCKET_RECV_BUF_SIZE, nn::socket::MSG_DONTWAIT, &m_Server_addr))
        ReturnRecv = nn::socket::RecvFrom(m_Socket, RecvBuf, SOCKET_RECV_BUF_SIZE, nn::socket::MSG_DONTWAIT, &m_Server_addr);
        //NN_LOG("Recv = %d\n", ReturnRecv);
        if(0 > ReturnRecv)
        {
            continue;
        }

        if(CommandUtil::CompareString(RecvBuf, "STA"))
        {
            m_RecvPacketNum = CommandUtil::ConvertNumFromString(&RecvBuf[5], 3);
            m_RecvPacketLength = CommandUtil::ConvertNumFromString(&RecvBuf[8], 3);
            m_isRecvStart = true;
            NN_LOG("TestStart! PacketNum = %d\n", m_RecvPacketNum);
        }
        else
        {
            if(m_isRecvStart)
            {
                if(CommandUtil::CompareString(RecvBuf, "END"))
                {
                    m_isEndRxTest = true;
                    break;
                }
                else
                {
                    if(CheckRecvData(RecvBuf, m_RecvPacketLength))
                    {
                        m_ActuallyRecvNum++;
                    }

                }
            }
        }
        std::memset(RecvBuf, 0x00, SOCKET_RECV_BUF_SIZE);
    }

    delete[] RecvBuf;

    nn::socket::Close(m_Socket);

    //if(!DestroySocket())
    //{
    //    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    //}

    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
    std::sprintf(m_WorkBuf, "%d#%d", m_ActuallyRecvNum, m_RecvPacketNum);
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);
}
//------------------------------------------------------------------------------
// Desc   FRxeXg̍ۂ̃^CAEgݒ
// Arg    F^CAEg܂ł̎(Second)
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_SetRxTimeOut(const char* arg)
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);


    m_RxTimeOutSec = CommandUtil::ConvertNumFromString(arg, std::strlen(arg));
    NN_LOG("TimeOutSec = %d\n", m_RxTimeOutSec);
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FAPRSSI̒l擾
// Arg    FȂ
// Return FRSSI̒l
//------------------------------------------------------------------------------
const char* TestWlAudio::ATH_GetRSSI(const char* arg)
{
    #if 1  // APڑRSSI擾
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);



    nn::Result result;
    nn::ac::CTR::AccessPoint AP;

    result = GetConnectingAccessPoint(&AP);
    if(result.IsFailure())
    {
        m_StatWindow.Printf("Get RSSI Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    NN_LOG("RSSI = %d\n", AP.rssi);

    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);

    std::sprintf(m_WorkBuf, "%d", AP.rssi);

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);


    #else  // A^CłRSSI擾(x)

    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);




    nn::Result result;
    const int AP_LEN = 10;
    nn::ac::CTR::AccessPoint AP[ AP_LEN ];
    nn::nwm::Ssid MySSID(m_AP_SSID);

    int RSSI_Count = 0;
    u8  FindAP = 0;

    for(int i = 0; i < RSSI_CHECK_NUM; i++)
    {
        result = ScanAccessPoint(&FindAP, AP, AP_LEN);
        if(result.IsFailure())
        {
            //NN_UTIL_PANIC_IF_FAILED(result);
            m_StatWindow.Printf("Scan AccessPoint Error\n");
            return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
        }

        for(int j = 0; j < FindAP; j++)
        {
            if(AP[j].ssid == MySSID)
            {
                NN_LOG("Find = %d RSSI = %d, j = %d\n", FindAP, AP[j].rssi, j);
                RSSI_Count += AP[j].rssi;
            }
        }
        std::memset(AP, 0x00, sizeof(AP));
    }

    NN_LOG("RSSI = %d\n", RSSI_Count / RSSI_CHECK_NUM);

    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
    std::sprintf(m_WorkBuf, "%d", RSSI_Count / RSSI_CHECK_NUM);

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);
    #endif

}

//------------------------------------------------------------------------------
// Desc   F0201 I[fBI֘Ȁ
// Arg    F1 : }CNTvO^Cv(10i1) m_SamplingType
//              =>0:8bit 1:16bit 2:signed8bit 3:signed16bit
//          2 : }CNTvO[g(10i1) m_SamplingRate
//              =>0:32730Hz 1:16360Hz 2:10910Hz 3:8180Hz
//          3 : ɔf}CNAvQC(10i1-2)
//              =>L͈0`119ACTR̃ftHgNTR[h̍őQCł0x43(67 = 44dB)
//              =>Z0=10.5dBA119=70.0dBA120iK0.5dBXebvZo
// Return FȂ
//------------------------------------------------------------------------------
static const char *SamplingTypeList[]={      //TvO^Cv
    " 8bit",
    "16bit",
    "signed  8bit",
    "signed 16bit",
};

static const char *SamplingRateList[]={      //TvO[g
    "32.73kHz",
    "16.36kHz",
    "10.91kHz",
    " 8.18kHz",
};

const char* TestWlAudio::AUDIO_Init(const char* arg)
{
    int ret;
    char str[3];                        //őŃAvQC2
    const int AMP_GAIN_MAX = 119;       //ݒłől
    
    //ɏςłȂ΍s
    if(!m_isAUDIOInit)
    {
        //}CN
        pMicLib = MicLib::GetInstance();
        //}CNdI
        WlAudio_TurnOnMic();
        
        m_StatWindow.Printf("Start AUDIO Initialize.\n");
    }
    else
    {
        m_StatWindow.Printf("Start AUDIO Re-Initialize.\n");
        
        //}CNd
        pMicLib->TurnOnMic();
    }
    
    //R}h}CNTvO^Cv𒊏o
    std::memset(str, 0x00, sizeof(str));
    std::memcpy(str, arg, 1);
    ret = CommandUtil::ConvertNumFromString(str, 1);
    if(ret < 0 || ret > pMicLib->MIC_SAMPLING_TYPE_SUPREMUM)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);    //s
    //TvO^Cv𔽉f
    m_SamplingType = static_cast<MicLib::SamplingType>(ret);
    pMicLib->PresetSamplingType(m_SamplingType);
    
    m_StatWindow.Printf("SamplingType : %s\n", SamplingTypeList[ret]);
    
    //R}h}CNTvO[g𒊏o
    std::memset(str, 0x00, sizeof(str));
    std::memcpy(str, &arg[2], 1);
    ret = CommandUtil::ConvertNumFromString(str, 1);
    if(ret < 0 || ret > pMicLib->MIC_SAMPLING_RATE_SUPREMUM)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);    //s
    //TvO[g𔽉f
    m_SamplingRate = static_cast<MicLib::SamplingRate>(ret);
    pMicLib->PresetSamplingRate(m_SamplingRate);
    
    m_StatWindow.Printf("SamplingRate : %s\n", SamplingRateList[ret]);
    
    //R}hO}CNAvQC𒊏o
    std::memset(str, 0x00, sizeof(str));
    std::memcpy(str, &arg[4], 2);
    ret = CommandUtil::ConvertNumFromString(str, 2);
    if(ret < 0 || ret > AMP_GAIN_MAX)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x02);    //s͔͈͊O
    //AvQC𔽉f
    nn::mic::SetAmpGain(static_cast<u8>(ret));
    
    m_StatWindow.Printf("Amp Gain     : %d\n", static_cast<u8>(ret));
    
    //CAL␳lPGA Gain Calibrationɔf
    WlAudioUpdatePgaGain();
    
    //}CNNvItɂ
    nn::mic::SetClamp(false);
    
    m_isAUDIOInit = true;
    
    m_StatWindow.Printf("Finish AUDIO Initialize.\n\n");
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   F0202 I[fBI֘ÃVbg_E mioŃnÔߏԈ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_End(const char* arg)
{
    NN_UNUSED_VAR(arg)
#if 0
    //ɏIς̏ꍇ
    if(!m_isAUDIOInit)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
    
    //}CNdIt
    WlAudio_TurnOffMic();
    
    m_isAUDIOInit = false;
#endif
    
    m_StatWindow.Printf("AUDIO Shutdown.\n");
    
    //}CNd؂Ă
    pMicLib->TurnOffMic();
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   F0203 }CÑTvO^Cvݒ
// Arg    FTvO^Cv
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_SetSamplingType(const char* arg)
{
    m_SamplingType = static_cast<MicLib::SamplingType>(CommandUtil::ConvertNumFromString(arg, 1));
    
    m_StatWindow.Printf("Set SamplingType : %s\n\n", SamplingTypeList[static_cast<int>(m_SamplingType)]);
    
    if(m_SamplingType < 0 || m_SamplingType > pMicLib->MIC_SAMPLING_TYPE_SUPREMUM)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);      //s
    
    //TvOłΒ~
    if(m_isSampling)
    {
        pMicLib->StopSampling();
        m_isSampling = false;
    }
    
    pMicLib->PresetSamplingType(m_SamplingType);
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   F0204 }CÑTvO[gݒ
// Arg    FTvO[g
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_SetSamplingRate(const char* arg)
{
    m_SamplingRate = static_cast<MicLib::SamplingRate>(CommandUtil::ConvertNumFromString(arg, 1));
    
    m_StatWindow.Printf("Set SamplingRate : %s\n\n", SamplingRateList[static_cast<int>(m_SamplingRate)]);
    
    if(m_SamplingRate < 0 || m_SamplingRate > pMicLib->MIC_SAMPLING_RATE_SUPREMUM)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);      //s
    
    //TvOłΒ~
    if(m_isSampling)
    {
        pMicLib->StopSampling();
        m_isSampling = false;
    }
    
    pMicLib->PresetSamplingRate(m_SamplingRate);
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   F0205 }CNAvQC̐ݒ
// Arg    FAvQC u8
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_SetAmpGain(const char* arg)
{
    u8 pga_gain_Hex;
    
    //pga_gain_HexPC󂯎␳l
    pga_gain_Hex = static_cast<u8>(CommandUtil::ConvertNumFromString(arg, std::strlen(arg)));
    
    m_StatWindow.Printf("Set AmpGain : %d\n\n", pga_gain_Hex);
    
    //CodecPGALu[Vlݒ
    nn::mic::SetAmpGain(pga_gain_Hex);
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   F0206 }CNAvQC̎擾
// Arg    FȂ
// Return FAvQC u8
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_GetAmpGain(const char* arg)
{
    NN_UNUSED_VAR(arg)
    
    u8 pga_gain_Hex;
    
    //CodecPGALu[Vl擾
    nn::mic::GetAmpGain(&pga_gain_Hex);
    
    m_StatWindow.Printf("Get AmpGain : %d\n\n", pga_gain_Hex);
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, pga_gain_Hex);
}

//------------------------------------------------------------------------------
// Desc   F0207 }CNQC␳lCodecWX^ɐݒ(p̈ꎞIȔf)
// Arg    FPGALu[Vl(u8 => 16i2)
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_SetCodecMicCal(const char* arg)
{
    NN_UNUSED_VAR(arg)
    
    u8 pga_cal_Hex;
    codec::TestCodec* pTestCodec = new codec::TestCodec;
    
    //pga_cal_HexPC󂯎␳l
    pga_cal_Hex = static_cast<u8>(CommandUtil::ConvertNumFromString(arg, std::strlen(arg)));
    
    m_StatWindow.Printf("Set CodecMicCal : %d\n", pga_cal_Hex);
    
    //StopSampling
    if(m_isSampling)
    {
        pMicLib->StopSampling();
        m_isSampling = false;
    }
    
    //CodecPGALu[Vlݒ
    pTestCodec->TestWriteMultiEx_SPI2_MicPgaGainCalibration(&pga_cal_Hex);
    
    delete pTestCodec;
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   F0208 }CNQC␳lCodecWX^擾
// Arg    FȂ
// Return F}CNQC␳l16i1-2
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_GetCodecMicCal(const char* arg)
{
    NN_UNUSED_VAR(arg)
    
    u8 pga_cal_Hex;
    codec::TestCodec* pTestCodec = new codec::TestCodec;
    
    pTestCodec->TestReadMultiEx_SPI2_MicPgaGainCalibration();
    
    pga_cal_Hex = pTestCodec->m_MicPgaGainCalibration_SPI2;
    
    delete pTestCodec;
    
    m_StatWindow.Printf("Set CodecMicCal : %d\n", pga_cal_Hex);
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, pga_cal_Hex);
}

//------------------------------------------------------------------------------
// Desc   F0209 }CNQC␳lCalɔf
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_WriteMicCal(const char* arg)
{
    using namespace nn::drivers::cal::CTR;
    
    //PC󂯎}CNQC␳l
    u8 pga_cal_Hex = static_cast<u8>(CommandUtil::ConvertNumFromString(arg, std::strlen(arg)));
    
    //[h LINE[hłȂ΃}CNQCCalɏȂ
    if(m_TestMode != uji::seq::pl::LINE && uji::seq::pl::SUBMIT != m_TestMode)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    
    Calibration cal;
    nn::drivers::cal::CTR::CodecCalDataCore codecCalDataCore;
    
    //CAL
    cal.Initialize();
    
    //l̎擾
    if(!cal.Get(&codecCalDataCore, CAL_DATA_CODEC))
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    
    codecCalDataCore.micGainCalibrateParam = pga_cal_Hex;
    
    //Call̐ݒ
    if(!cal.Set(&codecCalDataCore, CAL_DATA_CODEC))
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x02);
    
    if(!cal.Flush())
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x03);
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   F0210 }CÑTvOJn
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_StartMicSampling(const char* arg)
{
    NN_UNUSED_VAR(arg)
    
    //AUDIONG
    if(!m_isAUDIOInit)
        CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    
    //TvOłȂStartSampling
    //XLbvœdĂяo邩Ȃ̂ŃTvOĂяołNGɂȂ
    if(!m_isSampling)
    {
        pMicLib->StartSampling();
        m_isSampling = true;
        
        //obt@TCY̔(1b)1̃f[^i[ōsB1̊i[{܂őҋ@
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1000));
    }
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   F0211 }CÑTvO~
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_StopMicSampling(const char* arg)
{
    NN_UNUSED_VAR(arg)
    
    //AUDIONG
    if(!m_isAUDIOInit)
        CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    
    //TvOłStopSampling
    if(m_isSampling)
    {
        pMicLib->StopSampling();
        m_isSampling = false;
    }
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   F0212 TvOʂ̑M
// Arg    FU擾邽߂Ɏ擾|Cg u16
//          Ave,Max,Mino߂Ɏ擾 u16
// Return FTvO
//          Uϒl
//          Uől
//          Uŏl
//          ItZbgϓl  STvOʂẴItZbgϓ
//------------------------------------------------------------------------------
double dft_j( long n, s32 x[], double j ) {
    double r, i, d, t;
    long k;
    r = 0.0;    // 
    i = 0.0;    // 
    d = -2.0 * M_PI * j / n;
    for( k=0; k<n; k++ ) {
        t =  d * k;
        r += x[k] * cos( t );
        i += x[k] * sin( t );
    }
    r /= n;
    i /= n;
    d = sqrt( r*r + i*i );  // Βl
    if( d == 0 ) return -999;
    return d*2;
}

const char* TestWlAudio::AUDIO_GetMicAmplitude(const char* arg)
{
    int i, j, ret, sampleDataNum, sampleCount, positionMax, separatorPosition = 1;
    char str[4];
    s32 amplitudeMax, amplitudeMin, amplitudeTotal, offsetMax, offsetMin;
    
    //ؗp
    nn::os::Tick startTick, currentTick;
    nn::fnd::TimeSpan timeSpan;
    
    //}CÑTvOłȂ΃TvOJn
    if(!m_isSampling)
    {
        pMicLib->StartSampling();
        m_isSampling = true;
        //DFTɂ1bȏ҂ȂƂȂ
        //if(m_SamplingRate == MicLib::MIC_SAMPLING_RATE_32730 && m_SamplingType == MicLib::MIC_SAMPLING_TYPE_SIGNED_16BIT)
            //nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1000));
        //else
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));    //CTRpƒl𑵂
    }
    
    //DFTؗp
    if(m_SamplingType == MicLib::MIC_SAMPLING_TYPE_SIGNED_16BIT)
    {
        s32 micData[MIC_BUFFER_SIZE];
        double targetFreq = 1000.0;
        sampleDataNum = 650;    //32kHz1TvO20msƂƃ|Cg͖650 16kHzɂ40msɂȂ
        sampleCount   = 50;     //TvO񐔂50
        int extractCount  = 10;     //cTvOf[^̐
        
        startTick = nn::os::Tick::GetSystemCurrent();
        
        double* dftResultBuffer = new double[sampleCount];
        double* dftResultExt    = new double[extractCount];
        
        for(i = 0; i < 50; i++)
        {
            //W
            pMicLib->GetMicData(micData, static_cast<size_t>(sampleDataNum));
            
            //DFT
            double dftFreqArg = targetFreq / ((m_SamplingRate == MicLib::MIC_SAMPLING_RATE_32730) ? 32729 : 16365) * sampleDataNum;
            
            dftResultBuffer[i] = dft_j(sampleDataNum, micData, dftFreqArg);
        }
        
        //㉺20|Cg폜邽߂ɍ~\[g
        for(i = 0; i < (sampleCount - 1); i++)
        {
            for(j = i + 1; j < sampleCount; j++)
            {
                if(dftResultBuffer[i] < dftResultBuffer[j])
                {
                    double tmp = dftResultBuffer[i];
                    dftResultBuffer[i] = dftResultBuffer[j];
                    dftResultBuffer[j] = tmp;
                }
            }
        }
        
        //10|Cg𒊏o
        std::memcpy(dftResultExt, &dftResultBuffer[20], (extractCount * sizeof(double)));
        
        delete [] dftResultBuffer;
        
        double dftResult = 0.0;
        for(i = 0; i < 10; i++)
        {
            dftResult += dftResultExt[i] / 10.0;
        }
        
        delete [] dftResultExt;
        
        currentTick = nn::os::Tick::GetSystemCurrent();
        
        //ɂԂ\Ă
        timeSpan = (currentTick - startTick).ToTimeSpan();
        m_StatWindow.Printf("DFT Result(%4.1fHz) = %f\n", targetFreq, dftResult);
        m_StatWindow.Printf("Calc time = %s\n", CommandUtil::ConvertStringFromTimeSpan(timeSpan));
        
        //X|Xpf[^𐶐
        std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
        sprintf(m_WorkBuf, "%X#%X#%X#%X", static_cast<int>(dftResult), 0, 0, 0);
        
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);
        
#if 0
        s32 micData[MIC_BUFFER_SIZE];
        double targetFreq, maxFreq, dftResult, dftMax = 0.0;
        long SAMPLE_NUM = (m_SamplingRate == MicLib::MIC_SAMPLING_RATE_32730) ? 32729 : 16365;  //}CNTvO̎ۂ̎g
        const double START_FREQ = 999.5;
        const double END_FREQ = 1000.5;
        const double STEP_FREQ = 0.05;
        
        pMicLib->GetMicData(micData, static_cast<size_t>(SAMPLE_NUM + 10));   //㔼ɂ͔g`f[^i[Ȃ̂Ńobt@TCY͎gĂ̓_
        
        m_StatWindow.Printf("Amplitude = %d\n", pMicLib->m_Amplitude);
        
        //SendCommand("0667A21218000165#9238#9FFF#58F5BBF");    NGɂĂď\L[삷鎞p
        
        startTick = nn::os::Tick::GetSystemCurrent();
        
        //999Hz1001Hz̊ԂŃs[NT
        for(targetFreq = START_FREQ; targetFreq <= END_FREQ; targetFreq += STEP_FREQ)
        {
            dftResult = dft_j(SAMPLE_NUM, micData, targetFreq);
            if(dftMax < dftResult) { dftMax = dftResult; maxFreq = targetFreq; }
            //dftResult += STEP_FREQ / 2.0 * (dft_j(SAMPLE_NUM, micData, (targetFreq * 3273.0 / 3273.0 / (static_cast<int>(m_SamplingRate) + 1))) + dft_j(SAMPLE_NUM, micData, ((targetFreq + STEP_FREQ) * 3273.0 / 3273.0 / (static_cast<int>(m_SamplingRate) + 1))));
        }
        
        m_StatWindow.Printf("DFT Result(%4.1fHz) %4.1f - %4.1f = %f\n", maxFreq, START_FREQ, END_FREQ, dftMax);
        currentTick = nn::os::Tick::GetSystemCurrent();
        //ԂvZ
        timeSpan = (currentTick - startTick).ToTimeSpan();
        m_StatWindow.Printf("Calc time = %s\n", CommandUtil::ConvertStringFromTimeSpan(timeSpan));
        
        //X|Xpf[^𐶐
        std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
        sprintf(m_WorkBuf, "%X#%X#%X#%X", static_cast<int>(dftMax), 0, 0, 0);
        
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);

        while(1)
        {
            if(Pad().IsButtonPress(Pad::BUTTON_DOWN))
            {
                targetFreq -= 10.0;
                dftResult   = dft_j(SAMPLE_NUM, micData, (targetFreq * 3273.0 / 3273.0 / ((static_cast<double>(m_SamplingRate) + 1))));
                m_StatWindow.Printf("DFT Result(%4.1f) = %f\n", targetFreq, dftResult);
            }
            if(Pad().IsButtonPress(Pad::BUTTON_UP))
            {
                targetFreq += 10.0;
                dftResult   = dft_j(SAMPLE_NUM, micData, (targetFreq * 3273.0 / 3273.0 / ((static_cast<double>(m_SamplingRate) + 1))));
                m_StatWindow.Printf("DFT Result(%4.1f) = %f\n", targetFreq, dftResult);
            }
            if(Pad().IsButtonPress(Pad::BUTTON_LEFT))
            {
                targetFreq -= 1.0;
                dftResult   = dft_j(SAMPLE_NUM, micData, (targetFreq * 3273.0 / 3273.0 / ((static_cast<double>(m_SamplingRate) + 1))));
                m_StatWindow.Printf("DFT Result(%4.1f) = %f\n", targetFreq, dftResult);
            }
            if(Pad().IsButtonPress(Pad::BUTTON_RIGHT))
            {
                targetFreq += 1.0;
                dftResult   = dft_j(SAMPLE_NUM, micData, (targetFreq * 3273.0 / 3273.0 / ((static_cast<double>(m_SamplingRate) + 1))));
                m_StatWindow.Printf("DFT Result(%4.1f) = %f\n", targetFreq, dftResult);
            }
            if(Pad().IsButtonPress(Pad::BUTTON_L))
            {
                targetFreq -= 0.1;
                dftResult   = dft_j(SAMPLE_NUM, micData, (targetFreq * 3273.0 / 3273.0 / ((static_cast<double>(m_SamplingRate) + 1))));
                m_StatWindow.Printf("DFT Result(%4.1f) = %f\n", targetFreq, dftResult);
            }
            if(Pad().IsButtonPress(Pad::BUTTON_R))
            {
                targetFreq += 0.1;
                dftResult   = dft_j(SAMPLE_NUM, micData, (targetFreq * 3273.0 / 3273.0 / ((static_cast<double>(m_SamplingRate) + 1))));
                m_StatWindow.Printf("DFT Result(%4.1f) = %f\n", targetFreq, dftResult);
            }
            if(Pad().IsButtonPress(Pad::BUTTON_A))
            {
                break;
            }
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
        }
#endif
    }
    
    //DFT؂܂
    
    while(arg[separatorPosition] != '#')
    {
        if(arg[separatorPosition] == '\0')
        {
            CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);     //s
        }
        
        separatorPosition++;
    }
    
    //R}h擾|Cg𒊏o
    std::memset(str, 0x00, sizeof(str));
    std::memcpy(str, arg, separatorPosition);
    ret = CommandUtil::ConvertNumFromString(str, std::strlen(str));
    if(ret < 0)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);    //s
    }
    //擾|Cgݒ
    sampleDataNum = static_cast<int>(ret);
    
    separatorPosition++;
    
    //R}hf[^擾񐔂𒊏o
    std::memset(str, 0x00, sizeof(str));
    std::memcpy(str, &arg[separatorPosition], (std::strlen(arg) - separatorPosition));
    ret = CommandUtil::ConvertNumFromString(str, (std::strlen(arg) - separatorPosition));
    if(ret < 0)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x02);    //s
    }
    //f[^擾񐔂𔽉f
    sampleCount = static_cast<int>(ret);
    
    int dataSize = sampleCount / 4;
    s32 samp_data[dataSize];
    
    //ݒ肱܂ ȉW
    amplitudeTotal = amplitudeMax = offsetMax = 0;
    amplitudeMin = offsetMin = 0xFFFF;  //}CNŏWł͈͂̍ő
    
    //ؗp
    startTick = nn::os::Tick::GetSystemCurrent();
    //ؗp܂
    
    for(i = 0; i < sampleCount; i++)
    {
        s32 micData[static_cast<size_t>(sampleDataNum)];
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds((sampleDataNum / 16) + 5));
        
        //TvO
        pMicLib->GetMicData(micData, static_cast<size_t>(sampleDataNum));
        //i[悪O͒PɊi[Ă
        if(i < dataSize)
        {
            samp_data[i] = pMicLib->m_Amplitude;
            amplitudeTotal += samp_data[i];
            //őlXV͈ʒuXV
            if(amplitudeMax < pMicLib->m_Amplitude) {positionMax = i; amplitudeMax = pMicLib->m_Amplitude;}
            //ŏlXV
            if(amplitudeMin > pMicLib->m_Amplitude) amplitudeMin = pMicLib->m_Amplitude;
            //ItZbgől
            if(offsetMax < pMicLib->m_AveMicData) offsetMax = pMicLib->m_AveMicData;
            //ItZbgŏl
            if(offsetMin > pMicLib->m_AveMicData) offsetMin = pMicLib->m_AveMicData;
        }
        //i[悪ꂽ͍őlւĂ
        else
        {
            //őlႢl̏ꍇ͂ւ
            if(pMicLib->m_Amplitude < amplitudeMax)
            {
                samp_data[positionMax] = pMicLib->m_Amplitude;
                amplitudeTotal -= amplitudeMax;
                amplitudeTotal += pMicLib->m_Amplitude;
                //ŏlXV
                if(amplitudeMin > pMicLib->m_Amplitude) amplitudeMin = pMicLib->m_Amplitude;
                //ItZbgől
                if(offsetMax < pMicLib->m_AveMicData) offsetMax = pMicLib->m_AveMicData;
                //ItZbgŏl
                if(offsetMin > pMicLib->m_AveMicData) offsetMin = pMicLib->m_AveMicData;
                
                amplitudeMax = 0;
                
                //ől̃CfbNXT[`
                for(j = 0; j < dataSize; j++)
                {
                    if(amplitudeMax < samp_data[j])
                    {
                        amplitudeMax = samp_data[j];
                        positionMax = j;
                    }
                }
            }
        }
    }
    
    //ؗp
DFT_FINISH:
    currentTick = nn::os::Tick::GetSystemCurrent();
    //ԂvZ
    timeSpan = (currentTick - startTick).ToTimeSpan();
    m_StatWindow.Printf("%s\n", CommandUtil::ConvertStringFromTimeSpan(timeSpan));
    //ؗp܂
    
    //X|Xpf[^𐶐
    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
    sprintf(m_WorkBuf, "%X#%X#%X#%X", (amplitudeTotal / dataSize), amplitudeMax, amplitudeMin, (offsetMax - offsetMin));
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);
}

//------------------------------------------------------------------------------
// Desc   F0213 }CN̋N莞ԂƖԖŏ̃TvO擾
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_CheckMicStableTime(const char* arg)
{
    s64 tempStableTime, compareTime;
    s32 threshMin, threshMax;
    int separatorPosition = 1;
    nn::os::Tick startTick;
    nn::os::Tick currentTick;
    int sampleDataNum = 256;    //CTRP
    const u64 MSEC_STABLE_DECISION_REGION = 100;    //ȏ臒lɂΈ莞Ԋm CTRP
    const u64 STABLE_TIMEOUT = 2000;  //S肵ȂA삵ĂȂ}CN̏ꍇɔ邽ߐ݂
    s32 micData[static_cast<size_t>(sampleDataNum)];
    u16 responseSampleData, stableTime;
    bool testFinish = false;    //}CNo痧Ă
    
    //蔻͈̔͂𒊏o
    //؂蕶̏ꏊ{
    while(arg[separatorPosition] != '#')
    {
        separatorPosition++;
        if(arg[separatorPosition] == '\0')
            return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);  //s(؂蕶)
    }
    if(separatorPosition == (std::strlen(arg) - 1))
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);      //s(I[؂蕶)
    
    //𒊏o
    threshMin = static_cast<s32>(CommandUtil::ConvertNumFromString(arg, separatorPosition));
    
    separatorPosition++;
    
    //𒊏o
    threshMax = static_cast<s32>(CommandUtil::ConvertNumFromString(&arg[separatorPosition], (std::strlen(arg) - separatorPosition)));
    
    //Ɖ̊֌WĂ
    if(threshMin >= threshMax)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x02);
    
    //}CN̓dUItɂ
    pMicLib->TurnOffMic();
    m_StatWindow.Printf("Turn off MIC\n");
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1000));   //dItPbҋ@
    
    //ēx}CN̓dIɂ
    pMicLib->TurnOnMic();
    
    //vJn
    startTick = nn::os::Tick::GetSystemCurrent();
    m_StatWindow.Printf("Turn on  MIC\n");
    
    //TvOJn
    if(!m_isSampling)
    {
        //gp}CN̓obt@㏑ݒ肷
        //pMicLib->SetSamplingLength(nn::mic::BUFFER_ALIGNMENT_SIZE);
        
        pMicLib->StartSampling();
        //TvOJnA}CN͈҂500ms̃fBCĂ
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));
    }
    
    //U0̊Ԃ߂
    pMicLib->m_Amplitude = 0;   //sv
    
    while(pMicLib->m_Amplitude == 0)
    {
        pMicLib->GetMicData(micData, static_cast<size_t>(sampleDataNum));
    }
    
    currentTick = nn::os::Tick::GetSystemCurrent();
    m_StatWindow.Printf("No signal span = %dms\n", (currentTick - startTick).ToTimeSpan().GetMilliSeconds());
    m_StatWindow.Printf("First mic amp  = %d\n", pMicLib->m_Amplitude);
    m_StatWindow.Printf("silent min = %d, max = %d\n", micData[pMicLib->m_MinIndex], micData[pMicLib->m_MaxIndex]);
    m_StatWindow.Printf("Thresh : min = %d, max = %d\n", threshMin, threshMax);
    
    //莞Ԍ{
    do
    {
        currentTick = nn::os::Tick::GetSystemCurrent();
        //̈ɓꍇAԂ̃X^[g_ƂtempStableTimeg
        tempStableTime = (currentTick - startTick).ToTimeSpan().GetMilliSeconds();
        pMicLib->GetMicData(micData, static_cast<size_t>(sampleDataNum));
        
        while(threshMin <= micData[pMicLib->m_MinIndex] && micData[pMicLib->m_MaxIndex] <= threshMax)
        {
            currentTick = nn::os::Tick::GetSystemCurrent();
            compareTime = (currentTick - startTick).ToTimeSpan().GetMilliSeconds();
            pMicLib->GetMicData(micData, static_cast<size_t>(sampleDataNum));
            
            //100msȏ臒lɂΈ莞Ԋm
            if((compareTime - tempStableTime) > MSEC_STABLE_DECISION_REGION)
            {
                stableTime = static_cast<u16>((currentTick - startTick).ToTimeSpan().GetMilliSeconds());
                m_StatWindow.Printf("Stable Time = %dms\n", stableTime);
                m_StatWindow.Printf("min = %d, max = %d", micData[pMicLib->m_MinIndex], micData[pMicLib->m_MaxIndex]);
                testFinish = true;
                break;
            }
            
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));
        }
    }while(!testFinish && (currentTick - startTick).ToTimeSpan().GetMilliSeconds() < STABLE_TIMEOUT);
    
    //TvO~
    pMicLib->StopSampling();
    
    //obt@gpʂɖ߂
    //pMicLib->ResetSamplingLength();
    
    //NGAɂ͍őlƍŏl̒ԓ_(ItZbgɂȂH)ڂ
    if(!testFinish)
    {
        //莞ԂɃ^CAEgŔ̎ԂĂ
        stableTime = static_cast<u16>((currentTick - startTick).ToTimeSpan().GetMilliSeconds());
    }
    //ɂ̓Z^[lӂڂ
    responseSampleData = static_cast<u16>(micData[pMicLib->m_MaxIndex] - micData[pMicLib->m_MinIndex]);
    
    //X|Xpf[^𐶐
    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
    sprintf(m_WorkBuf, "%X#%X", stableTime, responseSampleData);
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);
}

//------------------------------------------------------------------------------
// Desc   F0214 I2S1gPĐ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_PlaySound(const char* arg)
{
    NN_UNUSED_VAR(arg)
    
    //ɍĐ̏ꍇNGԂ
    if(m_isPlaying) return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    
    //ꎞ~ɂȂĂȂ ̔肪̂ňꎞ~ɂȂ̂͂蓾Ȃz
    m_isPlaying = sound::TestStartWlAudioSp();
    if(m_isPlaying)
    {
        //}CN̐ݒ肵Ȃ
        pMicLib->PresetSamplingRate(pMicLib->MIC_SAMPLING_RATE_32730);
        pMicLib->PresetSamplingType(pMicLib->MIC_SAMPLING_TYPE_16BIT);
        
        //}CNTvOJn
        pMicLib->StartSampling();
        m_isSampling = true;
        
        //TvOJnf[^o܂ŏ҂ PC炱̃p[^ndlɂH
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
        
        //Howll̎擾 DP1ł̓ʑΉ
        //for(int i = 0; i < 100; i++)    //Xs[J[Jn̎ɉ񐔂^ĂĂ񐔂߂    =========
        {
            s32 micData[static_cast<size_t>(256)];
            
            pMicLib->GetMicData(micData, static_cast<size_t>(256));
            
            m_StatWindow.Printf("Mic Amplitude = %d\n", pMicLib->m_Amplitude);
            
            //nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));
        }
        pMicLib->StopSampling();
        m_isSampling = false;
        
        std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
        sprintf(m_WorkBuf, "%d", pMicLib->m_Amplitude);
        
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);
    }
    else
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
}

//------------------------------------------------------------------------------
// Desc   F0215 I2S1gPĐ̒~
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_StopSound(const char* arg)
{
    NN_UNUSED_VAR(arg)
    
    //ĐłȂꍇNGԂ
    if(!m_isPlaying) return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    
    sound::TestStopWlAudioSp();
    m_isPlaying = false;
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   F0216 ʃ{[̋Kp
// Arg    F{[l(FAFE)
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_SetSoundVolume(const char* arg)
{
    u8 leftVol, rightVol, volumeSetting = 0;
    const u8 VOLUME_LEN = 2;
    codec::TestCodec* pTestCodec = new codec::TestCodec;
    
    //gOɈ̒Ƌ؂蕶Ă
    if(arg[2] != '#' || std::strlen(arg) != (VOLUME_LEN * 2 + 1))
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    
    //獶ʂ𒊏o
    leftVol  = static_cast<u8>(CommandUtil::ConvertNumFromString(arg, 2));
    
    //Eʂ𒊏o
    rightVol = static_cast<u8>(CommandUtil::ConvertNumFromString(&arg[VOLUME_LEN + 1], 2));
    
    //SPIWX^̃{[lDݒɂ
    pTestCodec->TestSetVolumeSetting(&volumeSetting);
    
    //ʂݒ
    pTestCodec->TestSetLeftVolume(&leftVol);
    
    //Eʂݒ
    pTestCodec->TestSetRightVolume(&rightVol);
    
    delete pTestCodec;
    
    m_StatWindow.Printf("Set SoundVolume\nLeft : %d  Right : %d\n", leftVol, rightVol);
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   F0217 CallɕۑĂ}CN␳lCodecɒ@
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::AUDIO_ApplyMicCal(const char* arg)
{
    NN_UNUSED_VAR(arg)
    
    WlAudioUpdatePgaGain();
    
    m_StatWindow.Printf("Apply CodecMicCal : %d\n", m_CurrentPgaGainHex);
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_CurrentPgaGainHex);
}

//------------------------------------------------------------------------------
// Desc   FMPʐM̏
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::MP_Init(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);

    //ɏς̏ꍇ
    if(m_isMPInit)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);

    nn::Result result;

    result = nn::mp::CTR::Initialize();
    if(result.IsFailure())
    {
        nn::dbg::PrintResult(result);
        m_StatWindow.Printf("MP Initialize Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    result = nn::mp::CTR::SetPortConfig(0, true, 0);
    if(result.IsFailure())
    {
        nn::dbg::PrintResult(result);
        m_StatWindow.Printf("MP SetPortConfig Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    }

    m_isMPInit = true;

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);

}

//------------------------------------------------------------------------------
// Desc   FMPʐM̏I
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::MP_End(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);

    //ɏIς̏ꍇ
    if(!m_isMPInit)
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);

    nn::Result result;

    result = nn::mp::CTR::Finalize();
    if(result.IsFailure())
    {
        nn::dbg::PrintResult(result);
        m_StatWindow.Printf("MP Finalize Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    m_isMPInit = false;

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   FMPʐM̃`lw
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::MP_SetChannel(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);


    m_MPChannel = CommandUtil::ConvertNumFromString(arg, std::strlen(arg));

    if(m_MPChannel == CommandUtil::CONVERT_ERROR_NUM)
    {
        m_StatWindow.Printf("MP SetChannel Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    NN_LOG("Channel = %d\n", m_MPChannel);

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   FMPʐMAPSSIDݒ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::MP_SetSSID(const char* arg)
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);

    std::memset(m_MP_AP_SSID, 0x00, MAX_SSID_SIZE);
    std::strcpy(m_MP_AP_SSID, arg);
    NN_LOG("Set SSID = %s\n", m_MP_AP_SSID);

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   FAPɑ΂ăANeBuXLARSSIlԂ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::MP_StartActiveScan(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);

    nn::mp::CTR::Config config;
    nn::Result result;
    nn::mp::CTR::BssDesc bssDesc[ NN_MP_SCAN_BSS_MAX ];

    config.mode = NN_MP_MODE_CHILD;
    config.recvmode = NN_MP_RECVMODE_PORT;

    nn::mp::CTR::Start(&config);

    nn::mp::CTR::ScanParam param;

    std::memset(&param, 0, sizeof(nn::mp::CTR::ScanParam));
    param.channelBits = 0x0001<< (m_MPChannel - 1) ;  //1chŒ
    param.maxChannelTime = 1000;        // XLԁi1bj
    param.descNum = NN_MP_SCAN_BSS_MAX; // őXL
    std::memset(param.bssid, 0xff, 6);    // SMACAhXΏ

    result = nn::mp::CTR::Scan(bssDesc, &param, NN_MP_SCANTYPE_ACTIVE);
    if(result.IsFailure())
    {
        m_StatWindow.Printf("Scan Failure\n");
        nn::dbg::PrintResult(result);
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    result = nn::mp::CTR::Stop();
    if(result.IsFailure())
    {
        m_StatWindow.Printf("MP Can't Stop\n");
        nn::dbg::PrintResult(result);
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    }

    for (int i = 0; i < NN_MP_SCAN_BSS_MAX; i++)
    {
        NN_LOG("num = %d Set = %s scan = %s\n", i, m_MP_AP_SSID, reinterpret_cast<char*>(bssDesc[i].ssid));
        m_StatWindow.Printf("num = %d Set = %s scan = %s\n", i, m_MP_AP_SSID, reinterpret_cast<char*>(bssDesc[i].ssid));
        if(0 == std::strcmp(m_MP_AP_SSID, reinterpret_cast<char*>(bssDesc[i].ssid)))
        {
            const int RETURN_RSSI_LENGTH = 5;
            static char returnMPRSSI[ RETURN_RSSI_LENGTH ];
            NN_LOG("RSSI = %d\n", bssDesc[i].rssi);
            std::sprintf(returnMPRSSI, "%X", GetRssi8(bssDesc[i].rssi));

            return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, returnMPRSSI);
        }
    }
    NN_LOG("No Hit\n");
    m_StatWindow.Printf("AP Can't Discover\n");
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x02);

}

//------------------------------------------------------------------------------
// Desc   FCTRbr[R𑗐M
// Arg    Fob(16i)
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::MP_StartBeacon(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);


    int sendSec = CommandUtil::ConvertNumFromString(arg, std::strlen(arg));
    if(sendSec == CommandUtil::CONVERT_ERROR_NUM)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    nn::mp::CTR::Config config;
    nn::Result result;
    TimeCounter tCount;
    const int PARENT_DATA_SIZE = 4;
    const int CHILD_DATA_SIZE  = 4;

    config.mode               = NN_MP_MODE_PARENT;
    config.ggid               = 0x00;
    config.tgid               = NN_MP_TGID_AUTO;
    config.channel            = m_MPChannel;
    config.lifeTime           = NN_MP_LIFETIME_DEFAULT;
    config.beaconPeriod       = 10;
    config.maxNodes           = NN_MP_AID_MAX-1; //15
    config.parentMaxSize      = PARENT_DATA_SIZE;
    config.childMaxSize       = CHILD_DATA_SIZE;
    config.entryFlag          = 1;
    config.frequency          = 1;
    config.userGameInfoLength = NN_MP_GAMEINFO_USER_SIZE;

    result = nn::mp::CTR::Start(&config);
    if(result.IsFailure())
    {
        nn::dbg::PrintResult(result);
        m_StatWindow.Printf("MP Start Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    }

    while(tCount.GetTimeSpan().GetSeconds() < sendSec)
    {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));
    }

    result = nn::mp::CTR::Stop();
    if(result.IsFailure())
    {
        nn::dbg::PrintResult(result);
        m_StatWindow.Printf("MP Stop Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x02);
    }
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   FAPɑ΂ăpbVuXLARSSIlԂ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::MP_StartPassiveScan(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%s Exec! arg = %s\n", __func__, arg);


    nn::mp::CTR::Config config;
    nn::Result result;
    nn::mp::CTR::BssDesc bssDesc[ NN_MP_SCAN_BSS_MAX ];

    config.mode = NN_MP_MODE_CHILD;
    config.recvmode = NN_MP_RECVMODE_PORT;

    nn::mp::CTR::Start(&config);

    nn::mp::CTR::ScanParam param;

    std::memset(&param, 0, sizeof(nn::mp::CTR::ScanParam));
    param.channelBits = 0x0001<< (m_MPChannel - 1) ;  // 1chŒ
    param.maxChannelTime = 1000;                        // XLԁi1bj
    param.descNum = NN_MP_SCAN_BSS_MAX;                 // őXL
    std::memset(param.bssid, 0xff, 6);                // SMACAhXΏ

    result = nn::mp::CTR::Scan(bssDesc, &param);
    if(result.IsFailure())
    {
        nn::dbg::PrintResult(result);
        m_StatWindow.Printf("MP Scan Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }


    for (int i = 0; i < NN_MP_SCAN_BSS_MAX; i++)
    {
        if(0 == std::strcmp(m_MP_AP_SSID, reinterpret_cast<char*>(bssDesc[i].ssid)))
        {
            const int RETURN_RSSI_LENGTH = 5;
            static char returnMPRSSI[ RETURN_RSSI_LENGTH ];
            NN_LOG("RSSI = %d\n", bssDesc[i].rssi);
            std::sprintf(returnMPRSSI, "%X", GetRssi8(bssDesc[i].rssi));

            result = nn::mp::CTR::Stop();
            if(result.IsFailure())
            {
                nn::dbg::PrintResult(result);
                m_StatWindow.Printf("MP Stop Error\n");
                return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
            }

            return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, returnMPRSSI);
        }
    }
    NN_LOG("Can't Get AP\n");
    m_StatWindow.Printf("Can't Discover AP\n");
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x02);

}



/*
const char* TestWlAudio::ATH_GetPacketErrorRate(const char* arg)
{
    NN_UNUSED_VAR(arg)

    if(!m_isEndRxTest)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::OPERATING);
    }
    else
    {
        char ResultString[ 100 ];
        std::sprintf(ResultString, "%u#%u", m_ActuallyRecvNum, m_ExpectedRecvNum);
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, ResultString);
    }
}
*/
//------------------------------------------------------------------------------
// Desc   FWRFUW[MacAddress擾
// Arg    FȂ
// Return FMacAddress(12)
//------------------------------------------------------------------------------
const char* TestWlAudio::CTR_GetMacAddress(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);


    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
    std::sprintf(m_WorkBuf,"%02X%02X%02X%02X%02X%02X", m_MacAddress[0], m_MacAddress[1], m_MacAddress[2],
                                                               m_MacAddress[3], m_MacAddress[4], m_MacAddress[5]);
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);

}

//------------------------------------------------------------------------------
// Desc   FVAio[̓ǂݍ
// Arg    FȂ
// Return FVAio[
//------------------------------------------------------------------------------
const char* TestWlAudio::CTR_GetSerialNumber(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);

    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
    uji::sys::GetSerialNumber(m_WorkBuf);
    
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);

}

//------------------------------------------------------------------------------
// Desc   FModuleID̓ǂݍ
// Arg    FȂ
// Return FVAio[
//------------------------------------------------------------------------------
const char* TestWlAudio::CTR_GetModuleID(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);

    u8 moduleID;
    const int MODULE_ID_ADDR = 0x2F;

    nn::cfg::nor::CTR::Initialize();
    nn::cfg::nor::CTR::Read(MODULE_ID_ADDR, &moduleID, sizeof(u8));

    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
    std::sprintf(m_WorkBuf, "%02X", moduleID);
    nn::cfg::nor::CTR::Finalize();

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);

}

//------------------------------------------------------------------------------
// Desc   FFirmwareType̓ǂݍ
// Arg    FȂ
// Return FVAio[
//------------------------------------------------------------------------------
const char* TestWlAudio::CTR_GetFirmwareType(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);

    u8 firmwareType;
    const int FIRMWARE_TYPE_ADDR = 0x1FD;

    nn::cfg::nor::CTR::Initialize();
    nn::cfg::nor::CTR::Read(FIRMWARE_TYPE_ADDR, &firmwareType, sizeof(u8));

    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
    std::sprintf(m_WorkBuf, "%02X", firmwareType);
    nn::cfg::nor::CTR::Finalize();

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);
}


//------------------------------------------------------------------------------
// Desc   FVAio[̏
// Arg    FVAio[
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::CTR_WriteSerialNumber(const char* arg)
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);


    if(uji::seq::pl::LINE != m_TestMode && uji::seq::pl::SUBMIT != m_TestMode)
    {
        std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
        std::strcpy(m_WorkBuf, arg);
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
    }
    
    if(uji::sys::WriteSerialNumber(arg))
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
    }else
    {
        m_StatWindow.Printf("Write SerialNumber Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

}

//------------------------------------------------------------------------------
// Desc   Ft@[EFÃo[W擾
// Arg    FȂ
// Return Ft@[EFAo[W
//------------------------------------------------------------------------------
const char* TestWlAudio::CTR_GetFirmwareVersion(const char* arg)
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);


    nn::Result result;
    nn::nwm::CTR::HardwareInfo HWInfo;

    result = nn::nwm::CTR::InitializeExtControl();
    if(result.IsFailure())
    {
        nn::dbg::PrintResult(result);
        m_StatWindow.Printf("RFU InitializeExtControl Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    result = nn::nwm::CTR::Ext::GetHardwareInfo(HWInfo);
    if(result.IsFailure())
    {
        nn::dbg::PrintResult(result);
        m_StatWindow.Printf("GetHardwareInfo Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    }

    result = nn::nwm::CTR::FinalizeExtControl();
    if(result.IsFailure())
    {
        nn::dbg::PrintResult(result);
        m_StatWindow.Printf("RFU FinalizeExtControl Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x02);
    }

    std::memset(m_WorkBuf, 0x00, MAX_COMMAND_SIZE);
    std::sprintf(m_WorkBuf, "%08X", HWInfo.firmwareVersion);
    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);

}

//------------------------------------------------------------------------------
// Desc   F{̂̃[W擾
// Arg    FȂ
// Return F{̂̃[W
//------------------------------------------------------------------------------
const char* TestWlAudio::CTR_GetRegion(const char* arg)
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);


    nn::cfg::CTR::CfgRegionCode region;
    
    region = uji::sys::GetRegionCode();

    switch(region)
    {
        case nn::cfg::CFG_REGION_AMERICA    :
            std::sprintf(m_WorkBuf, "USA");
            break;

        case nn::cfg::CFG_REGION_CHINA      :
            std::sprintf(m_WorkBuf, "CHN");
            break;

        case nn::cfg::CFG_REGION_EUROPE     :
            std::sprintf(m_WorkBuf, "EUR");
            break;
        case nn::cfg::CFG_REGION_JAPAN      :
            std::sprintf(m_WorkBuf, "JPN");
            break;

        case nn::cfg::CFG_REGION_KOREA      :
            std::sprintf(m_WorkBuf, "KOR");
            break;

        case nn::cfg::CFG_REGION_TAIWAN     :
            std::sprintf(m_WorkBuf, "TWN");
            break;

        case nn::cfg::CFG_REGION_AUSTRALIA  :
            std::sprintf(m_WorkBuf, "AUS");
            break;

        default  :
            std::sprintf(m_WorkBuf, "UNKNOWN REGION");
    }

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, m_WorkBuf);

}

//------------------------------------------------------------------------------
// Desc   FCTR{̂ɃZbg
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::CTR_SetReset(const char* arg)
{
    NN_UNUSED_VAR(arg)


    uji::eva::mcu::EvaReset();

    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromSeconds(10)); // Zbg܂łŎ~܂

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   FCTR{̂̓d𗎂Ƃ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::CTR_SetPowerOff(const char* arg)
{
    NN_UNUSED_VAR(arg)


    uji::eva::mcu::EvaPowerOff();


    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromSeconds(10));  // d܂łŎ~܂


    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}




//------------------------------------------------------------------------------
// Desc   FvÕo[W擾
// Arg    FȂ
// Return FvOo[W
//------------------------------------------------------------------------------
const char* TestWlAudio::TESTER_GetVersion(const char* arg)
{
    NN_UNUSED_VAR(arg)


    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, UJI_APPVER_WL_AUDIO);
}
//------------------------------------------------------------------------------
// Desc   FvÕrh擾
// Arg    FȂ
// Return FvÕrh
//------------------------------------------------------------------------------
const char* TestWlAudio::TESTER_GetBuildDate(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS, VERSION_DATE);
}
//------------------------------------------------------------------------------
// Desc   FiOpjJnԐݒ
// Arg    FJn
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::TESTER_SetTime(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);



    const u8 DATA_AND_TIME_LEN = 16;

    if(std::strlen(arg) != DATA_AND_TIME_LEN)  // ̒̂e
    {
        m_StatWindow.Printf("Data Length Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    const u8 SEPARATOR_POSITION = 10;

    if(arg[ SEPARATOR_POSITION ] != '#')  // ̔ẑe
    {
        m_StatWindow.Printf("Data Format Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    }

    const u8 DATE_NUM   = 10;
    const u8 TIME_START = 11;
    const u8 TIME_NUM   = 5;

    std::memset(m_StartTestDate, 0x00, sizeof(m_StartTestDate));
    std::memset(m_StartTestTime, 0x00 ,sizeof(m_StartTestTime));

    std::memcpy(m_StartTestDate, &arg[0], DATE_NUM);
    std::memcpy(m_StartTestTime, &arg[ TIME_START ], TIME_NUM);

    NN_LOG("TestDate = %s\n", m_StartTestDate);
    NN_LOG("TestTime = %s\n", m_StartTestTime);

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FiOpj[hݒ
// Arg    F[h
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::TESTER_SetTestMode(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);

    const u8 SEPARATOR_POSITION = 1;
    if('#' != arg[ SEPARATOR_POSITION ])
    {
        m_StatWindow.Printf("TestMode Set Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    m_TestMode = CommandUtil::ConvertNumFromString(arg, 1);

    const u8 TESTER_ID_START  = 2;
    const u8 TESTER_ID_LENGTH = 6;

    std::memset(m_TesterID, 0x00, sizeof(m_TesterID));

    std::memcpy(m_TesterID, &arg[ TESTER_ID_START ], TESTER_ID_LENGTH);

    NN_LOG("TestMode = %d TesterID = %s\n", m_TestMode, m_TesterID);

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}
//------------------------------------------------------------------------------
// Desc   FiOpjJnO
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::TESTER_WriteStartLog(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);

    if(m_TestMode == uji::seq::pl::DEBUG)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    #if 1
    // O
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    if(0 <= pdl->Add_1Line(m_TestMode, "WlAudio", "START", UJI_APPVER_WL_AUDIO, m_StartTestDate, m_StartTestTime, m_TesterID, arg))
    {
        pdl->Finalize();
        delete pdl;
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
    }else
    {
        pdl->Finalize();
        delete pdl;
        m_StatWindow.Printf("Write StartLog Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    }
    
    
    
    #endif

}
//------------------------------------------------------------------------------
// Desc   FiOpjOKO
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::TESTER_WriteOKLog(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);

    if(m_TestMode == uji::seq::pl::DEBUG)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    const u8 LOG_MESSAGE_MAX = 80;
    char logMessage[ LOG_MESSAGE_MAX ] = "";
/*  ł͖
    int separatorPosition = 0;
    std::strcat(logMessage, CreateOKLogMessage(&arg[ separatorPosition ]));

    //NN_LOG("%s\n", logMessage);

    while(arg[ separatorPosition ] != '\0')
    {
        if(arg[ separatorPosition ] == '#')
        {
            std::strcat(logMessage, "$");
            //std::strcat(logMessage, "\n");
            std::strcat(logMessage, CreateOKLogMessage(&arg[ separatorPosition + 1 ]));

        }
        separatorPosition++;
    }
    NN_LOG("%s\n", logMessage);
    m_StatWindow.Printf("%s\n", logMessage);
*/
    // O
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    if(0 <= pdl->Add_1Line(m_TestMode, "WlAudio", "OK", UJI_APPVER_WL_AUDIO, m_StartTestDate, m_StartTestTime, m_TesterID, logMessage))
        {
        pdl->Finalize();
        delete pdl;
#ifdef EVA_COMPOSITE
        m_TestResult = RESULT_OK;
#endif
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
    }else
    {
        pdl->Finalize();
        
        delete pdl;
        m_StatWindow.Printf("Write OKLog Error\n");
#ifdef EVA_COMPOSITE
        m_TestResult = RESULT_NG;
#endif
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    }
}
//------------------------------------------------------------------------------
// Desc   FiOpjNGR[h
// Arg    FNGR[h
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::TESTER_WriteNGLog(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);
    
    if(m_TestMode == uji::seq::pl::DEBUG)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    // O
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
#ifdef EVA_COMPOSITE
    m_TestResult = RESULT_NG;
#endif
    if(0<= pdl->Add_1Line(m_TestMode, "WlAudio", "NG", UJI_APPVER_WL_AUDIO, m_StartTestDate, m_StartTestTime, m_TesterID, arg))
    {
        pdl->Finalize();
        delete pdl;
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
    }else
    {
        pdl->Finalize();
        delete pdl;
        m_StatWindow.Printf("Write NGLog Error\n");
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    }

}
//------------------------------------------------------------------------------
// Desc   FCTR̃^CJE^[擾
// Arg    FȂ
// Return F^CJE^[̒l
//------------------------------------------------------------------------------
const char* TestWlAudio::TESTER_GetTimeCounter(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);



    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS,
                        CommandUtil::ConvertStringFromTimeSpan(m_TimeCounter.GetTimeSpan()));
}

//------------------------------------------------------------------------------
// Desc   Fڑ`lw肷
// Arg    F`l
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::DEBUG_SetChannel(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);



    nn::Result result;
    u8 channel = CommandUtil::ConvertNumFromString(arg, std::strlen(arg));

    NN_LOG("channel = %d\n", channel);

    result = Internal::SetNetworkSetting_Ip_ScanlessConnect_LastConnectedChannnel(channel);
    NN_UTIL_PANIC_IF_FAILED(result);

    // Internalݒ𔽉f
    result = Internal::UpdateNetworkSetting(0);
    NN_UTIL_PANIC_IF_FAILED(result);

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// Desc   FScanlessConnect
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWlAudio::DEBUG_ScanlessConnect(const char* arg)
{
    NN_UNUSED_VAR(arg)
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg);



    nn::Result result;

        result = Internal::SetNetworkSetting_Ip_ScanlessConnect_HasConnected(true);
        NN_UTIL_PANIC_IF_FAILED(result);
    // Internalݒ𔽉f
    result = Internal::UpdateNetworkSetting(0);
    NN_UTIL_PANIC_IF_FAILED(result);

    NN_LOG("Connect Line = %d\n", __LINE__);

    nn::ac::Config config;
    nn::ac::CreateDefaultConfig(&config);
    nn::ac::CTR::SetNetworkArea(&config, nn::ac::NETWORK_AREA_LAN);

    NN_LOG("Connect Line = %d\n", __LINE__);

    result = nn::ac::Connect(config);

    NN_LOG("Connect Line = %d\n", __LINE__);

    //NN_UTIL_PANIC_IF_FAILED(result);
    if(result.IsFailure())
    {
        NN_LOG("Connect\n");
        nn::dbg::PrintResult(result);
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    NN_LOG("Connect Success!\n");

    // IPAdress擾p
    {
        nn::socket::Initialize();
        m_MyIpAddress.addr = nn::socket::GetHostId();
        nn::socket::Finalize();
    }
    // IPȂꍇAڑ̂sĂƂ݂ȂAؒfsB
    if(m_MyIpAddress.addr == 0)
    {
        nn::ac::Close();
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x01);
    }

    {   // ڑĂ`l̎擾
        nn::ac::AccessPoint AP;
        nn::ac::GetConnectingAccessPoint(&AP);

        m_MyChannel = AP.channel;
        NN_LOG("Channel = %d\n", m_MyChannel);
    }

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

const char* TestWlAudio::DEBUG_SetStartPacketNum(const char* arg)
{
    debTxParam.startPacketNum = CommandUtil::ConvertNumFromString(arg, std::strlen(arg));

    if(m_PortNum == CommandUtil::CONVERT_ERROR_NUM)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);

}

const char* TestWlAudio::DEBUG_SetStartPacketWait(const char* arg)
{

    debTxParam.startPacketWait = CommandUtil::ConvertNumFromString(arg, std::strlen(arg));

    if(m_PortNum == CommandUtil::CONVERT_ERROR_NUM)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

const char* TestWlAudio::DEBUG_SetStartPacketInterval(const char* arg)
{
    debTxParam.startPacketInterval = CommandUtil::ConvertNumFromString(arg, std::strlen(arg));

    if(m_PortNum == CommandUtil::CONVERT_ERROR_NUM)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

const char* TestWlAudio::DEBUG_SetDataPacketWait(const char* arg)
{
    debTxParam.dataPacketWait = CommandUtil::ConvertNumFromString(arg, std::strlen(arg));

    if(m_PortNum == CommandUtil::CONVERT_ERROR_NUM)
    {
        return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::FAILURE, (u8)0x00);
    }

    return CommandUtil::CreateRSCAndResponseArgString(CommandUtil::SUCCESS);
}

//------------------------------------------------------------------------------
// ܂Ō֐
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
// X^[gpPbg̑MsB
//------------------------------------------------------------------------------
void TestWlAudio::SendStartPacket(const u32 &sendCount, const u32 &sendSize)
{
    const u8 START_PACKET_SIZE = (5+3+3+1);
    char StartBuf[ START_PACKET_SIZE ] = "";

    std::sprintf(StartBuf, "START%03X%03X", sendCount, sendSize);

    nn::socket::SendTo(m_Socket, StartBuf, sizeof(StartBuf) - 1 , 0 , &m_Send_Addr);
}

//------------------------------------------------------------------------------
// f[^t[pPbg̑MsB
//------------------------------------------------------------------------------
void TestWlAudio::SendDataFramePacket(const u32 &sendCount, const u32 &sendSize)
{
    u8 NowSend = 0;
    u8 SendDataFrameBuf[ sendSize ];
    for(int i = 0; i < sendCount; i++)
    {
        std::memset(SendDataFrameBuf, NowSend, sendSize);
        nn::socket::SendTo(m_Socket, SendDataFrameBuf, sizeof(SendDataFrameBuf) , 0 , &m_Send_Addr);
        if(NowSend == 0xFF) // MJE^0xFFɒB0x00ɖ߂
        {
            NowSend = 0;
        }else
        {
            NowSend++;
        }
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(5));
    }
}

//------------------------------------------------------------------------------
// GhpPbg̑MsB
//------------------------------------------------------------------------------
void TestWlAudio::SendEndPacket()
{
    const char EndBuf[] = "END";
    nn::socket::SendTo(m_Socket, EndBuf, sizeof(EndBuf) - 1 , 0 , &m_Send_Addr);
}

//------------------------------------------------------------------------------
// Mf[^t[̐mF
//------------------------------------------------------------------------------
bool TestWlAudio::CheckRecvData(const char* RecvBuf, int &PacketLength)
{
    for(int i = 1; i < PacketLength; i++)
    {
        if(!(RecvBuf[0] == RecvBuf[i]))
        {
            return false;
        }
    }
    return true;
}

//------------------------------------------------------------------------------
// \Pbg쐬
//------------------------------------------------------------------------------
bool TestWlAudio::CreateSocket()
{
    NN_LOG("%s Exec!\n", __func__);
    nn::Result result;
    //result = nn::socket::Initialize();
    do
    {
        result = nn::socket::Initialize();
        nn::dbg::PrintResult(result);
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));
    }while(result.IsFailure());

    m_MyIpAddress.addr = nn::socket::GetHostId();
    NN_LOG("IP = %s\n",nn::socket::InetNtoA(m_MyIpAddress));

    return true;
}

//------------------------------------------------------------------------------
// \Pbgj
//------------------------------------------------------------------------------
bool TestWlAudio::DestroySocket()
{
    nn::Result result;
    result = nn::socket::Finalize();

    if(result.IsFailure())
    {
        nn::dbg::PrintResult(result);
        return false;
    }

    return true;
}

//------------------------------------------------------------------------------
// hbg10ĩAhX1~4oCgsɕϊ
//------------------------------------------------------------------------------

union changeIP
{
    u32 addrU32;
    u8  addrU8[4];
};

void TestWlAudio::U32ToU8Matrix(const nn::socket::InAddr &inAddr, u8 outAddr[])
{
    changeIP cIP;
    cIP.addrU32 = inAddr.addr;

    for(int i = 0; i < 4; i++)
    {
        outAddr[i] = cIP.addrU8[i];
    }

}


u8 TestWlAudio::GetRssi8(u8 rssi)
{
    if (rssi & 0x0002)
    {
        return static_cast<u8>(rssi >> 2);
    }
    return static_cast<u8>((rssi >> 2) + 25);
}

//------------------------------------------------------------------------------
// ĂR}hOKLog̃bZ[W쐬
//------------------------------------------------------------------------------
const char* TestWlAudio::CreateOKLogMessage(const char* arg)
{
    const u8 LOG_MESSAGE_MAX = 80;
    static char returnMessage[ LOG_MESSAGE_MAX ];
    std::memset(returnMessage, 0x00, sizeof(returnMessage));

    int ch        = 0;
    int frameRate = 0;
    int rssi      = 0;

    int arrayStart = 0;
    int arrayEnd   = 0;
    bool isTx;

    if(arg[ arrayStart ] == 'T' || arg[ arrayStart ] == 't')
    {
        isTx = true;
    }else
    {
        isTx = false;
    }

    arrayStart = arrayEnd = 2;

    while(true)
    {
        if(arg[ arrayEnd ] == '@')
        {
            break;
        }
        arrayEnd++;
    }
    ch = CommandUtil::ConvertNumFromString(&arg[ arrayStart ], arrayEnd - arrayStart);

    arrayStart = ++arrayEnd;

    while(true)
    {
        if(arg[ arrayEnd ] == '@')
        {
            break;
        }
        arrayEnd++;
    }

    frameRate = CommandUtil::ConvertNumFromString(&arg[ arrayStart ], arrayEnd - arrayStart);

    arrayStart = ++arrayEnd;

    while(true)
    {
        if(arg[ arrayEnd ] == '#' || arg[ arrayEnd ] == '\0')
        {
            break;
        }
        arrayEnd++;
    }

    rssi = CommandUtil::ConvertNumFromString(&arg[ arrayStart ], arrayEnd - arrayStart);

    if(isTx)
    {
        std::sprintf(returnMessage, "CH:%d FR:%d RSTx:%d", ch, frameRate, rssi);
    }else
    {
        std::sprintf(returnMessage, "CH:%d FR:%d RSRx:%d", ch, frameRate, rssi);
    }
    return returnMessage;
}

//------------------------------------------------------------------------------
// MR}hFĉʕ\
//------------------------------------------------------------------------------
void TestWlAudio::PrintRecvCommand(const CommPack commPack)
{
    //const int MAX_PRINT_BUF = 100;
    //char PrintBuf[ MAX_PRINT_BUF ] = "";
    //
    //std::memcpy(PrintBuf, &str[0], 4);
    //m_CommWindow.SetTextColor(ATTR_COLOR_CYAN);
    //m_CommWindow.Printf(PrintBuf);
    //std::memset(PrintBuf, 0x00, 4);
    //
    //std::memcpy(PrintBuf, &str[4], 4);
    //m_CommWindow.SetTextColor(ATTR_COLOR_WHITE);
    //m_CommWindow.Printf(PrintBuf);
    //std::memset(PrintBuf, 0x00, 4);
    //
    //std::memcpy(PrintBuf, &str[8], 2);
    //m_CommWindow.SetTextColor(ATTR_COLOR_CYAN);
    //m_CommWindow.Printf(PrintBuf);
    //std::memset(PrintBuf, 0x00, 2);
    //
    //m_CommWindow.SetTextColor(ATTR_COLOR_WHITE);
    //m_CommWindow.Printf("%s\n", &str[10]);
    m_CommWindow.SetTextColor(ATTR_COLOR_WHITE);
    m_CommWindow.Printf("%s Arg = %s\n", GetCommandName(commPack), commPack.Arg);
    m_CommWindow.SetTextColor(ATTR_COLOR_WHITE);
}

//------------------------------------------------------------------------------
// MR}hFĉʕ\
//------------------------------------------------------------------------------
void TestWlAudio::PrintSendCommand(const char* str)
{
    const int MAX_PRINT_BUF = 100;
    char PrintBuf[ MAX_PRINT_BUF ] = "";

    std::memcpy(PrintBuf, &str[0], 4);
    m_CommWindow.SetTextColor(ATTR_COLOR_GREEN);
    m_CommWindow.Printf("%s", PrintBuf);
    std::memset(PrintBuf, 0x00, 4);

    std::memcpy(PrintBuf, &str[4], 4);
    m_CommWindow.SetTextColor(ATTR_COLOR_YELLOW);
    m_CommWindow.Printf("%s", PrintBuf);
    std::memset(PrintBuf, 0x00, 4);

    std::memcpy(PrintBuf, &str[8], 2);
    m_CommWindow.SetTextColor(ATTR_COLOR_GREEN);
    m_CommWindow.Printf("%s", PrintBuf);
    std::memset(PrintBuf, 0x00, 2);

    if(str[10] == '0' && str[11] == '0')
    {
        m_CommWindow.SetTextColor(ATTR_COLOR_BLUE);
    }else
    {
        m_CommWindow.SetTextColor(ATTR_COLOR_RED);
    }
    std::memcpy(PrintBuf, &str[10], 2);
    m_CommWindow.Printf("%s", PrintBuf);
    m_CommWindow.SetTextColor(ATTR_COLOR_YELLOW);
    m_CommWindow.Printf("%s\n", &str[12]);
}

/*---------------------------------------------------------------------------
  CAL ̓Ǎ
---------------------------------------------------------------------------*/
bool TestWlAudio::ExecuteGetCalPgaGain(nn::drivers::cal::CTR::CodecCalDataCore* pc)
{
    using namespace nn::drivers::cal::CTR;
    
    Calibration cal;
    
    // CAL ̏Al̎擾
    cal.Initialize();
    if(!cal.Get(pc, CAL_DATA_CODEC)){  return false;  }
    else                            {  return true;   }
}

/*---------------------------------------------------------------------------
  PGA Gain Calibration XV
---------------------------------------------------------------------------*/
void TestWlAudio::WlAudioUpdatePgaGain(void)
{
    codec::TestCodec* pTestCodec = new codec::TestCodec;
    
    // CAL ̒lǍ
    nn::drivers::cal::CTR::CodecCalDataCore codecCalDataCore;
    ExecuteGetCalPgaGain(&codecCalDataCore);
    
    m_CurrentPgaGainHex = codecCalDataCore.micGainCalibrateParam;
    m_CurrentPgaGainF32 = pTestCodec->ConvCalibGainHexToF32(m_CurrentPgaGainHex);
    
    // CODEC  MIC PGA Gain Calibration ɔf
    pTestCodec->TestWriteMultiEx_SPI2_MicPgaGainCalibration(&m_CurrentPgaGainHex);
    
    delete pTestCodec;
}

/*---------------------------------------------------------------------------
  }CN̓dI
---------------------------------------------------------------------------*/
void TestWlAudio::WlAudio_TurnOnMic(void)
{
    // CTR}CN̏ƓdI
    pMicLib->Initialize();
    pMicLib->TurnOnMic();
}

/*---------------------------------------------------------------------------
  }CN̓dIt
---------------------------------------------------------------------------*/
void TestWlAudio::WlAudio_TurnOffMic(void)
{
    // CTR}CN̓dItyяI
    pMicLib->TurnOffMic();
    pMicLib->Finalize();
}

} // namespace eva
} // namespace uji
//

/************************************************************************
ʂɊG\

************************************************************************/
static void ShowPicture( wchar_t *file )
{
    GLuint s_TextureId;

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    JpegTexture jt;

    jt.Open( file );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            GL_RGB_NATIVE_DMP,
                                            jt.GetWidth(),
                                            jt.GetHeight(),
                                            GL_RGB_NATIVE_DMP,
                                            GL_UNSIGNED_SHORT_5_6_5,
                                            jt.GetTextureDataPointer(),
                                            s_TextureId );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
    gfx->m_DrawFramework->FillTexturedRectangle(s_TextureId,
                                                0.0f, 0.0f,
                                                GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT,
                                                GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT,
                                                jt.GetWidth(), jt.GetHeight() );
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->DeleteTexture(s_TextureId);
    jt.Close();

}
