#ifndef UDS_LIB_H_INCLUDED
#define UDS_LIB_H_INCLUDED

#include <nn.h>
#include <nn/os.h>
#include <nn/Result.h>
#include <nn/hid.h>
#include <nn/uds.h>
#include "sys.h"

namespace
{
    u8   m_RecvBufCommon[ 1036 ] NN_ATTRIBUTE_ALIGN(4);
    const int UDS_BUFFER_SIZE = 4096 * 20;
    bit8 s_UdsRecvBuffer[ UDS_BUFFER_SIZE ] NN_ATTRIBUTE_ALIGN(4096);
    
}


namespace uji{
namespace eva{

#define EFFECTIVE_UDS_LIB_CONSOLE_LOG


/*---------------------------------------------------------------------------
  name: UDS_LIB_LOG
  Desc: EFFECTIVE_UDS_LIB_CONSOLE_LOG`Ă鎞
        R\[o͂s

  Args: 
  Rtns: ȂB
---------------------------------------------------------------------------*/  


#ifdef EFFECTIVE_UDS_LIB_CONSOLE_LOG
    #define UDS_LIB_LOG( ... ) NN_LOG(__VA_ARGS__)
#else
    #define UDS_LOB_LOG( ... ) ((void)0)
#endif


struct CommunicationBuffer
{
    u8  IsAck;
    NN_PADDING3;
    int StateCount;
    u32 CheckSum;
    u8 Buffer[1024];
};

static const char PASSPHRASE[] = "UJI_EVA_UDS_TEST_PHRASE";     // pXt[YB̕gĒʐMoHp̈Í𐶐܂B
static const wchar_t MAC_ADDRESS_FILE_PATH[] = L"sdmc:/gyro/sequencerMacAddress.log";

class UDS_Lib
{
    public:
    enum SendState
    {
        SEND_SUCCESS = 0,
        SEND_OPERATING,
        SEND_FAILURE
    };
    
    enum LinkLevel
    {
        LINK_LEVEL_0,  // ɒʐMiA͒ʐMĂȂ 
        LINK_LEVEL_1,  // ʐMi 
        LINK_LEVEL_2,  // ʐMi܂ǂȂ 
        LINK_LEVEL_3   // ʐMi悢 
    };
    
    // RXgN^
    UDS_Lib() : m_DisconnectFlag( true ), m_isMonitorThreadActive( false ), m_isClientConnect( false ),
    m_ReceiveStateCount(0), m_MaxRetry( MAX_RETRY ), m_NetworkChannel(0), m_isLastSendState( SEND_SUCCESS )
    {
        m_SendBuf.StateCount = 1;
        m_UniqueID = nn::uds::CTR::CreateLocalCommunicationId( 0xFFF0F );
        m_RecvBuf = reinterpret_cast< CommunicationBuffer* >( m_RecvBufCommon );
    }
    // fXgN^
    ~UDS_Lib()
    {
    }
    
/*---------------------------------------------------------------------------
    ̗Ƃ
    1.UDS_LibCX^X쐬
    2.Initialize()
    3.SetUniqueID() // DP1płB
    4.InitUDSConnectionMaster()orInitUDSConnectionClient()
    
    ƂԂŏĂB
---------------------------------------------------------------------------*/
    
    
    
/*---------------------------------------------------------------------------
  Desc: MasterƂălbg[N\zB
        V[PTĂłB

  Args: Ȃ
  Rtns: lbg[N\z̐(ʏ͖Ő܂)
---------------------------------------------------------------------------*/  
    bool InitUDSConnectionMaster();
    
/*---------------------------------------------------------------------------
  Desc: ClientƂălbg[NXLB
        팟ĂłB

  Args: timeOut = ^CAEg܂ł̎
        TimeSpanIuWFNgƂĎw
        
  Rtns: ^CAEg܂łɃlbg[Ntrue
        ^CAEg̏ꍇfalse
---------------------------------------------------------------------------*/  
    bool InitUDSConnectionClient( nn::fnd::TimeSpan timeOut );
    
/*---------------------------------------------------------------------------
  Desc: f[^𑗐MB

  Args: sendMessage = Mf[^̓obt@ւ̃|C^
        dataSize    = Mf[^̃TCY
        
  Rtns: ȂB
        GetLastSend()őMʂ擾悤ɂĂB
---------------------------------------------------------------------------*/  
    void SendTo( const void* sendMessage, size_t dataSize );
    
/*---------------------------------------------------------------------------
  Desc: gCƂăf[^𑗐MB
        GetLastSendFailureԂĂꍇ́Af[^̃gCɎgpĂB
        Mf[^MłĂ΁AM͎Iɂ̃f[^j܂B
        ԍŏɂ̊֐Ă񂾏ꍇ͕̓sB

  Args: sendMessage = Mf[^̓obt@ւ̃|C^
        dataSize    = Mf[^̃TCY
        
  Rtns: ȂB
        GetLastSend()őMʂ擾悤ɂĂB
---------------------------------------------------------------------------*/  
    void RetrySendTo( const void* sendMessage, size_t dataSize );
    
/*---------------------------------------------------------------------------
  Desc: ŌɑMf[^̐

  Args: ȂB
        
  Rtns: SEND_SUCCESS,  : M
        SEND_OPERATING,: M
        SEND_FAILURE   : Ms
        Ԃ܂B
---------------------------------------------------------------------------*/  
    u8 GetLastSend()
    {
        return m_isLastSendState;
    }
    
/*---------------------------------------------------------------------------
  Desc: f[^M

  Args: recvMessage = Mf[^obt@ւ̃|C^
        recvSize    = f[^obt@̃TCY
        
  Rtns: f[^MĂtrueԂAobt@Ƀf[^Rs[
        f[^MĂȂꍇfalseԂAobt@ɂ͉Ȃ
---------------------------------------------------------------------------*/  
    bool Receive( void *recvBuf, size_t recvSize );
    
/*---------------------------------------------------------------------------
  Desc: lbg[NɐڑłĂ邩mF
        팟Ăł

  Args: Ȃ
        
  Rtns: ڑłĂfalse
        ؒfĂtrue
---------------------------------------------------------------------------*/  
    bool IsDisconnected()
    {
        return m_DisconnectFlag;
    }
    
/*---------------------------------------------------------------------------
  Desc: V[PX̏ꍇ̓lbg[N̂jB
        팟̓lbg[N痣EB
        {Iɂ͌Iɔ팟݂̂E
        e@͏Ƀlbg[Nێ`ɂȂB

  Args: Ȃ
        
  Rtns: Ȃ
---------------------------------------------------------------------------*/  
    void DisconnectNetwork()
    {
        if( m_isMaster )
        {
            nn::uds::DestroyNetwork();
        }else
        {
            nn::uds::DisconnectNetwork();
        }
    }
    
/*---------------------------------------------------------------------------
  Desc: ʐM֌W̃CjVCYłB
        

  Args: Ȃ
        
  Rtns: Ȃ
---------------------------------------------------------------------------*/  
    void Initialize()
    {
        nn::uds::Initialize( &statusUpdateEvent, s_UdsRecvBuffer, UDS_BUFFER_SIZE );
    }


/*---------------------------------------------------------------------------
  Desc: ʐM֌W̃t@CiCY

  Args: Ȃ
        
  Rtns: Ȃ
---------------------------------------------------------------------------*/  
    void Finalize();


/*---------------------------------------------------------------------------
  Desc: Client̐ڑ̗L

  Args: Ȃ
        
  Rtns: qĂtrueAȂfalse
---------------------------------------------------------------------------*/  
    bool IsClientConnect()
    {
        return m_isClientConnect;
    }
    
/*---------------------------------------------------------------------------
  Desc: MacAddress̎擾

  Args: charzւ̃|C^
        
  Rtns: Ȃ
---------------------------------------------------------------------------*/  
    void GetMacAddress( char* macAddress )
    {
        bit8 mac[6];
        uji::sys::GetMacAddress( mac );
    
        std::sprintf( macAddress, "%02X%02X%02X%02X%02X%02X", mac[0], mac[1], mac[2]
                                                                 , mac[3], mac[4], mac[5]);
    }
    
/*---------------------------------------------------------------------------
  Desc: ڑ̃lbg[Ñ`l擾(1 or 6 or 11)

  Args: `l
        
  Rtns: Ȃ
---------------------------------------------------------------------------*/  
    u32 GetChannel()
    {
        return m_NetworkChannel;
    }
    
/*---------------------------------------------------------------------------
  Desc: ڑ̒ʐMԂ擾

  Args: Ȃ
        
  Rtns: ʐM
        LINK_LEVEL_0 : ɒʐMiA͒ʐMĂȂ 
        LINK_LEVEL_1 : ʐMi 
        LINK_LEVEL_2 : ʐMi܂ǂȂ 
        LINK_LEVEL_3 : ʐMi悢 

---------------------------------------------------------------------------*/  
    LinkLevel GetLinkLevel();
    
    private:

    // 萔
    static const u8 SUB_ID = 0x01;                                  // AvŒʐM (ΐ/Ȃ) ؂蕪ۂɎgp ID
    static const u8  MAX_ENTRY = 3;                                  // őڑ
    static const int PACKET_SIZE = nn::uds::UDS_PACKET_PAYLOAD_MAX_SIZE;  //̃főMf[^̃TCY
    static const int MAX_RETRY = 5;

    // ϐ
    nn::os::LightEvent m_LightEvent;
    nn::os::LightEvent m_RetryEvent;
    nn::os::Event statusUpdateEvent;
    
    bit8 m_ScanBuffer[1024];                                        //XLobt@Blbg[N 1KByte xKvłB
    bool m_isMaster;
    bool m_DisconnectFlag;
    bool m_ClientConnect;
    volatile bool m_isReceiveData;
    bool m_isMonitorThreadActive;
    bool m_isEventActive;
    bool m_isClientConnect;
    bool m_isSendThreadAlive;
    bool m_isRecvThreadAlive;
    
    bit32 m_UniqueID;
    
    u16 s_NodeList[ MAX_ENTRY ];                                    // ؒfꂽm[h\邽߂̔z
    
    int m_ReceiveStateCount;
    u32 m_MaxRetry;
    u32 m_NetworkChannel;
    
    volatile u8 m_isLastSendState;

    u8 m_SendBuffer[ PACKET_SIZE / sizeof(u8) ];
    u8 m_ReceiveBuffer[ PACKET_SIZE / sizeof(u8) ];
    
    
    CommunicationBuffer m_SendBuf;
    CommunicationBuffer* m_RecvBuf;
    u8 m_ReturnBuf[1024];
    
    nn::os::Thread moniThread;
    nn::os::Thread sendThread;
    nn::os::Thread recvThread;
    
    nn::uds::LinkLevel m_linkLevel;

    
    void SendThread();
    static void WrappingSendThread( void* param );
    
    void ReceiveThread();
    static void WrappingReceiveThread( void* param );
    
    void MonitorThread();
    static void WrappingMonitorThread( void* param );
    
    bool StartConnectCommon();
    
    bool CheckDataCorrect( u32 checkSum, u8* Buffer, size_t size );
    
    
    
    u32 CreateUniqueID( bit8 MacU8[] )
    {
        return ( MacU8[2]*0x1000000 + MacU8[3]*0x10000 + MacU8[4]*0x100 + MacU8[5] );
    }
    
    //--------------------------------------------------------------------------
    // ȉAfobOp֐Af[^u
    //--------------------------------------------------------------------------
    
    public:

    void CreateMonitorThread();
    bool SaveSequencerSSID();
    
    // DP1eXgvOpj[NIDw֐
    void SetUniqueID( u32 uniqueID )
    {
        //m_UniqueID = uniqueID;
        m_UniqueID = nn::uds::CTR::CreateLocalCommunicationId( uniqueID );
    }
    
    // fobOpMR}h
    void SendTo()
    {
        m_LightEvent.Signal();
    }
    
    // fobOpMR}h
    bool Receive()
    {
        m_isReceiveData = false;
        return true;
    }
    
    void AllEventClear()
    {
        m_LightEvent.ClearSignal();
        m_RetryEvent.ClearSignal();
    }
    
    void AllEventSignal()
    {
        m_LightEvent.Signal();
        m_RetryEvent.Signal();
    }
    
    void SendThreadInit()
    {
        m_LightEvent.ClearSignal();
        m_RetryEvent.Signal();
    }
    
    void SetRetryNum( int retryNum )
    {
        m_MaxRetry = retryNum;
    }
};

} // namespace eva
} // namespace uji


#endif // UDS_LIB_H_INCLUDED
