#include <nn.h>
#include <nn/os.h>
#include <nn/Result.h>
#include <nn/hid.h>
#include <nn/uds.h>
#include "sys.h"
#include "UDS_Lib.h"

using namespace uji::sys;

//namespace
//{
//    const u32 UNIQUE_ID = 1233;
//}
//


namespace uji{
namespace eva{

//------------------------------------------------------------------------------
// o֐XbhƂċÑׂbp[
//------------------------------------------------------------------------------
void UDS_Lib::WrappingSendThread( void* param )
{
    UDS_Lib* pUDSLib = reinterpret_cast< UDS_Lib* >( param );
    pUDSLib->SendThread();
}

//------------------------------------------------------------------------------
// MXbh
//------------------------------------------------------------------------------
void UDS_Lib::SendThread()
{

    nn::uds::EndpointDescriptor ed;
    nn::Result result = nn::uds::CreateEndpoint( &ed ); //Endpoint ̐
    NN_UTIL_PANIC_IF_FAILED( result );
    u32 RetryCount = 0;
    UDS_LIB_LOG("%s is Start!\n", __func__);
    m_isSendThreadAlive = true;

    
    nn::os::Mutex mutex( false );
    while( true )
    {
        m_LightEvent.Wait();
        mutex.Lock();
        RetryCount = 0;
        m_SendBuf.CheckSum = 0;
        for( int i = 0; i < 1024; i++ )
        {
            m_SendBuf.CheckSum += m_SendBuf.Buffer[i];
        }
        // gC̏ꍇ͂ȂB
        SEND_RETRY:
        //m_isLastSendState = UDS_Lib::SEND_OPERATING;
        
        m_SendBuf.IsAck = 0;
        //m_RetryEvent.ClearSignal();
        // 3񕪂قǃf[^𑗂B
        for(int i = 0; i <= 3; i++ )
        {
            result = nn::uds::SendTo( ed, &m_SendBuf, sizeof(m_SendBuf), nn::uds::BROADCAST_NODE_ID, 1, nn::uds::NO_WAIT );

            if( result.IsFailure() )
            {
                mutex.Unlock();
                goto SEND_THREAD_END;
            }
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMicroSeconds(100));
        }
        
        // 0.01b҂
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
        
        // AckM񍐂邩mFAȂ΃gC
        if( !m_RetryEvent.TryWait() ) 
        {
            // K萔gCĂʖڂꍇ
            if( ++RetryCount >= m_MaxRetry )
            {
                // Xe[^XuMsvɂđMI
                m_isLastSendState = UDS_Lib::SEND_FAILURE;
                goto RETRY_TIMEOUT;
            }
            UDS_LIB_LOG("  Retry! Send = %x\n", m_SendBuf.StateCount );
            goto SEND_RETRY;
        // AckMĂꍇ̓V[PXԍ𑝂₵Ď̑MɔB
        }else
        {
            // Xe[^XuMvɂđMI
            m_isLastSendState = UDS_Lib::SEND_SUCCESS;
            UDS_LIB_LOG("Send Success! counter = %08x\n", m_SendBuf.StateCount );
            RETRY_TIMEOUT:
            m_SendBuf.StateCount++; // MV[PXԍ̃CNg
        }
        mutex.Unlock();
    }
    SEND_THREAD_END :
    m_isLastSendState = UDS_Lib::SEND_FAILURE;
    
    //ؒf
    UDS_LIB_LOG("DestroyEndpoint\n");
    result = nn::uds::DestroyEndpoint(&ed);
    NN_UTIL_PANIC_IF_FAILED(result);
    
    m_isSendThreadAlive = false;
    UDS_LIB_LOG("%s is Finish!\n", __func__);
}

//------------------------------------------------------------------------------
// o֐XbhƂċÑׂbp[
//------------------------------------------------------------------------------
void UDS_Lib::WrappingReceiveThread( void* param )
{
    UDS_Lib* pUDSLib = reinterpret_cast< UDS_Lib* >( param );
    pUDSLib->ReceiveThread();
}

//------------------------------------------------------------------------------
// f[^MpXbh
//------------------------------------------------------------------------------
void UDS_Lib::ReceiveThread()
{
    nn::uds::EndpointDescriptor ed;
    nn::Result result;
    result = nn::uds::CreateEndpoint(&ed);  //Endpoint ̐
    NN_UTIL_PANIC_IF_FAILED(result);
    
    result = nn::uds::Attach(&ed, nn::uds::BROADCAST_NODE_ID, 1 );  //Endpoint ̎MݒBMOɕKsĂB
    NN_UTIL_PANIC_IF_FAILED(result);
    
    UDS_LIB_LOG("%s is Start!\n", __func__);

    u16    srcNodeId;
    size_t recvedSize;
    
    nn::os::CriticalSection cs;
    cs.Initialize();
    
    while(true)
    {
       // f[^̎M
       result = nn::uds::ReceiveFrom( ed, m_RecvBuf, &recvedSize, &srcNodeId, sizeof( CommunicationBuffer ) );
       cs.Enter();
       if( result.IsFailure() )
       {
           break;
       }
       
       // Ack(BmFp)tO̊mF
       if( m_RecvBuf->IsAck == 0 )
       {
           if( CheckDataCorrect( m_RecvBuf->CheckSum, m_RecvBuf->Buffer, 1024 ))
           {
               // Ackł͂ȂꍇAMV[PXԍ̊mF
               if( m_ReceiveStateCount <= m_RecvBuf->StateCount )
               {   
                   if( m_ReceiveStateCount < m_RecvBuf->StateCount )
                   {
                       // Mf[^ێĂ鑗MV[PXԍ傫ꍇA
                       // MV[PXԍ킹B
                       m_ReceiveStateCount = m_RecvBuf->StateCount;
                       UDS_LIB_LOG( "Recv From:%02u, counter=%08x, size=%d Byte\n", srcNodeId, m_RecvBuf->StateCount, recvedSize );
                        memcpy( m_ReturnBuf, &m_RecvBuf->Buffer, 1024 );
                        m_isReceiveData = true;
                    }
                    
                    // AcktO𗧂ĂāAAckt[𑗐M
                    m_RecvBuf->IsAck = 1;
                    for( int i = 0; i <= 3; i++ )
                    {
                        result = nn::uds::SendTo( ed, m_RecvBuf, sizeof( CommunicationBuffer ), nn::uds::BROADCAST_NODE_ID, 1, nn::uds::NO_WAIT );
                        if( result.IsFailure() )
                        {
                            break;
                        }
                        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMicroSeconds(100));
                    }
                }
            }
        // AckMꍇAMXbhɃtO𑗂B
        }else if( m_RecvBuf->IsAck == 1 )
        {
            if( m_SendBuf.StateCount == m_RecvBuf->StateCount )
            {
                m_RetryEvent.Signal();
            }
        }
        cs.Leave();

    }
    UDS_LIB_LOG("DestroyEndpoint\n");
    result = nn::uds::DestroyEndpoint(&ed);
    NN_UTIL_PANIC_IF_FAILED(result);
    

    UDS_LIB_LOG("%s is Finish!\n", __func__);
}


//------------------------------------------------------------------------------
// o֐XbhƂċN邽߂̃bp[
//------------------------------------------------------------------------------
void UDS_Lib::WrappingMonitorThread( void* param )
{
    UDS_Lib* pUDSLib = reinterpret_cast< UDS_Lib* >( param );
    pUDSLib->MonitorThread();
}

//------------------------------------------------------------------------------
// ĎXbh
//------------------------------------------------------------------------------
void UDS_Lib::MonitorThread()
{
    m_DisconnectFlag = false;
    
    nn::Result result;
    
    
    result = sendThread.TryStartUsingAutoStack ( WrappingSendThread, this, 4096 );
    //result = sendThread.TryStartUsingAutoStack ( WrappingSendThread, this, 4096 );
    //NN_UTIL_PANIC_IF_FAILED( result );
    result = recvThread.TryStartUsingAutoStack ( WrappingReceiveThread, this, 4096 );
    //NN_UTIL_PANIC_IF_FAILED( result );
    UDS_LIB_LOG("Now %d\n", __LINE__);

    UDS_LIB_LOG("%s is Start!\n", __func__);

    
    while(true)
    {
        // statusUpdateEvent ̓lbg[N̏Ԃω (܂߂ڑؒf̔) ꍇ Signal ܂B
        if( statusUpdateEvent.Wait( nn::fnd::TimeSpan::FromMilliSeconds(100)))
        {
            UDS_LIB_LOG("Signal!\n");
            nn::uds::ConnectionStatus connectionStatus;
            result = nn::uds::GetConnectionStatus(&connectionStatus);
            NN_UTIL_PANIC_IF_FAILED(result);
            
            
            
            m_ReceiveStateCount = 0;

            if( connectionStatus.nowState ) //ڑԂ̃`FbN
            {
                UDS_LIB_LOG("State is Update!(Now=%d, NodeId=%d)\n", connectionStatus.nowState, connectionStatus.myNodeId );

                if( connectionStatus.nowState != nn::uds::STATE_MASTER && connectionStatus.nowState != nn::uds::STATE_CLIENT )
                {
                    // lbg[Nؒfꂽ
                    if( m_isMaster )
                    {
                        // Master lbg[N𗣒Eꍇ DestroyNetwork() sꍇɌ܂B
                        UDS_LIB_LOG("Destruct! Reason = %d\n", connectionStatus.disconnectReason);
                        break;
                    }
                    else
                    {
                        // Client / Audience  DisconnectNetwork() sȊOɁAMaster  EjectClient() sꍇ
                        // ʐMێłȂꍇɂlbg[Nؒf܂B

                        UDS_LIB_LOG("Disconnect! Reason = %d\n", connectionStatus.disconnectReason); //ؒfR
                        
                        result = nn::uds::DisconnectNetwork(); //sĂsȂĂ肠܂B
                        NN_UTIL_PANIC_IF_FAILED(result);
                        m_DisconnectFlag = true;
                        break;
                    }
                }
            }
            for(int i = 0;i < MAX_ENTRY; i++) //m[hXgAbv
            {
                if( connectionStatus.updateNodeBitmap&(0x0001 << i ))
                {
                    //ω
                    if( connectionStatus.nodeIdList[i] != 0 )
                    {
                        if( connectionStatus.nodeIdList[i] != connectionStatus.myNodeId )
                        {
                            //VKڑ
                            nn::uds::NodeInformation nodeInfo;
                            UDS_LIB_LOG("Connect New Node!: %d\n", connectionStatus.nodeIdList[i]);
                            result = nn::uds::GetNodeInformation( &nodeInfo, connectionStatus.nodeIdList[i] );
                            if( result.IsFailure() )
                            {
                                continue;
                            }
                            //O̕\
                            char name[11];
#if 1
                            std::wcstombs( name, nodeInfo.userName.userName, 10 );
#endif
                            name[10] = '\0';
                            UDS_LIB_LOG( "  Name: %s\n", name);
                            
                            m_isClientConnect = true;
                        }
                    }
                    else
                    {
                        // ωꏊ NodeID=0 łꍇAȑOڑĂm[hؒfƂ܂B
                        UDS_LIB_LOG("Disconnect Node!: %d\n", s_NodeList[i]);
                        m_isClientConnect = false;
                        m_isLastSendState = SEND_FAILURE;
                    }
                    
                    s_NodeList[i] = connectionStatus.nodeIdList[i];
                }
            }
            
            //Nx̎擾
            {
                nn::uds::GetLinkLevel(&m_linkLevel);
                
                UDS_LIB_LOG("LinkLevel = %d\n", m_linkLevel);
            }
        }
        
        if( !m_isSendThreadAlive )
        {
            if( !m_isMaster )
            {
                DisconnectNetwork();
            }else
            {
                sendThread.Join();
                sendThread.Finalize();
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromSeconds(1));
                result = sendThread.TryStartUsingAutoStack ( WrappingSendThread, this, 4096 );
            }
        }


    }
    m_LightEvent.Signal();
    
    sendThread.Join();
    recvThread.Join();
    
    sendThread.Finalize();
    recvThread.Finalize();
    
    //nn::uds::Finalize();
    
    UDS_LIB_LOG("%s is Finish!\n", __func__);
}

//------------------------------------------------------------------------------
// eƂălbg[N쐬
//------------------------------------------------------------------------------
bool UDS_Lib::InitUDSConnectionMaster()
{
    nn::Result result;
    //result = nn::uds::Initialize( &statusUpdateEvent, 4096*20 );
    //NN_UTIL_PANIC_IF_FAILED(result);
    //if( result.IsFailure())
    //{
    //    return false;
    //}
    
    int Rand = nn::os::Tick::GetSystemCurrent().ToTimeSpan().GetMicroSeconds();
    int Random = Rand % 3;
    m_NetworkChannel = 1 + ( 5*Random );
    UDS_LIB_LOG("Rand = %d Random = %d Ch = %d\n", Rand, Random, m_NetworkChannel );

    m_isMaster = true;
    
    if( m_isEventActive )
    {
        m_LightEvent.Finalize();
        m_RetryEvent.Finalize();
        m_isEventActive = false;
    }
    
    
    m_LightEvent.Initialize(false);
    m_RetryEvent.Initialize(false);
    m_isEventActive = true;
    

    //lbg[N̍\z
    result = nn::uds::CreateNetwork( SUB_ID, MAX_ENTRY, m_UniqueID, PASSPHRASE, sizeof(PASSPHRASE), m_NetworkChannel );
    //NN_UTIL_PANIC_IF_FAILED(result);  
    if( result.IsFailure())
    {
        return false;
    }
    
    CreateMonitorThread();
    return true;

}

//------------------------------------------------------------------------------
// qƂălbg[NAڑ
//------------------------------------------------------------------------------
bool UDS_Lib::InitUDSConnectionClient( nn::fnd::TimeSpan timeOut )
{
    if( m_isEventActive )
    {
        m_LightEvent.Finalize();
        m_RetryEvent.Finalize();
        m_isEventActive = false;
    }
    
    
    m_LightEvent.Initialize(false);
    m_RetryEvent.Initialize(false);
    m_isEventActive = true;
    
    //nn::uds::Initialize( &statusUpdateEvent, 4096*20 );
    nn::Result result;
    m_isMaster = false;
    


    nn::fnd::TimeSpan StartTimeSpan = nn::os::Tick::GetSystemCurrent().ToTimeSpan();
    RETRY_CONNECT:
    while(true)
    {
        if( timeOut.GetSeconds() < ( nn::os::Tick::GetSystemCurrent().ToTimeSpan().GetSeconds() - StartTimeSpan.GetSeconds() ))
        {
            //nn::uds::Finalize();
            return false;
            
        }
        result = nn::uds::Scan( m_ScanBuffer, sizeof(m_ScanBuffer), SUB_ID, m_UniqueID );
        //NN_UTIL_PANIC_IF_FAILED(result);
        if( result.IsFailure())
        {
            return false;
        }
        
        //XLʂ̉
        
        if( StartConnectCommon())
        {
            break;
        }
    }
    CreateMonitorThread();
    return true;
}

//------------------------------------------------------------------------------
// ڑ
//------------------------------------------------------------------------------
bool UDS_Lib::StartConnectCommon()
{
    nn::Result result;
    nn::uds::ScanResultReader networkList( m_ScanBuffer );
    //ŏɌlbg[Nɐڑ
    if( 0 != networkList.GetCount() ) 
    {
        UDS_LIB_LOG("Scan != 0\n");
        nn::uds::NetworkDescriptionReader netDescReader = networkList.GetNextDescription();
        nn::uds::NetworkDescription netDesc;
        result = netDescReader.GetNetworkDescription(&netDesc);
        if( result.IsFailure() )
        {
            return false;
        }
        
        result = nn::uds::ConnectNetwork( netDesc, nn::uds::CONNECT_AS_CLIENT, PASSPHRASE, sizeof(PASSPHRASE) );
        m_NetworkChannel = netDesc.GetChannel();
        UDS_LIB_LOG("ConnectChannel = %d\n", m_NetworkChannel );

        if( result.IsFailure() )
        {
            ////ڑɎs (XL蒼)
            switch( result.GetValue() )
            {
                case nn::uds::ResultNotFoundNetwork::Value :
                {
                    // Ώۂ̃lbg[Nł܂ł
                    NN_LOG(" nn::uds::ConnectNetwork is Failed ( Not Found )\n");
                }
                break;
                case nn::uds::ResultAlreadyNetworkIsFull::Value :
                {
                    // ڑ䐔ɍőł
                    NN_LOG(" nn::uds::ConnectNetwork is Failed ( Max Connection )\n");
                }
                break;
                case nn::uds::ResultDeniedFromMaster::Value :
                {
                    // Master ɐڑۂ܂
                    NN_LOG(" nn::uds::ConnectNetwork is Failed ( Denied )\n");
                }
                break;
                case nn::uds::ResultConnectionTimeout::Value :
                {
                    // Ώۂ̃lbg[N͔ł܂ Master ̉܂ł
                    NN_LOG(" nn::uds::ConnectNetwork is Failed ( Timeout )\n");
                }
                break;
                case nn::uds::ResultWirelessOff::Value :
                {
                    //  OFF [hɂȂ܂
                    NN_LOG(" nn::uds::ConnectNetwork is Failed ( Wireless Off )\n");
                }
                break;
                case nn::uds::ResultInvalidState::Value :
                default:
                {
                    //̃fł̓Xe[gႢ̃G[͏oȂ͂Ȃ̂ Panic 悤ɂĂ܂
                    NN_PANIC(" nn::uds::ConnectNetwork is Failed (Other)");
                }
            }
            nn::uds::DisconnectNetwork();
        }
        else
        {
            return true; //ڑɐ̂Ŏ̏Ɉȍ~
        }
    }
    else
    {
        UDS_LIB_LOG("Scan = 0\n");
    }
    return false;
}

//------------------------------------------------------------------------------
// ԊĎXbh̍쐬
//------------------------------------------------------------------------------
void UDS_Lib::CreateMonitorThread()
{
    UDS_LIB_LOG("Now %d\n", __LINE__);
    if( m_isMonitorThreadActive )
    {
        moniThread.Join();
        moniThread.Finalize();
        m_isMonitorThreadActive = false;
    }
    UDS_LIB_LOG("Now %d\n", __LINE__);
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
    nn::Result result;
    moniThread.TryStartUsingAutoStack( WrappingMonitorThread, this, 4096 );
    //NN_UTIL_PANIC_IF_FAILED( result );
    m_isMonitorThreadActive = true;
}

//------------------------------------------------------------------------------
// I
//------------------------------------------------------------------------------
void UDS_Lib::Finalize()
{
    if( m_isMonitorThreadActive )
    {
        moniThread.Join();
        moniThread.Finalize();
        m_isMonitorThreadActive = false;
    }
    //if( m_isEventActive )
    {
        m_LightEvent.Finalize();
        m_RetryEvent.Finalize();
        m_isEventActive = false;
    }
    nn::uds::Finalize();
    
}

//------------------------------------------------------------------------------
// f[^M֐BMpobt@Ƀf[^l߂AMXbhNB
//------------------------------------------------------------------------------
void UDS_Lib::SendTo( const void* sendMessage, size_t dataSize )
{
    if(( m_isMaster && IsClientConnect()) || ( !m_isMaster && !IsDisconnected()))
    {
        UDS_LIB_LOG("Call SendTo\n");
        m_isLastSendState = UDS_Lib::SEND_OPERATING;
        memcpy( &m_SendBuf.Buffer, sendMessage, dataSize );
        m_LightEvent.Signal();
    }
}

//------------------------------------------------------------------------------
// Ms̃gCƂẴf[^M֐
// MV[PXԍCNgȂ
//------------------------------------------------------------------------------
void UDS_Lib::RetrySendTo( const void* sendMessage, size_t dataSize )
{
    if(( m_isMaster && IsClientConnect()) || ( !m_isMaster && !IsDisconnected()))
    {
        UDS_LIB_LOG("Call RetrySendTo\n");
        m_isLastSendState = UDS_Lib::SEND_OPERATING;
        memcpy( &m_SendBuf.Buffer, sendMessage, dataSize );
        if( m_SendBuf.StateCount > 0 )
        {
            m_SendBuf.StateCount--;
        }
        m_LightEvent.Signal();
    }
}

//------------------------------------------------------------------------------
// f[^̎MBobt@Ƀf[^܂Ă΁Af[^Rs[
//------------------------------------------------------------------------------
bool UDS_Lib::Receive( void *recvBuf, size_t recvSize )
{
    if( !m_isReceiveData )
    {
        return false;
    }else
    {
        memcpy( recvBuf, &m_ReturnBuf, recvSize );
        m_isReceiveData = false;
        return true;
    }
}

bool UDS_Lib::CheckDataCorrect( u32 checkSum, u8* Buffer, size_t size )
{
    u32 MyCheckSum = 0;
    for( int i = 0; i < size; i++ )
    {
        MyCheckSum += Buffer[i];
    }
    if( MyCheckSum == checkSum )
    {
        return true;
    }else
    {
        UDS_LIB_LOG("CheckSum Error!\n");
        return false;
    }
}


//------------------------------------------------------------------------------
// LinkLevel̎擾s
//------------------------------------------------------------------------------

UDS_Lib::LinkLevel UDS_Lib::GetLinkLevel()
{
    if( m_isMaster )
    {
        if( m_isClientConnect )
        {
            return static_cast< UDS_Lib::LinkLevel >( m_linkLevel );
        }else
        {
            return LINK_LEVEL_0;
        }
        
    }else
    {
        if( !m_DisconnectFlag )
        {
            return static_cast< UDS_Lib::LinkLevel >( m_linkLevel );
        }else
        {
            return LINK_LEVEL_0;
        }
    }
}

//------------------------------------------------------------------------------
// V[PT肷ׂID̓o^@\
//------------------------------------------------------------------------------
bool UDS_Lib::SaveSequencerSSID()
{
    /*
    //if( !nn::fs::IsInitialized() )
    //{
    //    UDS_LIB_LOG("FS NOT INIT\n");
        nn::fs::Initialize();
    }
    
    const u16 FONT_SIZE = 14;
    uji::sys::GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::sys::WindowManager   windowManager;
    uji::sys::InputTextWindow inputWindow( 240/(FONT_SIZE/2), 180/FONT_SIZE, FONT_SIZE, windowManager );
    windowManager.CreateWindow( &inputWindow, NN_GX_DISPLAY0, 0, 0 );
    
    nn::Result result;
    nn::fs::FileOutputStream fsOut;
    result = fsOut.TryInitialize( MAC_ADDRESS_FILE_PATH, true );
    
    NN_UTIL_PANIC_IF_FAILED(result);
    //if( result.IsFailure() )
    //{
    //    return false;
    //}
    
    //fsOut.SetPosition( 0 );
    
    //UDS_LIB_LOG("inSaveSequencerSSID\n");
    
    const u8 MAC_ADDRESS_OCTET = 6;
    bit8 MacU8[ MAC_ADDRESS_OCTET ] = "";
    
    int cursor = 0;
    
    while( true )
    {
        inputWindow.Printf("\f");
        inputWindow.Printf("SetSequencerMacAddress!\n");
        inputWindow.Printf("Press Start to Return!\n\n");
        uji::sys::Pad().UpdatePad();
        
        if( uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_LEFT  )){ cursor--; }
        if( uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_RIGHT )){ cursor++; }
        if( cursor < 0 ){ cursor = MAC_ADDRESS_OCTET - 1; }
        if( cursor > MAC_ADDRESS_OCTET - 1 ){ cursor = 0; }
        
        
        for( int i = 0; i < MAC_ADDRESS_OCTET; i++ )
        {
            if( i == cursor )
            {
                inputWindow.SetTextColor( ATTR_COLOR_CYAN );
            }
            inputWindow.Printf("%02X", MacU8[i]);
            inputWindow.SetTextColor( ATTR_COLOR_WHITE );
            
            if( i < MAC_ADDRESS_OCTET - 1 )
            {
                inputWindow.Printf(":");
            }
        }
        
        if( uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_A ))
        {
            inputWindow.Gotoxy( cursor * 3, 3 );
            MacU8[ cursor ] = inputWindow.InputData8( MacU8[ cursor ]);
            cursor++;
        }
        
        if( uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_START )) { break; }
        
        // ʕ`
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
        gfx->m_DrawFramework->Clear();
        windowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        
    }
        

    
    UDS_LIB_LOG("input = %02X:%02X:%02X:%02X:%02X:%02X\n", MacU8[0], MacU8[1], MacU8[2]
                                                    , MacU8[3], MacU8[4], MacU8[5]);
                                                    
    fsOut.Write( MacU8, sizeof( MacU8 ) );
    
    u32 newunique = CreateUniqueID( MacU8 );
    UDS_LIB_LOG("newUniqueID = %X\n", newunique );
    
    nn::os::Event statusUpdateEvent;
#if 1
    nn::uds::Initialize( &statusUpdateEvent, m_UdsRecvBuffer, UDS_BUFFER_SIZE );
#endif    
    bit8 MacU8_2[6];
    nn::uds::GetMacAddress( MacU8_2 );
    
    u32 newunique2 = CreateUniqueID( MacU8_2 );
    UDS_LIB_LOG("get   = %02X:%02X:%02X:%02X:%02X:%02X\n", MacU8_2[0], MacU8_2[1], MacU8_2[2]
                                                    , MacU8_2[3], MacU8_2[4], MacU8_2[5]);
    UDS_LIB_LOG("newUniqueID = %X\n", newunique2 );
    
    nn::uds::Finalize();
    
        
    // ʕ`
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
    gfx->m_DrawFramework->Clear();
    windowManager.DrawDisplay0();
    gfx->m_DrawFramework->SwapBuffers();
    
    windowManager.DestroyWindow( &inputWindow );
    inputWindow.Destroy();
    */
    return true;
    
}

    
} // namespace eva
} // namespace uji
