/************************************************************************

 C_pȈՖvO

 *************************************************************************/

#ifndef TEST_WIRELESS_FOR_SC_INCLUDED
#define TEST_WIRELESS_FOR_SC_INCLUDED

#include <nn.h>
#include <nn/ac/CTR/private/ac_Internal.h>
#include <nn/ac/CTR/private/ac_InternalApi.h>
#include <nn/ac/CTR/private/ac_PrivateApi.h>
#include <nn/ac/CTR/private/ac_NetworkSetting.h>
#include <nn/mp.h>

#include "sys.h"
#include "../seq/TestResult.h"
#include "CommandUtil.h"

namespace uji{
namespace eva{

class TestWirelessForSC
{
//-----------------------------------------------------------------------------------------
// 
//-----------------------------------------------------------------------------------------
    public:
    TestWirelessForSC() :   gfx( uji::sys::GraphicsDrawing::GetInstance()),
                            m_UpperWindow( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE )
    {
        m_UpperWindow.SetTitle("Wireless Test");
        uji::sys::Menu::m_WindowManager.CreateWindow( &m_UpperWindow, NN_GX_DISPLAY0, 0, 0 );
    }
    
    ~TestWirelessForSC()
    {
        uji::sys::Menu::m_WindowManager.DestroyWindow( &m_UpperWindow );
    }
    void SaveAPSetting();
    private:
    static const int FONT_SIZE = 14;
    void DrawDisplays( s32 display );

    bool SetNetworkSettingFromData( nn::ac::CTR::NetworkSetting* networkSetting );
    bool GetSettingStrings( const char* source, const char* search, char* returnStr );
    bool SaveAPSettingCommon( uji::seq::TestResult& result );

    
    uji::sys::GraphicsDrawing* gfx;
    uji::sys::TextWindow m_UpperWindow;
    
    
    
//-----------------------------------------------------------------------------------------
// TestAP
//-----------------------------------------------------------------------------------------
    public:
    
    static void ExecuteTestAP()
    {
        TestWirelessForSC tWFC;
        uji::eva::CommandUtil::CheckWifiMode();
        tWFC.TestAP();
    }
    
    static void ExecuteSaveAPSetting()
    {
        TestWirelessForSC tWFC;
        tWFC.SaveAPSetting();
    }

    private:
    void TestAP();
    bool TestAPCommon( uji::seq::TestResult &result, nn::ac::CTR::NetworkSetting* networkSetting );

    u8 GetRssi8( u8 rssi )
    {
        if ( rssi & 0x0002 )
        {
            return static_cast<u8>( rssi >> 2 );
        }
        return static_cast<u8>(( rssi >> 2 ) + 25 );
    }

    

/*
//-----------------------------------------------------------------------------------------
// TestMP
//-----------------------------------------------------------------------------------------
    public:
    
    static void ExecuteTestMPMaster()
    {
        TestWirelessForSC tWFC;
        uji::eva::CommandUtil::CheckWifiMode();
        tWFC.TestMPMaster();
    }
    
    private:
    
    
    
    
    
    static void WrappingTestMPMasterReceiveThread( void* param )
    {
        TestWirelessForSC* pTwfsc = reinterpret_cast< TestWirelessForSC* >( param );
        pTwfsc->TestMPMasterReceiveThread();
    }
    
    
    void TestMPMasterReceiveThread();
    void TestMPMaster();
    bool TestMPMasterCommon( uji::seq::TestResult& result );

    static const int COMM_DATA_PORT = 8;
    static const u32 GGID              = 0x003fff10; //TWLƍ킹Kv
    static const u8 CHANNEL            = 1;
    static const u8 DATA_SIZE          = 1;
    static const u8 FREQUENCY          = 1; //V[PVʐM̎
    
    

    nn::mp::CTR::Config  m_Config;
    bool m_IsMasterRecvFinished;
    
*/
};


} // namespace eva
} // namespace uji

#endif
