#include "TestWirelessForSC.h"

namespace
{

}



void uji::eva::TestWirelessForSC::TestAP()
{

    uji::seq::TestResult result;
    
    nn::ac::CTR::NetworkSetting networkSetting;
    std::memset( &networkSetting, 0x00, sizeof( networkSetting ));
    nn::fs::MountSaveData();
    if( !SetNetworkSettingFromData( &networkSetting ))
    {
        m_UpperWindow.Printf("Load APSetting Error!\n");
        m_UpperWindow.Printf("Please Import APSetting!\n");
        m_UpperWindow.Printf("\nPress B to Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        do
        {
            uji::sys::Pad().UpdatePad();
        }while( !uji::sys::Pad().IsButtonPress( uji::sys::Pad::BUTTON_B ));
        
        nn::fs::Unmount("data:");
        return;
    }
    nn::fs::Unmount("data:");
    m_UpperWindow.Printf("Connect AP Test\n");
    m_UpperWindow.Printf("\n");
    m_UpperWindow.Printf("Press A To Start Wireless Test!\n");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    do
    {
        uji::sys::Pad().UpdatePad();
    }while( !uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_A ));
    
    m_UpperWindow.Printf("Start Wifi Test     ");
    DrawDisplays( NN_GX_DISPLAY0 );
    if( !TestAPCommon( result, &networkSetting ))
    {
        m_UpperWindow.Printf("NG\n");
    }
    
    m_UpperWindow.Printf("%s\n", result.m_String );
    m_UpperWindow.Printf("\nPress B to Return\n");
    DrawDisplays( NN_GX_DISPLAY0 );
     
    do
    {
        uji::sys::Pad().UpdatePad();
    }while( !uji::sys::Pad().IsButtonPress( uji::sys::Pad::BUTTON_B ));



}

bool uji::eva::TestWirelessForSC::TestAPCommon( uji::seq::TestResult &result, nn::ac::CTR::NetworkSetting* networkSetting )
{
    nn::Result nnResult;
    
    //const char m_AP_SSID[] = "TEST_FOR_REPAIR";
    result.m_Result = true;
    int apRSSI = 0;
    int mpRSSI = 0;
    u8  apChannel = 0;
    

    nnResult = nn::ac::CTR::InitializeInternal(); // nn::ac̃C^[ȉ
    if( nnResult.IsFailure())
    {
        nn::ac::Finalize();
        
        result.m_Result = false;
        std::sprintf( result.m_String, "Initialize Error");
        return result.m_Result;
        
    }
    
    nn::ac::CTR::NetworkSetting backupSetting;
    std::memset( &backupSetting, 0x00, sizeof( backupSetting ));
    bool isBackUpSuccess = true;
    nnResult = nn::ac::CTR::LoadNetworkSetting( 0, backupSetting );
    if( nnResult.IsFailure())
    {
        isBackUpSuccess = false;
    }
    
    
    nnResult = nn::ac::CTR::UpdateNetworkSetting( 0, *networkSetting );
    if( nnResult.IsFailure())
    {
        
        result.m_Result = false;
        std::sprintf( result.m_String, "NetworkSetting Error");
        goto TEST_AP_END;
    }
    

    nn::ac::Config config;
    nn::ac::CreateDefaultConfig( &config );
    nn::ac::CTR::SetNetworkArea( &config, nn::ac::NETWORK_AREA_LAN );

    nnResult = nn::ac::ConnectWithoutEula( config );
    if( nnResult.IsFailure())
    {
        result.m_Result = false;
        std::sprintf( result.m_String, "AP Connect Error");
        nn::dbg::PrintResult( nnResult );
        goto TEST_AP_END;
    }    

    
    {
        nn::ac::CTR::AccessPoint AP;
        nnResult = nn::ac::CTR::GetConnectingAccessPoint( &AP );
        if( nnResult.IsFailure())
        {
            result.m_Result = false;
            std::sprintf( result.m_String, "AP Get Infomation Error");
            goto TEST_AP_END;
        }    
        
        result.m_Result = true;
        apRSSI = AP.rssi;
        apChannel = AP.channel;
    }
    
    TEST_AP_END:
    
    if( isBackUpSuccess )
    {
        nn::ac::CTR::UpdateNetworkSetting( 0, backupSetting );
        nn::ac::CTR::FlushNetworkSetting();
        
    }else
    {
        nn::ac::CTR::RemoveNetworkSetting( 0 );
    }
    nnResult = nn::ac::FinalizeInternal();
    if( nnResult.IsFailure() && result.m_Result )
    {
        result.m_Result = false;
        std::sprintf( result.m_String, "Finalize Error");
    }

    nnResult = nn::ac::Finalize();
    if( nnResult.IsFailure() && result.m_Result )
    {
        result.m_Result = false;
        std::sprintf( result.m_String, "Finalize Error");
    }
    if( !result.m_Result )
    {
        return result.m_Result;
    }else
    {
        m_UpperWindow.Printf("OK!\n");
        m_UpperWindow.Printf("Start MP Test       ");
        DrawDisplays( NN_GX_DISPLAY0 );
    }
    
    nnResult = nn::mp::CTR::Initialize();
    if( nnResult.IsFailure())
    {
        result.m_Result = false;
        std::sprintf( result.m_String, "MP Initialize Error");
        return result.m_Result;
    }
    
    nnResult = nn::mp::CTR::SetPortConfig( 0, true, 0 );
    if( nnResult.IsFailure())
    {
        result.m_Result = false;
        std::sprintf( result.m_String, "MP Initialize Error");
        goto TEST_MP_END;
    }
    
    nn::mp::CTR::Config mpConfig;
    nn::mp::CTR::BssDesc bssDesc[ NN_MP_SCAN_BSS_MAX ];

    mpConfig.mode = NN_MP_MODE_CHILD;
    mpConfig.recvmode = NN_MP_RECVMODE_PORT;
    
    nnResult = nn::mp::CTR::Start( &mpConfig );
    if( nnResult.IsFailure())
    {
        result.m_Result = false;
        std::sprintf( result.m_String, "MP Start Error");
        goto TEST_MP_END;
    }
    
    nn::mp::CTR::ScanParam param;
    std::memset( &param, 0, sizeof( nn::mp::CTR::ScanParam ));
    param.channelBits = 0x0001 << ( apChannel - 1 );
    param.maxChannelTime = 500;
    param.descNum = NN_MP_SCAN_BSS_MAX; // őXL
    std::memset( param.bssid, 0xff, 6 );    // SMACAhXΏ
    
    nnResult = nn::mp::CTR::Scan( bssDesc, &param, NN_MP_SCANTYPE_ACTIVE );;
    if( nnResult.IsFailure())
    {
        nn::dbg::PrintResult( nnResult );
        result.m_Result = false;
        std::sprintf( result.m_String, "MP Scan Error");
        nn::mp::CTR::Stop();
        goto TEST_MP_END;
    }
    
    for ( int i = 0; i < NN_MP_SCAN_BSS_MAX; i++ )
    {
        if( 0 == std::strcmp( reinterpret_cast<char*>( networkSetting->wireless.essidSecurity.ssid ),
                              reinterpret_cast<char*>( bssDesc[i].ssid )))
        {
            mpRSSI = GetRssi8( bssDesc[i].rssi );

            nnResult = nn::mp::CTR::Stop();
            if( nnResult.IsFailure())
            {
                result.m_Result = false;
                std::sprintf( result.m_String, "MP Stop Error");
                goto TEST_MP_END;
            }
            
            result.m_Result = true;
            goto TEST_MP_END;

        }
    }
    result.m_Result = false;
    std::sprintf( result.m_String, "MP Test Error");
    
    TEST_MP_END:
    
    nnResult = nn::mp::CTR::Finalize();
    
    if( nnResult.IsFailure() && result.m_Result )
    {
        result.m_Result = false;
        std::sprintf( result.m_String, "MP Finalize Error");
    }

    if( result.m_Result )
    {
        std::sprintf( result.m_String, "OK!\n\nWireless Test OK!\nAP RSSI = %d MP RSSI = %d", apRSSI, mpRSSI );
    }
    
    return result.m_Result;
    
}

bool uji::eva::TestWirelessForSC::SetNetworkSettingFromData( nn::ac::CTR::NetworkSetting* networkSetting )
{

    NN_LOG("Start FromSD\n");
    nn::Result result;
    
    result = nn::ac::CTR::InitializeInternal(); // nn::ac̃C^[ȉ
    
    if( result.IsFailure())
    {
        NN_LOG("ac Initialize Error\n");
        return false;
    }
    
    nn::fs::FileInputStream fsRead;
    result = fsRead.TryInitialize( L"data:/uji/APSetting.txt");
    if( result.IsFailure())
    {
        NN_LOG("fs Initialize Error\n");
        return false;
    }
    
    s64 fileSize;
    
    result = fsRead.TryGetSize( &fileSize );
    if( result.IsFailure())
    {
        NN_LOG("GetSize Error\n");
        return false;
    }
    
    char* readBuf = new char[ fileSize + 1 ];
    
    s32 readSize;
    result = fsRead.TryRead( &readSize, readBuf, fileSize );
    if( result.IsFailure())
    {
        NN_LOG("Read Error\n");
        delete[] readBuf;
        return false;
    }
    
    memset( networkSetting, 0x00, sizeof( networkSetting ));
    
    {
        char SSIDStr[64] = "";
        if( !GetSettingStrings( readBuf, "SSID", SSIDStr ))
        {
            delete[] readBuf;
            return false;
        }
    
        NN_LOG("ReadSSID=%s\n", SSIDStr );
        //NN_LOG("ReadLen=%d\nN-WAP0001Len=%d\n", std::strlen( SSIDStr ), std::strlen("N-WAP0001"));
        std::memcpy( networkSetting->wireless.essidSecurity.ssid, SSIDStr, std::strlen( SSIDStr ));
        networkSetting->wireless.essidSecurity.ssidLength = std::strlen( SSIDStr );
    }
    {
        char SecurityModeStr[40] = "";
        
        if( !GetSettingStrings( readBuf, "SecurityMode", SecurityModeStr ))
        {
            delete[] readBuf;
            return false;
        }
            
        NN_LOG("ReadSecurityMode=%s\n", SecurityModeStr );
        if( 0 == std::strcmp( SecurityModeStr, "OPEN"))
        {
            networkSetting->wireless.essidSecurity.securityMode  = nn::ac::OPEN;
        }else if( 0 == std::strcmp( SecurityModeStr, "WEP_40BIT"))
        {
            networkSetting->wireless.essidSecurity.securityMode  = nn::ac::WEP_40BIT;
        }else if( 0 == std::strcmp( SecurityModeStr, "WEP_104BIT"))
        {
            networkSetting->wireless.essidSecurity.securityMode  = nn::ac::WEP_104BIT;
        }else if( 0 == std::strcmp( SecurityModeStr, "WEP_128BIT"))
        {
            networkSetting->wireless.essidSecurity.securityMode  = nn::ac::WEP_128BIT;
        }else if( 0 == std::strcmp( SecurityModeStr, "WPA_TKIP"))
        {
            networkSetting->wireless.essidSecurity.securityMode  = nn::ac::WPA_TKIP;
        }else if( 0 == std::strcmp( SecurityModeStr, "WPA2_TKIP"))
        {
            networkSetting->wireless.essidSecurity.securityMode  = nn::ac::WPA2_TKIP;
        }else if( 0 == std::strcmp( SecurityModeStr, "WPA_AES"))
        {
            networkSetting->wireless.essidSecurity.securityMode  = nn::ac::WPA_AES;
        }else if( 0 == std::strcmp( SecurityModeStr, "WPA2_AES"))
        {
            networkSetting->wireless.essidSecurity.securityMode  = nn::ac::WPA2_AES;
        }else
        {
            NN_LOG("Can't Set SecurityMode %s\n", SecurityModeStr );
            //NN_LOG("cmp = %d\n", std::strcmp( SecurityModeStr, "WPA2_AES") );
            //NN_LOG("Len = %d\n", std::strlen( SecurityModeStr ));
            //NN_LOG("Le2 = %d\n", std::strlen( "WPA2_AES" ));
            return false;
        }
    }
    char SecurityKeyStr[64] = "";
    if( networkSetting->wireless.essidSecurity.securityMode != nn::ac::OPEN )
    {
        if( !GetSettingStrings( readBuf, "SecurityKey", SecurityKeyStr ))
        {
            delete[] readBuf;
            return false;
        }
        
        //memset( SecurityKeyStr, 0x00, sizeof( SecurityKeyStr ));
        //SecurityKeyStr[0] = '1';
        //SecurityKeyStr[1] = '2';
        //SecurityKeyStr[2] = '3';
        //SecurityKeyStr[3] = '4';
        //SecurityKeyStr[4] = '5';
        //SecurityKeyStr[5] = '6';
        //SecurityKeyStr[6] = '7';
        //SecurityKeyStr[7] = '8';
        //SecurityKeyStr[8] = '9';
        //SecurityKeyStr[9] = '0';
        //SecurityKeyStr[10] = '1';
        //SecurityKeyStr[11] = '2';
        //SecurityKeyStr[12] = '3';
        //SecurityKeyStr[13] = 0x00;
        
        
        //std::memcpy( networkSetting->wireless.essidSecurity.key, SecurityKeyStr, std::strlen( SecurityKeyStr ));
        std::memset( networkSetting->wireless.essidSecurity.passphrase, 0x00, 64 );
        std::memcpy( networkSetting->wireless.essidSecurity.passphrase, SecurityKeyStr, std::strlen( SecurityKeyStr ));
        
        NN_LOG("SecurityKey=%s\n", SecurityKeyStr );
        NN_LOG("SecurityKeyLen=%d\n", strlen( SecurityKeyStr ));
        
        NN_LOG("Passphrase=%s\n", networkSetting->wireless.essidSecurity.passphrase );
        NN_LOG("Passphraselength=%d\n", strlen( (char*)networkSetting->wireless.essidSecurity.passphrase ));
        
        if(( networkSetting->wireless.essidSecurity.securityMode != nn::ac::WEP_40BIT ) &&
           ( networkSetting->wireless.essidSecurity.securityMode != nn::ac::WEP_104BIT ) &&
           ( networkSetting->wireless.essidSecurity.securityMode != nn::ac::WEP_128BIT ))
        {
                result =    nn::ac::ConvertPassphraseToPsk(
                            (u8*)SecurityKeyStr,
                            std::strlen( SecurityKeyStr ),
                            networkSetting->wireless.essidSecurity.ssid,
                            networkSetting->wireless.essidSecurity.ssidLength,
                            networkSetting->wireless.essidSecurity.key,
                            nn::nwm::WPA_PSK_SIZE );
                
                NN_LOG("SecurityKey=%s\n", networkSetting->wireless.essidSecurity.key );
                if( result.IsFailure())
                {
                    NN_LOG("ConvertPassphraseToPsk Error\n");
                    nn::dbg::PrintResult( result );
                    return false;
                }
        }
        
        
    }
    {
        networkSetting->wireless.enable = true;
        networkSetting->wireless.editableEssidSecurity = true;
        networkSetting->wireless.multiSsid.enable = false;

        networkSetting->ip.enableDHCP        = true;
        networkSetting->scanlessConnect.hasConnected = false;
        networkSetting->ip.autoDNSSetting    = true;
        //networkSetting->other.mtu = 1400;
    }

    delete[] readBuf;
    
    result = nn::ac::FinalizeInternal();
    
    if( result.IsFailure())
    {
        NN_LOG("ac Finalize Error\n");
        nn::dbg::PrintResult( result );
        return false;
    }

    return true;
    
    

}
void uji::eva::TestWirelessForSC::SaveAPSetting()
{
    uji::seq::TestResult result;
    
    uji::sys::Menu::m_SubWindow->Printf("Import Start!\n");
    DrawDisplays( NN_GX_DISPLAY1 );
    uji::sys::Menu::m_SubWindow->Printf("\f");
    if( !SaveAPSettingCommon( result ))
    {
        uji::sys::Menu::m_SubWindow->Printf("Import NG!\n");
    }
    
    uji::sys::Menu::m_SubWindow->Printf("%s\n", result.m_String );
    uji::sys::Menu::m_SubWindow->Printf("\nPress B to Return\n");
    DrawDisplays( NN_GX_DISPLAY1 );
     
    do
    {
        uji::sys::Pad().UpdatePad();
    }while( !uji::sys::Pad().IsButtonPress( uji::sys::Pad::BUTTON_B ));
    
    
}


bool uji::eva::TestWirelessForSC::SaveAPSettingCommon( uji::seq::TestResult& result )
{
    nn::Result nnResult;
    nn::fs::FileStream fsWrite;
    char* readBuf;
    
    nnResult = nn::fs::MountSaveData();
    if( nnResult.IsFailure())
    {
        if( nnResult <= nn::fs::ResultNotFormatted()    ||
            nnResult <= nn::fs::ResultBadFormat()       ||
            nnResult <= nn::fs::ResultVerificationFailed())
        {
            nnResult = nn::fs::FormatSaveData( 0x100, 0x100 );
            if( nnResult.IsFailure())
            {
                std::sprintf( result.m_String, "BackUpMedia Format Error");
                NN_LOG("Format Error\n");
                
                return false;
            }
            nnResult = nn::fs::MountSaveData();
            if( nnResult.IsFailure())
            {
                std::sprintf( result.m_String, "Backup Media Error");
                return false;
            }
        }else
        {
            std::sprintf( result.m_String, "BackUpMedia Unknown Error\nPlease Change Card");
            return false;
        }
    }
    
    nnResult = nn::fs::MountSdmc();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "MountSDMC Error");
        NN_LOG("Mount SDMC Error\n");
        nn::fs::Unmount("data:");
        return false;
        
    }
    
    nn::fs::FileInputStream fsRead;
    nnResult = fsRead.TryInitialize( L"sdmc:/APSetting.txt");
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "SDMCFile Open Error");
        NN_LOG("SDMC File Initialize Error\n");
        result.m_Result = false;
        goto END_MOUNT;
    }
    
    s64 fileSize;
    
    nnResult = fsRead.TryGetSize( &fileSize );
    if( nnResult.IsFailure())
    {
        NN_LOG("Get SDMC FileSize Error\n");
        std::sprintf( result.m_String, "FileSize Error");
        result.m_Result = false;
        goto END_MOUNT;
    }
    
    readBuf = new char[ fileSize + 1 ];
    
    s32 readSize;
    nnResult = fsRead.TryRead( &readSize, readBuf, fileSize );
    if( nnResult.IsFailure())
    {
        NN_LOG("Read Error\n");
        std::sprintf( result.m_String, "SDMC Read Error");
        result.m_Result = false;
        goto END_NEW;
    }
    
    // ȉ2͎sĂ
    nn::fs::TryCreateDirectory(L"data:/uji/");
    nn::fs::TryDeleteFile(L"data:/uji/APSetting.txt"); 
    
    nnResult = fsWrite.TryInitialize(L"data:/uji/APSetting.txt",   nn::fs::OPEN_MODE_READ   | 
                                                                   nn::fs::OPEN_MODE_WRITE  | 
                                                                   nn::fs::OPEN_MODE_CREATE );
                                                                    
    
    if( nnResult.IsFailure())
    {
        result.m_Result = false;
        std::sprintf( result.m_String, "Write BackupMedia Error");
        goto END_NEW;
    }
    
    s32 writeSize;
    nnResult = fsWrite.TryWrite( &writeSize, readBuf, fileSize );
    if( nnResult.IsFailure())
    {
        NN_LOG("Read Error\n");
        std::sprintf( result.m_String, "Write BackupMedia Error");
        result.m_Result = false;
        goto END_NEW;
    }
    
    fsWrite.Finalize();
    nn::ac::CTR::NetworkSetting networkSetting;
    if( !SetNetworkSettingFromData( &networkSetting ))
    {
        result.m_Result = false;
        std::sprintf( result.m_String, "SettingFile Error");
        nn::fs::TryDeleteFile(L"data:/uji/APSetting.txt"); 
        goto END_NEW;
    }
    
    result.m_Result = true;
    std::sprintf( result.m_String, "Import Success!");
    
    END_NEW:
    delete[] readBuf;
    
    END_MOUNT:
    
    nn::fs::Unmount("sdmc:");
    nn::fs::Unmount("data:");
    
    return result.m_Result;
    
}


bool uji::eva::TestWirelessForSC::GetSettingStrings( const char* source, const char* search, char* returnStr )
{
    char* tmpStr = returnStr;
    while( *source != '\0' )
    {
        if( *source == '#')
        {
            while( *source != 0x0d && *source != 0x0a )
            {
                *source++;
            }
            while( *source == 0x0d || *source == 0x0a )
            {
                *source++;
            }
        }
            
        if( *source == *search )
        {
            if( 0 == ( std::memcmp( source, search, std::strlen( search ))))
            {
                while( *source++ != '=' )
                {}
                while( *source != 0x0d && *source != 0x0a ) // 
                {
                    *tmpStr++ = *source++;
                }
                *tmpStr = 0x00;
                return true;
            }
        }
    source++;
    }
    return false;
}
    
    
    

//------------------------------------------------------------------------------
// `fBXvCw肵āA`s
//------------------------------------------------------------------------------
void uji::eva::TestWirelessForSC::DrawDisplays( s32 display )
{
    if( display == NN_GX_DISPLAY0 || display == NN_GX_DISPLAY_BOTH )
    {
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        uji::sys::Menu::m_WindowManager.Update();
        uji::sys::Menu::m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
    }
    
    if( display == NN_GX_DISPLAY1 || display == NN_GX_DISPLAY_BOTH )
    {
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
        gfx->m_DrawFramework->Clear();
        uji::sys::Menu::m_WindowManager.Update();
        uji::sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        
    }
    gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
    
}

