/****************************************************************************
    CTRi

    VERSION = 0.01 V[PTΉ\
    VERSION = 0.02 Rx̃^CAEgΉ(10b)
    VERSION = 0.03 oOCARSCTIME_OUTǉ
    VERSION = 0.04 START_Packet̕\
    VERSION = 0.05 GetIPAddress̎
    VERSION = 0.06 œKASetRxTimeOut̎
    VERSION = 0.07 SDK0.10ΉAIPAhXwARSSI擾
    VERSION = 0.08 PER̃oOCARSSIA^C擾ɕύX
    VERSION = 0.09 O֘AAfobOR}hƂă`l擾ǉ
    VERSION = 0.10 SDK0.11.1Ή
    VERSION = 0.11 Ȍ݂ύXAVAio[ݑΉ
    VERSION = 0.12 ÕRgAEg߂ASTART+L+RŌ𔲂lɂB
    VERSION = 0.13 Ö𑽏ύXB
    VERSION = 0.14 R}hɐFtAMPʐM
    VERSION = 0.15 R}hɂԍBo[WǗomaket@CɈړ
    VERSION = 0.16 R[ht@N^OB
    VERSION = 0.17 SDK0.13.1ΉB

****************************************************************************/

#include <nn.h>
#include <nn/gx.h>
#include "../seq/TestResult.h"
#include "sys.h"
#include "sys_GetSerialNumber.h"
#include "sys_GetRegionCode.h"
#include "sys_WriteSerialNumber.h"
#include "TestWireless.h"
#include "CommandUtil.h"
#include "../Application.h"
#include "TestUDS.h"
#include "CommandTestTool.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../mcu/McuInitializer.h"
#include "../mcu/TestMcuNotification.h"
#include "../mcu/TestPowerOff.h"
#include "sys_GetBondingOption.h"

#include <nn/nwm.h>
#include <nn/cfg.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/cfg/CTR/cfg_ApiNor.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji::sys;
using namespace nn::ac::CTR::detail;

namespace uji{
namespace eva{
    
static void ShowPicture( wchar_t *file );

namespace
{

    const TestWireless::FuncMapping FuncMap[] =
    {
        { 0x0101,   "ATH_Init"                  ,&TestWireless::ATH_Init                },
        { 0x0102,   "ATH_End"                   ,&TestWireless::ATH_End                 },
        { 0x0103,   "ATH_Connect"               ,&TestWireless::ATH_Connect             },
        { 0x0104,   "ATH_Disconnect"            ,&TestWireless::ATH_Disconnect          },
        { 0x0105,   "ATH_GetLinkStatus"         ,&TestWireless::ATH_GetLinkStatus       },
        { 0x0106,   "ATH_SetSSID"               ,&TestWireless::ATH_SetSSID             },
        { 0x0107,   "ATH_GetIPAddress"          ,&TestWireless::ATH_GetIPAddress        },
        { 0x0108,   "ATH_GetChannel"            ,&TestWireless::ATH_GetChannel          },
        { 0x0110,   "ATH_SetIPAddress"          ,&TestWireless::ATH_SetIPAddress        },
        { 0x0111,   "ATH_SetNetmask"            ,&TestWireless::ATH_SetNetmask          },
        { 0x0112,   "ATH_SetPortnum"            ,&TestWireless::ATH_SetPortnum          },
        { 0x0113,   "ATH_SetDefaultGateway"     ,&TestWireless::ATH_SetDefaultGateway   },
        { 0x0114,   "ATH_SetSendIPAddress"      ,&TestWireless::ATH_SetSendIPAddress    },
        { 0x0115,   "ATH_SetSendPacketNum"      ,&TestWireless::ATH_SetSendPacketNum    },
        { 0x0116,   "ATH_SetSendPacketLength"   ,&TestWireless::ATH_SetSendPacketLength },
        { 0x0117,   "ATH_StartTxTest"           ,&TestWireless::ATH_StartTxTest         },
        { 0x0118,   "ATH_StartRxTest"           ,&TestWireless::ATH_StartRxTest         },
        { 0x0119,   "ATH_SetRxTimeOut"          ,&TestWireless::ATH_SetRxTimeOut        },
        { 0x0120,   "ATH_GetRSSI"               ,&TestWireless::ATH_GetRSSI             },

        { 0x0301,   "MP_Init"                   ,&TestWireless::MP_Init                 },
        { 0x0302,   "MP_End"                    ,&TestWireless::MP_End                  },
        { 0x0303,   "MP_SetChannel"             ,&TestWireless::MP_SetChannel           },
        { 0x0304,   "MP_SetSSID"                ,&TestWireless::MP_SetSSID              },
        { 0x0305,   "MP_StartActiveScan"        ,&TestWireless::MP_StartActiveScan      },
        { 0x0310,   "MP_StartBeacon"            ,&TestWireless::MP_StartBeacon          },
        { 0x0311,   "MP_StartPassiveScan"       ,&TestWireless::MP_StartPassiveScan     },

        { 0x0801,   "CTR_GetMacAddress"         ,&TestWireless::CTR_GetMacAddress       },
        { 0x0802,   "CTR_GetModuleID"           ,&TestWireless::CTR_GetModuleID         },
        { 0x0803,   "CTR_GetFirmwareType"       ,&TestWireless::CTR_GetFirmwareType     },
        { 0x0804,   "CTR_GetFirmwareVersion"    ,&TestWireless::CTR_GetFirmwareVersion  },
        { 0x0805,   "CTR_GetRegion"             ,&TestWireless::CTR_GetRegion           },
        { 0x0806,   "CTR_GetSerialNumber"       ,&TestWireless::CTR_GetSerialNumber     },
        { 0x0807,   "CTR_WriteSerialNumber"     ,&TestWireless::CTR_WriteSerialNumber   },
        { 0x0813,   "CTR_SetReset"              ,&TestWireless::CTR_SetReset            },
        { 0x0814,   "CTR_SetPowerOff"           ,&TestWireless::CTR_SetPowerOff         },

        { 0x0901,   "TESTER_GetVersion"         ,&TestWireless::TESTER_GetVersion       },
        { 0x0902,   "TESTER_GetBuildDate"       ,&TestWireless::TESTER_GetBuildDate     },
        { 0x0903,   "TESTER_SetTime"            ,&TestWireless::TESTER_SetTime          },
        { 0x0904,   "TESTER_SetTestMode"        ,&TestWireless::TESTER_SetTestMode      },
        { 0x0905,   "TESTER_WriteStartLog"      ,&TestWireless::TESTER_WriteStartLog    },
        { 0x0906,   "TESTER_WriteOKLog"         ,&TestWireless::TESTER_WriteOKLog       },
        { 0x0907,   "TESTER_WriteNGLog"         ,&TestWireless::TESTER_WriteNGLog       },
        { 0x0908,   "TESTER_GetTimeCounter"     ,&TestWireless::TESTER_GetTimeCounter   },

        //{ 0x1000,   "DEBUG_SetChannel"          ,&TestWireless::DEBUG_SetChannel        },
        //{ 0x1001,   "DEBUG_ScanlessConnect"     ,&TestWireless::DEBUG_ScanlessConnect   },
        { 0x1001,   "DEBUG_SetStartPacketNum"       ,&TestWireless::DEBUG_SetStartPacketNum         },
        { 0x1002,   "DEBUG_SetStartPacketWait"      ,&TestWireless::DEBUG_SetStartPacketWait        },
        { 0x1003,   "DEBUG_SetStartPacketInterval"  ,&TestWireless::DEBUG_SetStartPacketInterval    },
        { 0x1004,   "DEBUG_SetDataPacketWait"       ,&TestWireless::DEBUG_SetDataPacketWait         },
    };


    static u8 s_SocketBuffer[ 4096 * 20 ] NN_ATTRIBUTE_ALIGN( 4096 );

}

//static bit8 s_UdsReceiveBuffer[ 4096*1 ] NN_ATTRIBUTE_ALIGN( 4096 );
//------------------------------------------------------------------------------
// JnȌ
//------------------------------------------------------------------------------
bool TestWireless::AllInit()
{

    uji::sys::GetMacAddress( m_MacAddress );

    //nn::Result result;
    //nn::nwm::CTR::HardwareInfo HWInfo;
    //
    //result = nn::nwm::CTR::InitializeExtControl();
    //if( result.IsFailure())
    //{
    //    nn::dbg::PrintResult( result );
    //    return false;
    //}
    //
    //result = nn::nwm::CTR::Ext::GetHardwareInfo( m_HWInfo );
    //if( result.IsFailure())
    //{
    //    nn::dbg::PrintResult( result );
    //    return false;
    //}
    //
    //result = nn::nwm::CTR::FinalizeExtControl();
    //if( result.IsFailure())
    //{
    //    nn::dbg::PrintResult( result );
    //    return false;
    //}
    //
    //{
    //    NN_LOG("chipId                  = %X\n", HWInfo.chipId               );
    //    NN_LOG("romId                   = %X\n", HWInfo.romId                );
    //    NN_LOG("hostVersion             = %X\n", HWInfo.hostVersion          );
    //    NN_LOG("firmwareVersion         = %X\n", HWInfo.firmwareVersion      );
    //    NN_LOG("datapatchVersion        = %d\n", HWInfo.datapatchVersion     );
    //    NN_LOG("eepromFirmVersion       = %d\n", HWInfo.eepromFirmVersion    );
    //    NN_LOG("regulatoryDomain        = %X\n", HWInfo.regulatoryDomain     );
    //    NN_LOG("allowedChannelBitmap    = %d\n", HWInfo.allowedChannelBitmap );
    //}
    return true;
}



//------------------------------------------------------------------------------
// {
//------------------------------------------------------------------------------
#if 1
void TestWireless::TestWirelessCommon()
{

    AllInit();

    CommandUtil::CheckWifiMode();

    nn::os::Thread execCommThread;
    execCommThread.StartUsingAutoStack( WrappingExecuteCommandThread, this, 4096, nn::os::DEFAULT_THREAD_PRIORITY - 1 );
    //ExecuteCommandThread();

    uji::sys::WindowManager windowManager;

    m_CommWindow.SetTitle("Command  ( Press L+R : Clear )");
    m_StatWindow.SetTitle("TestWireless Status");
    m_InfoWindow.SetTitle("Wireless Info");


    windowManager.CreateWindow( &m_CommWindow, NN_GX_DISPLAY0, 0, 0 );
    windowManager.CreateWindow( &m_StatWindow, NN_GX_DISPLAY1, 0, 0 );
    windowManager.CreateWindow( &m_InfoWindow, NN_GX_DISPLAY0, 0, 160 );

    m_TimeCounter.InitTime();

    while( true )
    {
        Pad().UpdatePad();
        if( m_TestResult != RESULT_DEFAULT )
        {
            m_isTestFin = true;
        }
        if( Pad().IsButtonPress( Pad::BUTTON_L ) && Pad().IsButtonPress( Pad::BUTTON_R ) && Pad().IsButtonPress( Pad::BUTTON_START ))
        {
            m_isTestFin = true;
        }
        if( Pad().IsButtonPress( Pad::BUTTON_A ) && m_isAthEnd )
        {
            m_isTestFin = true;
        }
        if( m_isTestFin )  // R}heXgIł悤ɔ蕔𕪂܂B
        {
            break;
        }

        if( Pad().IsButtonPress( Pad::BUTTON_DOWN ) && Pad().IsButtonPress( Pad::BUTTON_A ))
        {
            uji::eva::mcu::EvaReset();
        }

        if( Pad().IsButtonPress( Pad::BUTTON_DOWN ) && Pad().IsButtonPress( Pad::BUTTON_B ))
        {
            uji::eva::mcu::EvaPowerOff();
        }
        if( Pad().IsButtonPress( Pad::BUTTON_L ) && Pad().IsButtonPress( Pad::BUTTON_R ) )
        {
            m_CommWindow.Printf("\f");
            m_StatWindow.Printf("\f");
            m_SendCommCount = 0;
            m_RecvCommCount = 0;
            m_RecvPacketNum = 0;
            m_RecvPacketLength = 0;
            m_ActuallyRecvNum = 0;
        }


        if(m_isF2USBActive)
        {
            
            m_InfoWindow.Printf("\f");
            m_InfoWindow.Printf("CTR_Wireless Tester Ver:%s     ( %s )\n", VERSION_STRING, VERSION_DATE );
            m_InfoWindow.Printf("MacAddress = %02X:%02X:%02X:%02X:%02X:%02X   ", m_MacAddress[0], m_MacAddress[1], m_MacAddress[2],
                                                                               m_MacAddress[3], m_MacAddress[4], m_MacAddress[5] );
            m_InfoWindow.Printf("SSID = %s\n", m_AP_SSID );
            m_InfoWindow.Printf("TimeCount  = %s         ",
                       CommandUtil::ConvertStringFromTimeSpan( m_TimeCounter.GetTimeSpan()));

            m_InfoWindow.Printf("IP Address = %s\n",                  nn::socket::InetNtoA( m_MyIpAddress ));
            m_InfoWindow.Printf("Channel = %2d                     ", m_MyChannel );
            m_InfoWindow.Printf("StartPacketNum = %03d\n",            m_RecvPacketNum );
            m_InfoWindow.Printf("StartPacketLength = %03d          ", m_RecvPacketLength );
            m_InfoWindow.Printf("RecvDataFrame = %d\n",               m_ActuallyRecvNum );


            gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
            gfx->m_DrawFramework->Clear();
            windowManager.Update();
            windowManager.DrawDisplay0();
            gfx->m_DrawFramework->SwapBuffers();

            gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
            gfx->m_DrawFramework->Clear();
            windowManager.Update();
            windowManager.DrawDisplay1();
            gfx->m_DrawFramework->SwapBuffers();
            
            
        }
        else if(!m_isCardPowerActive)
        {
            //BGNAJ[ݒ肷
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 1.0f, 0.0f, 0.0f, 1.0f );
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 1.0f, 0.0f, 0.0f, 1.0f );
            
            //ʃNA
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->Clear();
            gfx->m_DrawFramework->SwapBuffers();
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
            gfx->m_DrawFramework->Clear();
            gfx->m_DrawFramework->SwapBuffers();
            
            //BGNAJ[ɖ߂
            gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
            gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
        }
        else
        {
            //BGNAJ[ݒ肷
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 1.0f, 1.0f, 1.0f, 1.0f );
            gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 1.0f, 1.0f, 1.0f, 1.0f );
            
            //ʃNA
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
            gfx->m_DrawFramework->Clear();
            gfx->m_DrawFramework->SwapBuffers();
            gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
            gfx->m_DrawFramework->Clear();
            gfx->m_DrawFramework->SwapBuffers();
            
            //BGNAJ[ɖ߂
            gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
            gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
                GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
        }
        
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);


    }
    
    bool isShowResult = true;
    switch(m_TestResult)
    {
        case RESULT_OK:
            ShowPicture( L"rom:/jpeg/Pass.jpg" );
        break;
        
        case RESULT_NG:
            ShowPicture( L"rom:/jpeg/Fail.jpg" );
        case RESULT_DEFAULT:
            isShowResult = false;
        break;
    }
    while( isShowResult )
    {
        Pad().UpdatePad();
        if( Pad().IsButtonPress( Pad::BUTTON_A ))
        {
            break;
        }
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));
    }
    execCommThread.Join();
    execCommThread.Finalize();
}

#else
void TestWireless::TestWirelessCommon()
{

    NN_LOG("Test Start!\n");
    m_StatWindow.Printf("Test Start!\n");

    const char TestResArg[] = "TestArg";

    const char* TestRes = CommandUtil::CreateRSCAndResponseArgString( CommandUtil::ILLEGAL_MODE, TestResArg );

    NN_LOG("resRSC = %s\n", TestRes );

    {   // ATH_InitTest
        const char ATH_InitCommand[] = "0122010100";

        CommPack ATH_InitComm = CommandUtil::AnalysisCommand( ATH_InitCommand );

        NN_LOG("TestComm CheckSum = %04X\n ", ATH_InitComm.CheckSum );
        NN_LOG("TestComm CommID = %04X\n ", ATH_InitComm.CommID );
        NN_LOG("TestComm ArgNum = %02X\n", ATH_InitComm.ArgNum );
        NN_LOG("TestComm Arg = %s\n", ATH_InitComm.Arg );

        NN_LOG("Response = %s\n", CommandUtil::CreateResponseString( ATH_InitComm, TestRes ));

        NN_LOG("Response = %s\n", ExecuteCommandFunction( ATH_InitComm ));
    }

    {   // ATH_SetSSID
        CommPack ATH_SetSSIDComm = CommandUtil::AnalysisCommand("03D5010609PE-WLTEST");
        NN_LOG("Response = %s\n", ExecuteCommandFunction( ATH_SetSSIDComm ));
    }

    {   // ATH_SetIPAddressTest
        CommPack ATH_SetIPAddressComm = CommandUtil::AnalysisCommand( "039101100F192.168.11.2" );
        NN_LOG("Response = %s\n", ExecuteCommandFunction( ATH_SetIPAddressComm ));
    }

    {   //ATH_ConnectTest
        CommPack ATH_ConnectComm = CommandUtil::AnalysisCommand("0124010300");
        NN_LOG("Response = %s\n", ExecuteCommandFunction( ATH_ConnectComm ));
    }

    {   // ATH_SetPortnum
        CommPack ATH_SetPortnumComm = CommandUtil::AnalysisCommand("01D10112034D2");
        NN_LOG("Response = %s\n", ExecuteCommandFunction( ATH_SetPortnumComm ));
    }

    {   // ATH_CreateSocket
        CommPack ATH_CreateSocketComm = CommandUtil::AnalysisCommand("0124012100");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction( ATH_CreateSocketComm ));
    }

    {   // ATH_SetSendIPAddress
        CommPack ATH_SetSendIPAddressComm = CommandUtil::AnalysisCommand("039201140C192.168.11.2");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction( ATH_SetSendIPAddressComm ));
    }
    {   // ATH_SetSendPacketNum
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("01CB01150300A");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction( ATH_TestComm ));
    }
    {   // ATH_SetSendPacketLength
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("01CC01160300A");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction( ATH_TestComm ));
    }

    {   // ATH_StartTxTest
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("0129011700");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction( ATH_TestComm ));
    }

    {   // ATH_StartRxTest
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("012A011800");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction( ATH_TestComm ));
    }

    {
        const int MAX_RES_SIZE = 10;
        while( true )
        {
            CommPack ATH_TestComm = CommandUtil::AnalysisCommand("012B011900");
            char ResTest[ MAX_RES_SIZE ] = "";
            const char* pRes = ExecuteCommandFunction( ATH_TestComm );
            std::memcpy( ResTest, pRes, MAX_RES_SIZE );
            if( CommandUtil::ConvertNumFromString( ResTest, 2 ) == CommandUtil::SUCCESS )
            {
                NN_LOG("Response = %s\n", ResTest );
                break;
            }
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 1000 ));
        }
    }

    {   // ATH_StartRxTest
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("012A011800");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction( ATH_TestComm ));
    }

    {
        const int MAX_RES_SIZE = 10;
        while( true )
        {
            CommPack ATH_TestComm = CommandUtil::AnalysisCommand("012B011900");
            char ResTest[ MAX_RES_SIZE ] = "";
            const char* pRes = ExecuteCommandFunction( ATH_TestComm );
            std::memcpy( ResTest, pRes, MAX_RES_SIZE );
            if( CommandUtil::ConvertNumFromString( ResTest, 2 ) == CommandUtil::SUCCESS )
            {
                NN_LOG("Response = %s\n", ResTest );
                break;
            }
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 1000 ));
        }
    }


    {   //ATH_DestroySocket
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("0125012200");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction( ATH_TestComm ));
    }

    {   // ATH_Disconnect
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("0125010400");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction( ATH_TestComm ));
    }

    {   // ATH_End
        CommPack ATH_TestComm = CommandUtil::AnalysisCommand("0123010200");
        NN_LOG("Reponse = %s\n", ExecuteCommandFunction( ATH_TestComm ));
    }
}
#endif

//------------------------------------------------------------------------------
// ɓdāAJ[h̑}Ԃ𒲍B
//------------------------------------------------------------------------------
bool TestWireless::ScanCardSlot()
{
    u8 PowerState, CardState;
    
    //dĂ݂
    nn::fs::CardSlotPowerOn(&PowerState);
    
    //Jڒ߂
    do
    {
        nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
    }while(CardState == 0x0C);
    
    //Jڌ̏ԂmF
    nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
    if(!CardState) return false;
    else if(CardState == 0x04)
    {
        nn::fs::CardSlotPowerOff(&PowerState);
        
        return false;
    }
    else if(CardState == 0x08) return true;
    
    //ɗ̂s
    nn::fs::CardSlotPowerOff(&PowerState);
    return false;
}

//------------------------------------------------------------------------------
// R}h̑M֐
//------------------------------------------------------------------------------
void TestWireless::SendCommand( const char* str )
{
    u32 w_Count;

    COMMAND_SEND_RETRY :  // obt@ɋ󂫂Ȃꍇ͂烊gC
    w_Count = m_CommSpi.GetWriteFifoCount();

    // FIFŐ󂫂0x0FFF-0x0F38=200Byteȏ㖳ꍇ͋󂭂܂ő҂B
    if( w_Count >= 0x0F38 )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(100));
        goto COMMAND_SEND_RETRY;
    }

    m_CommSpi.WriteFifo( reinterpret_cast< const u8* >( str ), std::strlen( str ));
    m_CommWindow.SetTextColor( ATTR_COLOR_YELLOW );
    m_CommWindow.Printf("->%02x:", m_SendCommCount );
    PrintSendCommand( str );
    m_SendCommCount++;
}



//------------------------------------------------------------------------------
// f[^MBf[^FIFOɂȂꍇfalseԂ
//------------------------------------------------------------------------------
bool TestWireless::ReceiveCommand()
{
    u8 CardState;
    u32 inFIFOCount = 0;
    
    //J[hd̊mF
    nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
    if(!CardState || CardState == 0x0C)
    {
        //J[hdĂȂA͏ԑJڒ̏ꍇ
        m_isCardPowerActive = false;
        
        //J[hď
        while(!m_isCardPowerActive)
        {
            //J[hd̏Ԏ擾
            nn::fs::CardSlotGetCardIFPowerStatus(&CardState);
            
            if(!CardState)  //J[hdOFF
            {
                //xdĂ݂āAXe[gǂ]Ԃ`FbN
                if(ScanCardSlot())  m_isCardPowerActive = true;
                else                m_isCardPowerActive = false;
            }
            else if(CardState == 0x04 || CardState == 0x08)
            {
                //0x08̏ꍇ͐ɒʓdA0x04ɂȂXe[g͖mFON̖͗l
                m_isCardPowerActive = true;
            }
            else if(CardState == 0x0C)
            {
                //JڒȂ̂ōă[v
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
            }
            else
            {
                //ɗXe[g͖͂H
            }
        }
    }
    else m_isCardPowerActive = true;    //̍s0x04zȌԂłȂΗvȂ͂
    
    //ɓB_ŁẢ̎MɂĂ͓dONO
    
    inFIFOCount = m_CommSpi.GetReadFifoCount();
    // R}h10(ŏR}h)Zꍇ͒Ȃ܂ő҂
    if(inFIFOCount < 10)
    {
        //F2USBFłĂ邱ƂtOɊi[Ă
        m_isF2USBActive = true;
        return false;
    }
    else if(inFIFOCount > MAX_COMMAND_SIZE)
    {
        //F2USBƂSPIʐMɈُ킪Ăꍇ
        m_isF2USBActive = false;
        return false;
    }
    
    // R}h܂ĂꍇAxԂuĂǂ݂Ȃ
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
    inFIFOCount = m_CommSpi.GetReadFifoCount();

    // ۂFifoǂݏoAeʂɕ\
    std::memset(m_RecvCommandBuf, 0x00, MAX_COMMAND_SIZE);
    m_CommSpi.ReadFifo(reinterpret_cast< u8* >(m_RecvCommandBuf), inFIFOCount);

    m_CommWindow.SetTextColor(ATTR_COLOR_WHITE);
    m_CommWindow.Printf("  %02x:", m_RecvCommCount);
    //PrintRecvCommand(m_RecvCommandBuf);

    // R}hǂݍ݃tOZbgAR}hJEg𑝂₷
    m_RecvCommCount++;
    return true;

}

//------------------------------------------------------------------------------
// o֐XbhƂċN邽߂̃bp[
//------------------------------------------------------------------------------
void TestWireless::WrappingExecuteCommandThread( void* param )
{
    TestWireless* pTW = reinterpret_cast< TestWireless* >( param );
    pTW->ExecuteCommandThread();
}

//------------------------------------------------------------------------------
// R}h猟NXbhB
//------------------------------------------------------------------------------
void TestWireless::ExecuteCommandThread()
{

    CommPack commPack;
    NN_LOG("ExecuteCommandThread\n");

    const char CHECKSUM_ERROR_COMMAND[] = "0000000000";

    while( true )
    {
        if( m_isTestFin )
        {
            break;
        }
        if( ReceiveCommand() ) // R}hMmF
        {
            if( !CommandUtil::isCorrectCheckSum( m_RecvCommandBuf, std::strlen( m_RecvCommandBuf )))
            {
                NN_LOG("CheckSum Error!\n");
                m_StatWindow.Printf("%02x: Command CheckSum Error!\n", m_RecvCommCount - 1 );
                m_StatWindow.Printf("%s\n", m_RecvCommandBuf );

                commPack = CommandUtil::AnalysisCommand( CHECKSUM_ERROR_COMMAND );

                const char* RSCStr = CommandUtil::CreateResponseString( commPack,
                                                  CommandUtil::CreateRSCAndResponseArgString( CommandUtil::CHECKSUM ));
                SendCommand( RSCStr );
                continue;
            }

            commPack = CommandUtil::AnalysisCommand( m_RecvCommandBuf );
            PrintRecvCommand( commPack );
            const char* RSCStr = CommandUtil::CreateResponseString( commPack, ExecuteCommandFunction( commPack ));
            SendCommand( RSCStr );
        }else
        {
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
        }
    }
}

//------------------------------------------------------------------------------
// R}hpPbg猟֐sAԂlԂ
//------------------------------------------------------------------------------
const char* TestWireless::ExecuteCommandFunction( const CommPack &commPack )
{
    int gID = GetGroupIDFromCommandID( commPack.CommID );
    if( gID < 0 )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    else
    {
        return ( this->*( FuncMap[ gID ].func ))( commPack.Arg );
    }
}

//------------------------------------------------------------------------------
// R}hpPbg猟֐Ԃ
//------------------------------------------------------------------------------
const char* TestWireless::GetCommandName( const CommPack &commPack )
{
    int gID = GetGroupIDFromCommandID( commPack.CommID );
    if( gID < 0 )
    {
        return "No Command";
    }
    else
    {
        return FuncMap[ gID ].funcname;
    }
}

//------------------------------------------------------------------------------
// R}hpPbgCommIĎ̔ԍԂ
//------------------------------------------------------------------------------
int TestWireless::GetGroupIDFromCommandID( const u16 &commID )
{
    int groupID;
    u32 max_GroupID = ( sizeof( FuncMap ) / sizeof( FuncMap[0] ));

    for( groupID = 0; groupID <= max_GroupID; groupID++ )
    {
        if( commID == FuncMap[ groupID ].opcode )
        {
            return groupID;
        }
    }
    NN_LOG("Bad Return! %d\n", __LINE__);
    const int ERROR_NUMBER = -1;
    return ERROR_NUMBER;
}


//------------------------------------------------------------------------------
// ȉA֐
// Return FȂƂȂĂ̂́ARSĈ݂Ԃ
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
// Desc   F
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_Init( const char* arg )
{
    NN_UNUSED_VAR( arg )

    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    nn::Result result;

    result = nn::ac::CTR::InitializeInternal(); // nn::ac̃C^[ȉ
    if( result.IsFailure())
    {
        m_StatWindow.Printf("ac InternalInit Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    m_isAthEnd = false;

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FI
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_End( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    nn::Result result;
    // J@AobNAbvɎsꍇ
    // lbg[Nݒ
    if( uji::sys::GetBondingOption() || !m_isBackUp )
    {
        nn::ac::CTR::RemoveNetworkSetting( 0 );
        nn::ac::CTR::FlushNetworkSetting();
    }

    result = nn::ac::FinalizeInternal();
    if( result.IsFailure())
    {
        m_StatWindow.Printf("ac InternalFinalize Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    m_isAthEnd = true;

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );

}

//------------------------------------------------------------------------------
// Desc   FCTR{̂IPAhXݒ
// Arg    FZbgIPAhX
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_SetIPAddress( const char* arg )
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );

    if( !nn::socket::InetAtoN( arg, &m_SetIpAddress ))
    {
        m_StatWindow.Printf("SetIPAddress Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    NN_LOG("Set IP Address = %s\n", nn::socket::InetNtoA( m_SetIpAddress ));
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FCTR{̂̃lbg}XNݒ
// Arg    FZbglbg}XN
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_SetNetmask( const char* arg )
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );

    if( !nn::socket::InetAtoN( arg, &m_SetNetmask ))
    {
        m_StatWindow.Printf("SetNetMask Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    NN_LOG("Set Netmask = %s\n", nn::socket::InetNtoA( m_SetNetmask ));
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FCTR{̂̃ftHgQ[gEFCݒ
// Arg    FZbgftHgQ[gEFC
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_SetDefaultGateway( const char* arg )
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );

    if( !nn::socket::InetAtoN( arg, &m_SetDefaultGateway ))
    {
        m_StatWindow.Printf("SetDefaultGateway Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    NN_LOG("Set m_SetDefaultGateway = %s\n", nn::socket::InetNtoA( m_SetDefaultGateway ));
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FAPSSIDݒ
// Arg    FZbgSSID
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_SetSSID( const char* arg )
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );
    std::memset( m_AP_SSID, 0x00, MAX_SSID_SIZE );
    std::strcpy( m_AP_SSID, arg );
    NN_LOG("Set SSID = %s\n", m_AP_SSID );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FCTRIPAhX擾
// Arg    FȂ
// Return FCTRIPAhX
//------------------------------------------------------------------------------
const char* TestWireless::ATH_GetIPAddress( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, nn::socket::InetNtoA( m_MyIpAddress ) );
}
//------------------------------------------------------------------------------
// Desc   FAPւ̐ڑ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_Connect( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );


    nn::Result result;

    nn::ac::CTR::NetworkSetting backupSetting;
    std::memset( &backupSetting, 0x00, sizeof( backupSetting ));
    
    // LINE[hȊȌꍇ͖{̂̃lbg[Nݒ̃obNAbvs
    if( uji::seq::pl::LINE != m_TestMode ) 
    {
        result = nn::ac::CTR::LoadNetworkSetting( 0, backupSetting );
        if( result.IsFailure())
        {
            m_StatWindow.Printf("No Data\n");
            nn::dbg::PrintResult( result );
        }else
        {
            if( 0 != std::strcmp( m_AP_SSID, reinterpret_cast<char*>( backupSetting.wireless.essidSecurity.ssid )))
            {
                m_StatWindow.Printf("Backup SSID = %s\n", backupSetting.wireless.essidSecurity.ssid );
                m_isBackUp = true;
            }else
            {
                m_StatWindow.Printf("Test SSID\n");
            }
        }
    }
    
    nn::ac::CTR::NetworkSetting networkSetting;
    {
        {
            networkSetting.wireless.enable = true;
            networkSetting.wireless.editableEssidSecurity = true;
            {
                std::memcpy( networkSetting.wireless.essidSecurity.ssid, m_AP_SSID, std::strlen( m_AP_SSID ));
                networkSetting.wireless.essidSecurity.ssidLength    = std::strlen( m_AP_SSID );
                networkSetting.wireless.essidSecurity.securityMode  = nn::ac::OPEN;
            }
            {
                networkSetting.wireless.multiSsid.enable = false;
            }
        }
        {
            networkSetting.ip.enableDHCP        = false;
            networkSetting.ip.autoDNSSetting    = true;
            U32ToU8Matrix( m_SetIpAddress, networkSetting.ip.ipAddress );
            U32ToU8Matrix( m_SetDefaultGateway, networkSetting.ip.defaultGateway );
            U32ToU8Matrix( m_SetNetmask, networkSetting.ip.netmask );
            networkSetting.other.mtu = 1400;
        }
    }
    result = nn::ac::CTR::UpdateNetworkSetting( 0, networkSetting );
    if( result.IsFailure())
    {
        m_StatWindow.Printf("Update Error\n");
        nn::dbg::PrintResult( result );
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    

    nn::ac::Config config;
    nn::ac::CreateDefaultConfig( &config );
    nn::ac::CTR::SetNetworkArea( &config, nn::ac::NETWORK_AREA_LAN );

    result = nn::ac::ConnectWithoutEula( config );
    NN_LOG("Call ConnectWithoutEula\n");
    
    // LINE[hȊOŁA
    if( m_isBackUp && uji::seq::pl::LINE != m_TestMode )
    {
        result = nn::ac::CTR::UpdateNetworkSetting( 0, backupSetting );
        if( result.IsFailure())
        {
            nn::dbg::PrintResult( result );
            m_StatWindow.Printf("Restore Error\n");
        }
        
        result = nn::ac::CTR::FlushNetworkSetting();
        if( result.IsFailure())
        {
            nn::dbg::PrintResult( result );
            m_StatWindow.Printf("Flush Error\n");
        }
    }
    

    NN_LOG("Connect Success!\n");


    if( !CreateSocket())
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    // IPȂꍇAڑ̂sĂƂ݂ȂAؒfsB
    if( m_MyIpAddress.addr == 0 )
    {
        nn::ac::Close();
        m_StatWindow.Printf("Can't Get IP Addr\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    {   // ڑĂ`l̎擾
        nn::ac::AccessPoint AP;
        nn::ac::GetConnectingAccessPoint( &AP );

        m_MyChannel = AP.channel;
        NN_LOG("Channel = %d\n", m_MyChannel );
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );

}
//------------------------------------------------------------------------------
// Desc   FAP̐ؒf
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_Disconnect( const char* arg )
{
    NN_UNUSED_VAR( arg )

    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    DestroySocket();

    nn::Result result;
    result = nn::ac::Close();
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("ac Close Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    m_MyIpAddress.addr = 0; //IPAhXƃ`l0(ڑĂȂ\)
    m_MyChannel        = 0;
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FCTR̐ڑԊmF
// Arg    FȂ
// Return FCTR̐ڑ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_GetLinkStatus( const char* arg )
{
    NN_UNUSED_VAR( arg )

    nn::Result result;
    nn::ac::Status status;
    result = nn::ac::GetStatus( &status );
    if( result.IsFailure())
    {
        m_StatWindow.Printf("ac GetStatus Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    std::sprintf( m_WorkBuf, "%02X", status );
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );
}

//------------------------------------------------------------------------------
// Desc   FSocket̃|[gݒ
// Arg    Fݒ肷|[g
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_SetPortnum( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    m_PortNum = CommandUtil::ConvertNumFromString( arg, std::strlen( arg ));
    NN_LOG("Port = %d\n", m_PortNum );

    if( m_PortNum == CommandUtil::CONVERT_ERROR_NUM )
    {
        m_StatWindow.Printf("Socket PortNumber Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FTxeXgɂđMIPAhXw
// Arg    Fݒ肷IPAhX
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_SetSendIPAddress( const char* arg )
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );

    if( !nn::socket::InetAtoN( arg, &m_SendIpAddress ))
    {
        m_StatWindow.Printf("Set Send IPAddress Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    NN_LOG("Send IP Address = %s\n", nn::socket::InetNtoA( m_SendIpAddress ));
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FTxeXgɂđMpPbg̎w
// Arg    FMpPbg
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_SetSendPacketNum( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    m_SendPacketNum = CommandUtil::ConvertNumFromString( arg, std::strlen( arg ));
    NN_LOG("PacketNum = %d\n", m_SendPacketNum );

    if( m_SendPacketNum == CommandUtil::CONVERT_ERROR_NUM )
    {
        m_StatWindow.Printf("Set Packet Num Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FTxeXgɂđMpPbg̒
// Arg    FMpPbg
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_SetSendPacketLength( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    m_SendPacketLength = CommandUtil::ConvertNumFromString( arg, std::strlen( arg ));
    NN_LOG("PacketLength = %d\n", m_SendPacketLength );

    if( m_SendPacketLength == CommandUtil::CONVERT_ERROR_NUM )
    {
        m_StatWindow.Printf("Set Packet Length Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FTxeXgJn
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_StartTxTest( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    // pPbg̐AK͈͓ł鎖mFB
    if( m_SendPacketNum < 0 || 1024 < m_SendPacketNum )
    {
        m_StatWindow.Printf("Packet Num Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    if( m_SendPacketLength < 0 || 1024 < m_SendPacketLength )
    {
        m_StatWindow.Printf("Packet Length Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    m_Socket = nn::socket::Socket( nn::socket::PF_INET, nn::socket::SOCK_DGRAM, 0 );

    {
        m_Server_addr.len = sizeof(nn::socket::SockAddrIn);
        m_Server_addr.family = nn::socket::AF_INET;
        m_Server_addr.addr.addr = 0;
        m_Server_addr.port = nn::socket::HtoNs( m_PortNum );
    }

    s32 ret = nn::socket::Bind( m_Socket, &m_Server_addr );

    if( ret )
    {
        m_StatWindow.Printf( "Bind Error " );
        if( ret == nn::socket::ENETRESET )
        {
            m_StatWindow.Printf( "ENETRESET\n" );
        }
        
        if( ret == nn::socket::EBADF )
        {
            m_StatWindow.Printf( "EBADF\n" );
        }
        
        if( ret == nn::socket::EOPNOTSUPP )
        {
            m_StatWindow.Printf( "EOPNOTSUPP\n" );
        }
        
        if( ret == nn::socket::EINVAL )
        {
            m_StatWindow.Printf( "EINVAL\n" );
        }
        
        if( ret == nn::socket::EAFNOSUPPORT )
        {
            m_StatWindow.Printf( "EAFNOSUPPORT\n" );
        }
        
        if( ret == nn::socket::EADDRINUSE )
        {
            m_StatWindow.Printf( "EADDRINUSE\n" );
        }
        
        
    }

    m_Send_Addr.len    = sizeof( nn::socket::SockAddrIn );
    m_Send_Addr.family = nn::socket::AF_INET;
    m_Send_Addr.addr   = m_SendIpAddress;
    m_Send_Addr.port   = nn::socket::HtoNs( m_PortNum );

    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( debTxParam.startPacketWait ));

    // X^[gpPbg̑M
    for( int i = 0; i < debTxParam.startPacketNum; i++ )
    {
        SendStartPacket( m_SendPacketNum, m_SendPacketLength );
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( debTxParam.startPacketInterval ));
    }

    // STARTpPbgf[^pPbg܂ł̊Ԋu
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( debTxParam.dataPacketWait ));

    SendDataFramePacket( m_SendPacketNum, m_SendPacketLength );

    // f[^pPbgENDpPbg܂ł̊Ԋu
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 100 ));

    // GhpPbg̑M
    for( int i = 0; i < 5; i++ )
    {
        SendEndPacket();
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 10 ));
    }

    nn::socket::Close( m_Socket );


    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FRxeXgJn
// Arg    FȂ
// Return FM
//------------------------------------------------------------------------------
const char* TestWireless::ATH_StartRxTest( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    m_Socket = nn::socket::Socket( nn::socket::PF_INET, nn::socket::SOCK_DGRAM, 0 );

    {
        m_Server_addr.len = sizeof(nn::socket::SockAddrIn);
        m_Server_addr.family = nn::socket::AF_INET;
        m_Server_addr.addr.addr = 0;
        m_Server_addr.port = nn::socket::HtoNs( m_PortNum );
    }

    s32 ret = nn::socket::Bind( m_Socket, &m_Server_addr );

    if( ret )
    {
        m_StatWindow.Printf( "Bind Error\n" );
    }


    m_RecvPacketNum    = 0;
    m_RecvPacketLength = 0;
    m_isRecvStart      = false;
    m_isEndRxTest      = false;
    m_ActuallyRecvNum  = 0;


    // Ɨp̃obt@쐬
    const int SOCKET_RECV_BUF_SIZE = 4096;
    const int CHECK_BUF_SIZE       = 10;
    char* RecvBuf  = new char[ SOCKET_RECV_BUF_SIZE ];

    std::memset( RecvBuf, 0x00, SOCKET_RECV_BUF_SIZE );

    const nn::fnd::TimeSpan RxTimeOutSpan = nn::fnd::TimeSpan::FromSeconds( m_RxTimeOutSec );
    nn::os::Tick StartRxTick = nn::os::Tick::GetSystemCurrent();

    s32 ReturnRecv;

    while( true )
    {
        if(( nn::os::Tick::GetSystemCurrent() - StartRxTick ).ToTimeSpan().GetMilliSeconds() > RxTimeOutSpan.GetMilliSeconds())
        {
            m_StatWindow.Printf("TimeOut Time = %d\n", m_RxTimeOutSec );
            DestroySocket();
            delete[] RecvBuf;
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::TIME_OUT );
        }
        //if( 0 > nn::socket::RecvFrom( m_Socket, RecvBuf, SOCKET_RECV_BUF_SIZE, nn::socket::MSG_DONTWAIT, &m_Server_addr ))
        ReturnRecv = nn::socket::RecvFrom( m_Socket, RecvBuf, SOCKET_RECV_BUF_SIZE, nn::socket::MSG_DONTWAIT, &m_Server_addr );
        //NN_LOG("Recv = %d\n", ReturnRecv );
        if( 0 > ReturnRecv )
        {
            continue;
        }

        if( CommandUtil::CompareString( RecvBuf, "STA"))
        {
            m_RecvPacketNum = CommandUtil::ConvertNumFromString( &RecvBuf[5], 3 );
            m_RecvPacketLength = CommandUtil::ConvertNumFromString( &RecvBuf[8], 3 );
            m_isRecvStart = true;
            NN_LOG("TestStart! PacketNum = %d\n", m_RecvPacketNum );
        }
        else
        {
            if( m_isRecvStart )
            {
                if( CommandUtil::CompareString( RecvBuf, "END"))
                {
                    m_isEndRxTest = true;
                    break;
                }
                else
                {
                    if( CheckRecvData( RecvBuf, m_RecvPacketLength ))
                    {
                        m_ActuallyRecvNum++;
                    }

                }
            }
        }
        std::memset( RecvBuf, 0x00, SOCKET_RECV_BUF_SIZE );
    }

    delete[] RecvBuf;

    nn::socket::Close( m_Socket );

    //if( !DestroySocket())
    //{
    //    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    //}

    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    std::sprintf( m_WorkBuf, "%d#%d", m_ActuallyRecvNum, m_RecvPacketNum );
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );
}
//------------------------------------------------------------------------------
// Desc   FRxeXg̍ۂ̃^CAEgݒ
// Arg    F^CAEg܂ł̎(Second)
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::ATH_SetRxTimeOut( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    m_RxTimeOutSec = CommandUtil::ConvertNumFromString( arg, std::strlen( arg ));
    NN_LOG("TimeOutSec = %d\n", m_RxTimeOutSec );
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FAPRSSI̒l擾
// Arg    FȂ
// Return FRSSI̒l
//------------------------------------------------------------------------------
const char* TestWireless::ATH_GetRSSI( const char* arg )
{
    #if 1  // APڑRSSI擾
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );



    nn::Result result;
    nn::ac::CTR::AccessPoint AP;

    result = GetConnectingAccessPoint( &AP );
    if( result.IsFailure())
    {
        m_StatWindow.Printf("Get RSSI Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    NN_LOG("RSSI = %d\n", AP.rssi );

    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );

    std::sprintf( m_WorkBuf, "%d", AP.rssi );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );


    #else  // A^CłRSSI擾(x)

    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );




    nn::Result result;
    const int AP_LEN = 10;
    nn::ac::CTR::AccessPoint AP[ AP_LEN ];
    nn::nwm::Ssid MySSID( m_AP_SSID );

    int RSSI_Count = 0;
    u8  FindAP = 0;

    for( int i = 0; i < RSSI_CHECK_NUM; i++ )
    {
        result = ScanAccessPoint( &FindAP, AP, AP_LEN );
        if( result.IsFailure())
        {
            //NN_UTIL_PANIC_IF_FAILED(result);
            m_StatWindow.Printf("Scan AccessPoint Error\n");
            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
        }

        for( int j = 0; j < FindAP; j++ )
        {
            if( AP[j].ssid == MySSID )
            {
                NN_LOG("Find = %d RSSI = %d, j = %d\n", FindAP, AP[j].rssi, j );
                RSSI_Count += AP[j].rssi;
            }
        }
        std::memset( AP, 0x00, sizeof(AP));
    }

    NN_LOG("RSSI = %d\n", RSSI_Count / RSSI_CHECK_NUM );

    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    std::sprintf( m_WorkBuf, "%d", RSSI_Count / RSSI_CHECK_NUM );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );
    #endif

}

//------------------------------------------------------------------------------
// Desc   FڑĂ`l̎擾
// Arg    FȂ
// Return F`l
//------------------------------------------------------------------------------
const char* TestWireless::ATH_GetChannel( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );


    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    std::sprintf( m_WorkBuf, "%02d", m_MyChannel );
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );
}

//------------------------------------------------------------------------------
// Desc   FMPʐM̏
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::MP_Init( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );


    nn::Result result;

    result = nn::mp::CTR::Initialize();
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("MP Initialize Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    result = nn::mp::CTR::SetPortConfig( 0, true, 0 );
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("MP SetPortConfig Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );

}

//------------------------------------------------------------------------------
// Desc   FMPʐM̏I
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::MP_End( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );


    nn::Result result;

    result = nn::mp::CTR::Finalize();
    if( result.IsFailure() )
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("MP Finalize Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }


    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FMPʐM̃`lw
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::MP_SetChannel( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );


    m_MPChannel = CommandUtil::ConvertNumFromString( arg, std::strlen( arg ));

    if( m_MPChannel == CommandUtil::CONVERT_ERROR_NUM )
    {
        m_StatWindow.Printf("MP SetChannel Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    NN_LOG("Channel = %d\n", m_MPChannel );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FMPʐMAPSSIDݒ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::MP_SetSSID( const char* arg )
{
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );

    std::memset( m_MP_AP_SSID, 0x00, MAX_SSID_SIZE );
    std::strcpy( m_MP_AP_SSID, arg );
    NN_LOG("Set SSID = %s\n", m_MP_AP_SSID );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}



//------------------------------------------------------------------------------
// Desc   FAPɑ΂ăANeBuXLARSSIlԂ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::MP_StartActiveScan( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );

    nn::mp::CTR::Config config;
    nn::Result result;
    nn::mp::CTR::BssDesc bssDesc[ NN_MP_SCAN_BSS_MAX ];

    config.mode = NN_MP_MODE_CHILD;
    config.recvmode = NN_MP_RECVMODE_PORT;

    nn::mp::CTR::Start( &config );

    nn::mp::CTR::ScanParam param;

    std::memset( &param, 0, sizeof( nn::mp::CTR::ScanParam ));
    param.channelBits = 0x0001<< ( m_MPChannel - 1 ) ;  //1chŒ
    param.maxChannelTime = 1000;        // XLԁi1bj
    param.descNum = NN_MP_SCAN_BSS_MAX; // őXL
    std::memset( param.bssid, 0xff, 6 );    // SMACAhXΏ

    result = nn::mp::CTR::Scan( bssDesc, &param, NN_MP_SCANTYPE_ACTIVE );
    if( result.IsFailure())
    {
        m_StatWindow.Printf("Scan Failure\n");
        nn::dbg::PrintResult( result );
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    result = nn::mp::CTR::Stop();
    if( result.IsFailure())
    {
        m_StatWindow.Printf("MP Can't Stop\n");
        nn::dbg::PrintResult( result );
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    for ( int i = 0; i < NN_MP_SCAN_BSS_MAX; i++ )
    {
        NN_LOG("num = %d Set = %s scan = %s\n", i, m_MP_AP_SSID, reinterpret_cast<char*>( bssDesc[i].ssid ));
        m_StatWindow.Printf("num = %d Set = %s scan = %s\n", i, m_MP_AP_SSID, reinterpret_cast<char*>( bssDesc[i].ssid ));
        if( 0 == std::strcmp( m_MP_AP_SSID, reinterpret_cast<char*>( bssDesc[i].ssid )))
        {
            const int RETURN_RSSI_LENGTH = 5;
            static char returnMPRSSI[ RETURN_RSSI_LENGTH ];
            NN_LOG("RSSI = %d\n", bssDesc[i].rssi );
            std::sprintf( returnMPRSSI, "%X", GetRssi8( bssDesc[i].rssi ));

            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, returnMPRSSI );
        }
    }
    NN_LOG("No Hit\n");
    m_StatWindow.Printf("AP Can't Discover\n");
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );

}

//------------------------------------------------------------------------------
// Desc   FCTRbr[R𑗐M
// Arg    Fob(16i)
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::MP_StartBeacon( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );


    int sendSec = CommandUtil::ConvertNumFromString( arg, std::strlen( arg ));
    if( sendSec == CommandUtil::CONVERT_ERROR_NUM )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    nn::mp::CTR::Config config;
    nn::Result result;
    TimeCounter tCount;
    const int PARENT_DATA_SIZE = 4;
    const int CHILD_DATA_SIZE  = 4;

    config.mode               = NN_MP_MODE_PARENT;
    config.ggid               = 0x00;
    config.tgid               = NN_MP_TGID_AUTO;
    config.channel            = m_MPChannel;
    config.lifeTime           = NN_MP_LIFETIME_DEFAULT;
    config.beaconPeriod       = 10;
    config.maxNodes           = NN_MP_AID_MAX-1; //15
    config.parentMaxSize      = PARENT_DATA_SIZE;
    config.childMaxSize       = CHILD_DATA_SIZE;
    config.entryFlag          = 1;
    config.frequency          = 1;
    config.userGameInfoLength = NN_MP_GAMEINFO_USER_SIZE;

    result = nn::mp::CTR::Start( &config );
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("MP Start Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    while( tCount.GetTimeSpan().GetSeconds() < sendSec )
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
    }

    result = nn::mp::CTR::Stop();
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("MP Stop Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FAPɑ΂ăpbVuXLARSSIlԂ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::MP_StartPassiveScan( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%s Exec! arg = %s\n", __func__, arg );


    nn::mp::CTR::Config config;
    nn::Result result;
    nn::mp::CTR::BssDesc bssDesc[ NN_MP_SCAN_BSS_MAX ];

    config.mode = NN_MP_MODE_CHILD;
    config.recvmode = NN_MP_RECVMODE_PORT;

    nn::mp::CTR::Start( &config );

    nn::mp::CTR::ScanParam param;

    std::memset( &param, 0, sizeof( nn::mp::CTR::ScanParam ));
    param.channelBits = 0x0001<< ( m_MPChannel - 1 ) ;  // 1chŒ
    param.maxChannelTime = 1000;                        // XLԁi1bj
    param.descNum = NN_MP_SCAN_BSS_MAX;                 // őXL
    std::memset( param.bssid, 0xff, 6 );                // SMACAhXΏ

    result = nn::mp::CTR::Scan( bssDesc, &param );
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("MP Scan Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }


    for ( int i = 0; i < NN_MP_SCAN_BSS_MAX; i++ )
    {
        if( 0 == std::strcmp( m_MP_AP_SSID, reinterpret_cast<char*>( bssDesc[i].ssid )))
        {
            const int RETURN_RSSI_LENGTH = 5;
            static char returnMPRSSI[ RETURN_RSSI_LENGTH ];
            NN_LOG("RSSI = %d\n", bssDesc[i].rssi );
            std::sprintf( returnMPRSSI, "%X", GetRssi8( bssDesc[i].rssi ) );

            result = nn::mp::CTR::Stop();
            if( result.IsFailure())
            {
                nn::dbg::PrintResult( result );
                m_StatWindow.Printf("MP Stop Error\n");
                return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
            }

            return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, returnMPRSSI );
        }
    }
    NN_LOG("Can't Get AP\n");
    m_StatWindow.Printf("Can't Discover AP\n");
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );

}



/*
const char* TestWireless::ATH_GetPacketErrorRate( const char* arg )
{
    NN_UNUSED_VAR( arg )

    if( !m_isEndRxTest )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::OPERATING );
    }
    else
    {
        char ResultString[ 100 ];
        std::sprintf( ResultString, "%u#%u", m_ActuallyRecvNum, m_ExpectedRecvNum );
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, ResultString );
    }
}
*/
//------------------------------------------------------------------------------
// Desc   FWRFUW[MacAddress擾
// Arg    FȂ
// Return FMacAddress(12)
//------------------------------------------------------------------------------
const char* TestWireless::CTR_GetMacAddress( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    std::sprintf( m_WorkBuf,"%02X%02X%02X%02X%02X%02X", m_MacAddress[0], m_MacAddress[1], m_MacAddress[2],
                                                               m_MacAddress[3], m_MacAddress[4], m_MacAddress[5] );
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );

}

//------------------------------------------------------------------------------
// Desc   FVAio[̓ǂݍ
// Arg    FȂ
// Return FVAio[
//------------------------------------------------------------------------------
const char* TestWireless::CTR_GetSerialNumber( const char* arg )
{
    NN_UNUSED_VAR( arg );
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    uji::sys::GetSerialNumber( m_WorkBuf );
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );

}

//------------------------------------------------------------------------------
// Desc   FModuleID̓ǂݍ
// Arg    FȂ
// Return FVAio[
//------------------------------------------------------------------------------
const char* TestWireless::CTR_GetModuleID( const char* arg )
{
    NN_UNUSED_VAR( arg );
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    u8 moduleID;
    const int MODULE_ID_ADDR = 0x2F;

    nn::cfg::nor::CTR::Initialize();
    nn::cfg::nor::CTR::Read( MODULE_ID_ADDR, &moduleID, sizeof(u8) );

    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    std::sprintf( m_WorkBuf, "%02X", moduleID );
    nn::cfg::nor::CTR::Finalize();

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );

}

//------------------------------------------------------------------------------
// Desc   FFirmwareType̓ǂݍ
// Arg    FȂ
// Return FVAio[
//------------------------------------------------------------------------------
const char* TestWireless::CTR_GetFirmwareType( const char* arg )
{
    NN_UNUSED_VAR( arg );
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    u8 firmwareType;
    const int FIRMWARE_TYPE_ADDR = 0x1FD;

    nn::cfg::nor::CTR::Initialize();
    nn::cfg::nor::CTR::Read( FIRMWARE_TYPE_ADDR, &firmwareType, sizeof(u8) );

    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    std::sprintf( m_WorkBuf, "%02X", firmwareType );
    nn::cfg::nor::CTR::Finalize();

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );
}


//------------------------------------------------------------------------------
// Desc   FVAio[̏
// Arg    FȂ
// Return FMacAddress(12)
//------------------------------------------------------------------------------
const char* TestWireless::CTR_WriteSerialNumber( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    if( !uji::seq::pl::LINE == m_TestMode )
    {
        std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
        std::strcpy( m_WorkBuf, arg );
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }
    
    if( uji::sys::WriteSerialNumber( arg ))
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }else
    {
        m_StatWindow.Printf("Write SerialNumber Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

}

//------------------------------------------------------------------------------
// Desc   Ft@[EFÃo[W擾
// Arg    FȂ
// Return Ft@[EFAo[W
//------------------------------------------------------------------------------
const char* TestWireless::CTR_GetFirmwareVersion( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    nn::Result result;
    nn::nwm::CTR::HardwareInfo HWInfo;

    result = nn::nwm::CTR::InitializeExtControl();
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("RFU InitializeExtControl Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    result = nn::nwm::CTR::Ext::GetHardwareInfo( HWInfo );
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("GetHardwareInfo Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    result = nn::nwm::CTR::FinalizeExtControl();
    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        m_StatWindow.Printf("RFU FinalizeExtControl Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    std::memset( m_WorkBuf, 0x00, MAX_COMMAND_SIZE );
    std::sprintf( m_WorkBuf, "%08X", HWInfo.firmwareVersion );
    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );

}

//------------------------------------------------------------------------------
// Desc   F{̂̃[W擾
// Arg    FȂ
// Return F{̂̃[W
//------------------------------------------------------------------------------
const char* TestWireless::CTR_GetRegion( const char* arg )
{
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );


    nn::cfg::CTR::CfgRegionCode region;
    
    region = uji::sys::GetRegionCode();

    switch( region )
    {
        case nn::cfg::CFG_REGION_AMERICA    :
            std::sprintf( m_WorkBuf, "USA");
            break;

        case nn::cfg::CFG_REGION_CHINA      :
            std::sprintf( m_WorkBuf, "CHN");
            break;

        case nn::cfg::CFG_REGION_EUROPE     :
            std::sprintf( m_WorkBuf, "EUR");
            break;
        case nn::cfg::CFG_REGION_JAPAN      :
            std::sprintf( m_WorkBuf, "JPN");
            break;

        case nn::cfg::CFG_REGION_KOREA      :
            std::sprintf( m_WorkBuf, "KOR");
            break;

        case nn::cfg::CFG_REGION_TAIWAN     :
            std::sprintf( m_WorkBuf, "TWN");
            break;

        case nn::cfg::CFG_REGION_AUSTRALIA  :
            std::sprintf( m_WorkBuf, "AUS");
            break;

        default  :
            std::sprintf( m_WorkBuf, "UNKNOWN REGION");
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, m_WorkBuf );

}

//------------------------------------------------------------------------------
// Desc   FCTR{̂ɃZbg
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::CTR_SetReset( const char* arg )
{
    NN_UNUSED_VAR( arg )


    uji::eva::mcu::EvaReset();

    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromSeconds(10)); // Zbg܂łŎ~܂

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FCTR{̂̓d𗎂Ƃ
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::CTR_SetPowerOff( const char* arg )
{
    NN_UNUSED_VAR( arg )


    uji::eva::mcu::EvaPowerOff();


    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromSeconds(10));  // d܂łŎ~܂


    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}




//------------------------------------------------------------------------------
// Desc   FvÕo[W擾
// Arg    FȂ
// Return FvOo[W
//------------------------------------------------------------------------------
const char* TestWireless::TESTER_GetVersion( const char* arg )
{
    NN_UNUSED_VAR( arg )


    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, VERSION_STRING );
}
//------------------------------------------------------------------------------
// Desc   FvÕrh擾
// Arg    FȂ
// Return FvÕrh
//------------------------------------------------------------------------------
const char* TestWireless::TESTER_GetBuildDate( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS, VERSION_DATE );
}
//------------------------------------------------------------------------------
// Desc   FiOpjJnԐݒ
// Arg    FJn
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::TESTER_SetTime( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );



    const u8 DATA_AND_TIME_LEN = 16;

    if( std::strlen( arg ) != DATA_AND_TIME_LEN )  // ̒̂e
    {
        m_StatWindow.Printf("Data Length Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    const u8 SEPARATOR_POSITION = 10;

    if( arg[ SEPARATOR_POSITION ] != '#' )  // ̔ẑe
    {
        m_StatWindow.Printf("Data Format Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    const u8 DATE_NUM   = 10;
    const u8 TIME_START = 11;
    const u8 TIME_NUM   = 5;

    std::memset( m_StartTestDate, 0x00, sizeof( m_StartTestDate ));
    std::memset( m_StartTestTime, 0x00 ,sizeof( m_StartTestTime ));

    std::memcpy( m_StartTestDate, &arg[0], DATE_NUM );
    std::memcpy( m_StartTestTime, &arg[ TIME_START ], TIME_NUM );

    NN_LOG("TestDate = %s\n", m_StartTestDate );
    NN_LOG("TestTime = %s\n", m_StartTestTime );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FiOpj[hݒ
// Arg    F[h
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::TESTER_SetTestMode( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    const u8 SEPARATOR_POSITION = 1;
    if( '#' != arg[ SEPARATOR_POSITION ])
    {
        m_StatWindow.Printf("TestMode Set Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    m_TestMode = CommandUtil::ConvertNumFromString( arg, 1 );

    const u8 TESTER_ID_START  = 2;
    const u8 TESTER_ID_LENGTH = 6;

    std::memset( m_TesterID, 0x00, sizeof( m_TesterID ));

    std::memcpy( m_TesterID, &arg[ TESTER_ID_START ], TESTER_ID_LENGTH );

    NN_LOG("TestMode = %d TesterID = %s\n", m_TestMode, m_TesterID );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}
//------------------------------------------------------------------------------
// Desc   FiOpjJnO
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::TESTER_WriteStartLog( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    if( m_TestMode == uji::seq::pl::DEBUG )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    #if 1
    // O
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    if( 0 <= pdl->Add_1Line( m_TestMode, "Wireless", "START", VERSION_STRING, m_StartTestDate, m_StartTestTime, m_TesterID, arg ))
    {
        pdl->Finalize();
        delete pdl;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }else
    {
        pdl->Finalize();
        delete pdl;
        m_StatWindow.Printf("Write StartLog Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    
    
    
    #endif

}
//------------------------------------------------------------------------------
// Desc   FiOpjOKO
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::TESTER_WriteOKLog( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );

    if( m_TestMode == uji::seq::pl::DEBUG )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    const u8 LOG_MESSAGE_MAX = 80;
    char logMessage[ LOG_MESSAGE_MAX ] = "";

    int separatorPosition = 0;
    std::strcat( logMessage, CreateOKLogMessage( &arg[ separatorPosition ]));

    //NN_LOG("%s\n", logMessage );

    while( arg[ separatorPosition ] != '\0' )
    {
        if( arg[ separatorPosition ] == '#' )
        {
            std::strcat( logMessage, "$" );
            //std::strcat( logMessage, "\n" );
            std::strcat( logMessage, CreateOKLogMessage( &arg[ separatorPosition + 1 ]));

        }
        separatorPosition++;
    }
    NN_LOG("%s\n", logMessage );
    m_StatWindow.Printf("%s\n", logMessage );
    #if 1
    // O
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    if( 0 <= pdl->Add_1Line( m_TestMode, "Wireless", "OK", VERSION_STRING, m_StartTestDate, m_StartTestTime, m_TesterID, logMessage ))
        {
        pdl->Finalize();
        delete pdl;
        //#ifdef EVA_COMPOSITE
        m_TestResult = RESULT_OK;
        //#endif
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }else
    {
        pdl->Finalize();
        
        delete pdl;
        //#ifdef EVA_COMPOSITE
        m_TestResult = RESULT_NG;
        //#endif
        m_StatWindow.Printf("Write OKLog Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }
    #else
    // O
    uji::seq::ProductionLog pdl;
    pdl.Initialize();
    if( 0 <= pdl.Add_1Line( m_TestMode, "Wireless", "OK", VERSION_STRING, m_StartTestDate, m_StartTestTime, m_TesterID, logMessage ))
    {
        pdl.Finalize();
        //#ifdef EVA_COMPOSITE
        m_TestResult = RESULT_OK;
        //#endif
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }else
    {
        pdl.Finalize();
        //#ifdef EVA_COMPOSITE
        m_TestResult = RESULT_NG;
        //#endif
        m_StatWindow.Printf("Write OKLog Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    #endif

}
//------------------------------------------------------------------------------
// Desc   FiOpjNGR[h
// Arg    FNGR[h
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::TESTER_WriteNGLog( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );
    
    if( m_TestMode == uji::seq::pl::DEBUG )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    // O
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    //#ifdef EVA_COMPOSITE
    m_TestResult = RESULT_NG;
    //#endif
    if( 0<= pdl->Add_1Line( m_TestMode, "Wireless", "NG", VERSION_STRING, m_StartTestDate, m_StartTestTime, m_TesterID, arg ))
    {
        pdl->Finalize();
        delete pdl;
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
    }else
    {
        pdl->Finalize();
        delete pdl;
        m_StatWindow.Printf("Write NGLog Error\n");
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }


}
//------------------------------------------------------------------------------
// Desc   FCTR̃^CJE^[擾
// Arg    FȂ
// Return F^CJE^[̒l
//------------------------------------------------------------------------------
const char* TestWireless::TESTER_GetTimeCounter( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );



    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS,
                        CommandUtil::ConvertStringFromTimeSpan( m_TimeCounter.GetTimeSpan()));
}

//------------------------------------------------------------------------------
// Desc   Fڑ`lw肷
// Arg    F`l
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::DEBUG_SetChannel( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );



    nn::Result result;
    u8 channel = CommandUtil::ConvertNumFromString( arg, std::strlen( arg ));

    NN_LOG("channel = %d\n", channel );

    result = Internal::SetNetworkSetting_Ip_ScanlessConnect_LastConnectedChannnel( channel );
    NN_UTIL_PANIC_IF_FAILED( result );

    // Internalݒ𔽉f
    result = Internal::UpdateNetworkSetting( 0 );
    NN_UTIL_PANIC_IF_FAILED( result );

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// Desc   FScanlessConnect
// Arg    FȂ
// Return FȂ
//------------------------------------------------------------------------------
const char* TestWireless::DEBUG_ScanlessConnect( const char* arg )
{
    NN_UNUSED_VAR( arg )
    NN_LOG("%02x: %s Arg = %s\n",m_RecvCommCount - 1, __func__, arg );



    nn::Result result;

        result = Internal::SetNetworkSetting_Ip_ScanlessConnect_HasConnected( true );
        NN_UTIL_PANIC_IF_FAILED( result );
    // Internalݒ𔽉f
    result = Internal::UpdateNetworkSetting( 0 );
    NN_UTIL_PANIC_IF_FAILED( result );

    NN_LOG("Connect Line = %d\n", __LINE__ );

    nn::ac::Config config;
    nn::ac::CreateDefaultConfig( &config );
    nn::ac::CTR::SetNetworkArea( &config, nn::ac::NETWORK_AREA_LAN );

    NN_LOG("Connect Line = %d\n", __LINE__ );

    result = nn::ac::Connect( config );

    NN_LOG("Connect Line = %d\n", __LINE__ );

    //NN_UTIL_PANIC_IF_FAILED( result );
    if( result.IsFailure())
    {
        NN_LOG("Connect\n");
        nn::dbg::PrintResult( result );
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    NN_LOG("Connect Success!\n");

    // IPAdress擾p
    {
        nn::socket::Initialize();
        m_MyIpAddress.addr = nn::socket::GetHostId();
        nn::socket::Finalize();
    }
    // IPȂꍇAڑ̂sĂƂ݂ȂAؒfsB
    if( m_MyIpAddress.addr == 0 )
    {
        nn::ac::Close();
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    {   // ڑĂ`l̎擾
        nn::ac::AccessPoint AP;
        nn::ac::GetConnectingAccessPoint( &AP );

        m_MyChannel = AP.channel;
        NN_LOG("Channel = %d\n", m_MyChannel );
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

const char* TestWireless::DEBUG_SetStartPacketNum( const char* arg )
{
    debTxParam.startPacketNum = CommandUtil::ConvertNumFromString( arg, std::strlen( arg ));

    if( m_PortNum == CommandUtil::CONVERT_ERROR_NUM )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );

}

const char* TestWireless::DEBUG_SetStartPacketWait( const char* arg )
{

    debTxParam.startPacketWait = CommandUtil::ConvertNumFromString( arg, std::strlen( arg ));

    if( m_PortNum == CommandUtil::CONVERT_ERROR_NUM )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

const char* TestWireless::DEBUG_SetStartPacketInterval( const char* arg )
{
    debTxParam.startPacketInterval = CommandUtil::ConvertNumFromString( arg, std::strlen( arg ));

    if( m_PortNum == CommandUtil::CONVERT_ERROR_NUM )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

const char* TestWireless::DEBUG_SetDataPacketWait( const char* arg )
{
    debTxParam.dataPacketWait = CommandUtil::ConvertNumFromString( arg, std::strlen( arg ));

    if( m_PortNum == CommandUtil::CONVERT_ERROR_NUM )
    {
        return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::FAILURE );
    }

    return CommandUtil::CreateRSCAndResponseArgString( CommandUtil::SUCCESS );
}

//------------------------------------------------------------------------------
// ܂Ō֐
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
// X^[gpPbg̑MsB
//------------------------------------------------------------------------------
void TestWireless::SendStartPacket( const u32 &sendCount, const u32 &sendSize )
{
    const u8 START_PACKET_SIZE = ( 5+3+3+1 );
    char StartBuf[ START_PACKET_SIZE ] = "";

    std::sprintf( StartBuf, "START%03X%03X", sendCount, sendSize );

    nn::socket::SendTo( m_Socket, StartBuf, sizeof( StartBuf ) - 1 , 0 , &m_Send_Addr );
}

//------------------------------------------------------------------------------
// f[^t[pPbg̑MsB
//------------------------------------------------------------------------------
void TestWireless::SendDataFramePacket( const u32 &sendCount, const u32 &sendSize )
{
    u8 NowSend = 0;
    u8 SendDataFrameBuf[ sendSize ];
    for( int i = 0; i < sendCount; i++ )
    {
        std::memset( SendDataFrameBuf, NowSend, sendSize );
        nn::socket::SendTo( m_Socket, SendDataFrameBuf, sizeof( SendDataFrameBuf ) , 0 , &m_Send_Addr );
        if( NowSend == 0xFF ) // MJE^0xFFɒB0x00ɖ߂
        {
            NowSend = 0;
        }else
        {
            NowSend++;
        }
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(5));
    }
}

//------------------------------------------------------------------------------
// GhpPbg̑MsB
//------------------------------------------------------------------------------
void TestWireless::SendEndPacket()
{
    const char EndBuf[] = "END";
    nn::socket::SendTo( m_Socket, EndBuf, sizeof( EndBuf ) - 1 , 0 , &m_Send_Addr );
}

//------------------------------------------------------------------------------
// Mf[^t[̐mF
//------------------------------------------------------------------------------
bool TestWireless::CheckRecvData( const char* RecvBuf, int &PacketLength )
{
    for( int i = 1; i < PacketLength; i++ )
    {
        if( !( RecvBuf[0] == RecvBuf[i] ) )
        {
            return false;
        }
    }
    return true;
}

//------------------------------------------------------------------------------
// \Pbg쐬
//------------------------------------------------------------------------------
bool TestWireless::CreateSocket()
{
    NN_LOG("%s Exec!\n", __func__ );
    nn::Result result;
    //result = nn::socket::Initialize();
    do
    {
        result = nn::socket::Initialize();
        nn::dbg::PrintResult( result );
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(500));
    }while( result.IsFailure());

    m_MyIpAddress.addr = nn::socket::GetHostId();
    NN_LOG("IP = %s\n",nn::socket::InetNtoA( m_MyIpAddress ));

    return true;
}

//------------------------------------------------------------------------------
// \Pbgj
//------------------------------------------------------------------------------
bool TestWireless::DestroySocket()
{
    nn::Result result;
    result = nn::socket::Finalize();

    if( result.IsFailure())
    {
        nn::dbg::PrintResult( result );
        return false;
    }

    return true;
}

//------------------------------------------------------------------------------
// hbg10ĩAhX1~4oCgsɕϊ
//------------------------------------------------------------------------------

union changeIP
{
    u32 addrU32;
    u8  addrU8[4];
};

void TestWireless::U32ToU8Matrix( const nn::socket::InAddr &inAddr, u8 outAddr[] )
{
    changeIP cIP;
    cIP.addrU32 = inAddr.addr;

    for(int i = 0; i < 4; i++ )
    {
        outAddr[i] = cIP.addrU8[i];
    }

}


u8 TestWireless::GetRssi8( u8 rssi )
{
    if ( rssi & 0x0002 )
    {
        return static_cast<u8>( rssi >> 2 );
    }
    return static_cast<u8>(( rssi >> 2 ) + 25 );
}

//------------------------------------------------------------------------------
// ĂR}hOKLog̃bZ[W쐬
//------------------------------------------------------------------------------
const char* TestWireless::CreateOKLogMessage( const char* arg )
{
    const u8 LOG_MESSAGE_MAX = 80;
    static char returnMessage[ LOG_MESSAGE_MAX ];
    std::memset( returnMessage, 0x00, sizeof( returnMessage ));

    int ch        = 0;
    int frameRate = 0;
    int rssi      = 0;

    int arrayStart = 0;
    int arrayEnd   = 0;
    bool isTx;

    if( arg[ arrayStart ] == 'T' || arg[ arrayStart ] == 't' )
    {
        isTx = true;
    }else
    {
        isTx = false;
    }

    arrayStart = arrayEnd = 2;

    while( true )
    {
        if( arg[ arrayEnd ] == '@' )
        {
            break;
        }
        arrayEnd++;
    }
    ch = CommandUtil::ConvertNumFromString( &arg[ arrayStart ], arrayEnd - arrayStart );

    arrayStart = ++arrayEnd;

    while( true )
    {
        if( arg[ arrayEnd ] == '@' )
        {
            break;
        }
        arrayEnd++;
    }

    frameRate = CommandUtil::ConvertNumFromString( &arg[ arrayStart ], arrayEnd - arrayStart );

    arrayStart = ++arrayEnd;

    while( true )
    {
        if( arg[ arrayEnd ] == '#' || arg[ arrayEnd ] == '\0' )
        {
            break;
        }
        arrayEnd++;
    }

    rssi = CommandUtil::ConvertNumFromString( &arg[ arrayStart ], arrayEnd - arrayStart );

    if( isTx )
    {
        std::sprintf( returnMessage, "CH:%d FR:%d RSTx:%d", ch, frameRate, rssi );
    }else
    {
        std::sprintf( returnMessage, "CH:%d FR:%d RSRx:%d", ch, frameRate, rssi );
    }
    return returnMessage;
}

//------------------------------------------------------------------------------
// MR}hFĉʕ\
//------------------------------------------------------------------------------
void TestWireless::PrintRecvCommand( const CommPack commPack )
{
    //const int MAX_PRINT_BUF = 100;
    //char PrintBuf[ MAX_PRINT_BUF ] = "";
    //
    //std::memcpy( PrintBuf, &str[0], 4 );
    //m_CommWindow.SetTextColor( ATTR_COLOR_CYAN );
    //m_CommWindow.Printf( PrintBuf );
    //std::memset( PrintBuf, 0x00, 4 );
    //
    //std::memcpy( PrintBuf, &str[4], 4 );
    //m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
    //m_CommWindow.Printf( PrintBuf );
    //std::memset( PrintBuf, 0x00, 4 );
    //
    //std::memcpy( PrintBuf, &str[8], 2 );
    //m_CommWindow.SetTextColor( ATTR_COLOR_CYAN );
    //m_CommWindow.Printf( PrintBuf );
    //std::memset( PrintBuf, 0x00, 2 );
    //
    //m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
    //m_CommWindow.Printf( "%s\n", &str[10]);
    m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
    m_CommWindow.Printf( "%s Arg = %s\n", GetCommandName( commPack ), commPack.Arg );
    m_CommWindow.SetTextColor( ATTR_COLOR_WHITE );
}

//------------------------------------------------------------------------------
// MR}hFĉʕ\
//------------------------------------------------------------------------------
void TestWireless::PrintSendCommand( const char* str )
{
    const int MAX_PRINT_BUF = 100;
    char PrintBuf[ MAX_PRINT_BUF ] = "";

    std::memcpy( PrintBuf, &str[0], 4 );
    m_CommWindow.SetTextColor( ATTR_COLOR_GREEN );
    m_CommWindow.Printf("%s", PrintBuf );
    std::memset( PrintBuf, 0x00, 4 );

    std::memcpy( PrintBuf, &str[4], 4 );
    m_CommWindow.SetTextColor( ATTR_COLOR_YELLOW );
    m_CommWindow.Printf("%s", PrintBuf );
    std::memset( PrintBuf, 0x00, 4 );

    std::memcpy( PrintBuf, &str[8], 2 );
    m_CommWindow.SetTextColor( ATTR_COLOR_GREEN );
    m_CommWindow.Printf("%s", PrintBuf );
    std::memset( PrintBuf, 0x00, 2 );

    if( str[10] == '0' && str[11] == '0' )
    {
        m_CommWindow.SetTextColor( ATTR_COLOR_BLUE );
    }else
    {
        m_CommWindow.SetTextColor( ATTR_COLOR_RED );
    }
    std::memcpy( PrintBuf, &str[10], 2 );
    m_CommWindow.Printf("%s", PrintBuf );
    m_CommWindow.SetTextColor( ATTR_COLOR_YELLOW );
    m_CommWindow.Printf( "%s\n", &str[12]);
}

/************************************************************************
ʂɊG\

************************************************************************/
static void ShowPicture( wchar_t *file )
{
    GLuint s_TextureId;

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    JpegTexture jt;

    jt.Open( file );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            GL_RGB_NATIVE_DMP,
                                            jt.GetWidth(),
                                            jt.GetHeight(),
                                            GL_RGB_NATIVE_DMP,
                                            GL_UNSIGNED_SHORT_5_6_5,
                                            jt.GetTextureDataPointer(),
                                            s_TextureId );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
    gfx->m_DrawFramework->FillTexturedRectangle(s_TextureId,
                                                0.0f, 0.0f,
                                                GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT,
                                                GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT,
                                                jt.GetWidth(), jt.GetHeight() );
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->DeleteTexture(s_TextureId);
    jt.Close();

}


} // namespace eva
} // namespace uji
//
