#ifndef TEST_UDS_FOR_GYRO_H_INCLUDED
#define TEST_UDS_FOR_GYRO_H_INCLUDED

#include <nn.h>
#include "sys.h"
#include "UDS_Lib.h"

namespace uji{
namespace eva{


class TestUDSforGyro
{
    public:
    TestUDSforGyro() : gfx( uji::sys::GraphicsDrawing::GetInstance()),
                       SendWindow( 200/(FONT_SIZE/2), 160/FONT_SIZE,  FONT_SIZE ),
                       RecvWindow( 200/(FONT_SIZE/2), 160/FONT_SIZE,  FONT_SIZE ),
                       StusWindow( 200/(FONT_SIZE/2), 160/FONT_SIZE,  FONT_SIZE )
    {
        udsLib = new uji::eva::UDS_Lib;

    }
    
    ~TestUDSforGyro()
    {
        delete udsLib;
    }
    
    // GyroV[PX̐is󋵂񋓑()
    enum TestGyroStatus
    {
        Gyro_Init,
        Gyro_X_Start_Cal,
        Gyro_X_End_Cal,
        Gyro_Y_Start_Cal,
        Gyro_Y_End_Cal,
        Gyro_Z_Start_Cal,
        Gyro_Z_End_Cal,
        Gyro_Fin
    };
    
    static void ExecuteTestUDSforGyro()
    {
        TestUDSforGyro* tUDS = new TestUDSforGyro;
        tUDS->TestUDSforGyroCommon();
        delete tUDS;
    }
    
    static void WrappingDrawThread( void* param )
    {
        TestUDSforGyro* pTUfG = reinterpret_cast< TestUDSforGyro* >( param );
        pTUfG->DrawThread();
    }
    
    private:
    
    void TestUDSforGyroCommon();
    
    void SetStartParameter();
    
    void WriteSequenceData();
    
    void DrawThread();
    
    void CommunicationThread();

    
    //--------------------------------------------------------------------------
    // ϐ
    //--------------------------------------------------------------------------
    
    bool isMaster;
    u32  m_UniqueID;
    int  m_NowStatus;
    int  m_LastStatus;
    int  m_RecvStatus;
    int  m_TestNum;
    nn::fnd::TimeSpan StartTimeSpan;
    
    uji::eva::UDS_Lib* udsLib;
    
    
    uji::sys::GraphicsDrawing* gfx;
    
    uji::sys::TextWindow SendWindow;
    uji::sys::TextWindow RecvWindow;
    uji::sys::TextWindow StusWindow;
    
    uji::sys::WindowManager windowManager;
    
    //--------------------------------------------------------------------------
    // 萔
    //--------------------------------------------------------------------------
    
    static const u8 FONT_SIZE   = 10;
    static const u8 BUFFER_SIZE = FONT_SIZE*3;
    
};

} // namespace eva
} // namespace uji

#endif
