#include "TestUDSforGyro.h"
#include "UDS_Lib.h"

using namespace uji::sys;

namespace uji{
namespace eva{
    
#pragma diag_suppress 181
    
namespace
{
    //const wchar_t LOG_DATA_PATH[] = L"sdmc:/gyro/Gyrotest.log";
    
}


void TestUDSforGyro::CommunicationThread()
{
    m_NowStatus = Gyro_Init;
    StartTimeSpan = nn::os::Tick::GetSystemCurrent().ToTimeSpan();
    m_RecvStatus = Gyro_Init;
    m_TestNum = 0;
        

    if( isMaster )
    {
        udsLib->InitUDSConnectionMaster();
    }else
    {
        while( !udsLib->InitUDSConnectionClient( nn::fnd::TimeSpan::FromSeconds(10)))
        {
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(100));
        }
    }
    
    nn::fs::TryCreateDirectory( L"sdmc:/gyro");
    nn::fs::FileOutputStream fsOut;
    char MacAddress[17] = "";
    udsLib->GetMacAddress( MacAddress );
    char LOG_PATH[50];
    
    std::sprintf( LOG_PATH, "sdmc:/gyro/%s_ch_%d.log", MacAddress, udsLib->GetChannel() );
    
    wchar_t W_LOG_PATH[100];
    std::mbstowcs( W_LOG_PATH, LOG_PATH, std::strlen( LOG_PATH ) + 1 );
    
    NN_LOG("%s\n", LOG_PATH );
    fsOut.TryInitialize( LOG_PATH, true );
    
    
    
    nn::fnd::TimeSpan Timer = nn::os::Tick::GetSystemCurrent().ToTimeSpan();
    nn::fnd::TimeSpan WatchDog = nn::os::Tick::GetSystemCurrent().ToTimeSpan();
    char LogString[50];
    
    
    while( true )
    {
        RE_START:
        if( !isMaster )
        {
            if ( udsLib->IsDisconnected())
            {
                udsLib->InitUDSConnectionClient(nn::fnd::TimeSpan::FromSeconds(10));
            }
            //NN_LOG("Out Send Loop\n");
            
            if( udsLib->Receive( &m_RecvStatus, sizeof(int)))
            {
                NN_LOG("RecvStatus = %d\n", m_RecvStatus );
                if( m_RecvStatus != ( m_NowStatus + 1 ))
                {
                    NN_LOG("Error Status!\n");
                    
                }
                m_NowStatus = m_RecvStatus;
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000));
                m_NowStatus++;
                udsLib->SendTo( &m_NowStatus, sizeof(int));
                NN_LOG("SendStatus = %d\n", m_NowStatus );
                DrawThread();
                while( udsLib->GetLastSend() != UDS_Lib::SEND_SUCCESS )
                {
                    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(50));
                    if( udsLib->GetLastSend() == UDS_Lib::SEND_FAILURE )
                    {
                        udsLib->RetrySendTo( &m_NowStatus, sizeof(int));
                        NN_LOG("InSendLoopRetry\n");

                    }else
                    {
                        NN_LOG("InSendLoopNoRetry\n");
                    }
                    if ( udsLib->IsDisconnected())
                    {
                        goto RE_START;
                        //udsLib->InitUDSConnectionClient(nn::fnd::TimeSpan::FromSeconds(10));
                    }
                    DrawThread();
                }
                if( m_NowStatus >= Gyro_Z_End_Cal )
                {
                    m_NowStatus = Gyro_Init;
                    StartTimeSpan = nn::os::Tick::GetSystemCurrent().ToTimeSpan();
                }
                DrawThread();
                WatchDog = nn::os::Tick::GetSystemCurrent().ToTimeSpan();
            }else
            {
                if( 10 < ( nn::os::Tick::GetSystemCurrent().ToTimeSpan().GetSeconds() - WatchDog.GetSeconds()))
                {
                    udsLib->DisconnectNetwork();
                    WatchDog = nn::os::Tick::GetSystemCurrent().ToTimeSpan();
                }
            }
        }else
        {
            while( !udsLib->IsClientConnect() )
            {
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(100));
            }
            
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromSeconds(3));
            m_NowStatus++;
            udsLib->SendTo( &m_NowStatus, sizeof(int));
            NN_LOG("SendStatus = %d\n", m_NowStatus );
            while( udsLib->GetLastSend() != UDS_Lib::SEND_SUCCESS )
            {
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(50));
                if( udsLib->GetLastSend() == UDS_Lib::SEND_FAILURE )
                {
                    udsLib->RetrySendTo( &m_NowStatus, sizeof(int));
                    NN_LOG("InSendLoopRetry\n");
                }else
                {
                    NN_LOG("InSendLoopNoRetry\n");
                }
                DrawThread();
                if( !udsLib->IsClientConnect())
                {
                    //udsLib->Finalize();
                    //nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000));
                    //udsLib->Initialize();
                    //udsLib->InitUDSConnectionMaster();
                    //udsLib->SendThreadInit();
                    goto RE_START;
                }
            }
            DrawThread();
            while( !udsLib->Receive( &m_RecvStatus, sizeof(int)))
            {
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(15));
                if( !udsLib->IsClientConnect())
                {
                    //udsLib->Finalize();
                    //nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1000));
                    //udsLib->Initialize();
                    //udsLib->InitUDSConnectionMaster();
                    goto RE_START;
                }
                //NN_LOG("OutSendLoop\n");
            }
            NN_LOG("RecvStatus = %d\n", m_RecvStatus );
            if( m_RecvStatus != m_NowStatus + 1 )
            {
                NN_LOG("Error Status!\n");
                if( m_RecvStatus < 2 )
                {
                    m_NowStatus = m_RecvStatus - 2;
                }
            }else
            {
                m_NowStatus = m_RecvStatus;
            }
            if( m_NowStatus >= Gyro_Z_End_Cal )
            {
                m_TestNum++;
                m_NowStatus = Gyro_Init;
                std::sprintf( LogString, "TestNum = %03d Time = %d[s]\n", m_TestNum,
                              ( nn::os::Tick::GetSystemCurrent().ToTimeSpan().GetSeconds() - StartTimeSpan.GetSeconds()));

                RecvWindow.Printf("%s", LogString );
                fsOut.Write( LogString, std::strlen( LogString ));
                
                StartTimeSpan = nn::os::Tick::GetSystemCurrent().ToTimeSpan();
            }
         
        }
        DrawThread();
        
    }
}

void TestUDSforGyro::DrawThread()
{
    //while(true)
    {
        
        if( m_LastStatus != m_NowStatus )
        {
            SendWindow.Printf("NowStatus = %d\n", m_NowStatus );
            m_LastStatus = m_NowStatus;
        }
        
        
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        
        windowManager.Update();
        windowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        
        
        StusWindow.Printf("\f");
        if( isMaster )
        {
            StusWindow.Printf("YourType = Master\n");
        }else
        {
            StusWindow.Printf("YourType = Client\n");
        }
        
        StusWindow.Printf("YourUniqueID = %d\n", m_UniqueID );
        StusWindow.Printf("Time = %d\n", ( nn::os::Tick::GetSystemCurrent().ToTimeSpan().GetSeconds() - StartTimeSpan.GetSeconds() ));
        StusWindow.Printf("Channel = %d\n", udsLib->GetChannel());
        
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
        gfx->m_DrawFramework->Clear();
        
        windowManager.Update();
        windowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
    }
    
}
    

void TestUDSforGyro::TestUDSforGyroCommon()
{
    nn::Result result;
    nn::fs::Initialize();
    
    SetStartParameter();
    
    SendWindow.SetTitle("NowStatus");
    RecvWindow.SetTitle("TestNum&Result");
    StusWindow.SetTitle("TestInfo");
    
    windowManager.CreateWindow( &SendWindow, NN_GX_DISPLAY0,   0, 0 );
    windowManager.CreateWindow( &RecvWindow, NN_GX_DISPLAY0, 200, 0 );
    windowManager.CreateWindow( &StusWindow, NN_GX_DISPLAY1,   0, 0 );
    
    if( isMaster )
    {
        StusWindow.Printf("YourType = Master\n");
    }else
    {
        StusWindow.Printf("YourType = Client\n");
    }
    
    StusWindow.Printf("YourUniqueID = %d\n", m_UniqueID);
    
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->Clear();
    
    windowManager.Update();
    windowManager.DrawDisplay0();
    gfx->m_DrawFramework->SwapBuffers();
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->Clear();
    
    windowManager.Update();
    windowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    
    udsLib->Initialize();
    udsLib->SetUniqueID( m_UniqueID );
    udsLib->SetRetryNum( 20 );
    

    CommunicationThread();

    
}

void TestUDSforGyro::SetStartParameter()
{
    nn::Result result;
    NN_LOG("%s Execute!\n", __func__ );
    uji::sys::TextWindow setParamWindow( 400/(FONT_SIZE/2), 160/FONT_SIZE, FONT_SIZE );
    setParamWindow.SetTitle("Set Start Param");
    
    NN_LOG( "%d\n", __LINE__ );
    
    windowManager.CreateWindow( &setParamWindow, NN_GX_DISPLAY0, 0, 0 );
    NN_LOG( "%d\n", __LINE__ );

    while( true )
    {
        uji::sys::Pad().UpdatePad();
        if( Pad().IsButtonDown( sys::Pad::BUTTON_DOWN ) || Pad().IsButtonDown( sys::Pad::BUTTON_UP ) ||
            Pad().IsButtonDown( sys::Pad::BUTTON_A )    || Pad().IsButtonDown( sys::Pad::BUTTON_B ))
        {
            isMaster = !isMaster;
        }

        if( Pad().IsButtonDown( sys::Pad::BUTTON_START ))
        {
            break;
        }
        
        setParamWindow.Printf("\f");
        
        if( isMaster )
        {
            setParamWindow.Printf("YourType = Master\n");
        }else
        {
            setParamWindow.Printf("YourType = Client\n");
        }
        
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        windowManager.Update();
        windowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
    }
    
    if( isMaster )
    {
        const wchar_t SDMC_PATH[] = L"sdmc:/";
        nn::fs::Directory directory;
        result = directory.TryInitialize( SDMC_PATH );
        
        if( result.IsFailure())
        {
            SYS_PANIC("SD Card Error!");
        }
        
        directory.Finalize();
    }
    
    u32 Unique1 = 1;
    
    while( true )
    {
        uji::sys::Pad().UpdatePad();
        if( Pad().IsButtonDown( sys::Pad::BUTTON_DOWN ) || Pad().IsButtonDown( sys::Pad::BUTTON_B ))
        {
            Unique1--;
            if( Unique1 < 1 )
            {
                Unique1 = 21;
            }
        }
        if( Pad().IsButtonDown( sys::Pad::BUTTON_UP ) || Pad().IsButtonDown( sys::Pad::BUTTON_A ))
        {
            Unique1++;
            if( Unique1 > 21 )
            {
                Unique1 = 1;
            }
        }
        
        if( Pad().IsButtonDown( sys::Pad::BUTTON_START ))
        {
            break;
        }
        
        setParamWindow.Printf("\f");
        if( isMaster )
        {
            setParamWindow.Printf("YourType = Master\n");
        }else
        {
            setParamWindow.Printf("YourType = Client\n");
        }
        setParamWindow.Printf("Set UniqueID = %2d\n", Unique1 );
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        windowManager.Update();
        windowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
    }
    m_UniqueID = Unique1;
    uji::sys::Pad().UpdatePad(); // ǂ
    setParamWindow.Printf("Press Start!\n");
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->Clear();
    windowManager.Update();
    windowManager.DrawDisplay0();
    gfx->m_DrawFramework->SwapBuffers();
    
    do
    {
        Pad().UpdatePad();
        gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY0 );
        
    }while( !Pad().IsButtonDown( sys::Pad::BUTTON_START ));
    
    
    windowManager.DestroyWindow( &setParamWindow );
    setParamWindow.Destroy();
}

//void TestUDSforGyro::WriteSequenceData()
//{
//    nn::Result result;
//    nn::fs::FileOutputStream fsOut;
//    result = fsOut.TryInitialize( LOG_DATA_PATH, true );
//    NN_UTIL_PANIC_IF_FAILED( result );
//    
//    static int Testnum = 0;
//    
//    //fsOut.TrySeek( 0, nn::fs::POSITION_BASE_END );
//    result = fsOut.TrySetPosition( fsOut.GetSize());
//    //NN_UTIL_PANIC_IF_FAILED( result );
//    fsOut.Write( "Test3\n", 5 );
//    
//    fsOut.Finalize();
//    
//    Testnum++;
//}
//    

#pragma diag_default 181

} // namespace eva
} // namespace uji

