﻿/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     uds_Main.cpp

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 14186 $
 *---------------------------------------------------------------------------*/

#include <nn.h>
#include <nn/os.h>
#include <nn/Result.h>
#include <nn/hid.h>
#include <nn/uds.h>
#include "TestUDS.h"
#include "sys.h"
#include "UDS_Lib.h"

using namespace uji::sys;

namespace uji{
namespace eva{


namespace 
{
    
    const u8 COMMAND_FONT_SIZE = 10;
    const u8 INFO_FONT_SIZE = 14;
    
    TextWindow* SendWindow;
    TextWindow* RecvWindow;
    TextWindow* InfoWindow;
    
    
}

// テストプログラム

void TestUDS()
{
    
    
    NN_LOG("START\n");

    nn::Result result;
    bool isMaster;
    
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    uji::eva::UDS_Lib UDS_Lib;
    UDS_Lib.Initialize();
    
    SendWindow = new TextWindow ( 200/(COMMAND_FONT_SIZE/2), 160/COMMAND_FONT_SIZE, COMMAND_FONT_SIZE );
    RecvWindow = new TextWindow ( 200/(COMMAND_FONT_SIZE/2), 160/COMMAND_FONT_SIZE, COMMAND_FONT_SIZE );
    InfoWindow = new TextWindow ( 240/(INFO_FONT_SIZE/2), 160/INFO_FONT_SIZE, INFO_FONT_SIZE );
              
    
    SendWindow->SetTitle("Send Command");
    RecvWindow->SetTitle("Recv Command");
    InfoWindow->SetTitle("UDS Status");
    
    uji::sys::WindowManager uds_WindowManager;
    
    uds_WindowManager.CreateWindow( SendWindow, NN_GX_DISPLAY0, 0, 0 );
    uds_WindowManager.CreateWindow( RecvWindow, NN_GX_DISPLAY0, 200, 0 );
    uds_WindowManager.CreateWindow( InfoWindow, NN_GX_DISPLAY1, 0, 0 );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->Clear();
    
    uds_WindowManager.Update();
    uds_WindowManager.DrawDisplay0();
    gfx->m_DrawFramework->SwapBuffers();

    //動作モードを切り替えるために HID を使用
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->Clear();
    
    InfoWindow->Printf("MODE SELECT (A:Master  B:Client)\n");
    NN_LOG("MODE SELECT (A:Master B:Client)\n");
    
    uds_WindowManager.Update();
    uds_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    
    //UDS_Lib.SaveSequencerSSID();

    while(true)
    {
        // 入力取得
        sys::Pad().UpdatePad();
        
        //----------------------------------------------------------------------
        // ここでモードを選択する
        // A：Masterモード(ネットワークを構築する側、通常シーケンサ側)
        // B：Clientモード(ネットワークに接続する側、通常被検査物側）
        // X：SSID登録モード(Client側が接続に行くネットワークのSSIDを指定する、
        //                   通常はシーケンサ側のMACAddressの下位4バイトを使用する予定)
        //----------------------------------------------------------------------
        if( uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_A ))
        {
            isMaster = true;
            NN_LOG("-> Select: Master!\n");
            InfoWindow->Printf("-> Select: Master!\n");
            break;
        }

        if( sys::Pad().IsButtonDown( Pad::BUTTON_B ))
        {
            isMaster   = false;
            NN_LOG("-> Select: Client!\n");
            InfoWindow->Printf("-> Select: Client!\n");
            break;
        }
        if( sys::Pad().IsButtonDown( Pad::BUTTON_X ))
        {
            UDS_Lib.SaveSequencerSSID();
            
            
            gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
            gfx->m_DrawFramework->Clear();
            
            uds_WindowManager.Update();
            uds_WindowManager.DrawDisplay0();
            gfx->m_DrawFramework->SwapBuffers();
            
            gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
            gfx->m_DrawFramework->Clear();
            
            uds_WindowManager.Update();
            uds_WindowManager.DrawDisplay1();
            gfx->m_DrawFramework->SwapBuffers();
                    
        }
/*
        if(padStatus.hold & nn::hid::BUTTON_Y)
        {
            isMaster   = false;
            isAudience = true;
            NN_LOG("-> Select: Audience!\n");
            break;
        }
*/

        
    }
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->Clear();
    
    uds_WindowManager.Update();
    uds_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    
    if( isMaster )  // シーケンサ側初期処理
    {
        if( !UDS_Lib.InitUDSConnectionMaster())
        {
            NN_LOG("ConnectMaster Failure!\n");
        }
    }else           // 被検査物側初期処理
    {
        if( !UDS_Lib.InitUDSConnectionClient( nn::fnd::TimeSpan::FromSeconds(10)) ) 
        {
            return;
        }
    }
    
    //接続が完了したので送受信スレッドを立てる
    NN_LOG("Connect Finished\n");
    
    {   // MacAddressの表示
        bit8 MA[6];
        nn::uds::GetMacAddress( MA );
        NN_LOG("MacAddress = %x:%x:%x:%x:%x:%x = %s\n", MA[0], MA[1], MA[2], MA[3], MA[4], MA[5], MA );
        InfoWindow->Printf("MacAddress = %02x:%02x:%02x:%02x:%02x:%02x\n", MA[0], MA[1], MA[2], MA[3], MA[4], MA[5] );
    }
    
    size_t RecvSize = 100;
    char RecvBuffer[ RecvSize ];
    char SendBuffer[ 30 ];
    
    // タイマーで500(ms)毎に相手にデータを送信する。
    nn::os::Timer timer;
    timer.Initialize(false);
    timer.StartPeriodic( nn::fnd::TimeSpan::FromMilliSeconds(500), nn::fnd::TimeSpan::FromMilliSeconds(500) );
    int TestCount = 0;
    
    //接続状態の監視
    while(true)
    {
        uji::sys::Pad().UpdatePad();
        gfx->m_DrawFramework->Clear();
        
        if( uji::sys::Pad().IsButtonDown( Pad::BUTTON_B ))
        {
            // ネットワークを終了する
            UDS_Lib.DisconnectNetwork();
            break;
        }
        //if( uji::sys::Pad().IsButtonDown( Pad::BUTTON_A ))
        //{
        //    //UDS_Lib.SendTo();
        //    sprintf( SendBuffer, "Test%d", TestCount++ );
        //    SendWindow->Printf("%s\n", SendBuffer );
        //    UDS_Lib.SendTo( SendBuffer, sizeof( SendBuffer ));
        //}
        
        timer.Wait();
        if( UDS_Lib.GetLastSend() == UDS_Lib::SEND_SUCCESS )
        {
            sprintf( SendBuffer, "Test%d", TestCount++ );
            SendWindow->Printf("%s\n", SendBuffer );
            UDS_Lib.SendTo( SendBuffer, sizeof( SendBuffer ));
        }else if( UDS_Lib.GetLastSend() == UDS_Lib.SEND_FAILURE )
        {
            SendWindow->Printf("Failure\nRetry %s\n", SendBuffer );
            UDS_Lib.RetrySendTo( SendBuffer, sizeof( SendBuffer ));
        }else
        {
            NN_LOG(" NOW OPERATING");
        }
        
        if( UDS_Lib.Receive( RecvBuffer, RecvSize ))
        {
            RecvWindow->Printf("%s\n", RecvBuffer );
            memset( RecvBuffer, 0x00, RecvSize );
        }
        
        // Client用処理、もし切断状態になった場合自動的に再接続へ
        if( UDS_Lib.IsDisconnected() )
        {
            UDS_Lib.InitUDSConnectionClient( nn::fnd::TimeSpan::FromSeconds(10)) ;
        }
        
        uds_WindowManager.Update();
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();

        uds_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
        gfx->m_DrawFramework->Clear();

        uds_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
    }
    
    timer.Stop();
    timer.Finalize();
       
    UDS_Lib.Finalize();
    
    
    uds_WindowManager.DestroyWindow( SendWindow );
    uds_WindowManager.DestroyWindow( RecvWindow );
    uds_WindowManager.DestroyWindow( InfoWindow );
    
    SendWindow->Destroy();
    RecvWindow->Destroy();
    InfoWindow->Destroy();
    
    delete SendWindow;
    delete RecvWindow;
    delete InfoWindow;
    
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(200));
    NN_LOG("END\n");

    NN_LOG("Finalize!\n");
}

} // namespace eva
} // namespace uji
