/*--------------------------------------------------------------------------*
 Project:
 File: TestMp.cpp

       
*--------------------------------------------------------------------------*/

#include "TestMp.h"

bool uji::eva::mp::TestMpInit( uji::seq::TestResult &result )
{
    nn::Result nnResult;
    nn::mp::CTR::Config config;
    const int PARENT_DATA_SIZE = 4;
    const int CHILD_DATA_SIZE  = 4;
    
    nnResult = nn::mp::CTR::Initialize();
    if( nnResult.IsFailure())
    {
        sprintf( result.m_String, "MP Initialize Failed" );
        return result.m_Result = false; 
    }
    
    nnResult = nn::mp::CTR::SetPortConfig( 0, true, 0 );
    if( nnResult.IsFailure())
    {
        sprintf( result.m_String, "MP Set PortConfig Error" );
        result.m_Result = false;
        
        goto mp_end;
    }
    
    config.mode               = NN_MP_MODE_PARENT;
    config.ggid               = 0x00;
    config.tgid               = NN_MP_TGID_AUTO;
    config.channel            = 1;
    config.lifeTime           = NN_MP_LIFETIME_DEFAULT;
    config.beaconPeriod       = 10;
    config.maxNodes           = NN_MP_AID_MAX-1; //15
    config.parentMaxSize      = PARENT_DATA_SIZE;
    config.childMaxSize       = CHILD_DATA_SIZE;
    config.entryFlag          = 1;
    config.frequency          = 1;
    config.userGameInfoLength = NN_MP_GAMEINFO_USER_SIZE;
    config.recvmode           = NN_MP_RECVMODE_ALL;
    
    nnResult = nn::mp::CTR::Start( &config );
    if( nnResult.IsFailure())
    {
        sprintf( result.m_String, "MP Start Error" );
        result.m_Result = false;
        
        goto mp_end;
    }
    
    nnResult = nn::mp::CTR::Stop();
    if( nnResult.IsFailure())
    {
        sprintf( result.m_String, "MP Stop Error" );
        result.m_Result = false;
        
        goto mp_end;
    }
    
    result.m_Result = true;
    mp_end:
    nn::mp::CTR::Finalize();
    return result.m_Result;
}



