//-------------------------------------------------------
// TestWirelessp[eBeB
//-------------------------------------------------------

#ifndef WIRELESS_UTIL_H_INCLUDED
#define WIRELESS_UTIL_H_INCLUDED

#include <nn.h>
#include "sys.h"


// pfBOɊւxvO}
#pragma diag_suppress 1301,2530

namespace uji{
namespace eva{

//const u8 MAX_ARG_NUM = 86;
const u16 MAX_ARG_NUM = 256;

const u8  MAX_ARG_LEN = 128;    //FR12ȍ~p
const u8  NGCODE_LEN  = 2;      //FR12ȍ~p

struct CommPack  // R}h́Ai[\
{
    u16     CheckSum;
    u16     CommID;
    u8      ArgNum;
    char    Arg[ MAX_ARG_NUM ];
    
};


class CommandUtil
{
    public:
    
    enum RSCStateMent
    {
        SUCCESS   = 0x00,
        FAILURE   = 0x01,
        CHECKSUM  = 0x02,
        TIME_OUT  = 0x03,
        OPERATING = 0x04
    };
    
    enum
    {
        CONVERT_ERROR_NUM = -1
    };
    //--------------------------------------------------------------------------
    // CTR̊֐gp̗ (b)
    // 1.M
    // 2.isCorrectCheckSumŃ`FbNTmF
    // 3.AnalysisCommandŕR}hpPbgɕϊ
    // 4.R}hpPbg֐s(ʎ)
    //   ̍ہAԂlƂCreateRSCAndResponseArgStringɂ
    //   RSC2+ԂlB
    // 5.CreateResponseStringgpAԂl3.̃R}hpPbg
    //   X|X쐬B
    // 6.X|X񑗐MB
    //--------------------------------------------------------------------------
    
/*---------------------------------------------------------------------------*
  Decs  : ASCII𐔒lɕϊ܂B

  Args  : Str        ASCIĨ|C^B
          ArrayNum   ϊ镶̐B
  
  Return: ϊ̐lԂ܂B
 *---------------------------------------------------------------------------*/
    static int  ConvertNumFromString( const char *Str, const int &ArrayNum );

/*---------------------------------------------------------------------------*
  Decs  : 񂩂`FbNT𐶐܂B

  Args  : *Str      Ɏgp镶̐擪̃|C^w肵܂  B
          ArgLength gp镶񒷂w肵܂B
  
  Return: `FbNTԂ܂B
 *---------------------------------------------------------------------------*/
    static u16  CalcCheckSum( const char *Str, const int &ArgLength );

/*---------------------------------------------------------------------------*
  Decs  : R}h̃`FbNTmF܂B

  Args  : *str      mF镶(`FbNT)̐擪̃|C^w肵܂ B
          strLength mF镶̒(`FbNT)w肵܂B
  
  Return: mFʁB
 *---------------------------------------------------------------------------*/
    static bool isCorrectCheckSum( const char* str, const int &strLength );

/*---------------------------------------------------------------------------*
  Decs  : 񂪎w肵̂ǂmF܂B

  Args  : *objStr    mFΏەւ̃|C^łB
          *cntStr    mF镶łB
                     "Test"Ȃǂ̗lɒڎw肵ĂB

  Return: 
 *---------------------------------------------------------------------------*/
    static bool CompareString( const char *objStr, const char *cntStr );
    
/*---------------------------------------------------------------------------*
  Decs  : R}hR}h\̂Ɋi[܂B

  Args  : *Str   R}h̐擪̃|C^w肵܂B
  
  Return: R}h\̂Ԃ܂B
 *---------------------------------------------------------------------------*/
    static CommPack AnalysisCommand( const char* Str );

/*---------------------------------------------------------------------------*
  Decs  : R}h\̂當𐶐܂B

  Args  : commPack   Ɏgp\̂w肵܂B
  
  Return: łB
 *---------------------------------------------------------------------------*/
    static const char* ConvertStringFromCommPack( const CommPack &commPack );


/*---------------------------------------------------------------------------*
  Decs  : PC̃R}hɑ΂鉞R}h쐬܂B

  Args  : CommPack  PC瑗ĂR}hł
          *str      RSC+Ԃlw肵܂B

  Return: PCR}hɑ΂鉞R}hB
 *---------------------------------------------------------------------------*/
    static const char* CreateResponseString( const CommPack &commPack, const char* str );

/*---------------------------------------------------------------------------*
  Decs  : PC̃R}hɑ΂RSC(s)ƕԂl쐬܂B

  Args  : rsc       R}hsʂłB
          *str      ԂlƂĎw肷镶łB
                    ԂlȂ̏ꍇ͏ȗł܂B
          val       ԂlƂĎw肷鐔l(NGR[h)łB
                    l𕶎ɕϊĈɍڂ܂B
                    ԂlȂ̏ꍇ͏ȗł܂B

  Return: RSC2{Ԃl̃|C^
 *---------------------------------------------------------------------------*/
    static const char* CreateRSCAndResponseArgString( const u8 &rsc, const char* str );

    static const char* CreateRSCAndResponseArgString( const u8 &rsc )
    {
        return CreateRSCAndResponseArgString( rsc, "" );
    }
    
    static const char* CreateRSCAndResponseArgString( const u8 &rsc, const u8 val )
    {
        char str[NGCODE_LEN + 1];
        
        memset( str, 0x00, NGCODE_LEN + 1);
        sprintf( str, "%02X", val);
        return CreateRSCAndResponseArgString( rsc, str );
    }

/*---------------------------------------------------------------------------*
  Decs  : pvZs܂B

  Args  : y  y^xyw肵܂B
          x  y^xxw肵܂B
  
  Return: vZʂԂ܂B
 *---------------------------------------------------------------------------*/
    static int  CalcExponentiation( const int &y, const int &x );

/*---------------------------------------------------------------------------*
  Decs  : TimeSpanIuWFNghh::mm::ss.nn`̕Ԃ܂B

  Args  : TimeSpanIuWFNgłB
  
  Return: vZʂԂ܂B
 *---------------------------------------------------------------------------*/

    static const char* ConvertStringFromTimeSpan( const nn::fnd::TimeSpan &timeSpan );

/*---------------------------------------------------------------------------*
  Decs  : XCb`OnOff擾āAOff̏ꍇOnɂ悤Ɏwo܂B

  Args  : Ȃ
  
  Return: Ȃ
 *---------------------------------------------------------------------------*/

    static void CheckWifiMode();


    // ܂֐
    #if 0
    static const char* ReturnResultLevel( const nn::Result* result );
    static const char* ReturnResultSummary( const nn::Result* result );
    static const char* ReturnResultModule( const nn::Result* result );
    static const char* ReturnResultDesc( const nn::Result* result );
    #endif
};


class TimeCounter
{
    public:
    TimeCounter() : m_StandardTick( nn::os::Tick::GetSystemCurrent())
    {}
    
    ~TimeCounter(){}
    
    nn::fnd::TimeSpan GetTimeSpan()
    {
        return ( nn::os::Tick::GetSystemCurrent() - m_StandardTick ).ToTimeSpan();
    }
    
    void InitTime()
    {
        m_StandardTick = nn::os::Tick::GetSystemCurrent();
    }
    
    
    private:
    nn::os::Tick m_StandardTick;
};
    


//// pfBOɊւxɖ߂
//#pragma diag_default 1301,2530


} // namespace eva
} // namespace uji

#endif /* WIRELESS_UTIL_H_INCLUDED */
