#include <cstring>
#include <nn.h>
#include <nn/gx.h>
#include "../seq/TestResult.h"
#include "sys.h"
#include "TestWireless.h"
//include "TestWirelessCommand.h"
#include "CommandUtil.h"
#include "../mcu/McuInitializer.h"
#include <nn/nwm.h>

using namespace uji::sys;

namespace
{
    const u8 CHECK_SUM_LENGTH  = 4;
    const u8 COMMAND_ID_LENGTH = 4;
    const u8 ARG_NUM_LENGTH    = 2;
    const u8 DEF_COMMAND_LENGTH    = 10;
}

namespace uji{
namespace eva{


/*---------------------------------------------------------------------------*
  Decs  : ASCII𐔒lɕϊ܂B

  Args  : Str        ASCIĨ|C^B
          ArrayNum   ϊ镶̐B
  
  Return: ϊ̐lԂ܂B
 *---------------------------------------------------------------------------*/

int CommandUtil::ConvertNumFromString( const char *Str, const int &ArrayNum )
{
    u32 Num = 0;
    
    for( int i = 0; i < ArrayNum; i++ )
    {
        if( Str[i] >= '0' && Str[i] <= '9' )                        // '0'`'9'̏ꍇ
        {
            Num += (Str[i] - '0') << 4 * ( ArrayNum - ( i + 1 ));
        }
        else if( Str[i] >= 'A' && Str[i] <= 'F' )                   // 'A'`'F'̏ꍇ
        {
            Num += (Str[i] - '7') << 4 * ( ArrayNum - ( i + 1 ));   // 'A'=10Ƃׂ'7'gp
        }
        else if( Str[i] >= 'a' && Str[i] <= 'f' )                   // 'a'`'f'̏ꍇ(A`FƓlԂB)
        {
            Num += (Str[i] - 'W') << 4 * ( ArrayNum - ( i + 1 ));   // 'a'=10Ƃׂ'W'gp
        }else
        {
            return -1;                                              // ȊO̕񂪂ꍇ-1ԂB
        }
    }
    return static_cast<int>(Num);
}


/*---------------------------------------------------------------------------*
  Decs  : pvZs܂B

  Args  : y  y^xyw肵܂B
          x  y^xxw肵܂B
  
  Return: vZʂԂ܂B
 *---------------------------------------------------------------------------*/
int CommandUtil::CalcExponentiation( const int &y, const int &x )
{
    if( x <  0 ) return 0;                      // ^̉\̂ŁA-*0Ԃ
    if( x == 0 ) return 1;                      // 0̏ꍇ1ԂB
    if( y == 0 ) return 0;                      // y0̏ꍇ0Ԃ܂B
    
    int num = 1;                                // L𖞂ȂꍇɕϐvZJn
    for( int i = 1 ; i <= x ; i++ )
    {
        num *= y;                               // yx悷
    }
    return num;
}

/*---------------------------------------------------------------------------*
  Decs  : R}hR}h\̂Ɋi[܂B

  Args  : *wCom  i[R}h\̂w肵܂B
          *Str   R}h̐擪̃|C^w肵܂B
  
  Return: R}h\̂Ԃ܂B
 *---------------------------------------------------------------------------*/
CommPack CommandUtil::AnalysisCommand( const char* Str )
{
    CommPack commPack;
    commPack.CheckSum   = CommandUtil::ConvertNumFromString( &Str[0], CHECK_SUM_LENGTH ); // `FbNT
    commPack.CommID     = CommandUtil::ConvertNumFromString( &Str[ CHECK_SUM_LENGTH ], CHECK_SUM_LENGTH ); // R}hID
    commPack.ArgNum     = CommandUtil::ConvertNumFromString( &Str[ CHECK_SUM_LENGTH + COMMAND_ID_LENGTH ], ARG_NUM_LENGTH ); // 
    
    const int ZERO_CLEAR = 0;
    std::memset( commPack.Arg, ZERO_CLEAR, MAX_ARG_NUM );  // z̃NA
    
    if( commPack.ArgNum )
    {
        std::memcpy( commPack.Arg, &Str[ DEF_COMMAND_LENGTH ], commPack.ArgNum );
    }

    return commPack;
}

/*---------------------------------------------------------------------------*
  Decs  : 񂩂`FbNT𐶐܂B

  Args  : *Str   Ɏgp镶̐擪̃|C^w肵܂  B
          ArgNum gp镶񐔂w肵܂B
  
  Return: `FbNTԂ܂B
 *---------------------------------------------------------------------------*/

u16 CommandUtil::CalcCheckSum( const char *Str, const int &ArgLength )
{   
    u16 CheckSum = 0;
    
    for( int i = 0; i < ArgLength; i++ )
    {
        CheckSum += Str[i];
    }
    return CheckSum;
}

/*---------------------------------------------------------------------------*
  Decs  : R}h̃`FbNTmF܂B

  Args  : *str   mF镶(`FbNT)̐擪̃|C^w肵܂ B
          ArgNum mF镶̒(`FbNT)w肵܂B
  
  Return: mFʁB
 *---------------------------------------------------------------------------*/

bool CommandUtil::isCorrectCheckSum( const char* str, const int &strLength )
{
    int commandCheckSum = CommandUtil::ConvertNumFromString( str, 4 );
    int calcCheckSum = 0;
    
    for( int i = 4; i < strLength; i++ )
    {
        calcCheckSum += str[i];
    }
    
    if( commandCheckSum == calcCheckSum )
    {
        return true;
    }else
    {
        return false;
    }
}


/*---------------------------------------------------------------------------*
  Decs  : R}h\̂當𐶐܂B

  Args  : commPack   Ɏgp\̂w肵܂B
  
  Return: 
 *---------------------------------------------------------------------------*/

const char* CommandUtil::ConvertStringFromCommPack( const CommPack &commPack )
{
    static char ReturnStrings[ 10 + MAX_ARG_NUM ];   // Ԃlpɂ܂łc
    char CalcCheckSumStr[ 6 + commPack.ArgNum ];
    sprintf( CalcCheckSumStr, "%04X%02X%s", commPack.CommID, commPack.ArgNum, commPack.Arg );
    
    std::memset( ReturnStrings, 0x00, 10 + MAX_ARG_NUM );
    sprintf( ReturnStrings, "%04X%04X%02X%s", CalcCheckSum( CalcCheckSumStr, 6 + commPack.ArgNum ),
             commPack.CommID, commPack.ArgNum, commPack.Arg );
    
    return ReturnStrings;
}

/*---------------------------------------------------------------------------*
  Decs  : 񂪎w肵̂ǂmF܂B

  Args  : *objStr    mFΏەւ̃|C^łB
          *cntStr    mF镶łB
                     "Test"Ȃǂ̗lɒڎw肵ĂB

  Return: 
 *---------------------------------------------------------------------------*/
bool CommandUtil::CompareString( const char *objStr, const char *cntStr )
{
    //NN_LOG("obj = %s cnt = %s size = %d\n", objStr, cntStr, sizeof( cntStr ));
    if( 0 == std::memcmp( objStr, cntStr, std::strlen( cntStr )))
    {
        return true;
    }else
    {
        return false;
    }
}


/*---------------------------------------------------------------------------*
  Decs  : PC̃R}hɑ΂RSC(s)ƕԂl쐬܂B

  Args  : rsc       R}hsʂłB
          *str      ԂlƂĎw肷镶łB
                    ԂlȂ̏ꍇ͏ȗł܂B

  Return: RSC2{Ԃl̃|C^
 *---------------------------------------------------------------------------*/

const char* CommandUtil::CreateRSCAndResponseArgString( const u8 &rsc, const char* str )
{
    static char ReturnStrings[ MAX_ARG_NUM ];
    std::memset( ReturnStrings, 0x0, MAX_ARG_NUM );
    sprintf( ReturnStrings, "%02X%s", rsc, str );
    return ReturnStrings;
    
}

/*---------------------------------------------------------------------------*
  Decs  : PC̃R}hɑ΂鉞R}h쐬܂B

  Args  : CommPack  PC瑗ĂR}hł
          *str      RSC+Ԃlw肵܂B

  Return: PCR}hɑ΂鉞R}hB
 *---------------------------------------------------------------------------*/
const char* CommandUtil::CreateResponseString( const CommPack &commPack, const char* str )
{
    static char ReturnStrings[ 10 + MAX_ARG_NUM ];
    std::memset( ReturnStrings,      0x0, 10 + MAX_ARG_NUM );
    
    char CalcCheckSumString[ 6 + MAX_ARG_NUM ];
    std::memset( CalcCheckSumString, 0x0,  6 + MAX_ARG_NUM);
    
    u16 ArgNum = std::strlen( str );
    if ( ArgNum > 255 ) ArgNum = 255;
    sprintf( CalcCheckSumString, "%04X%02X%s", commPack.CommID + 0xA000, ArgNum, str );

    u16 CheckSum = CommandUtil::CalcCheckSum( CalcCheckSumString, 6 + ArgNum );
    sprintf( ReturnStrings, "%04X%s", CheckSum, CalcCheckSumString );

    return ReturnStrings;
}

const char* CommandUtil::ConvertStringFromTimeSpan( const nn::fnd::TimeSpan &timeSpan )
{
    s64 nowTime = timeSpan.GetMilliSeconds();
    int h,m,s,ms;

    h  = ( nowTime / 3600000 )%99; //ōXX܂ŕێ
    m  = ( nowTime / 60000   )%60;
    s  = ( nowTime / 1000    )%60;
    ms = ( nowTime / 10      )%99;
    
    static char Str[13];
    int Count = 0;

    Str[ Count++ ] = static_cast<char>( '0'+(h/10) );
    Str[ Count++ ] = static_cast<char>( '0'+(h%10) );
    Str[ Count++ ] = ':';
    Str[ Count++ ] = static_cast<char>( '0'+(m/10) );
    Str[ Count++ ] = static_cast<char>( '0'+(m%10) );
    Str[ Count++ ] = ':';
    Str[ Count++ ] = static_cast<char>( '0'+(s/10) );
    Str[ Count++ ] = static_cast<char>( '0'+(s%10) );
    Str[ Count++ ] = '.';
    Str[ Count++ ] = static_cast<char>( '0'+(ms/10) );
    Str[ Count++ ] = static_cast<char>( '0'+(ms%10) );
    Str[ Count++ ] = '\0';
    
    return Str;

}

void CommandUtil::CheckWifiMode()
{
    if( nn::nwm::IsWifiOn())
    {
        return;
    }
    
    uji::sys::JpegDrawer jpegDrawer;
    jpegDrawer.OpenPicture(L"rom:/jpeg/WifiButtonForCheck.jpg");
    
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    // ʍXV
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->Clear();      
    jpegDrawer.DrawPicture( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
    
    
    do{
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(200));
    }while( !nn::nwm::IsWifiOn());
}
    




//------------------------------------------------------------------------------
// ȉ܂
//------------------------------------------------------------------------------

#if 0
/*---------------------------------------------------------------------------*
  Decs  : nn::ResultResultLevel̕쐬܂B

  Args  : result    nn::ResultCX^X̃|C^w肵܂B

  Return: ResultLevelB
 *---------------------------------------------------------------------------*/

const char* CommandUtil::ReturnResultLevel( const nn::Result* result )
{
    nn::Result::Level level = result->GetLevel();
    switch( level )
    {
        case nn::Result::LEVEL_INFO      : return "LEVEL_INFO";
        case nn::Result::LEVEL_SUCCESS   : return "LEVEL_SUCCESS";
        case nn::Result::LEVEL_FATAL     : return "LEVEL_FATAL";
        case nn::Result::LEVEL_RESET     : return "LEVEL_RESET";
        case nn::Result::LEVEL_REINIT    : return "LEVEL_REINIT";
        case nn::Result::LEVEL_USAGE     : return "LEVEL_USAGE";
        case nn::Result::LEVEL_PERMANENT : return "LEVEL_PERMANENT";
        case nn::Result::LEVEL_TEMPORARY : return "LEVEL_TEMPORARY";
        case nn::Result::LEVEL_STATUS    : return "LEVEL_STATUS";
        default                          : return "NO_DEFINE";
    }
}

/*---------------------------------------------------------------------------*
  Decs  : nn::ResultResultSummary̕쐬܂B

  Args  : result    nn::ResultCX^X̃|C^w肵܂B

  Return: ResultSummaryB
 *---------------------------------------------------------------------------*/

const char* CommandUtil::ReturnResultSummary( const nn::Result* result )
{
    nn::Result::Summary summary = result->GetSummary();
    switch ( summary )
    {
        case nn::Result::SUMMARY_SUCCESS          : return "SUMMARY_SUCCESS";
        case nn::Result::SUMMARY_NOTHING_HAPPENED : return "SUMMARY_NOTHING_HAPPENED";
        case nn::Result::SUMMARY_WOULD_BLOCK      : return "SUMMARY_WOULD_BLOCK";
        case nn::Result::SUMMARY_OUT_OF_RESOURCE  : return "SUMMARY_OUT_OF_RESOURCE";
        case nn::Result::SUMMARY_NOT_FOUND        : return "SUMMARY_NOT_FOUND";
        case nn::Result::SUMMARY_INVALID_STATE    : return "SUMMARY_INVALID_STATE";
        case nn::Result::SUMMARY_NOT_SUPPORTED    : return "SUMMARY_NOT_SUPPORTED";
        case nn::Result::SUMMARY_INVALID_ARGUMENT : return "SUMMARY_INVALID_ARGUMENT";
        case nn::Result::SUMMARY_WRONG_ARGUMENT   : return "SUMMARY_WRONG_ARGUMENT";
        case nn::Result::SUMMARY_CANCELLED        : return "SUMMARY_CANCELLED";
        case nn::Result::SUMMARY_STATUS_CHANGED   : return "SUMMARY_STATUS_CHANGED";
        case nn::Result::SUMMARY_INTERNAL         : return "SUMMARY_INTERNAL";
        default                                   : return "NO_DEFINE";
    }
}


/*---------------------------------------------------------------------------*
  Decs  : nn::ResultResultModule̕쐬܂B

  Args  : result    nn::ResultCX^X̃|C^w肵܂B

  Return: ResultModuleB
 *---------------------------------------------------------------------------*/
const char* CommandUtil::ReturnResultModule( const nn::Result* result )
{
    nn::Result::Module module = result->GetModule();
    switch ( module )
    {
        case nn::Result::MODULE_COMMON           : return "MODULE_COMMON";
        case nn::Result::MODULE_NN_KERNEL        : return "MODULE_NN_KERNEL";
        case nn::Result::MODULE_NN_UTIL          : return "MODULE_NN_UTIL";
        case nn::Result::MODULE_NN_FILE_SERVER   : return "MODULE_NN_FILE_SERVER";
        case nn::Result::MODULE_NN_LOADER_SERVER : return "MODULE_NN_LOADER_SERVER";
        case nn::Result::MODULE_NN_TCB           : return "MODULE_NN_TCB";
        case nn::Result::MODULE_NN_OS            : return "MODULE_NN_OS";
        case nn::Result::MODULE_NN_DBG           : return "MODULE_NN_DBG";
        case nn::Result::MODULE_NN_DMNT          : return "MODULE_NN_DMNT";
        case nn::Result::MODULE_NN_PDN           : return "MODULE_NN_PDN";
        case nn::Result::MODULE_NN_GX            : return "MODULE_NN_GX";
        case nn::Result::MODULE_NN_I2C           : return "MODULE_NN_I2C";
        case nn::Result::MODULE_NN_GPIO          : return "MODULE_NN_GPIO";
        case nn::Result::MODULE_NN_DD            : return "MODULE_NN_DD";
        case nn::Result::MODULE_NN_CODEC         : return "MODULE_NN_CODEC";
        case nn::Result::MODULE_NN_SPI           : return "MODULE_NN_SPI";
        case nn::Result::MODULE_NN_PXI           : return "MODULE_NN_PXI";
        case nn::Result::MODULE_NN_FS            : return "MODULE_NN_FS";
        case nn::Result::MODULE_NN_DI            : return "MODULE_NN_DI";
        case nn::Result::MODULE_NN_HID           : return "MODULE_NN_HID";
        case nn::Result::MODULE_NN_CAMERA        : return "MODULE_NN_CAMERA";
        case nn::Result::MODULE_NN_PI            : return "MODULE_NN_PI";
        case nn::Result::MODULE_NN_PM            : return "MODULE_NN_PM";
        case nn::Result::MODULE_NN_PMLOW         : return "MODULE_NN_PMLOW";
        case nn::Result::MODULE_NN_FSI           : return "MODULE_NN_FSI";
        case nn::Result::MODULE_NN_SRV           : return "MODULE_NN_SRV";
//        case nn::Result::MODULE_NN_WCM           : return "MODULE_NN_WCM";
        case nn::Result::MODULE_NN_NWM           : return "MODULE_NN_NWM";
        case nn::Result::MODULE_NN_SOCKET        : return "MODULE_NN_SOCKET";
        case nn::Result::MODULE_NN_LDR           : return "MODULE_NN_LDR";
        case nn::Result::MODULE_NN_ACC           : return "MODULE_NN_ACC";
        case nn::Result::MODULE_NN_ROMFS         : return "MODULE_NN_ROMFS";
        case nn::Result::MODULE_NN_AM            : return "MODULE_NN_AM";
        case nn::Result::MODULE_NN_HIO           : return "MODULE_NN_HIO";
        case nn::Result::MODULE_NN_UPDATER       : return "MODULE_NN_UPDATER";
        case nn::Result::MODULE_NN_MIC           : return "MODULE_NN_MIC";
        case nn::Result::MODULE_NN_FND           : return "MODULE_NN_FND";
//        case nn::Result::MODULE_NN_MPWM          : return "MODULE_NN_MPWM";
        case nn::Result::MODULE_NN_MPWL          : return "MODULE_NN_MPWL";
        case nn::Result::MODULE_NN_AC            : return "MODULE_NN_AC";
        case nn::Result::MODULE_NN_HTTP          : return "MODULE_NN_HTTP";
        case nn::Result::MODULE_NN_DSP           : return "MODULE_NN_DSP";
        case nn::Result::MODULE_NN_SND           : return "MODULE_NN_SND";
        case nn::Result::MODULE_NN_DLP           : return "MODULE_NN_DLP";
        case nn::Result::MODULE_NN_HIOLOW        : return "MODULE_NN_HIOLOW";
        case nn::Result::MODULE_NN_CSND          : return "MODULE_NN_CSND";
        case nn::Result::MODULE_NN_SSL           : return "MODULE_NN_SSL";
        case nn::Result::MODULE_NN_AMLOW         : return "MODULE_NN_AMLOW";
//        case nn::Result::MODULE_NN_JUGEM         : return "MODULE_NN_JUGEM";
        case nn::Result::MODULE_NN_FRIENDS       : return "MODULE_NN_FRIENDS";
        case nn::Result::MODULE_NN_RDT           : return "MODULE_NN_RDT";
        case nn::Result::MODULE_NN_APPLET        : return "MODULE_NN_APPLET";
        default                                  : return "NO_DEFINE";
    }
}


/*---------------------------------------------------------------------------*
  Decs  : nn::ResultResultModule̕쐬܂B

  Args  : result    nn::ResultCX^X̃|C^w肵܂B

  Return: ResultModuleB
 *---------------------------------------------------------------------------*/
const char* CommandUtil::ReturnResultDesc( const nn::Result* result )
{
    int desc = result->GetDescription();
    switch ( desc )
    {
        case nn::Result::DESCRIPTION_INVALID_SELECTION          : return "DESCRIPTION_INVALID_SELECTION";
        case nn::Result::DESCRIPTION_TOO_LARGE                  : return "DESCRIPTION_TOO_LARGE";
        case nn::Result::DESCRIPTION_NOT_AUTHORIZED             : return "DESCRIPTION_NOT_AUTHORIZED";
        case nn::Result::DESCRIPTION_ALREADY_DONE               : return "DESCRIPTION_ALREADY_DONE";
        case nn::Result::DESCRIPTION_INVALID_SIZE               : return "DESCRIPTION_INVALID_SIZE";
        case nn::Result::DESCRIPTION_INVALID_ENUM_VALUE         : return "DESCRIPTION_INVALID_ENUM_VALUE";
        case nn::Result::DESCRIPTION_INVALID_COMBINATION        : return "DESCRIPTION_INVALID_COMBINATION";
        case nn::Result::DESCRIPTION_NO_DATA                    : return "DESCRIPTION_NO_DATA";
        case nn::Result::DESCRIPTION_BUSY                       : return "DESCRIPTION_BUSY";
        case nn::Result::DESCRIPTION_MISALIGNED_ADDRESS         : return "DESCRIPTION_MISALIGNED_ADDRESS";
        case nn::Result::DESCRIPTION_MISALIGNED_SIZE            : return "DESCRIPTION_MISALIGNED_SIZE";
        case nn::Result::DESCRIPTION_OUT_OF_MEMORY              : return "DESCRIPTION_OUT_OF_MEMORY";
        case nn::Result::DESCRIPTION_NOT_IMPLEMENTED            : return "DESCRIPTION_NOT_IMPLEMENTED";
        case nn::Result::DESCRIPTION_INVALID_ADDRESS            : return "DESCRIPTION_INVALID_ADDRESS";
        case nn::Result::DESCRIPTION_INVALID_POINTER            : return "DESCRIPTION_INVALID_POINTER";
        case nn::Result::DESCRIPTION_INVALID_HANDLE             : return "DESCRIPTION_INVALID_HANDLE";
        case nn::Result::DESCRIPTION_NOT_INITIALIZED            : return "DESCRIPTION_NOT_INITIALIZED";
        case nn::Result::DESCRIPTION_ALREADY_INITIALIZED        : return "DESCRIPTION_ALREADY_INITIALIZED";
        case nn::Result::DESCRIPTION_NOT_FOUND                  : return "DESCRIPTION_NOT_FOUND";
        case nn::Result::DESCRIPTION_CANCEL_REQUESTED           : return "DESCRIPTION_CANCEL_REQUESTED";
        case nn::Result::DESCRIPTION_ALREADY_EXISTS             : return "DESCRIPTION_ALREADY_EXISTS";
        case nn::Result::DESCRIPTION_OUT_OF_RANGE               : return "DESCRIPTION_OUT_OF_RANGE";
        case nn::Result::DESCRIPTION_TIMEOUT                    : return "DESCRIPTION_TIMEOUT";
        case nn::Result::DESCRIPTION_INVALID_RESULT_VALUE       : return "DESCRIPTION_INVALID_RESULT_VALUE";

        default                                                 : return "NO_DEFINE";
    }
}
#endif

} // namespace eva
} // namespace uji

