#include "CommandTestTool.h"

using namespace uji::sys;

namespace uji{
namespace eva{

//------------------------------------------------------------------------------
// j[
//------------------------------------------------------------------------------
void CommandTestTool::TestSPIPort()
{
    ClassMenu *m = new ClassMenu( "SendCommandForSPI Test" );
    m->Add( " ATH_Init  "           , CommandTestTool::Send_ATH_Init );
    m->Add( " ATH_SetSSID  "        , CommandTestTool::Send_ATH_SetSSID );
    m->Add( " ATH_SetIPAddress  "   , CommandTestTool::Send_ATH_SetIPAddress );
    m->Add( " Alphabet  "           , CommandTestTool::Send_Alphabet );
    m->Add( " Receive Mode "        , CommandTestTool::ReceiveModeTest );
    m->Open();
    delete m;
    
}

void CommandTestTool::ReceiveModeTest()
{
    const u8  FONT_SIZE   = 14;
    const u16 BUFFER_HEIGHT = ( 240/FONT_SIZE ) * 5;
    GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    uji::sys::MessageLogWindow  LowerWindow( 310/( FONT_SIZE/2 ), 220/FONT_SIZE, BUFFER_HEIGHT, FONT_SIZE );
    uji::sys::TextWindow        UpperWindow( 310/( FONT_SIZE/2 ), 220/FONT_SIZE, FONT_SIZE );
    
    uji::sys::WindowManager     windowManager;
    
    windowManager.CreateWindow( &LowerWindow, NN_GX_DISPLAY1, 0, 0 );
    windowManager.CreateWindow( &UpperWindow, NN_GX_DISPLAY0, 0, 0 );
    
    
    UpperWindow.Printf(" Press A To Read\n");
    UpperWindow.Printf(" Press B To Return\n");
    UpperWindow.Printf(" Press X To Auto Read\n");
    {   // `
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        windowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
    }
    
    nn::fs::FileStream in;
    s32 readByte;
    
    in.Initialize( L"cardspi:/1MHz_1xIO.bin", NULL);
    u8   Count_R_Buf[3];
    char RecvCommandBuffer[96] = "";
    
    bool isAutoMode = false;
    
    while( true )
    {
        do{
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(20));
            sys::Pad().UpdatePad();
            windowManager.Update();
            windowManager.UpdatePad( sys::Pad() );
            
            if( uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_B ))
            {
                goto End;
            }
            if( uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_X ))
            {
                isAutoMode = !isAutoMode;
            }
            
            if( isAutoMode )
            {
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds( 100 ));
                break;
            }
            
        }while( !uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_A ));
        
        sys::Pad().UpdatePad();
        
        in.SetPosition( 0x0004 );
        readByte = in.Read( Count_R_Buf, 3 );
        
        
        u32 wCount = ( Count_R_Buf[0] + Count_R_Buf[1]*0x100 + Count_R_Buf[2] * 0x10000 );
        
        NN_LOG("Count = %d\n", wCount );
        
        if( wCount )
        {
            NN_LOG("readByte : %d\n", readByte );
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMicroSeconds(1000));
            in.SetPosition( 0x1000 );
            //NN_LOG("Line = %d\n", __LINE__);
            readByte = in.Read( RecvCommandBuffer, wCount );
            NN_LOG("Command = %s\n", RecvCommandBuffer );
            LowerWindow.Printf("Command = %s\n", RecvCommandBuffer );
            std::memset( RecvCommandBuffer, 0x00, 96 );
                
            {   // `
                gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
                gfx->m_DrawFramework->Clear();
                windowManager.DrawDisplay1();
                gfx->m_DrawFramework->SwapBuffers();
            }
        }
        
    }
    
    End:
    in.Finalize();
    
}
void CommandTestTool::SendExecute( const char str[], int size )
{
    nn::fs::FileStream out;
    nn::fs::FileStream in;
    
    s32 readByte;
    s32 writtenByte;
    
    u8  wCountBuf[3];
    
    in.Initialize( L"cardspi:/1MHz_1xIO.bin", NULL );
    in.SetPosition( 0x0008 );
    readByte = in.Read( wCountBuf, 3 );
    NN_LOG("readByte : %d\n", readByte );
    
    u32 wCount = ( wCountBuf[0] + wCountBuf[1]*0x10 + wCountBuf[2]*0x100 );
    if( wCount > 0x0F38 )
    {
        NN_LOG(" COUNT_W is Full!\n");
        return;
    }
    
    
    out.Initialize( L"cardspi:/1MHz_1xIO.bin", NULL );
    out.SetPosition( 0x2000 );
    
    // f[^̍쐬
    //memset(gBuffer, 0x5A, BUF_SIZE);
    
    writtenByte = out.Write( str, size );
    NN_LOG("writtenByte : %d\n", writtenByte );
}

//------------------------------------------------------------------------------
// ȉAMR}h
//------------------------------------------------------------------------------
void CommandTestTool::Send_ATH_Init()
{
    const char SendComm[] = "0122010100";
    SendExecute( SendComm, sizeof( SendComm ) - 1 );
}

void CommandTestTool::Send_ATH_SetSSID()
{
    const char SendComm[] = "03D5010609PE-WLTEST";
    SendExecute( SendComm, sizeof( SendComm ) - 1 );
}


void CommandTestTool::Send_ATH_SetIPAddress()
{
    const char SendComm[] = "038C01100B192.168.11.1";
    SendExecute( SendComm, sizeof( SendComm ) - 1 );
}

void CommandTestTool::Send_Alphabet()
{
    const char SendComm[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    SendExecute( SendComm, sizeof( SendComm ) - 1 );
}



}
}
