/********************************************************************
WIFI
********************************************************************/

#include "TestWifi.h"

#include <nn/gx/CTR/gx_LcdPowerManager.h>


namespace uji{
namespace eva{
    
using namespace uji::sys;
using namespace uji::seq;


namespace
{
bool s_txThreadFlag;
bool s_rxThreadFlag;


struct IEEE_802_3_LLC_SNAP
{
	u8 Destination[6];
	u8 Source[6];
	u16 Length;
	u8 Dsap;
	u8 Ssap;
	u8 Control;
	u8 Pid[3];
	u16 Type;
	u8 Payload[1];
};

class Ieee802_3_Llc_Snap
{
private:
	u8 m_Destination[6]; // 802.3 Destination
	u8 m_Source[6];      // 802.3 Source
	u16 m_Length;        // 802.3 Length (LLC + SNAP + Payload̒)
	u8 m_Dsap;           // LLC DSAP
	u8 m_Ssap;           // LLC SSAP
	u8 m_Control;        // LLC Control
	u8 m_Pid[3];         // SNAP Protocol ID
	u16 m_Type;          // SNAP Protocol Type
	u8 m_Payload[1506];  // Payload (1506 : CTR̍őyC[h)
public:
	Ieee802_3_Llc_Snap()
	{
		std::memset(m_Destination, 0, 3);
		std::memset(m_Source, 0, 3);
		m_Length = 0;
		m_Dsap = 0xAA;    // SNAP
		m_Ssap = 0xAA;    // SNAP
		m_Control = 0x03; // RlNVXAMIvVȂ
		std::memset(m_Pid, 0, 3);
		m_Type = 0;
		std::memset(m_Payload, 0, 1506);
	};

	u8* GetDestinationP()
	{
		return m_Destination;
	};

	nn::nwm::Mac GetDestination()
	{
		return nn::nwm::Mac(m_Destination);
	}

	void SetDestination(nn::nwm::Mac address)
	{
		std::memcpy(m_Destination, address.Get(), nn::nwm::Mac::MAC_SIZE);
	};

	nn::nwm::Mac GetSource()
	{
		return nn::nwm::Mac(m_Source);
	};

	u8* GetSourceP()
	{
		return m_Source;
	};

	void SetSource(nn::nwm::Mac address)
	{
		std::memcpy(m_Source, address.Get(), nn::nwm::Mac::MAC_SIZE);
	};

	u16 GetLength()
	{
		return (m_Length << 8 | m_Length >> 8);
	};

	void SetLength(u16 l)
	{
		m_Length = (l << 8 | l >> 8);
	}

	u16 GetType()
	{
		return (m_Type << 8 | m_Type >> 8);
	};

	void SetType(u16 type)
	{
		m_Type = (type << 8 | type >> 8); // GfBAϊĂ
	};

	u8* GetPayload()
	{
		return (u8*)m_Payload;
	};

	void SetPayload(u8* p, size_t size)
	{
        nn::nstd::MemCpy(m_Payload, p, size);
	}

	u32 GetHeaderSize(){ return 22; };
};
}

/*******************************************************************************/
nn::Result TestWifiSendOpen( void )
{
    nn::nwm::MasterParam param;
    nn::nwm::SapTxQueueParam txQueueParam[2];
	u16 ctw;

    {
		param.numOfClients = 15;					//!> ڑ Client łB1-15̒lłB
		param.channel = 1;							//!> gp`lłB1-14̒lłB
		param.hiddenSsid = false;					//!> XeXSSIDݒtOłB false:any true:hidden
		param.defaultAuthorize = true;				//!> Master Jn Client ڑۂ Authorize Ԃɂ܂Bfalse:Unauthorize true:Authorize
		param.inactivePeriod = 600;					//!> ʐMȂClientؒf܂ł̎[sec]łB
		param.supportedRates = nn::nwm::RATE_SET_6_0M;		//!> IEEE802.11 Supported Rates łB
		param.basicRates = nn::nwm::RATE_SET_6_0M;			//!> IEEE802.11 Supported Rates  Basic Rates ܂B
		param.security = nn::nwm::Security();				//!> ڑ̃ZLeBvt@C
		param.ssid = nn::nwm::Ssid("sap_master");			//!> gp SSID łB
		param.beaconIntervalTu = 100;				//!> gp Beacon Interval[TU] łB
		ctw = 10;
        
        nn::nwm::SapTxQueueParam stqparam;
		stqparam.eCWmin = 4;
		stqparam.eCWmax = 10;
		stqparam.aifsn = 2;
		txQueueParam[0] = stqparam;
		txQueueParam[1] = stqparam;
	    txQueueParam[0].queueType = nn::nwm::TX_QUEUE_1;
	    txQueueParam[1].queueType = nn::nwm::TX_QUEUE_2;
    }

    nn::Result result;
    {
        result = nn::MakePermanentResult(nn::Result::SUMMARY_NOTHING_HAPPENED,
                                         nn::Result::MODULE_COMMON,
                                         nn::Result::DESCRIPTION_NOT_IMPLEMENTED);
        
        u16 state;
        result = nn::nwm::Sap::GetState(&state);
        NN_LOG("GetState %d\n", result.IsSuccess());

        if(!result.IsSuccess())
        {
            NN_LOG("state is invalid\n");
            return result;
        }

        if(state >= nn::nwm::STATE_SLEEP && state <= nn::nwm::STATE_READY)
        {
            nn::nwm::Sap::OpenMode();
        }
    }


    {
        u8 oui[3] = {0x00, 0x1f, 0x32};
        result = nn::nwm::Sap::SetResponseParam(true, oui);
        if( result.IsFailure() )
        {
            NN_LOG("SetResponseParam failed\n");
            return result;
        }
    }

    // ʏL[̃ANZXp[^ݒ
    result = nn::nwm::Sap::SetTxQueue(txQueueParam[0]);
    if (result.IsFailure())
    {
        NN_LOG("SetTxQueue(NORMAL) failed\n");
        return result;
    }

    // CABL[̃ANZXp[^ݒ
    result = nn::nwm::Sap::SetTxQueue(txQueueParam[1]);
    if (result.IsFailure())
    {
        NN_LOG("SetTxQueue(CAB) failed\n");
        return result;
    }

    NN_LOG("Sap::SetSapPowerSave()\n");
    nn::nwm::SapPsParam psParam;
    psParam.psMode = nn::nwm::SAP_PS_MASTER;
    psParam.psEnable = false;
    psParam.ctWin = ctw;
    result = nn::nwm::Sap::SetSapPowerSave(psParam, false);
    if (result.IsFailure())
    {
        NN_LOG(" - failed : SetSapPowerSave\n");
        return result;
    }
        
    NN_LOG("Sap::BeginMaster()\n");
    result = nn::nwm::Sap::BeginMaster(param);

    if (result.IsFailure())
    {
        NN_LOG(" - failed : BeginMaster\n");
        return result;
    }
    NN_LOG(" - success : BeginMaster\n");
    return result;
}

nn::Result TestWifiSend(u8 data[], size_t size)
{
    nn::Result result;

    nn::nwm::Mac mac;
    result = nn::nwm::CTR::GetMacAddress(mac);
    if (result.IsFailure())
    {
        NN_LOG("GetMacAddress failed\n");
        return result;
    }

    std::memcpy(((IEEE_802_3_LLC_SNAP*)data)->Source, mac.Get(), nn::nwm::Mac::MAC_SIZE);

    result = nn::nwm::Sap::PutFrameRaw(data, size);
    
    if (result.IsFailure())
    {
        //NN_LOG("PutFrameRaw failed\n");
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1));	// ؒf̘AMs邽߁AX[v
    }
    else
    {
        //NN_LOG("PutFrameRaw success\n");
    }

    return result;
}

nn::Result TestWifiReceiveOpen( void )
{
    {
        //ModeChanger::ToSapMode();
        nn::Result result = nn::MakePermanentResult(nn::Result::SUMMARY_NOTHING_HAPPENED,
                                                    nn::Result::MODULE_COMMON,
                                                    nn::Result::DESCRIPTION_NOT_IMPLEMENTED);

        u16 state;
        result = nn::nwm::Sap::GetState(&state);
        NN_LOG("GetState %d\n", result.IsSuccess());

        if(!result.IsSuccess())
        {
            NN_LOG("state is invalid\n");
            return result;
        }

        if(state >= nn::nwm::STATE_SLEEP && state <= nn::nwm::STATE_READY)
        {
            nn::nwm::Sap::OpenMode();
        }
    }

    nn::Result result;
	nn::nwm::SapTxQueueParam txQueueParam[2];

    nn::nwm::SapTxQueueParam param;
    param.eCWmin = 4;
    param.eCWmax = 10;
    param.aifsn = 2;
    txQueueParam[0] = param;
    txQueueParam[1] = param;
    txQueueParam[0].queueType = nn::nwm::TX_QUEUE_1;
    txQueueParam[1].queueType = nn::nwm::TX_QUEUE_2;

    // ʏL[̃ANZXp[^ݒ
    result = nn::nwm::Sap::SetTxQueue(txQueueParam[0]);
    if (result.IsFailure())
    {
        NN_LOG("SetTxQueue(NORMAL) failed\n");
        //return result;
    }

    // CABL[̃ANZXp[^ݒ
    result = nn::nwm::Sap::SetTxQueue(txQueueParam[1]);
    if (result.IsFailure())
    {
        NN_LOG("SetTxQueue(CAB) failed\n");
        //return result;
    }

    // Directu[hLXgݒ
    result = nn::nwm::Sap::EnableClientBroadcast(false);
    if(result.IsFailure())
    {
        NN_LOG("EnableClientBroadcast failed\n");
        //return result;
    }

    // `lI
    u8   channel = 1;

    NN_LOG("Sap::SetSapPowerSave()\n");
    nn::nwm::SapPsParam psParam;
    psParam.psMode = nn::nwm::SAP_PS_CLIENT;
    psParam.psEnable = false;
    psParam.clr = false;
    psParam.txWait = 5;
    result = nn::nwm::Sap::SetSapPowerSave(psParam, false);
    if (result.IsFailure())
    {
        NN_LOG(" - failed : SetSapPowerSave\n");
        return result;
    }

    NN_LOG("Sap::Connect()\n");
    result = nn::nwm::Sap::Connect(nn::nwm::Ssid("sap_master"),
                                   nn::nwm::ZeroMac(),
                                   channel,
                                   nn::nwm::Security(),
                                   105,
                                   nn::nwm::CURR_BSS_IND);
    if (result.IsFailure())
    {
			NN_LOG(" - failed : Connect\n");

	        return result;
    }
    NN_LOG(" - success : Connect\n");
		
    return result;
}

/*******************************************************************************/
namespace wifi
{
nn::os::Thread s_sendThread;
nn::os::Thread s_recvThread;

void __tstSendThread(uptr param);
void __tstRecvThread(uptr param);

/*------------------------------------------------------------------------------
  Desc  : Wifi𑗐MԂɂ
          
  Code  : none
  Return: result
------------------------------------------------------------------------------*/
bool TestWifiSendStart(TestResult &result)
{
    int i;
    bool ret = false;
    
    nn::gx::CTR::LcdPowerManager::TurnOffAll();
    
    //MXbh𗧂āAMJn
    s_sendThread.StartUsingAutoStack ( __tstSendThread, NULL, 4096 );
    
    for(i=0; i<20; i++)                 // ڑ2b܂ő҂
    {
        if(s_txThreadFlag)
        {
            ret = true;
            break;                      // ڑ甲
        }
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
    }
    
    // MJnłĂȂ΃XbhIĂ
    if(ret == false)
    {
        s_txThreadFlag = false;         // MXbh~
        
        s_sendThread.Join();
        s_sendThread.Finalize();
    }
    
    result.m_Result = ret;
    return result.m_Result;
}

/*------------------------------------------------------------------------------
  Desc  : WifȋM~
          
  Code  : none
  Return: result
------------------------------------------------------------------------------*/
bool TestWifiSendStop(TestResult &result)
{
    bool ret = true;
    nn::Result nn_Result;
    
    if(s_txThreadFlag)
    {
        s_txThreadFlag = false;         // MXbh~
        
        s_sendThread.Join();
        s_sendThread.Finalize();
    }
    
    result.m_Result = ret;
    return result.m_Result;
}

/*------------------------------------------------------------------------------
  Desc  : WifiMԂɂ
          
  Code  : none
  Return: result
------------------------------------------------------------------------------*/
bool TestWifiReceiveStart(TestResult &result)
{
    int i;
    bool ret = false;
    
    //MXbh𗧂āAMJn
    s_recvThread.StartUsingAutoStack ( __tstRecvThread, NULL, 4096 );
    
    for(i=0; i<20; i++)                 // ڑ2b܂ő҂
    {
        if(s_rxThreadFlag)
        {
            ret = true;
            break;                      // ڑ甲
        }
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
    }
    
    result.m_Result = ret;
    return result.m_Result;
}

/*------------------------------------------------------------------------------
  Desc  : Wifi̎M~
          
  Code  : none
  Return: result
------------------------------------------------------------------------------*/
bool TestWifiReceiveStop(TestResult &result)
{
    bool ret = true;
    nn::Result nn_Result;
    
    if(s_rxThreadFlag)
    {
        s_rxThreadFlag = false;         // MXbh~
        
        s_recvThread.Join();
        s_recvThread.Finalize();
    }
    
    nn::gx::CTR::LcdPowerManager::TurnOnAll();
    
    result.m_Result = ret;
    return result.m_Result;
}

/*******************************************************************************/
//MXbh
void __tstSendThread(uptr param)
{
    NN_UNUSED_VAR( param );

	nn::Result result;
	
	// gpCȕ
	nn::ndm::Initialize();
	result = nn::nwm::InitializeSapControl();
	if(result.IsFailure())
    {
        nn::ndm::Finalize();
        
        NN_LOG("Fail to InitializeSapControl\n");
        return;
    }
	
	// obNOEhʐM~
    nn::ndm::SuspendScheduler();
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(50));
    
    // M
    result = TestWifiSendOpen();
    if(result.IsFailure())
    {
        nn::ndm::ResumeScheduler();
        nn::nwm::FinalizeSapControl();
	    nn::ndm::Finalize();
	    
	    NN_LOG("Fail to TestWifiSendOpen\n");
        return;
    }

    Ieee802_3_Llc_Snap frame;
    u64 count = 0;
    u16 size = 1506;
    
    s_txThreadFlag = true;
    while( s_txThreadFlag )
    {
        frame.SetDestination( nn::nwm::Mac(0xFF,0xFF,0xFF,0xFF,0xFF,0xFF) );
        frame.SetLength( size + frame.GetHeaderSize() - 4 );
        frame.SetPayload((u8*)&count, sizeof(u64));
        
        TestWifiSend((u8*)&frame, size + frame.GetHeaderSize());
        
        count++;
    }
    
	nn::nwm::Sap::EndMaster();
    
	// obNOEhʐMĊJ
	nn::ndm::ResumeScheduler();
	
	// gpCu̖
	nn::nwm::FinalizeSapControl();
	nn::ndm::Finalize();
}

//MXbh
void __tstRecvThread(uptr param)
{
    NN_UNUSED_VAR( param );
	
	nn::Result result;
	
	// gpCȕ
	nn::ndm::Initialize();
	result = nn::nwm::InitializeSapControl();
	if(result.IsFailure())
    {
        nn::ndm::Finalize();
        
        NN_LOG("Fail to InitializeSapControl\n");
        return;
    }
		
	// obNOEhʐM~
    nn::ndm::SuspendScheduler();

    // M
    s_rxThreadFlag = true;
    while( s_rxThreadFlag )
    {
        TestWifiReceiveOpen();
    }
    
    nn::nwm::Sap::CloseMode();

	// obNOEhʐMĊJ
	nn::ndm::ResumeScheduler();
	
	// gpCu̖
	nn::nwm::FinalizeSapControl();
	nn::ndm::Finalize();

}

} // namespace wifi

} // namespace eva
} // namespace uji
