/********************************************************************
~c~[hWIFI
********************************************************************/

#include <nn.h>
#include <nn/mp.h>
#include <nn/gx/CTR/gx_LcdPowerManager.h>

#include "TestMitsumiWifi.h"


namespace uji{
namespace eva{
    
using namespace uji::sys;
using namespace uji::seq;


namespace 
{
    const int GL_MEMORY_SIZE = 0x800000;

    enum COMMAND_TYPE
    {
        CONNECT_AS_MP_PARENT,
        CONNECT_AS_MP_CHILD,
        COMMAND_MAX
    };

    const char* COMMAND_NAME[COMMAND_MAX] =
    {
        "< CONNECT AS MP_PARENT >",
        "< CONNECT AS MP_CHILD >"
    };

    demo::RenderSystemDrawing s_RenderSystem;

    nn::fnd::ExpHeap s_AppHeap;
    uptr s_HeapForGx;

    nn::os::StackBuffer<4096> s_StackBuffer;
    nn::os::Thread s_Thread;

    bool s_IsCommunicate        = false;     // ʐMtO

    static nn::mp::CTR::BssDesc s_BssDesc[NN_MP_SCAN_BSS_MAX]; // XLobt@

    u32  s_RecvNo[NN_MP_AID_MAX];            // 擾f[^
    bit8 s_MacAddress[NN_MP_AID_MAX][6];     // MAC AhX
    u32  s_SendNo;                           // Mf[^
    nn::os::LightEvent s_AwakeEvent;         // NpCxg
    nn::os::LightEvent s_SleepEvent;         // X[vpCxg
    
}

namespace MitsumiWifi
{
void __tstChildReceiveThread(uptr param);

/*------------------------------------------------------------------------------
  Desc  : WifiMԂɂ
          
  Code  : none
  Return: result
------------------------------------------------------------------------------*/
bool TestMitsumiWifiReceiveStart(TestResult &result)
{
    int i;
    bool ret = false;
    
    nn::gx::CTR::LcdPowerManager::TurnOffAll();
    
    // MXbhグ
    s_IsCommunicate = false;
    s_Thread.Start( __tstChildReceiveThread, NULL, s_StackBuffer );
    
    for(i=0; i<20; i++)                 // ڑ2b܂ő҂
    {
        if(s_IsCommunicate)
        {
            ret = true;
            break;                      // ڑ甲
        }
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
    }
    
    result.m_Result = ret;
    return result.m_Result;
}

/*------------------------------------------------------------------------------
  Desc  : Wifi̎MԂ~
          
  Code  : none
  Return: result
------------------------------------------------------------------------------*/
bool TestMitsumiWifiReceiveStop(TestResult &result)
{
    int i;
    bool ret = true;
    nn::Result nn_Result;
    
    // MXbh~
    s_IsCommunicate = false;
    
    NN_LOG("STOP\n");
    nn_Result = nn::mp::CTR::Stop();
    if (nn_Result != nn::mp::CTR::ResultWirelessOff())
    {
        NN_ASSERT_RESULT(nn_Result);
    }

    // d|̎M𒆎~
    // ReceiveAll() LZ
    nn_Result = nn::mp::CTR::AbortReceive( 0 );
    if (nn_Result != nn::mp::CTR::ResultWirelessOff())
    {
//      NN_ASSERT_RESULT(result);
    }    
    
    std::memset( s_RecvNo, 0, sizeof(s_RecvNo) );
    std::memset( s_MacAddress, 0, sizeof(s_MacAddress));
    
    s_Thread.Join();
    s_Thread.Finalize();
    
    // MPhCoI
    nn_Result = nn::mp::CTR::Finalize();
    if (nn_Result.IsFailure())
    {
        ret = false;
    }
    NN_ASSERT_RESULT(nn_Result);
    
    nn::gx::CTR::LcdPowerManager::TurnOnAll();
    
    result.m_Result = ret;
    return result.m_Result;
}

// q@MXbh
void __tstChildReceiveThread(uptr )
{
    nn::Result result;
    static nn::mp::CTR::Config s_Config; //TCYrIɑ傫̂ŃX^bNmۂȂ

    
    // MPhCo
    result = nn::mp::CTR::Initialize();
    
    // OFFɂ鎸s̏ꍇAIB
    if (result == nn::mp::CTR::ResultWirelessOff())
    {
        NN_DBG_PRINT_RESULT(result);
        return;
    }
    NN_ASSERT_RESULT(result);
    
    // |[gMݒ
    result = nn::mp::CTR::SetPortConfig(COMM_DATA_PORT, true, 0);

    // OFFɂ鎸s̏ꍇAIB
    if (result == nn::mp::CTR::ResultWirelessOff())
    {
        NN_DBG_PRINT_RESULT(result);
        nn::mp::CTR::Finalize();
        return;
    }
    NN_ASSERT_RESULT(result);
    
    std::memset(&s_Config, 0, sizeof(nn::mp::CTR::Config));
    s_Config.mode = NN_MP_MODE_CHILD;
    s_Config.recvmode = NN_MP_RECVMODE_PORT;

    // q@[hJnA̎_ł͒ʐM͂Ȃ
    result = nn::mp::CTR::Start(&s_Config);

    // OFFɂ鎸s̏ꍇAĂѓ͑҂ցB
    if (result == nn::mp::CTR::ResultWirelessOff())
    {
        NN_DBG_PRINT_RESULT(result);
        nn::mp::CTR::Finalize();
        return;
    }
    NN_ASSERT_RESULT(result);
    
    s_IsCommunicate = true;

    // M~v܂ŃXLJԂ
    while(s_IsCommunicate)
    {
        //XL
        nn::mp::CTR::ScanParam param;
        
        std::memset(&param, 0, sizeof(nn::mp::CTR::ScanParam));
        param.channelBits = 0x0001<< (CHANNEL-1) ;  //1chŒ
        param.maxChannelTime = 1000;		// XLԁi1bj
        param.descNum = NN_MP_SCAN_BSS_MAX;	// őXL
        std::memset(param.bssid, 0xff, 6);	// SMACAhXΏ
        
        result = nn::mp::CTR::Scan(s_BssDesc, &param);
        
        // OFFɂ鎸s̏ꍇAĂѓ͑҂ցB
        if (result == nn::mp::CTR::ResultWirelessOff())
        {
            NN_DBG_PRINT_RESULT(result);
            s_IsCommunicate = false;
            break;
        }
        NN_ASSERT_RESULT(result);
        
    }
}

} // namespace MitsumiWifi

} // namespace eva
} // namespace uji
