/************************************************************************

 WifivO
 
 *************************************************************************/
 
#ifndef TEST_EEPROM_H_INCLUDED
#define TEST_EEPROM_H_INCLUDED

#include <nn.h>
#include <nn/nwm.h>
//#include <nn/nwm/CTR/nwm_ExtMpAPI.h>
#include <nn/nwm/CTR/nwm_ExtAPI.h>
#include <nn/cfg/CTR/cfg_ApiNor.h>
#include <nn/ndm.h>

#include "sys.h"
#include "../seq/TestResult.h"


// AvP[VƎ OutOfMemory G[̍쐬
NN_DEFINE_RESULT_CONST( \
    ResultAppOutOfMemory, \
    nn::Result::LEVEL_PERMANENT, nn::Result::SUMMARY_OUT_OF_RESOURCE, nn::Result::MODULE_APPLICATION, nn::Result::DESCRIPTION_OUT_OF_MEMORY);
NN_DEFINE_RESULT_CONST( \
    ResultAppUnexpectedResult, \
    nn::Result::LEVEL_PERMANENT, nn::Result::SUMMARY_INTERNAL, nn::Result::MODULE_APPLICATION, nn::Result::DESCRIPTION_INVALID_RESULT_VALUE);

#define NOR_TEST_PAGE_BEGIN 0
#define NOR_TEST_PAGE_END   15

#define NOR_PAGE_SIZE				256
#define NOR_PROTECT_PAGE_NUM		3
#define NOR_PROTECT_PAGES_SIZE		(NOR_PAGE_SIZE*NOR_PROTECT_PAGE_NUM)
#define NOR_UNPROTECT_PAGE_NUM		13
#define NOR_UNPROTECT_PAGES_SIZE	(NOR_PAGE_SIZE*NOR_UNPROTECT_PAGE_NUM)
#define NOR_ALL_PAGE_NUM			(NOR_PROTECT_PAGE_NUM+NOR_UNPROTECT_PAGE_NUM)
#define NOR_BUFFER_SIZE				(NOR_PAGE_SIZE*NOR_ALL_PAGE_NUM)
#define NOR_ADDR_TOP				0x00000
#define NOR_ADDR_BOTTOM				0x20000

/* nor̃f[^ */
#define WLNOR_PARAMETER_ADDR			0x0028
#define WLNOR_PARAMETER_SIZE			0x01D8
#define WLNOR_PARAMETER_MAC_OFFSET		0x000E
#define WLNOR_PARAMETER_CHECKSUM_OFFSET	0x0002

namespace uji{
namespace eva{

namespace eeprom
{
    extern bool TestWifi32kEepromWrite( uji::seq::TestResult &result );
}

class TestWifi
{
    public:
        TestWifi()
        {
            norCommonDataBuf = NULL;
            norCommonDataBufForVerify = NULL;
        }
        void init(void);
        nn::Result GetModuleMacAddress(void);
        nn::Result readCommonData(void);
        void OverwriteMacAddress(void);
        nn::Result WriteNorCommonData(void);
        nn::Result verifyNorData(void);
        nn::Result WriteCheckSum(void);
        void FreeBuf(void);
        
    private:
        u16 calc_NextCRC( u8 data, u16 total);
        u16 wlVerifyCheckSum(u8 *wparam);
        void dump(void* buf, int num);
        
    private:
        u8 norData[WLNOR_PARAMETER_SIZE];
        void*     norCommonDataBuf;
        void*     norCommonDataBufForVerify;

        nn::nwm::Mac myMac;
};

} // namespace eva
} // namespace uji
#endif
