/********************************************************************
WIFI
********************************************************************/

#include "TestEepRom.h"


namespace uji{
namespace eva{
    
using namespace uji::sys;
using namespace uji::seq;


namespace 
{
    typedef	struct
    {
    	u16		checkSum;			// 00
    	u16		tableSize;			// 02

    	u8		vendorID;			// 04
    	u8		moduleID;			// 05
    	u8		serialNum[5];		// 06
    	u8		rsv;				// 0B

    	u16		macAdrs[3];			// 0C
    	u16		enableChannel;		// 12

    	u16		wlOperation;		// 14

    	u8		rfDeviceId;			// 16
    	u8		rfBitWidth;			// 17
    	u8		rfInitRegNum;		// 18
    	u8		rfDepChRegNum;		// 19

    	u16		macTxRxRegs[16];	// 1A
    	u8		bbpInitRegs[105];	// 3A
    	u8		pad;				// A3
        // private data follows
    } FLASH_TABLE, *LPFLASH_TABLE;

    /**********************************************************************
     * CRC-ANSI( CRC-16)
     **********************************************************************/
    static const u16 crc16_table[16] = {
        0x0000, 0xCC01, 0xD801, 0x1400,
        0xF001, 0x3C00, 0x2800, 0xE401,
        0xA001, 0x6C00, 0x7800, 0xB401,
        0x5000, 0x9C01, 0x8801, 0x4400
    };
    
    /**********************************************************************
     * 
     **********************************************************************/
    const u8 SUB_ID = 0x01;                // AvŒʐM (ΐ/Ȃ) ؂蕪ۂɎgp ID
    const u8 MAX_ENTRY = 5;                // őڑ
    const char PASSPHRASE[] = "CTR_SDK_SAMPLE";     // pXt[YB̕gĒʐMoHp̈Í𐶐܂B
    const int PACKET_SIZE = nn::uds::UDS_PACKET_PAYLOAD_MAX_SIZE;  //̃főMf[^̃TCY
    
    bit8 s_UdsReceiveBuffer[4096*20] NN_ATTRIBUTE_ALIGN(4096);  //VXepMobt@łB4096 oCgꂽobt@ 4096 ̔{łKv܂B
    u32 s_SendBuffer[ PACKET_SIZE / sizeof(u32) ];
    u32 s_ReceiveBuffer[ PACKET_SIZE / sizeof(u32) ];
    
    nn::os::Event s_txStatusUpdateEvent;
    nn::os::Event s_rxStatusUpdateEvent;
    
    nn::os::Thread s_sendThread;
    nn::os::Thread s_recvThread;
    bool s_txThreadFlag = false;
    bool s_rxThreadFlag = false;
}

/*******************************************************************************/

u16 TestWifi::calc_NextCRC( u8 data, u16 total){
    u16 r1;

    /*4bit*/
    r1 = crc16_table[ total & 0xf];
    total = static_cast<u16>((total >> 4) & 0x0FFF);
	total = static_cast<u16>(total ^ r1 ^ crc16_table[ data & 0xf]);

	/*4bit*/
	r1 = crc16_table[ total & 0xf];
	total = static_cast<u16>((total >> 4) & 0x0fff);
	total = static_cast<u16>(total ^ r1 ^ crc16_table[ (data >> 4) & 0xf]);

	return total;
}

u16 TestWifi::wlVerifyCheckSum(u8 *wparam)
{
	u8* p;
	u16	crc,tbsize,c;

	crc = (reinterpret_cast<FLASH_TABLE*>(wparam))->checkSum;
	tbsize = (reinterpret_cast<FLASH_TABLE*>(wparam))->tableSize;

	p    = reinterpret_cast<u8*>(( reinterpret_cast<u32>(wparam)) + 2 );
	crc  = 0;
	c    = 0;
	for( ; tbsize > 0 ; tbsize-- )
	{
		c   = *p++;
		crc = calc_NextCRC( c, crc );
	}

	return crc;
}

void TestWifi::dump(void* buf, int num)
{
    u8 *pbuf = static_cast<u8*>(buf);
    for(int i=0; i<num; i++)
    {
        NN_LOG("%02X ", pbuf[i]);
        if((i+1)%16==0)
            NN_LOG("\n");
    }
}

void TestWifi::init(void)
{
    // Disable Network daemon manager
    NN_UTIL_PANIC_IF_FAILED(nn::ndm::Initialize());
    NN_UTIL_PANIC_IF_FAILED(nn::ndm::SuspendScheduler());

    std::memset(norData, 0x00, WLNOR_PARAMETER_SIZE);

    NN_LOG("init done\n");
}


nn::Result TestWifi::GetModuleMacAddress(void)
{
    nn::Result result;

    result = nn::nwm::CTR::GetMacAddress(myMac);
    if (result.IsFailure())
    {
        NN_LOG("%s failed\n", __FUNCTION__);
        return result;
    }

    char macbuf[nn::nwm::Mac::MAC_STRING_SIZE];
    myMac.GetString(macbuf);
    NN_LOG("%s\n", macbuf);

    return result;
}

nn::Result TestWifi::readCommonData(void)
{
    nn::Result result;
    s64 size;

    // ʃf[^ǂݍ
    // mount rom
    s32 workingMemorySize = nn::fs::GetRomRequiredMemorySize(1, 1, true);

    // [LO̊m
    void* workingMemory = uji::sys::AllocDeviceMemory(workingMemorySize, 32);
    if(!workingMemory)
    {
        NN_LOG("Cannot allocate memory : size=%d\n", workingMemorySize);
        return ResultAppOutOfMemory();
    }

    nn::fs::FileReader norDataReader(L"rom:/32kEEPROM.bin");
    result = norDataReader.TryGetSize(&size);                                   // MountRomȂȂ̂ŁAresultɌʂ邽߂ɕύX

    norCommonDataBuf = uji::sys::AllocDeviceMemory(size, 32);
    if(!norCommonDataBuf)
    {
        NN_LOG("Cannot allocate memory : size=%d\n", size);
        return ResultAppOutOfMemory();
    }
    norDataReader.Read(norCommonDataBuf, size);

    //verifypɓTCỸobt@쐬
    norCommonDataBufForVerify = uji::sys::AllocDeviceMemory(size, 32);
    if(!norCommonDataBufForVerify)
    {
        NN_LOG("Cannot allocate memory : size=%d\n", size);
        return ResultAppOutOfMemory();
    }

    norDataReader.Finalize();
    NN_LOG("Get common nor data from Romfs\n");

    uji::sys::Free(workingMemory);

    return result;
}

void TestWifi::FreeBuf(void)
{
    if(norCommonDataBuf != NULL)
    {
        uji::sys::Free(norCommonDataBuf);
        norCommonDataBuf = NULL;
    }
    if(norCommonDataBufForVerify != NULL)
    {
        uji::sys::Free(norCommonDataBufForVerify);
        norCommonDataBufForVerify = NULL;
    }
}

void TestWifi::OverwriteMacAddress(void)
{
    std::memcpy((static_cast<u8*>(norCommonDataBuf)+WLNOR_PARAMETER_ADDR+WLNOR_PARAMETER_MAC_OFFSET),
            myMac.Get(), nn::nwm::Mac::MAC_SIZE);
}

nn::Result TestWifi::WriteNorCommonData(void)
{
	nn::Result result;

    // NOR֋ʃf[^
    {
        nn::cfg::nor::CTR::Initialize();

        // protected area
        result = nn::cfg::nor::CTR::Write( NOR_ADDR_TOP, static_cast<u8*>(norCommonDataBuf), NOR_PROTECT_PAGES_SIZE );
        if (result.IsFailure())
        {
            NN_LOG("%s failed @%d\n", __FUNCTION__, __LINE__);
            NN_DBG_PRINT_RESULT(result);
            return result;
        }

        // not protected area
        result = nn::cfg::nor::CTR::Write( NOR_ADDR_BOTTOM - NOR_UNPROTECT_PAGES_SIZE,
                static_cast<u8*>(norCommonDataBuf) + NOR_PROTECT_PAGES_SIZE, NOR_UNPROTECT_PAGES_SIZE );
        if (result.IsFailure())
        {
            NN_LOG("%s failed @%d\n", __FUNCTION__, __LINE__);
            NN_DBG_PRINT_RESULT(result);
            return result;
        }

        nn::cfg::nor::CTR::Finalize();
        NN_LOG("Writing Common Data Done!\n");
    }
	return result;
}

/*
 * NORɂ̓CgveNg{Ă̈悪邽߁AȂ̗͂̈Ƀf[^͏߂Ȃ
 * ̂߁Aʏł͂Verify͎s
 */
nn::Result TestWifi::verifyNorData(void)
{
    nn::Result result;

    nn::cfg::nor::CTR::Initialize();
    result = nn::cfg::nor::CTR::Read( NOR_ADDR_TOP, static_cast<u8*>(norCommonDataBufForVerify), NOR_PROTECT_PAGES_SIZE );
    if (result.IsFailure())
    {
        NN_LOG("%s failed @%d\n", __FUNCTION__, __LINE__);
        NN_DBG_PRINT_RESULT(result);
        return result;
    }
    result = nn::cfg::nor::CTR::Read( NOR_ADDR_BOTTOM - NOR_UNPROTECT_PAGES_SIZE,
            static_cast<u8*>(norCommonDataBufForVerify) + NOR_PROTECT_PAGES_SIZE, NOR_UNPROTECT_PAGES_SIZE );
    if (result.IsFailure())
    {
        NN_LOG("%s failed @%d\n", __FUNCTION__, __LINE__);
        NN_DBG_PRINT_RESULT(result);
        return result;
    }
    nn::cfg::nor::CTR::Finalize();

    // verify
    if (std::memcmp(norCommonDataBuf, norCommonDataBufForVerify, NOR_PROTECT_PAGES_SIZE+NOR_UNPROTECT_PAGES_SIZE) != 0)
    {
        NN_LOG("%s failed @%d\n", __FUNCTION__, __LINE__);
        return ResultAppUnexpectedResult();
    }
#if 0
    //dump
    NN_LOG("\n");
    NN_LOG("raw data\n");
    dump(norCommonDataBuf, NOR_PROTECT_PAGES_SIZE+NOR_UNPROTECT_PAGES_SIZE);
    NN_LOG("\n");
    NN_LOG("new data\n");
    dump(norCommonDataBufForVerify, NOR_PROTECT_PAGES_SIZE+NOR_UNPROTECT_PAGES_SIZE);
    NN_LOG("\n");
#endif
    NN_LOG("verifying nor data success\n");

    return result;
}

nn::Result TestWifi::WriteCheckSum(void)
{
	nn::Result result;
    // NORf[^ǂݍ
    nn::cfg::nor::CTR::Initialize();
    result = nn::cfg::nor::CTR::Read( WLNOR_PARAMETER_ADDR, norData, WLNOR_PARAMETER_SIZE );
    if (result.IsFailure())
    {
        NN_LOG("%s failed\n", __FUNCTION__);
        NN_DBG_PRINT_RESULT(result);
        return result;
    }

    u16 crc = wlVerifyCheckSum(reinterpret_cast<u8*>(norData + WLNOR_PARAMETER_CHECKSUM_OFFSET));
    NN_LOG("New CRC : %04X\n", crc);

    result = nn::cfg::nor::CTR::Write( WLNOR_PARAMETER_ADDR + WLNOR_PARAMETER_CHECKSUM_OFFSET,
    		reinterpret_cast<u8*>(&crc), 2);
    if (result.IsFailure())
    {
        NN_LOG("%s failed\n", __FUNCTION__);
        NN_DBG_PRINT_RESULT(result);
        return result;
    }
    nn::cfg::nor::CTR::Finalize();

    return result;
}

namespace eeprom
{

/*------------------------------------------------------------------------------
  Desc  : WIFI 32k EEPROMMACAhX
          
  Code  : none
  Return: result
------------------------------------------------------------------------------*/
bool TestWifi32kEepromWrite(TestResult &result)
{
    nn::Result nnResult;
    
    TestWifi wifiControl;
    
    /*  */
    wifiControl.init();
    
    /* {̂MACAhX擾 */
    nnResult = wifiControl.GetModuleMacAddress();
    if(nnResult.IsFailure())
    {
        std::sprintf(result.m_String, "Fail to get ModuleMacAddress");
        result.m_Result = false;
        
        wifiControl.FreeBuf();
        return result.m_Result;
    }
    
    nnResult = wifiControl.readCommonData();
    if(nnResult.IsFailure())
    {
        std::sprintf(result.m_String, "Fail to read CommonData");
        result.m_Result = false;
        
        wifiControl.FreeBuf();
        return result.m_Result;
    }
    
    wifiControl.OverwriteMacAddress();
    
    nnResult = wifiControl.WriteNorCommonData();
    if(nnResult.IsFailure())
    {
        std::sprintf(result.m_String, "Fail to write NorCommonData");
        result.m_Result = false;
        
        wifiControl.FreeBuf();
        return result.m_Result;
    }
    
    nnResult = wifiControl.verifyNorData();
    if(nnResult.IsFailure())
    {
        std::sprintf(result.m_String, "Fail to verify NorData");
        result.m_Result = false;
        
        wifiControl.FreeBuf();
        return result.m_Result;
    }
    
    nnResult = wifiControl.WriteCheckSum();
    if(nnResult.IsFailure())
    {
        std::sprintf(result.m_String, "Fail to CheckSum");
        result.m_Result = false;
        
        wifiControl.FreeBuf();
        return result.m_Result;
    }
    
    // I
    wifiControl.FreeBuf();
    
    result.m_Result = true;
    return result.m_Result;
}

} // namespace wifi

} // namespace eva
} // namespace uji
