/********************************************************************
{[ERc{[
********************************************************************/

#include <stdlib.h>
#include <nn.h>
#include <nn/gx.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include "sys.h"
#include "../seq/Config.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../mcu/McuInitializer.h"
#include "EvaVolume.h"
using namespace uji;
using namespace uji::sys;
using namespace uji::eva;

static const u8 MCU_THREE_D_VOLUME_ADDRESS = 0x08;
static const u8 MCU_SOUND_VOLUME_ADDRESS   = 0x27;

class Panel : public JpegDrawer
{
public:
    Panel(){}
    virtual ~Panel(){}

    void Open(wchar_t *file)
    {
        uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        gfx->m_DrawFramework->Clear();
        OpenPicture( file );
        DrawPicture( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->SwapBuffers();

    }

    void Close(void)
    {
        ClosePicture();
    }
};

//G[}CNl\
enum{
    MICRO_PASS=0,
    MICRO_3D_VOLUME_NO_SENSE_ERROR,
    MICRO_3D_VOLUME_RANGE_ERROR,
    MICRO_SOUND_VOLUME_NO_SENSE_ERROR,
    MICRO_SOUND_VOLUME_RANGE_ERROR
};



//TuEChE
const int FONT_SIZE = 14;
const int SUB_WINDOW_SIZE_X = 40;
const int SUB_WINDOW_SIZE_Y = 10;
static uji::sys::TextWindow *s_InfoWindow;

// 3D{[臒l
const int SPR_ThreeDVolume_Min = 30;
const int SPR_ThreeDVolume_Max = 216;

/************************************************************************
fBXvCP̃Abvf[g
  ************************************************************************/
static void UpdateDisplay1(void)
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    Menu::m_WindowManager.Update();
    Menu::m_WindowManager.UpdatePad(pad);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    Menu::m_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/************************************************************************
݂̃{[\
************************************************************************/
static void ShowCurrentVolume( uji::sys::TextWindow *win )
{
    u8 threeDVolume;
    u8 soundVolume;

    nn::mcu::CTR::HwCheck mcu( mcu::McuInitializer().GetHSession() );
    mcu.ReadByReceive( MCU_THREE_D_VOLUME_ADDRESS, &threeDVolume,  sizeof(threeDVolume) );
    mcu.ReadByReceive( MCU_SOUND_VOLUME_ADDRESS, &soundVolume, sizeof(soundVolume) );

    win->Printf("\f[VOLUME]\n" );
    win->Printf("3D VOLUME(0x08)    = %d\n", threeDVolume );
    win->Printf("SOUND VOLUME(0x27) = %d\n", soundVolume );

}

/************************************************************************
{[ERc{[]
  ************************************************************************/
void uji::eva::EvaluateVolume(void)
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();



    // MCU֘A
    mcu::McuInitializer().HwCheckInit();

    do
    {
        ShowCurrentVolume(Menu::m_SubWindow);
        UpdateDisplay1();

        pad.UpdatePad();
    }
    while( !pad.IsButtonDown(Pad::BUTTON_B) );


    pad.ClearTriggerFlag();
}

/************************************************************************
{[ŏlT
false : ͈͊O
true  : o
  ************************************************************************/
static bool DetectMinVolume( u8 &volumeMin, u8 mcuAddress, u8 threshold )
{
    uji::seq::Config config;

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    nn::mcu::CTR::HwCheck mcu( mcu::McuInitializer().GetHSession() );
    u8 volume;

    mcu.ReadByReceive( mcuAddress, &volumeMin,  sizeof(u8) );
    if( volumeMin >= threshold ) return false;                  //臒lOȂ̂łe`krdŕԂ

    for( int i=1 ; i<config.Get().VolumeSampling ; i++ )        //K萔TvĂlhmԂ
    {
        mcu.ReadByReceive( mcuAddress, &volume,  sizeof(u8) );

        if( volumeMin>volume ) volumeMin = volume;
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }

    return true;
}

/************************************************************************
Lu[Vl̕ۑ

************************************************************************/
static void StoreCal( u8 threeDVolumeMin, u8 threeDVolumeMax, u8 soundVolumeMin, u8 soundVolumeMax )
{
    using namespace nn::drivers::cal::CTR;

    uji::seq::Config config;
    Calibration cal;
    McuCalDataCore mcuCalData;
    nn::fs::FileOutputStream ofile;
    nn::Result nnResult;

    cal.Initialize();

    //̃Lf[^ǂݏo
    if( !cal.Get(&mcuCalData, CAL_DATA_MCU) )           SYS_PANIC( "CAL FAIL" );

    //߂lݒ
    if( uji::sys::PLATFORM_FTR != uji::sys::GetPlatformType()) // FTRł͓ǂ񂾒l̂܂܏߂
    {
        mcuCalData.svr2.min  = threeDVolumeMin;
        mcuCalData.svr2.max  = threeDVolumeMax;
    }
    mcuCalData.sound.min = soundVolumeMin;
    mcuCalData.sound.max = soundVolumeMax;


    // lۑ
    if( !cal.Set(&mcuCalData, CAL_DATA_MCU) )           SYS_PANIC( "CAL FAIL" );
    if( !cal.Flush() )                                  SYS_PANIC( "CAL FAIL" );

    //fobOo
    if( config.Get().EnableDebugOut )
    {
        if( nn::fs::MountSdmc().IsFailure() ) SYS_PANIC( "FAIL TO MOUNT SDMC" );

        //l`bAhX擾
        bit8 mac[6];
        uji::sys::GetMacAddress( mac );

        //t@CI[v
        nn::fs::TryCreateDirectory(L"sdmc:/uji" );
        nn::fs::TryCreateDirectory(L"sdmc:/uji/slidevolume" );
        nnResult = ofile.TryInitialize( L"sdmc:/uji/slidevolume/cal.csv", true );
        if( nnResult.IsFailure() )                      SYS_PANIC( "SD CARD FAIL" );
        ofile.SetPosition( ofile.GetSize() );

        //t@CɃZ[u
        char str[100];
        sprintf( str, "%02X-%02X-%02X-%02X-%02X-%02X,%d,%d,%d,%d\n",
                mac[0],mac[1],mac[2],mac[3],mac[4],mac[5],
                mcuCalData.svr2.min, mcuCalData.svr2.max, mcuCalData.sound.min, mcuCalData.sound.max );
        ofile.Write( str, strlen(str) );
        ofile.Finalize();
        nn::fs::Unmount("sdmc:");
    }
}


/************************************************************************
{[őlT
false : ͈͊O
true  : o

************************************************************************/
static bool DetectMaxVolume( u8 &volumeMax, u8 mcuAddress, u8 threshold )
{
    uji::seq::Config config;

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    nn::mcu::CTR::HwCheck mcu( mcu::McuInitializer().GetHSession() );
    u8 volume;

    mcu.ReadByReceive( mcuAddress, &volumeMax,  sizeof(u8) );
    if( volumeMax <= threshold ) return false;                  //臒lOȂ̂łe`krdŕԂ

    for( int i=1 ; i<config.Get().VolumeSampling ; i++ )        //K萔TvĂl`wԂ
    {
        mcu.ReadByReceive( mcuAddress, &volume,  sizeof(u8) );

        if( volumeMax<volume ) volumeMax = volume;
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    }

    return true;
}


/************************************************************************
{[ERc{[
  ************************************************************************/
bool uji::eva::TestClampVolume(uji::seq::TestResult &result)
{
    uji::seq::Config config;
    Panel panel;

    int timer;
    u8 threeDVolumeMin=0;
    u8 threeDVolumeMax=0;
    u8 soundVolumeMin =0;
    u8 soundVolumeMax =0;
    u8 initialVolume;
    u8 volume;

    //EChE\
    s_InfoWindow = new TextWindow( SUB_WINDOW_SIZE_X, SUB_WINDOW_SIZE_Y, FONT_SIZE );
    s_InfoWindow->SetTitle( "INFORMATION" );
    Menu::m_WindowManager.CreateWindow( s_InfoWindow, NN_GX_DISPLAY1, 0, 0 );

    // MCU֘A
    mcu::McuInitializer().HwCheckInit();
    nn::mcu::CTR::HwCheck mcu( mcu::McuInitializer().GetHSession() );
    // FTR̍ۂ͌̂sȂ
    if( uji::sys::PLATFORM_FTR != uji::sys::GetPlatformType())
    {
        //Rc{[
        panel.Open( L"rom:/jpeg/3DVolumeDown.jpg" );
        mcu.ReadByReceive( MCU_THREE_D_VOLUME_ADDRESS, &initialVolume,  sizeof(u8) );
        timer=0;
        // SPFLCTR臒lς@ConfigDefine.h̒lꍇ킯ł΂őΉ
        if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
        {
            do
            {
                if( timer++> config.Get().VolumeAdjustTimeOut ){
                    mcu.ReadByReceive( MCU_THREE_D_VOLUME_ADDRESS, &volume,  sizeof(u8) );
                    if( abs( (int)volume-(int)initialVolume ) <= config.Get().VolumeNoSense )
                    {
                        result.m_Micro = MICRO_3D_VOLUME_NO_SENSE_ERROR;
                    }else{
                        result.m_Micro = MICRO_3D_VOLUME_RANGE_ERROR;
                    }
                    goto TIMEOUT;
                }

                ShowCurrentVolume(s_InfoWindow);
                UpdateDisplay1();
            }
            while( !DetectMinVolume( threeDVolumeMin, MCU_THREE_D_VOLUME_ADDRESS, SPR_ThreeDVolume_Min ) );
        }
        else
        {
            do
            {
                if( timer++> config.Get().VolumeAdjustTimeOut ){
                    mcu.ReadByReceive( MCU_THREE_D_VOLUME_ADDRESS, &volume,  sizeof(u8) );
                    if( abs( (int)volume-(int)initialVolume ) <= config.Get().VolumeNoSense )
                    {
                        result.m_Micro = MICRO_3D_VOLUME_NO_SENSE_ERROR;
                    }else{
                        result.m_Micro = MICRO_3D_VOLUME_RANGE_ERROR;
                    }
                    goto TIMEOUT;
                }

                ShowCurrentVolume(s_InfoWindow);
                UpdateDisplay1();
            }
            while( !DetectMinVolume( threeDVolumeMin, MCU_THREE_D_VOLUME_ADDRESS, config.Get().ThreeDVolume_Min ) );
        }
        panel.Close();


        //Rc{[
        panel.Open( L"rom:/jpeg/3DVolumeUp.jpg" );
        timer=0;
        // SPFLCTR臒lς
        if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
        {
            do
            {
                if( timer++> config.Get().VolumeAdjustTimeOut )
                {
                    mcu.ReadByReceive( MCU_THREE_D_VOLUME_ADDRESS, &volume,  sizeof(u8) );
                    if( abs( (int)volume-(int)initialVolume ) <= config.Get().VolumeNoSense )
                    {
                        result.m_Micro = MICRO_3D_VOLUME_NO_SENSE_ERROR;
                    }else{
                        result.m_Micro = MICRO_3D_VOLUME_RANGE_ERROR;
                    }
                    goto TIMEOUT;
                }

                ShowCurrentVolume(s_InfoWindow);
                UpdateDisplay1();
            }
            while( !DetectMaxVolume( threeDVolumeMax, MCU_THREE_D_VOLUME_ADDRESS, SPR_ThreeDVolume_Max ) );
        }
        else
        {
            do
            {
                if( timer++> config.Get().VolumeAdjustTimeOut )
                {
                    mcu.ReadByReceive( MCU_THREE_D_VOLUME_ADDRESS, &volume,  sizeof(u8) );
                    if( abs( (int)volume-(int)initialVolume ) <= config.Get().VolumeNoSense )
                    {
                        result.m_Micro = MICRO_3D_VOLUME_NO_SENSE_ERROR;
                    }else{
                        result.m_Micro = MICRO_3D_VOLUME_RANGE_ERROR;
                    }
                    goto TIMEOUT;
                }

                ShowCurrentVolume(s_InfoWindow);
                UpdateDisplay1();
            }
            while( !DetectMaxVolume( threeDVolumeMax, MCU_THREE_D_VOLUME_ADDRESS, config.Get().ThreeDVolume_Max ) );
        }
        panel.Close();
    }


    //{[
    panel.Open( L"rom:/jpeg/SoundVolumeDown.jpg" );
    mcu.ReadByReceive( MCU_SOUND_VOLUME_ADDRESS, &initialVolume,  sizeof(u8) );
    timer=0;
    do
    {
        if( timer++> config.Get().VolumeAdjustTimeOut )
        {
            mcu.ReadByReceive( MCU_SOUND_VOLUME_ADDRESS, &volume,  sizeof(u8) );
            if( abs( (int)volume-(int)initialVolume ) <= config.Get().VolumeNoSense )
            {
                result.m_Micro = MICRO_SOUND_VOLUME_NO_SENSE_ERROR;
            }else{
                result.m_Micro = MICRO_SOUND_VOLUME_RANGE_ERROR;
            }
            goto TIMEOUT;
        }

        ShowCurrentVolume(s_InfoWindow);
        UpdateDisplay1();
    }
    while( !DetectMinVolume( soundVolumeMin, MCU_SOUND_VOLUME_ADDRESS, config.Get().SoundVolume_Min ) );
    panel.Close();


    //{[
    panel.Open( L"rom:/jpeg/SoundVolumeUp.jpg" );
    timer=0;
    do
    {
        if( timer++> config.Get().VolumeAdjustTimeOut )
        {
            mcu.ReadByReceive( MCU_SOUND_VOLUME_ADDRESS, &volume,  sizeof(u8) );
            if( abs( (int)volume-(int)initialVolume ) <= config.Get().VolumeNoSense )
            {
                result.m_Micro = MICRO_SOUND_VOLUME_NO_SENSE_ERROR;
            }else{
                result.m_Micro = MICRO_SOUND_VOLUME_RANGE_ERROR;
            }
            goto TIMEOUT;
        }

        ShowCurrentVolume(s_InfoWindow);
        UpdateDisplay1();
    }
    while( !DetectMaxVolume( soundVolumeMax, MCU_SOUND_VOLUME_ADDRESS, config.Get().SoundVolume_Max ) );
    panel.Close();

    //C[hݒ莞݂̂b`klۑ
    if( config.Get().TestMode == uji::seq::pl::LINE )
    {
        // SPFL̂Ƃ͍ŏlɂ𗚂i+15j
        if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
        {
            StoreCal( threeDVolumeMin + 15, threeDVolumeMax, soundVolumeMin, soundVolumeMax );
        }
        else if( uji::sys::PLATFORM_KTR == uji::sys::GetPlatformType())
        {
            StoreCal( threeDVolumeMin +  9, threeDVolumeMax, soundVolumeMin + 44, soundVolumeMax );
        }
        else
        {
            StoreCal( threeDVolumeMin, threeDVolumeMax, soundVolumeMin, soundVolumeMax );
        }
    }
    //EChȄI
    Menu::m_WindowManager.DestroyWindow( s_InfoWindow );
    delete s_InfoWindow;

    sprintf( result.m_String, "3D VOLUME MIN=%d MAX=%d\nSOUND VOLUME MIN=%d MAX=%d\n",
                    threeDVolumeMin, threeDVolumeMax, soundVolumeMin, soundVolumeMax );
    result.m_Result = true;
    return result.m_Result;

TIMEOUT:
    //EChȄI
    Menu::m_WindowManager.DestroyWindow( s_InfoWindow );
    delete s_InfoWindow;

    sprintf( result.m_String, "3D VOLUME MIN=%d MAX=%d\nSOUND VOLUME MIN=%d MAX=%d\n",
                    threeDVolumeMin, threeDVolumeMax, soundVolumeMin, soundVolumeMax );
    result.m_Result = false;
    return result.m_Result;

}

/************************************************************************
Rc{[ (ProcessCheckp)
  ************************************************************************/
static const int margin_3dvolume_procchk = 5;
bool uji::eva::Test3DVolumeForProcessCheck(uji::seq::TestResult &result)
{
    uji::seq::Config config;
    Panel panel;

    int timer;
    u8 threeDVolumeMin=0;
    u8 threeDVolumeMax=0;
    u8 initialVolume;
    u8 volume;


    //EChE\
    s_InfoWindow = new TextWindow( SUB_WINDOW_SIZE_X, SUB_WINDOW_SIZE_Y, FONT_SIZE );
    s_InfoWindow->SetTitle( "INFORMATION" );
    Menu::m_WindowManager.CreateWindow( s_InfoWindow, NN_GX_DISPLAY1, 0, 0 );

    // MCU֘A
    mcu::McuInitializer().HwCheckInit();
    nn::mcu::CTR::HwCheck mcu( mcu::McuInitializer().GetHSession() );

    // CTRAFTȐꍇ́ASUCCESS
    if( uji::sys::PLATFORM_CTR == uji::sys::GetPlatformType())
    {
        goto SUCCESS;
    }
    else if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        goto SUCCESS;
    }

    //Rc{[
    panel.Open( L"rom:/jpeg/3DVolumeDown.jpg" );
    mcu.ReadByReceive( MCU_THREE_D_VOLUME_ADDRESS, &initialVolume,  sizeof(u8) );
    timer=0;
    // SPFL
    if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
    {
        do
        {
            // l`FbN
            if( timer++> config.Get().VolumeAdjustTimeOut ){
                mcu.ReadByReceive( MCU_THREE_D_VOLUME_ADDRESS, &volume,  sizeof(u8) );
                if( abs( (int)volume-(int)initialVolume ) <= config.Get().VolumeNoSense )
                {
                    result.m_Micro = MICRO_3D_VOLUME_NO_SENSE_ERROR;
                }else{
                    result.m_Micro = MICRO_3D_VOLUME_RANGE_ERROR;
                }
                goto TIMEOUT;
            }

            ShowCurrentVolume(s_InfoWindow);
            UpdateDisplay1();
        }
        while( !DetectMinVolume( threeDVolumeMin, MCU_THREE_D_VOLUME_ADDRESS, SPR_ThreeDVolume_Min +  margin_3dvolume_procchk) );
    }
    panel.Close();


    //Rc{[
    panel.Open( L"rom:/jpeg/3DVolumeUp.jpg" );
    timer=0;
    // SPFL
    if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
    {
        do
        {
            if( timer++> config.Get().VolumeAdjustTimeOut )
            {
                mcu.ReadByReceive( MCU_THREE_D_VOLUME_ADDRESS, &volume,  sizeof(u8) );
                if( abs( (int)volume-(int)initialVolume ) <= config.Get().VolumeNoSense )
                {
                    result.m_Micro = MICRO_3D_VOLUME_NO_SENSE_ERROR;
                }else{
                    result.m_Micro = MICRO_3D_VOLUME_RANGE_ERROR;
                }
                goto TIMEOUT;
            }

            ShowCurrentVolume(s_InfoWindow);
            UpdateDisplay1();
        }
        while( !DetectMaxVolume( threeDVolumeMax, MCU_THREE_D_VOLUME_ADDRESS,  SPR_ThreeDVolume_Max -  margin_3dvolume_procchk ) );
    }
    panel.Close();

SUCCESS:
    //EChȄI
    Menu::m_WindowManager.DestroyWindow( s_InfoWindow );
    delete s_InfoWindow;
    sprintf( result.m_String, "3D VOLUME MIN=%d MAX=%d\n",threeDVolumeMin, threeDVolumeMax);
    result.m_Result = true;
    return result.m_Result;

TIMEOUT:
    //EChȄI
    Menu::m_WindowManager.DestroyWindow( s_InfoWindow );
    delete s_InfoWindow;

    sprintf( result.m_String, "3D VOLUME MIN=%d MAX=%d\n",threeDVolumeMin, threeDVolumeMax);
    result.m_Result = false;
    return result.m_Result;

}


