#ifndef SPI_FLASH_H_
#define SPI_FLASH_H_

#include <vector>
#include <map>
#include <list>
#include <string>
#include <sstream>
#include <iomanip>
#include <nn.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include <nn/fnd.h>
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include <nn/fs/CTR/fs_ArchiveTypesForSystem.h>
#include <nn/hid/CTR/hid_AccelerometerCalibrator.h>
#include <nn/hid/CTR/hid_ApiWithPrivilege.h>
#include <nn/hw/ioreg.h>
#include <nn/os.h>

#include "sys_GraphicsDrawing.h"
#include "sys_WindowManager.h"
#include "sys_Window.h"
#include "sys_MessageLogWindow.h"
#include "sys_TextWindow.h"    
#include "sys_Pad.h"

#include "../seq/TestResult.h"


#define DATA_4K_BYTE 4096
#define DATA_1M_BIT      128*1024		// 128K Byte
#define DATA_4M_BIT      512*1024		// 512K Byte
#define ERASE_CHECK_OFF 0
#define ERASE_CHECK_ON  1
#define  READ_WAY_1XIO  0x0001
#define  READ_WAY_4XIO  0x0004

#define  CHECK_ERASE_ERROR        0x100000
#define  VERIFY_INCREMENT_ERROR   0x200000

namespace uji {
namespace eva {


// WindowNXpVvȃNX
class TestFlash : public sys::Window
{
public:
    /*
        RXgN^
        mgr : j[}l[W̃CX^X̃AhX
    */
    TestFlash(sys::WindowManager& mgr, s32 width, s32 height)
    : Window("SIMPLE WINDOW", width, height), m_MesgCount(0), m_FrameCount(0),
      m_WindowManager(mgr), m_MessageLogWindow(0), m_TextWindow(0)
    {}
	virtual ~TestFlash(){}

    // o͐̃eLXgEChEݒ肵܂
    void SetTextWindow(sys::TextWindow& wnd) { m_TextWindow = &wnd; }
    // o͐̃bZ[WOEChEݒ肵܂
    void SetMessageLogWindow(sys::MessageLogWindow& wnd) { m_MessageLogWindow = &wnd; }  

protected:
    // eI[o[ChƎ̏܂
//    virtual void OnDraw(sys::GraphicsDrawing* gfx);
//    virtual void OnUpdatePad(const sys::Pad& pad);
//    virtual void OnUpdate();

private:
    int m_MesgCount;
    int m_FrameCount;
    
    sys::WindowManager&     m_WindowManager;  
    sys::MessageLogWindow*  m_MessageLogWindow;
    sys::TextWindow*        m_TextWindow;
};

// NX
class SPIFlash
{
public:
	SPIFlash()
    :
        m_frameCount(0),
        /*
            eLXgEChE
            1ʂɉ23~c8\\BtHgTCY16B
        */
        m_TextWindow(23, 8, 16),
            
        /*
            bZ[WOEChE
            1ʂɉ20~c10\\B100s̃obt@BtHgTCY14B
            EChEɃtH[JXꍇ́AXN[\B
        */
        m_MessageLogWindow(20, 10, 100, 14),
            
        /* 
            EChEhVvEChE
            TCY200dot~140dotB
        */
        m_TestFlash(this->m_WindowManager, 200, 140)
    {}
	virtual ~SPIFlash(){}
    
    void Run();

private:
    int m_frameCount;    

    sys::WindowManager      m_WindowManager;
    sys::TextWindow         m_TextWindow;
    sys::MessageLogWindow   m_MessageLogWindow;
    TestFlash            	m_TestFlash;
};    

	extern bool CheckSPIFlash( uji::seq::TestResult &result );			// 
	extern s32 CheckErase(u32 test_size, u32 start_address, u32* read_data, nn::os::Tick start_tick, s32 ECflag);
	extern s32 VerifyIncrement(u32 test_size, u32 start_address, u32* write_data, u32* read_data, nn::os::Tick start_tick, u32 read_way);
	extern u32 PrepareSPIFlash(void);
}
}





#endif
