// 1 sector = 4k Byte
// 1Mb 0x000000-0x01FFFF
// 4Mb 0x000000-0x07FFFF


#include "SPIFlash.h"
#include "../seq/TesterLog/ProductionLog.h"
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include <nn/ctst/ctst_Parameters.h>
#include <nn/ctst/ctst_Api.h>
#include <nn/pxi/CTR/pxi_CardTest9.h>
//#include <nn/fs/fs_IpcFileSystem.h>



using namespace  nn::ctst::CTR;
extern bool initialize_card_flag;

static s32 SPIFlash_PushA(void);
static void SPIFlash_PushX(uji::sys::GraphicsDrawing* gfx);
static void SPIFlash_PushY(uji::sys::GraphicsDrawing* gfx);
static void PrepareCard(void);
static void PrepareScreen(uji::sys::GraphicsDrawing* gfx, uji::sys::Pad* pad);
static s64 GetMicroSecond( nn::os::Tick start_time );
static s32 EraseCommand(u32 test_size, u32 start_address);
static s32 EraseWriteRead(u32 test_size, u32 start_address, u32* write_data, u32* read_data, s32 ECflag);

namespace uji {
namespace eva {



//============================================================================
//============================================================================
void  SPIFlash::Run(void)
{
    uji::seq::TestResult result_check;

    uji::eva::CheckSPIFlash(result_check);
}


//============================================================================
// obNAbv̌
//============================================================================
bool CheckSPIFlash(uji::seq::TestResult &result)
{
    //j[p̃EChE}l[W
    static uji::sys::WindowManager m_WindowManager;

    nn::os::Tick start_tick;
    s64 test_time = 0;
    s32 start_page = 0;
    s32 read_page_size = 1;
    s32 moji = 1;
    s32 ng_code = 0;
    u8 first_flag = 1;
    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(196);

    //  CTRJ[hɃANZX鏀
    PrepareCard();

    do
    {

        // ------------------------------------\------------------------------------
        PrepareScreen(gfx, &pad);
        (void)gfx->m_TextWriter.Printf( "\n start_page:%d  read_page_size:%d moji:%d  \n\n\n", start_page, read_page_size, moji );

        // j[ŏ͏Lʂɕ\邽߁ALs
        if( first_flag == 1)
        {
            glFlush();
            gfx->m_DrawFramework->SwapBuffers();
            first_flag = 0;
        }

        // ------------------------------------L[͑҂[v------------------------------------
        while(  !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) )
        {

            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            // A{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_A))
            {
                // ԌvJn
                start_tick = nn::os::Tick::GetSystemCurrent();
                ng_code = SPIFlash_PushA();
                test_time = GetMicroSecond(start_tick);
                NN_LOG(" test_time:%lld mS \n", test_time);

                if(ng_code) NN_LOG("ng_code:%d\n", ng_code);
                break;
            }

            // B{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B))
            {
                moji++;
                (void)gfx->m_TextWriter.Printf( "\n moji:%d \n", moji );

                NN_LOG("\n B \n");
                break;
            }

            // X{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_X))
            {
                SPIFlash_PushX(gfx);
                break;
            }

            // Y{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_Y))
            {
                SPIFlash_PushY(gfx);
                break;
            }

            // {^ |
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_DOWN))
            {
                start_page--;
                (void)gfx->m_TextWriter.Printf( "\n start_page:%d \n", start_page );
                break;
            }

            // {^ {
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_UP))
            {
                start_page++;
                (void)gfx->m_TextWriter.Printf( "\n start_page:%d \n", start_page );
                break;
            }

            // 
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_LEFT))
            {
                read_page_size--;
                (void)gfx->m_TextWriter.Printf( "\n read_page_size:%d \n", read_page_size );
                break;
            }

            // E
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_RIGHT))
            {
                read_page_size++;
                (void)gfx->m_TextWriter.Printf( "\n read_page_size:%d \n", read_page_size );
                break;
            }

        };

        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        // Sleep
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(200 * 1000 * 1000));

    // R{^B{^𓯎ꂽꍇ͌rłj[ɖ߂
    }while(  !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) );

    NN_LOG("end...\n");

    result.m_Result = true;
    return result.m_Result;

}





//============================================================================
// C[X(ECflagERASE_CHECK_ON̏ꍇFFɂȂĂ邱Ƃ̊mFs)
//============================================================================
s32 CheckErase(u32 test_size, u32 start_address, u32* read_data, nn::os::Tick start_tick, s32 ECflag)
{
    int i;
    s64 test_time = 0;

    // C[XďoׂłԂɖ߂
    NN_LOG("\n ERASE \n");
    EraseCommand(test_size, start_address);

    test_time = GetMicroSecond(start_tick);
    NN_LOG(" test_time:%lld mS \n", test_time);

    // C[XmFtO1̏ꍇ̓C[XɍsĂ邩mF
    if(ECflag == ERASE_CHECK_ON)
    {
        // [h
        NN_LOG("\n READ \n");
//      nn::fs::Read(0x03, start_address, read_data, test_size);
        nn::fs::Read_4xIO(0xEB, start_address, read_data, test_size);

        test_time = GetMicroSecond(start_tick);
        NN_LOG(" test_time:%lld mS \n", test_time);

        // C[X̒lFFł邱ƂmF
        for(i=0;i<test_size/sizeof(u32);i++)
        {
            if( read_data[i] != 0xFFFFFFFF )
            {
                NN_LOG( "FIRST ERASE CHECK NG i:%d read:%llX  \n", i, read_data[i] );
                return i + CHECK_ERASE_ERROR;
            }
        }
        NN_LOG( "ERASE CHECK OK i:%X read:%llX  \n", i, read_data[i-1] );
        test_time = GetMicroSecond(start_tick);
        NN_LOG(" CheckErase Total Time:%lld mS \n", test_time);
    }


    return 0;

}


//============================================================================
// eXgp^[݂ƃxt@C
//============================================================================
s32 VerifyIncrement(u32 test_size, u32 start_address, u32* write_data, u32* read_data, nn::os::Tick start_tick, u32 read_way)
{
    s64 test_time = 0;
    int i;

    // foCXstart_addressɃAhXwrite_datan܂f[^test_size
    nn::fs::CpuWriteWithoutVerify(write_data, start_address, test_size);

    test_time = GetMicroSecond(start_tick);
    NN_LOG(" test_time:%lld mS \n", test_time);

    // eXgp^[ǂݏo
    NN_LOG("\n READ \n");
    if(read_way == READ_WAY_4XIO) nn::fs::Read_4xIO(0xEB, start_address, read_data, test_size);
    else                      nn::fs::Read(0x03, start_address, read_data, test_size);

    test_time = GetMicroSecond(start_tick);
    NN_LOG(" test_time:%lld mS  start_address:%llX\n", test_time, start_address);

    // ǂݏol񂾒lƓł邱Ƃr
    for(i=0;i<test_size/sizeof(u32);i++)
    {
        if( read_data[i] != write_data[i] )
        {
            NN_LOG( "WRITE NG i:%d read:%X write:%X  \n", i, read_data[i], write_data[i] );
//          return i + VERIFY_INCREMENT_ERROR;
        }
    }
    NN_LOG( "WRITE CHECK OK i:%X read:%llX  \n", i, read_data[i-1] );
    test_time = GetMicroSecond(start_tick);
    NN_LOG(" test_time:%lld mS \n", test_time);

    return 0;

}


//============================================================================
//  SPIFlash̏(ʐMx̐ݒ)
//  ߂l  foCX̃TCY
//============================================================================
u32 PrepareSPIFlash(void)
{
    u32 device_density = 0;
    u32 status = 0;

    // ʐMxݒ
    nn::fs::SetCardSpiBaudRate(nn::fs::CARDSPI_BAUDRATE_8MHZ);

    // foCXID擾
    NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x9F, &status, 3));  // RDID
    device_density = status / 0x10000;

    NN_LOG("\n status:%X  device_density:%X \n", status, device_density);

    if(device_density == 0x11) return DATA_1M_BIT;
    else if(device_density == 0x13) return DATA_4M_BIT;
    else return 1;

}


}
}


//============================================================================
//  CTRJ[hɃANZX鏀
//============================================================================
static void PrepareCard(void)
{
//  u8 apMemory[8*1024];
//  u32 read_size = 512 * 10;
//  DetailInfo  detailInfo;
//  SettingInfo setting;
//  int i;
    u32         gCardMaxSize;


    NN_LOG("\n WaitButton 1\n");
    while(1)
    {
        uji::sys::Pad().UpdatePad();
        if( uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_A ))
        {
            NN_LOG("Button_A \n WaitButton 2\n");
            break;
        }
    }

    //ctst(CardTest)Cu
//  NN_UTIL_PANIC_IF_FAILED(Initialize());

    //CardhCo
//  NN_UTIL_PANIC_IF_FAILED(FunctionTestStart(apMemory, read_size, TID_FUNC_INITIALIZE, &detailInfo));


}



//============================================================================
//  ʕ\̏
//============================================================================
static void PrepareScreen(uji::sys::GraphicsDrawing* gfx, uji::sys::Pad* pad)
{
    static uji::sys::WindowManager m_WindowManager;

    gfx->m_DrawFramework->Clear();

    //  EChE
    m_WindowManager.UpdatePad(*pad);
    m_WindowManager.Update();
    m_WindowManager.DrawDisplay0();

    //  `
    gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

    // `̑O
    gfx->BeginDrawingString();
    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
    gfx->SetFixedWidthFont(16);
    gfx->m_TextWriter.SetCursor(10, 20);

}



//============================================================================
// A{^Ƃ̏
//============================================================================
static s32 SPIFlash_PushA(void)
{
    u32 device_size = 0;
    u32 start_address = 0x1000 * 0;
    u32* read_data;
    u32* write_data;
    int i;

    device_size = uji::eva::PrepareSPIFlash();
    if(device_size == 1)
    {
        NN_LOG("\nERROR\n");
        return 1;
    }

    read_data = reinterpret_cast<u32*>(uji::sys::AllocDeviceMemory(device_size, 32));
    if (read_data == NULL)
    {
        NN_LOG("Failed to allocate continuous memory\n");
//NG̏邱ƁB
    }
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));

    write_data = reinterpret_cast<u32*>(uji::sys::AllocDeviceMemory(device_size, 32));
    if (write_data == NULL)
    {
        NN_LOG("Failed to allocate continuous memory\n");
//NG̏邱ƁB
    }

        NN_LOG("test4 %X (%u) %d \n", device_size, device_size );
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));

    // f[^i[
    for(i=0;i<device_size/sizeof(u32);i++)
    {
        read_data[i] = 0x99999999;
        write_data[i] = i;
    }


    //  Erase -> Write -> Read -> Verify -> Erase -> Erase̊mF̏ɍs֐
    EraseWriteRead(device_size, start_address, write_data, read_data, ERASE_CHECK_OFF);

#if 0
    // f[^i[
    for(i=0;i<test_size/sizeof(u32);i++)
    {
        read_data[i] = 0x99999999;
        write_data[i] = 0x55555555;
    }

    //  Erase -> Write -> Read -> Verify̏ɍs֐
    EraseWriteRead(device_size, start_address, write_data, read_data, ERASE_CHECK_OFF);
#endif

    uji::sys::Free(read_data);
    uji::sys::Free(write_data);

    return 0;

}


//============================================================================
// X{^Ƃ̏
//============================================================================
static void SPIFlash_PushX(uji::sys::GraphicsDrawing* gfx)
{
    bool x = 0;
    u8 power_on_off = 0;
//  nn::fs::CardSlotIsInserted(&x);
    nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
    (void)gfx->m_TextWriter.Printf( "\n x:%d, power_on_off:%d \n", x, power_on_off );
    nn::fs::CardSlotPowerOn(&power_on_off);
    nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
    (void)gfx->m_TextWriter.Printf( "\n1 x:%d, power_on_off:%d \n", x, power_on_off );
//  nn::fs::CTRCardInitialize();
//              (void)gfx->m_TextWriter.Printf( "\n X \n"  );
    NN_LOG("\n X \n");

}


//============================================================================
// Y{^Ƃ̏
//============================================================================
static void SPIFlash_PushY(uji::sys::GraphicsDrawing* gfx)
{
    bool x = 0;
    u8 power_on_off = 0;

#if 0
                moji--;
                (void)gfx->m_TextWriter.Printf( "\n moji:%d \n", moji );
#endif

//  nn::fs::CardSlotIsInserted(&x);
    nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
//  CardSlotPowerOn(&power_on_off);
    (void)gfx->m_TextWriter.Printf( "\n %d, power_on_off:%d \n", x, power_on_off );
    nn::fs::CardSlotPowerOff(&power_on_off);
    nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
    (void)gfx->m_TextWriter.Printf( "\n2 x:%d, power_on_off:%d \n", x, power_on_off );
    (void)gfx->m_TextWriter.Printf( "\n Y \n"  );
    NN_LOG("\n Y \n");
}


/*!--------------------------------------------------------------------------*
  @brief        Ԍv֐
        vJn_
  ߂l    start_timeo߂(mS)
 *---------------------------------------------------------------------------*/
static s64 GetMicroSecond( nn::os::Tick start_time )
{

    nn::os::Tick currentTick = nn::os::Tick::GetSystemCurrent();

    float millisecond = (float)((currentTick - start_time).ToTimeSpan().GetMicroSeconds() / 1000.0);

    return millisecond;

}


//============================================================================
//  Erases֐
//  :test_size      ̈̃TCY
//  :start_address  JnAhX
//============================================================================
static s32 EraseCommand(u32 test_size, u32 start_address)
{
    u32 erase_loop = 0;
    s32 i = 0;
    u32 status = 0;

    if( test_size%(4*1024) == 0 ) erase_loop = test_size/(4*1024);
    else                          erase_loop = test_size/(4*1024) + 1;

    // C[Xs(1ŃC[Xł̂4KByte܂)
    for(i=0;i<erase_loop;i++)
    {
        // nn::fs::SectorEraseWithoutVerify(start_address + i*4096);肱̕SmS

        // ݉\ɂ
        NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x06));  // WREN

        // ݉\ɂȂƂmF
        do {
//  NN_LOG("\n ERASE1 \n");
            NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
        } while(!(status & 0x02));  // WEL=1 ɂȂ烋[v𔲂

        // C[X
        NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x20, start_address + i*4096)); // SE

        do {
//  NN_LOG("\n ERASE2 \n");
            NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
        } while(status & 0x01);  // WIP=0 ɂȂ烋[v𔲂

    }

    return 0;

}


//============================================================================
//  Erase -> Erase̊mF -> Write -> Read -> Verify -> Erase -> Erase̊mF̏ɍs֐
//  :test_size      ̈̃TCY
//  :start_address  JnAhX
//  :write_data     ݃f[^i[ꏊ̐擪AhX
//  :read_data      ǂݏof[^i[ꏊ̐擪AhX
//  :ECflag         Erase̊mFsǂ߂tO  ꂪ0̏ꍇEraseAmFȂWriteJn
//============================================================================
static s32 EraseWriteRead(u32 test_size, u32 start_address, u32* write_data, u32* read_data, s32 ECflag)
{
    s32 ng_code = 0;
    s32 i = 0;

    // Ԍvp
    nn::os::Tick start_tick;
    s64 test_time = 0;

    // ԌvJn
    start_tick = nn::os::Tick::GetSystemCurrent();

    NN_LOG("\nFIRST ERASE \n");
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));

    // C[X(ECflagERASE_CHECK_ON̏ꍇFFɂȂĂ邱Ƃ̊mFs)
    uji::eva::CheckErase(test_size, start_address, read_data, start_tick, ECflag);

    NN_LOG("\n WRITE \n");

    // eXgp^[݂ƃxt@C
    uji::eva::VerifyIncrement(test_size, start_address, write_data, read_data, start_tick, READ_WAY_1XIO);

    NN_LOG("\nSECOND ERASE \n");

    // C[XAсAFFɂȂĂ邱Ƃ̊mF
    uji::eva::CheckErase(test_size, start_address, read_data, start_tick, ERASE_CHECK_ON);

    return ng_code;
}
































//  size_t once_write_size = 32;
//NN_LOG( "i:%d read:%X write:%X  \n", i, read_data[i], write_data[i] );
//if(i<20)NN_LOG( "i:%d read:%X write:%X  \n", i, read_data[i], write_data[i] );
//  if(i>1024)NN_LOG( "i:%d read:%X write:%X  \n", i, read_data[i], write_data[i] );
//                      NN_LOG("\n TEST2 [%x] \n", status);
#if 0
//  u32* read_data;
//  u32* write_data;
    read_data = reinterpret_cast<u32*>(uji::sys::AllocDeviceMemory(test_size/sizeof(u32), 32));
    if (read_data == NULL)
    {
        NN_LOG("Failed to allocate continuous memory\n");
//NG̏邱ƁB
    }

    write_data = reinterpret_cast<u32*>(uji::sys::AllocDeviceMemory(test_size/sizeof(u32), 32));
    if (write_data == NULL)
    {
        NN_LOG("Failed to allocate continuous memory [write_data]\n");
//NG̏邱ƁB
    }
#endif
//  NN_LOG( "1 read:%X write:%X  \n", read_data[1], write_data[1] );


#if 0


    NN_LOG("START %d\n", sizeof(u32));
    NN_LOG("DATA_4M_BIT/sizeof(u32):%x", DATA_4M_BIT/sizeof(u32));



//============================================================================
// A{^Ƃ̏
//============================================================================
static void SPIFlash_PushA(void)
{
    u32 data_size = 1024*1024;
    int i;
    u32 test_size = DATA_4K_BYTE/sizeof(u32) + 64;      // f[^̐ (4kByte̒ɂu32^̐)
    u32 read_data[test_size];
    u32 read_data2[test_size];
    u32 write_data[test_size];
    u32 status = 0;
    u32 start_address = 0x1000 * 0;
    size_t size = 32;
    size_t once_write_size = 8;

    u8* apMemory;
    apMemory = reinterpret_cast<u8*>(uji::sys::AllocDeviceMemory(data_size, 32));
    if (apMemory == NULL)
    {
        NN_LOG("Failed to allocate continuous memory\n");
//NG̏邱ƁB
    }

    // eXgp^[

    // eXgp^[ǂݏo

    // ǂݏol񂾒lƓł邱Ƃr


    // f[^i[
    for(i=0;i<test_size;i++)
    {
        read_data[i] = 0x12345678;
        read_data2[i] = 0x87654321;
        write_data[i] = 0x55555555;
    }

    //
    for(i=0;i<test_size;i++)
    {
        if (i>=1024)NN_LOG("\n i:%d read read_str :%02X ", i, read_data[i] );
        if (i>=1024)NN_LOG("\n i:%d read read_str2:%02X \n", i, read_data2[i] );
    }


    NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x9F, &status, 3));  // RDSR
    NN_LOG("\n TEST0 [%x] \n", status);

    NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x06));  // WREN
    do {
        NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
    } while(!(status & 0x02));  // WEL=1 ɂȂ烋[v𔲂

    // C[X
    NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x20, start_address));

    do {
        NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
    } while(status & 0x01);  // WIP=0 ɂȂ烋[v𔲂


    NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x06));  // WREN
    do {
        NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
    } while(!(status & 0x02));  // WEL=1 ɂȂ烋[v𔲂

    // C[X
//              NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x20, 0x1000));


    do {
        NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
    } while(status & 0x01);  // WIP=0 ɂȂ烋[v𔲂


    NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x03, start_address, read_data, test_size * sizeof(u32)));
    NN_UTIL_PANIC_IF_FAILED(nn::fs::Read_4xIO(0xEB, start_address, read_data2, test_size * sizeof(u32)));
//              NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x03, 0x1000, read_data+1024, test_size * sizeof(u32) - 1024));
//              NN_UTIL_PANIC_IF_FAILED(nn::fs::Read_4xIO(0xEB, 0x1000, read_data2+1024, test_size * sizeof(u32) - 1024));

    NN_LOG("\n start_address:%x test_size:%d \n", start_address, test_size);
    for(i=0;i<test_size;i++)
    {

        if (i>=1024)NN_LOG("\n i:%d read read_str :%02X ", i, read_data[i] );
        if (i>=1024)NN_LOG("\n i:%d read read_str2:%02X \n", i, read_data2[i] );
    }


    for(i=0;i<test_size;i++)
    {
        NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x06));  // WREN
        do {
            NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
//                      NN_LOG("\n TEST1 [%x] \n", status);
        } while(!(status & 0x02));  // WEL=1 ɂȂ烋[v𔲂


        // f[^̏(32oCg)
        NN_UTIL_PANIC_IF_FAILED(nn::fs::Write(0x02, start_address + once_write_size*i, write_data, once_write_size));  // PP

        do {
            NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
//                      NN_LOG("\n TEST2 [%x] \n", status);
        } while(status & 0x01);  // WIP=0 ɂȂ烋[v𔲂
    }

    NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x03, start_address, read_data, test_size * sizeof(u32)));
    NN_UTIL_PANIC_IF_FAILED(nn::fs::Read_4xIO(0xEB, start_address, read_data2, test_size * sizeof(u32)));

//              NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x03, 0x1000, read_data+1024, test_size * sizeof(u32) - 1024));
//              NN_UTIL_PANIC_IF_FAILED(nn::fs::Read_4xIO(0xEB, 0x1000, read_data2+1024, test_size * sizeof(u32) - 1024));

    NN_LOG("\n test start_address:%x \n", start_address);
    for(i=0;i<test_size;i++)
    {
        if (i>=1024)NN_LOG("\n i:%d read read_str :%02X ", i, read_data[i] );
        if (i>=1024)NN_LOG("\n i:%d read read_str2:%02X \n", i, read_data2[i] );
    }

    NN_LOG("\n A \n");
    uji::sys::Free(apMemory);


}



{

    //j[p̃EChE}l[W
    static uji::sys::WindowManager m_WindowManager;

    uji::sys::GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(196);

    // J[\ʒup
    uji::sys::Point cursorPos;

    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;


    uji::seq::TestResult result_check;
    u8 change_value = 1;


    s64 gCardMaxSize;
    s32 start_page = 0;
    s32 read_page_size = 1;
    s32 moji = 1;


    u8* apMemory;
    u32 data_size = 1024*1024;

    apMemory = reinterpret_cast<u8*>(uji::sys::AllocDeviceMemory(data_size, 32));
    if (apMemory == NULL)
    {
        NN_LOG("Failed to allocate continuous memory\n");
//NG̏邱ƁB
    }

    nn::fs::FileInputStream file;

    // }EgOɕʂ̃foCXւ̃A}Egs
    nn::fs::Unmount( "nand:" );

    // J[hfoCX̏
    nn::fs::InitializeForLoader();

    NN_UTIL_PANIC_IF_FAILED( nn::fs::CTRCardInitialize());//ˋ炭KvȂÔ߁B

    // Ô߁AT[rX֘AN
    NN_UTIL_PANIC_IF_FAILED( nn::srv::Initialize());

    // foCX̃}Eg
    NN_UTIL_PANIC_IF_FAILED( nn::fs::MountSpecialArchive("card:", nn::fs::CTR::ARCHIVE_TYPE_CARD) );

    // fs̏A
    NN_UTIL_PANIC_IF_FAILED(file.TryInitialize("card:/"));

    // J[h̃TCY擾
    NN_UTIL_PANIC_IF_FAILED(file.TryGetSize((s64*)&gCardMaxSize));
    NN_LOG("\n gCardMaxSize:%lld \n", gCardMaxSize);

    //
    u8 first_flag = 1;
    bool x = 0;
    u8 power_on_off = 0;
    int i;


    do
    {

        // ------------------------------------\------------------------------------

        gfx->m_DrawFramework->Clear();

        //  EChE
        m_WindowManager.UpdatePad(pad);  // pbh
        m_WindowManager.Update();        // XV
        m_WindowManager.DrawDisplay0();

        //  `
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

        // `̑O
        gfx->BeginDrawingString();
        gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
        gfx->SetFixedWidthFont(16);
        gfx->m_TextWriter.SetCursor(10, 20);

        (void)gfx->m_TextWriter.Printf( "\n start_page:%d  read_page_size:%d moji:%d  \n\n\n", start_page, read_page_size, moji );

        // ------------------------------------\ ܂------------------------------------

        while(  !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) )
        {

            // j[
            if( first_flag == 1)
            {
//              glFlush();
//              gfx->m_DrawFramework->SwapBuffers();
                first_flag = 0;
                break;
            }

            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);



            // A{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_A))
            {
//              u8 command;
//              u32 address = 0x00;
                u32 test_size = DATA_4K_BYTE/sizeof(u32) + 64;      // f[^̐ (4kByte̒ɂu32^̐)
//              u32 test_size = 64/sizeof(u32);     // f[^̐ (4kByte̒ɂu32^̐)

                u32 read_data[test_size];
                u32 read_data2[test_size];
                u32 write_data[test_size];
                u32 status = 0;
                u32 start_address = 0x1000 * 0;
                size_t size = 32;
                size_t once_write_size = 8;


                for(i=0;i<test_size;i++)
                {
                    read_data[i] = 0x12345678;
                    read_data2[i] = 0x87654321;
                    write_data[i] = 0x55555555;
                }

                for(i=0;i<test_size;i++)
                {

                    if (i>=1024)NN_LOG("\n i:%d read read_str :%02X ", i, read_data[i] );
                    if (i>=1024)NN_LOG("\n i:%d read read_str2:%02X \n", i, read_data2[i] );
                }


                NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x9F, &status, 3));  // RDSR
                NN_LOG("\n TEST0 [%x] \n", status);

                NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x06));  // WREN
                do {
                    NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
                } while(!(status & 0x02));  // WEL=1 ɂȂ烋[v𔲂

                // C[X
                NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x20, start_address));

                do {
                    NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
                } while(status & 0x01);  // WIP=0 ɂȂ烋[v𔲂


                NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x06));  // WREN
                do {
                    NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
                } while(!(status & 0x02));  // WEL=1 ɂȂ烋[v𔲂

                // C[X
//              NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x20, 0x1000));

// PP L̂悤ȃf[^ꕶǉKvL
// nn::fs::Write(0x02, start_address + once_write_size*i, write_data, once_write_size));


                do {
                    NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
                } while(status & 0x01);  // WIP=0 ɂȂ烋[v𔲂


                NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x03, start_address, read_data, test_size * sizeof(u32)));
                NN_UTIL_PANIC_IF_FAILED(nn::fs::Read_4xIO(0xEB, start_address, read_data2, test_size * sizeof(u32)));
//              NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x03, 0x1000, read_data+1024, test_size * sizeof(u32) - 1024));
//              NN_UTIL_PANIC_IF_FAILED(nn::fs::Read_4xIO(0xEB, 0x1000, read_data2+1024, test_size * sizeof(u32) - 1024));

                NN_LOG("\n start_address:%x test_size:%d \n", start_address, test_size);
                for(i=0;i<test_size;i++)
                {

                    if (i>=1024)NN_LOG("\n i:%d read read_str :%02X ", i, read_data[i] );
                    if (i>=1024)NN_LOG("\n i:%d read read_str2:%02X \n", i, read_data2[i] );
                }


                for(i=0;i<test_size;i++)
                {
                    NN_UTIL_PANIC_IF_FAILED(nn::fs::Command(0x06));  // WREN
                    do {
                        NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
//                      NN_LOG("\n TEST1 [%x] \n", status);
                    } while(!(status & 0x02));  // WEL=1 ɂȂ烋[v𔲂


                    // f[^̏(32oCg)
                    NN_UTIL_PANIC_IF_FAILED(nn::fs::Write(0x02, start_address + once_write_size*i, write_data, once_write_size));  // PP

                    do {
                        NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x05, &status, 1));  // RDSR
//                      NN_LOG("\n TEST2 [%x] \n", status);
                    } while(status & 0x01);  // WIP=0 ɂȂ烋[v𔲂
                }

                NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x03, start_address, read_data, test_size * sizeof(u32)));
                NN_UTIL_PANIC_IF_FAILED(nn::fs::Read_4xIO(0xEB, start_address, read_data2, test_size * sizeof(u32)));

//              NN_UTIL_PANIC_IF_FAILED(nn::fs::Read(0x03, 0x1000, read_data+1024, test_size * sizeof(u32) - 1024));
//              NN_UTIL_PANIC_IF_FAILED(nn::fs::Read_4xIO(0xEB, 0x1000, read_data2+1024, test_size * sizeof(u32) - 1024));

                NN_LOG("\n test start_address:%x \n", start_address);
                for(i=0;i<test_size;i++)
                {
                    if (i>=1024)NN_LOG("\n i:%d read read_str :%02X ", i, read_data[i] );
                    if (i>=1024)NN_LOG("\n i:%d read read_str2:%02X \n", i, read_data2[i] );
                }

                NN_LOG("\n A \n");
                break;
            }

            // B{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B))
            {
                moji++;
                (void)gfx->m_TextWriter.Printf( "\n moji:%d \n", moji );

                NN_LOG("\n B \n");
                break;
            }
            // {^ |
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_DOWN))
            {
                start_page--;
                (void)gfx->m_TextWriter.Printf( "\n start_page:%d \n", start_page );
                break;
            }

            // {^ {
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_UP))
            {
                start_page++;
                (void)gfx->m_TextWriter.Printf( "\n start_page:%d \n", start_page );
                break;
            }

            // 
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_LEFT))
            {
                read_page_size--;
                (void)gfx->m_TextWriter.Printf( "\n read_page_size:%d \n", read_page_size );
                break;
            }

            // E
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_RIGHT))
            {
                read_page_size++;
                (void)gfx->m_TextWriter.Printf( "\n read_page_size:%d \n", read_page_size );
                break;
            }


            // X{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_X))
            {
                nn::fs::CardSlotIsInserted(&x);
                nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
                (void)gfx->m_TextWriter.Printf( "\n x:%d, power_on_off:%d \n", x, power_on_off );
                nn::fs::CardSlotPowerOn(&power_on_off);
                nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
                (void)gfx->m_TextWriter.Printf( "\n1 x:%d, power_on_off:%d \n", x, power_on_off );
                nn::fs::CTRCardInitialize();
//              (void)gfx->m_TextWriter.Printf( "\n X \n"  );
                NN_LOG("\n X \n");
                break;
            }

            // Y{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_Y))
            {
//              moji--;
//              (void)gfx->m_TextWriter.Printf( "\n moji:%d \n", moji );


                nn::fs::CardSlotIsInserted(&x);
                nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
//  CardSlotPowerOn(&power_on_off);
                (void)gfx->m_TextWriter.Printf( "\n %d, power_on_off:%d \n", x, power_on_off );
                nn::fs::CardSlotPowerOff(&power_on_off);
                nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
                (void)gfx->m_TextWriter.Printf( "\n2 x:%d, power_on_off:%d \n", x, power_on_off );
                (void)gfx->m_TextWriter.Printf( "\n Y \n"  );
                NN_LOG("\n Y \n");
                break;
            }
//#endif


        };

        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        // Sleep
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(200 * 1000 * 1000));

    // R{^B{^𓯎ꂽꍇ͌rłj[ɖ߂
    }while(  !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) );

    NN_LOG("end...\n");


//    delete q;

    result.m_Result = true;
    return result.m_Result;

}


#endif
