/*--------------------------------------------------------------------------*
 Project:
 File: spi_Tool.h


*--------------------------------------------------------------------------*/
#ifndef __SPI_TOOL_H__
#define __SPI_TOOL_H__

#include <nn/spi.h>
#include <nn/srv.h>

#include "sys.h"

// TS{[hł̃fobOƌł̃fobN̐؂ւ
//#define TS_Board


namespace uji {
namespace eva {
namespace spi {

#define SEQ_COMMAND_ID_ERROR  1
#ifdef TS_Board
#define COMMAND_TIME_OUT      60000
#else
#define COMMAND_TIME_OUT      3000
#endif

typedef struct {
    int sum;
    int id;
    int arg_num;
    char str_check_sum[5];
    char str_id[5];
    char str_arg_num[3];
    char str_arg[256];
} SpiCommand;

typedef struct {
    int sum;
    int id;
    int arg_num;
    char str_check_sum[5];
    char str_id[5];
    char str_arg_num[3];
    char str_arg[256];
} SpiResponse;



class WriteSpi
{
public:

    WriteSpi(){
    }
    virtual ~WriteSpi(){}
    
    static void WriteSpiInit()
    {
        nn::Result result;
        // ServiceManagervZX̏
        result = nn::srv::Initialize();
        NN_UTIL_PANIC_IF_FAILED(result);

        result = nn::spi::CTR::detail::InitializePort( &session[0], nn::spi::CTR::CS2 );
        NN_UTIL_PANIC_IF_FAILED(result);
        result = nn::spi::CTR::detail::InitializePort( &session[1], nn::spi::CTR::CS3 );
        NN_UTIL_PANIC_IF_FAILED(result);
    
        s1 = new nn::spi::CTR::SPI(session[0]); 
        s2 = new nn::spi::CTR::SPI(session[1]) ; 
    
        result = s1->Initialize( nn::spi::CTR::CS2, nn::spi::CTR::BAUDRATE_8MHZ );
        NN_UTIL_PANIC_IF_FAILED(result);
        result = s2->Initialize( nn::spi::CTR::CS3, nn::spi::CTR::BAUDRATE_8MHZ );
        NN_UTIL_PANIC_IF_FAILED(result);
        return;
    }
    
    nn::spi::CTR::SPI *GetSPIpS1()  { return s1; }
    nn::spi::CTR::SPI *GetSPIpS2()  { return s2; }
    nn::Handle  GetSpisession0()  { return session[0]; }
    nn::Handle  GetSpisession1()  { return session[1]; }

private:    
    static nn::spi::CTR::SPI *s1;
    static nn::spi::CTR::SPI *s2;
    static nn::Handle session[2];
    

   
};


extern u8   CheckFIFOWriteAreaA();
extern u8   CheckFIFOWriteAreaB();
extern u8   CheckFIFOReadAreaA();
extern u8   CheckFIFOReadAreaB();
extern bool SpiChAWriteRegister( u8 address, u8 writeData );
extern bool SpiChAWriteRegister_1_64( u8 address, u8 *writeData, u8 write_size );
extern bool SpiChBWriteRegister( u8 address, u8 writeData );
extern bool SpiChABWriteRegister( u8 address, u8 writeData );
extern nn::Result WriteUnit_1_64( nn::spi::CTR::SPI *t, nn::spi::CTR::DeviceID device, u8 command, u8 *sendData, u8 write_size );
extern bool SpiChAReadRegister( u8 address, u8 *readData );
extern bool SpiChAReadRegister_1_64( u8 address, u8 *readData, u8 read_size );
extern bool SpiChAReadRegisterNoCheck( u8 address, u8 *readData );
extern bool SpiChBReadRegister( u8 address, u8 *readData );
extern bool SpiChBReadRegisterNoCheck( u8 address, u8 *readData );
extern bool SpiChABReadRegister( u8 address, u8 *readData );
extern nn::Result ReadUnit_1_64( nn::spi::CTR::SPI *t, nn::spi::CTR::DeviceID device, u8 command, u8 *pReadData, u8 read_size );
extern void ChangeBaudRateA( u8 divisor );
extern void ChangeBaudRateB( u8 divisor );
extern s64  GetMicroSecond( nn::os::Tick start_time );
extern void ChooseBaudRate( sys::GraphicsDrawing* gfx, s32* devisor, nn::hid::CTR::PadReader* padReader, nn::hid::CTR::PadStatus* padStatus, uji::sys::Pad* pad );

extern const char* InsertChangeLine( const char* str, const int changeLine, const int strLength );


} // namespace
}
}

#endif
