/*--------------------------------------------------------------------------*
 Project:
 File: spi_Tool.cpp
 

*--------------------------------------------------------------------------*/



#include <stdlib.h>
#include "spi_Tool.h"

using namespace nn;
using namespace nn::dbg::detail;
using namespace nn::spi;

u32 deviser_5M[14] = {  16667,  // 300
                    4167,   // 1200
                    2083,   // 2400
                    1042,   // 4800
                    521,    // 9600
                    260,    // 19200
                    130,    // 38400
                    87,     // 57600
                    43,     // 115200
                    21,     // 230400
                    10,     // 500000
                    5,      // 1000000
                    2,      // 2500000
                    1   // 5000000
};


char str_deviser_5M[14][10] = 
                    {   "300",
                        "1200",
                        "2400",
                        "4800",
                        "9600",
                        "19200",
                        "38400",
                        "57600",
                        "115200",
                        "230400",
                        "500000",
                        "1000000",
                        "2500000",
                        "5000000"
};




namespace uji {
namespace eva {
namespace spi {


#define  SHIFT_SPI_W_R_BIT      7
#define  SHIFT_SPI_ADDRESS_BIT  3
#define  SHIFT_CH1_BIT          2
#define  SHIFT_CH0_BIT          1

#define SPI_WRITE_BIT           0
#define SPI_READ_BIT            1


nn::spi::CTR::SPI * uji::eva::spi::WriteSpi::s1 = 0;
nn::spi::CTR::SPI * uji::eva::spi::WriteSpi::s2 = 0;
nn::Handle uji::eva::spi::WriteSpi::session[2];


Result ReadUnit_1_64( SPI *t, DeviceID device, u8 command, u8 *pReadData, u8 read_size );
Result WriteUnit_1_64( SPI *t, DeviceID device, u8 command, u8 *sendData, u8 write_size );
s64 GetMicroSecond( nn::os::Tick start_time );



//=================================================================================================================================================
// AhX bit 7:W/R  6-3:addres  2:CH1  1:CH0  0:C
//  W/Rrbg0̂ƂWRITEA1̂ƂREAD  CH1CH0͗0ɂ

// TeraTermɓƂ
//bit32 m_Code  SpiChAWriteRegister( u8 address, u8 writeData )
//=================================================================================================================================================
bool  SpiChAWriteRegister( u8 address, u8 writeData )
{
    int command;

    while(1)
    {
        if( CheckFIFOWriteAreaA() > 0) break;
    }
    
    command = SPI_WRITE_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 0 << SHIFT_CH0_BIT | 0 ;
    nn::spi::CTR::detail::WriteUnit( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, writeData );
    return 1;
}


//=================================================================================================================================================
//=================================================================================================================================================
bool  SpiChAWriteRegister_1_64( u8 address, u8 *writeData, u8 write_size )
{
    int command;

    while(1)
    {
        if( CheckFIFOWriteAreaA() >= write_size ) break;
    }
    
    command = SPI_WRITE_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 0 << SHIFT_CH0_BIT | 0 ;
    WriteUnit_1_64 ( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, writeData, write_size );
    return 1;
}


//=================================================================================================================================================
// V[PTɓƂ
//=================================================================================================================================================
bool  SpiChBWriteRegister( u8 address, u8 writeData )
{
    int command;

    while(1)
    {
        if( CheckFIFOWriteAreaB() > 0) break;
    }

    command = SPI_WRITE_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 1 << SHIFT_CH0_BIT | 0 ;
    nn::spi::CTR::detail::WriteUnit( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, writeData );
    return 1;
}


//=================================================================================================================================================
// ɓƂ
//=================================================================================================================================================
bool  SpiChABWriteRegister( u8 address, u8 writeData )
{
    int command;

    while(1)
    {
        if( CheckFIFOWriteAreaA() > 0) break;
    }

    command = SPI_WRITE_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 0 << SHIFT_CH0_BIT | 0 ;
    nn::spi::CTR::detail::WriteUnit( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, writeData );

    while(1)
    {
        if( CheckFIFOWriteAreaB() > 0) break;
    }

    command = SPI_WRITE_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 1 << SHIFT_CH0_BIT | 0 ;
    nn::spi::CTR::detail::WriteUnit( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, writeData );

    return 1;
}


//=================================================================================================================================================
//=================================================================================================================================================
Result WriteUnit_1_64( SPI *t, DeviceID device, u8 command, u8 *sendData, u8 write_size )
{

    const u32 COMMAND_BUF_SIZE = 4;
    const u32 WRITE_BUF_SIZE   = 64;
    u8 commandBuf[COMMAND_BUF_SIZE];
    u8 writeBuf[WRITE_BUF_SIZE];
    int i;

    commandBuf[0] = command;

    for(i=0;i<write_size;i++)
    {
        writeBuf[i] = *(sendData+i);
    }
    
    
    return t->Write( device, commandBuf, 1, writeBuf, write_size );

}


//=================================================================================================================================================
// TeraTerm󂯂Ƃ
//=================================================================================================================================================
bool  SpiChAReadRegister( u8 address, u8 *readData )
{
    int command; 

    while(1)
    {
        if( CheckFIFOReadAreaA() > 0) break;
    }

    command = SPI_READ_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 0 << SHIFT_CH0_BIT | 0 ;
    nn::spi::CTR::detail::ReadUnit( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, readData );
    
    return 1;
}


//=================================================================================================================================================
//=================================================================================================================================================
bool  SpiChAReadRegister_1_64( u8 address, u8 *readData, u8 read_size )
{
    int command; 

    while(1)
    {
        if( CheckFIFOReadAreaA() > 0) break;
    }

    command = SPI_READ_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 0 << SHIFT_CH0_BIT | 0 ;
    ReadUnit_1_64( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, readData, read_size );
    
    return 1;
}


//=================================================================================================================================================
// CheckFIFOReadAreaAł̃`FbNŃf[^ǂݏo
//=================================================================================================================================================
bool  SpiChAReadRegisterNoCheck( u8 address, u8 *readData )
{
    int command; 

    command = SPI_READ_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 0 << SHIFT_CH0_BIT | 0 ;
    nn::spi::CTR::detail::ReadUnit( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, readData );
    
    return 1;
}


//=================================================================================================================================================
// V[PT󂯂Ƃ
//=================================================================================================================================================
bool  SpiChBReadRegister( u8 address, u8 *readData )
{
    int command; 

    while(1)
    {
        if( CheckFIFOReadAreaB() > 0) break;
    }

    command = SPI_READ_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 1 << SHIFT_CH0_BIT | 0 ;
    nn::spi::CTR::detail::ReadUnit( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, readData );
//  Printf("\n address:%x readData:%x \n", address, *readData);

    return 1;
}


//=================================================================================================================================================
// V[PT󂯂Ƃ
//=================================================================================================================================================
bool  SpiChBReadRegisterNoCheck( u8 address, u8 *readData )
{
    int command; 

    command = SPI_READ_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 1 << SHIFT_CH0_BIT | 0 ;
    nn::spi::CTR::detail::ReadUnit( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, readData );
//  Printf("\n address:%x readData:%x \n", address, *readData);

    return 1;
}


//=================================================================================================================================================
// 󂯂Ƃ
//=================================================================================================================================================
bool  SpiChABReadRegister( u8 address, u8 *readData )
{
    int command; 

    while(1)
    {
        if( CheckFIFOReadAreaA() > 0) break;
    }

    command = SPI_READ_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 0 << SHIFT_CH0_BIT | 0 ;
    nn::spi::CTR::detail::ReadUnit( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, readData );

    while(1)
    {
        if( CheckFIFOReadAreaB() > 0) break;
    }

    command = SPI_READ_BIT << SHIFT_SPI_W_R_BIT | address << SHIFT_SPI_ADDRESS_BIT | 0 << SHIFT_CH1_BIT | 1 << SHIFT_CH0_BIT | 0 ;
    nn::spi::CTR::detail::ReadUnit( WriteSpi().GetSPIpS1(), nn::spi::CTR::CS2, command, readData );

    return 1;
}


//=================================================================================================================================================
//=================================================================================================================================================
Result ReadUnit_1_64( SPI *t, DeviceID device, u8 command, u8 *pReadData, u8 read_size )
{
    const u32 COMMAND_BUF_SIZE = 4;
    const u32 READ_BUF_SIZE    = 64;
    u8 commandBuf[COMMAND_BUF_SIZE];
    u8 readBuf[READ_BUF_SIZE];
    int i;

    commandBuf[0] = command;
          
    Result result = t->Read( device, commandBuf, 1, readBuf, read_size );

    for(i=0;i<read_size;i++)
    {
        *(pReadData+i) = readBuf[i];
    }
    
    return result;
}


//=================================================================================================================================================
// FIFO݉\ȏ󋵂mFA݉\łȂΉ\ɂȂ܂ő҂Ă珑
// ߂lF݉\ȕ\
//=================================================================================================================================================
u8 CheckFIFOWriteAreaA()
{
    u8 readData = 0;
    SpiChAReadRegisterNoCheck( 0x08, &readData );
    return readData;
}


//=================================================================================================================================================
//=================================================================================================================================================
u8 CheckFIFOWriteAreaB()
{
    u8 readData = 0;
    SpiChBReadRegisterNoCheck( 0x08, &readData );
    return readData;
}


//=================================================================================================================================================
// FIFOǂݏo\ȏ󋵂mFAǂݏo\łȂΉ\ɂȂ܂ő҂Ăǂݏo
// ߂lFǂݏo\ȕ\
//=================================================================================================================================================
u8 CheckFIFOReadAreaA()
{
    u8 readData = 0;
    SpiChAReadRegisterNoCheck( 0x09, &readData );
    return readData;
}


//=================================================================================================================================================
//=================================================================================================================================================
u8 CheckFIFOReadAreaB()
{
    u8 readData = 0;
    SpiChBReadRegisterNoCheck( 0x09, &readData );
    return readData;
}


//=================================================================================================================================================
// Baud RateύX֐
// divisor baud rate߂邽߂̐
//=================================================================================================================================================
void ChangeBaudRateA(u8 divisor)
{
    SpiChAWriteRegister( 0x03, 0x80 );
    SpiChAWriteRegister( 0x00, divisor );
    SpiChAWriteRegister( 0x03, 0x03 );
}


//=================================================================================================================================================
//=================================================================================================================================================
void ChangeBaudRateB(u8 divisor)
{
    SpiChBWriteRegister( 0x03, 0x80 );
    SpiChBWriteRegister( 0x00, divisor );
    SpiChBWriteRegister( 0x03, 0x03 );
}










//=================================================================================================================================================
//=================================================================================================================================================
void ChooseBaudRate(sys::GraphicsDrawing* gfx, s32* devisor, nn::hid::CTR::PadReader* padReader, nn::hid::CTR::PadStatus* padStatus, uji::sys::Pad* pad)
{

    gfx->m_DrawFramework->Clear();
    gfx->m_TextWriter.SetCursor(10, 20);
    (void)gfx->m_TextWriter.Printf(" UP/DOWN:    choose Baud Rate \n A:          set Baud Rate \n");
    (void)gfx->m_TextWriter.Printf("\n Baud Rate:%s\n", str_deviser_5M[*devisor]);
    glFlush();
    gfx->m_DrawFramework->SwapBuffers();

    
    while(1)
    {
        // {^ {
        if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_UP))
        {
            // ʐMxύX
            (*devisor)++;
            if(*devisor>13) *devisor = 13;
            gfx->m_DrawFramework->Clear();
            gfx->m_TextWriter.SetCursor(10, 20);
            (void)gfx->m_TextWriter.Printf(" UP/DOWN:    choose Baud Rate \n A:          set Baud Rate \n");
            (void)gfx->m_TextWriter.Printf("\n boud rate:%s \n", str_deviser_5M[*devisor]);
            glFlush();
            gfx->m_DrawFramework->SwapBuffers();
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(500 * 1000 * 1000));
        }
        
        // {^ |
        if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_DOWN))
        {
            (*devisor)--;
            if(*devisor<0)
            {
                *devisor = 0;
            }
            gfx->m_DrawFramework->Clear();
            gfx->m_TextWriter.SetCursor(10, 20);
            (void)gfx->m_TextWriter.Printf(" UP/DOWN:    choose Baud Rate \n A:          set Baud Rate \n");
            (void)gfx->m_TextWriter.Printf("\n boud rate:%s \n", str_deviser_5M[*devisor]);
            glFlush();
            gfx->m_DrawFramework->SwapBuffers();
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(500 * 1000 * 1000));
        }


        // A{^
        // M
        if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_A))
        {
            gfx->m_DrawFramework->Clear();
            gfx->m_TextWriter.SetCursor(10, 20);
            (void)gfx->m_TextWriter.Printf(" UP/DOWN:    decide Baud Rate \n A:          set Baud Rate \n");
            (void)gfx->m_TextWriter.Printf("\n set Baud Rate:%s\n\n waiting command\n", str_deviser_5M[*devisor]);
            glFlush();
            gfx->m_DrawFramework->SwapBuffers();

#ifdef TS_Board
            ChangeBaudRateA(8);
#else
            ChangeBaudRateA(deviser_5M[*devisor]);
#endif

            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(500 * 1000 * 1000));
            break;
        }
        
        // L[͂̊mF
        padReader->ReadLatest(padStatus);
        pad->UpdatePad(*padStatus);
        
    }

}






//=================================================================================================================================================
// 񂩂4̃`FbNTvZ֐
//  
// ߂l `FbNT(4)
//=================================================================================================================================================
u32 CalculateCheckSumFromStr(char *str)
{
    u32 str_num = 0;
    char tmp_str[256] = "";
    int sum_i;
    int i;
    u32 sum = 0;
    
    
    // vZ
    str_num = strlen(str);
    
    
    // `FbNTvZ
    for(sum_i=0;sum_i<str_num;i++)
    {
        tmp_str[i] = str[i];
        sum += tmp_str[i];
        Printf("\n tmp_str[%d]:%c = %d \n", i, tmp_str[i], tmp_str[i]);
    }
    
    Printf("\n sum*%u \n",sum);
    
    return sum;
        

}



#if 0
//=================================================================================================================================================
// response_arg_str X|Xpstr񂪂ɏ
// commang_arg_str  R}hɊi[
// calc_command_sum R}h񂩂vZďo`FbNT
// arg_command_sum  R}hɂĂ`FbNT
//=================================================================================================================================================
void CardTest0101( char *response_arg_str, char *command_arg_str, u32 calc_command_sum, char *arg_command_sum )
{
    // 猟͈͂
    
    // `FbNT
    
    // OK/NG#`FbNT̒lԂ
}

void CardTest0102( char *response_arg_str, char *command_arg_str, u32 calc_command_sum, char *arg_command_sum )
{

}
#endif

/*---------------------------------------------------------------------------
  Desc: Ɏw萔ɉs}܂B 
  
  Args: str         : ϊ镶̃|C^
        changeLine  : sR[hԊu
        strLenght   : ^ꂽ̒
  
  rtns: ϊ̃̕|C^
---------------------------------------------------------------------------*/
const char* InsertChangeLine( const char* str, const int changeLine, const int strLength )
{
    static const u32 MAX_STRING_LENGTH = 1000;     // ϊ㕶̍ő咷
    static char returnChar[ MAX_STRING_LENGTH ];
    
    std::memset( returnChar, 0x00, sizeof( returnChar ));
    
    char* pChar = returnChar;
        
    for( int i = 0; i < strLength; i++ )
    {
        if( i % changeLine == 0 && i > 0 )
        {
            *pChar++ = '\n';
        }
        *pChar++ = *str++;
    }
    
    return returnChar;
}


}   // usingnamespace spi
}   // usingnamespace eva
}   // usingnamespace uji



