/*--------------------------------------------------------------------------*
 Project:
 File: spi_Test.cpp
 
*--------------------------------------------------------------------------*/

#include "spi_Test.h"
#include "../seq/TestResult.h"    
#include <stdlib.h>

using namespace nn::dbg::detail;		// Printfp
using namespace uji::eva::spi;


namespace uji {
namespace eva {
namespace spi {


//=========================================================================================
//  Channel A p̏ݒ
//=========================================================================================
void SetChannelA( void )
{

// 3:LCR  Divisor Latch Enable <- 1
    SpiChAWriteRegister( 0x03, 0x80 );

// 0:DLL baud rate 115200
#ifdef TS_Board
    SpiChAWriteRegister( 0x00, 0x08 );
#else
    SpiChAWriteRegister( 0x00, 0x2B );
#endif

// 1:IER  
    SpiChAWriteRegister( 0x01, 0x00 );

// 3:LCR  
    SpiChAWriteRegister( 0x03, 0xBF );

// 2:EFR  enable enhanced functions <- 1
    SpiChAWriteRegister( 0x02, 0xD0 );

// 3:LCR  
    SpiChAWriteRegister( 0x03, 0x03 );

// 4:MCR IrDA mode enable  <- 0:IrDA mode   TCR and TLR enable <- 0:enable
    SpiChAWriteRegister( 0x04, 0x00 );

// F:EFCR 
    SpiChAWriteRegister( 0x0F, 0x00 );

// 2:FCR TX FIFO reset  RX FIFO reset 
    SpiChAWriteRegister( 0x02, 0x06 );

    SpiChAWriteRegister( 0x02, 0x01 );

    SpiChAWriteRegister( 0x07, 0x88 );

}



//=====================================================================================================================================================================
// V[PT瑗ꂽR}hǂݎ֐(R}hMJn3boĂR}hׂĎ󂯎ĂȂꍇ̓^CAEgƂ݂Ȃăf[^NA)
//=====================================================================================================================================================================
s32 ReceiveCommandFromSeq( sys::GraphicsDrawing* gfx, SpiCommand* seq_command, u8* command_buffer, s64 list_test_time )
{
	s16 read_stack = 0;
	bool arg_num_flag = 0;		// (R}h9`10)mFO0AmF1ɂȂtO
	bool send_start_flag = 0;	// V[PTR}hn߂ĂԂ1ɁAȊO0ɂȂtO
	s32 i;
	nn::os::Tick start_tick;	// Ԍvp
	s64 test_time = 0;			// Ԍvp
	u32 command_num = 0;		// V[PT󂯎R}h̕
	u64 counter = 0;

#ifdef TS_Board
    static uji::sys::WindowManager m_WindowManager;		// j[p̃EChE}l[W
    nn::hid::CTR::PadReader padReader;		// {^͊mp
    nn::hid::CTR::PadStatus padStatus;		// {^͊mp
    uji::sys::Pad pad;						// {^͊mp
	m_WindowManager.UpdatePad(pad);  // pbh
#endif
	
	// ϐȂǂ̏
	InitializeCommandData( seq_command, command_buffer );
		
	while(1)
	{
		counter++;
//if(counter%100 == 0)Printf( "\n Loop %04llu\n", counter );
		// FIFORHRɂf[^ʂmF(0`64ԂĂ)
		read_stack = CheckFIFOReadAreaA();
		command_num += read_stack;

		// ʕ\
		gfx->m_DrawFramework->Clear();
		gfx->m_TextWriter.SetCursor(10, 20);

		if( arg_num_flag == 1 ) (void)gfx->m_TextWriter.Printf(" NOW READ FIFO DATA Ver.0.7.0\n strlen:%d arg_num+10:%d\n", strlen((char*)command_buffer), seq_command->arg_num + 10 );
		else                    (void)gfx->m_TextWriter.Printf(" NOW READ FIFO DATA Ver.0.7.0\n strlen:%d arg_num+10:coming soon\n[%s]\n", strlen((char*)command_buffer),command_buffer );
#ifdef TS_Board
		(void)gfx->m_TextWriter.Printf( "DEBUG MODE\n" );
#else
		(void)gfx->m_TextWriter.Printf( "PRODUCT MODE\n" );
#endif
		(void)gfx->m_TextWriter.Printf( " command_num:%d read_stack:%d \n", command_num, read_stack );
		(void)gfx->m_TextWriter.Printf("\n list_test_time:%lld mS\n", list_test_time );
		glFlush();
		gfx->m_DrawFramework->SwapBuffers();
//		nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(200));

		
		// FIFORHRɃf[^܂Ăꍇ(V[PT瑗ꂽf[^FIFOɂꍇ)
		if( read_stack > 0 )
		{
			Printf( "\n read_stack > 0 \n" );
			// R}h𑗂n߂ۂɃ^CAEgp̎ԌvJn
			if(send_start_flag == 0)
			{	// ԌvJn
				Printf("\n Start \n");
				start_tick = nn::os::Tick::GetSystemCurrent();
				send_start_flag = 1;
			}
			
			// FIFOɗ܂Ăf[^ǂݏo(1`64Byte)
			ReadFIFO( read_stack, command_buffer);


#ifndef TS_Board
			
			// mFĂȂꍇ
			if( arg_num_flag == 0 )
			{
				Printf("\n  arg_num_flag == 0  \n");
				// f[^ʂ10z_ňmF
				if( command_num >= 10 )
				{
					Printf("\n command_num >= 10 \n");
					arg_num_flag = 1;
					
					// seq_command\̂ɃR}hɊւi[
					GetCommandData( seq_command, command_buffer );

					Printf( "\n GetCommandData 2 arg_num:%u \n", seq_command->arg_num);
				}
			}
			
			// mFĂꍇ
			if( arg_num_flag == 1 )
			{
				Printf("\n len:%d  arg_num + 10:%d \n", strlen((char*)command_buffer), (seq_command->arg_num) + 10 );
				if( strlen((char*)command_buffer) == (seq_command->arg_num + 10) ) break;
				else if( strlen((char*)command_buffer) > (seq_command->arg_num + 10) )
				{
					for(i=0;i<strlen((char*)command_buffer)-(seq_command->arg_num + 10);i++)
					{
						command_buffer[(seq_command->arg_num + 10) + i] = 0;
					}
					break;
				}
			}
#endif

			test_time = GetMicroSecond(start_tick);
			// R}h󂯎n߂Ă莞Ԃo߂ꍇ
			if(test_time > COMMAND_TIME_OUT)
			{
				Printf("\n in TimeOut:%lld \n", test_time);
				send_start_flag = 0;
				arg_num_flag = 0;
				// ϐȂǂ̏
				InitializeCommandData( seq_command, command_buffer );
				command_num = 0;
			}

		}
		
		test_time = GetMicroSecond(start_tick);
		// R}h󂯎n߂Ă莞Ԃo߂ꍇ
		if( (send_start_flag == 1) && (test_time > COMMAND_TIME_OUT) )
		{
			Printf("\n out TimeOut:%d \n", test_time);
			send_start_flag = 0;
			arg_num_flag = 0;
			// ϐȂǂ̏
			InitializeCommandData( seq_command, command_buffer );
			command_num = 0;
		}


#ifdef TS_Board
			// L[͂̊mF
			padReader.ReadLatest(&padStatus);
			pad.UpdatePad(padStatus);

			// A{^ꂽꍇ
			if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_A))
			{
				Printf("\n A BUTTON \n");


			
				// mFĂȂꍇ
				if( arg_num_flag == 0 )
				{
					Printf( "\n arg_num_flag == 0 \n" );
					// f[^ʂ10z_ňmF
					if( command_num >= 10 )
					{
						Printf("\n command_num >= 10 \n");
						arg_num_flag = 1;
						
						// seq_command\̂ɃR}hɊւi[
						GetCommandData(  seq_command, command_buffer );
	
						Printf( "\n GetCommandData 2 arg_num:%u \n", seq_command->arg_num);
					}
				}
				
				// mFĂꍇ
				if( arg_num_flag == 1 )
				{
					Printf("\n len:%d  arg_num + 10:%d \n", strlen((char*)command_buffer), (seq_command->arg_num) + 10 );
					if( strlen((char*)command_buffer) == (seq_command->arg_num + 10) ) break;
					else if( strlen((char*)command_buffer) > (seq_command->arg_num + 10) )
					{
						for(i=0;i<strlen((char*)command_buffer)-(seq_command->arg_num + 10);i++)
						{
							command_buffer[(seq_command->arg_num + 10) + i] = 0;
						}
						break;
					}
				}


			}
#endif


		
	}
	
	Printf( "\n ReceiveCommandFromSeq END \n" );

	return 0;

}


//------------------------ReceiveCommandFromSeq̊֐------------------------------

//=========================================================================================
// Responsȅ֐
//=========================================================================================
void InitializeResponseData( SpiResponse* response )
{


	response->sum = 0;
	response->id = 0;
	response->arg_num = 0;
	memset(response->str_check_sum, 0x00, sizeof(response->str_check_sum));
	memset(response->str_id, 0x00, sizeof(response->str_id));
	memset(response->str_arg_num, 0x00, sizeof(response->str_arg_num));
	memset(response->str_arg, 0x00, sizeof(response->str_arg));

}



//=================================================================================================================================================
// V[PTɑ郌X|X擾
//=================================================================================================================================================
s32 GetResponseData( SpiCommand* seq_command, SpiResponse* response, u8* str_response )
{
	s32 i;
	char str_tmp_response[2048*2];				// X|Xi[p


	// X|Xi[̈
	for(i=0;i<2048*2;i++)
	{
		str_response[i] = 0;
		str_tmp_response[i] = 0;
	}

	if(seq_command->id > 0x10000)
	{
		return SEQ_COMMAND_ID_ERROR;
	}
	// R}hID烌X|XID쐬
	response->id = seq_command->id + 0xA000;
//					Printf("\n 0 seq_command->id:%d   \n", seq_command->id);
	if( response->id >= 0x10000 ) response->id = (response->id & 0xFFFF);
	sprintf(response->str_id, "%04X", response->id);
//					Printf("\n 1 seq_command->id:%d   \n", seq_command->id);
//					Printf("\n 1 seq_command->str_id:%s   \n", seq_command->str_id);

	// X|X̒擾
	response->arg_num = strlen(response->str_arg);
	Printf("\n GetResponse 1 response->str_arg:%s   \nstrlen(response->str_arg):%d\n", response->str_arg, strlen(response->str_arg));
		Printf("\n response->arg_num:%X(%d)   \n", response->arg_num, response->arg_num);

	
	// X|X̐𕶎
	sprintf( response->str_arg_num, "%02X", response->arg_num );
	
	// X|X`FbNTȊO̕𕶎
	sprintf( str_tmp_response, "%s%s%s", response->str_id, response->str_arg_num, response->str_arg );

	// X|X`FbNT̍쐬
	i = 0;
	while( str_tmp_response[i] != 0 )
	{
//		Printf( "%d:[%c]=%02X ", i, str_tmp_response[i], str_tmp_response[i] );
		response->sum += str_tmp_response[i];
		i++;
	}

	sprintf( response->str_check_sum, "%04X", response->sum );
	sprintf( (char*)str_response, "%s%s", response->str_check_sum, str_tmp_response );

	
	// ̍Ō
	// CR(A)
	str_response[10 + response->arg_num] = 0x0D;
	// LF(s)
	str_response[10 + response->arg_num + 1] = 0x0A;
	// I
	str_response[10 + response->arg_num + 2] = 0;

	Printf("\n GetResponseData last response->arg_num:%X   \n", response->arg_num);

	return 0;

}

//=================================================================================================================================================
// CTRV[PTɃX|X𑗂
//   gfx
//   response
//   str_response
//=================================================================================================================================================
s32 SendResponseToSeq( SpiResponse* response, u8* str_response )
{
	s32 i;
	u32 send_data_num = 0;
	u8 write_space = 0;						// ݉\FIFŐ󂫗e ő64(PʂByte)
	u8* tmp_str;


	tmp_str = str_response;
	
	// V[PTɑf[^
	send_data_num = 10 + response->arg_num + 2;
	

	while(send_data_num > 0)
	{
		Printf("\n send_data_num:%X   \n", send_data_num);
		Printf("\n str_response:[%s] \n", str_response);
		

		// f[^Mł(FIFŐ󂫂64Byte܂͑\̃f[^TCYȏ)ɂȂ܂ő҂
		do
		{
			write_space = CheckFIFOWriteAreaA();
		} while( (send_data_num > write_space) && (write_space != 64) );
		
		Printf("\n tmp_str:%c \n", tmp_str[0]);
		
		if(send_data_num > 64)
		{
			SpiChAWriteRegister_1_64( 0x00, tmp_str, 64 );
			send_data_num = send_data_num - 64;
			tmp_str = tmp_str + 64;
			
		}
		else
		{
			SpiChAWriteRegister_1_64( 0x00, tmp_str, send_data_num );
			send_data_num = 0;
			break;
		}
		
	}
	
		
	return 0;

}












//=========================================================================================
// Command̏֐
//=========================================================================================
void InitializeCommandData( SpiCommand* seq_command, u8* command_buffer )
{

	seq_command->sum = 0;
	seq_command->id = 0;
	seq_command->arg_num = 0;
	memset(seq_command->str_check_sum, 0x00, sizeof(seq_command->str_check_sum));
	memset(seq_command->str_id, 0x00, sizeof(seq_command->str_id));
	memset(seq_command->str_arg_num, 0x00, sizeof(seq_command->str_arg_num));
	memset(seq_command->str_arg, 0x00, sizeof(seq_command->str_arg));

	memset(command_buffer, 0x00, 2048*2);
}


//=========================================================================================
// FIFOɗ܂Ăf[^(SequencerCTRɑꂽf[^)1`64Byteǂݏo
//=========================================================================================
void ReadFIFO( s16 read_stack, u8* command_buffer)
{
	u8 readData64[64];
	u8 write_space = 0;
	char tmp_str[65];


	memset( readData64, 0x00, sizeof(readData64) );
	memset( tmp_str, 0x00, sizeof(tmp_str) );

	// FIFÕf[^ǂ
	SpiChAReadRegister_1_64( 0x00, readData64, read_stack );
	
	
	// ǂݏoR}hpobt@ɒǉ
	sprintf((char*)tmp_str, "%s", readData64);
	Printf("\n ReadFIFO tmp_str:%s \n", tmp_str);
	strcat((char*)command_buffer,(char*)tmp_str);


// Debugp      Tera Term͂ꂽTera Termɕ\(GR[@\)
#ifdef TS_Board
	// ݃obt@󂭂܂ő҂
	do
	{
		write_space = CheckFIFOWriteAreaA();
		Printf("\n ReadFIFO write_space:%d read_stack:%d", write_space, read_stack);
	} while( read_stack > write_space );

	SpiChAWriteRegister_1_64( 0x00, readData64, read_stack );
#endif



}


//=========================================================================================
// seq_command\̂ɃR}hɊւi[֐
//=========================================================================================
void GetCommandData( SpiCommand*  seq_command, u8* command_buffer )
{
	s32 i;
	s32 ng_flag = 0;
	

	for(i=0;i<4;i++)
	{
		seq_command->str_check_sum[i] = command_buffer[i];
		seq_command->str_id[i] = command_buffer[i+4];
	}
	seq_command->str_check_sum[4] = '\0';
	seq_command->str_id[4] = '\0';
	
	// 4Byte擾 `FbNT (16iɕϊ)
	seq_command->sum = strtol(seq_command->str_check_sum, NULL, 16);
	
	// 4Byte擾 R}hID (16iɕϊ)
	seq_command->id  = strtol(seq_command->str_id, NULL, 16);
	
	// 2Byte擾 
	seq_command->str_arg_num[0] = command_buffer[8];
	seq_command->str_arg_num[1] = command_buffer[9];
	seq_command->str_arg_num[2] = '\0';
	seq_command->arg_num = strtol(seq_command->str_arg_num, NULL, 16);

	
	// R}h̏(̍Ōɂ[\0])
	for(i=0;i<seq_command->arg_num;i++)
	{
		if(command_buffer[i+10]<0 || 127<command_buffer[i+10]) ng_flag = 1;
		if(ng_flag == 1) command_buffer[i+10] = 0;
		seq_command->str_arg[i] = command_buffer[i+10];
	}
	seq_command->str_arg[seq_command->arg_num] = 0;
	
	if(ng_flag == 1) seq_command->arg_num = strlen(seq_command->str_arg);
	
	Printf( "\n GetCommandData arg_num:%u \n", seq_command->arg_num );
	Printf( "\n GetCommandData seq_command->str_arg:%s \n", seq_command->str_arg );



}





#if 0

//#ifdef TS_Board
	seq_command->str_arg_num[0] = 4;
	seq_command->str_arg_num[1] = 0;
		command_buffer[i+10] = i%10;
#endif





























//=========================================================================================
//  @brief        Ԍv֐
//  		vJn_
//  ߂l    start_timeo߂(mS)
//=========================================================================================
s64 GetMicroSecond( nn::os::Tick start_time )
{

    nn::os::Tick currentTick = nn::os::Tick::GetSystemCurrent();
    
    float millisecond = (float)((currentTick - start_time).ToTimeSpan().GetMicroSeconds() / 1000.0);
    
	return millisecond;

}










}   // usingnamespace spi
}   // usingnamespace eva
}   // usingnamespace uji






