/*--------------------------------------------------------------------------*
 Project:
 File: TestSound.h
 

*--------------------------------------------------------------------------*/
#ifndef TESTSOUND_H_INCLUDED
#define TESTSOUND_H_INCLUDED

#include <nn.h>
#include <nn/snd.h>
#include <nn/codec.h>
#include <nn/codec/CTR/codec_HardwareCheck.h>
#include "sys.h"
#include "sys_SoundPlayer.h"
#include "SoundInitializer.h"
#include "../codec/TestCodec.h"
#include "../seq/TestResult.h" 

/*---------------------------------------------------------------------------
  wav t@Cǉꍇ́AWavFileId ɂʏ̂ǉ邱ƁI
---------------------------------------------------------------------------*/
enum WavFileId
{
    LR_SIN_16BIT_1000HZ = 0,
    L_SIN_16BIT_1000HZ,
    R_SIN_16BIT_1000HZ,
    NG_SOUND,
    OK_SOUND,
    LR_SIN_16BIT_100HZ,
    LR_SIN_16BIT_200HZ,
    LR_SIN_16BIT_500HZ,
    LR_SIN_16BIT_4000HZ,
    WAV_FILENUM             // <-gp܂
};
static const char* apFileNames[WAV_FILENUM] =
{
    "rom:/snd/LR_SIN_16bit_1000Hz.wav",
    "rom:/snd/L_SIN_16bit_1000Hz.wav",
    "rom:/snd/R_SIN_16bit_1000Hz.wav",
    "rom:/SoundPlayer/ng.wav",
    "rom:/SoundPlayer/ok.wav",
    "rom:/snd/LR_SIN_16bit_100Hz.wav",
    "rom:/snd/LR_SIN_16bit_200Hz.wav",
    "rom:/snd/LR_SIN_16bit_500Hz.wav",
    "rom:/snd/LR_SIN_16bit_4000Hz.wav",
};
/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/

namespace uji {
namespace eva {
namespace sound {

    /* ----------------------------------------------------------------------
     *   ÓI萔
     * -------------------------------------------------------------------- */
     static const u8 CHANNEL_ALL         = 0x00;
     static const u8 CHANNEL_FRONT_LEFT  = 0x01;
     static const u8 CHANNEL_FRONT_RIGHT = 0x02;
     //static const u8 CHANNEL_REAR_LEFT   = 0x04;
     //static const u8 CHANNEL_REAR_RIGHT  = 0x08;

    /* ----------------------------------------------------------------------
     *   p֐
     * -------------------------------------------------------------------- */
    extern bool TestPlaySoundI2S1(uji::seq::TestResult &result);
    extern bool TestPlaySoundI2S1_NEC(uji::seq::TestResult &result);
    extern bool TestPlaySoundI2S2(uji::seq::TestResult &result);
    extern bool TestPlaySoundI2S2_NEC(uji::seq::TestResult &result);
    extern bool TestOutputSpeakerR(uji::seq::TestResult &result);
    extern bool TestOutputSpeakerL(uji::seq::TestResult &result);
    extern bool TestOutputSpeakerRVolUp(uji::seq::TestResult &result);
    extern bool TestOutputSpeakerLVolUp(uji::seq::TestResult &result);
    extern bool SoundSinPulse3sec(uji::seq::TestResult &result);
    extern bool TestDeleteInstance1(uji::seq::TestResult &result);
    extern bool TestDeleteInstance2(uji::seq::TestResult &result);
    extern bool TestStopSoundI2S1(uji::seq::TestResult &result);
    extern bool TestStopSoundI2S2(uji::seq::TestResult &result);
    extern bool TestWaitJackInsert(uji::seq::TestResult &result);
    extern bool TestWaitJackPullout(uji::seq::TestResult &result);

    extern bool TestBibiriSound(uji::seq::TestResult &result);
    extern bool TestLeftAndRightSpeaker(uji::seq::TestResult &result);
    extern bool TestLeftAndRightSpeakerSin(uji::seq::TestResult &result);
    
    extern void CreateInstance(f32 volume=1.0f, u8 outputChannel=sound::CHANNEL_ALL, bool loopFlag=true);
    extern void DeleteInstance();

    extern void CreateInstanceUsingFileName(char* soundFileName, f32 volume=1.0f, u8 outputChannel=sound::CHANNEL_ALL, bool loopFlag=true);
    extern void DeleteInstanceUsingFileName();
    
    //p
    extern bool TestStartWlAudioSp(void);
    extern bool TestStopWlAudioSp(void);

class TestSound : public codec::TestCodec
{
public: 
    /* ----------------------------------------------------------------------
     *   RXgN^AfXgN^
     * -------------------------------------------------------------------- */
    TestSound() : m_MainBus( 1.0f )
    {}
    virtual ~TestSound(){};
    
    /* ----------------------------------------------------------------------
     *   oϐ
     * -------------------------------------------------------------------- */
    
    /* ----------------------------------------------------------------------
     *   ÓIo֐
     * -------------------------------------------------------------------- */
    static void WrappingThreadSound(void* param);
    
private: 
    /* ----------------------------------------------------------------------
     *   o֐
     * -------------------------------------------------------------------- */
     
    /*
        Xbh֌W
    */
    void ThreadSound();
    void StartThreadSound();
    void StopThreadSound();
    
public: 
    /*
        zWAVt@Co^Ďw̃t@Cǂݍޏꍇ
    */
    void InitializeSound(f32 volume, u8 outputChannel, bool loopFlag);
    void FinalizeSound();
    bool PlaySound(u16 sndId, bool* isPlaying);
    bool StopSound(u16 sndId);
    bool StopSound(u16 sndId, bool* isPlaying);
    bool PlaySoundOnMilliseconds(u16 sndId, s64 milliseconds);
    f64  TurnUpVolume( f64 vol );
    f64  TurnDownVolume( f64 vol );
    
    /*
        t@CĂŒWAVt@Cǂݍ
    */
    void InitializeSoundUsingFileName(char* soundFileName, f32 volume, u8 outputChannel, bool loopFlag);
    void FinalizeSoundUsingFileName();
    bool PlaySoundUsingFileName(bool* isPlaying);
    bool StopSoundUsingFileName();
    bool StopSoundUsingFileName(bool* isPlaying);
    bool PlaySoundUsingFileNameOnMilliseconds(s64 milliseconds);
    
    /*
        ʂ̏
    */
    void SetChannelGain(u8 outputChannel);
    void SetVolume(f32 vol);
    bool PlaySoundI2S1();
    bool PlaySoundI2S1_NEC();
    bool PlaySoundI2S2();
    bool PlaySoundI2S2_NEC();
    bool StopSoundI2S1();
    bool StopSoundI2S2();
    void InitializeCodecHardwareCheck();
    void FinalizeCodecHardwareCheck();
    
    // fobOʊmFp
    void LogPrintfAndUpdateDisplay(sys::InputTextWindow *win, sys::ATTR_TEXT_COLOR color, const char* format, ...);
    
private:
    f32 m_MainBus;
    uji::sys::WindowManager m_WindowManager;
    uji::sys::TextWindow*   m_LogWindow;   // Oo͗p
};


} // namespace sound
} // namespace eva
} // namespace uji

#endif  // TESTSOUND_H_INCLUDED

