/*--------------------------------------------------------------------------*
 Project:
 File: SoundInitializer.h


*--------------------------------------------------------------------------*/
#ifndef __UJI_SOUND_INITIALIZER_H__
#define __UJI_SOUND_INITIALIZER_H__

#include <nn/types.h>
#include <nw/snd.h>


namespace uji {
namespace eva {


/*
    Desc: Evaj[ʂ̃TEh
*/
class SoundInitializer
{
public:
    SoundInitializer(){}
    virtual ~SoundInitializer(){}
   
    /*
        Desc: SDKgpTEh̏
    */
    static void InitSDK()
    {
        if (m_bInitializedSDK)
        {
            return;   
        }
            
        nn::Result result;
        result = nn::dsp::Initialize();
        NN_UTIL_PANIC_IF_FAILED(result);
        
        result = nn::dsp::LoadDefaultComponent();
        NN_UTIL_PANIC_IF_FAILED(result);
        
        result = nn::snd::Initialize();
        NN_UTIL_PANIC_IF_FAILED(result);
        
        m_bInitializedSDK = true;
    }
    
    /*
        Desc: SDKgpTEh̏I
    */    
    static void FinalizeSDK()
    {
        if (!m_bInitializedSDK)
        {
            return;   
        }
        
        nn::Result result;
        result = nn::snd::Finalize();
        NN_UTIL_PANIC_IF_FAILED( result );

        result = nn::dsp::UnloadComponent();
        NN_UTIL_PANIC_IF_FAILED( result );

        nn::dsp::Finalize();
        
        m_bInitializedSDK = false;
    }
    
private:
    static bool m_bInitializedSDK;
};


} // namespace
}

#endif
