﻿/*--------------------------------------------------------------------------*
 Project:
 File: NWSound.h

 NintendoWare SimpleApp.cppを参考に作成しました

*--------------------------------------------------------------------------*/
#ifndef _UJI_NW_SND_DEMO_SIMPLE_APP_H_
#define _UJI_NW_SND_DEMO_SIMPLE_APP_H_

#include "sys.h"    
#include "../seq/TestResult.h"     
#include <nw/snd.h>


namespace uji {
namespace eva {


class NWSoundApp
{
public:
    static void sEvaRun()
    {
        NWSoundApp s;
        s.EvaRun();
    }    
    void EvaRun();
    
    bool PlayAgingSound(seq::TestResult &result);
    bool StopAgingSound(seq::TestResult &result);
    
    void OnUpdate();
    
    void InitializeSDK();
    void FinalizeSDK();
        
private:
    void OnInitialize();
    void OnFinalize();
    void OnDrawUpLCD();
    void OnUpdatePad(const sys::Pad& pad);
    
    void InitializeSoundSystem();

    nw::snd::RomSoundArchive    m_Archive;
    nw::snd::SoundArchivePlayer m_ArchivePlayer;
    nw::snd::SoundDataManager   m_DataManager;
    nw::snd::SoundHeap          m_Heap;
    nw::snd::SoundHandle        m_Handle;

    void* m_pMemoryForSoundSystem;
    void* m_pMemoryForInfoBlock;
    void* m_pMemoryForSoundDataManager;
    void* m_pMemoryForSoundArchivePlayer;
    void* m_pMemoryForSoundHeap;
    void* m_pMemoryForStreamBuffer;
};

namespace agingsnd{
bool StartAgingSound(seq::TestResult &result);
bool StopAgingSound(seq::TestResult &result);
void UpdatePlayer();
}

}
}

#endif /* _UJI_NW_SND_DEMO_SIMPLE_APP_H_ */

