
#include "EvaSound.h"
#include "NWSound.h"
#include "CSound.h"
#include "../mcu/TestMcu.h"

using namespace uji::sys;

namespace uji {
namespace eva {

static uji::eva::sound::TestSound *s_pTs;

/*------------------------------------------------------------------------------
  Desc: ֐
------------------------------------------------------------------------------*/
char* ChangeSoundFrequency( int id )
{
    switch( id )
    {
    case 1:  return "rom:/snd/LR_SIN_16bit_100Hz.wav";
    case 2:  return "rom:/snd/LR_SIN_16bit_200Hz.wav";
    case 3:  return "rom:/snd/LR_SIN_16bit_500Hz.wav";
    case 4:  return "rom:/snd/LR_SIN_16bit_1000Hz.wav";
    case 5:  return "rom:/snd/LR_SIN_16bit_4000Hz.wav";
    }

    return "rom:/snd/LR_SIN_16bit_1000Hz.wav";
}

void UpdateDisplay1()
{
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    sys::Menu::m_WindowManager.Update();
    sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    sys::Menu::m_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}
void UpdateDisplay1(sys::JpegDrawer *jpegDrawer, wchar_t *pass)
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    jpegDrawer->OpenPicture(pass);
    jpegDrawer->DrawPicture(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->SwapBuffers();
}

void UpdateDisplayParallaxBarrier()
{
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    sys::Menu::m_WindowManager.Update();
    sys::Menu::m_WindowManager.UpdatePad(sys::Pad());

    //
    // t

    // tRc[hɂ
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_STEREO);

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->SetColor( 1.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 400.0f, 240.0f );
    gfx->m_DrawFramework->Transfer();

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0_EXT );
    gfx->m_DrawFramework->SetColor( 0.0f, 1.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 400.0f, 240.0f );
    gfx->m_DrawFramework->Transfer();
    gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();

    //
    // t

    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    sys::Menu::m_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

void SetDefaultBackGroundColor( void )
{
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE,
        GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);

    // tʏ탂[hɖ߂
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
}

void JackInsertTestCore(bool snd)
{
    uji::sys::Pad pad;
    bool isInserting = false;
    bool isPlaying   = false;
    bool isArgument  = false;

    do
    {
        pad.UpdatePad();
        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");

        if(snd)
        {
            // IIt
            if(pad.IsButtonDown(Pad::BUTTON_A))
                s_pTs->PlaySound(0, &isPlaying);

            if(isPlaying==false)  Menu::m_SubWindow->Printf("     Sound OFF\n");
            else                  Menu::m_SubWindow->Printf("     Sound ON\n");
        }

        if(pad.IsButtonDown(Pad::BUTTON_X))
        {
            isArgument = (isArgument) ? false : true;
        }

        // ֐̐ؑ
        if(isArgument==false){
            isInserting = nn::snd::GetHeadphoneStatus();
            Menu::m_SubWindow->Printf("     Argument void\n");
        } else {
            nn::dsp::CTR::GetHeadphoneStatus(&isInserting);
            Menu::m_SubWindow->Printf("     Argument bool*\n");
        }

        // wbhzWbN}
        if(isInserting==false)  Menu::m_SubWindow->Printf("     Please Insert HeadphoneJack.\n");
        else                    Menu::m_SubWindow->Printf("     Inserted HeadphoneJack.\n");

        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        if(snd)  Menu::m_SubWindow->Printf("     A : Sound ON/OFF\n");
        Menu::m_SubWindow->Printf("     X : Change Function\n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        UpdateDisplay1();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));

    if(snd)
    {
        s_pTs->StopSound(0, &isPlaying);
    }
}

/*------------------------------------------------------------------------------
  Desc: TEh fobOp
------------------------------------------------------------------------------*/
void EvaSoundDebug1()
{
    uji::sys::Pad pad;
    u32 initializeCount = 0;
    u32 finalizeCount   = 0;
    enum NextMode
    {
        INITIALIZE_SDK = 0,
        FINALIZE_SDK   = 1,
        MODE_NUM       = 2
    };

    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     Initialize: %d\n", initializeCount);
        Menu::m_SubWindow->Printf("     Finalize  : %d\n", finalizeCount  );
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     A : Initialize/Finalize\n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        UpdateDisplay1();

        if(pad.IsButtonRepeat(Pad::BUTTON_A))
        {
            switch( initializeCount - finalizeCount )
            {
            case INITIALIZE_SDK:
                uji::eva::SoundInitializer().InitSDK();
                ++initializeCount;
                break;
            case FINALIZE_SDK:
                uji::eva::SoundInitializer().FinalizeSDK();
                ++finalizeCount;
                break;
            }
        }
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}

void EvaSoundDebug2()
{
    uji::sys::Pad pad;
    u32 createInstanceCount = 0;
    u32 deleteInstanceCount = 0;
    u32 createNInstanceCount = 0;
    u32 deleteNInstanceCount = 0;
    enum NextMode
    {
        CREATEINSTANCE = 0,
        DELETEINSTANCE = 1,
        MODE_NUM       = 2
    };

    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     Create Instance(Array): %d\n", createInstanceCount);
        Menu::m_SubWindow->Printf("     Delete Instance(Array): %d\n", deleteInstanceCount);
        Menu::m_SubWindow->Printf("     Create Instance(FName): %d\n", createNInstanceCount);
        Menu::m_SubWindow->Printf("     Delete Instance(FName): %d\n", deleteNInstanceCount);
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     A : Create/Delete(Array)\n");
        Menu::m_SubWindow->Printf("     X : Create/Delete(FileName)\n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        UpdateDisplay1();

        if(pad.IsButtonRepeat(Pad::BUTTON_A))
        {
            if( createNInstanceCount==deleteNInstanceCount )
            {
                switch( createInstanceCount - deleteInstanceCount )
                {
                case CREATEINSTANCE:
                    sound::CreateInstance();
                    ++createInstanceCount;
                    break;
                case DELETEINSTANCE:
                    sound::DeleteInstance();
                    ++deleteInstanceCount;
                    break;
                }
            }
            else
            {
                Menu::m_SubWindow->Printf("\f");
                Menu::m_SubWindow->Printf(" Now, existing another instance. \n");
                UpdateDisplay1();
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(2000));
            }
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_X))
        {
            if( createInstanceCount==deleteInstanceCount )
            {
                switch( createNInstanceCount - deleteNInstanceCount )
                {
                case CREATEINSTANCE:
                    sound::CreateInstanceUsingFileName("rom:/snd/LR_SIN_16bit_1000Hz.wav");
                    ++createNInstanceCount;
                    break;
                case DELETEINSTANCE:
                    sound::DeleteInstanceUsingFileName();
                    ++deleteNInstanceCount;
                    break;
                }
            }
            else
            {
                Menu::m_SubWindow->Printf("\f");
                Menu::m_SubWindow->Printf(" Now, existing another instance. \n");
                UpdateDisplay1();
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(2000));
            }
        }
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}

void EvaSoundDebug3()
{
    bool isPlaying = false; // TEh~
    u8 sndChannel = sound::CHANNEL_ALL;
    f32 volume = 1.0f;

    uji::sys::Pad pad;

    sound::CreateInstanceUsingFileName("rom:/snd/LR_SIN_16bit_1000Hz.wav", volume, sndChannel);
    s_pTs->PlaySoundUsingFileName(&isPlaying);

    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        if(isPlaying==false)  Menu::m_SubWindow->Printf("     Sound OFF");
        else                  Menu::m_SubWindow->Printf("     Sound ON ");
        switch(sndChannel)
        {
        case sound::CHANNEL_ALL:         Menu::m_SubWindow->Printf("  Speaker LR"); break;
        case sound::CHANNEL_FRONT_RIGHT: Menu::m_SubWindow->Printf("  Speaker R");  break;
        case sound::CHANNEL_FRONT_LEFT:  Menu::m_SubWindow->Printf("  Speaker L");  break;
        }
        Menu::m_SubWindow->Printf("  vol %3.1f\n", volume);

        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     A : Sound ON/OFF\n");
        Menu::m_SubWindow->Printf(" UPPER : Change Speaker LR\n");
        Menu::m_SubWindow->Printf(" RT/LT : Change Speaker R/L\n");
        Menu::m_SubWindow->Printf("   X/Y : Volume Up/Down\n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        UpdateDisplay1();

        if(pad.IsButtonRepeat(Pad::BUTTON_A))
        {
            sound::CreateInstanceUsingFileName("rom:/snd/LR_SIN_16bit_1000Hz.wav", volume, sndChannel);
            s_pTs->PlaySoundUsingFileName(&isPlaying);
        }

        // Ăꍇ́A~߂Ăo̓Xs[J؂ւ
        if(pad.IsButtonRepeat(Pad::BUTTON_UP))
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            sndChannel = sound::CHANNEL_ALL;
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_RIGHT))
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            sndChannel = sound::CHANNEL_FRONT_RIGHT;
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_LEFT))
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            sndChannel = sound::CHANNEL_FRONT_LEFT;
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_X) && volume<2.0f)
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            volume += 0.1f;
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_Y) && volume>0.0f)
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            volume -= 0.1f;
        }

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));

    }while(!pad.IsButtonDown(Pad::BUTTON_B));

    s_pTs->StopSoundUsingFileName(&isPlaying);

    sound::DeleteInstanceUsingFileName();
}

void EvaSoundDebug4()
{
    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     Play Sound 3000ms \n");
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     A : Array\n");
        Menu::m_SubWindow->Printf("     X : FileName\n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        UpdateDisplay1();

        if(pad.IsButtonRepeat(Pad::BUTTON_A))
        {
            sound::CreateInstance();
            s_pTs->PlaySoundOnMilliseconds(0, 3000);
            sound::DeleteInstance();
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_X))
        {
            sound::CreateInstanceUsingFileName
                ("rom:/snd/LR_SIN_16bit_1000Hz.wav");
            s_pTs->PlaySoundUsingFileNameOnMilliseconds(3000);
            sound::DeleteInstanceUsingFileName();
        }

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}

/*
    SDK0.12PEEŊmFAvoid̏ꍇɓ삵ȂB
    uuji::eva::SoundInitializer().InitSDK()vł͂ȂA
    uCreateInstance()vŏƂȂȂB
*/
void EvaSoundDebug5()
{
    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     JackInsert Test \n");
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     A : SoundInitializer()\n");
        Menu::m_SubWindow->Printf("     X : CreateInstance\n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        UpdateDisplay1();

        if(pad.IsButtonRepeat(Pad::BUTTON_A))
        {
            uji::eva::SoundInitializer().InitSDK();
            JackInsertTestCore(false);
#if NN_VERSION_REVISION==22048
            //SDK 0.11 PEE
            uji::eva::SoundInitializer().FinalizeSDK();
#endif
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_X))
        {
            uji::eva::sound::CreateInstance();
            JackInsertTestCore(true);
            uji::eva::sound::DeleteInstance();
        }

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));

}

void EvaSoundDebug6()
{
    bool isPlaying = false; // TEh~
    enum WavFileId sndId;

    uji::sys::Pad pad;

    const bool NONLOOP = false;
    sound::CreateInstance(2.0f, sound::CHANNEL_ALL, NONLOOP);

    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     Playmode : Nonloop \n");
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     A : Initialize\n");
        Menu::m_SubWindow->Printf("     L : OK Sound\n");
        Menu::m_SubWindow->Printf("     R : NG Sound\n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        UpdateDisplay1();

        if(pad.IsButtonRepeat(Pad::BUTTON_A))
        {
            sound::DeleteInstance();
            sound::CreateInstance(2.0f, sound::CHANNEL_ALL, NONLOOP);
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_L))
        {
            sndId = OK_SOUND;
            s_pTs->PlaySound(sndId, &isPlaying);
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_R))
        {
            sndId = NG_SOUND;
            s_pTs->PlaySound(sndId, &isPlaying);
        }

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));

    }while(!pad.IsButtonDown(Pad::BUTTON_B));

    if(isPlaying)
    {
        s_pTs->StopSound(sndId);
    }

    sound::DeleteInstance();
}

void EvaSoundDebug8()
{
    NN_LOG("ARM: CsndSample starts.\n");
    nn::Result result;
    const bool _REPEAT = true;

    uji::sys::Pad pad;
    uji::eva::csnd::CSound* pCsnd = new uji::eva::csnd::CSound;
    enum BcwavFileId soundFileId = LR_SIN_16BIT_1000HZ_PCM16;
    bool isPlaying = false;

    pCsnd->InitializeCSound();
    pCsnd->SetCSound( soundFileId, _REPEAT );
    pCsnd->PlayCSound();
    isPlaying = true;

    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     PLAY: %d, PAUSE: %d\n", isPlaying, !isPlaying);
        switch( soundFileId )
        {
        case LR_SIN_16BIT_1000HZ_PCM16:
        Menu::m_SubWindow->Printf("     LR_SIN_16bit_1000Hz.pcm16.bcwav \n"); break;
        case SSID_SINE:
        Menu::m_SubWindow->Printf("     sin440.pcm16.32k.1.bin          \n"); break;
        case LR_SIN_16BIT_1000HZ_:
        Menu::m_SubWindow->Printf("     LR_SIN_16bit_1000Hz.wav         \n"); break;
        }
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     A : Start/Pause\n");
        Menu::m_SubWindow->Printf("     X : Change\n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        UpdateDisplay1();

        if( pad.IsButtonRepeat(Pad::BUTTON_A) )
        {
            if( isPlaying )
            {
                pCsnd->PauseCSound();
                isPlaying = false;
            }
            else
            {
                pCsnd->PlayCSound();
                isPlaying = true;
            }
        }
        if( pad.IsButtonRepeat(Pad::BUTTON_X) )
        {
            switch( soundFileId )
            {
            case LR_SIN_16BIT_1000HZ_PCM16: soundFileId=SSID_SINE;                 break;
            case SSID_SINE:                 soundFileId=LR_SIN_16BIT_1000HZ_;      break;
            case LR_SIN_16BIT_1000HZ_:      soundFileId=LR_SIN_16BIT_1000HZ_PCM16; break;
            }
            pCsnd->StopCSound();
            pCsnd->SetCSound( soundFileId, _REPEAT );
            pCsnd->PlayCSound();
            isPlaying = true;
        }

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMicroSeconds( 16 ) );
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));

    pCsnd->StopCSound();
    pCsnd->FinalizeCSound();

    delete pCsnd;
    NN_LOG("CsndSample End\n");

}

void EvaSoundDebug9()
{
    typedef enum
    {
        TestPlaySoundI2S2 = 0,
        TestStopSoundI2S2,
        TestPlaySoundI2S1,
        UpdateLCD,
        TestStopSoundI2S1,

        BoardSoundTestModeNum
    }
    BoardSoundTestMode;

    uji::sys::Pad pad;
    int  testMode = 0;
    char testName[50] = "";
    char nextTestName[50] = "";
    bool testResult = false;

    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     CURRENT %s \n", testName);
        Menu::m_SubWindow->Printf("     NEXT    %s \n", nextTestName);
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     A : NextTest\n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        Menu::m_SubWindow->Printf(" - RESULT - \n");
        Menu::m_SubWindow->Printf("     %s\n", (testResult ? "TRUE" : "FALSE"));
        UpdateDisplay1();

        if( testMode == TestStopSoundI2S1 )
        {
            testResult = s_pTs->StopSoundI2S1();
            sound::DeleteInstance();
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1500));
            return;     // I
        }

        if(pad.IsButtonRepeat(Pad::BUTTON_A))
        {
            switch( testMode )
            {
            case TestPlaySoundI2S2:
                sprintf( testName,     "%d: TestPlaySoundI2S2",  testMode );
                sprintf( nextTestName, "%d: TestStopSoundI2S2", testMode+1 );
                testResult = s_pTs->PlaySoundI2S2();
                break;
            case TestStopSoundI2S2:
                sprintf( testName, nextTestName );
                sprintf( nextTestName, "%d: TestPlaySoundI2S1", testMode+1 );
                testResult = s_pTs->StopSoundI2S2();
                break;
            case TestPlaySoundI2S1:
                sprintf( testName, nextTestName );
                sprintf( nextTestName, "%d: TestStopSoundI2S1", testMode+1 );
                sound::CreateInstance(0.5f, sound::CHANNEL_ALL);
                testResult = s_pTs->PlaySoundI2S1();
                break;
            case UpdateLCD:
                sprintf( testName, nextTestName );
                sprintf( nextTestName, "" );
                break;
            }
            ++testMode;
        }

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}

void EvaSoundDebug10()
{
    typedef enum
    {
        TestOutputSpeakerR  = 0,
        TestDeleteInstance2,
        TestOutputSpeakerL,
        TestDeleteInstance1,
        UpdateLCD,
        TestWaitJackInsert,

        InterfaceSoundTestModeNum
    }
    InterfaceSoundTestMode;

    uji::sys::Pad pad;
    int  testMode = 0;
    char testName[50] = "";
    char nextTestName[50] = "";
    bool isPlaying   = false;
    bool IsInserting = false;

    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     CURRENT %s \n", testName);
        Menu::m_SubWindow->Printf("     NEXT    %s \n", nextTestName);
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     A : NextTest\n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        UpdateDisplay1();

        if( testMode == TestWaitJackInsert )
        {
            IsInserting = false;
            uji::eva::SoundInitializer().InitSDK();
            Menu::m_SubWindow->Printf("\n");
            Menu::m_SubWindow->Printf("     Please Insert Jack.\n");
            UpdateDisplay1();
            do
            {
                nn::dsp::CTR::GetHeadphoneStatus(&IsInserting);
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
            }
            while( IsInserting==false );

            Menu::m_SubWindow->Printf("     Wait...\n");
            UpdateDisplay1();
            WaitMilliSeconds(2000);     // ʏ̌ł 500ms

            Menu::m_SubWindow->Printf("     Please Pull out Jack.\n");
            UpdateDisplay1();

            IsInserting = true;
            uji::eva::SoundInitializer().InitSDK();
            do
            {
                nn::dsp::CTR::GetHeadphoneStatus(&IsInserting);
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
            }
            while( IsInserting );
            WaitMilliSeconds(100);
            return;     // I
        }

        if( pad.IsButtonRepeat(Pad::BUTTON_A) )
        {
            switch( testMode )
            {
            case TestOutputSpeakerR:
                sprintf( testName,     "%d: TestOutputSpeakerR",  testMode );
                sprintf( nextTestName, "%d: TestDeleteInstance2", testMode+1 );
                sound::CreateInstance(2.0f, sound::CHANNEL_FRONT_RIGHT);
                isPlaying = false;
                s_pTs->PlaySound(LR_SIN_16BIT_1000HZ, &isPlaying);
                WaitMilliSeconds(100);
                break;
            case TestDeleteInstance2:
                sprintf( testName, nextTestName );
                sprintf( nextTestName, "%d: TestOutputSpeakerL", testMode+1 );
                s_pTs->StopSound(LR_SIN_16BIT_1000HZ);
                sound::DeleteInstance();
                break;
            case TestOutputSpeakerL:
                sprintf( testName, nextTestName );
                sprintf( nextTestName, "%d: TestDeleteInstance1", testMode+1 );
                sound::CreateInstance(2.0f, sound::CHANNEL_FRONT_LEFT);
                isPlaying = false;
                s_pTs->PlaySound(LR_SIN_16BIT_1000HZ, &isPlaying);
                WaitMilliSeconds(100);
                break;
            case TestDeleteInstance1:
                sprintf( testName, nextTestName );
                sprintf( nextTestName, "%d: TestWaitJackInsert", testMode+1 );
                s_pTs->StopSound(LR_SIN_16BIT_1000HZ);
                sound::DeleteInstance();
                break;
            case UpdateLCD:
                sprintf( testName, nextTestName );
                sprintf( nextTestName, "" );
                break;
            }
            ++testMode;
        }

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}

void EvaSoundDebug11()
{
    int count = 0;
    uji::sys::Pad pad;

    uji::eva::csnd::CSound* pCsnd = new uji::eva::csnd::CSound;
    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     COUNT %d \n", count);
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        UpdateDisplay1();

        enum BcwavFileId soundFileId = SSID_SINE;

        pCsnd->InitializeCSound();
        pCsnd->SetCSound( soundFileId, true );
        pCsnd->PlayCSound();

        WaitMilliSeconds(500);

        pCsnd->StopCSound();
        pCsnd->FinalizeCSound();

        ++count;
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
    delete pCsnd;
}

void EvaSoundDebug12()
{
    nn::Result nnResult;
    uji::sys::Pad pad;
    u32 initializeCount = 0;
    u32 finalizeCount   = 0;
    enum NextMode
    {
        INITIALIZE_CSOUND = 0,
        FINALIZE_CSOUND   = 1,
        MODE_NUM          = 2
    };

    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     CSound Initialize: %d\n", initializeCount);
        Menu::m_SubWindow->Printf("            Finalize  : %d\n", finalizeCount  );
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     A : Initialize/Finalize\n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        UpdateDisplay1();

        if(pad.IsButtonRepeat(Pad::BUTTON_A))
        {
            switch( initializeCount - finalizeCount )
            {
            case INITIALIZE_CSOUND:
                nnResult = nn::csnd::init::Initialize();
                NN_UTIL_PANIC_IF_FAILED(nnResult);
                ++initializeCount;
                break;
            case FINALIZE_CSOUND:
                nnResult = nn::csnd::Finalize();
                NN_UTIL_PANIC_IF_FAILED(nnResult);
                ++finalizeCount;
                break;
            }
        }
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}

void EvaSoundDebug13()
{
    bool isPlaying = false; // TEh~
    u8 sndChannel = sound::CHANNEL_ALL;
    f32 volume = 2.0f;

    uji::sys::Pad pad;

    enum SoundFrequencyId
    {
        WAV_100HZ  = 1,
        WAV_200HZ  = 2,
        WAV_500HZ  = 3,
        WAV_1000HZ = 4,
        WAV_4000HZ = 5
    };

    int sndId = WAV_500HZ;

    sound::CreateInstanceUsingFileName(ChangeSoundFrequency(sndId), volume, sndChannel);
    s_pTs->PlaySoundUsingFileName(&isPlaying);

    do
    {
        pad.UpdatePad();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        if(isPlaying==false)  Menu::m_SubWindow->Printf("     STOP ");
        else                  Menu::m_SubWindow->Printf("     START");
        switch(sndId)
        {
        case WAV_100HZ:       Menu::m_SubWindow->Printf(" 100 Hz");  break;
        case WAV_200HZ:       Menu::m_SubWindow->Printf(" 200 Hz");  break;
        case WAV_500HZ:       Menu::m_SubWindow->Printf(" 500 Hz");  break;
        case WAV_1000HZ:      Menu::m_SubWindow->Printf(" 1000Hz");  break;
        case WAV_4000HZ:      Menu::m_SubWindow->Printf(" 4000Hz");  break;
        }
        switch(sndChannel)
        {
        case sound::CHANNEL_ALL:         Menu::m_SubWindow->Printf(" SpeakerLR"); break;
        case sound::CHANNEL_FRONT_RIGHT: Menu::m_SubWindow->Printf(" Speaker R");  break;
        case sound::CHANNEL_FRONT_LEFT:  Menu::m_SubWindow->Printf(" SpeakerL ");  break;
        }
        Menu::m_SubWindow->Printf(" vol%3.1f\n", volume);

        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     A : Start/Stop\n");
        Menu::m_SubWindow->Printf("   X/Y : Change Volume(Up/Down)\n");
        Menu::m_SubWindow->Printf("   R/L : Change Freq(100/200/500/1k/4k)\n");
        Menu::m_SubWindow->Printf(" UPPER : Change Speaker(LR)\n");
        Menu::m_SubWindow->Printf(" RT/LT : Change Speaker(R/L)\n");
        Menu::m_SubWindow->Printf("     B : Exit");
        UpdateDisplayParallaxBarrier();

        if(pad.IsButtonRepeat(Pad::BUTTON_A))
        {
            sound::CreateInstanceUsingFileName(ChangeSoundFrequency(sndId), volume, sndChannel);
            s_pTs->PlaySoundUsingFileName(&isPlaying);
        }

        // Ăꍇ́A~߂Ăo̓Xs[J؂ւ
        if(pad.IsButtonRepeat(Pad::BUTTON_UP))
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            sndChannel = sound::CHANNEL_ALL;
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_RIGHT))
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            sndChannel = sound::CHANNEL_FRONT_RIGHT;
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_LEFT))
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            sndChannel = sound::CHANNEL_FRONT_LEFT;
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_X) && volume<2.0f)
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            volume += 0.1f;
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_Y) && volume>0.0f)
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            volume -= 0.1f;
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_L))
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            sndId += ((sndId==1) ? 4 : -1);
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_R))
        {
            s_pTs->StopSoundUsingFileName(&isPlaying);
            sound::DeleteInstanceUsingFileName();
            sndId = sndId % 5 + 1;
        }

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));

    }while(!pad.IsButtonDown(Pad::BUTTON_B));

    s_pTs->StopSoundUsingFileName(&isPlaying);

    sound::DeleteInstanceUsingFileName();

    SetDefaultBackGroundColor();
}

void EvaSoundDebug14()
{   
    bool done = false;
    bool isPlaying = false; // TEh~
    u8 sndChannel = sound::CHANNEL_FRONT_LEFT;
    f32 volume = 1.0f;
    
    uji::sys::Pad pad;
    
    sound::CreateInstanceUsingFileName("rom:/snd/LR_SIN_16bit_1000Hz.wav", volume, sndChannel);
    s_pTs->PlaySoundUsingFileName(&isPlaying);

    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
    UpdateDisplay1(jpegDrawer, L"rom:/jpeg/left.jpg");

    do
    {
        pad.UpdatePad();
        if( uji::sys::PLATFORM_FTR != uji::sys::GetPlatformType())
        {
            if(pad.IsButtonDown(Pad::BUTTON_A))
            {
                s_pTs->StopSoundUsingFileName(&isPlaying);
                //xCX^XĂĐȂƁAfȂ
                sound::DeleteInstanceUsingFileName();
                if (sndChannel == sound::CHANNEL_FRONT_RIGHT)
                {
                UpdateDisplay1(jpegDrawer, L"rom:/jpeg/left.jpg");
                    sndChannel = sound::CHANNEL_FRONT_LEFT;
                }
                else
                {
                UpdateDisplay1(jpegDrawer, L"rom:/jpeg/right.jpg");
                    sndChannel = sound::CHANNEL_FRONT_RIGHT;
                    done = true;
                }
                sound::CreateInstanceUsingFileName("rom:/snd/LR_SIN_16bit_1000Hz.wav", volume, sndChannel);
                s_pTs->PlaySoundUsingFileName(&isPlaying);
            }
        }else
        {
            if( false == done ) done = true;
        }
        
    }while(!pad.IsButtonDown(Pad::BUTTON_B) || !done);
    
    s_pTs->StopSoundUsingFileName(&isPlaying);
    
    sound::DeleteInstanceUsingFileName();
    jpegDrawer->ClosePicture();
    delete jpegDrawer;
}

/*------------------------------------------------------------------------------
  Desc: TEh]j[
------------------------------------------------------------------------------*/
void OpenSoundMenu()
{
    sys::ClassMenu *m = new sys::ClassMenu( "Sound Evaluation Menu" );

    m->Add( " Debug 1(Initialize/Finalize) ",    EvaSoundDebug1 );
    m->Add( " Debug 2(Create/Delete Instance) ", EvaSoundDebug2 );
    m->Add( " Debug 3(Speaker Test) ",           EvaSoundDebug3 );
    m->Add( " Debug 4(Play Sound 3000ms) ",      EvaSoundDebug4 );
    m->Add( " Debug 5(JackInsert) ",             EvaSoundDebug5 );
    m->Add( " Debug 6(Nonloop Playing) ",        EvaSoundDebug6 );
    m->Add( " Debug 7(NintendoWare) ",           NWSoundApp().sEvaRun );
    m->Add( " Debug 8(System Sound) ",           EvaSoundDebug8 );
    m->Add( " Debug 9(Board Simple Test) ",      EvaSoundDebug9 );
    m->Add( " Debug10(Interface Simple Test) ",  EvaSoundDebug10);
    m->Add( " Debug11(CSound Bug CheckPrg)",     EvaSoundDebug11);
    m->Add( " Debug12(CSound Init/Fin Test)",    EvaSoundDebug12);
    m->Add( " Debug13(3D Mode Speaker Test)",    EvaSoundDebug13);
    m->Open();

    delete m;
}

/*------------------------------------------------------------------------------
  Desc: T[rXZ^[TEh]j[
------------------------------------------------------------------------------*/
void OpenSoundMenuForService()
{
    sys::ClassMenu *m = new sys::ClassMenu( "Sound Evaluation Menu" );

    m->Add( " Speaker Test(LCD&KEY) ", EvaSoundDebug14 );
    m->Open();

    delete m;
}


/*------------------------------------------------------------------------------
  Desc: xEWC̈萫mFŕs莞Ɍxo
------------------------------------------------------------------------------*/
void EvaSoundStability(u16 play_switch)
{
    bool isPlaying = false; // TEh~
    u8 sndChannel = sound::CHANNEL_ALL;
    f32 volume = 8.0f;

    if(play_switch == SAMPLING_SOUND_START)
    {
        sound::CreateInstanceUsingFileName("rom:/snd/LR_SIN_16bit_1000Hz.wav", volume, sndChannel);
    }
    else if(play_switch == SAMPLING_SOUND_ON)
    {
        s_pTs->PlaySoundUsingFileName(&isPlaying);
        uji::eva::mcu::NotifyLedRedOnNoWait();
    }
    else if(play_switch == SAMPLING_SOUND_OFF)
    {
        isPlaying = true;
        s_pTs->PlaySoundUsingFileName(&isPlaying);
        uji::eva::mcu::NotifyLedWhiteOff();
    }
    else if(play_switch == SAMPLING_SOUND_END)
    {
        sound::DeleteInstanceUsingFileName();
        uji::eva::mcu::NotifyLedWhiteOff();
    }
}




} // namespace eva
} // namespace uji

