﻿/*--------------------------------------------------------------------------*
 Project:
 File: CSound.h
 

*--------------------------------------------------------------------------*/
#ifndef CSOUND_H_INCLUDED
#define CSOUND_H_INCLUDED

#include <nn.h>
#include <nn/csnd.h>
#include "sys.h"

// 音源データ領域のシンボル
extern const u8 LR_SIN_16BIT_1000HZ_PCM16_BEGIN[];
extern const u8 LR_SIN_16BIT_1000HZ_PCM16_END[];

extern const u8 SIN440_PCM16_32K_1_BEGIN[];
extern const u8 SIN440_PCM16_32K_1_END[];

extern const u8 LR_SIN_16BIT_1000HZ_BEGIN[];
extern const u8 LR_SIN_16BIT_1000HZ_END[];

// 音源情報
#define LR_SIN_16BIT_1000HZ_PCM16_RATE     44100
#define LR_SIN_16BIT_1000HZ_PCM16_SYMBOL   reinterpret_cast<uptr>(LR_SIN_16BIT_1000HZ_PCM16_BEGIN)
#define LR_SIN_16BIT_1000HZ_PCM16_SIZE     (LR_SIN_16BIT_1000HZ_PCM16_END - LR_SIN_16BIT_1000HZ_PCM16_BEGIN)

#define SINE_PCM16_RATE     32000
#define SINE_PCM16_SYMBOL   reinterpret_cast<uptr>(SIN440_PCM16_32K_1_BEGIN)
#define SINE_PCM16_SIZE     (SIN440_PCM16_32K_1_END - SIN440_PCM16_32K_1_BEGIN)

#define LR_SIN_16BIT_1000HZ_RATE     44100
#define LR_SIN_16BIT_1000HZ_SYMBOL   reinterpret_cast<uptr>(LR_SIN_16BIT_1000HZ_BEGIN)
#define LR_SIN_16BIT_1000HZ_SIZE     (LR_SIN_16BIT_1000HZ_END - LR_SIN_16BIT_1000HZ_BEGIN)

// 音源情報管理構造体
struct SoundInformation
{
    uptr    symbol;
    uptr    address[2];
    size_t  dataSize;
    size_t  bufferSize;
    s32     sampleRate;
    u16     quantumBits;
    u8      channelCount;
    NN_PADDING1;
};

/*---------------------------------------------------------------------------
  ※bcwav ファイルを追加する場合は、BcwavFileId にも通称を追加すること！
---------------------------------------------------------------------------*/
// 音源番号
enum BcwavFileId
{
    LR_SIN_16BIT_1000HZ_PCM16 = 0,
    SSID_SINE,
    LR_SIN_16BIT_1000HZ_,
    BCWAV_FILENUM
};
// 音源配列
static SoundInformation SsAdmin[BCWAV_FILENUM] =
{
    {
        LR_SIN_16BIT_1000HZ_PCM16_SYMBOL,
        {0, 0}, 
        LR_SIN_16BIT_1000HZ_PCM16_SIZE, 
        0, 
        LR_SIN_16BIT_1000HZ_PCM16_RATE, 
        16, 
        2
    },
    
    { 
        SINE_PCM16_SYMBOL,
        {0, 0}, 
        SINE_PCM16_SIZE, 
        0, 
        SINE_PCM16_RATE, 
        16, 
        1
    },
    
    {
        LR_SIN_16BIT_1000HZ_SYMBOL,
        {0, 0}, 
        LR_SIN_16BIT_1000HZ_SIZE, 
        0, 
        LR_SIN_16BIT_1000HZ_RATE, 
        16, 
        2
    },
};
/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/

namespace uji {
namespace eva {
namespace csnd {

class CSound
{
public: 
    /* ----------------------------------------------------------------------
     *   コンストラクタ、デストラクタ
     * -------------------------------------------------------------------- */
    CSound()
    {}
    virtual ~CSound(){};
    
    /* ----------------------------------------------------------------------
     *   メンバ変数
     * -------------------------------------------------------------------- */
    
    /* ----------------------------------------------------------------------
     *   静的メンバ関数
     * -------------------------------------------------------------------- */
    
    /* ----------------------------------------------------------------------
     *   メンバ関数
     * -------------------------------------------------------------------- */
public: 
    /*
    	配列にBCWAVファイルを登録して指定のファイルを読み込む場合
    */
    void InitializeCSound( void );
    void FinalizeCSound( void );
    void SetCSound( enum BcwavFileId id, bool loopFlag );
    bool PlayCSound( void );
    bool StopCSound( void );
    bool PauseCSound( void );
    
private:
    /*
    	共通の処理
    */
    void InitializeSsSource( void );
    void FinalizeSsSource( void );
    void SelectSsSource( enum BcwavFileId id );
    
    
    
};

} // namespace csnd
} // namespace eva
} // namespace uji

#endif  // CSOUND_H_INCLUDED

