﻿
#include "CSound.h"

using namespace uji::sys;

static nn::csnd::DataInfo  s_DataInfo;
static nn::csnd::Channel * s_pChannel;

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/

namespace uji {
namespace eva {
namespace csnd {

//===========================================================================
//===========================================================================
//                    配列でＢＣＷＡＶファイルを指定
//===========================================================================
//===========================================================================
/*---------------------------------------------------------------------------
  Desc: 音源の初期化
---------------------------------------------------------------------------*/
void CSound::InitializeSsSource( void )
{
    for ( s32 ss = 0 ; ss < BCWAV_FILENUM ; ++ss )
    {
        // ステレオの場合は、全体サイズの半分だけ確保する（左右別々のバッファ）。
        size_t size = SsAdmin[ss].dataSize / SsAdmin[ss].channelCount;
        NN_TASSERT_( size );
        NN_TLOG_("ARM: Alloc (@system[%d], size = %d).\n", ss, size);
        for ( s32 index = 0 ; index < SsAdmin[ss].channelCount ; ++index )
        {
            uptr address = reinterpret_cast<uptr>( uji::sys::AllocDeviceMemory(size, 32) );
            NN_TASSERT_( address != NULL );
            NN_TASSERT_( SsAdmin[ss].symbol );
            if ( SsAdmin[ss].channelCount == nn::csnd::CHANNEL_COUNT_MONAURAL )
            {
                ::std::memcpy(reinterpret_cast<void*>(address),
                              reinterpret_cast<void*>(SsAdmin[ss].symbol), size);
            }
            else
            {
                s16 * pDestination = reinterpret_cast<s16*>(address);
                s16 * pSource      = reinterpret_cast<s16*>(SsAdmin[ss].symbol);
                s32 length = size / ( SsAdmin[ss].quantumBits >> 3 );
                NN_TLOG_("ARM: address[%d] = %08x (length=%d).\n", index, address, length);
                pSource += index;
                
                for ( s32 i = 0 ; i < length ; ++i )
                {
                    pDestination[i] = pSource[i << 1];
                }
            }
            nn::csnd::FlushDataCache( address, size );
            SsAdmin[ss].address[index] = address;
        }
        
        // 片バッファのサイズを代入する。
        SsAdmin[ss].bufferSize = size;
    }
}

/*---------------------------------------------------------------------------
  Desc: 音源の終了処理
---------------------------------------------------------------------------*/
void CSound::FinalizeSsSource( void )
{
    for ( s32 ss = 0 ; ss < BCWAV_FILENUM ; ++ss )
    {
        for ( s32 index = 0 ; index < SsAdmin[ss].channelCount ; ++index )
        {
            uji::sys::Free ( reinterpret_cast<void*>( SsAdmin[ss].address[index] ) );
        }
    }
}

/*---------------------------------------------------------------------------
  Desc: 音源の選択
---------------------------------------------------------------------------*/
void CSound::SelectSsSource( enum BcwavFileId id )
{
    s_DataInfo.channelCount = SsAdmin[id].channelCount;
    s_DataInfo.format       = nn::csnd::FORMAT_PCM16;
    s_DataInfo.sampleRate   = SsAdmin[id].sampleRate;
    
    for ( s32 index = 0 ; index < SsAdmin[id].channelCount; ++index )
    {
        s_DataInfo.bufferAddress[index] =
            reinterpret_cast<const void *>(SsAdmin[id].address[index]);
    }
    
    s_DataInfo.bufferLength = SsAdmin[id].bufferSize;
}

/*---------------------------------------------------------------------------
  Desc: サウンド初期化
---------------------------------------------------------------------------*/
void CSound::InitializeCSound( void )
{
    nn::Result result;

    // CSND の初期化処理。
#if NN_VERSION_MINOR == 11
    result = nn::csnd::Initialize();
#else //NN_VERSION_MINOR = 12
    result = nn::csnd::init::Initialize();
#endif
    NN_UTIL_PANIC_IF_FAILED(result);
    
    // 音源の初期化。
    InitializeSsSource();
}

/*---------------------------------------------------------------------------
  Desc: サウンド終了処理
---------------------------------------------------------------------------*/
void CSound::FinalizeCSound( void )
{
    nn::Result result;
    
    // 終了処理
    FinalizeSsSource();
    
    // CSND の終了処理
    result = nn::csnd::Finalize();
    NN_UTIL_PANIC_IF_FAILED(result);
}

/*---------------------------------------------------------------------------
  Desc: サウンド再生準備
---------------------------------------------------------------------------*/
void CSound::SetCSound( enum BcwavFileId id, bool loopFlag )
{
    // 音源を選択。
    SelectSsSource( id );
    
    // 操作オブジェクト取得。
    s_pChannel = nn::csnd::AllocChannel( static_cast<nn::csnd::DropCallback>(NULL), NULL );
    NN_TASSERT_( s_pChannel != NULL );
    
    size_t size    = s_DataInfo.bufferLength;
    uptr   address = reinterpret_cast<uptr>(s_DataInfo.bufferAddress[nn::csnd::CHANNEL_INDEX_LEFT]);
    nn::csnd::LoopType loopType = 
        ( loopFlag ) ? nn::csnd::LOOP_TYPE_REPEAT : nn::csnd::LOOP_TYPE_1SHOT;
    
    // 音源情報を個々に設定（コマンド） 
    s_pChannel->SetFormat                 ( s_DataInfo.format );                            // フォーマット
    s_pChannel->SetLoopType               ( loopType );                                     // 繰り返し
    s_pChannel->SetInitialBufferParameters( reinterpret_cast<const void *>(address), size); // 初期バッファ
    s_pChannel->SetLoopBufferParameters   ( address, size );                                // 繰り返しバッファ
    s_pChannel->SetLinearInterpolationFlag( s_pChannel->LINEAR_INTERPOLATION_ENABLE );      // 線形補間フラグ
    s_pChannel->SetSampleRate             ( s_DataInfo.sampleRate );                        // サンプリング周波数
    s_pChannel->SetVolume                 ( nn::csnd::NN_CSND_VOLUME_MAXIMUM / 2,           // ボリューム
                                            nn::csnd::NN_CSND_VOLUME_MAXIMUM / 2,
                                            nn::csnd::NN_CSND_VOLUME_MINIMUM,
                                            nn::csnd::NN_CSND_VOLUME_MINIMUM );
}

/*---------------------------------------------------------------------------
  Desc: サウンド再生開始
---------------------------------------------------------------------------*/
bool CSound::PlayCSound( void )
{

    s_pChannel->Start(); // 再生開始コマンド
    
    (void)nn::csnd::SendSyncStatusCommand();                    // ステータス取得
    (void)nn::csnd::FlushCommand( nn::csnd::FLAG_NOBLOCK );     // コマンド発行
    (void)nn::csnd::ReceiveCommandReply( nn::csnd::FLAG_BLOCK );// コマンド処理状況確認
    
    return ( s_pChannel->GetStatus().isPlayed ) ? true : false;
}

/*---------------------------------------------------------------------------
  Desc: サウンド再生停止、操作オブジェクトの解放
---------------------------------------------------------------------------*/
bool CSound::StopCSound( void )
{
    s_pChannel->Stop(); // 再生停止コマンド
    
    (void)nn::csnd::SendSyncStatusCommand();                    // ステータス取得
    (void)nn::csnd::FlushCommand( nn::csnd::FLAG_NOBLOCK );     // コマンド発行
    (void)nn::csnd::ReceiveCommandReply( nn::csnd::FLAG_BLOCK );// コマンド処理状況確認
    
    // 解放
    nn::csnd::FreeChannel( s_pChannel );
    
    return ( s_pChannel->GetStatus().isPlayed==false ) ? true : false;
}

/*---------------------------------------------------------------------------
  Desc: サウンド再生一時停止
---------------------------------------------------------------------------*/
bool CSound::PauseCSound( void )
{
    s_pChannel->Pause(); // 再生一時停止コマンド
    
    (void)nn::csnd::SendSyncStatusCommand();                    // ステータス取得
    (void)nn::csnd::FlushCommand( nn::csnd::FLAG_NOBLOCK );     // コマンド発行
    (void)nn::csnd::ReceiveCommandReply( nn::csnd::FLAG_BLOCK );// コマンド処理状況確認
    
    return ( s_pChannel->GetStatus().isPlayed==false ) ? true : false;
}



} // namespace csnd
} // namespace eva
} // namespace uji

