/************************************************************************

 SDJ[hvO

 *************************************************************************/
#include "TestSd.h"
#include "../wireless/CommandUtil.h"
#include "../seq/Reception_board_interface.h"
#include "../seq/Config.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "sys_ShowMessage.h"

#if 1
// SDK 0.11
#include <nn.h>
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include <nn/srv.h>

#endif

namespace uji{
namespace eva{

using namespace uji::sys;
using namespace uji::seq;

void OpenSdMenu()
{
    uji::sys::ClassMenu *m = new uji::sys::ClassMenu( "SD Test Menu" );
    m->Add("Detect",            uji::eva::sd::TestSd::Menu1);
//    m->Add("Insert/Extract",    uji::eva::sd::TestSd::Menu2);
    m->Add("WriteProtect",      uji::eva::sd::TestSd::Menu3);
    m->Add("---------------",   NULL );
    m->Add("Read",              uji::eva::sd::TestSd::Menu4);
    m->Add("Write",             uji::eva::sd::TestSd::Menu5);
    m->Add("Delete",            uji::eva::sd::TestSd::Menu6);
    m->Open();
    delete m;
}

namespace sd
{

// j[p
void TestSd::Menu1(void)
{
    uji::eva::sd::TestSd  *ts = new uji::eva::sd::TestSd();
    uji::seq::TestResult  tr;
    ts->DetectCard(tr);
    delete ts;
}

void TestSd::Menu2(void)
{
    uji::eva::sd::TestSd  *ts = new uji::eva::sd::TestSd();
    ts->InsertExtractMount();
    delete ts;
}

void TestSd::Menu3(void)
{
    uji::eva::sd::TestSd  *ts = new uji::eva::sd::TestSd();
    uji::seq::TestResult  tr;
    ts->GetWriteProtectStatus(tr);
    delete ts;
}

void TestSd::Menu4(void)
{
    uji::eva::sd::TestSd  *ts = new uji::eva::sd::TestSd();
    uji::seq::TestResult  tr;
    ts->ReadTest(tr);
    delete ts;
}

void TestSd::Menu5(void)
{
    uji::eva::sd::TestSd  *ts = new uji::eva::sd::TestSd();
    uji::seq::TestResult  tr;
    ts->WriteTest(tr);
    delete ts;
}

void TestSd::Menu6(void)
{
    uji::eva::sd::TestSd  *ts = new uji::eva::sd::TestSd();
    uji::seq::TestResult  tr;
    ts->DeleteTest(tr);
    delete ts;
}

//------------------------------------------------------------------------------
// /C^tF[X킩Ă΂
//------------------------------------------------------------------------------
// 26-002
bool TestSd::WriteProtect(uji::seq::TestResult &result)
{
    result.m_Result = false;

    nn::fs::Initialize();
    nn::srv::Initialize();

    u8  writeProtectStatus = 3;

    bool bInserted;
//    NN_UTIL_PANIC_IF_FAILED(nn::fs::IsSdmcDetected(&bInserted));
    bInserted = nn::fs::IsSdmcInserted();
    if ( bInserted )
    {
        // CgveNgԎ擾
        bool bWritable;
        bWritable = nn::fs::IsSdmcWritable();

        if ( bWritable )
        {
            writeProtectStatus = 0; //CgveNg
        }
        else
        {
            writeProtectStatus = 1; //CgveNgL
        }

        result.m_Result = true;
    }
    else
    {
        writeProtectStatus = 2; //SDJ[hm
        result.m_Result = false;
    }

    u8 commData[2];
    commData[0] = writeProtectStatus;
    commData[1] = 0x00;
    u8 * ptr = commData;

    g_CommC2T->WriteDpramBinary( ptr, sizeof(commData)); //2oCgPʂő

    return result.m_Result;
}

// 26-003
bool TestSd::IsNotInsertedCard(uji::seq::TestResult &result)
{
    result.m_Result = false;

    nn::fs::Initialize();
    nn::srv::Initialize();

    // }Ԏ擾
    bool bInserted;
    bInserted = nn::fs::IsSdmcInserted();

    if ( bInserted )
    {
        NN_LOG("SD card is Inserted.\n");
        result.m_Result = false; //hĂANG
    }
    else
    {
        NN_LOG("SD card is NOT Inserted.\n");
        result.m_Result = true;
    }

    return result.m_Result;
}


// 26-004
// READ WRITEeXg

// WRITE(1-3), READ(4), DELETE(5)
// 1.SDJ[h /uji/board/ƂtH_Ȃ΍쐬
// 2./uji/boardtH_SDReadWriteTest.txtŃt@C쐬
// 3.̃t@CɎw̃CN^f[^(WRITE TEST)
//    (ݎԎłA1024oCg炢Hj
// 4.CN^f[^ꂽƂmF(READ  TEST)
// 5.̃t@C

bool TestSd::ReadWriteTest(uji::seq::TestResult &result)
{
    result.m_Result = false;

    nn::Result  nnr;
    nn::fs::Directory dir;
    nn::fs::FileInputStream fis;
    void * readDataBuf = NULL;
    nn::fs::FileOutputStream fos;
    void * writeDataBuf = NULL;

    nn::os::Tick tick1, tick2;
    nn::fnd::TimeSpan tspan(0);

    tick1 = nn::os::Tick::GetSystemCurrent();

    // SDJ[h}Eg
    NN_LOG("sdmc archive mount ");
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        return result.m_Result;
    }
    NN_LOG("succeeded.\n");

//
//  1/5 fBNg쐬
//
    //fBNg邩ǂׂ
    nnr = dir.TryInitialize(DIR_SD_SDTEST.c_str());
    if (nnr.IsFailure())
    {
         dir.Finalize();
         NN_LOG("directory(%ls) open failed.\n", DIR_SD_SDTEST.c_str());
         nn::dbg::PrintResult(nnr);

         //fBNgȂ̂ŁAujifBNg쐬B
         NN_LOG(" try create new uji directory ...");
         nnr = nn::fs::TryCreateDirectory(DIR_SD_UJI.c_str());
         if (nnr.IsFailure())
         {
            NN_LOG("failed.\n");
            nn::dbg::PrintResult(nnr);
         }
         else
         {
            NN_LOG("succeeded.\n");
         }

         //sdtestfBNg쐬B
         NN_LOG(" try create new sdtest directory ...");
         nnr = nn::fs::TryCreateDirectory(DIR_SD_SDTEST.c_str());
         if (nnr.IsFailure())
         {
            NN_LOG("failed.\n");
            nn::dbg::PrintResult(nnr);
            goto FIN;
         }
         NN_LOG("succeeded.\n");
    }

//
//  2/5 Write
//
    //t@C쐬
    NN_LOG(" try create new file ...");
    nnr = fos.TryInitialize(PATH_SDTEST.c_str(), true);
    if (nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    NN_LOG("succeeded.\n");

//
//  3/5 Write
//
    //mہif[^Cgpj
    writeDataBuf = uji::sys::Alloc(READWRITE_SIZE);
    if ( NULL == writeDataBuf)
    {
        NN_LOG("memory allocate failed.\n");
        goto FIN;
    }
    memset(writeDataBuf, 0x00, READWRITE_SIZE);

    //CNgf[^Ŗ߂
    u8 * ptr;
    ptr = reinterpret_cast<u8 *>(writeDataBuf);
    for(int i = 0; i < READWRITE_SIZE; i++,ptr++)
    {
        *ptr = (i % 256);
    }

    //f[^
    fos.Write(writeDataBuf,READWRITE_SIZE);
    fos.Finalize();//t@C

//
//  4/5 Read
//
    //mہif[^[hpj
    readDataBuf = uji::sys::Alloc(READWRITE_SIZE);
    if ( NULL == readDataBuf)
    {
        NN_LOG("memory allocate failed.\n");
        goto FIN;
    }
    memset(readDataBuf, 0x00, READWRITE_SIZE);

    //FileInputStream
    NN_LOG(" try initialize  ...");
    nnr = fis.TryInitialize(PATH_SDTEST.c_str());
    if (nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    NN_LOG("succeeded.\n");

    //f[^ǂ
    fis.Read(readDataBuf,READWRITE_SIZE);
    fis.Finalize();//t@C

    //CNgf[^Ă邩mF
    ptr = reinterpret_cast<u8 *>(readDataBuf);
    NN_LOG("\n");
    for(int i = 0; i < READWRITE_SIZE; i++,ptr++)
    {
        if ( *ptr == (i % 256))
        {
            NN_LOG("%02x",*ptr);
        }
        else
        {
            NN_LOG("\nERROR! 0x%04x: value=%02x (!=%02x)\n",i,*ptr, (i%256));
            goto FIN;
        }

        if ( 0  == (i % 32)) NN_LOG("\n");
    }

//
// 5/5 t@C
//
    NN_LOG("try delete file ... ");
    nnr = nn::fs::TryDeleteFile(PATH_SDTEST.c_str());
    if ( nnr.IsFailure() )
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    NN_LOG("succeeded.\n");


    //fBNg
    // uji/sdtest
    NN_LOG("try delete uji/sdtest directory ... ");
    nnr = nn::fs::TryDeleteDirectory(DIR_SD_SDTEST.c_str());
    if (nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    NN_LOG("succeeded.\n");

    // uji
    NN_LOG("try delete uji directory ... ");
    nnr = nn::fs::TryDeleteDirectory(DIR_SD_UJI.c_str());
    if (nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    NN_LOG("succeeded.\n");

//
    tick2 = nn::os::Tick::GetSystemCurrent();
    tspan = (tick2 - tick1).ToTimeSpan();
    s64 timeMSec;
    timeMSec = tspan.GetMilliSeconds();
    NN_LOG("Read succeeded (%lld) msec.\n",timeMSec);

    result.m_Result = true;

FIN:

    // SDJ[h̃A}Eg
    NN_LOG("sdmc archive unmount ");
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
    }
    NN_LOG("succeeded.\n");

    return result.m_Result;
}

// 26-005
// READ WRITEeXg(ujitH_폜Ȃ)

// WRITE(1-3), READ(4), DELETE(5)
// 1.SDJ[h /uji/board/ƂtH_Ȃ΍쐬
// 2./uji/boardtH_SDReadWriteTest.txtŃt@C쐬
// 3.̃t@CɎw̃CN^f[^(WRITE TEST)
//    (ݎԎłA1024oCg炢Hj
// 4.CN^f[^ꂽƂmF(READ  TEST)
// 5.̃t@C

bool TestSd::ReadWriteTestEz(uji::seq::TestResult &result)
{
    //khmdݒȊOł͌ɂnjŕԂB
    Config c;
    if( c.Get().TestMode !=uji::seq::pl::LINE )
    {
        strcpy( result.m_String, "SKIPPED" );
        result.m_Result = true;
        return result.m_Result;
    }


    result.m_Result = false;

    nn::Result  nnr;
    nn::fs::Directory dir;
    nn::fs::FileInputStream fis;
    void * readDataBuf = NULL;
    nn::fs::FileOutputStream fos;
    void * writeDataBuf = NULL;

    nn::os::Tick tick1, tick2;
    nn::fnd::TimeSpan tspan(0);

    tick1 = nn::os::Tick::GetSystemCurrent();

    // SDJ[h}Eg
    NN_LOG("sdmc archive mount ");
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        return result.m_Result;
    }
    NN_LOG("succeeded.\n");

//
//  1/5 fBNg쐬
//
    //fBNg邩ǂׂ
    result.m_Micro = 1;
    nnr = dir.TryInitialize(DIR_SD_SDTEST.c_str());
    if (nnr.IsFailure())
    {
         dir.Finalize();
         NN_LOG("directory(%ls) open failed.\n", DIR_SD_SDTEST.c_str());
         nn::dbg::PrintResult(nnr);

         //fBNgȂ̂ŁAujifBNg쐬B
         NN_LOG(" try create new uji directory ...");
         nnr = nn::fs::TryCreateDirectory(DIR_SD_UJI.c_str());
         if (nnr.IsFailure())
         {
            NN_LOG("failed.\n");
            nn::dbg::PrintResult(nnr);
         }
         else
         {
            NN_LOG("succeeded.\n");
         }

         //sdtestfBNg쐬B
         NN_LOG(" try create new sdtest directory ...");
         nnr = nn::fs::TryCreateDirectory(DIR_SD_SDTEST.c_str());
         if (nnr.IsFailure())
         {
            NN_LOG("failed.\n");
            nn::dbg::PrintResult(nnr);
            goto FIN;
         }
         NN_LOG("succeeded.\n");
    }

//
//  2/5 Write
//
    result.m_Micro = 2;
    //t@C쐬
    NN_LOG(" try create new file ...");
    nnr = fos.TryInitialize(PATH_SDTEST.c_str(), true);
    if (nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    NN_LOG("succeeded.\n");

//
//  3/5 Write
//
    result.m_Micro = 3;
    //mہif[^Cgpj
    writeDataBuf = uji::sys::Alloc(READWRITE_SIZE);
    if ( NULL == writeDataBuf)
    {
        NN_LOG("memory allocate failed.\n");
        goto FIN;
    }
    memset(writeDataBuf, 0x00, READWRITE_SIZE);

    //CNgf[^Ŗ߂
    u8 * ptr;
    ptr = reinterpret_cast<u8 *>(writeDataBuf);
    for(int i = 0; i < READWRITE_SIZE; i++,ptr++)
    {
        *ptr = (i % 256);
    }

    //f[^
    fos.Write(writeDataBuf,READWRITE_SIZE);
    fos.Finalize();//t@C

//
//  4/5 Read
//
    result.m_Micro = 4;
    //mہif[^[hpj
    readDataBuf = uji::sys::Alloc(READWRITE_SIZE);
    if ( NULL == readDataBuf)
    {
        NN_LOG("memory allocate failed.\n");
        goto FIN;
    }
    memset(readDataBuf, 0x00, READWRITE_SIZE);

    //FileInputStream
    NN_LOG(" try initialize  ...");
    nnr = fis.TryInitialize(PATH_SDTEST.c_str());
    if (nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    NN_LOG("succeeded.\n");

    //f[^ǂ
    fis.Read(readDataBuf,READWRITE_SIZE);
    fis.Finalize();//t@C

    //CNgf[^Ă邩mF
    ptr = reinterpret_cast<u8 *>(readDataBuf);
    NN_LOG("\n");
    for(int i = 0; i < READWRITE_SIZE; i++,ptr++)
    {
        if ( *ptr == (i % 256))
        {
            NN_LOG("%02x",*ptr);
        }
        else
        {
            NN_LOG("\nERROR! 0x%04x: value=%02x (!=%02x)\n",i,*ptr, (i%256));
            goto FIN;
        }

        if ( 0  == (i % 32)) NN_LOG("\n");
    }

    tick2 = nn::os::Tick::GetSystemCurrent();
    tspan = (tick2 - tick1).ToTimeSpan();
    s64 timeMSec;
    timeMSec = tspan.GetMilliSeconds();
    NN_LOG("Read succeeded (%lld) msec.\n",timeMSec);

    result.m_Micro  = 0;
    result.m_Result = true;

FIN:

    // SDJ[h̃A}Eg
    NN_LOG("sdmc archive unmount ");
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(nnr);
    }
    NN_LOG("succeeded.\n");

    return result.m_Result;
}

//------------------------------------------------------------------------------
// 蓮s֐
//------------------------------------------------------------------------------

// KɃ|[OāASDJ[h̏Ԃ𔻒肷
// (f[^̃}Eg͍sȂ)
bool TestSd::DetectCard(uji::seq::TestResult &result)
{
    result.m_Result = false;

    nn::Result  nnr;

    uji::sys::TextWindow  tw( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    m_WindowManager.CreateWindow( &tw, NN_GX_DISPLAY0, 0,0);

    tw.Printf("I : SD Inserted, WriteProtect=Off\n");
    tw.Printf("L : SD Inserted, WriteProtect=On\n");
    tw.Printf("R : SD Removed\n");

    tw.Printf("Press B : Return\n");

    nn::fs::Initialize();
    nn::srv::Initialize();

    // }Ԏ擾
    bool bInserted;
    bInserted = nn::fs::IsSdmcInserted();

    u32 charCnt = 0;
    while(1)
    {
        DrawDisplays( NN_GX_DISPLAY0 );
        uji::sys::Pad().UpdatePad();

        bInserted = nn::fs::IsSdmcInserted();
        if (bInserted )
        {
            bool bWritable = false;
            bWritable = nn::fs::IsSdmcWritable();
            if( bWritable == false)
            {
                tw.Printf("L");
            }
            else
            {
                tw.Printf("I");
            }
            result.m_Result = false;
        }
        else
        {
            tw.Printf("R");
            result.m_Result = true;
        }
        charCnt++;

        if( Pad().IsButtonPress( Pad::BUTTON_B ))
        {
            break;
        }

        if ( charCnt > 800)
        {
            tw.Printf("\f");
            charCnt = 0;
        }

        DrawDisplays( NN_GX_DISPLAY0 );
    }

    m_WindowManager.DestroyWindow( &tw);
    tw.Destroy();

    return result.m_Result;
}


// SD̑}Arow񐔎s
bool TestSd::InsertExtractMount()
{
    nn::Result  nnr;

    uji::sys::TextWindow  tw( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );

    m_WindowManager.CreateWindow( &tw, NN_GX_DISPLAY0, 0,0);

    tw.Printf("Insert/Extract Test\n");

    nn::fs::Initialize();
    nn::srv::Initialize();

    // }Cxgo^
    nn::os::LightEvent                      insertEvent(false);
    nn::srv::LightEventNotificationHandler  insertNotificationHandler;
    insertNotificationHandler.Initialize(&insertEvent);
    NN_UTIL_PANIC_IF_FAILED(nn::srv::RegisterNotificationHandler(&insertNotificationHandler, nn::srv::NOTIFICATION_INSERT_INTO_SDMC_SLOT));
    nn::os::LightEvent                      removeEvent(false);
    nn::srv::LightEventNotificationHandler  removeNotificationHandler;
    removeNotificationHandler.Initialize(&removeEvent);
    NN_UTIL_PANIC_IF_FAILED(nn::srv::RegisterNotificationHandler(&removeNotificationHandler, nn::srv::NOTIFICATION_EJECT_FROM_SDMC_SLOT));

    // }Ԏ擾
    bool bInserted;
    bInserted = nn::fs::IsSdmcInserted();

    // Notification Mo^
    NN_UTIL_PANIC_IF_FAILED(nn::srv::Subscribe(nn::srv::NOTIFICATION_INSERT_INTO_SDMC_SLOT));
    NN_UTIL_PANIC_IF_FAILED(nn::srv::Subscribe(nn::srv::NOTIFICATION_EJECT_FROM_SDMC_SLOT));

    int loopMax = 5;
    int loopCnt = 1;
    while(1)
    {
        if ( loopCnt > loopMax )
        {
            break;
        }

        DrawDisplays( NN_GX_DISPLAY0 );
        uji::sys::Pad().UpdatePad();

        if (bInserted)
        {
            // SD J[h A}EgiG[͔Ȃj
            NN_UTIL_PANIC_IF_FAILED(nn::fs::Unmount("sdmc:"));

            tw.Printf("Unmount done. Waiting Extract SD CARD ...");
            DrawDisplays( NN_GX_DISPLAY0 );

            // SD J[h҂
            removeEvent.Wait();
            bInserted = false;
            NN_LOG("R\n");
            tw.Printf("OK\n");
        }
        else
        {
            tw.Printf("Waiting Insert SD CARD ...");
            DrawDisplays( NN_GX_DISPLAY0 );
            // SD J[h}҂
            insertEvent.Wait();
            bInserted = true;
            NN_LOG("I\n");
            tw.Printf("OK\n");

            tw.Printf("Try SD CARD Mount ...");
            DrawDisplays( NN_GX_DISPLAY0 );
            // SD J[h }Egi̊ԂɔꂽAG[j
//            nn::Result result = nn::fs::detail::MountSdmcForDevMenu();
            nn::Result result = nn::fs::MountSdmc();
            if (result.IsSuccess())
            {
                NN_LOG("MountSdmc Success.\n");
                // ȍ~ASD J[h ANZX\
                tw.Printf("Succeeded.\n");
                DrawDisplays( NN_GX_DISPLAY0 );
            }
            else
            {
                // ꂽAFAT Ă邩
                NN_LOG("MountSdmc Failure.\n");
                tw.Printf("Failed.\n");
                DrawDisplays( NN_GX_DISPLAY0 );
            }
        }
        loopCnt++;

        DrawDisplays( NN_GX_DISPLAY0 );
    }

    m_WindowManager.DestroyWindow( &tw);

    tw.Destroy();

    return true;
}

// CgveNgԎ擾
bool TestSd::GetWriteProtectStatus(uji::seq::TestResult &result)
{
    result.m_Result = false;

    uji::sys::TextWindow  tw( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    m_WindowManager.CreateWindow( &tw, NN_GX_DISPLAY0, 0,0);

    nn::fs::Initialize();
    nn::srv::Initialize();

    // CgveNgԎ擾
    bool bWritable;
    bWritable = nn::fs::IsSdmcWritable();

    if ( bWritable )
    {
        tw.Printf("SD card is writable.[true]\n");
        result.m_Result = true;
    }
    else
    {
        tw.Printf("SD card is not writable.[false]\n");
        result.m_Result = false;
    }

    while(1)
    {
        DrawDisplays( NN_GX_DISPLAY0 );
        uji::sys::Pad().UpdatePad();
       if( Pad().IsButtonPress( Pad::BUTTON_B )) break;
    }

    m_WindowManager.DestroyWindow( &tw);
    tw.Destroy();

    return result.m_Result;
}



// Read
bool TestSd::ReadTest(uji::seq::TestResult &result)
{
    nn::Result  nnr;
    result.m_Result = false;
    nn::fs::Directory dir;
    nn::fs::FileInputStream fis;
    void * readDataBuf = NULL;

    nn::os::Tick tick1, tick2;
    nn::fnd::TimeSpan tspan(0);

    tick1 = nn::os::Tick::GetSystemCurrent();

    uji::sys::TextWindow  tw( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    m_WindowManager.CreateWindow( &tw, NN_GX_DISPLAY0, 0,0);

    tw.Printf("* ReadTest *\n");

    nn::fs::Initialize();
    nn::srv::Initialize();

    // SDJ[h}Eg
    tw.Printf("sdmc archive mount ");
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        tw.Printf("failed.\n");
        return false;
    }
    tw.Printf("succeeded.\n");

    //fBNg邩ǂׂ
    nnr = dir.TryInitialize(DIR_SD_SDTEST.c_str());
    if (nnr.IsFailure())
    {
         dir.Finalize();
         tw.Printf("directory(%ls) open failed.\n", DIR_SD_SDTEST.c_str());
         DrawDisplays( NN_GX_DISPLAY0 );
         nn::dbg::PrintResult(nnr);
         goto FIN;
    }

    //mہif[^[hpj
    readDataBuf = uji::sys::Alloc(READWRITE_SIZE);
    if ( NULL == readDataBuf)
    {
        tw.Printf("memory allocate failed.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        goto FIN;
    }
    memset(readDataBuf, 0x00, READWRITE_SIZE);

    //FileInputStream
    tw.Printf(" try initialize  ...");
    DrawDisplays( NN_GX_DISPLAY0 );
    nnr = fis.TryInitialize(PATH_SDTEST.c_str());
    if (nnr.IsFailure())
    {
        tw.Printf("failed.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    tw.Printf("succeeded.\n");
    DrawDisplays( NN_GX_DISPLAY0 );

    //f[^ǂ
    fis.Read(readDataBuf,READWRITE_SIZE);
    fis.Finalize();//t@C

    //CNgf[^Ă邩mF
    u8 * ptr;
    ptr = reinterpret_cast<u8 *>(readDataBuf);
    tw.Printf("\n");
    for(int i = 0; i < READWRITE_SIZE; i++,ptr++)
    {
        if ( *ptr == (i % 256))
        {
            tw.Printf("%02x",*ptr);
        }
        else
        {
            tw.Printf("\nERROR! 0x%04x: value=%02x (!=%02x)\n",i,*ptr, (i%256));
            DrawDisplays( NN_GX_DISPLAY0 );
            goto FIN;
        }

        if ( 0  == (i % 32)) tw.Printf("\n");
//      if ( 0  == (i % 80)) tw.Printf("\f");
    }
    tw.Printf("\n");

    tick2 = nn::os::Tick::GetSystemCurrent();
    tspan = (tick2 - tick1).ToTimeSpan();
    s64 timeMSec;
    timeMSec = tspan.GetMilliSeconds();
    tw.Printf("ReadTest succeeded (%lld) msec.\n",timeMSec);
    DrawDisplays( NN_GX_DISPLAY0 );
    result.m_Result = true;

FIN:
    // SDJ[h̃A}Eg
    tw.Printf("sdmc archive unmount ");
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        tw.Printf("failed.\n");
        nn::dbg::PrintResult(nnr);
    }
    else
    {
        tw.Printf("succeeded.\n");
    }

    while(1)
    {
        DrawDisplays( NN_GX_DISPLAY0 );
        uji::sys::Pad().UpdatePad();
       if( Pad().IsButtonPress( Pad::BUTTON_B )) break;
    }

    m_WindowManager.DestroyWindow( &tw);
    tw.Destroy();

    return result.m_Result;
}

// Write
bool TestSd::WriteTest(uji::seq::TestResult &result)
{
    nn::Result  nnr;
    result.m_Result = false;
    nn::fs::Directory dir;
    nn::fs::FileOutputStream fos;
    void * writeDataBuf = NULL;

    nn::os::Tick tick1, tick2;
    nn::fnd::TimeSpan tspan(0);

    tick1 = nn::os::Tick::GetSystemCurrent();

    uji::sys::TextWindow  tw( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    m_WindowManager.CreateWindow( &tw, NN_GX_DISPLAY0, 0,0);

    tw.Printf("* WriteTest *\n");

    nn::fs::Initialize();
    nn::srv::Initialize();

    // SDJ[h}Eg
    tw.Printf("sdmc archive mount ");
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        tw.Printf("failed.\n");
    }
    tw.Printf("succeeded.\n");

    //fBNg邩ǂׂ
    nnr = dir.TryInitialize(DIR_SD_SDTEST.c_str());
    if (nnr.IsFailure())
    {
         dir.Finalize();
         tw.Printf("directory(%ls) open failed.\n", DIR_SD_SDTEST.c_str());
         DrawDisplays( NN_GX_DISPLAY0 );
         nn::dbg::PrintResult(nnr);

         //fBNgȂ̂ŁAujifBNg쐬B
         tw.Printf(" try create new uji directory ...");
         DrawDisplays( NN_GX_DISPLAY0 );
         nnr = nn::fs::TryCreateDirectory(DIR_SD_UJI.c_str());
         if (nnr.IsFailure())
         {
            tw.Printf("failed.\n");
            DrawDisplays( NN_GX_DISPLAY0 );
            nn::dbg::PrintResult(nnr);
         }
         else
         {
            tw.Printf("succeeded.\n");
            DrawDisplays( NN_GX_DISPLAY0 );
        }

         //fBNgȂ̂ŁAsdtestfBNg쐬B
         tw.Printf(" try create new sdtest directory ...");
         DrawDisplays( NN_GX_DISPLAY0 );
         nnr = nn::fs::TryCreateDirectory(DIR_SD_SDTEST.c_str());
         if (nnr.IsFailure())
         {
            tw.Printf("failed.\n");
            DrawDisplays( NN_GX_DISPLAY0 );
            nn::dbg::PrintResult(nnr);
            goto FIN;
         }
         tw.Printf("succeeded.\n");
         DrawDisplays( NN_GX_DISPLAY0 );
    }

    //t@C쐬
    tw.Printf(" try create new file ...");
    DrawDisplays( NN_GX_DISPLAY0 );
    nnr = fos.TryInitialize(PATH_SDTEST.c_str(), true);
    if (nnr.IsFailure())
    {
        tw.Printf("failed.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    tw.Printf("succeeded.\n");

    //mہif[^Cgpj
    writeDataBuf = uji::sys::Alloc(READWRITE_SIZE);
    if ( NULL == writeDataBuf)
    {
        tw.Printf("memory allocate failed.\n");
        goto FIN;
    }
    memset(writeDataBuf, 0x00, READWRITE_SIZE);

    //CNgf[^Ŗ߂
    u8 * ptr;
    ptr = reinterpret_cast<u8 *>(writeDataBuf);
    for(int i = 0; i < READWRITE_SIZE; i++,ptr++)
    {
        *ptr = (i % 256);
    }

    //f[^
    fos.Write(writeDataBuf,READWRITE_SIZE);
    fos.Finalize();//t@C

    tick2 = nn::os::Tick::GetSystemCurrent();
    tspan = (tick2 - tick1).ToTimeSpan();
    s64 timeMSec;
    timeMSec = tspan.GetMilliSeconds();

    tw.Printf("WriteTest succeeded (%lld) msec.\n",timeMSec);
    DrawDisplays( NN_GX_DISPLAY0 );
    result.m_Result = true;

FIN:
    // SDJ[h̃A}Eg
    tw.Printf("sdmc archive unmount ");
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        tw.Printf("failed.\n");
        nn::dbg::PrintResult(nnr);
    }
    else
    {
        tw.Printf("succeeded.\n");
    }

    while(1)
    {
        DrawDisplays( NN_GX_DISPLAY0 );
        uji::sys::Pad().UpdatePad();
       if( Pad().IsButtonPress( Pad::BUTTON_B )) break;
    }

    m_WindowManager.DestroyWindow( &tw);
    tw.Destroy();

    return result.m_Result;
}

// Delete
bool TestSd::DeleteTest(uji::seq::TestResult &result)
{
    nn::Result  nnr;
    result.m_Result = false;

    nn::os::Tick tick1, tick2;
    nn::fnd::TimeSpan tspan(0);

    tick1 = nn::os::Tick::GetSystemCurrent();

    uji::sys::TextWindow  tw( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    m_WindowManager.CreateWindow( &tw, NN_GX_DISPLAY0, 0,0);

    nn::fs::Initialize();
    nn::srv::Initialize();

    tw.Printf("* DeleteTest *\n");

    // SDJ[h}Eg
    tw.Printf("sdmc archive mount ");
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        tw.Printf("failed.\n");
        return false;
    }
    tw.Printf("succeeded.\n");

    //w̃pX̃t@C폜
    tw.Printf("delete [%ls]...", PATH_SDTEST.c_str());
    nnr = nn::fs::TryDeleteFile(PATH_SDTEST.c_str());
    if (nnr.IsFailure())
    {
        tw.Printf("failed.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    else
    {
        tw.Printf("succeeded.\n");
    }

    //w̃pX̃fBNg폜
    // uji/sdtest
    tw.Printf("delete directory [%ls]...", DIR_SD_SDTEST.c_str());
    nnr = nn::fs::TryDeleteDirectory(DIR_SD_SDTEST.c_str());
    if (nnr.IsFailure())
    {
        tw.Printf("failed.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    else
    {
        tw.Printf("succeeded.\n");
    }

    // uji
    tw.Printf("delete directory [%ls]...", DIR_SD_UJI.c_str());
    nnr = nn::fs::TryDeleteDirectory(DIR_SD_UJI.c_str());
    if (nnr.IsFailure())
    {
        tw.Printf("failed.\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        nn::dbg::PrintResult(nnr);
        goto FIN;
    }
    else
    {
        tw.Printf("succeded.\n");
    }

    tick2 = nn::os::Tick::GetSystemCurrent();
    tspan = (tick2 - tick1).ToTimeSpan();
    s64 timeMSec;
    timeMSec = tspan.GetMilliSeconds();

    tw.Printf("succeeded (%lld)msec.\n",timeMSec);
    result.m_Result = true;

FIN:
    // SDJ[h̃A}Eg
    tw.Printf("sdmc archive unmount ");
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        tw.Printf("failed.\n");
        nn::dbg::PrintResult(nnr);
    }
    else
    {
        tw.Printf("succeeded.\n");
    }

    while(1)
    {
        DrawDisplays( NN_GX_DISPLAY0 );
        uji::sys::Pad().UpdatePad();
       if( Pad().IsButtonPress( Pad::BUTTON_B )) break;
    }

    m_WindowManager.DestroyWindow( &tw);
    tw.Destroy();

    return result.m_Result;
}


//--------------------------------------------------------------------------------------------

// ʕ`
void TestSd::DrawDisplays( s32 display )
{
    m_gfx = uji::sys::GraphicsDrawing::GetInstance();

    if( display == NN_GX_DISPLAY0 || display == NN_GX_DISPLAY_BOTH )
    {
        m_gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        m_gfx->m_DrawFramework->Clear();
        m_WindowManager.Update();
        m_WindowManager.DrawDisplay0();
        m_gfx->m_DrawFramework->SwapBuffers();
    }

    if( display == NN_GX_DISPLAY1 || display == NN_GX_DISPLAY_BOTH )
    {
        m_gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
        m_gfx->m_DrawFramework->Clear();
        m_WindowManager.Update();
        m_WindowManager.DrawDisplay1();
        m_gfx->m_DrawFramework->SwapBuffers();

    }
    m_gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
}

} // namespace sd
} // namespace eva
} // namespace uji
