#ifndef ROM_READTEST_H_
#define ROM_READTEST_H_

#include <vector>
#include <map>
#include <list>
#include <string>
#include <sstream>
#include <iomanip>


#include <nn.h>
#include <nn/os.h>
#include <nn/fnd.h>
#include <nn/hw/ioreg.h>


#include "sys_GraphicsDrawing.h"
#include "sys_WindowManager.h"
#include "sys_Window.h"
#include "sys_MessageLogWindow.h"
#include "sys_TextWindow.h"    
#include "sys_Pad.h"

#include "../seq/TestResult.h"


namespace uji {
namespace eva {
namespace rom {


// WindowNXpVvȃNX
class TestRom : public sys::Window
{
public:
    /*
        RXgN^
        mgr : j[}l[W̃CX^X̃AhX
    */
    TestRom(sys::WindowManager& mgr, s32 width, s32 height)
    : Window("SIMPLE WINDOW", width, height), m_MesgCount(0), m_FrameCount(0),
      m_WindowManager(mgr), m_MessageLogWindow(0), m_TextWindow(0)
    {}
	virtual ~TestRom(){}

    // o͐̃eLXgEChEݒ肵܂
    void SetTextWindow(sys::TextWindow& wnd) { m_TextWindow = &wnd; }
    // o͐̃bZ[WOEChEݒ肵܂
    void SetMessageLogWindow(sys::MessageLogWindow& wnd) { m_MessageLogWindow = &wnd; }  

protected:
    // eI[o[ChƎ̏܂
//    virtual void OnDraw(sys::GraphicsDrawing* gfx);
//    virtual void OnUpdatePad(const sys::Pad& pad);
//    virtual void OnUpdate();

private:
    int m_MesgCount;
    int m_FrameCount;
    
    sys::WindowManager&     m_WindowManager;  
    sys::MessageLogWindow*  m_MessageLogWindow;
    sys::TextWindow*        m_TextWindow;
};

// EChEfNX
class DemoRom
{
public:
	DemoRom()
    :
        m_frameCount(0),
        /*
            eLXgEChE
            1ʂɉ23~c8\\BtHgTCY16B
        */
        m_TextWindow(23, 8, 16),
            
        /*
            bZ[WOEChE
            1ʂɉ20~c10\\B100s̃obt@BtHgTCY14B
            EChEɃtH[JXꍇ́AXN[\B
        */
        m_MessageLogWindow(20, 10, 100, 14),
            
        /* 
            EChEhVvEChE
            TCY200dot~140dotB
        */
        m_TestRom(this->m_WindowManager, 200, 140)
    {}
	virtual ~DemoRom(){}
    
    void Run();
    void ReadSPIFlush();

private:
    int m_frameCount;    

    sys::WindowManager      m_WindowManager;
    sys::TextWindow         m_TextWindow;
    sys::MessageLogWindow   m_MessageLogWindow;
    TestRom            		m_TestRom;
};    

//	extern bool testRom( uji::seq::TestResult &result );			// 
	extern bool LoopReadRom( uji::seq::TestResult &result );			// 

	extern s32 GetRomCheckSum( int block, int rom_size, u32 *checksum );
	extern s32 GetUniqueID( char *str_uniqueID );

}
}
}





#endif
