#include "rom_ReadTest.h"

#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>

#include <nn/hid/CTR/hid_ApiWithPrivilege.h>
#include <nn/hid/CTR/hid_AccelerometerCalibrator.h>
#include "../seq/TesterLog/ProductionLog.h"
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include <nn/fs/CTR/fs_ArchiveTypesForSystem.h>
#include <nn/ctst/ctst_Parameters.h>
#include <nn/ctst/ctst_Api.h>
#include <nn/pxi/CTR/pxi_CardTest9.h>

#include <nn/srv.h>


// 1 sector = 4k Byte
#define DATA_4K 4096
#define DATA_1M 1024*1024

using namespace  nn::ctst::CTR;



static void PrepareCard(nn::fs::FileInputStream* file);
static void PrepareScreen(uji::sys::GraphicsDrawing* gfx, uji::sys::Pad* pad);
static u32 ReadRom_PushA(nn::fs::FileInputStream* file, u32 start_page, u32 read_size);
static void ReadRom_PushX(uji::sys::GraphicsDrawing* gfx);
static void ReadRom_PushY(uji::sys::GraphicsDrawing* gfx);
static s64 GetMicroSecond( nn::os::Tick start_time );
static bool GetCardSize(u32 id1, u32* gCardMaxSize);
//static s32 GetRomCheckSum( char *str_uniqueID );


bool initialize_card_flag = 0;


namespace uji {
namespace eva {
namespace rom {







void  DemoRom::Run(void)
{
    uji::seq::TestResult result_check;

    uji::eva::rom::LoopReadRom(result_check);

//  uji::eva::testRom(result_check);
}





// ROMǂݏo
bool LoopReadRom(uji::seq::TestResult &result)
{



    // J[\ʒup
    uji::sys::Point cursorPos;

    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;

    u8 first_flag = 1;
    bool x = 0;
    s64 gCardMaxSize;
    u32 start_page = 0;
    u32 read_page_size = 1;
    u32 moji = 0;
    u32 calc_check_sum;
    nn::fs::FileInputStream file;
    u32 block = 0;
    char str_id[65];

    // Ԍvp
    nn::os::Tick start_tick;
    s64 test_time = 0;

    uji::sys::GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX܂
//  m_WindowManager.SetAlpha(196);


    do
    {

        // ------------------------------------\------------------------------------

        PrepareScreen(gfx, &pad);
        (void)gfx->m_TextWriter.Printf( "\n start_page:%d  read_page_size:%d moji:%d\n\n\n", start_page, read_page_size, moji );

        // j[ŏ͏Lʂɕ\邽߁ALs
        if( first_flag == 1)
        {
            glFlush();
            gfx->m_DrawFramework->SwapBuffers();
            first_flag = 0;
        }
        // ------------------------------------\ ܂------------------------------------

        while(  !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) )
        {

            gfx->m_DrawFramework->Clear();
            gfx->m_TextWriter.SetCursor(10, 20);
            (void)gfx->m_TextWriter.Printf("\n READ ROM block:%d  SUM:%X\n          time :%d mS\n", block, moji, test_time);
            glFlush();
            gfx->m_DrawFramework->SwapBuffers();


            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            // {^ |
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_DOWN))
            {
                block--;
                moji = 0;
                if(block<0) block = 0;
                (void)gfx->m_TextWriter.Printf( "\n block:%d \n", block );
                break;
            }

            // {^ {
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_UP))
            {
                block++;
                moji = 0;
                (void)gfx->m_TextWriter.Printf( "\n block:%d \n", block );
                break;
            }

            // 
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_LEFT))
            {
                read_page_size--;
                (void)gfx->m_TextWriter.Printf( "\n read_page_size:%d \n", read_page_size );
                break;
            }

            // E
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_RIGHT))
            {
                read_page_size++;
                (void)gfx->m_TextWriter.Printf( "\n read_page_size:%d \n", read_page_size );
                break;
            }

            // A{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_A))
            {
                (void)gfx->m_TextWriter.Printf("\n START %X\n");
                // ԌvJn
                start_tick = nn::os::Tick::GetSystemCurrent();

                GetRomCheckSum(block, 4, &moji);
            //  GetRomCheckSum(str_id);

//              calc_check_sum = ReadRom_PushA(&file, start_page, DATA_1M);

                test_time = GetMicroSecond(start_tick);
                NN_LOG(" test_time:%lld mS \n check sum:%X\n", test_time, moji);

                break;
            }

            // B{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B))
            {
                //moji++;
//              (void)gfx->m_TextWriter.Printf( "\n moji:%d \n", moji );
                GetUniqueID(str_id);
                (void)gfx->m_TextWriter.Printf( "\n GetUniqueID:%s \n", str_id );
                NN_LOG("\n B \n");
                NN_LOG("\n GetUniqueID:%s \n", str_id );
                break;
            }

            // X{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_X))
            {
                ReadRom_PushX(gfx);
                break;
            }

            // Y{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_Y))
            {
                ReadRom_PushY(gfx);
                break;
            }

        };

        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        // Sleep
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(200 * 1000 * 1000));

    // R{^B{^𓯎ꂽꍇ͌rłj[ɖ߂
    }while(  !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) );

    NN_LOG("end...\n");



    result.m_Result = true;
    return result.m_Result;


}





//=================================================================================================================================================
// 0101  ROM̃`FbNT擾
// 1Gbit = 128MBytemF (̈1MBybe~128ӏ 4Gbit̏ꍇ case1:0`1MBybe,4`5MBybec  case2:1`2MBybe,5`6MBybec )
//  block      ubN
//  rom_size  J[h̗e
//  checksum   f[^̃`FbNT
//
//=================================================================================================================================================
s32 GetRomCheckSum( int block, int rom_size, u32 *checksum )
{
//  u8 apMemory[8*1024];
    u32 read_size = 512 * 2 * 1024;
    DetailInfo  detailInfo;
    SettingInfo setting;
    int i;
    int k;
    u32 id1;
    u8  uid[8];
    u32         gCardMaxSize;
    int place_8 = 0;
    u64 tmp_sum = 0;
    u32 check_sum = 0;
    u32 read_32 = 0;
    u32 card_Gbit_size = 0;
    // Ԍvp
    nn::os::Tick start_tick;
    s64 test_time = 0;
    uji::sys::Pad pad;
    u32*        card_test_buffer;
#if 0
    //j[p̃EChE}l[W
    static uji::sys::WindowManager m_WindowManager;
    uji::sys::GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();
    PrepareScreen(gfx, &pad);

    gfx->m_DrawFramework->Clear();
    (void)gfx->m_TextWriter.Printf( " ROM CHECK START\n" );

    glFlush();
    gfx->m_DrawFramework->SwapBuffers();
#endif

    // ԌvJn
    start_tick = nn::os::Tick::GetSystemCurrent();

    u8* apMemory;
    apMemory = reinterpret_cast<u8*>(uji::sys::AllocDeviceMemory(read_size, 32));
    if (apMemory == NULL)
    {
        NN_LOG("Failed to allocate continuous memory\n");
//NG̏邱ƁB
    }

#if 0
    NN_LOG("\n WaitButton 1\n");
    while(1)
    {
        uji::sys::Pad().UpdatePad();
        if( uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_A ))
        {
            NN_LOG("Button_A\n");
            break;
        }
    }
#endif
//  test_time = GetMicroSecond(start_tick);
//  NN_LOG("1 test_time:%lld mS\n", test_time);

    // J[h}ɕKvȏ
    nn::fs::ActivateCardDevice();

//  test_time = GetMicroSecond(start_tick);
//  NN_LOG("2 test_time:%lld mS\n", test_time);

    if(initialize_card_flag == 0)
    {
        //ctst(CardTest)Cu
        NN_UTIL_PANIC_IF_FAILED(Initialize());
        initialize_card_flag = 1;
//      nn::os::SetDeviceMemorySize(2048*512);
//      card_test_buffer = nn::os::GetDeviceMemoryAddress();
    }

    //CardhCo
    NN_UTIL_PANIC_IF_FAILED(FunctionTestStart((u8*)apMemory, read_size, TID_FUNC_INITIALIZE, &detailInfo));
    NN_LOG("\nOK/NG :%d  false%d", detailInfo.mReadSpeed, false );

    //[ID1擾]
    SettingMenu( (SettingId)TID_FUNC_RDID1, setting );
    NN_UTIL_PANIC_IF_FAILED(FunctionTestStart((u8*)apMemory, read_size, TID_FUNC_RDID1, &detailInfo));
    //detail.mID1ID1B
    //˂ȂA܂A܂QłAG[ꍇdetailInfo.mReadSpeedfalse܂B
    id1 = detailInfo.mID1;
    NN_LOG("\n 01 detailInfo.mID1[%X]\n", detailInfo.mID1);
//  test_time = GetMicroSecond(start_tick);
    NN_LOG("OK/NG :%d", detailInfo.mReadSpeed );
//  (void)gfx->m_TextWriter.Printf(" detailInfo.mID1[%X]  time:%lld mS\n", detailInfo.mID1, test_time );
//  glFlush();
//  gfx->m_DrawFramework->SwapBuffers();

    //[ID2擾]
    NN_UTIL_PANIC_IF_FAILED(SettingMenu( (SettingId)TID_FUNC_RDID2, setting ));
    NN_UTIL_PANIC_IF_FAILED(FunctionTestStart((u8*)apMemory, read_size, TID_FUNC_RDID2, &detailInfo));
    //detail.mID2ID2B
    //˂ȂA܂A܂QłAG[ꍇdetailInfo.mReadSpeedfalse܂B
    NN_LOG("\n 02 detailInfo.mID1[%X]\n", detailInfo.mID1);
    NN_LOG("\n 03 detailInfo.mID2[%X]\n", detailInfo.mID2);
    NN_LOG("OK/NG :%d", detailInfo.mReadSpeed );
//  test_time = GetMicroSecond(start_tick);
//  (void)gfx->m_TextWriter.Printf(" detailInfo.mID2[%X]  time:%lld mS\n", detailInfo.mID2, test_time );
//  glFlush();
//  gfx->m_DrawFramework->SwapBuffers();


    //[UID(j[NID)擾]
    NN_UTIL_PANIC_IF_FAILED(SettingMenu( (SettingId)TID_RD_UID, setting ));
    NN_UTIL_PANIC_IF_FAILED(FunctionTestStart((u8*)apMemory, read_size, TID_RD_UID, &detailInfo));
    //(u8*)apMemory̐擪64ByteQ
    //˂ȂA܂A܂QłAG[ꍇdetailInfo.mReadSpeedfalse܂B
    NN_LOG("\n 04 detailInfo.mID1[%X]\n", detailInfo.mID1);
    NN_LOG("\n 05 detailInfo.mID2[%X]\n", detailInfo.mID2);
    NN_LOG("OK/NG :%d", detailInfo.mReadSpeed );
    NN_LOG("\n 06 read_size:%d UID:[%02X][%02X][%02X][%02X][%02X][%02X][%02X][%02X]\n",read_size, detailInfo.mUID[0], detailInfo.mUID[1], detailInfo.mUID[2], detailInfo.mUID[3], detailInfo.mUID[4], detailInfo.mUID[5], detailInfo.mUID[6], detailInfo.mUID[7] );
    NN_LOG("\n 06 read_size:%d UID:%02u%02u%02u%02u%02u%02u%02u%02u\n",read_size, detailInfo.mUID[0], detailInfo.mUID[1], detailInfo.mUID[2], detailInfo.mUID[3], detailInfo.mUID[4], detailInfo.mUID[5], detailInfo.mUID[6], detailInfo.mUID[7] );
//  test_time = GetMicroSecond(start_tick);
//  (void)gfx->m_TextWriter.Printf(" UID[%02X%02X%02X%02X%02X%02X%02X%02X]  time:%lld mS\n", detailInfo.mUID[0], detailInfo.mUID[1], detailInfo.mUID[2], detailInfo.mUID[3], detailInfo.mUID[4], detailInfo.mUID[5], detailInfo.mUID[6], detailInfo.mUID[7], test_time );
//  glFlush();
//  gfx->m_DrawFramework->SwapBuffers();


    // wb_[J[hTCYǂݏo
    // J[hTCYmF֐Ŏ擾TCYƁAwb_[擾TCYł邱ƂmF

    //[ROMZN^TCY擾](gCardMaxSizeɂ̓y[W)
    GetCardSize(id1, &gCardMaxSize);

    // J[h̗eʂGBitPʂɒu
    card_Gbit_size = (gCardMaxSize*8)/(2*DATA_1M);

#if 0
    if( card_Gbit_size < rom_size ){
        uji::sys::Free(apMemory);
        checksum = 0x9999;
        return 0x9999;
    }
#endif

    //gCardMaxSizeɍőZN^TCYB
    NN_LOG("\n 07 gCardMaxSize:%u\n", gCardMaxSize);
    NN_LOG("\n card_Gbit_size:%u\n", card_Gbit_size);
    // eʂ
    card_Gbit_size = rom_size;
    NN_LOG("\n card_Gbit_size2:%u\n", card_Gbit_size);


    NN_LOG("\n block:%u Read Rom\n", block);
    tmp_sum = 0;
    for(i=0;i<128;i++)
    {
        // f[^ǂݏoAhXݒ(y[WwȂ̂512ByteŊ̂YȂ)
        // (1`128)*card_Gbit_size + block
        setting.StartAddress = ( (card_Gbit_size*i + block) * DATA_1M ) / 512;

//  NN_LOG("\n Byte:%u\n i:%d g:%d %d\n", (card_Gbit_size*i + block), i, card_Gbit_size, DATA_1M );

//  NN_LOG("\n StartAddress:%llu(0x%x)\n", setting.StartAddress, setting.StartAddress);

        // Reserved Area(8-31y[W)͓ǂݏoȂ̂ŁA0`1MByteǂޏꍇ͂̕
        if(setting.StartAddress == 0)
        {
            // 0-7y[Wǂ
            setting.size = 8;
            setting.StartAddress = 0;
            NN_UTIL_PANIC_IF_FAILED(SettingMenu(TID_FUNC_TEST1, setting));
            NN_UTIL_PANIC_IF_FAILED(FunctionTestStart((u8*)apMemory, (setting.size*512), TID_FUNC_RDSEQ_WITH_VERIFY, &detailInfo));


            for(k=0;k<(setting.size*512);k++)
            {
//              NN_LOG("[%02X]", apMemory[k]);
                place_8 = 3 - (k % 4);
                read_32 += ( (apMemory[k]) * (1 << (8*place_8)) ) ;
                if( k % 4 == 3 )
                {
                    tmp_sum = tmp_sum + read_32;
                    //NN_LOG("[%08X]\n tmp_sum:%16llX\n", read_32, tmp_sum);
                    read_32 = 0;
                }
            }

            // 1MByte (2048y[W) - 16KByte(32y[W)
            setting.size = DATA_1M/512 - 32;
            setting.StartAddress = 32;
            NN_UTIL_PANIC_IF_FAILED(SettingMenu(TID_FUNC_TEST1, setting));
            NN_UTIL_PANIC_IF_FAILED(FunctionTestStart((u8*)apMemory, (setting.size*512), TID_FUNC_RDSEQ_WITH_VERIFY, &detailInfo));

            for(k=0;k<(setting.size*512);k++)
            {
//              NN_LOG("[%02X]", apMemory[k]);
                place_8 = 3 - (k % 4);
                read_32 += ( (apMemory[k]) * (1 << (8*place_8)) ) ;
                if( k % 4 == 3 )
                {
                    tmp_sum = tmp_sum + read_32;
                    //NN_LOG("[%08X]\n tmp_sum:%16llX\n", read_32, tmp_sum);
                    read_32 = 0;
                }
            }

        }
        else
        {

    // ԌvJn
//  start_tick = nn::os::Tick::GetSystemCurrent();
            //[ROMCӃZN^ǂݏo]
            setting.size = read_size/512;/* 1-2048w\ */
        //  setting.StartAddress = 0;/* 0-(gCardMaxSize - 1)͈̔͂Ŏw\  ۂ̃AhXStartAddress*512Byte*/
            NN_UTIL_PANIC_IF_FAILED(SettingMenu(TID_FUNC_TEST1, setting));

            NN_UTIL_PANIC_IF_FAILED(FunctionTestStart((u8*)apMemory, read_size, TID_FUNC_RDSEQ_WITH_VERIFY, &detailInfo));
            //(u8*)apMemory̐擪foCXXybN2048ZN^*512oCg(@1ZN^)܂Ŏ擾\B
            //˂ȂA܂A܂QłAG[ꍇdetailInfo.mReadSpeedfalse܂B
//  test_time = GetMicroSecond(start_tick);
//  NN_LOG(" test_time:%lld mS \n", test_time);

    #if 0
            for(i=0;i<read_size;i++)
            {
                if(i%16==0)NN_LOG("\n[%04X]", i);
                if(apMemory[i] != 0)NN_LOG("%02X", apMemory[i]);
            }
    #endif
//          NN_LOG("page[*512]:%llX\n", setting.StartAddress);

            for(k=0;k<DATA_1M;k++)
            {
//              NN_LOG("[%02X]", apMemory[k]);
//              place_8 = 3 - (k % 4);
//              read_32 += ( (apMemory[k]) * (1 << (8*place_8)) ) ;
                read_32 += ( (apMemory[k]) * (1 << (24 - 8 * (k % 4))) );
                if( k % 4 == 3 )
                {
                    tmp_sum = tmp_sum + read_32;
//                  NN_LOG("[%08X]\n k:%x tmp_sum:%16llX\n", read_32, k, tmp_sum);
                    read_32 = 0;
                }
            }

    //      NN_LOG("\n 1Mx*%d tmp_sum:%16llX \n", k, tmp_sum);
        }
//  test_time = GetMicroSecond(start_tick);
//  NN_LOG(" test_time:%lld mS \n check sum:%X\n", test_time, check_sum);

    }
    check_sum = tmp_sum % 0x100000000;
    NN_LOG("\n check_sum:%16llX \n", check_sum);



    NN_LOG( "Check Block is %3d\n", block );
    *checksum = check_sum;

    uji::sys::Free(apMemory);

    test_time = GetMicroSecond(start_tick);
    NN_LOG(" test_time:%lld mS \n check sum:%X\n", test_time, check_sum);

//  (void)gfx->m_TextWriter.Printf("\n READ ROM size:%u block:%d  SUM:%X\n          time :%d mS\n", gCardMaxSize, block, check_sum, test_time);
//  glFlush();
//  gfx->m_DrawFramework->SwapBuffers();


    return 0;


}



//=================================================================================================================================================
// 0102  j[NID擾
//=================================================================================================================================================
s32 GetUniqueID( char *str_uniqueID )
{
//  u8 apMemory[8*1024];
//  u32 read_size = 512 * 16;
    u32 read_size = 512 * 16;
    DetailInfo  detailInfo;
    SettingInfo setting;
//  u8* start_address;
    int i;
//  u8  uid[8];
    u32         gCardMaxSize;
    u8* apMemory;
    // Ԍvp
    nn::os::Tick start_tick;
    s64 test_time = 0;

    // ԌvJn
    start_tick = nn::os::Tick::GetSystemCurrent();

#if 0
    nn::os::SetDeviceMemorySize(1024*1024);
    apMemory = (u8*)nn::os::GetDeviceMemoryAddress();
#endif

    apMemory = reinterpret_cast<u8*>(uji::sys::AllocDeviceMemory(read_size, 32));
    if (apMemory == NULL)
    {
        NN_LOG("Failed to allocate continuous memory\n");
//NG̏邱ƁB
    }

    if(initialize_card_flag == 0)
    {
        //ctst(CardTest)Cu
        NN_UTIL_PANIC_IF_FAILED(Initialize());
        initialize_card_flag = 1;
    }

    //CardhCo
    NN_UTIL_PANIC_IF_FAILED(FunctionTestStart(apMemory, read_size, TID_FUNC_INITIALIZE, &detailInfo));
    NN_LOG("\nOK/NG :%d  false:%d", detailInfo.mReadSpeed, false );

    //[ID1擾]
    SettingMenu( (SettingId)TID_FUNC_RDID1, setting );
    NN_UTIL_PANIC_IF_FAILED(FunctionTestStart(apMemory, read_size, TID_FUNC_RDID1, &detailInfo));
    //detail.mID1ID1B
    //˂ȂA܂A܂QłAG[ꍇdetailInfo.mReadSpeedfalse܂B
    NN_LOG("\n 01 detailInfo.mID1[%X]\n", detailInfo.mID1);
    NN_LOG("OK/NG :%d", detailInfo.mReadSpeed );

    //[ID2擾]
    NN_UTIL_PANIC_IF_FAILED(SettingMenu( (SettingId)TID_FUNC_RDID2, setting ));
    NN_UTIL_PANIC_IF_FAILED(FunctionTestStart(apMemory, read_size, TID_FUNC_RDID2, &detailInfo));
    //detail.mID2ID2B
    //˂ȂA܂A܂QłAG[ꍇdetailInfo.mReadSpeedfalse܂B
    NN_LOG("\n 02 detailInfo.mID1[%X]\n", detailInfo.mID1);
    NN_LOG("\n 03 detailInfo.mID2[%X]\n", detailInfo.mID2);
    NN_LOG("OK/NG :%d", detailInfo.mReadSpeed );


    //[UID(j[NID)擾]
    NN_UTIL_PANIC_IF_FAILED(SettingMenu( (SettingId)TID_RD_UID, setting ));
    NN_UTIL_PANIC_IF_FAILED(FunctionTestStart(apMemory, read_size, TID_RD_UID, &detailInfo));
    //(u8*)apMemory̐擪64ByteQ
    //˂ȂA܂A܂QłAG[ꍇdetailInfo.mReadSpeedfalse܂B
    NN_LOG("\n 04 detailInfo.mID1[%X]\n", detailInfo.mID1);
    NN_LOG("\n 05 detailInfo.mID2[%X]\n", detailInfo.mID2);
    NN_LOG("OK/NG :%d", detailInfo.mReadSpeed );
    NN_LOG("\n 06 read_size:%d UID:%02X%02X%02X%02X%02X%02X%02X%02X\n",read_size, detailInfo.mUID[0], detailInfo.mUID[1], detailInfo.mUID[2], detailInfo.mUID[3], detailInfo.mUID[4], detailInfo.mUID[5], detailInfo.mUID[6], detailInfo.mUID[7] );
    sprintf(str_uniqueID, "%02X%02X%02X%02X%02X%02X%02X%02X", detailInfo.mUID[0], detailInfo.mUID[1], detailInfo.mUID[2], detailInfo.mUID[3], detailInfo.mUID[4], detailInfo.mUID[5], detailInfo.mUID[6], detailInfo.mUID[7] );

    uji::sys::Free(apMemory);

    test_time = GetMicroSecond(start_tick);
    NN_LOG(" test_time:%lld mS \n UniqueID:%s\n", test_time, str_uniqueID);

    return 0;

}









}
}
}










//============================================================================
//  CTRJ[hɃANZX鏀
//============================================================================
static void PrepareCard(nn::fs::FileInputStream* file)
{

    NN_LOG(" file:%s\n", file);


//  nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(200 * 1000 * 1000));


    return;

}










//============================================================================
//  ʕ\̏
//============================================================================
static void PrepareScreen(uji::sys::GraphicsDrawing* gfx, uji::sys::Pad* pad)
{
    static uji::sys::WindowManager m_WindowManager;

    gfx->m_DrawFramework->Clear();

    //  EChE
    m_WindowManager.UpdatePad(*pad);
    m_WindowManager.Update();
    m_WindowManager.DrawDisplay0();

    //  `
    gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

    // `̑O
    gfx->BeginDrawingString();
    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
    gfx->SetFixedWidthFont(16);
    gfx->m_TextWriter.SetCursor(10, 20);

    return;

}


//============================================================================
// A{^Ƃ̏(ROM̃`FbNT)
//============================================================================
static u32 ReadRom_PushA(nn::fs::FileInputStream* file, u32 start_page, u32 read_size)
{

    u32 once_read_size = 0;
    u32 total_page_num = 0;
    int place_8 = 0;
    int k = 0;
    u64 tmp_sum = 0;
    u32 check_sum = 0;
    u32 read_32 = 0;
    u32 page = 0;
    u8* apMemory;
    apMemory = reinterpret_cast<u8*>(uji::sys::AllocDeviceMemory(read_size, 32));
    if (apMemory == NULL)
    {
        NN_LOG("Failed to allocate continuous memory\n");
//NG̏邱ƁB
    }

    read_32 = 0;
    tmp_sum = 0;
    check_sum = 0;

    total_page_num = read_size/DATA_1M + 1;
        NN_LOG("\n total_page_num:%d \n", total_page_num);

    for(page=0;page<total_page_num;page++)
    {
        NN_LOG("\n page:%d \n", page);
        // f[^̓ǂݏoʒuw
        file->SetPosition( (512 * start_page) + (DATA_1M * page));

        // f[^̓ǂݏo
        if(page == total_page_num-1 ) once_read_size = read_size%DATA_1M;
        else                          once_read_size = DATA_1M;
        NN_LOG("\n once_read_size:%x \n", once_read_size);

        file->Read(apMemory, once_read_size);

        //
        for(k=0;k<once_read_size;k++)
        {
    //      NN_LOG("[%02X]", apMemory[k]);
            place_8 = 3 - (k % 4);
            read_32 += ( (apMemory[k]) * (1 << (8*place_8)) ) ;
            if( k % 4 == 3 )
            {
                tmp_sum = tmp_sum + read_32;
    //          NN_LOG("[%08X]\n tmp_sum:%16llX\n", read_32, tmp_sum);
                read_32 = 0;
            }
        }
    }

    //  NN_LOG("\n tmp_sum:%16llX \n", tmp_sum);

    check_sum = tmp_sum % 0x100000000;
//  NN_LOG("\n check_sum:%16llX \n", check_sum);


//  NN_LOG("\n A \n");

    return check_sum;

}

//============================================================================
// X{^Ƃ̏
//============================================================================
static void ReadRom_PushX(uji::sys::GraphicsDrawing* gfx)
{
    bool x = 0;
    u8 power_on_off = 0;

//  nn::fs::CardSlotIsInserted(&x);
    x = nn::fs::IsCardInserted();
    nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
    (void)gfx->m_TextWriter.Printf( "\n x:%d, power_on_off:%d \n", x, power_on_off );
    nn::fs::CardSlotPowerOn(&power_on_off);
    nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
    (void)gfx->m_TextWriter.Printf( "\n1 x:%d, power_on_off:%d \n", x, power_on_off );
//  nn::fs::CTRCardInitialize();
    Initialize();
//              (void)gfx->m_TextWriter.Printf( "\n X \n"  );
    NN_LOG("\n X \n");

    return;
}



//============================================================================
// Y{^Ƃ̏
//============================================================================
static void ReadRom_PushY(uji::sys::GraphicsDrawing* gfx)
{
    bool x = 0;
    u8 power_on_off = 0;

    x = nn::fs::IsCardInserted();
    nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
    (void)gfx->m_TextWriter.Printf( "\n %d, power_on_off:%d \n", x, power_on_off );
    nn::fs::CardSlotPowerOff(&power_on_off);
    nn::fs::CardSlotGetCardIFPowerStatus(&power_on_off);
    (void)gfx->m_TextWriter.Printf( "\n2 x:%d, power_on_off:%d \n", x, power_on_off );
    (void)gfx->m_TextWriter.Printf( "\n Y \n"  );
    NN_LOG("\n Y \n");

    return;
}




/*!--------------------------------------------------------------------------*
  @brief        Ԍv֐
        vJn_
  ߂l    start_timeo߂(mS)
 *---------------------------------------------------------------------------*/
static s64 GetMicroSecond( nn::os::Tick start_time )
{

    nn::os::Tick currentTick = nn::os::Tick::GetSystemCurrent();

    float millisecond = (float)((currentTick - start_time).ToTimeSpan().GetMicroSeconds() / 1000.0);

    return millisecond;

}



static bool GetCardSize(u32 id1, u32* gCardMaxSize)
{
    u8 cardSizeInd = ((id1 >> 8) & 0xff);
    NN_LOG("\n id1:%X  cardSizeInd:%X \n", id1, cardSizeInd );

    s64 sizeByte;
    if(cardSizeInd == 0x7f){
        //1Gbit(1073741824) / 8 = 134217728
//        UNUSED_START_PAGE = 257024;
        sizeByte = 134217728;
        *gCardMaxSize = sizeByte / 512;
    } else if(cardSizeInd == 0xFF) {
        //2Gbit
//        UNUSED_START_PAGE = 514048;
        sizeByte = 268435456;
        *gCardMaxSize = sizeByte / 512;
    } else if(cardSizeInd == 0xFE) {
        //4Gbit
//        UNUSED_START_PAGE = 1028096/*1027328*/;
        sizeByte = 536870912;
        *gCardMaxSize = sizeByte / 512;
    } else if(cardSizeInd == 0xFA) {
        //8Gbit
//        UNUSED_START_PAGE = 1952768/*1953280*/;
        sizeByte = 1073741824;
        *gCardMaxSize = sizeByte / 512;
    } else if(cardSizeInd == 0xF8) {
        //16Gbit
//        UNUSED_START_PAGE = 3906560;
        sizeByte = 2147483648LL;
        *gCardMaxSize = sizeByte / 512;
    NN_LOG("\n sizeByte:%lld (%lld = %u)\n", sizeByte, sizeByte / 512, sizeByte / 512);
    NN_LOG("\n gCardMaxSize:%u %llu \n", *gCardMaxSize, *gCardMaxSize);
    } else if(cardSizeInd == 0xF0) {
        //32Gbit
//        UNUSED_START_PAGE = 7813120;
        sizeByte = 4294967296LL;
        *gCardMaxSize = sizeByte / 512;
    } else if(cardSizeInd == 0xE0) {
        //64Gbit
        sizeByte = 859934592LL;
        *gCardMaxSize = sizeByte / 512;
    } else if(cardSizeInd == 0xE1) {
        //128Gbit
        sizeByte = 17179869184LL;
        *gCardMaxSize = sizeByte / 512;
    } else if(cardSizeInd == 0xE2) {
        //256Gbit
        sizeByte = 34359738368LL;
        *gCardMaxSize = sizeByte / 512;
    } else {
        NN_LOG("Data size is unknown.\n");
        return false;
    }
    return true;
}

