/************************************************************************

  vZX`FbNAvvZX`FbN

 *************************************************************************/

#ifndef PROCESS_CHECK_H_INCLUDED
#define PROCESS_CHECK_H_INCLUDED

#include "ProcessCheck_Define.h"
#include "ProcessCheck_ErrorCode.h"
#include "../seq/TestResult.h"


namespace uji{
namespace eva{

void OpenProcCheckMenu();


namespace procchk {


// Ăяo֐
extern bool Invoke_Startup       ( uji::seq::TestResult &result );
extern bool Invoke_DisplayQRCode ( uji::seq::TestResult &result );
extern void Invoke_DisplayQRCode ( void );

extern bool Invoke_CheckSequence ( uji::seq::TestResult &result );
extern bool Invoke_CheckRegion   ( uji::seq::TestResult &result );
extern bool Invoke_CheckSerialNo ( uji::seq::TestResult &result );

extern bool Invoke_CheckNotExsistAgingProgram( uji::seq::TestResult &result );

extern bool Invoke_CheckPreInstallSdCard ( uji::seq::TestResult &result );
extern bool Invoke_CheckBlankSdCard      ( uji::seq::TestResult &result );
extern bool Invoke_CheckNoSdCard         ( uji::seq::TestResult &result );
extern bool Invoke_CheckSdCardSize       ( uji::seq::TestResult &result );

extern bool Invoke_CheckRfuNor   ( uji::seq::TestResult &result );
extern bool Invoke_ClearRfuNor   ( uji::seq::TestResult &result );

extern bool Invoke_CheckProductLog              ( uji::seq::TestResult &result );
extern bool Invoke_CheckProductLogLastProcess   ( uji::seq::TestResult &result );
extern bool Invoke_CheckProductLogImportVersion ( uji::seq::TestResult &result );
extern bool Invoke_CheckProductLogPreInstallVersion ( uji::seq::TestResult &result );
extern bool Invoke_CheckProductLogNotPreInstalled ( uji::seq::TestResult &result );
extern bool Invoke_WriteProductLog            ( uji::seq::TestResult &result );
extern bool Invoke_TestFunc                   ( uji::seq::TestResult &result );

extern bool Invoke_ValidateSign         ( uji::seq::TestResult &result);

extern bool Invoke_CheckFirstLaunchFlag ( uji::seq::TestResult &result);

extern void SetMicroCode(nn::Result r, u32 * m);

// vZX`FbNNX
class ProcessCheck
{
public:
    static const int FONT_SIZE = 14;


//  oϐ̒`
private:
    sys::GraphicsDrawing  * m_gfx; // OtBbNXIuWFNg

    // eNX`
    sys::JpegDrawer *   m_JpegDrawer;
    sys::BmpTexture *   m_BmpBottom;
    GLuint              m_TextureIdBottom;
    sys::BmpTexture *   m_BmpQR;
    GLuint              m_TextureIdQR;

    // EBhE
    sys::WindowManager  m_WindowManager;
    sys::TextWindow     m_StartupWindow;   // X^[gʗp



public:
    ProcessCheck() :    m_BmpBottom(0),
                        m_TextureIdBottom(0),
                        m_BmpQR(0),
                        m_TextureIdQR(0),
                        m_StartupWindow(56,16,FONT_SIZE)
    {
        m_gfx = sys::GraphicsDrawing::GetInstance();
    };

    //fXgN^
    ~ProcessCheck()
    {
    //TODO OtBbNXñ|C^̉
    };


public:
    // ]j[
    void Menu1(void);
    void Menu2(void);
    void Menu3(void);
    void Menu4(void);

    // QRR[h
    u8 * GetTextureDataFromRawData(const u32& width,
                                               const u32& height,
                                               u8* rawDataBuffer,
                                               u32& textureWidth,
                                               u32& textureHeight);
    void CreateQRCode (void);
    void ShowQRCode   (void);

    // O`FbN
    bool LogCheck_Exist                  ( uji::seq::TestResult &result );
    bool LogCheck_LastProcessIsProcCheck ( uji::seq::TestResult &result );
    bool LogCheck_ImportVersion          ( uji::seq::TestResult &result );
    bool LogCheck_PreInstallVersion      ( uji::seq::TestResult &result );
    bool LogCheck_NotPreInstalled        ( uji::seq::TestResult &result );
    
    // OtBbNX
    void GraphicsInit     (char * window_title);
    void GraphicsFinalize (int types);
    void GraphicsUpdate   (int types);
    void CreateStartupWindow (void);

    // OtBbNX֐
private:
    void UpdateMainLcd (int types);
    void UpdateSubLcd  (int types);
    void UpdateLcd(void);

    void OpenBmpSubLcd (const wchar_t *fileName);
    void ShowBmpSubLcd (void);

    // ϊ
    u32 AsciiToU32 (char);
};


} // namespace procchk
} // namespace eva
} // namespace uji

#endif
