#include "ProcessCheck.h"
#include "sys_ShowMessage.h"
#include "../seq/Reception_board_interface.h"
#include "../seq/Config.h"
#include "../seq/TestListManager.h"
#include "../seq/TesterLog/ProductionLog.h"
#include <nn/dbg.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/cfg/CTR/cfg_ApiNor.h>
#include <nn/cfg/CTR/cfg_NtrSettings.h>
#include <mw/qre/qre.h>
#include <nn/am/am_Result.h>
#include "../sys/sys_GetSerialNumber.h"
#include <nn/cfg/CTR/detail/cfg_Keys.h>
#include <nn/cfg/CTR/detail/cfg_DataStructures.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji::seq::pl;
using namespace uji::seq;
using namespace nn::cfg::CTR;
using namespace mw::qre;

#define TYPE_NOUSE_JPEG  0
#define TYPE_STARTUP     1
#define TYPE_QRCODE      2
#define TYPE_UPPER_QR    3


namespace uji{
namespace eva{

void OpenProcCheckMenu()
{
using namespace uji::eva::procchk;

    uji::eva::procchk::ProcessCheck * pc = new uji::eva::procchk::ProcessCheck();

    uji::sys::ClassMenu *m = new uji::sys::ClassMenu( "ProcessCheck Menu" );
    m->Add<ProcessCheck>("Validate Signature", pc, &ProcessCheck::Menu1, NULL);
    m->Add<ProcessCheck>("Check RFU NOR",     pc, &ProcessCheck::Menu3, NULL);
//    m->Add<ProcessCheck>("Check RFU NOR2 (Detail)",     pc, &ProcessCheck::Menu5, NULL);
    m->Add<ProcessCheck>("Clear RFU NOR1(0x1FE00 -0x1FFFF:NTRSetting)",    pc, &ProcessCheck::Menu4, NULL);
    m->Add<ProcessCheck>("Clear RFU NOR2(0x1F300 -0x1FFFF)", pc, &ProcessCheck::Menu2, NULL);
    m->Open();

    delete pc;
    delete m;
}

namespace procchk
{

// _~[֐
bool Invoke_TestFunc( uji::seq::TestResult &result )
{
    result.m_Result = true;
    return result.m_Result;
}

//
// X^[gAbv(A{^܂ł͐i܂Ȃ)
//
bool Invoke_Startup( uji::seq::TestResult &result )
{
    result.m_Result = true;

    ProcessCheck * pc = new ProcessCheck();
    pc->GraphicsInit("Start Menu");
    pc->CreateStartupWindow();
    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();
        pc->GraphicsUpdate(TYPE_STARTUP);

    } while(!pad.IsButtonDown(uji::sys::Pad::BUTTON_A));

    pc->GraphicsFinalize(TYPE_STARTUP);

    delete pc;
    return result.m_Result;
}

//
// QRR[h\
//
bool Invoke_DisplayQRCode( uji::seq::TestResult &result )
{
    result.m_Result = true;

    ProcessCheck * pc = new ProcessCheck();
    pc->GraphicsInit("QR Code");

    pc->CreateQRCode();

    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();
        pc->GraphicsUpdate(TYPE_QRCODE);

    } while(!pad.IsButtonDown(uji::sys::Pad::BUTTON_A));

    pc->GraphicsFinalize(TYPE_QRCODE);

    delete pc;
    return result.m_Result;
}

//
// QRR[h\
//
void Invoke_DisplayQRCode( void )
{
    ProcessCheck * pc = new ProcessCheck();
    pc->GraphicsInit("QR Code");

    pc->CreateQRCode();

    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();
        pc->GraphicsUpdate(TYPE_QRCODE);

    } while(!pad.IsButtonDown(uji::sys::Pad::BUTTON_A));

    pc->GraphicsFinalize(TYPE_QRCODE);

    delete pc;
}

//
// `FbNV[PX
//
// Sequence̗LEeXg[hUJI_BUILD_TYPE
// Ă邱ƂmF
bool Invoke_CheckSequence( uji::seq::TestResult &result )
{
    result.m_Result = true;

/*
    //  QC[h̏ꍇ
    uji::seq::Config  *c = new uji::seq::Config;
    if ( uji::seq::pl::QC == c->Get().TestMode )
    {
        //CONFIGURATION ProductLog2 ProcCheck  trueł邱ƂmF
        if ( true != c->Get().LogCheck_ProcCheck )
        {
            sprintf(result.m_String, " Confirm CONFIGURATION settings \n (enable \"ProductLog2 ProcCheck\")");
            result.m_Micro  = PROCCHK_ERROR_SEQUENCE;
            result.m_Result = false ;
        }
    }
    delete c;
*/

    return result.m_Result;
}

//
// `FbN G[WOvO݂Ȃ
//
bool Invoke_CheckNotExsistAgingProgram( uji::seq::TestResult &result )
{
    result.m_Result = false;
    nn::Result nnr;

    nn::am::ProgramInfo pi;
    nn::ProgramId pidArray[1];
    pidArray[0] = uji::eva::AgingImporter::IMPORTEE_AGING_ID;

    // amGetProgramInfos֐ĂсA̖߂lResultNotFoundȊOł΁ANG
    nnr = nn::am::GetProgramInfos(&pi, nn::fs::MEDIA_TYPE_NAND, pidArray, 1);
    if ( nnr.IsFailure() && nnr == nn::am::ResultNotFound())
    {
        result.m_Result = true;
    }
    else
    {
        result.m_Result = false;
        sprintf(result.m_String, "%016llx is not ResultNotFound", uji::eva::AgingImporter::IMPORTEE_AGING_ID);
    }

    return result.m_Result;
}

// MicroR[hݒ
void SetMicroCode(nn::Result r, u32 * m)
{

    *m = 0; //YȂꍇ 0

    // ̂ƂAAM݂̂ɎgpB
    if ( r.GetModule() == nn::Result::MODULE_NN_AM )
    {
        *m = PROCCHK_ERROR_CATEGORY_AM_OFFSET + r.GetDescription();
    }

    return;
}

//
// `FbNSDJ[h
//
// {̂ƕRtꂽf[^ł邱ƂmF
// (uNSDJ[h`FbN͕APIpӁj
//
//  1. SDJ[h}Ă邱ƂmF (IsSdmcInserted)
//  2. SDJ[h݋֎~ł͂ȂƂmF (IsSdmcWritable)
//  3. SDJ[h}Eg
//  4. SDJ[h̒̃fBNgGg̐1ł邱ƂmFB
//     1łȂꍇ́AĂ邩ő10\B
//  5. fBNgGg̓e݂āA"Nintendo 3DS"1邱ƂmF
//  6. SDJ[hA^CgID̃Xg擾Ã^CgID̈
//     Ӗ̂f[^(ProgramInfosize0łȂ)擾ł OKƂB
//  7. SDJ[hA}Eg
bool Invoke_CheckPreInstallSdCard( uji::seq::TestResult &result )
{
    result.m_Result = false;
    nn::Result  nnr;
    nn::fs::Directory rootDir;
    nn::fs::DirectoryEntry deArray[10];//128ƂƂƁASiX^bNsHj
    int deNum;

    nn::srv::Initialize();

    //1.SDJ[h}Ă邱ƂmF
    bool bInserted;
    bInserted = nn::fs::IsSdmcInserted();
    if (!bInserted )
    {
        sprintf(result.m_String, "sd card is NOT inserted.\n");
        result.m_Micro  = PROCCHK_ERROR_SD_NOT_INSERTED;
        goto ERROR2;
    }

    //2.CgveNgĂȂƂmF
    bool bWritable;
    bWritable = nn::fs::IsSdmcWritable();
    if ( !bWritable )
    {
        sprintf(result.m_String, "sd card is NOT writable.\n");
        result.m_Micro  = PROCCHK_ERROR_SD_NOT_WRITABLE;
        goto ERROR2;
    }

    //3.SDJ[h̃}Eg
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        SetMicroCode(nnr, &result.m_Micro);
        sprintf(result.m_String, "sd card mount failed(%d).\n", (s32)(result.m_Micro));
        goto ERROR2;
    }

    //4.
    nnr = rootDir.TryInitialize(L"sdmc:/");
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        sprintf(result.m_String, "root directory open failed.\n");
        result.m_Micro  = PROCCHK_ERROR_SD_DIR_OPEN;
        goto ERROR1;
    }

    {
        std::wstring deName     = L" ";
        deNum = -1;
        deNum = rootDir.Read(deArray,10);//10قǃfBNgGg擾
        if ( 1 != deNum )
        {
            NN_LOG("deNum :%d\n", deNum);
            std::wstring temp;
            for(int i = 0; i < deNum; i++)
            {
                temp   = deArray[i].entryName;
                deName = deName + temp + L" ";
            }
            sprintf(result.m_String, "root directory entryNum is NOT 1 directory! \n%ls", deName.c_str());
            result.m_Micro  = PROCCHK_ERROR_SD_ENTRY_NOT_ONE;
            goto ERROR1;
        }
    }

    //5
    nn::am::ProgramInfo pi;
    nn::ProgramId pidArray[10];
    s32 outnum;

    // SDJ[hA^CgID̃Xg擾A^CgID̈GetProgramInfosgpāA
    // Ӗ̂f[^ƂĎ擾ł΁AOKƂB

//
#define USE_MEDIA_SDMC 1

#if USE_MEDIA_SDMC
    // OfBAC|[gΏۂƂĎgp\₢킹
    // ܂AtH_"Nintendo 3DS"ł邱ƁATutH_̂Q
    // Íꂽw̕\LɂȂĂ邱ƂmFB
    bool bAvailable;
    nnr = nn::am::QueryAvailableExternalTitleDatabase(&bAvailable);
    if ( nnr.IsFailure())
    {
        sprintf(result.m_String, "am::QueryAvailableExternalTitleDatabase API failed.\n");
        SetMicroCode(nnr, &result.m_Micro);
        result.m_Result = false;
        goto ERROR1;
    }

    if ( !bAvailable)
    {
        sprintf(result.m_String, "am::QueryAvailableExternalTitleDatabase [false].\n");
        result.m_Micro  = PROCCHK_ERROR_SD_QUERY_EXTERNAL_TITLE_DB;
        result.m_Result = false;
        goto ERROR1;
    }
#endif

    s32 programNum;

#if USE_MEDIA_SDMC
    programNum = -1;
    nnr = nn::am::GetNumPrograms(&programNum, nn::fs::MEDIA_TYPE_SDMC);
    if ( nnr.IsFailure())
    {
        SetMicroCode(nnr, &result.m_Micro);
        sprintf(result.m_String, "am::GetNumPrograms SDMC failed(%d).\n",(s32)result.m_Micro);
        result.m_Result = false;
        goto ERROR1;
    }

#else
    nnr = nn::am::GetNumPrograms(&programNum, nn::fs::MEDIA_TYPE_NAND);
    if ( nnr.IsFailure())
    {
        SetMicroCode(nnr, &result.m_Micro);
        sprintf(result.m_String, "am::GetNumPrograms NAND failed(%d).\n"(s32)result.m_Micro);
        result.m_Result = false;
        goto ERROR1;
    }
#endif


    outnum = -1;
#if USE_MEDIA_SDMC
    nnr = nn::am::GetProgramList(&outnum, pidArray, 10, nn::fs::MEDIA_TYPE_SDMC);
#else
    nnr = nn::am::GetProgramList(&outnum, pidArray, 10, nn::fs::MEDIA_TYPE_NAND);
#endif
    if ( nnr.IsFailure())
    {
        SetMicroCode(nnr, &result.m_Micro);
        sprintf(result.m_String, "am::GetProgramList failed(%d).\n",(s32)result.m_Micro);
        result.m_Result = false;
        goto ERROR1;
    }

#if USE_MEDIA_SDMC
    nnr = nn::am::GetProgramInfos(&pi, nn::fs::MEDIA_TYPE_SDMC, pidArray, 1);
#else
    nnr = nn::am::GetProgramInfos(&pi, nn::fs::MEDIA_TYPE_NAND, pidArray, 1);
#endif
    if ( nnr.IsFailure())
    {
        SetMicroCode(nnr, &result.m_Micro);
        sprintf(result.m_String, "am::GetProgramInfos failed(%d).\n",(s32)result.m_Micro);
        result.m_Result = false;
        goto ERROR1;
    }

    //6.programInfosize0Ȃ΁Asȃf[^Ɣf
    //  łȂ΁AOKƂB
    if ( 0 == pi.size )
    {
        sprintf(result.m_String, "ProgramInfo size is invalid.\n");
        result.m_Micro  = PROCCHK_ERROR_SD_PROGRAM_INFO_ENTRYSIZE;
        result.m_Result = false;
        goto ERROR1;
    }


    //7.SDJ[h̃A}Eg
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        sprintf(result.m_String, "sd card unmount failed.\n"); //TODO Xe[^X\
        result.m_Micro  = PROCCHK_ERROR_SD_UMOUNT;
        goto ERROR2;
    }

    // ܂łΐ
    result.m_Result = true;
    return result.m_Result;

ERROR1:
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure()) nn::dbg::PrintResult(nnr);

ERROR2:
    result.m_Result = false;
    return result.m_Result;
}


//
// `FbN NoSDCard
//

//  SDJ[h}ĂȂƂmF (IsSdmcInserted)
bool Invoke_CheckNoSdCard( uji::seq::TestResult &result )
{
    result.m_Result = false;
    nn::Result nnr;

    nn::srv::Initialize();

    //SDJ[h}ĂȂƂmF
    bool bInserted;
    bInserted = nn::fs::IsSdmcInserted();
    if (bInserted )
    {
        sprintf(result.m_String, "sd card is inserted.\n");
        result.m_Micro  = PROCCHK_ERROR_SD_NOT_INSERTED;
        goto ERROR2;
    }

    // ܂łΐ
    result.m_Result = true;
    return result.m_Result;

ERROR2:
    result.m_Result = false;
    return result.m_Result;
}



//
// `FbNuNSDJ[h
//

//  1. SDJ[h}Ă邱ƂmF (IsSdmcInserted)
//  2. SDJ[h݋֎~ł͂ȂƂmF (IsSdmcWritable)
//  3. SDJ[h}Eg
//  4. SDJ[h̒̃fBNgGg̐0ł邱ƂmFB
//     0łȂꍇ́AĂ邩ő10\B
//  5. SDJ[hA}Eg
bool Invoke_CheckBlankSdCard( uji::seq::TestResult &result )
{
    result.m_Result = false;
    nn::Result nnr;
    nn::fs::Directory rootDir;
    nn::fs::DirectoryEntry deArray[10];//128ƂƂƁASiX^bNsHj
    int deNum;

    nn::srv::Initialize();

    //1.SDJ[h}Ă邱ƂmF
    bool bInserted;
    bInserted = nn::fs::IsSdmcInserted();
    if (!bInserted )
    {
        sprintf(result.m_String, "sd card is NOT inserted.\n");
        result.m_Micro  = PROCCHK_ERROR_SD_NOT_INSERTED;
        goto ERROR2;
    }

    //2.CgveNgĂȂƂmF
    bool bWritable;
    bWritable = nn::fs::IsSdmcWritable();
    if ( !bWritable )
    {
        sprintf(result.m_String, "sd card is NOT writable.\n");
        result.m_Micro  = PROCCHK_ERROR_SD_NOT_WRITABLE;
        goto ERROR2;
    }

    //3.SDJ[h̃}Eg
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        sprintf(result.m_String, "sd card mount failed.\n"); //TODO Xe[^X\
        result.m_Micro  = PROCCHK_ERROR_SD_MOUNT;
        goto ERROR2;
    }

    //4.SDJ[h̃fBNgGg̐JEg
    nnr = rootDir.TryInitialize(L"sdmc:/");
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        sprintf(result.m_String, "root directory open failed.\n");
        result.m_Micro  = PROCCHK_ERROR_SD_DIR_OPEN;
        goto ERROR1;
    }

    deNum = -1;
    deNum = rootDir.Read(deArray,10);//10قǃfBNgGg擾
    if ( 0 != deNum )
    {
        NN_LOG("deNum :%d\n", deNum);
        std::wstring deName = L" ";
        std::wstring temp;
        for(int i = 0; i < deNum; i++)
        {
            temp   = deArray[i].entryName;
            deName = deName + temp + L" ";
        }
        sprintf(result.m_String, "root directory entryNum is NOT zero! \n%ls", deName.c_str());
        result.m_Micro  = PROCCHK_ERROR_SD_ENTRY_NOT_ZERO;
        goto ERROR1;
    }

    //5.SDJ[h̃A}Eg
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        sprintf(result.m_String, "sd card unmount failed.\n"); //TODO Xe[^X\
        result.m_Micro  = PROCCHK_ERROR_SD_UMOUNT;
        goto ERROR2;
    }

    // ܂łΐ
    result.m_Result = true;
    return result.m_Result;

ERROR1:
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure()) nn::dbg::PrintResult(nnr);

ERROR2:
    result.m_Result = false;
    return result.m_Result;
}


//
// `FbN SD CARD SIZE
//

//  w̃TCYSDJ[hĂ邩mF
//  SDJ[ȟȃTCY̓[J[ɂĈقȂ邽߁A+-5%̔r
bool Invoke_CheckSdCardSize( uji::seq::TestResult &result )
{
    nn::Result nnr;

    const s32 MEGA = 1000 * 1000;//SDJ[hSIړ\L̂
    
    s64 sdTotal   = 0;
    s64 sdFree    = 0;
    s32 sdTotalMB = 0;
    
    uji::seq::Config *config = new uji::seq::Config;
    const s32 configSdCardSizeGB = config->Get().SdCardSize;
    const s32 configSdCardSizeMB = configSdCardSizeGB * 1000;//MBPʂɕϊ
    delete config;
    
    s32 sizeThresholdMB = configSdCardSizeGB * 50;//ݒlƎeʂ̋e鍷(+-5% MBP)

    result.m_Result = false;
    
    //1.SDJ[h}Ă邱ƂmF
    bool bInserted;
    bInserted = nn::fs::IsSdmcInserted();
    if (!bInserted )
    {
        sprintf(result.m_String, "sd card is NOT inserted.\n");
        result.m_Micro  = PROCCHK_ERROR_SD_NOT_INSERTED;
        goto ERROR2;
    }

    //2.CgveNgĂȂƂmF
    bool bWritable;
    bWritable = nn::fs::IsSdmcWritable();
    if ( !bWritable )
    {
        sprintf(result.m_String, "sd card is NOT writable.\n");
        result.m_Micro  = PROCCHK_ERROR_SD_NOT_WRITABLE;
        goto ERROR2;
    }

    //3.SDJ[h̃}Eg
    nnr = nn::fs::MountSdmc();
    if (nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        sprintf(result.m_String, "sd card mount failed.\n"); //TODO Xe[^X\
        result.m_Micro  = PROCCHK_ERROR_SD_MOUNT;
        goto ERROR2;
    }

    //4.SDJ[h̃TCY`FbN
    nnr = nn::fs::GetSdmcSize( &sdTotal, &sdFree );
    if( nnr.IsFailure() )
    {
        sprintf(result.m_String, "sd card get size failed.\n");
        result.m_Micro = PROCCHK_ERROR_SD_GET_SIZE;
        goto ERROR1;
    }
    sdTotalMB = sdTotal / MEGA;
    
    if (nn::math::Abs(configSdCardSizeMB - sdTotalMB) > sizeThresholdMB) {
        sprintf(result.m_String, "incorrect sd card size.\nInserted : %d(MB)   Config : %d(MB)\n", sdTotalMB, configSdCardSizeMB );
        result.m_Micro = PROCCHK_ERROR_SD_INCORRECT_SIZE;
        goto ERROR1;
    }

    //5.SDJ[h̃A}Eg
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        sprintf(result.m_String, "sd card unmount failed.\n"); //TODO Xe[^X\
        result.m_Micro  = PROCCHK_ERROR_SD_UMOUNT;
        goto ERROR2;
    }

    // ܂łΐ
    result.m_Result = true;
    return result.m_Result;
    
ERROR1:
    nnr = nn::fs::Unmount("sdmc:");
    if ( nnr.IsFailure()) nn::dbg::PrintResult(nnr);
    
ERROR2:
    result.m_Result = false;
    return result.m_Result;
    
}


//
// `FbN[W
//

// 1. VAio[̂QڂƖ{̓RegionCodevĂ邩
// 2. UJI_REGIONƖ{̓̃[WvĂ邩
bool Invoke_CheckRegion( uji::seq::TestResult &result )
{
    result.m_Result = true;
    bool flag = true;

// 1. VAio[̂QڂƖ{̓RegionCodevĂ邩
    int code = -1;
    code = uji::sys::GetRegionCode();

    char serNo[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN];
    std::memset(serNo, 0x00, sizeof(serNo));
    uji::sys::GetSerialNumber(serNo);

/*
    if ( 'A' == serNo[1] ) { if (code != CFG_REGION_EUROPE)    { flag = false ;}}
    if ( 'B' == serNo[1] ) { if (code != CFG_REGION_AMERICA)   { flag = false ;}}
    if ( 'C' == serNo[1] ) { if (code != CFG_REGION_CHINA)     { flag = false ;}}
    if ( 'E' == serNo[1] ) { if (code != CFG_REGION_EUROPE)    { flag = false ;}}
    if ( 'J' == serNo[1] ) { if (code != CFG_REGION_JAPAN)     { flag = false ;}}
    if ( 'K' == serNo[1] ) { if (code != CFG_REGION_KOREA)     { flag = false ;}}
    if ( 'S' == serNo[1] ) { if (code != CFG_REGION_AMERICA)   { flag = false ;}}
    if ( 'T' == serNo[1] ) { if (code != CFG_REGION_TAIWAN)    { flag = false ;}}
    if ( 'W' == serNo[1] ) { if (code != CFG_REGION_AMERICA)   { flag = false ;}}
*/
    if ( code != uji::sys::SerialNumberToRegionCode(serNo[1])) { flag = false ;}

    if ( false == flag)
    {
        result.m_Micro  = PROCCHK_ERROR_REGION_CODE;
        result.m_Result = false;
        goto FIN;
    }

// 2. UJI_REGIONƖ{̓̃[WvĂ邩
    if ( 0 == strncmp(UJI_REGION, "CHN", 3) ) {if ( code != CFG_REGION_CHINA)     { flag = false ;}}
    else if ( 0 == strncmp(UJI_REGION, "EUR", 3) ) {if ( code != CFG_REGION_EUROPE)    { flag = false ;}}
    else if ( 0 == strncmp(UJI_REGION, "UKV", 3) ) {if ( code != CFG_REGION_EUROPE)    { flag = false ;}}
    else if ( 0 == strncmp(UJI_REGION, "JPN", 3) ) {if ( code != CFG_REGION_JAPAN)     { flag = false ;}}
    else if ( 0 == strncmp(UJI_REGION, "KOR", 3) ) {if ( code != CFG_REGION_KOREA)     { flag = false ;}}
    else if ( 0 == strncmp(UJI_REGION, "TWN", 3) ) {if ( code != CFG_REGION_TAIWAN)    { flag = false ;}}
    else if ( 0 == strncmp(UJI_REGION, "USA", 3) ) {if ( code != CFG_REGION_AMERICA)   { flag = false ;}}
    else if ( 0 == strncmp(UJI_REGION, "FTR_EUR", 7) ) {if ( code != CFG_REGION_EUROPE)    { flag = false ;}}
    else if ( 0 == strncmp(UJI_REGION, "FTR_KOR", 7) ) {if ( code != CFG_REGION_KOREA)     { flag = false ;}}
    else if ( 0 == strncmp(UJI_REGION, "FTR_USA", 7) ) {if ( code != CFG_REGION_AMERICA)   { flag = false ;}}
    else { /*쓙Œǉpɂɔ邽߁AG[ԂȂBf[^݂łNGԂȂAvZX`FbNNGƂȂB*/ }

    result.m_Micro  = PROCCHK_ERROR_UJI_REGION;
    result.m_Result = flag;

FIN:
    return result.m_Result;
}

//
// `FbNVAio[
//
#define CHECK_SERNO_RANGE(index)  (( serNo[index] < 0x30 ) || ( serNo[index] > 0x39))
bool Invoke_CheckSerialNo( uji::seq::TestResult &result )
{
    result.m_Result = true;

    char serNo[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN];
    std::memset(serNo, 0x00, sizeof(serNo));
    uji::sys::GetSerialNumber(serNo);

    // Ŝ̕1011ł邱ƂmF
    int length = 0;
    length = strlen(serNo);
    if (( 10 != length ) && ( 11 != length) )
    {
        result.m_Result = false;
        sprintf(result.m_String, "Invalid SerNo length!");
        result.m_Micro  = PROCCHK_ERROR_SERNO_LENGTH;
        goto FIN;
    }

    //擪̃`FbN
    //  [CTR] ʎY@ł 'CfJ@ł 'E'ł邱
    //  [SPFL]ʎY@ł 'RfJ@ł 'S'ł邱
    u8 bondingOption;
    bondingOption = uji::sys::GetBondingOption();
    
    // CTȐꍇ
    if ( uji::sys::PLATFORM_CTR == uji::sys::GetPlatformType())
    {
	    if ( 0 == bondingOption )	   //ʎY@
	    {
	        if ( serNo[0] != 'C') { result.m_Result = false; sprintf(result.m_String, "Invalid SerNo 1st Character!");
	                                result.m_Micro  = PROCCHK_ERROR_SERNO_1STCHAR; goto FIN ; }
	    }
	    else if ( 1 == bondingOption ) //J@A
	    {
	        if ( serNo[0] != 'E') { result.m_Result = false; sprintf(result.m_String, "Invalid SerNo 1st Character!");
	                                result.m_Micro  = PROCCHK_ERROR_SERNO_1STCHAR; goto FIN ; }
	    }
	}
	// SPȐꍇ
	if ( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
    {
	    if ( 0 == bondingOption )	   //ʎY@
	    {
	        if ( serNo[0] != 'S') { result.m_Result = false; sprintf(result.m_String, "Invalid SerNo 1st Character!");
	                                result.m_Micro  = PROCCHK_ERROR_SERNO_1STCHAR; goto FIN ; }
	    }
	    else if ( 1 == bondingOption ) //J@A
	    {
	        if ( serNo[0] != 'R') { result.m_Result = false; sprintf(result.m_String, "Invalid SerNo 1st Character!");
	                                result.m_Micro  = PROCCHK_ERROR_SERNO_1STCHAR; goto FIN ; }
	    }
	}
	// FTȐꍇ
	if ( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
	    if ( 0 == bondingOption )	   //ʎY@
	    {
	        if ( serNo[0] != 'A') { result.m_Result = false; sprintf(result.m_String, "Invalid SerNo 1st Character!");
	                                result.m_Micro  = PROCCHK_ERROR_SERNO_1STCHAR; goto FIN ; }
	    }
	    else if ( 1 == bondingOption ) //J@A
	    {
	        if ( serNo[0] != 'P') { result.m_Result = false; sprintf(result.m_String, "Invalid SerNo 1st Character!");
	                                result.m_Micro  = PROCCHK_ERROR_SERNO_1STCHAR; goto FIN ; }
	    }
	}


    //2ڂ 'A','B','C','E','J','K','T','U','W','S'̂ǂꂩł邱
    if ( (serNo[1] != 'A') &&
         (serNo[1] != 'B') &&
         (serNo[1] != 'C') &&
         (serNo[1] != 'E') &&
         (serNo[1] != 'G') &&
         (serNo[1] != 'J') &&
         (serNo[1] != 'K') &&
         (serNo[1] != 'T') &&
         (serNo[1] != 'U') &&
         (serNo[1] != 'W') &&
         (serNo[1] != 'S')
       )
    {
        result.m_Result = false;
        sprintf(result.m_String, "Invalid SerNo 2nd Character!");
        result.m_Micro  = PROCCHK_ERROR_SERNO_2ndCHAR;
        goto FIN;
    }

    // ̃`FbN
    //   8 0x30  0x39܂ł͈̔͂Ɏ܂Ă邱Ƃ̊mF
    if ( 10 == length )
    {
        // serNo[2]serNo[9] ܂ł8
        for(int i = 2; i < 10; i++)
        {
            if CHECK_SERNO_RANGE(i) { sprintf(result.m_String, "Invalid 8-digit number!");
                                      result.m_Micro  = PROCCHK_ERROR_SERNO_8DIGIT;
                                      result.m_Result = false;goto FIN; }
        }
    }
    else if ( 11 == length )
    {
        // serNo[3]  serNo[10]܂ł8
        for(int i = 3; i < 11; i++)
        {
            if CHECK_SERNO_RANGE(i) { sprintf(result.m_String, "Invalid 8-digit number!");
                                      result.m_Micro  = PROCCHK_ERROR_SERNO_8DIGIT;
                                      result.m_Result = false;goto FIN; }
        }
    }

FIN:
    return result.m_Result;
}


namespace
{
  const u32   FILL_AREA_OFFSET = 0x1F300U;    // f[^ߗ̈ItZbg
//  const u32   FILL_AREA_SIZE   = 0xD00U;      // f[^ߗ̈TCY
  const u32   FILL_AREA_SIZE   = 0xB00U;      // f[^ߗ̈TCY

  const u8    FILL_VALUE       = 0xFFU;       // f[^ߒl
        u8    s_writeData[FILL_AREA_SIZE];
        u8    s_readData[FILL_AREA_SIZE];
}

//
// `FbN RFU NORtbV
//

// u"NAND  FATAL G[tO" ̈悪 0xFF ł邱Ɓv
//  = u0x0020 Ԓn 0x3FC0  0x1F300`0x1FFFFԒn 0xFF ł邱Ɓv

bool Invoke_CheckRfuNor( uji::seq::TestResult &result )
{
    result.m_Result = true;

    const u32   NITRO_OFFSET_STORED_ADDR    =  0x0020U;  // NITORO {̐ݒf[^ ROM ItZbgi[AhX
    const u16   NITRO_OFFSET_EXPECTED_VALUE =  0x3FC0U;  // NITORO {̐ݒf[^ ROM ItZbgҒl
    const u32   NOR_RESERVE_TOP                 = 0x1F300U; // \̈̐擪
    const u32   NOR_NTR_SYSTEM_DATA_MIRROR2_END = 0x1FFFFU; // NTR{̐ݒf[^~[Q̍Ō

    nn::cfg::nor::CTR::Initialize();

    // 1/2 : 0x0020 Ԓn 0x3FC0U ł邱
    u16 nitro_offset = 0xFFFFU;
    nn::cfg::nor::CTR::Read(NITRO_OFFSET_STORED_ADDR, reinterpret_cast<u8*>(&nitro_offset), sizeof(nitro_offset));
    if (nitro_offset != NITRO_OFFSET_EXPECTED_VALUE)
    {
        sprintf(result.m_String, "NITRO offset is unexpected value: 0x%04X", nitro_offset);
        result.m_Micro  = PROCCHK_ERROR_NOR_NTROFFSET;
        result.m_Result = false;
        return result.m_Result;
    }

    // 2/2 : 0x1F300`0x1FDFF Ԓn0xFF ł邱
    //       \̈ATWL WiFiݒANTR WiFiݒ

#if 0
    // @3bx
    u8 target_value = 0xAB;//_~[l
    u32 addr;
    for ( addr=NOR_RESERVE_TOP; addr <= NOR_NTR_SYSTEM_DATA_MIRROR2_END; addr++)
    {
        nn::cfg::nor::CTR::Read(addr, reinterpret_cast<u8*>(&target_value), sizeof(target_value));
        if ( target_value != 0xFF )
        {
            sprintf(result.m_String, " address:0x%04X  is unexpected value: 0x%02X",addr, target_value);
            result.m_Micro  = PROCCHK_ERROR_NOR_1F300;
            result.m_Result = false;
            return result.m_Result;
        }
        NN_LOG(" address:0x%04X value: 0x%02X\n",addr, target_value);
        target_value = 0xAB;
    }
#else
    // @1bȉ
    nn::Result nnr;
    nnr = nn::cfg::nor::CTR::Read(NOR_RESERVE_TOP, s_readData, FILL_AREA_SIZE);
    if ( nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        result.m_Result = false;
    }

    u32 offset_addr = 0;
    const u8 * ptr = s_readData;
    for ( ; offset_addr < FILL_AREA_SIZE ;ptr++, offset_addr++)
    {
        if ( *ptr != 0xFF)
        {
//            sprintf(result.m_String, " address:0x%04X  is unexpected value: 0x%02X",ptr, *ptr);
            sprintf(result.m_String, " address:0x%04X  is unexpected value: 0x%02X",(u32)(NOR_RESERVE_TOP + offset_addr), *ptr);
            result.m_Micro  = PROCCHK_ERROR_NOR_1F300;
            result.m_Result = false;
            return result.m_Result;
        }
    }

#endif

    return result.m_Result;
}

//
// NA RFU NORtbV
//

//   1: 0x1F300`0x1FDFFԒn0xFFCgsA
//   2: InitNtrSettingĂсA0x1FE00 `0x1FFFFBCRCtB
bool Invoke_ClearRfuNor( uji::seq::TestResult &result )
{
    result.m_Result = true;
    nn::Result nnr;

    //1/2
    std::memset(s_writeData, FILL_VALUE, FILL_AREA_SIZE);

    const u8 * ptr;
    ptr = s_writeData;

    nn::cfg::nor::CTR::Initialize();

    nnr = nn::cfg::nor::CTR::Write(FILL_AREA_OFFSET, ptr, FILL_AREA_SIZE);
    if ( nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        result.m_Micro  = PROCCHK_ERROR_NOR_WRITE;
        result.m_Result = false;
    }

    //2/2
    nn::cfg::CTR::CfgRegionCode cfrc;
    cfrc = uji::sys::GetRegionCode();
    nnr = nn::cfg::nor::CTR::InitNtrSetting(cfrc);
    if ( nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        result.m_Micro  = PROCCHK_ERROR_INIT_NTR_SETTING;
        result.m_Result = false;
    }

    return result.m_Result;
}


//   2: InitNtrSettingĂсA0x1FE00 `0x1FFFFBCRCtB
bool Invoke_InitNtrSetting( uji::seq::TestResult &result )
{
    result.m_Result = true;
    nn::Result nnr;

    nn::cfg::nor::CTR::Initialize();

    //2/2
    nn::cfg::CTR::CfgRegionCode cfrc;
    cfrc = uji::sys::GetRegionCode();
    nnr = nn::cfg::nor::CTR::InitNtrSetting(cfrc);
    if ( nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        result.m_Micro  = PROCCHK_ERROR_INIT_NTR_SETTING;
        result.m_Result = false;
    }

    return result.m_Result;
}


//   ؂s
bool Invoke_ValidateSign( uji::seq::TestResult &result )
{
    result.m_Result = true;
    nn::Result nnr;
    nn::fs::FileInputStream fis;
    s64 fileSize=0;

    nn::cfg::CTR::init::Initialize();

    // [JthR[hV[h
    nnr = nn::cfg::CTR::init::ValidateLocalFriendCodeSeed();
    if ( nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        result.m_Micro  = PROCCHK_ERROR_LOCAL_FRIEND_CODE;
        result.m_Result = false;
        goto FIN;
    }

    // [JthR[hV[h̏Ɠɍ쐬Ă
    // /private/movable.sed ݂Ă邱ƂmF
    nnr = fis.TryInitialize(L"nand:/private/movable.sed");
    if ( nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        result.m_Micro  = PROCCHK_ERROR_MOVABLE_SED;
        result.m_Result = false;
        goto FIN;
    }

    // movable.sed̃t@CTCY0łȂƂmF
    fileSize = fis.GetSize();
    if ( fileSize == 0)
    {
        result.m_Micro  = PROCCHK_ERROR_MOVABLE_SED;
        result.m_Result = false;
        goto FIN;
    }
    fis.Finalize(); //t@C

    nnr = nn::cfg::CTR::init::ValidateLocalFriendCodeSeed();
    if ( nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        result.m_Micro  = PROCCHK_ERROR_LOCAL_FRIEND_CODE;
        result.m_Result = false;
        goto FIN;
    }

    // ZLACtH
    nnr = nn::cfg::CTR::init::ValidateSecureInfo();
    if ( nnr.IsFailure())
    {
        nn::dbg::PrintResult(nnr);
        result.m_Micro  = PROCCHK_ERROR_SECURE_INFO;
        result.m_Result = false;
    }

FIN:
    return result.m_Result;
}

//
// NV[PX̃tOmF
//
bool Invoke_CheckFirstLaunchFlag ( uji::seq::TestResult & result)
{
    result.m_Result = false;

    bit32 key = (( static_cast<bit32>(nn::cfg::CTR::detail::NN_CFG_MENU) << 16 )|
                 ( static_cast<bit32>(nn::cfg::CTR::detail::NN_CFG_MENU_FIRST_LAUNCH)));

    nn::cfg::CTR::detail::FirstLaunchInfoCfgData first;
    nn::Result ret = nn::cfg::CTR::init::GetConfig(&first, sizeof(first), key);

    if(ret.IsSuccess() && (first.mmen == 0))
    {
        result.m_Result = true;
    }

    return result.m_Result;
}

//
// O
//
bool Invoke_WriteProductLog( uji::seq::TestResult &result )
{
    result.m_Result = false;

    // Sequencẽ`FbNR[h擾
    uji::seq::TestListManager  *tlm = new uji::seq::TestListManager;
    int sequenceCheckCode;
    if ( "P-P Check" == PROCCHK_MODE ) { tlm->SetCurrentTestList(TESTLIST_ID_PRE_PROCCHK);}
    if ( "ProcCheck" == PROCCHK_MODE ) { tlm->SetCurrentTestList(TESTLIST_ID_PROCCHK);}
    sequenceCheckCode = tlm->GetCheckCode();

    // Config̃`FbNR[h擾
    uji::seq::Config  *c = new uji::seq::Config;
    int configCheckCode;
    configCheckCode =  c->GetCheckCode();

    // ObZ[W̍쐬
    char message[80+1];
    std::memset(message, 0x00, sizeof(message));
    sprintf(message, "[%s] seq:%04d config:%04d", UJI_REGION, sequenceCheckCode, configCheckCode);

    // OpIuWFNg
    uji::seq::LogResult  lr;
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    lr = pl->Add_1Line(c->Get().TestMode,PROCCHK_MODE, "OK",  VERSION_STRING, "","","",message);
    if (lr == LogResultCode::SUCCESS)
    {
        result.m_Result = true;
    }
    else
    {
        result.m_Micro  = PROCCHK_ERROR_LOG_WRITE;
        result.m_Result = false;
    }

    pl->Finalize();

    delete pl;
    delete c;
    delete tlm;

    return result.m_Result;
}

//--------------------------------------------------------------------
// O̍Ō̃vZX`FbN
//--------------------------------------------------------------------
bool Invoke_CheckProductLogLastProcess( uji::seq::TestResult &result )
{
    result.m_Result = false;

    uji::seq::Config  *c = new uji::seq::Config;

    if ( uji::seq::pl::QC == c->Get().TestMode )
    {
        // QC[hł́AO̍Ō`FbN
        ProcessCheck * pc = new ProcessCheck();
        pc->LogCheck_LastProcessIsProcCheck(result);
        delete pc;
    }
    else
    {
        // QC[hȊOł́AtrueԂ
        result.m_Result = true;
    }

    delete c;

    return result.m_Result;
}

//--------------------------------------------------------------------
// Õf[^݃vÕo[W`FbN
//--------------------------------------------------------------------
bool Invoke_CheckProductLogImportVersion( uji::seq::TestResult &result )
{
    result.m_Result = false;

    ProcessCheck * pc = new ProcessCheck();
    pc->LogCheck_ImportVersion(result);
    delete pc;

    // o[Wŵ̂łȂ΁Ão[WNG\
    if ( false == result.m_Result) { NN_LOG("%s\n", result.m_String);}

    return result.m_Result;
}

//--------------------------------------------------------------------
// Õf[^݃vOA
// RSPo[W̃vCXg[ʎq`FbN
//--------------------------------------------------------------------
bool Invoke_CheckProductLogPreInstallVersion( uji::seq::TestResult &result )
{
    result.m_Result = false;

    ProcessCheck * pc = new ProcessCheck();
    pc->LogCheck_PreInstallVersion(result);
    delete pc;

    // o[Wŵ̂łȂ΁Ão[WNG\
    if ( false == result.m_Result) { NN_LOG("%s\n", result.m_String);}

    return result.m_Result;
}

//--------------------------------------------------------------------
// Õf[^݃vOA
// vCXg[ł邱ƂmF
//--------------------------------------------------------------------
bool Invoke_CheckProductLogNotPreInstalled( uji::seq::TestResult &result )
{
    result.m_Result = false;
    
    ProcessCheck * pc = new ProcessCheck();
    pc->LogCheck_NotPreInstalled(result);
    delete pc;
    
    // vCXg[ĂꍇÃo[WNG\
    if ( false == result.m_Result) { NN_LOG("%s\n", result.m_String);}
    
    return result.m_Result;
}


//---------------------------------------------------------------------
// Ȏ݂`FbN
//---------------------------------------------------------------------
bool Invoke_CheckProductLog( uji::seq::TestResult &result )
{
    result.m_Result = false;

    ProcessCheck * pc = new ProcessCheck();
    pc->LogCheck_Exist(result);
    delete pc;

    // ȂH\
    if ( false == result.m_Result) { NN_LOG("%s\n", result.m_String);}

    return result.m_Result;
}


// std::vectoro^p}N
#define PRODUCT_LOG_CHECK(tester) if ( config->Get().LogCheck_ ## tester & mask) { processArray.push_back(#tester);}

// SĂ̍H`ĂB
// rh^[QbgƂɁAǂ̍H̃O`FbN邩ǂ́AProcessCheck_Define.h ɏW񂷂B

#define ENTRY_LOGCHECK_ALL_PROCESS      PRODUCT_LOG_CHECK(CpuBoard)   \
                                        PRODUCT_LOG_CHECK(SlidePad)   \
                                        PRODUCT_LOG_CHECK(LcdAndKey)  \
                                        PRODUCT_LOG_CHECK(TpCal)      \
                                        PRODUCT_LOG_CHECK(Interface)  \
                                        PRODUCT_LOG_CHECK(Aging)      \
                                        PRODUCT_LOG_CHECK(Wireless)   \
                                        PRODUCT_LOG_CHECK(Shock)      \
                                        PRODUCT_LOG_CHECK(Acc)        \
                                        PRODUCT_LOG_CHECK(Mic)        \
                                        PRODUCT_LOG_CHECK(Gyroscope)  \
                                        PRODUCT_LOG_CHECK(Parallax)   \
                                        PRODUCT_LOG_CHECK(Ocam)       \
                                        PRODUCT_LOG_CHECK(Icam)       \
                                        PRODUCT_LOG_CHECK(DataList)   \
                                        PRODUCT_LOG_CHECK(Sign)       \
                                        PRODUCT_LOG_CHECK(Import)     \
                                        PRODUCT_LOG_CHECK(SpAndTp)    \
                                        PRODUCT_LOG_CHECK(WlAudio)    \
                                        PRODUCT_LOG_CHECK(CamCapture) \
                                        PRODUCT_LOG_CHECK(CamAndIf)

#define ENTRY_LOGCHECK_CPU_BOARD        PRODUCT_LOG_CHECK(CpuBoard)

//
// HO݊mF
//
bool  ProcessCheck::LogCheck_Exist( uji::seq::TestResult &result )
{

    u32 testMode = 0;
    u32 mask = 0;

    // Config̐ݒlLł΁AprocessArrayɓo^
    uji::seq::Config *config = new uji::seq::Config;

        std::vector<std::string> processArray;
        processArray.reserve(40);

        // [h擾
        testMode = config->Get().TestMode;

        switch(uji::sys::GetPlatformType())
        {
            case PLATFORM_CTR:
            {
                if ( uji::seq::pl::LINE  == testMode ) 
                    { mask = MASK_PROCCHK_LOGCHECK_CTR_LINE ;}
                else 
                    { mask = MASK_PROCCHK_LOGCHECK_CTR_QC ;} 
                break;
            }
            case PLATFORM_SPR:
            {
                if ( uji::seq::pl::LINE  == testMode ) 
                    { mask = MASK_PROCCHK_LOGCHECK_SPR_LINE ;}
                else 
                    { mask = MASK_PROCCHK_LOGCHECK_SPR_QC ;} 
                break;
            }
            case PLATFORM_FTR:
            {
                if ( uji::seq::pl::LINE  == testMode ) 
                    { mask = MASK_PROCCHK_LOGCHECK_FTR_LINE ;}
                else 
                    { mask = MASK_PROCCHK_LOGCHECK_FTR_QC ;} 
                break;
            }
            case PLATFORM_KTR:
            {
                if ( uji::seq::pl::LINE  == testMode ) 
                    { mask = MASK_PROCCHK_LOGCHECK_KTR_LINE ;}
                else 
                    { mask = MASK_PROCCHK_LOGCHECK_KTR_QC ;} 
                break;
            }

        }

        // `FbN錟H̓o^
#ifdef LOGCHECK_CPU_BOARD
        ENTRY_LOGCHECK_CPU_BOARD;
#else
        ENTRY_LOGCHECK_ALL_PROCESS;
#endif

        // vZX`FbN̓o^(vvZX`FbNAvZX`FbNj
        if ( config->Get().LogCheck_ProcCheck & mask ) { processArray.push_back(PROCCHK_MODE);}

    delete config;




//  ̎_ŁAprocessArrayɂ́A`FbNH̕񂪓ĂB


    result.m_Result = true;
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog;

        pl->Initialize();

        // processArray̌핶񂪁Aproduct.logɑ݂Ă邩ǂ肷
        std::string missingProcess = "";
        NN_LOG("checking tester num:%d\n", processArray.size());
        int i;
        for(i =0; i < processArray.size() ; i++)
        {
            // processArray[i]vZX`FbN̏ꍇ́ALINÊ
            if (( 0 == strncmp(processArray[i].c_str(), "P-P Check",9)) ||
                ( 0 == strncmp(processArray[i].c_str(), "ProcCheck",9)))
            {
                if ( false == pl->LogTable_LatestLogEntryIsOK(processArray[i].c_str(),LINE))
                {
                    // O݂Ȃ̕m_Resultɉ
                    missingProcess = missingProcess + processArray[i] + " ";
                    result.m_Micro  = PROCCHK_ERROR_LOG_MISS_PROCESS;
                    result.m_Result = false;
                }
            }
            // processArray[i]vZX`FbNȊȌꍇ
            else
            {
                if (true == pl->LogTable_LatestLogEntryIsOK(processArray[i],testMode))
                {
                    // w̌[h̃O΁Aɐi
                }
                else
                {
                    // O݂Ȃ̕m_Resultɉ
                    missingProcess = missingProcess + processArray[i] + " ";
                    result.m_Micro  = PROCCHK_ERROR_LOG_MISS_PROCESS;
                    result.m_Result = false;
                }
            }
        };

        pl->Finalize();

    delete pl;

    // ǂ̌̃OȂ m_ResultɓĂ
    if ( false == result.m_Result ) { sprintf(result.m_String, "==Process Missed!==\n%s", missingProcess.c_str()); }

    return result.m_Result;
}

//
// O`FbN LINE[ȟO̍ŌオvZX`FbNł邩ǂ
//
bool  ProcessCheck::LogCheck_LastProcessIsProcCheck( uji::seq::TestResult &result )
{
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog;

        pl->Initialize();

        int id = -1;
        id = pl->Get_LatestLogEntryIndex(uji::seq::pl::LINE); // LINE[h̍Ō̃O
        if ( -1 == id )
        {
            result.m_Result = false;
            sprintf(result.m_String, "LINE mode Last process is NOT \"ProcCheck\".");
            result.m_Micro  = PROCCHK_ERROR_LOG_LAST_PROCESS;
            goto FIN;
        }

        LogEntry le;
        le = pl->Get_LogEntry(id);

        NN_LOG("id :%d\n", id);
        NN_LOG("testerName :%s\n", le.testerName);
        if (( 0 == strncmp(le.testerName, "P-P Check",9)) ||
            ( 0 == strncmp(le.testerName, "ProcCheck",9)))
        {
            result.m_Result = true;
        }
        else
        {
            result.m_Result = false;
            sprintf(result.m_String, "LINE mode Last process is NOT \"ProcCheck\".\n (%s:%s)",
                                                                 le.testerName, le.state);
            result.m_Micro  = PROCCHK_ERROR_LOG_MISS_PROCESS;

        }

FIN:
        pl->Finalize();

    delete pl;

    return result.m_Result;
}

//
// O`FbN f[^݃vÕo[W`FbN
//
bool  ProcessCheck::LogCheck_ImportVersion( uji::seq::TestResult &result )
{

    // config f[^݃vÕo[W擾
    uji::seq::Config *config = new uji::seq::Config;

        u32 config_ImportVer = 0;
        config_ImportVer = config->Get().ProgramVer_Import ;

    delete config;

    // product.logAf[^݃vÕo[W擾
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog;

        pl->Initialize();

        int id = -1;
        id = pl->Get_LatestLogEntryIndex("Import"); // f[^݂̍ŐVO
        if ( -1 == id )
        {
            result.m_Result = false;
            sprintf(result.m_String, "Import Log is NOT found.");
            result.m_Micro  = PROCCHK_ERROR_LOG_MISS_PROCESS;
            goto FIN;
        }

        LogEntry le;
        le = pl->Get_LogEntry(id);

        NN_LOG("id :%d\n", id);
        NN_LOG("testerName :%s\n", le.testerName);
        NN_LOG("version :[%s] length[%d]\n", le.version, sizeof(le.version));

    //
    // vmF
    //
    char config_ImportVerStr[LOG_VERSION_LEN    +1];
    std::memset(config_ImportVerStr, 0x00, sizeof(config_ImportVerStr));

    // u32̒l 100ŊāAstringɓĔr
    sprintf(config_ImportVerStr, "%d.%02d",(int) (config_ImportVer/100), (int)(config_ImportVer%100));

    if ( 0 == strncmp(config_ImportVerStr, le.version, 5))
    {
            result.m_Result = true;
    }
    else
    {
            result.m_Result = false;
            sprintf(result.m_String, "Import Version is unexpected value: %s\n",le.version);
            result.m_Micro  = PROCCHK_ERROR_LOG_IMPORT_VERSION;
    }

FIN:
        pl->Finalize();

    delete pl;

    return result.m_Result;
}

//
// O`FbN f[^݃vOPreInstallo[W`FbN
//

u32   ProcessCheck::AsciiToU32(char c)
{
    if ((c >= 0x30) && ( c <= 0x39))      // '0''9'̏
    {
        return  (u32)(c - 0x30);
    }
    else if ((c >= 0x41) && ( c <= 0x5a)) // 'A''Z'̏
    {
        return  (u32)(c - 0x37);
    }
    
    return 0;                             // ȊO0ŕԂ
}

bool  ProcessCheck::LogCheck_PreInstallVersion( uji::seq::TestResult &result )
{

    // config f[^݃vÕo[W擾
    uji::seq::Config *config = new uji::seq::Config;
    
    u32 config_PreInstallVer = 0;
    config_PreInstallVer = config->Get().PreInstallVer;

    delete config;


    // product.logAf[^݃vÕo[W擾
    result.m_Result = false;
    string str;
    string strPreInstallVer;
    string::size_type index;

    u32 value = 0;
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog;

    pl->Initialize();

        int id = -1;
        id = pl->Get_LatestLogEntryIndex("DataList"); // f[^Xg̍ŐVO
        if ( -1 == id )
        {
            sprintf(result.m_String, "DataList Log is NOT found.\n");
            result.m_Micro  = PROCCHK_ERROR_LOG_MISS_PROCESS;
            goto FIN;
        }

        LogEntry le;
        le = pl->Get_LogEntry(id);

        NN_LOG("id :%d\n", id);
        NN_LOG("testerName :%s\n", le.testerName);
        NN_LOG("message :[%s] length[%d]\n", le.message, sizeof(le.message));

        str = le.message;
        index = str.find("preInstall:");
        if ( index == string::npos)
        {
            sprintf(result.m_String, "preInstallVer: is NOT found.\n");
            result.m_Micro  = PROCCHK_ERROR_LOG_PREINSTALL_VERSION;
            goto FIN;
        }
        else
        {
            // bZ[W̊mF
            if ( str.size() < (index + 11 + 3) )
            {
                sprintf(result.m_String, "preInstallVer: length is invalid.\n");
                result.m_Micro  = PROCCHK_ERROR_LOG_PREINSTALL_VERSION;
                goto FIN;
            }
            
            strPreInstallVer = str.substr(index+11, 3);
            NN_LOG("%s\n",strPreInstallVer.c_str());
        }

        // configproduct.log̒l̈vmF
        value =  AsciiToU32( strPreInstallVer.at(0))*36*36
               + AsciiToU32( strPreInstallVer.at(1))*36
               + AsciiToU32( strPreInstallVer.at(2));
        NN_LOG("value %d\n",value);

        if ( value == config_PreInstallVer )
        {
            result.m_Result = true;
        }
        else
        {
            sprintf(result.m_String, "preInstallVer: [%s] is unexpected value.\n",strPreInstallVer.c_str());
            result.m_Micro  = PROCCHK_ERROR_LOG_PREINSTALL_VERSION;
        }
 
FIN:
    pl->Finalize();

    delete pl;

    return result.m_Result;
}

bool  ProcessCheck::LogCheck_NotPreInstalled( uji::seq::TestResult &result )
{
    // product.logAf[^݃vÕo[W擾
    result.m_Result = false;
    string str;
    string strPreInstallVer;
    string::size_type index;
    
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog;
    
    pl->Initialize();
    
        int id = -1;
        id = pl->Get_LatestLogEntryIndex("DataList"); // f[^Xg̍ŐVO
        if ( -1 == id )
        {
            sprintf(result.m_String, "DataList Log is NOT found.\n");
            result.m_Micro  = PROCCHK_ERROR_LOG_MISS_PROCESS;
            goto FIN;
        }

        LogEntry le;
        le = pl->Get_LogEntry(id);

        NN_LOG("id :%d\n", id);
        NN_LOG("testerName :%s\n", le.testerName);
        NN_LOG("message :[%s] length[%d]\n", le.message, sizeof(le.message));

        str = le.message;
        index = str.find("preInstall:");
        if ( index == string::npos)
        {
            result.m_Result = true;
            goto FIN;
        }
        else if ( str.size() < (index + 11 + 3) )
        {   // bZ[W̊mF
            sprintf(result.m_String, "preInstallVer: length is invalid.\n");
            result.m_Micro  = PROCCHK_ERROR_LOG_PREINSTALL_VERSION;
            goto FIN;
        } else {
            // G[Ô߂̃vCXg[o[WmF
            strPreInstallVer = str.substr(index+11, 3);
            NN_LOG("%s\n",strPreInstallVer.c_str());
            sprintf(result.m_String, "PreInstalled [%s].\n",strPreInstallVer.c_str());
            result.m_Micro  = PROCCHK_ERROR_LOG_PREINSTALL_VERSION;
            goto FIN;
        }

FIN:
    pl->Finalize();
    delete pl;

    return result.m_Result;
}


//
//  OtBbNX̏s
//
void ProcessCheck::GraphicsInit(char * window_title)
{
    m_WindowManager.CreateWindow(&m_StartupWindow, NN_GX_DISPLAY0, 0, 0);
    m_StartupWindow.SetTitle(window_title);

    // StartMenȕꍇ
    if ( 0 == strncmp(window_title, "Start Menu", 9))
    {
        //dnƂ̊Go
        m_JpegDrawer = new sys::JpegDrawer;
        if ( 0 == strncmp(UJI_REGION, "AUS", 3) ) {m_JpegDrawer->OpenPicture( L"rom:/jpeg/import_aus.jpg" );}
        if ( 0 == strncmp(UJI_REGION, "BRA", 3) ) {m_JpegDrawer->OpenPicture( L"rom:/jpeg/import_bra.jpg" );}
        if ( 0 == strncmp(UJI_REGION, "CHN", 3) ) {m_JpegDrawer->OpenPicture( L"rom:/jpeg/import_chn.jpg" );}
        if ( 0 == strncmp(UJI_REGION, "EUR", 3) ) {m_JpegDrawer->OpenPicture( L"rom:/jpeg/import_eur.jpg" );}
        if ( 0 == strncmp(UJI_REGION, "UKV", 3) ) {m_JpegDrawer->OpenPicture( L"rom:/jpeg/import_eur.jpg" );}
        if ( 0 == strncmp(UJI_REGION, "JPN", 3) ) {m_JpegDrawer->OpenPicture( L"rom:/jpeg/import_jpn.jpg" );}
        if ( 0 == strncmp(UJI_REGION, "KOR", 3) ) {m_JpegDrawer->OpenPicture( L"rom:/jpeg/import_kor.jpg" );}
        if ( 0 == strncmp(UJI_REGION, "TWN", 3) ) {m_JpegDrawer->OpenPicture( L"rom:/jpeg/import_twn.jpg" );}
        if ( 0 == strncmp(UJI_REGION, "USA", 3) ) {m_JpegDrawer->OpenPicture( L"rom:/jpeg/import_usa.jpg" );}
    }

    // QRR[h̏ꍇ
    if ( 0 == strncmp(window_title, "QR", 2))
    {
        m_JpegDrawer = new sys::JpegDrawer;
        m_JpegDrawer->OpenPicture( L"rom:/jpeg/BarcodeScanner.jpg" );

        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
        m_StartupWindow.Printf("\n");
            char serNo[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN];
            std::memset(serNo, 0x00, sizeof(serNo));
            GetSerialNumber(serNo);
        m_StartupWindow.Printf("            CTR SerialNumber:[%s]\n",serNo);
    }

}

//
//  OtBbNX̏Is
//
void ProcessCheck::GraphicsFinalize(int types)
{
    if (( types != TYPE_NOUSE_JPEG) && (types != TYPE_UPPER_QR))
    {
        m_JpegDrawer->ClosePicture();
        delete m_JpegDrawer;
    }
}


void ProcessCheck::GraphicsUpdate(int types)
{
    UpdateMainLcd (types);

	if (types != TYPE_UPPER_QR )
	{
    	UpdateSubLcd  (types);
	}

    UpdateLcd();
}



// Startupʂ쐬
void ProcessCheck::CreateStartupWindow(void)
{
    // ʏ㕔̃bZ[W
    m_StartupWindow.Printf("%s\n", PROCCHK_STARTUP_MSG);
    m_StartupWindow.Printf("\n\n");

    // Omakefileł̒`(F)
    m_StartupWindow.Printf("UJI_REGION     :[%s]\n",    UJI_REGION);
    m_StartupWindow.Printf("APPVER         :[%s]\n",VERSION_STRING);
    m_StartupWindow.Printf("PROCCHK_MODE   :[%s]\n",  PROCCHK_MODE);

    // Platform̏ (cfgCuEĂ)
    // vvZX`FbNŎgp邽߁AȂĂ擾ł̂gp
    m_StartupWindow.Printf("BONDING OPTION :[%d]\n", uji::sys::GetBondingOption());

    // VAio[̎擾
    char serNo[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN];
    std::memset(serNo, 0x00, sizeof(serNo));
    uji::sys::GetSerialNumber(serNo);
    m_StartupWindow.Printf("SERIAL NUMBER  :[%s]\n",  serNo);

    // RegionCode̎擾
    m_StartupWindow.Printf("REGION_CODE    :[%d]\n",   uji::sys::GetRegionCode());
}


u8* ProcessCheck::GetTextureDataFromRawData(const u32& width,
                                               const u32& height,
                                               u8* rawDataBuffer,
                                               u32& textureWidth,
                                               u32& textureHeight)
{
    textureWidth = GetTextureLength(width);
    textureHeight = GetTextureLength(height);
    u32 textureSize = textureWidth * textureHeight * 3;
    u8* textureGLDataBuffer = reinterpret_cast<u8*>(uji::sys::Alloc(textureSize));
    u8* dstPtr = textureGLDataBuffer;

    u32 y = 0;
    for (; y < height; y++) {
#if 0
        u8* srcPtr = rawDataBuffer + width * y * 3;
#else
        // FLIPΉ
        // ConvertGLTextureToNative()ɂFLIPĂB
        u8* srcPtr = rawDataBuffer + width * (height - y - 1) * 3;
#endif
        u32 x = 0;
        for (; x < width; x++) {
            dstPtr[0] = srcPtr[2];
            dstPtr[1] = srcPtr[1];
            dstPtr[2] = srcPtr[0];
            dstPtr += 3;
            srcPtr += 3;
        }
        for (; x < textureWidth; x++) {
            dstPtr[0] = dstPtr[1] = dstPtr[2] = 0x00;
            dstPtr += 3;
        }
    }
    for (; y < textureHeight; y++) {
        for (u32 x = 0; x < textureWidth; x++) {
            dstPtr[0] = dstPtr[1] = dstPtr[2] = 0x00;
            dstPtr += 3;
        }
    }

    u8* textureDataBuffer = reinterpret_cast<u8*>(uji::sys::Alloc(textureSize));
    GLenum format = GL_RGB_NATIVE_DMP;
    bool result = demo::ConvertGLTextureToNative(format, textureWidth, textureHeight,
                                                 textureGLDataBuffer, textureDataBuffer);
    if (!result) {
        NN_LOG("  Convert to GL_RGB_NATIVE_DMP failed.\n");
        NN_ASSERT(0);
    }
    uji::sys::Free(reinterpret_cast<void*>(textureGLDataBuffer));

    return textureDataBuffer;
}


// QRR[h쐬
const char* const QR_OUTPUT_FILENAME_TEMPLATE = "sdmc:/QR.bmp";
void ProcessCheck::CreateQRCode(void)
{
    char qrData[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN];
    std::memset(qrData, 0x00, sizeof(qrData));
    GetSerialNumber(qrData);

    QREncoder *encoder = new QREncoder;
    u32 dataSize = std::strlen(qrData);

    u32 memorySize = QREncoder::GetEncodeBufferSize(dataSize, 3, 1); // cell_size=3, count=1

    void * buffer = NULL;
    buffer = uji::sys::Alloc(memorySize);
    if ( NULL == buffer )
    {
        NN_LOG("memory allocate error!\n");
        return;
    }
    encoder->InitMemory(buffer, memorySize);

    /* 쐬QRR[h̏ݒ */
    EncodeData info;
    info.version   = 12;
    info.ecc_level = ECC_LEVEL_H;
    info.size      = dataSize;
    info.data      = reinterpret_cast<u8*>(const_cast<char*>(qrData));
    info.total     = 0;
    info.cell_size = 3;

    /* GR[hs */
    if ( !encoder->Encode(&info))
    {
        NN_LOG("QR encode failed...\n");
        uji::sys::Free(buffer);
        return;
    }

    int count = encoder->GetDivCount();
    NN_LOG(" DivCount %d\n",count);

    int size = encoder->GetQRSize(0, true);
    NN_LOG(" QRSize %d\n",size);

    u8* bmp_data = reinterpret_cast<u8*>(uji::sys::Alloc(size));
    if (!bmp_data)
    {
        NN_LOG("Memory allocation failed...\n");
    }

    if (encoder->GetQRBMPData(bmp_data, size, 0))
    {
#if 0
        nn::fs::MountSdmc();
            char file_name[32];
            std::sprintf(file_name, QR_OUTPUT_FILENAME_TEMPLATE);
            nn::fs::FileOutputStream fos;
            fos.Initialize(file_name, true);
            fos.SetSize(size);
            if (fos.Write(bmp_data, size) != size) {
                NN_LOG("File save failed...\n");
            }
            fos.Finalize();
        nn::fs::Unmount("sdmc:");
#endif
    }

    int qrSize = encoder->GetQRSize(0, true);

    ImageInfo QRImage;
    u8 * rgb888DataPtr = reinterpret_cast<u8*>(uji::sys::Alloc(qrSize));
    if ( NULL == rgb888DataPtr )
    {
        NN_LOG("Memory allocation failed...\n");
    }

    QRImage.rgb888Data = rgb888DataPtr;
    encoder->GetQRData(&QRImage, 0);

    NN_LOG("QRImage.width %d\n", QRImage.width);
    NN_LOG("QRImage.height %d\n",QRImage.height);
    u32 width = QRImage.width;
    u32 height = QRImage.height;

// BMPeNX` 
    m_BmpQR = new sys::BmpTexture();
#if 1
    m_BmpQR->FakeLoad(bmp_data);
#else
//    m_BmpQR->Open(L"rom:/bmp/gyro_YAxisTest.bmp");//\ł
//    m_BmpQR->Open(L"rom:/bmp/QR.bmp");//\łȂB
#endif

    if (m_TextureIdQR != 0)
    {
        NN_LOG("m_TextureIdBottom !=0 \n");
        m_gfx->m_DrawFramework->DeleteTexture(m_TextureIdQR );
    }

    u32 textureWidth = width;
    u32 textureHeight = height;
    u8* textureDataBuffer = GetTextureDataFromRawData(width, height,
                                                      QRImage.rgb888Data,
                                                      textureWidth,
                                                      textureHeight);

    m_gfx->m_DrawFramework->GenerateTexture(GL_TEXTURE_2D,
                                            m_BmpQR->INTERNAL_FORMAT,
                                            textureWidth,
                                            textureHeight,
                                            m_BmpQR->FORMAT,
                                            m_BmpQR->TYPE,
                                            textureDataBuffer,
                                            m_TextureIdQR);

    delete encoder;

    uji::sys::Free(rgb888DataPtr);
    uji::sys::Free(buffer);
    uji::sys::Free(bmp_data);

}


void ProcessCheck::OpenBmpSubLcd(const wchar_t *fileName)
{
    m_BmpBottom = new sys::BmpTexture();
    m_BmpBottom->Open(fileName);

    if (m_TextureIdQR != 0)
    {
        m_gfx->m_DrawFramework->DeleteTexture(m_TextureIdQR );
    }

    m_gfx->m_DrawFramework->GenerateTexture(GL_TEXTURE_2D,
                                            m_BmpBottom->INTERNAL_FORMAT,
                                            m_BmpBottom->GetTextureWidth(),
                                            m_BmpBottom->GetTextureHeight(),
                                            m_BmpBottom->FORMAT,
                                            m_BmpBottom->TYPE,
                                            m_BmpBottom->GetTextureDataPointer(),
                                            m_TextureIdQR);
}


// QRR[h\
void ProcessCheck::ShowQRCode()
{
#if 1
    m_gfx->m_DrawFramework->FillTexturedRectangle(  m_TextureIdQR,
                                                    120.0f, 40.0f, 160.0f, 160.0f,
                                                    m_BmpQR->GetBmpWidth(),
                                                    m_BmpQR->GetBmpHeight(),
                                                    m_BmpQR->GetTextureWidth(),
                                                    m_BmpQR->GetTextureHeight() );
#else
    m_gfx->m_DrawFramework->FillTexturedRectangle(  m_TextureIdQR,
                                                    140.0f, 60.0f, 120.0f, 120.0f,
                                                    m_BmpQR->GetBmpWidth(),
                                                    m_BmpQR->GetBmpHeight(),
                                                    m_BmpQR->GetTextureWidth(),
                                                    m_BmpQR->GetTextureHeight() );
#endif
}

void ProcessCheck::ShowBmpSubLcd()
{
    m_gfx->m_DrawFramework->FillTexturedRectangle(  m_TextureIdBottom,
                                                    0.0f, 0.0f, 320.0f, 240.0f,
                                                    m_BmpBottom->GetBmpWidth(),
                                                    m_BmpBottom->GetBmpHeight(),
                                                    m_BmpBottom->GetTextureWidth(),
                                                    m_BmpBottom->GetTextureHeight() );
}
void ProcessCheck::UpdateMainLcd(int type)
{
    m_gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    m_gfx->m_DrawFramework->Clear();
    m_gfx->SetScreenSize(m_gfx->DISPLAY0_WIDTH, m_gfx->DISPLAY0_HEIGHT);

    if (( type == TYPE_QRCODE ) || ( type == TYPE_UPPER_QR) )
    {
        ShowQRCode();
    }

    m_WindowManager.Update();
    m_WindowManager.DrawDisplay0();
    m_gfx->m_DrawFramework->SwapBuffers();
    m_gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

void ProcessCheck::UpdateSubLcd(int types)
{
    m_gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    m_gfx->m_DrawFramework->Clear();
    m_gfx->SetScreenSize(m_gfx->DISPLAY1_WIDTH, m_gfx->DISPLAY1_HEIGHT);

    if (( types != TYPE_NOUSE_JPEG ) && ( types != TYPE_UPPER_QR ))
    {
        m_JpegDrawer->DrawPicture(NN_GX_DISPLAY1);
    }

    m_WindowManager.Update();
    m_WindowManager.DrawDisplay1();
}

void ProcessCheck::UpdateLcd(void)
{
    m_gfx->m_DrawFramework->SwapBuffers();
    m_gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}


// j[p
void ProcessCheck::Menu1(void)
{
    uji::seq::TestResult tr;
    Invoke_ValidateSign(tr);

    ProcessCheck * pc = new ProcessCheck();
    pc->GraphicsInit("ProcessCheck");

    if ( tr.m_Result )
    {
        pc->m_StartupWindow.Printf(" VALIDATE SIGN: [%s]\n", "OK");
    }
    else
    {
        pc->m_StartupWindow.Printf(" VALIDATE SIGN: [%s]\n", "NG");
    }

    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();
        pc->GraphicsUpdate(TYPE_NOUSE_JPEG);

    } while(!pad.IsButtonDown(uji::sys::Pad::BUTTON_B));

    pc->GraphicsFinalize(TYPE_NOUSE_JPEG);
    delete pc;

}

void ProcessCheck::Menu2(void)
{
    uji::seq::TestResult tr;
    Invoke_ClearRfuNor(tr);

    ProcessCheck * pc = new ProcessCheck();
    pc->GraphicsInit("ProcessCheck");

    if ( tr.m_Result )
    {
        pc->m_StartupWindow.Printf(" CLEAR RFU NOR: [%s]\n", "OK");
    }
    else
    {
        pc->m_StartupWindow.Printf(" CLEAR RFU NOR: [%s]\n", "NG");
    }

    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();
        pc->GraphicsUpdate(TYPE_NOUSE_JPEG);

    } while(!pad.IsButtonDown(uji::sys::Pad::BUTTON_B));

    pc->GraphicsFinalize(TYPE_NOUSE_JPEG);
    delete pc;

}

void ProcessCheck::Menu3(void)
{
    uji::seq::TestResult tr;
    Invoke_CheckRfuNor(tr);

    ProcessCheck * pc = new ProcessCheck();
    pc->GraphicsInit("ProcessCheck");

    if ( tr.m_Result )
    {
        pc->m_StartupWindow.Printf(" CHECK RFU NOR: [%s]\n", "OK");
    }
    else
    {
        pc->m_StartupWindow.Printf(" CHECK RFU NOR: [%s]\n", "NG");
    }

    pc->m_StartupWindow.Printf("\n%s", tr.m_String);


    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();
        pc->GraphicsUpdate(TYPE_NOUSE_JPEG);

    } while(!pad.IsButtonDown(uji::sys::Pad::BUTTON_B));

    pc->GraphicsFinalize(TYPE_NOUSE_JPEG);
    delete pc;

}


void ProcessCheck::Menu4(void)
{
    uji::seq::TestResult tr;
    Invoke_InitNtrSetting(tr);

    ProcessCheck * pc = new ProcessCheck();
    pc->GraphicsInit("ProcessCheck");

    if ( tr.m_Result )
    {
        pc->m_StartupWindow.Printf(" InitNtrSetting: [%s]\n", "OK");
    }
    else
    {
        pc->m_StartupWindow.Printf(" InitNtrSetting: [%s]\n", "NG");
    }

    pc->m_StartupWindow.Printf("\n%s", tr.m_String);


    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();
        pc->GraphicsUpdate(TYPE_NOUSE_JPEG);

    } while(!pad.IsButtonDown(uji::sys::Pad::BUTTON_B));

    pc->GraphicsFinalize(TYPE_NOUSE_JPEG);
    delete pc;

}




}//namespace procchk
}//namespace eva
}//namespace uji
