

#include "EvaNand.h"

using namespace uji;
using namespace uji::sys;

namespace uji {
namespace eva {

/*---------------------------------------------------------------------------
  Desc: NAND CID WX^̒lԂ܂
---------------------------------------------------------------------------*/
void EvaGetNandCid()
{
    u8 nandCid[CID_SIZE];
    string nandCidString1 = "CID: ";
    string nandCidString2 = "     ";
    string retString      = "Test_GetNandCid: ";
    string warningMsg     = "";
    uji::sys::Pad pad;
    
    nn::Result result = nn::fs::GetNandCid(nandCid, 
                                           sizeof(nandCid));
    if (result.IsFailure())
    {
        warningMsg += "Couldn't get NAND CID!";
        retString  += "FALSE";
    }
    else
    {
        for(int i=0; i<CID_SIZE; ++i)
        {
            char nandCidAscii[4];
            sprintf(nandCidAscii, "%02X ", nandCid[i]);
            if(i < (CID_SIZE>>1)) nandCidString1 += static_cast<string>( nandCidAscii );
            else                  nandCidString2 += static_cast<string>( nandCidAscii );
        }
        retString += "TRUE";
    }

    NN_LOG("------------------------------------------------\n");
    NN_LOG("%s\n", nandCidString1.c_str());
    NN_LOG("%s\n", nandCidString2.c_str());
    NN_LOG("%s\n", retString.c_str());
    NN_LOG("%s\n", warningMsg.c_str());
    NN_LOG("------------------------------------------------\n");
    
    do
    {
        pad.UpdatePad();
        
        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     %s\n", nandCidString1.c_str());
        Menu::m_SubWindow->Printf("     %s\n", nandCidString2.c_str());
        Menu::m_SubWindow->Printf("     %s\n", retString.c_str());
        Menu::m_SubWindow->Printf("     %s\n", warningMsg.c_str());
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        
        sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        sys::Menu::m_WindowManager.Update();
        sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();        
        sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
        
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}

/*---------------------------------------------------------------------------
  Desc: NAND CID Product revision
---------------------------------------------------------------------------*/
void EvaGetNandCidPrv()
{
    u8 nandCidPrv[2];
    uji::sys::Pad pad;
    nand::TestNand* pTn = new nand::TestNand;
    
    nandCidPrv[0] = pTn->GetNandCidPrv();
    nandCidPrv[1] = 0x00;
    
    delete pTn;
    
    for(int i=0; i<2; ++i)
    {
    	NN_LOG("%d: %3x, %3d\n", i, nandCidPrv[i], nandCidPrv[i]);
    }
    
    NN_LOG("\n");
    
    do
    {
        pad.UpdatePad();
        
        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - CID Resistor PRV - \n");
        Menu::m_SubWindow->Printf("     %02X %02X\n", nandCidPrv[1], nandCidPrv[0]);
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        
        sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        sys::Menu::m_WindowManager.Update();
        sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();        
        sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
        
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}

/*---------------------------------------------------------------------------
  Desc: NAND ]j[
---------------------------------------------------------------------------*/
void OpenNandMenu()
{
    ClassMenu *m = new ClassMenu( "Nand Menu" );

    m->Add( " CID Output  ", EvaGetNandCid );
    m->Add( " CID PRV Read", EvaGetNandCidPrv );
    m->Open();

    delete m;
}

} // namespace eva
} // namespace uji
