/************************************************************************

  {̏擾(ꏊAt@C)

 *************************************************************************/
#include "TestReentry.h"
#include "../sec/cal/TestCal.h"
#include "../eva/import/Import.h"
#include "../eva/import/TestExecuteImport.h"
#include "../eva/backup/TestBackup.h"
#include "TestExtractCpuBoard.h"
#include "../seq/config.h"
#include "../seq/TesterLog/ProductionLog.h"

#include <nn/drivers/cal/CTR/cal_Api.h>

bool uji::eva::TestReconstructLogForReentry( uji::seq::TestResult &testResult )
{
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog;
    
    if(pl->Initialize() != uji::seq::LogResultCode::SUCCESS )
    {
        testResult.m_Result = false;
        goto END;
    }
    if(pl->LogTable_ReconstructForReentry() != uji::seq::LogResultCode::SUCCESS )
    {
        testResult.m_Result = false;
        goto END;
    }
    if( pl->Finalize() != uji::seq::LogResultCode::SUCCESS )
    {
        testResult.m_Result = false;
        goto END;
    }
    
    testResult.m_Result = true;
    
    END:
    delete pl;
    return testResult.m_Result;
}

bool uji::eva::IsReentryCheck()
{
    // LINE[hȊOŎsꂽꍇ͍ēsȂB
    // SP&TPɂQC[h͂܂񂪔Ô
    uji::seq::Config config;
    if( config.Get().TestMode != uji::seq::pl::LINE )
    {
        return false;
    }
    
    nn::drivers::cal::CTR::Calibration calibration;
    calibration.Initialize();
    
    // obNCg̃ftHgCALsĂꍇ(LCD&Key̖`ŏ)͍ēsB
    if( calibration.IsAdjusted( nn::drivers::cal::CTR::CAL_DATA_BL_PWM ) )
    {
        return true;
    }
    
    // O̍Ō̍ڂuCpuBoardvuAPP_IvuSpAndTpvȊO͍̎ēsB
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog; 
    pdl->Initialize();
    
    int logNum = pdl->Get_LogEntryNums();
    uji::seq::LogEntry lE;
    
    bool isLogExist = false;
    for( int i = 0; i < logNum; i++ )
    {
        lE = pdl->Get_LogEntry( i );
        if( 0 != std::strcmp( lE.testerName, "CpuBoard" ) && 0 != std::strcmp( lE.testerName, "App_I") && 0 != std::strcmp( lE.testerName, "SpAndTp"))
        {
            isLogExist = true;
        }
    }
    
    pdl->Finalize();
    delete pdl;
    
    if( isLogExist )
    {
        return true;
    }else
    {
        return false;
    }
    
    
}

bool uji::eva::TestReentry( uji::seq::TestResult &testResult )
{
    if( !uji::eva::IsReentryCheck())
    {
        testResult.m_Result = true;
        return testResult.m_Result;
    }
    
    if( !uji::eva::TestReconstructLogForReentry( testResult ) )
    {
        strcat( testResult.m_String, "\nTestExtractCpuAndAppImporter" );
        return testResult.m_Result;
    }
    
    if( !uji::sec::cal::TestBackUpRtcCalAndWriteStartLog( testResult ) )
    {
        strcat( testResult.m_String, "\nTestBackUpRtcCalAndWriteStartLog" );
        return testResult.m_Result;
    }
    
    if( !uji::sec::cal::TestEraseCal( testResult ) )
    {
        strcat( testResult.m_String, "\nTestEraseCal" );
        return testResult.m_Result;
    }
    
    if( !uji::sec::cal::TestRestoreRtcCal( testResult ) )
    {
        strcat( testResult.m_String, "\nTestRestoreRtcCal" );
        return testResult.m_Result;
    }
    
    if( !uji::sec::cal::TestConfirmCalInitialized( testResult ) )
    {
        strcat( testResult.m_String, "\nTestConfirmCalInitialized" );
        return testResult.m_Result;
    }
    
    if( !uji::eva::import::TestExecuteResetSetting( testResult ) )
    {
        strcat( testResult.m_String, "\nTestExecuteResetSetting" );
        return testResult.m_Result;
    }
    
    return testResult.m_Result;

}
