/************************************************************************

  {̏擾(ꏊAt@C)

 *************************************************************************/
#include "TestHWInfo.h"
#include <nn/cfg/CTR/detail/cfg_LocalFriendCodeSeed.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/ps/CTR/ps_API.h>
#include <nn/ps/CTR/ps_Parameters.h>

using namespace uji::sys;
using namespace uji::seq;
using namespace nn::cfg::CTR;
using namespace nn::cfg::CTR::init;
using namespace nn::cfg::CTR::detail;

bool uji::eva::TestGetUid( TestResult &testResult )
{
#if 1
    nn::Result r; 
    bit32 deviceId = 0;
	const u8 DEVICE_ID_LEN = 8;
    
    // PSZbV
    r = nn::ps::CTR::Initialize();
    if ( r.IsFailure())
    {
        NN_LOG("Initialize failed.\n");
        nn::dbg::PrintResult(r);
        return false;
    }
    
    // foCXID擾
    r = nn::ps::CTR::GetDeviceId(&deviceId);
    if ( r.IsFailure())
    {
        NN_LOG("GetDeviceId failed.\n");
        nn::dbg::PrintResult(r);
        return false;
    }

    // argɊi[ 
    char  arg[DEVICE_ID_LEN +1];
    std::memset(arg, 0x00, sizeof(arg));
    sprintf(arg, "%08X", deviceId);
    NN_LOG("arg: [%s]\n",arg);
    
	//argtestResult.m_Stringɏo
	std::sprintf( testResult.m_String,"%s",arg);
    
    // psZbVj
    r = nn::ps::CTR::Finalize();
    if ( r.IsFailure())
    {
        NN_LOG("GetDeviceId failed.\n");
        nn::dbg::PrintResult(r);
    }

    testResult.m_Result = true;
    
#else

// DP2̎bΉ ([JthR[h擾)
    u8 * u8DispPtr;
       
	nn::cfg::CTR::detail::LocalFriendCodeSeedBody lfcsb;
	nn::cfg::CTR::detail::LocalFriendCodeSeedBody * lfcsbPtr;
	lfcsbPtr = &lfcsb;
	
	// LocalFriendCodeSeedBody擾
	nn::cfg::CTR::init::GetLocalFriendCodeSeedBody(lfcsbPtr, true); //hardware resettrue
    u8DispPtr =  reinterpret_cast<u8 *>(lfcsbPtr);	
    NN_LOG(" LocalFriendCodeSeedBody:\n  ");
	for(int i=0; i < 16; i++)
    {
        if ( i == 8 ) NN_LOG("\n  ");
        
        NN_LOG("%02X ", *u8DispPtr);
        u8DispPtr++;
    }
    NN_LOG("\n");

    //LocalFriendCodeSeedBody=16oCg
	NN_LOG("sizeof LocalFriendCodeSeedBody:%d\n",  sizeof(lfcsb));

    //arg𐶐
    char arg[32];
    std::memset(arg,      0x00, sizeof(arg));
    u8DispPtr =  reinterpret_cast<u8 *>(lfcsbPtr);
    for(int i=0; i < 16; i++)
    {

        NN_LOG("%02X ", *u8DispPtr);
        sprintf(arg+i*2, "%02X", *u8DispPtr);
        u8DispPtr++;
    }
    NN_LOG("\n");
    NN_LOG("arg: [%s]\n",arg);
 
	//argtestResult.m_Stringɏo
	std::sprintf( testResult.m_String,"%s",arg);
                  
    testResult.m_Result = true;
#endif    
    
    return testResult.m_Result;
}


bool uji::eva::TestGetMacAddress( TestResult &testResult )
{
    bit8 mac[ nn::uds::MAC_ADDRESS_SIZE ];
    
    if( !uji::sys::TryGetMacAddress( mac ))
    {
        std::sprintf( testResult.m_String, "Fail to Get Mac Address\n" );
        testResult.m_Result = false;
    }
    else
    {
        std::sprintf( testResult.m_String, "Mac=%02X-%02X-%02X-%02X-%02X-%02X",
                      mac[0], mac[1], mac[2], mac[3], mac[4], mac[5] );
        testResult.m_Result = true;
#ifdef EVA_BOARD
        // ̏ꍇAMACAhXłNGƂĒe
        if( testResult.m_String == "Mac=FF-FF-FF-FF-FF-FF" || testResult.m_String == "Mac=00-03-7F-00-00-00" )
        {
            testResult.m_Result = false;
        }
#endif
    }
    return testResult.m_Result;
}
