/*--------------------------------------------------------------------------*
 Project:
 File: mic_TesterRegister.h

*--------------------------------------------------------------------------*/

#ifndef __TEST_MIC_TESTER_REGISTER_H__
#define __TEST_MIC_TESTER_REGISTER_H__


#define MIC_TESTERCONTROL_DEBUGFLAG     0


#include <nn.h>

#if MIC_TESTERCONTROL_DEBUGFLAG
#include <string>
using namespace std;
#endif


namespace uji {
namespace eva {

#if MIC_TESTERCONTROL_DEBUGFLAG
    static string s_strBuffer = "";
#endif


// 탂[h
typedef enum
{
    MIC_MODE_CALIBRATION    = 0x00,
    MIC_MODE_TEST           = 0x01
}
MICTesterMode;


// o̓xύXv
typedef enum
{
    CALIB_REQ_COMPLETE = 0x00,
    CALIB_REQ_INCREASE = 0x01,
    CALIB_REQ_DECREASE = 0x02,
    CALIB_REQ_MAX = CALIB_REQ_DECREASE
}
MICTesterCalibLevelReq;

// Mo
const bool MIC_OUTPUT_OFF   = false;
const bool MIC_OUTPUT_ON    = true;

// gI/o̓xݒ
const bool MIC_SETUP_NONE   = false;
const bool MIC_SETUP_OK     = true;

// M\tO
const bool MIC_SMP_RQ_PROHIBITION = false;
const bool MIC_SMP_RQ_POSSIBLE    = true;

// ~XCb`CxgtO
const bool MIC_EVENT_NO     = false;
const bool MIC_EVENT_OCCUR  = true;

// gݒ
typedef u8 MICTesterFreq;


// Xe[^X
typedef union {
    u8 raw;
    struct
    {
        u8 MODE         :   1;  //rbgtB[h(1bit)
        u8 STOP_EVENT   :   1;
        u8 SETUP        :   1;
        u8 SMP_RQ       :   1;
        u8 ERR          :   4;
    };
} MICTesterStatus;


// ʃR[h
typedef enum
{
    MICI_RESULT_SUCCESS                       = 0x00000000, // OK
    MICI_RESULT_STATUS_ERROR_FATAL            = 0x00010000,
    MICI_RESULT_STATUS_ERROR_TIMEOUT          = 0x00020000,
    MICI_RESULT_STATUS_ERROR_SETUP            = 0x00040000,
    MICI_RESULT_STATUS_ERROR_SMP_RQ           = 0x00080000,
    MICI_RESULT_STATUS_ERROR_CALIB_NOCOMP     = 0x00100000,
    MICI_RESULT_ILLEGAL_PARAM                 = 0x80000000
}
MICIResultCode;


// \IȎg̐ݒl`
const bit32 MIC_TESTER_FSEL_4kHz   = 0x01;
const bit32 MIC_TESTER_FSEL_1kHz   = 0x07;
const bit32 MIC_TESTER_FSEL_200kHz = 0x27;

// ^CvʗpID
const bit32 MIC_TESTER_TYPE_CTR = 0x3D;

const u32 TESTER_W_ADDR_MAX = 0x0006;
const u32 TESTER_R_ADDR_MAX = 0x0001;
const s16 ACCESS_DATA_SIZE = 1;

//============================================================================
//============================================================================
//                     WRITEWX^
//============================================================================
//============================================================================
// o͎gI
const u32 MIC_REGSPI_W_FREQ_ADDR                = 0x00000000;
const bit32 MIC_REGSPI_W_FREQ_MASK              = 0xff;

// Lu[VID
const u32 MIC_REGSPI_W_CALIBRATION_ID_ADDR      = 0x00000001;
const bit32 MIC_REGSPI_W_CALIBRATION_ID_MASK    = 0xff;

// Lu[Vo̓xύXv
const u32 MIC_REGSPI_W_CALIB_LEVEL_CTRL_ADDR    = 0x00000003;
const bit32 MIC_REGSPI_W_CALIB_LEVEL_CTRL_MASK  = 0x03;

// g`o
const u32 MIC_REGSPI_W_WAVE_OUT_ADDR            = 0x00000005;
const bit32 MIC_REGSPI_W_WAVE_OUT_MASK          = 0x01;

// ėpWX^
const u32 MIC_REGSPI_W_GENERAL_ADDR             = 0x00000006;
const bit32 MIC_REGSPI_W_GENERAL_MASK           = 0xff;

//============================================================================
//============================================================================
//                     READWX^
//============================================================================
//============================================================================

/*---------------------------------------------------------------------------*
    Xe[^X
*---------------------------------------------------------------------------*/
const u32 MIC_REGSPI_R_STATUS_ADDR              = 0x00000000;
const s16 MIC_REGSPI_R_STATUS_MODE_SHIFT        = 0;    // 샂[h
const s16 MIC_REGSPI_R_STATUS_STOP_EVENT_SHIFT  = 1;    // ~tO
const s16 MIC_REGSPI_R_STATUS_SETUP_SHIFT       = 2;    // gI/o̓xݒ
const s16 MIC_REGSPI_R_STATUS_SMP_RQ_SHIFT      = 3;    // M\tO
const s16 MIC_REGSPI_R_STATUS_ERROR_B0_SHIFT    = 4;    // G[rbg B0
const s16 MIC_REGSPI_R_STATUS_ERROR_B1_SHIFT    = 5;    // G[rbg B1
const s16 MIC_REGSPI_R_STATUS_ERROR_B2_SHIFT    = 6;    // G[rbg B2
const s16 MIC_REGSPI_R_STATUS_ERROR_B3_SHIFT    = 7;    // G[rbg B3
const s16 MIC_REGSPI_R_STATUS_ERROR_CODE_SHIFT  = 4;    // G[R[h
const bit32 MIC_REGSPI_R_STATUS_MASK            = 0x01;

/*---------------------------------------------------------------------------*
    G[e
*---------------------------------------------------------------------------*/
const bit32 MIC_REGSPI_R_STATUS_ERROR_CALIBRATION   = 0x01; // Lu[VG[
const bit32 MIC_REGSPI_R_STATUS_ERROR_PARAMETER     = 0x10; // p[^s
const bit32 MIC_REGSPI_R_STATUS_ERROR_COMMUNICATION = 0x11; // ʐMt[s

/*---------------------------------------------------------------------------*
    ėpWX^
*---------------------------------------------------------------------------*/
const u32 MIC_REGSPI_R_GENERAL_ADDR             = 0x00000001;
const s16 MIC_REGSPI_R_GENERAL_SHIFT            = 0;
const bit32 MIC_REGSPI_R_GENERAL_MASK           = 0xff; 


//============================================================================
//============================================================================
//                     탌WX^NX
//============================================================================
//============================================================================
class MicTesterReg
{
#if MIC_TESTERCONTROL_DEBUGFLAG
void OutputStatus(MICTesterStatus& status)
{
    char bufMODE[10];
    char bufSTEV[10];
    char bufSETU[10];
    char bufSMRQ[10];
    char bufERRO[10];
    sprintf(bufMODE, "MO(%01X)", status.MODE);
    sprintf(bufSTEV, "SE(%01X)", status.STOP_EVENT);
    sprintf(bufSETU, "SU(%01X)", status.SETUP);
    sprintf(bufSMRQ, "RQ(%01X)", status.SMP_RQ);
    sprintf(bufERRO, "ER(%01X)\n", status.ERR);
    s_strBuffer += bufMODE;
    s_strBuffer += bufSTEV;
    s_strBuffer += bufSETU;
    s_strBuffer += bufSMRQ;
    s_strBuffer += bufERRO;
}
#endif

public:
    MicTesterReg(int clock=CLOCK_4M_HZ);
    virtual ~MicTesterReg();

    /*------------------------------------------------------------------------
        Desc: NbN̎擾
    ------------------------------------------------------------------------*/
    enum {
        CLOCK_512K_HZ = 0,
        CLOCK_1M_HZ,
        CLOCK_2M_HZ,
        CLOCK_4M_HZ,
        CLOCK_8M_HZ,
        CLOCK_16M_HZ,
        CLOCK_MAX
    };
    
    int GetClock() const
    {
        return m_Clock;
    }
    
    /*------------------------------------------------------------------------
      Desc: o͎gI

      Args: freq - g

      Rtns: Ȃ
    ------------------------------------------------------------------------*/
    void SetFrequency(MICTesterFreq freq)
    {
        this->Write(MIC_REGSPI_W_FREQ_ADDR, 
                    static_cast<u8>(freq & MIC_REGSPI_W_FREQ_MASK));
    }

    /*------------------------------------------------------------------------
      Desc: Lu[VID̐ݒ

      Args: vol - o͓d

      Rtns: Ȃ
    ------------------------------------------------------------------------*/
    void SetCalibrationID(u8 calib_id)
    {
        this->Write(MIC_REGSPI_W_CALIBRATION_ID_ADDR, 
                    static_cast<u8>(calib_id & MIC_REGSPI_W_CALIBRATION_ID_MASK));
    }

    /*------------------------------------------------------------------------
      Desc: Lu[Vo̓xύXv

      Args: vol - 肵g`f[^

      Rtns: Ȃ
    ------------------------------------------------------------------------*/
    void SetCalibrationLevel(MICTesterCalibLevelReq level_req)
    {
        this->Write(MIC_REGSPI_W_CALIB_LEVEL_CTRL_ADDR,
                    static_cast<u8>(level_req & MIC_REGSPI_W_CALIB_LEVEL_CTRL_MASK));
    }

    /*------------------------------------------------------------------------
      Desc: g`o

      Args: sw - o͂ON/OFF

      Rtns: Ȃ
    ------------------------------------------------------------------------*/
    void SetWaveOutput(bool sw)
    {
        this->Write(MIC_REGSPI_W_WAVE_OUT_ADDR,
                    static_cast<u8>(sw & MIC_REGSPI_W_WAVE_OUT_MASK));
    }

    /*------------------------------------------------------------------------
      Desc: ėpWX^

      Args: data - Cgf[^

      Rtns: Ȃ
    ------------------------------------------------------------------------*/
    void WriteGeneralRegister(u8 data)
    {
        this->Write(MIC_REGSPI_W_GENERAL_ADDR, 
                    static_cast<u8>(data & MIC_REGSPI_W_GENERAL_MASK));
    }


public:
    /*---------------------------------------------------------------------------
      Desc: Xe[^XWX^
            8biťXe[^XׂĎ擾܂        

      Args: Ȃ

      Rtns: Xe[^X
    ---------------------------------------------------------------------------*/
    MICTesterStatus GetTesterStatus(void)
    {
        static MICTesterStatus status;
        
        status.raw = this->Read(MIC_REGSPI_R_STATUS_ADDR);
    
#if MIC_TESTERCONTROL_DEBUGFLAG
        OutputStatus(status);
#endif
        return status;
    }

    /*---------------------------------------------------------------------------
      Desc: 샂[h̎擾

      Args: Ȃ

      Rtns: 0x00   Lu[V
            0x01   ʏ팟
    ---------------------------------------------------------------------------*/
    MICTesterMode GetMode(void)
    {
        return static_cast<MICTesterMode>((this->Read(MIC_REGSPI_R_STATUS_ADDR)
                                >> MIC_REGSPI_R_STATUS_MODE_SHIFT)
                                &  MIC_REGSPI_R_STATUS_MASK);
    }

    /*---------------------------------------------------------------------------
      Desc: ~XCb`CxgtO

      Args: Ȃ

      Rtns: false   CxgȂ
            true    Cxg
    ---------------------------------------------------------------------------*/
    bool GetStopEvent(void)
    {
        return static_cast<bool>((this->Read(MIC_REGSPI_R_STATUS_ADDR)
                                >> MIC_REGSPI_R_STATUS_STOP_EVENT_SHIFT)
                                &  MIC_REGSPI_R_STATUS_MASK);
    }

    /*---------------------------------------------------------------------------
      Desc: g/IDݒԎ擾

      Args: Ȃ

      Rtns: false   ݒ薢ρA܂NG
            true    ݒOK
    ---------------------------------------------------------------------------*/
    bool GetSetup(void)
    {
        return static_cast<bool>((this->Read(MIC_REGSPI_R_STATUS_ADDR)
                                >> MIC_REGSPI_R_STATUS_SETUP_SHIFT)
                                &  MIC_REGSPI_R_STATUS_MASK);
    }

    /*---------------------------------------------------------------------------
      Desc: M\tO

      Args: Ȃ

      Rtns: false   TvO֎~
            true    TvO\
    ---------------------------------------------------------------------------*/
    bool GetSmpRq(void)
    {
        return static_cast<bool>((this->Read(MIC_REGSPI_R_STATUS_ADDR)
                                >> MIC_REGSPI_R_STATUS_SMP_RQ_SHIFT)
                                &  MIC_REGSPI_R_STATUS_MASK);
    }

    /*---------------------------------------------------------------------------
      Desc: G[R[h

      Args: Ȃ

      Rtns: 0       
            1       Lu[VG[
                     (a)o̓xvɉȂꍇ
                     (b)ʏ팟ɂĎw肳ꂽuIDݒvvɑΉ
                        Lu[Vς̏ꍇ
            2       p[^s
            3       ʐMt[s
            4`7    \
            8`15   G[   
    ---------------------------------------------------------------------------*/
    u16 GetErrCode(void)
    {
        return static_cast<u16>((this->Read(MIC_REGSPI_R_STATUS_ADDR)
                                >> MIC_REGSPI_R_STATUS_ERROR_CODE_SHIFT)
                                &  MIC_REGSPI_R_STATUS_MASK);
    }

    /*---------------------------------------------------------------------------
      Desc: ėpWX^

      Args: Ȃ

      Rtns: WX^l
    ---------------------------------------------------------------------------*/
    u8 ReadGeneralRegister(void)
    {
        return static_cast<u8>((this->Read(MIC_REGSPI_R_GENERAL_ADDR)
                                >> MIC_REGSPI_R_GENERAL_SHIFT)
                                &  MIC_REGSPI_R_GENERAL_MASK);
    }

    /*---------------------------------------------------------------------------
      Desc: 킪CTRpHiėpWX^̊mFj

      Args: Ȃ

      Rtns: true    CTR
            false   LȊO
    ---------------------------------------------------------------------------*/
    static bool isCTR;

    bool IsCTRTester(void)
    {
        static bool bInitialized = false;

        // 탌WX^擾͈̂x
        if (!bInitialized)
        {
            isCTR = (this->ReadGeneralRegister() == MIC_TESTER_TYPE_CTR) ? true : false;
            bInitialized = true;
        }
        return isCTR;
    }
    
    
private:
    void Write(u32 addr, u8 data);
    u8   Read(u32 addr);
    
public:
    
private:
    int m_Clock;
    int m_PolingInterval;
    
};




}   // namespace eva
}   // namespace uji

/* __TEST_MIC_TESTER_REGISTER_H__ */
#endif

/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
