/*--------------------------------------------------------------------------*
 Project:
 File: mic_TesterRegister.cpp

 }CNSPIWX^ANZX

*--------------------------------------------------------------------------*/
#include "mic_TesterRegister.h"
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>

namespace uji {
namespace eva {


#define USE_FILESTREAM


/*---------------------------------------------------------------------------
  Desc: RXgN^

  Args: Ȃ
 
  Rtns: Ȃ
---------------------------------------------------------------------------*/
MicTesterReg::MicTesterReg(int clock) : m_Clock(clock), m_PolingInterval(10)// |[OԊu1msecȏ
{
#ifdef USE_FILESTREAM
    nn::fs::CardSpiBaudRate baudRate;
    
    NN_ASSERTMSG(clock < CLOCK_MAX, "Error: Invalid clock(%d)\n", clock);
    
    switch (m_Clock = clock)
    {
        case CLOCK_512K_HZ : baudRate = nn::fs::CARDSPI_BAUDRATE_512KHZ;   break;   
        case CLOCK_1M_HZ   : baudRate = nn::fs::CARDSPI_BAUDRATE_1MHZ;     break;   
        case CLOCK_2M_HZ   : baudRate = nn::fs::CARDSPI_BAUDRATE_2MHZ;     break;
        case CLOCK_4M_HZ   : baudRate = nn::fs::CARDSPI_BAUDRATE_4MHZ;     break;
        case CLOCK_8M_HZ   : baudRate = nn::fs::CARDSPI_BAUDRATE_8MHZ;     break;
        case CLOCK_16M_HZ  : baudRate = nn::fs::CARDSPI_BAUDRATE_16MHZ;    break;
        default:                                                           break;                                              
    }
        
    nn::fs::SetCardSpiBaudRate( baudRate );
#else
    (void)clock;
#endif
}

/*---------------------------------------------------------------------------
  Desc: fXgN^

  Args: Ȃ
 
  Rtns: Ȃ
---------------------------------------------------------------------------*/
MicTesterReg::~MicTesterReg(void)
{
#ifdef USE_FILESTREAM
#endif
}

/*---------------------------------------------------------------------------
  Desc: 탌WX^Cg

  Args: addr - AhX
        data - ݃f[^

  Rtns:
---------------------------------------------------------------------------*/
void MicTesterReg::Write(u32 addr, u8 data) 
{
#ifdef USE_FILESTREAM

    NN_ASSERTMSG(addr <= TESTER_W_ADDR_MAX, "Error: Invalid addr(%Xh)\n", addr);

    nn::fs::Write( 0x02, addr, reinterpret_cast<const u32*>( &data ), ACCESS_DATA_SIZE );
    
#else

    (void)addr;
    (void)data;
    
#endif
}

/*---------------------------------------------------------------------------
  Desc: 탌WX^[h

  Args: addr - AhX

  Rtns: ǂݍ݃f[^
---------------------------------------------------------------------------*/
u8 MicTesterReg::Read(u32 addr)
{
#ifdef USE_FILESTREAM

    NN_ASSERTMSG(addr <= TESTER_R_ADDR_MAX, "Error: Invalid addr(%Xh)\n", addr);
    
    u8 data[sizeof(u32)];
    nn::fs::Read( 0x03, addr, reinterpret_cast<u32*>(data), sizeof(data) );
    
    return data[0];
    
#else

    (void)addr;
    return 0xff;
    
#endif
}




}   // namespace eva
}   // namespace uji


