/*--------------------------------------------------------------------------*
 Project:
 File: mic_TesterCommand.h

*--------------------------------------------------------------------------*/
#ifndef __TEST_MIC_TESTER_COMMAND_H__
#define __TEST_MIC_TESTER_COMMAND_H__


#include <vector>
#include "sys.h"
#include "mic_TesterRegister.h"

//mic_TesterRegister.h Ɉȉ錾ς
//#define MIC_TESTERCONTROL_DEBUGFLAG       0 or 1

namespace uji {
namespace eva {

void Eva_CheckCommandTest(void);

/*---------------------------------------------------------------------------
    C^[tF[XNX
---------------------------------------------------------------------------*/
class MicTesterInterface : public MicTesterReg
{
public:
    MicTesterInterface(){}
    virtual ~MicTesterInterface(){}
    
    
    /*---------------------------------------------------------------------------
       G[lC^[tF[X֐
    ---------------------------------------------------------------------------*/
    u32 WaveSetup(MICTesterFreq freq, u8 calib_id);
    u32 WaveStart(void);
    u32 WaveStop(void);
    u32 CalModeWaveSetup(MICTesterFreq freq, u8 calib_id);
    u32 CalModeLevelControl(MICTesterCalibLevelReq level_req);
    
#if MIC_TESTERCONTROL_DEBUGFLAG
    void OutputStatus(MICTesterStatus& status);
#endif
    /*---------------------------------------------------------------------------
       `FbN֐
    ---------------------------------------------------------------------------*/
    u32 CheckFatalError(void);
    u32 CheckStateSMP_RQ(bool rq);
    u32 CheckSetupComplete(void);
    
private:
    //---------------------------------------------------------------------------
    //      萔
    //---------------------------------------------------------------------------
    // ̃Xe[^XWX^|[Op
    static const int POLLING_STATUS_TIMEOUT    = 100;  // ms
    // 퉹o͐M҂p
    static const int WAVE_OUT_WAIT_TIME        = 50;    // ms
    
};


/*---------------------------------------------------------------------------
    ]NX
---------------------------------------------------------------------------*/
class MicTesterCommand;

// j[̗vf
struct CommandMenuElement {
    CommandMenuElement(char* name, void (MicTesterCommand::*function)())
     : m_Name(name), m_Function(function)
    {}

    char* m_Name;
    void (MicTesterCommand::*m_Function)();    // o֐|C^
};

// ]NX
class MicTesterCommand
{
public:
    MicTesterCommand() : m_Cursor(0), m_IsReadStatusAllTime(false) {}
    virtual ~MicTesterCommand(){}
    
    void Run(void);
    
private:
    // \p
    void PrintCommandMenu(void);
    void PrintStatusReg(MICTesterStatus status);
    void UpdateScreen(sys::GraphicsDrawing* gfx);
    void InitializeWindow(MICTesterFreq* freq, u8* calib_id);
    void FinalizeWindow(u32 result);
    
    // R}hp[^ݒEChE
    void CreateCommandSettingWindow(char* name, s32 w, s32 h, s32 pos_x=120, s32 pos_y=80);
    void DestroyCommandSettingWindow();
    
    //------------------------------------------------------------------------
    //      R}hs֐
    //------------------------------------------------------------------------
    void Cmd_WaveSetup(void);
    void Cmd_WaveStart(void);
    void Cmd_WaveSetup1kHzStart(void);
    void Cmd_WaveStop(void);
    void Cmd_CalModeWaveSetup(void);
    void Cmd_CalModeLevelControl(void);
    void Cmd_ReadRegister(void);
    void Cmd_ReadRegister(bool alltime);
    void Cmd_WriteGeneralRegister(void);
    
    
private:
    // 퐧NX̃CX^X
    MicTesterInterface m_MICTesterIF;
    
    // Cj[vf̔z
    std::vector<CommandMenuElement*> m_MenuOrderArray; 
    
    int m_Cursor;
    bool m_IsReadStatusAllTime;
    
    sys::WindowManager      m_WindowManager;
    sys::TextWindow*        m_TWndMain;
    sys::TextWindow*        m_TWndLog;
    sys::InputTextWindow*   m_IWndCommand;
    sys::TextWindow*        m_TWndStatus;
    
    //------------------------------------------------------------------------
    //      EChEɊւ萔
    //------------------------------------------------------------------------
    static const int FONT_SIZE_L = 14;
    static const int FONT_SIZE_S = 12;

    static const s32 TWND_MAIN_WIDTH    = 40;
    static const s32 TWND_MAIN_POS_X    = 0;
    static const s32 TWND_MAIN_POS_Y    = 0;
    
    //static const s32 TWND_LOG_WIDTH     = 34;
    static const s32 TWND_LOG_WIDTH     = 52;
    static const s32 TWND_LOG_HEIGHT    = 19;
    static const s32 TWND_LOG_POS_X     = 0;
    static const s32 TWND_LOG_POS_Y     = 0;
    static const s32 TWND_STATUS_WIDTH  = 16; 
    static const s32 TWND_STATUS_HEIGHT = 10;
    //static const s32 TWND_STATUS_POS_X  = TWND_LOG_WIDTH * FONT_SIZE_S * 0.5 + 10;
    static const s32 TWND_STATUS_POS_X  = TWND_MAIN_WIDTH * FONT_SIZE_S * 0.5 + 10;
    static const s32 TWND_STATUS_POS_Y  = 0;
    
    
    static const bool ALL_TIME=true;
    static const bool ONE_TIME=false;
};


}   // namespace eva
}   // namespace uji

/* __TEST_MIC_TESTER_COMMAND_H__ */
#endif

/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
