/*--------------------------------------------------------------------------*
 Project:
 File: mic_TesterControl.cpp

 }CN

*--------------------------------------------------------------------------*/

#include "mic_TesterCommand.h"
#include "mic_Lib.h"

#if MIC_TESTERCONTROL_DEBUGFLAG
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>
#include <string>
using namespace std;
#endif

using namespace uji;
using namespace uji::sys;

namespace uji {
namespace eva {

//===========================================================================
//===========================================================================
//                              fobOp
//===========================================================================
//===========================================================================
#if MIC_TESTERCONTROL_DEBUGFLAG
/*---------------------------------------------------------------------------
  Desc: fBNgJȂꍇ͐VK쐬

  Args: path        Ώۃt@C̃tpX

  Rtns: Ȃ
---------------------------------------------------------------------------*/
static void CreateDirectorySdmc(const wchar_t* path)
{
    nn::fs::Directory dir;
    nn::Result result = dir.TryInitialize( path );
    
    // fBNgȂꍇ͐VK쐬
    if(result.IsFailure())
    {
        NN_LOG("Can't Initialize! So Create Directory... \n");
        
        result = nn::fs::TryCreateDirectory( path );
        
        if(result.IsFailure())
        {
            NN_LOG("* Warning: No Create Directory! \n");
        }
    }
    else
    {
        dir.Finalize();
    }
}
#endif
#if MIC_TESTERCONTROL_DEBUGFLAG
/*---------------------------------------------------------------------------
  Desc: Ώۃt@CɃf[^݂܂

  Args: path        Ώۃt@C̃tpX
        strBuf      ރf[^

  Rtns: Ȃ
---------------------------------------------------------------------------*/
static void WriteData2SD(const wchar_t* path, string strBuf)
{
    nn::Result result;
    bool bDetected;

    // SD`FbN
    result = nn::fs::IsSdmcDetected(&bDetected);
    if (result.IsFailure())
    {
        NN_LOG("* Warning: Fail nn::fs::IsSdmcDetected.\n");
    }
    
    // SDJ[h}ĂȂꍇG[
    // SDKł͓rōĂSDJ[hɑ΂ăt@CANZXoȂ
    if( 0==bDetected )
    {
        NN_LOG("* Warning: No Insert SD-Card!\n");
        NN_LOG("bDetected=%d\n", bDetected);
        /*
        do
        {
            // SD`FbN
            result = nn::fs::IsSdmcDetected(&bDetected);
            if (result.IsFailure())
            {
                // G[
                NN_LOG("* Warning: Fail nn::fs::IsSdmcDetected.\n");
            }
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
        }
        while( 0==bDetected );
        NN_LOG("bDetected=%d\n", bDetected);
        */
    }
    
    // EndOfFile
    char myEOF=0x1a;
    
    // t@C݂߂̃IuWFNg쐬
    nn::fs::FileStream fos;
    result = fos.TryInitialize(path, nn::fs::OPEN_MODE_READ   | 
                                     nn::fs::OPEN_MODE_WRITE  | 
                                     nn::fs::OPEN_MODE_CREATE );
    if(result.IsSuccess())
    {
        s64 size = fos.GetSize();
        NN_LOG("FILE_SIZE= %lld\n", size);
        
        if(size != 0)
        {
            // ڈȍ~
            fos.Seek( -1, nn::fs::POSITION_BASE_END );
        }
        fos.Write(strBuf.c_str(), strlen(strBuf.c_str()));
        fos.Write(&myEOF, 1);
    }
    
    // t@C
    fos.Finalize();
}
#endif

//===========================================================================
//===========================================================================
//                          ʏ팟[hp
//===========================================================================
//===========================================================================

/*---------------------------------------------------------------------------
  Desc: o͔g`̐ݒ

  Args: freq    - g
        calib_id  - Lu[VID

  Rtns: MICI_RESULT_SUCCESS - OK

        ̑NG͌Xe[^XƉLG[R[h̘_aԂ
        MICI_RESULT_STATUS_ERROR_FATAL   - vIG[
        MICI_RESULT_STATUS_ERROR_SETUP   - gIIDݒ̃G[
---------------------------------------------------------------------------*/
u32 MicTesterInterface::WaveSetup(MICTesterFreq freq, u8 calib_id)
{
    u32 ret;
    
#if MIC_TESTERCONTROL_DEBUGFLAG
    char buf1[10] = "";
    char buf2[10] = "";
    char buf3[10] = "";
    char buf4[10] = "";
#endif
    
    // Xe[^XmF
    MICTesterStatus status = MicTesterReg::GetTesterStatus();
    
#if MIC_TESTERCONTROL_DEBUGFLAG
    sprintf(buf1, "* 1:%s\n", (status.MODE!=MIC_MODE_TEST)  ? "NG" : "OK");
    sprintf(buf2, "* 2:%s\n", (status.SMP_RQ)               ? "NG" : "OK");
    sprintf(buf3, "* 3:%s\n", (CheckFatalError())           ? "NG" : "OK");
    s_strBuffer += static_cast<string>(buf1);
    s_strBuffer += static_cast<string>(buf2);
    s_strBuffer += static_cast<string>(buf3);
#endif

    if( (status.MODE!=MIC_MODE_TEST) || status.SMP_RQ || CheckFatalError() )
    {
        return ( static_cast<u32>(status.raw) | MICI_RESULT_STATUS_ERROR_FATAL );
    }
    
    // gI
    MicTesterReg::SetFrequency(freq);
    
    // Lu[VIDݒ
    MicTesterReg::SetCalibrationID(calib_id);
    
#if MIC_TESTERCONTROL_DEBUGFLAG
    sprintf(buf4, "* 4:%s\n", (CheckSetupComplete())    ? "NG" : "OK");
    s_strBuffer += static_cast<string>(buf4);
#endif
    
    // ZbgAbv̏I`FbN
    if( CheckSetupComplete() )
    {
        return ( ret | MICI_RESULT_STATUS_ERROR_SETUP );
    }
    
    return MICI_RESULT_SUCCESS;
}

/*---------------------------------------------------------------------------
  Desc: 퉹Mo͊Jn

  Args: Ȃ

  Rtns: MICI_RESULT_SUCCESS - OK
        
        NG͌Xe[^XƉLG[R[h̘_aԂ
        MICI_RESULT_STATUS_ERROR_FATAL   - vIG[
        MICI_RESULT_STATUS_ERROR_SMP_RQ  - M\tOG[
---------------------------------------------------------------------------*/
u32 MicTesterInterface::WaveStart(void)
{
    u32 ret;
    
    // Xe[^XmF
    MICTesterStatus status = MicTesterReg::GetTesterStatus();
    if( status.SMP_RQ || (status.SETUP != MIC_SETUP_OK) || CheckFatalError() )
    {
        return ( static_cast<u32>(status.raw) | MICI_RESULT_STATUS_ERROR_FATAL );
    }

    // Mo͊Jn
    MicTesterReg::SetWaveOutput(true);

    // Mo͐Mo͂ꂽƂmF
    if( CheckStateSMP_RQ(MIC_SMP_RQ_POSSIBLE) )
    {
        return ( ret | MICI_RESULT_STATUS_ERROR_SMP_RQ);
    }

    // \Ȏԑ҂
    WaitMilliSeconds(WAVE_OUT_WAIT_TIME);
    
    return MICI_RESULT_SUCCESS;
}

/*---------------------------------------------------------------------------
  Desc: 퉹Mo͒~

  Args: Ȃ

  Rtns: MICI_RESULT_SUCCESS - OK
        
        NG͌Xe[^XƉLG[R[h̘_aԂ
        MICI_RESULT_STATUS_ERROR_FATAL   - vIG[
        MICI_RESULT_STATUS_ERROR_SMP_RQ  - M\tOG[
---------------------------------------------------------------------------*/
u32 MicTesterInterface::WaveStop(void)
{
    u32 ret;
    
    // Xe[^XmF
    MICTesterStatus status = MicTesterReg::GetTesterStatus();
    if( !status.SMP_RQ || CheckFatalError() )
    {
        NN_LOG("_1_status adress=%08X\n", &status);
        return ( static_cast<u32>(status.raw) | MICI_RESULT_STATUS_ERROR_FATAL );
    }

    // Mo͒~
    MicTesterReg::SetWaveOutput(false);


    // Mo͐M~ł邱ƂmF
    if( CheckStateSMP_RQ(MIC_SMP_RQ_PROHIBITION) )
    {
        return ( ret | MICI_RESULT_STATUS_ERROR_SMP_RQ);
    }
    
    return MICI_RESULT_SUCCESS;
}

//============================================================================
//============================================================================
//                      Lu[V[hp
//============================================================================
//============================================================================

/*---------------------------------------------------------------------------
  Desc: o͔g`̃ZbgAbv

  Args: freq      - g
        calib_id  - Lu[VID
                    0`255 ܂ł̃Lu[VԍB0000h(Write)FSEL
                    256ʂ(ő1024ʂ)̃Lu[Vl\ł܂B

  Rtns: MICI_RESULT_SUCCESS - OK
        
        MICI_RESULT_ILLEGAL_PARAM - NG p[^s        

        ̑NG͌Xe[^XƉLG[R[h̘_aԂ
        MICI_RESULT_STATUS_ERROR_FATAL   - vIG[
        MICI_RESULT_STATUS_ERROR_SETUP   - gIIDݒ̃G[
        MICI_RESULT_STATUS_ERROR_SMP_RQ  - M\tOG[
---------------------------------------------------------------------------*/
u32 MicTesterInterface::CalModeWaveSetup( MICTesterFreq freq, u8 calib_id )
{
    u32 ret;
    
#if MIC_TESTERCONTROL_DEBUGFLAG
    char buf1[10] = "";
    char buf2[10] = "";
    char buf3[10] = "";
    char buf4[10] = "";
    char buf5[10] = "";
#endif
    
    // Xe[^XmF
    MICTesterStatus status = MicTesterReg::GetTesterStatus();
    
#if MIC_TESTERCONTROL_DEBUGFLAG
    sprintf(buf1, "* 1:%s\n", (status.MODE!=MIC_MODE_CALIBRATION)   ? "NG" : "OK");
    sprintf(buf2, "* 2:%s\n", (status.SMP_RQ)                       ? "NG" : "OK");
    sprintf(buf3, "* 3:%s\n", (CheckFatalError())                   ? "NG" : "OK");
    s_strBuffer += static_cast<string>(buf1);
    s_strBuffer += static_cast<string>(buf2);
    s_strBuffer += static_cast<string>(buf3);
#endif
    
    if( (status.MODE!=MIC_MODE_CALIBRATION) || status.SMP_RQ || CheckFatalError() )
    {
        return ( static_cast<u32>(status.raw) | MICI_RESULT_STATUS_ERROR_FATAL );
    }
    
    // gI
    MicTesterReg::SetFrequency(freq);
    
    // Lu[VIDݒ
    MicTesterReg::SetCalibrationID(calib_id);
    
#if MIC_TESTERCONTROL_DEBUGFLAG
    sprintf(buf4, "* 4:%s\n", (CheckSetupComplete())    ? "NG" : "OK");
    s_strBuffer += static_cast<string>(buf4);
#endif
    
    // ZbgAbv̏I`FbN
    if( CheckSetupComplete() )
    {
        return ( ret | MICI_RESULT_STATUS_ERROR_SETUP );
    }
    
#if MIC_TESTERCONTROL_DEBUGFLAG
    sprintf(buf5, "* 5:%s\n", (CheckSetupComplete())    ? "NG" : "OK");
    s_strBuffer += static_cast<string>(buf5);
#endif
    
    // Mo͐Mo͂ꂽƂmF
    if( CheckStateSMP_RQ(MIC_SMP_RQ_POSSIBLE) )
    {
        return ( ret | MICI_RESULT_STATUS_ERROR_SMP_RQ);
    }

    // \Ȏԑ҂
    WaitMilliSeconds(WAVE_OUT_WAIT_TIME);

    return MICI_RESULT_SUCCESS;
}

/*---------------------------------------------------------------------------
  Desc: o̓xύXvݒ

  Args: level_req   -   CALIB_REQ_COMPLETE  Lu[V
                        CALIB_REQ_INCREASE  o̓xv  
                        CALIB_REQ_DECREASE  o̓xv

  Rtns: MICI_RESULT_SUCCESS - OK
        
        MICI_RESULT_ILLEGAL_PARAM - NG p[^s
        
        ̑NG͌Xe[^XƉLG[R[h̘_aԂ
        MICI_RESULT_STATUS_ERROR_FATAL        - vIG[
        MICI_RESULT_STATUS_ERROR_SMP_RQ       - M\tOG[
        MICI_RESULT_STATUS_ERROR_CALIB_NOCOMP - Lu[V
---------------------------------------------------------------------------*/
u32 MicTesterInterface::CalModeLevelControl(MICTesterCalibLevelReq level_req)
{
    u32 ret;
    
    // level_req̐`FbN
    if (level_req > CALIB_REQ_MAX)
    {
        return MICI_RESULT_ILLEGAL_PARAM;
    }

    // Xe[^XmF
    MICTesterStatus status = MicTesterReg::GetTesterStatus();
    if ((status.MODE != MIC_MODE_CALIBRATION) || !status.SMP_RQ || CheckFatalError())
    {
        return ((u32)status.raw | MICI_RESULT_STATUS_ERROR_FATAL);
    }

    // Lu[Vo̓xύXv
    SetCalibrationLevel(level_req);

    // NGXgvU0ɂȂ邱ƁB
    // TWLł1~|炸0ɂȂAn[hEFA̐ݒ1000msxԂv
    if ( CheckStateSMP_RQ(MIC_SMP_RQ_PROHIBITION) )
    {
        return (ret | MICI_RESULT_STATUS_ERROR_SMP_RQ);
    }

    switch (level_req)
    {
    case CALIB_REQ_INCREASE:
    case CALIB_REQ_DECREASE:
        // Mo͐Mo͂ꂽ
        if ( CheckStateSMP_RQ(MIC_SMP_RQ_POSSIBLE) )
        {
            return (ret | MICI_RESULT_STATUS_ERROR_SMP_RQ);
        }
        break;
    case CALIB_REQ_COMPLETE:
        // Lu[V
        if ( CheckStateSMP_RQ(MIC_SMP_RQ_PROHIBITION) )
        {
            return (ret | MICI_RESULT_STATUS_ERROR_CALIB_NOCOMP);
        }
        break;
    default:
        break;
    }
    
    return MICI_RESULT_SUCCESS;

}

//===========================================================================
//===========================================================================
//                       e[hʃ`FbN֐
//===========================================================================
//===========================================================================

/*---------------------------------------------------------------------------
  Desc: vIG[̃`FbN

  Args: status - Xe[^X

  Rtns: MICI_RESULT_SUCCESS - OK
        
        NG͌Xe[^XƉLG[R[h̘_aԂ
        MICI_RESULT_STATUS_ERROR_FATAL   - vIG[
---------------------------------------------------------------------------*/
u32 MicTesterInterface::CheckFatalError(void)
{
    MICTesterStatus status = MicTesterReg::GetTesterStatus();
    
    if( (status.ERR != 0) || GetStopEvent() )
    {
        return (static_cast<u32>(status.raw) | MICI_RESULT_STATUS_ERROR_FATAL );
    }
    
    return MICI_RESULT_SUCCESS;
    
}

/*---------------------------------------------------------------------------
  Desc: M\tOmF

  Args: rq - `FbNSMP_RQ̏(true/false)

  Rtns: MICI_RESULT_SUCCESS - OK
        
        NG͌Xe[^XƉLG[R[h̘_aԂ
        MICI_RESULT_STATUS_ERROR_FATAL    - vIG[
        MICI_RESULT_STATUS_ERROR_TIMEOUT  - ^CAEg
---------------------------------------------------------------------------*/
u32 MicTesterInterface::CheckStateSMP_RQ(bool rq)
{
    nn::fnd::TimeSpan ts;
    
    // ŐVłȂ\̂ňxǂ݁i푤_uobt@̏ꍇj
    MICTesterStatus status = MicTesterReg::GetTesterStatus();
    
    do {
        status = MicTesterReg::GetTesterStatus();
        
        if( CheckFatalError() )
        {
            return ( static_cast<u32>(status.raw) | MICI_RESULT_STATUS_ERROR_FATAL );
        }
        else if( ts.GetMilliSeconds() > POLLING_STATUS_TIMEOUT )
        {
            return ( static_cast<u32>(status.raw) | MICI_RESULT_STATUS_ERROR_TIMEOUT );
        }
    } while( status.SMP_RQ != rq );
    
    return MICI_RESULT_SUCCESS;
}

/*---------------------------------------------------------------------------
  Desc: gIIDݒԂݒς݂ł邱ƂmF

  Args: Ȃ

  Rtns: MICI_RESULT_SUCCESS - OK
        
        NG͌Xe[^XƉLG[R[h̘_aԂ
        MICI_RESULT_STATUS_ERROR_FATAL    - vIG[
        MICI_RESULT_STATUS_ERROR_TIMEOUT  - ^CAEg
---------------------------------------------------------------------------*/
u32 MicTesterInterface::CheckSetupComplete(void)
{
    nn::fnd::TimeSpan ts;
    
    // ŐVłȂ\̂ňxǂ݁i푤_uobt@̏ꍇj
    MICTesterStatus status = MicTesterReg::GetTesterStatus();
    
    do {
        status = MicTesterReg::GetTesterStatus();
        
        if( CheckFatalError() )
        {
            return ( static_cast<u32>(status.raw) | MICI_RESULT_STATUS_ERROR_FATAL );
        }
        else if( ts.GetMilliSeconds() > POLLING_STATUS_TIMEOUT )
        {
            return ( static_cast<u32>(status.raw) | MICI_RESULT_STATUS_ERROR_TIMEOUT );
        }
    } while( status.SETUP != MIC_SETUP_OK );
    
    return MICI_RESULT_SUCCESS;
}


/*---------------------------------------------------------------------------
  Desc: ]j[s

  Args: Ȃ

  Rtns: Ȃ
---------------------------------------------------------------------------*/
void Eva_CheckCommandTest(void)
{
    MicTesterCommand mtc;
    mtc.Run();
}

void MicTesterCommand::Run(void)
{
    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();
    
    // ------------------------------------------------------------------------
    //  j[vf̐
    // ------------------------------------------------------------------------
    m_MenuOrderArray.push_back(new CommandMenuElement(" calib  -> WAVE SETUP",      &MicTesterCommand::Cmd_CalModeWaveSetup));
    m_MenuOrderArray.push_back(new CommandMenuElement("           LEVEL CTRL",      &MicTesterCommand::Cmd_CalModeLevelControl));
    m_MenuOrderArray.push_back(new CommandMenuElement(" test   -> WAVE SETUP",      &MicTesterCommand::Cmd_WaveSetup));
    m_MenuOrderArray.push_back(new CommandMenuElement("           WAVE START",      &MicTesterCommand::Cmd_WaveStart));
    m_MenuOrderArray.push_back(new CommandMenuElement("           WAVE SETUP(1kHz)+START",&MicTesterCommand::Cmd_WaveSetup1kHzStart));
    m_MenuOrderArray.push_back(new CommandMenuElement("           WAVE STOP",       &MicTesterCommand::Cmd_WaveStop));
    m_MenuOrderArray.push_back(new CommandMenuElement(" common -> READ STATUS REG", &MicTesterCommand::Cmd_ReadRegister));
    m_MenuOrderArray.push_back(new CommandMenuElement("           WRITE GENERAL REG",&MicTesterCommand::Cmd_WriteGeneralRegister));
    
    // ------------------------------------------------------------------------
    //  EChE
    // ------------------------------------------------------------------------
    m_TWndMain = new sys::TextWindow(TWND_MAIN_WIDTH, m_MenuOrderArray.size(), FONT_SIZE_S);
    m_TWndMain->SetTitle("SPI Command List");    
    m_WindowManager.CreateWindow(m_TWndMain, NN_GX_DISPLAY0, TWND_MAIN_POS_X, TWND_MAIN_POS_Y); 
    m_TWndLog = new sys::TextWindow(TWND_LOG_WIDTH, TWND_LOG_HEIGHT, FONT_SIZE_S);
    m_TWndLog->SetTitle("Command LOG");                       
    m_WindowManager.CreateWindow(m_TWndLog, NN_GX_DISPLAY1, TWND_LOG_POS_X, TWND_LOG_POS_Y); 
    m_TWndStatus = new sys::TextWindow(TWND_STATUS_WIDTH, TWND_STATUS_HEIGHT, FONT_SIZE_S);
    m_TWndStatus->SetTitle("Status Reg");                       
    m_WindowManager.CreateWindow(m_TWndStatus, NN_GX_DISPLAY0, TWND_STATUS_POS_X, TWND_STATUS_POS_Y); 
    
    
    // CEChEANeBu
    m_WindowManager.SetActiveWindow(m_TWndMain);


    // R}hOEChEɏo
    int exec_count = 0;
    m_TWndLog->Printf("\f");
    m_TWndLog->Printf("%03d> ", exec_count);
    
    do
    {
        // pbhXV
        sys::Pad().UpdatePad();
                        
        // EChE
        m_WindowManager.Update();
        m_WindowManager.UpdatePad(sys::Pad());

        // j[I
        if (sys::Pad().IsButtonRepeat(sys::Pad::BUTTON_DOWN))
        {
            if (++m_Cursor > (m_MenuOrderArray.size() - 1))
            {
                m_Cursor = 0;
            }
        }
        if (sys::Pad().IsButtonRepeat(sys::Pad::BUTTON_UP))
        {
            if (--m_Cursor < 0) 
            {
                m_Cursor = (m_MenuOrderArray.size() - 1);
            }
        }

        // s
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_A) && m_MenuOrderArray[m_Cursor]->m_Function)
        {            
            void (MicTesterCommand::*fpFunc)() = m_MenuOrderArray[m_Cursor]->m_Function;
            (this->*fpFunc)();
            
            m_TWndLog->SetTextColor(sys::ATTR_COLOR_WHITE);            
            m_TWndLog->Printf("%03d> ", ++exec_count);
        }
        
        // ʍXV
        UpdateScreen(gfx);
        
    }while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_B));

    // ------------------------------------------------------------------------
    //  I
    //------------------------------------------------------------------------
    m_WindowManager.DestroyWindow(m_TWndMain);
    m_WindowManager.DestroyWindow(m_TWndLog);
    m_WindowManager.DestroyWindow(m_TWndStatus);

    sys::Pad().ClearTriggerFlag();
}

/*---------------------------------------------------------------------------
  Desc: R}hj[̕\

  Args: Ȃ

  Rtns: Ȃ  
---------------------------------------------------------------------------*/
void MicTesterCommand::PrintCommandMenu(void)
{
    int i=0;    
    m_TWndMain->Printf("\f");
    
    for (std::vector<CommandMenuElement*>::iterator itr = m_MenuOrderArray.begin(); 
            itr != m_MenuOrderArray.end(); itr++)
    {
        if (i != 0) 
        {
            m_TWndMain->Printf("\n");
        }        
        if (m_Cursor == i)
        {
            m_TWndMain->SetTextColor(sys::ATTR_COLOR_YELLOW);
            m_TWndMain->Printf(">");
        }
        else
        {
            m_TWndMain->SetTextColor(sys::ATTR_COLOR_WHITE);
            m_TWndMain->Printf(" ");   
        }
        m_TWndMain->Printf(" %d.%s", i+1, (*itr)->m_Name);
        ++i;
    }
    m_TWndMain->SetTextColor(sys::ATTR_COLOR_WHITE);    
}

/*---------------------------------------------------------------------------
  Desc: Xe[^XWX^̕\

  Args: status

  Rtns: Ȃ
---------------------------------------------------------------------------*/
void MicTesterCommand::PrintStatusReg(MICTesterStatus status)
{
    m_TWndStatus->Printf("\f");
    
    m_TWndStatus->SetTextColor(sys::ATTR_COLOR_GREEN);
    m_TWndStatus->Printf("> %s\n", m_IsReadStatusAllTime ? "All Time" : "One Time");
    
    m_TWndStatus->SetTextColor(sys::ATTR_COLOR_WHITE);      
    m_TWndStatus->Printf("MODE       : %01X\n", status.MODE);
    m_TWndStatus->Printf("STOP_EVENT : %01X\n", status.STOP_EVENT);
    m_TWndStatus->Printf("SETUP      : %01X\n", status.SETUP);
    m_TWndStatus->Printf("SMP_RQ     : %01X\n", status.SMP_RQ);
    m_TWndStatus->Printf("ERR        : %01X\n", status.ERR);
}

/*---------------------------------------------------------------------------
  Desc: ]j[̉ʍXV

  Args: gfx -

  Rtns: Ȃ  
---------------------------------------------------------------------------*/
void MicTesterCommand::UpdateScreen(GraphicsDrawing* gfx)
{
    PrintCommandMenu();
    
    if (m_IsReadStatusAllTime)
    {
        PrintStatusReg(m_MICTesterIF.GetTesterStatus());
    }
    
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();
    m_WindowManager.DrawDisplay0();
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    m_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
        
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}


//===========================================================================
//===========================================================================
//                    R}hp[^ݒEChE
//===========================================================================
//===========================================================================

//---------------------------------------------------------------------------
//  R}hp[^ݒEChE̐^폜
//---------------------------------------------------------------------------
void MicTesterCommand::CreateCommandSettingWindow(char* name, 
                                                  s32 w, 
                                                  s32 h, 
                                                  s32 pos_x, 
                                                  s32 pos_y)
{
    m_IWndCommand = new sys::InputTextWindow(w, h, FONT_SIZE_S, this->m_WindowManager);
    m_IWndCommand->SetTitle(name);
    m_WindowManager.CreateWindow(m_IWndCommand, NN_GX_DISPLAY0, pos_x, pos_y);
}

void MicTesterCommand::DestroyCommandSettingWindow() {
    m_WindowManager.DestroyWindow(m_IWndCommand);
}


//===========================================================================
//===========================================================================
//                             eR}h
//===========================================================================
//===========================================================================

//---------------------------------------------------------------------------
//  Desc: R}hu(CALB/TEST) WAVE SETUPṽEBhE^I
//---------------------------------------------------------------------------
void MicTesterCommand::InitializeWindow(MICTesterFreq* freq, u8* calib_id)
{
#if MIC_TESTERCONTROL_DEBUGFLAG
    s_strBuffer  = static_cast<string>("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n");
#endif

    // R}hp[^͗pEChE̐
    CreateCommandSettingWindow("Set Parameter", 28, 5);
    m_IWndCommand->Printf("\f");
    
    // o͎gI
    m_IWndCommand->Printf(" (01:4KHz 07:1KHz 27:200Hz)");
    m_IWndCommand->Printf("\n FSEL = ");
    *freq = static_cast<MICTesterFreq>(m_IWndCommand->InputData16(0));
    
    // Lu[VID̑I
    m_IWndCommand->Printf("\n (0 - FFh)");
    m_IWndCommand->Printf("\n CALB_ID = ");
    *calib_id = static_cast<u8>(m_IWndCommand->InputData16(0));
}

void MicTesterCommand::FinalizeWindow(u32 result)
{
    // OEBhE֌ʂo
    sys::ATTR_TEXT_COLOR color = ((0 != result) ? sys::ATTR_COLOR_MAGENTA 
                                                : sys::ATTR_COLOR_WHITE);
    m_TWndLog->SetTextColor(color);
    ( 0 != result ) ? m_TWndLog->Printf("Failed to Setup(%08Xh)\n", result) 
                    : m_TWndLog->Printf("Wave Setup\n");
    
    // R}hEChEj
    DestroyCommandSettingWindow();
    
#if MIC_TESTERCONTROL_DEBUGFLAG
    CreateDirectorySdmc( L"sdmc:/uji/mic" );
    WriteData2SD( L"sdmc:/uji/mic/debugLog.txt", s_strBuffer );
    NN_LOG("%s\n", s_strBuffer.c_str());
#endif
}

//---------------------------------------------------------------------------
//  Desc: R}hu(CALB) WAVE SETUPvF
//  o͔g`̐ݒiLu[V[hpj
//---------------------------------------------------------------------------
void MicTesterCommand::Cmd_CalModeWaveSetup(void)
{
    MICTesterFreq freq=0;
    u8 calib_id=0;
    
    InitializeWindow(&freq, &calib_id);
    
    // o͔g`̃ZbgAbv
    u32 result = m_MICTesterIF.CalModeWaveSetup(freq, calib_id);
    
    FinalizeWindow(result);
}

//---------------------------------------------------------------------------
//  Desc: R}hu(CALB) LEVEL CTRLvF
//  o̓x̕ύXvݒiLu[V[hpj
//---------------------------------------------------------------------------
void MicTesterCommand::Cmd_CalModeLevelControl(void)
{
    // R}hp[^͗pEChE̐
    CreateCommandSettingWindow("Set Parameter", 26, 4);
    
    // o͗v̑I
    m_IWndCommand->Printf(" (0:Complete 1:Inc 2:Dec)");
    m_IWndCommand->Printf("\n LEVEL_CTRL = ");
    MICTesterCalibLevelReq level_req = 
    static_cast<MICTesterCalibLevelReq>(m_IWndCommand->InputData16(0));

    u32 result = m_MICTesterIF.CalModeLevelControl(level_req);
    
    // OEBhE֌ʂo
    sys::ATTR_TEXT_COLOR color = ((0 != result) ? sys::ATTR_COLOR_MAGENTA 
                                                : sys::ATTR_COLOR_WHITE);
    m_TWndLog->SetTextColor(color);
    ( 0 != result ) ? m_TWndLog->Printf("Failed to Control(%08Xh)\n", result)
                    : m_TWndLog->Printf("Level Control\n");
    
    // EChE폜
    DestroyCommandSettingWindow();
}

//---------------------------------------------------------------------------
//  Desc: R}hu(TEST) WAVE SETUPvFo͔g`̐ݒ
//---------------------------------------------------------------------------
void MicTesterCommand::Cmd_WaveSetup(void)
{
    MICTesterFreq freq=0;
    u8 calib_id=0;
    
    InitializeWindow(&freq, &calib_id);
    
    // o͔g`̃ZbgAbv
    u32 result = m_MICTesterIF.WaveSetup(freq, calib_id);
    
    FinalizeWindow(result);
}

//---------------------------------------------------------------------------
//  Desc: R}hu(TEST) WAVE STARTvFMo͊Jn
//---------------------------------------------------------------------------
void MicTesterCommand::Cmd_WaveStart(void)
{
    u32 result = 0x0;
    
    // 퉹M̏o͊Jn
    result = m_MICTesterIF.WaveStart();

    // OEBhE֌ʂo
    sys::ATTR_TEXT_COLOR color = ((0 != result) ? sys::ATTR_COLOR_MAGENTA 
                                                : sys::ATTR_COLOR_WHITE);
    m_TWndLog->SetTextColor(color);
    ( 0 != result ) ? m_TWndLog->Printf("Failed to Start(%08Xh)\n", result) 
                    : m_TWndLog->Printf("Wave Start\n");
}

//---------------------------------------------------------------------------
//  Desc: R}hu(TEST) WAVE SETUP(1kHz)+STARTvFo͔g`̐ݒƊJn
//---------------------------------------------------------------------------
void MicTesterCommand::Cmd_WaveSetup1kHzStart(void)
{
    u32 result = 0x0;
    
    // o͔g`̃ZbgAbv
    m_MICTesterIF.WaveSetup(MIC_TESTER_FSEL_1kHz, 0);
    
    // 퉹M̏o͊Jn
    result = m_MICTesterIF.WaveStart();

    // OEBhE֌ʂo
    sys::ATTR_TEXT_COLOR color = ((0 != result) ? sys::ATTR_COLOR_MAGENTA 
                                                : sys::ATTR_COLOR_WHITE);
    m_TWndLog->SetTextColor(color);
    ( 0 != result ) ? m_TWndLog->Printf("Failed to Start(%08Xh)\n", result) 
                    : m_TWndLog->Printf("1kHz Wave Start\n");
}

//---------------------------------------------------------------------------
//  Desc: R}hu(TEST) WAVE STOPvF퉹Mo͒~
//---------------------------------------------------------------------------
void MicTesterCommand::Cmd_WaveStop(void)
{
    u32 result = 0x0;
    
    // 퉹M̏o͒~
    result = m_MICTesterIF.WaveStop();

    // OEBhE֌ʂo
    sys::ATTR_TEXT_COLOR color = ((0 != result) ? sys::ATTR_COLOR_MAGENTA 
                                                : sys::ATTR_COLOR_WHITE);
    m_TWndLog->SetTextColor(color);
    ( 0 != result ) ? m_TWndLog->Printf("Failed to Stop(%08Xh)\n", result) 
                    : m_TWndLog->Printf("Wave Stop\n");
}

//---------------------------------------------------------------------------
//  Desc: R}hu(COMM) READ STATUS REGISTERvFXe[^XWX^[h
//---------------------------------------------------------------------------
void MicTesterCommand::Cmd_ReadRegister(void)
{
    // R}hp[^͗pEChE̐
    CreateCommandSettingWindow("Set Parameter", 15, 4);
    
    // p[^̓V[PX
    m_IWndCommand->Printf("\f");
    m_IWndCommand->Printf("0: One Time\n1: All Time");
    m_IWndCommand->Printf("\n\nUpdate= ");
    m_IsReadStatusAllTime = static_cast<bool>(m_IWndCommand->InputData16(0));
    
    // 킩烊[h
    MICTesterStatus status = m_MICTesterIF.GetTesterStatus();
    
    m_TWndLog->Printf("GET: STATUS Reg(%Xh)\n", status.raw);
    PrintStatusReg(status);    
    
    // EChE폜
    DestroyCommandSettingWindow();
}

//---------------------------------------------------------------------------
//  Desc: (Overload) ėpWX^[hR}h
//---------------------------------------------------------------------------
void MicTesterCommand::Cmd_ReadRegister(bool alltime)
{
    m_IsReadStatusAllTime = alltime;
    
    // 킩烊[h
    MICTesterStatus status;
    status.raw = m_MICTesterIF.ReadGeneralRegister();
    
    PrintStatusReg(status);
}

//---------------------------------------------------------------------------
//  Desc: R}hu(COMM) WRITE GENERALREGvFXe[^XėpWX^Cg
//---------------------------------------------------------------------------
void MicTesterCommand::Cmd_WriteGeneralRegister(void)
{
    // R}hp[^͗pEChE̐
    CreateCommandSettingWindow("Set Parameter", 15, 2);
    
    // p[^̓V[PX
    m_IWndCommand->Printf("\f");
    m_IWndCommand->Printf("DATA = ");
    u8 data = static_cast<u8>(m_IWndCommand->InputData16(0));
    
    // ėpWX^Cg
    m_MICTesterIF.WriteGeneralRegister(data);
    
    // Xe[^XEBhE֌ʂo
    Cmd_ReadRegister(ONE_TIME);
    
    // OEBhE֌ʂo
    m_TWndLog->SetTextColor(sys::ATTR_COLOR_MAGENTA);
    m_TWndLog->Printf("WRITE:addr(01h)data(%02X)\n", data);
    
    // EChE폜
    DestroyCommandSettingWindow();
}

}   // namespace eva
}   // namespace uji

