/*--------------------------------------------------------------------------*
 Project:
 File: mic_TesterCalibrator.h

*--------------------------------------------------------------------------*/
#ifndef __MIC_TESTER_CALIBRATOR_H__
#define __MIC_TESTER_CALIBRATOR_H__


#include "sys.h"
#include "mic_TesterRegister.h"
#include "mic_TesterCommand.h"
#include "mic_Lib.h"
#include <nn/types.h>

namespace uji {
namespace eva {

/*
    Desc: JPEG`悷
    
    TODO: ǂʂ̏ꏊ
*/
class JpegDrawer 
{
public:    
    JpegDrawer() : m_isOpen(false), m_TextureId(0)
    {}
    virtual ~JpegDrawer(){}

    void OpenPicture(wchar_t *file);
    void ClosePicture();
    void DrawPicture();

private:
    bool m_isOpen;
	GLuint m_TextureId;    
    sys::JpegTexture m_jt;    
};

/*
    Desc: 퉹MLuׂɕKvȏ
*/
typedef struct {
    char* szUsage;          // Lu[V̗pr\
    
    MICTesterFreq fsel;     // 퉹M̎g
    u8 calib_id;            // Lu[Vێ錟ID
    
    u16 amplitude;          // 背x
    u16 amp_margin;         // 背x̃}[W
    
    u8 ctrGain;             // CTR̃QC
} 
TesterCalibrationSetting;

/*
    Desc: }CNLu[VNX
*/
class MicTesterCalibrator
{
public:
    // RXgN^
    MicTesterCalibrator() : m_LogCount(0)
    {
        const u8 Config_CdcSensitivityGain = 55;   // 38.0dB
      //const u8 Config_CdcSensitivityGain = 67;   // 44.0dB
        
        const u8 MIC_TESTER_FSEL_4kHz   = 0x01;
        const u8 MIC_TESTER_FSEL_1kHz   = 0x07;
        const u8 MIC_TESTER_FSEL_200Hz  = 0x27;
        
        // Luݒ̈̓Im
        m_ppTesterCalibSetting = new TesterCalibrationSetting*[MODEL_NUM];
        for (int i=0; i<MODEL_NUM; i++) 
        {
            m_ppTesterCalibSetting[i] = new TesterCalibrationSetting[CALIBRATE_NUM];
        }        
    
        /*
            CTRpLuݒ
        */
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_CTR_SENS].szUsage    = "CTR Sensitive Test";
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_CTR_SENS].fsel       = MIC_TESTER_FSEL_1kHz;
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_CTR_SENS].calib_id   = CALIBRATION_ID_OFFSET_CTR + 0;
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_CTR_SENS].amplitude  = 28800;
      //m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_CTR_SENS].amplitude  = 32768; // 44.0dB ̏ꍇ
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_CTR_SENS].amp_margin = 512;
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_CTR_SENS].ctrGain    = Config_CdcSensitivityGain;
        
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_NTR_SENS].szUsage    = "NTR Sensitive Test";
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_NTR_SENS].fsel       = MIC_TESTER_FSEL_1kHz;
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_NTR_SENS].calib_id   = CALIBRATION_ID_OFFSET_CTR + 1;
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_NTR_SENS].amplitude  = 28800;
      //m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_CTR_SENS].amplitude  = 32768; // 44.0dB ̏ꍇ
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_NTR_SENS].amp_margin = 512;
        m_ppTesterCalibSetting[MODEL_CTR][CALIBRATE_NTR_SENS].ctrGain    = Config_CdcSensitivityGain;
        
        /*
            ^Ȃ񂩂oꂵEEetc.
        */
        // TODO: 
    }
    
    // fXgN^
    virtual ~MicTesterCalibrator()
    {
        for (int i=0; i<MODEL_NUM; i++) {
            delete[] m_ppTesterCalibSetting[i];
        }
        delete[] m_ppTesterCalibSetting;
    }
    
    // Luݒ̎擾
    TesterCalibrationSetting* GetCalibrationSetting(int model, int calib_element) {
        return &m_ppTesterCalibSetting[model][calib_element];
    }

    // ^^oĂǉo^
    enum PRODUCT_MODEL{
        MODEL_CTR = 0,
        MODEL_NUM
    };
        
    enum CALIBRATE_ELEMENT{
      CALIBRATE_CTR_SENS = 0,
      CALIBRATE_NTR_SENS,
      CALIBRATE_NUM
    };

    // Lu[V
    void Calibrate(void);
    static void sRun()
    {
        MicTesterCalibrator e;
        e.Calibrate();
    }    
    
private:
    bool CalibrateCore(TesterCalibrationSetting* setting);
    MICTesterCalibLevelReq GetLevelCtrl(u16 amplitude, u16 amp_margin);
    u32 CHK_FATAL_ERROR(u32 result, const char* message);    
    void UpdateDisplay();
    void LogPrintf(sys::TextWindow *wnd, sys::ATTR_TEXT_COLOR color, const char* format, ...);
        
    // }CNCu
    MicLib* m_pMicLib;
    // 퐧
    MicTesterInterface* m_pTesterInterface;
    // Luݒf[^ւ̃|C^
    // ̔hfzđzŊm
    TesterCalibrationSetting** m_ppTesterCalibSetting;
    // EChE}l[W    
    sys::WindowManager m_WndManager;
    // EChE
    sys::TextWindow* m_DebugWnd;
    sys::TextWindow* m_InfoWnd;
    // OJE^
    int m_LogCount;
    
    // 摜\p
    JpegDrawer* m_JpegDrawer;
        
    static const u8 CALIBRATION_ID_OFFSET_CTR = 0x0;
};


} // namespace
}

#endif
