/*--------------------------------------------------------------------------*
 Project:
 File: mic_TesterCalibrator.cpp


*--------------------------------------------------------------------------*/
#include "mic_TesterCalibrator.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../sys/sys_SoundPlayer.h"
#include <nn.h>


namespace uji {
namespace eva {


/*
    Desc: Lu[V

    Args: Ȃ

    Rtns: Ȃ
*/
void MicTesterCalibrator::Calibrate(void)
{
    enum _MODE {
        CALIBRATE_MICTESTER = 0,
        MICTEST             = 1
    };

    bool result;
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();

    const int FONT_SIZE = 12;
    const int DEBUG_WND_WIDTH  = 400/(FONT_SIZE/2);
    const int DEBUG_WND_HEIGHT = 12;
    const int INFO_WND_WIDTH   = 400/(FONT_SIZE/2);
    const int INFO_WND_HEIGHT  = 5;

    // 󋵏o͗pEChE̐
    m_DebugWnd = new sys::TextWindow(DEBUG_WND_WIDTH, DEBUG_WND_HEIGHT, FONT_SIZE);
    m_DebugWnd->SetTitle("Debug Log");
    m_WndManager.CreateWindow(m_DebugWnd, NN_GX_DISPLAY0, 0, 0);

    // Luo͗pEChE̐
    m_InfoWnd = new sys::TextWindow(INFO_WND_WIDTH, INFO_WND_HEIGHT, FONT_SIZE);
    m_InfoWnd->SetTitle("Calibrataion Setting");
    m_WndManager.CreateWindow(m_InfoWnd, NN_GX_DISPLAY0, 0, m_DebugWnd->GetSize().height);
    m_InfoWnd->SetActiveFlag(false);

    // 퐧p
    m_pTesterInterface = new MicTesterInterface;

    // 摜\p
    m_JpegDrawer = new JpegDrawer;

    // ŏɔÖׂɌ킪Lu[V[hł邱Ƃ̔܂
    MicTesterInterface* p  = new MicTesterInterface;
    MICTesterStatus status = p->GetTesterStatus();
    delete p;
    if( status.MODE!=CALIBRATE_MICTESTER )
    {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_RED, "Test Mode isn't CALIBRATE_MICTESTER.\n");
        UpdateDisplay();
        result = false;
        goto Finalize;
    }

    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_GREEN, "Tester Calibration Ready.\n");
    UpdateDisplay();

    // CTR}CN̏
    m_pMicLib = MicLib::GetInstance();;
    m_pMicLib->Initialize();
    m_pMicLib->TurnOnMic();
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE, "MIC Initialized.\n");
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500)); // Ö 500mS X[v

    // Lu[V̉ʂ\
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/MicTesting.jpg");
    UpdateDisplay();

    // Lu[V{
    for (int i=0; i<CALIBRATE_NUM; i++)
    {
        // TODO: i͌̃WX^擾āAʂɂ
        CalibrateCore(GetCalibrationSetting(MODEL_CTR, i));
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_CYAN, "- COMPLETE(%d). -\n", i);
    }

    UpdateDisplay();

#ifndef EVA_MIC_FPC	// }CNFPC̏ꍇ̓OcȂ

    // Oɏ
    pdl->Initialize();
    pdl->Add_1Line(0, "MicCalib", "CALIBRATOR", "0.00", "", "", "", "The special calibrator.");
    pdl->Finalize();

#endif

    result = true;

Finalize:
    delete pdl;

    if( result )
    {
        // Lu[VIʂ\
        m_JpegDrawer->OpenPicture(L"rom:/jpeg/Pass.jpg");
        UpdateDisplay();
        // 艹
        sys::SoundPlayer().UjiSoundPlayer( "rom:/SoundPlayer/ok.wav", 1500 );
    }
    else
    {
        // Lu[VIʂ\
        m_JpegDrawer->OpenPicture(L"rom:/jpeg/Fail.jpg");
        UpdateDisplay();
        // 艹
        sys::SoundPlayer().UjiSoundPlayer( "rom:/SoundPlayer/ng.wav", 1500 );
    }

    while (1) {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));
    }

    // ɂ͗܂
#if 0
    delete m_DebugWnd;
    delete m_InfoWnd;
    delete m_pTesterInterface;
    delete m_pMicLib;
    delete m_JpegDrawer;
#endif
}

/*
    Desc: Lu[ṼRA

    Args: setting - Lupݒւ̃|C^

    Rtns: G[
*/
bool MicTesterCalibrator::CalibrateCore(TesterCalibrationSetting* setting)
{
    const char* __MESG_CALIB_SETUP = "Function Calibration setup";
    const char* __MESG_CALIB_LEVEL_CTRL = "Function Calibration level control";

    MICTesterCalibLevelReq level_req;

    m_InfoWnd->Printf("\f");
    m_InfoWnd->Printf("Usage     : %s\n", setting->szUsage);
    m_InfoWnd->Printf("FSEL      : %X\n", setting->fsel);
    m_InfoWnd->Printf("CALIB_ID  : %X\n", setting->calib_id);
    m_InfoWnd->Printf("Target Amp: %d(%d)\n", setting->amplitude, setting->amp_margin);
    m_InfoWnd->Printf("CTR Gain  : %.1lf[dB]", static_cast<double>(setting->ctrGain) /2.0 + 10.5);
    UpdateDisplay();

    // o͔g`̃ZbgAbv
    CHK_FATAL_ERROR(
        m_pTesterInterface->CalModeWaveSetup(setting->fsel, setting->calib_id),
        __MESG_CALIB_SETUP);

    // CTR̃QCݒ
    nn::mic::SetAmpGain(setting->ctrGain);

    u16 count=0;
    // Lu[V
    do {
        // xvZo
        level_req = GetLevelCtrl(setting->amplitude, setting->amp_margin);

        // o̓x̕ύXvݒ
        CHK_FATAL_ERROR(
            m_pTesterInterface->CalModeLevelControl(level_req),
            __MESG_CALIB_LEVEL_CTRL);

        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE,
            "- NOW CALIBRATING(%d) AMP(%d) LV_CTRL(%d). -\n", ++count, m_pMicLib->m_Amplitude, level_req);
        UpdateDisplay();
    }
    while (level_req != CALIB_REQ_COMPLETE);

    return true;
}

/*
    Desc: g`𑪒肵Ao̓xvZo

    Args: amplitude     - Lu^[Qbg̐U
          amp_margin    - ^[Qbgɑ΂Ă̔}[W

    Rtns: level_req(MICTesterCalibLevelReq)
*/
MICTesterCalibLevelReq MicTesterCalibrator::GetLevelCtrl(u16 amplitude, u16 amp_margin)
{
    const int MEASUREMENT_RETRY_MAX = 1;
    const f32 MEASUREMENT_INTERVAL = 50;
    s32 micData[static_cast<size_t>(256.f)];

    MICTesterCalibLevelReq level_req;
    int measurement_count = 0;

    // Jn
    m_pMicLib->StartSampling();
    sys::WaitMilliSeconds(150);

    do {
        // TvOĐUZo
        m_pMicLib->GetMicData(micData, static_cast<size_t>(256.f));

        // ̉M傫邩H邩HIH𔻒
        if ((amplitude - amp_margin) > static_cast<u16>(m_pMicLib->m_Amplitude) )
        {
            return CALIB_REQ_INCREASE;      // 傫
        }
        // Ỏe󂯂\邽߃gCΏ
        else if ((amplitude + amp_margin) < static_cast<u16>(m_pMicLib->m_Amplitude) )
        {
            level_req = CALIB_REQ_DECREASE; // 菬
        }
        else
        {
            return CALIB_REQ_COMPLETE;  // Lu[V
        }

        measurement_count++;
        sys::WaitMilliSeconds(MEASUREMENT_INTERVAL);
    }
    while (measurement_count < MEASUREMENT_RETRY_MAX + 1);

    // ~
    m_pMicLib->StopSampling();

    return level_req;
}

/*
    Desc: vIG[̃`FbNG[̏

    Args: result  -
          message -

    Rtns: 펞0BG[͖߂܂B
*/
u32 MicTesterCalibrator::CHK_FATAL_ERROR(u32 result, const char* message)
{
    const u32 REGSPI_R_STATUS_ERROR_CODE_MASK= 0xf0;
    MICTesterStatus status;

    if (result == MICI_RESULT_SUCCESS)
    {
        return result;
    }

    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE, "Result(%Xh)\n", result);
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE, "Message: %s\n", message);

    // TODO: Lu[V[hł邱Ƃ̔

    status.raw = static_cast<u8>(result & 0xff);
    // 킪ڑĂȂiJ[hRlN^ڐGsetc.j
    if (status.raw & REGSPI_R_STATUS_ERROR_CODE_MASK == REGSPI_R_STATUS_ERROR_CODE_MASK) {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_RED, "- CARD INTERFACE ERROR -\n");
    }
    // ~{^ꂽ
    else if (status.STOP_EVENT) {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_RED, "- STOP BUTTON PUSHED -\n");
    }
    // Lu[VɎs
    else if (status.ERR == MIC_REGSPI_R_STATUS_ERROR_CALIBRATION) {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_RED, "- CALIBRATION FAILED -\n");
        // G[ʂ̕\
        m_JpegDrawer->OpenPicture(L"rom:/jpeg/Fail.jpg");
        UpdateDisplay();
        // 艹
        sys::SoundPlayer().UjiSoundPlayer( "rom:/SoundPlayer/ng.wav", 1500 );
        while (1) {
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));
        }
    }
    // ̑vIG[
    else {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_RED, "- FATAL ERROR OCCURRED -\n");
    }

    // G[ʂ̕\
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/FatalError.jpg");
    UpdateDisplay();
    // 艹
    sys::SoundPlayer().UjiSoundPlayer( "rom:/SoundPlayer/ng.wav", 1500 );

    while (1) {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));
    }

    // ɂ͗܂
}

/*
    Desc: ʍXV

    Args: Ȃ

    Rtns: Ȃ
*/
void MicTesterCalibrator::UpdateDisplay()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    /* ------------------------------------------------------------------------
            ʕ`
    ------------------------------------------------------------------------ */
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();
    m_WndManager.DrawDisplay0();
    gfx->m_DrawFramework->SwapBuffers();

    /* ------------------------------------------------------------------------
            ʕ`
    ------------------------------------------------------------------------ */
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();

    // 摜\
    m_JpegDrawer->DrawPicture();

    m_WndManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*
    Desc: OJEgtPrintf
*/
void MicTesterCalibrator::LogPrintf(sys::TextWindow *wnd, sys::ATTR_TEXT_COLOR color, const char* format, ...)
{
    sys::ATTR_TEXT_COLOR prev_color = wnd->GetTextColor();

    wnd->SetTextColor(sys::ATTR_COLOR_WHITE);
    wnd->Printf("%03d> ", m_LogCount++);

    wnd->SetTextColor(color);
    va_list vlist;
    va_start(vlist, format);
    wnd->VPrintf(format, vlist);
    va_end(vlist);

    wnd->SetTextColor(prev_color);
}


//============================================================================
//                      Jpeg摜\֘A
//============================================================================

/*
    Desc: 摜I[v
*/
void JpegDrawer::OpenPicture(wchar_t *file)
{
    if (m_isOpen)
    {
        ClosePicture();
    }
    else if (m_TextureId != 0)
    {
        sys::GraphicsDrawing::GetInstance()->m_DrawFramework->DeleteTexture(m_TextureId);
    }
    m_jt.Open(file);
    sys::GraphicsDrawing::GetInstance()->m_DrawFramework->GenerateTexture(
        GL_TEXTURE_2D,
        GL_RGB_NATIVE_DMP,
        m_jt.GetWidth(),
        m_jt.GetHeight(),
        GL_RGB_NATIVE_DMP,
        GL_UNSIGNED_SHORT_5_6_5,
        m_jt.GetTextureDataPointer(),
        m_TextureId);

    m_isOpen = true;
}

/*
    Desc: 摜N[Y
*/
void JpegDrawer::ClosePicture()
{
    if (m_TextureId != 0)
    {
        sys::GraphicsDrawing::GetInstance()->m_DrawFramework->DeleteTexture(m_TextureId);
        m_jt.Close();
        m_TextureId = 0;

        m_isOpen = false;
    }
}

/*
    Desc: 摜\
*/
void JpegDrawer::DrawPicture()
{
    if (!m_isOpen)
    {
        return;
    }

    sys::GraphicsDrawing::GetInstance()->SetScreenSize(
        sys::GraphicsDrawing::DISPLAY1_WIDTH, sys::GraphicsDrawing::DISPLAY1_HEIGHT);
    sys::GraphicsDrawing::GetInstance()->m_DrawFramework->FillTexturedRectangle(
        m_TextureId,
        0.0f, 0.0f,
        sys::GraphicsDrawing::DISPLAY1_WIDTH, sys::GraphicsDrawing::DISPLAY1_HEIGHT,
        sys::GraphicsDrawing::DISPLAY1_WIDTH, sys::GraphicsDrawing::DISPLAY1_HEIGHT,
        m_jt.GetWidth(), m_jt.GetHeight());
}


}   // namespace
}
