/*--------------------------------------------------------------------------*
 Project:
 File: mic_Tester.h

*--------------------------------------------------------------------------*/

#ifndef __MIC_TESTER_H__
#define __MIC_TESTER_H__

#include <nn.h>
#include <nn/math.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include <nn/cfg/CTR/detail/cfg_Default.h>
#include "sys.h"
#include "mic_TesterRegister.h"
#include "mic_TesterCommand.h"
#include "mic_TesterCalibrator.h"
#include "mic_Lib.h"
#include "../sound/TestSound.h"
#include "../codec/TestCodec.h"
#include "../seq/Config.h"
#include "../seq/TestResult.h"
#include "../seq/TesterLog/ProductionLog.h"

using namespace uji;
using namespace uji::sys;


namespace
{
    // Lu[V
    typedef enum
    {
        PGA_CALIB_STAT_INITIAL = 0,
        PGA_CALIB_STAT_TARGET_ADJUSTMENT,
        PGA_CALIB_STAT_FINE_ADJUSTMENT,
        PGA_CALIB_STAT_COMPLETE,
        PGA_CALIB_STAT_FATAL_ERROR
    }
    MICPgaGainCalibStatus;

    typedef enum
    {
        PGA_GAIN = 0
    }
    CodecInitParam;


}


namespace uji {
namespace eva {
namespace mic_t {

    extern bool TestExecuteCalibrateTester( uji::seq::TestResult &result );
    extern bool TestExecuteInitialize( uji::seq::TestResult &result );
    extern bool TestExecuteCtrModeDcOffset( uji::seq::TestResult &result );
    extern bool TestExecuteCtrModeInput( uji::seq::TestResult &result );
    extern bool TestExecuteCalibratePgaGain( uji::seq::TestResult &result );
    extern bool TestExecuteSensitivity( uji::seq::TestResult &result );
    extern bool TestExecuteWriteData2SD( uji::seq::TestResult &result );
    extern bool TestExecuteSetCalPgaGain( uji::seq::TestResult &result );
    extern bool TestExecuteFinalize( uji::seq::TestResult &result );
    extern bool TestExecuteWriteProductionLogOk( uji::seq::TestResult &result );
    extern bool TestExecuteShowMajorVariable( uji::seq::TestResult &result );

class MicTester
{
private:
    MicTester()
    {
        if (m_pInstance != NULL)
        {
            NW_FATAL_ERROR("MicTester instance already exists.");
        }
        m_pInstance = this;
    };

public:
    static MicTester* GetInstance()
    {
        if (m_pInstance == 0)
        {
            m_pInstance = new MicTester;
        }
        return m_pInstance;
    }

    static void sCalibratePgaGain( void )
    {
        uji::sys::Pad pad;

        MicTester e;
        e.ExecuteInitialize();
        e.ExecuteCalibratePgaGain();
        e.ExecuteFinalize();
    }
    static void sCalibratePgaGainReset()
    {
        uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        uji::sys::Pad pad;

        MicTester e;
        e.ExecuteResetCalPgaGain();

        Menu::m_SubWindow->Printf("\f");
        Menu::m_SubWindow->Printf(" - MESSAGE - \n");
        Menu::m_SubWindow->Printf("     Reset Completed!");
        Menu::m_SubWindow->Printf("\n");
        Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
        Menu::m_SubWindow->Printf("     B : Exit\n");
        sys::Menu::m_WindowManager.Update();
        sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        do{
            pad.UpdatePad();
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));
        }while(!pad.IsButtonDown(Pad::BUTTON_B));
    }

    /*---------------------------------------------------------------------------
       o֐
    ---------------------------------------------------------------------------*/
    bool ExecuteInitialize( void );                             // 
    bool ExecuteFinalize( void );                               // I
    bool ExecuteShowMajorVariable( void );                      // vȕϐʕ\
    bool ExecuteCheckStableTime( void );                        // 莞Ԍ
    bool ExecuteDcOffset( void );                               // ItZbg
    bool ExecuteMicInput( void );                               // ͌
    bool ExecuteCalibratePgaGain( void );                       // }CNx
    bool ExecuteSensitivity( void );                            // }CNx
    bool ExecuteWriteData2SD( void );                            // OEf[^o(SD)
    s32  ExecuteSetCalPgaGain( u16 param );                     // CAL 
    s32  ExecuteResetCalPgaGain( void );                        // CAL Zbg
    bool ExecuteGetCalPgaGain( nn::drivers::cal::CTR::CodecCalDataCore* pc ); // CAL Ǎ

private:
    bool MicTester_TurnOnMic( bool bMsg=false );
    bool MicTester_TurnOffMic( bool bMsg=false );
    void MicTesterUpdatePgaGain( void );
    bool CalibratePgaGainCore(TesterCalibrationSetting* setting);
    f32  MicTester_CalGainDiff(u16 amp_target, u16 amp_input);
    void GetMicSamplingAmpMaxMin(int samp_data_num, s32* p_amp_max, s32* p_amp_min);
    bool GetMicSamplingAve(int samp_data_num, int sampling_count, u16* p_amp, bool IsThreshChk, u16 InvalidThresholdMax);
    bool GetAmplitudeAve(int samp_data_num, int sampling_count, u16* p_amp, MICPgaGainCalibStatus* p_status,
                         bool IsThreshChk=false, u16 InvalidThresholdMax=65535);
    f32  GetPgaGainLevelCtrl(u16 amp_target, u16 amp_margin, u16* p_amp, MICPgaGainCalibStatus* p_status);
    u32  CHK_FATAL_ERROR(u32 result, const char* message);

    void UpdateDisplay();
    void LogPrintf(sys::TextWindow *wnd, sys::ATTR_TEXT_COLOR color, const char* format, ...);

    // SDւ̃Oo͗p
    bool CreateDirectorySdmc( const wchar_t* path );
    bool WriteData2SD( const wchar_t* path, string line );

    // ʖڎmFp
    void MicTesterWait( int milliseconds );

    /*---------------------------------------------------------------------------
       oϐ
    ---------------------------------------------------------------------------*/
    // VOgIuWFNgւ̃|C^
    static MicTester* m_pInstance;

    // }CNCu
    MicLib* m_pMicLib;

    MicTesterCalibrator*        m_pTCal;    // Lu[^
    MicTesterInterface*         m_pTesterInterface;     // 퐧

    // EChE}l[W
    sys::WindowManager m_WndManager;

    // EChE
    sys::TextWindow* m_DebugWnd;
    sys::TextWindow* m_InfoWnd;

    // RtBOݒ
    uji::seq::Config m_Config;

    // OJE^
    int m_LogCount;

    // 摜\p
    sys::JpegDrawer* m_JpegDrawer;

    // 
    s64  m_StableTime;          // }CN̈莞
    u16  m_AmpSilent;           // ̐U
    u16  m_AmpImput;            // }CNO}CNւ̐ؑ֔莞̐U
    u16  m_AmpSens;             // x̌ʁi\EOo͗pj
    u16  m_AmpSmpl16kHz;        // TvOg 16kHz ł̊x
    u16  m_AmpSmpl32kHz;        // TvOg 32kHz ł̊x
    f32  m_CurrentPgaGainF32;   // PGA Gain ␳l(f32)
    u8   m_CurrentPgaGainHex;   // PGA Gain ␳l(hex)
    char m_SerialNumber[16];    // VAԍ
    char m_MacAddress[32];      // }bNAhX

    // config Őݒ
    u16 STABLE_THRESHOLD_MIN;   // 莞Ԍ     Uŏ臒l
    u16 STABLE_THRESHOLD_MAX;   // 莞Ԍ     Uő臒l
    u64 STABLE_TIMEOUT;         // 莞Ԍ     ^CAEg
    u16 INPUT_TEST_DECIBEL;     // ͌             fVx
    u16 INPUT_TEST_THRESHOLD;   // ͌             U臒l
    u16 PGA_GAIN_AMP_TARGET;    // Lu[V   QCڕWl
    u16 PGA_GAIN_AMP_MARGIN;    // Lu[V   ڕWl̗]
    u16 SENSITIVITY_THRESHOLD_MIN;  // x         U臒lilj
    u16 SENSITIVITY_THRESHOLD_MAX;  // x         U臒lilj
    bool WRITE_DATA_TO_SD;      // L̏ꍇASDJ[hɃOo͂

public:
    uji::seq::TestResult  m_TestResult;

};


} // namespace
}
}

#endif
