
#include <string>
#include "mic_Tester.h"
#include "../seq/TestSequencer.h" 
#include "../sys/sys_GetSerialNumber.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

#define  MIC_TESTER_DEBUGGER 0 // fobOɂ 1 

using namespace uji;
using namespace uji::sys;
using namespace std;

namespace uji {
namespace eva {
namespace mic_t {

MicTester* MicTester::m_pInstance = 0;

static nn::drivers::cal::CTR::CodecCalDataCore s_CodecCalDataCore;
static char s_MajorVariable[256];
static char s_ProductionLogString[80];

void MicTester::MicTesterWait( int milliseconds )
{
    // ʊmFp
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_MAGENTA, 
        "====================== Wait(%dms) ======================\n", milliseconds);
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/Wait.jpg");
    UpdateDisplay();
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(milliseconds));
}

//============================================================================
//============================================================================
//                              C֐
//============================================================================
//============================================================================
/*---------------------------------------------------------------------------
  Desc: 

  Args: Ȃ

  Rtns: ^s
---------------------------------------------------------------------------*/
bool MicTester::ExecuteInitialize( void )
{
    const int FONT_SIZE        = 12;
    const int DEBUG_WND_WIDTH  = 400/(FONT_SIZE/2);
    const int DEBUG_WND_HEIGHT = 13;
    const int INFO_WND_WIDTH   = 400/(FONT_SIZE/2);
    const int INFO_WND_HEIGHT  = 5;
    
    uji::seq::Config config;
    
    // oϐ̏iVOĝ߁j
    {
        STABLE_THRESHOLD_MIN  = config.Get().StableThresholdMin;
        STABLE_THRESHOLD_MAX  = config.Get().StableThresholdMax;
        STABLE_TIMEOUT        = config.Get().StableTimeOut;
        INPUT_TEST_DECIBEL    = config.Get().InputTestDecibel;
        INPUT_TEST_THRESHOLD  = config.Get().InputTestThreshold;
        PGA_GAIN_AMP_TARGET   = config.Get().PgaGainAmpTarget;
        PGA_GAIN_AMP_MARGIN   = config.Get().PgaGainAmpMargin;
        SENSITIVITY_THRESHOLD_MIN = config.Get().SensTestThresholdMin;
        SENSITIVITY_THRESHOLD_MAX = config.Get().SensTestThresholdMax;
        WRITE_DATA_TO_SD      = config.Get().WriteData2SdMicT;
        
        m_LogCount           = 0;
        
        m_JpegDrawer = new sys::JpegDrawer;
        m_pTCal = new MicTesterCalibrator;
        
        m_StableTime         = 0;
        m_AmpSilent          = 0;
        m_AmpImput           = 0;
        m_AmpSens            = 0;
        m_AmpSmpl16kHz       = 0;
        m_AmpSmpl32kHz       = 0;
        m_CurrentPgaGainF32  = 0.f;
        m_CurrentPgaGainHex  = 0x0;
        sprintf(m_SerialNumber, "");
        sprintf(m_MacAddress  , "");
        
        m_TestResult.m_Result = false;
        m_TestResult.m_Micro  = 0;
        sprintf(m_TestResult.m_String, "");
    }
    
    // SerialNumber̎擾
    uji::sys::GetSerialNumber( m_SerialNumber );
    
    // MacAhX擾
    bit8 mac[6]={0,0,0,0,0,0};
    uji::sys::GetMacAddress(mac);
    sprintf(m_MacAddress,  "%02X::%02X::%02X::%02X::%02X::%02X", 
        mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
    
    // 󋵏o͗pEChE̐
    m_DebugWnd = new sys::TextWindow(DEBUG_WND_WIDTH, DEBUG_WND_HEIGHT, FONT_SIZE);
    m_DebugWnd->SetTitle("Debug Log");
    m_WndManager.CreateWindow(m_DebugWnd, NN_GX_DISPLAY0, 0, 0);
    
    // Luo͗pEChE̐
    m_InfoWnd = new sys::TextWindow(INFO_WND_WIDTH, INFO_WND_HEIGHT, FONT_SIZE);
    m_InfoWnd->SetTitle("Calibrataion Setting");
    m_WndManager.CreateWindow(m_InfoWnd, NN_GX_DISPLAY0, 0, m_DebugWnd->GetSize().height);
    m_InfoWnd->SetActiveFlag(false);
    
    // Hƌ̉ʂXV
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/Donttoutch.jpg");
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_CYAN, "@ INITIALIZE\n");
    UpdateDisplay();
    
    // }CN
    u8 defaultAmp = nn::mic::AMP_GAIN_DEFAULT_VALUE + 24;
    m_pMicLib = MicLib::GetInstance();
    m_pMicLib->PresetSamplingType(m_pMicLib->MIC_SAMPLING_TYPE_16BIT);
    m_pMicLib->PresetSamplingRate(m_pMicLib->MIC_SAMPLING_RATE_32730);
    nn::mic::SetAmpGain(defaultAmp);
    
    // CAL ̕␳l PGA Gain Calibration ɏ
    MicTesterUpdatePgaGain();
    
    // ʕ\
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_MAGENTA, "SAMPLING TYPE : %s\n",       m_pMicLib->GetSamplingType());
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_MAGENTA, "SAMPLING RATE : %5.2fkHz\n", 1/1000.f * m_pMicLib->GetSamplingRate());
    m_InfoWnd->Printf("CTR GAIN      : %4.1lf(dB)\n", 10.5+static_cast<f64>(defaultAmp)/2.0f);
    m_InfoWnd->Printf("PGA GAIN      : %4.1lf(dB)[%02d]\n", m_CurrentPgaGainF32, m_CurrentPgaGainHex);
    UpdateDisplay();
    
    // }CNON
    m_TestResult.m_Result = MicTester_TurnOnMic(true);
    nn::mic::SetClamp(false);  // Nv𖳌ɂ EVA_SDK_0_14_1
    
    // fobOp
#if MIC_TESTER_DEBUGGER==1
    MicTesterWait(2000);
#endif
    
    if( m_TestResult.m_Result )
    {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_GREEN, "passed!\n");
        UpdateDisplay();
    }
    else
    {
        ExecuteWriteData2SD();
        ExecuteFinalize();
    }
    
    return m_TestResult.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: I

  Args: Ȃ

  Rtns: I^s
---------------------------------------------------------------------------*/
bool MicTester::ExecuteFinalize( void )
{
    // Hƌ̉ʂXV
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_CYAN, "@ FINALIZE\n");
    m_InfoWnd->Printf("\f");
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/Wait.jpg");
    UpdateDisplay();
    
    // }CNdOFF
    MicTester_TurnOffMic(true);
    
    {
        // ProductionLog ɏo͂镶
        //  NG ɍŏIʂɕ\
        sprintf(s_ProductionLogString, 
            " PGA Gain=%.1fdB\n"
            " Time=%dms\n"
            " Silent=%d Input=%d Sens=%d", 
            m_CurrentPgaGainF32, (int)m_StableTime, m_AmpSilent, m_AmpImput, m_AmpSens
            );
        
        //  OK ɍŏIʂɕ\
        sprintf(s_MajorVariable, 
            " SerNumber  %s\n"
            " MacAddress %s\n"
            "\n"
            " PGA Gain   = %4.1f(dB)\n"
            " StableTime = %4d(ms)\n"
            " Amp Silent = %d  Input = %d  Sens = %d", 
            m_SerialNumber, m_MacAddress, 
            m_CurrentPgaGainF32, (int)m_StableTime, m_AmpSilent, m_AmpImput, m_AmpSens
            );
    }
    
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_GREEN, "passed!\n");
    UpdateDisplay();
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1000)); // ʊmFp
    
    // 摜̔j
    m_JpegDrawer->ClosePicture();
    
    m_WndManager.DestroyWindow(m_DebugWnd);
    m_WndManager.DestroyWindow(m_InfoWnd);
    
    delete m_pTCal;
    delete m_JpegDrawer;
    
    return true;
}

/*---------------------------------------------------------------------------
  Desc:  OK AOo͌ɏdvȃf[^\֐

  Args: Ȃ

  Rtns: ^s
---------------------------------------------------------------------------*/
bool MicTester::ExecuteShowMajorVariable( void )
{
    // bZ[WɃRs[
    sprintf(m_TestResult.m_String, "%s", s_MajorVariable);
    return true;
}

/*---------------------------------------------------------------------------
  Desc: }CNdI瑪Jn܂ł̈莞ԂƖ̐Uőŏl

  Args: Ȃ

  Rtns: ԓɈ艻^^CAEg
---------------------------------------------------------------------------*/
bool MicTester::ExecuteCheckStableTime( void )
{
    m_TestResult.m_Result = false;
    
    enum enumMicroErrorId
    {
        STABLE_TIME_OUT         = 0		// 莞Ԍv^CAEg
    };
    
    nn::os::Tick start           = nn::os::Tick(0);
    nn::os::Tick current         = nn::os::Tick(0);
    s64          tempStableTime  = (current-start).ToTimeSpan().GetMilliSeconds();
    s64          compareTime     = (current-start).ToTimeSpan().GetMilliSeconds();
    
    s32 stableAmpMin  = 0;
    s32 stableAmpMax  = 0;
    s32 compareAmpMin = 0;
    s32 compareAmpMax = 0;
    int sampleDataNum = 256;
    s32 micData[static_cast<size_t>(sampleDataNum)];
    
    uptr pLastSampAddr;
    uptr pStableSampAddr;
    
    const u64 MSEC_STABLE_DECISION_REGION = 100;    // 莞Ԃm肷߂̊
    
    // Hƌ̉ʂXV
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_CYAN, "@ CHECK STABLE TIME\n");
    m_InfoWnd->Printf("\f");
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/MicTesting.jpg");
    UpdateDisplay();
    
    // U}CNOFF
    MicTester_TurnOffMic();
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1000));
    
    // }CNON
    MicTester_TurnOnMic();
    
    // vJn
    start = nn::os::Tick::GetSystemCurrent();
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_YELLOW, "Wait for about 1sec until stabilizing.\n");
    UpdateDisplay();
    
    // TvOJn
    m_pMicLib->StartSampling();
    // TvOJnɑ肳G邽߈ꗥ 100ms ̓EFCg
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
    
    // 0 ȊO̐U肳܂ő҂
    m_pMicLib->m_Amplitude = 0;
    while( m_pMicLib->m_Amplitude==0 )
    {
        m_pMicLib->GetMicData(micData, static_cast<size_t>(sampleDataNum));
    }
    
    do
    {
        // b莞Ԃ Max Min Addr ێ
        current        = nn::os::Tick::GetSystemCurrent();
        tempStableTime = (current-start).ToTimeSpan().GetMilliSeconds();
        m_pMicLib->GetMicData(micData, static_cast<size_t>(sampleDataNum));
        stableAmpMin = micData[m_pMicLib->m_MinIndex];
        stableAmpMax = micData[m_pMicLib->m_MaxIndex];
        pStableSampAddr = pLastSampAddr;
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE, "# Max=%d Min=%d\n", stableAmpMax, stableAmpMin);
        UpdateDisplay();
        
        if( STABLE_THRESHOLD_MIN <= stableAmpMin && stableAmpMax <= STABLE_THRESHOLD_MAX )
        {
            do
            {
                current     = nn::os::Tick::GetSystemCurrent();
                compareTime = (current-start).ToTimeSpan().GetMilliSeconds();
                m_pMicLib->GetMicData(micData, static_cast<size_t>(sampleDataNum));
                compareAmpMin = micData[m_pMicLib->m_MinIndex];
                compareAmpMax = micData[m_pMicLib->m_MaxIndex];
                
                // 莞臒lȓ̒l𑪒肵ꂽ莞Ԋm
                if ((compareTime - tempStableTime) > MSEC_STABLE_DECISION_REGION)
                {
                    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE, "$ Max=%d Min=%d\n", compareAmpMax, compareAmpMin);
                    UpdateDisplay();
                    m_TestResult.m_Result = true;
                    break;
                }
            }
            while( STABLE_THRESHOLD_MIN <= compareAmpMin && compareAmpMax <= STABLE_THRESHOLD_MAX );
        }
    }
    while( m_TestResult.m_Result==false && (current-start).ToTimeSpan().GetMilliSeconds() < STABLE_TIMEOUT );
    
    m_StableTime = (current-start).ToTimeSpan().GetMilliSeconds();
    
    // 莞Ԍ̌ʂ\
    sys::ATTR_TEXT_COLOR color = (( m_TestResult.m_Result ) ? sys::ATTR_COLOR_WHITE : sys::ATTR_COLOR_RED );
    LogPrintf(m_DebugWnd, color, "StableTime: %d(ms) Max: %d Min: %d Addr: 0x%08X\n", 
        (int)m_StableTime, stableAmpMax, stableAmpMin, (u32)pStableSampAddr);
    UpdateDisplay();
    
    // TvO~
    m_pMicLib->StopSampling();
    
    // fobOp
#if MIC_TESTER_DEBUGGER==1
    MicTesterWait(2000);
#endif
    
    if( m_TestResult.m_Result )
    {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_GREEN, "passed!\n");
        UpdateDisplay();
    }
    else
    {
        m_TestResult.m_Micro = STABLE_TIME_OUT;
        ExecuteWriteData2SD();
        ExecuteFinalize();
        
        // Oɏo
        sprintf( m_TestResult.m_String, s_ProductionLogString );
    }
    
    return m_TestResult.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: ̃}CNU

  Args: Ȃ

  Rtns: l^ُlv
---------------------------------------------------------------------------*/
bool MicTester::ExecuteDcOffset( void )
{
    m_TestResult.m_Result = false;
    
    MICPgaGainCalibStatus status = PGA_CALIB_STAT_INITIAL;
    
    enum enumMicroErrorId
    {
        AMP_LEVEL_HIGH          = 1,	// ̐U
        FAIL_GET_AMP_IN_SILENT  = 2		// lȏ̊Ԍvꂽi^CAEgj
    };
    
    // Hƌ̉ʂXV
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_CYAN, "@ DC OFFSET\n");
    m_InfoWnd->Printf("\f");
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/MicTesting.jpg");
    UpdateDisplay();
    
    // ̐Ui̕ρj 
    if(GetAmplitudeAve(256, 10, &m_AmpSilent, &status, true, 10000))
    {
        if( m_AmpSilent < STABLE_THRESHOLD_MAX - STABLE_THRESHOLD_MIN )
        {
            m_TestResult.m_Result = true;
        }
        else
        {
            // ̐U臒l傫ꍇ
            m_TestResult.m_Result = false;
            m_TestResult.m_Micro = AMP_LEVEL_HIGH;
        }
    }
    else
    {
        // lȏvꂽꍇ
        m_TestResult.m_Result = false;
        m_TestResult.m_Micro = FAIL_GET_AMP_IN_SILENT;
    }
    
    // 莞Ԍ̌ʂ͂łɕ\ς݂Ȃ̂ŁAł͖̌ʂ̂ݕ\
    sys::ATTR_TEXT_COLOR color = (( m_TestResult.m_Result ) ? sys::ATTR_COLOR_WHITE : sys::ATTR_COLOR_RED );
    LogPrintf(m_DebugWnd, color, "Amp silent=%d\n", m_AmpSilent);
    UpdateDisplay();
    
    // fobOp
#if MIC_TESTER_DEBUGGER==1
    MicTesterWait(2000);
#endif
    
    if( m_TestResult.m_Result )
    {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_GREEN, "passed!\n");
    }
    else
    {
        ExecuteWriteData2SD();
        ExecuteFinalize();
        
        // Oɏo
        sprintf( m_TestResult.m_String, s_ProductionLogString );
    }
    
    return m_TestResult.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: }CN͊mF

  Args: setting - Lupݒւ̃|C^

  Rtns: ͗L^
---------------------------------------------------------------------------*/
bool MicTester::ExecuteMicInput( void )
{
    m_TestResult.m_Result = false;
    
    MICPgaGainCalibStatus status = PGA_CALIB_STAT_INITIAL;
    
    const char* __MESG_WAVE_SETUP     = "Function Setup Wave";
    const char* __MESG_WAVE_OUT_START = "Function Start to Send Out Sine-Wave";
    const char* __MESG_WAVE_OUT_STOP  = "Function Stop Sending Sine-Wave";
    
    int sampleDataNum = 256;
    s32 inputAmpMin  = 0;
    s32 inputAmpMax  = 0;
    s32 micData[static_cast<size_t>(sampleDataNum)];
    
    // Hƌ̉ʂXV
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_CYAN, "@ INPUT TEST\n");
    m_InfoWnd->Printf("\f");
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/MicTesting.jpg");
    UpdateDisplay();
    
    m_pTesterInterface           = new MicTesterInterface;
    codec::TestCodec* pTestCodec = new codec::TestCodec;
    
    // Lu[VݒǍ
    int model    = m_pTCal->MODEL_CTR;
    int calib_id = m_pTCal->CALIBRATE_CTR_SENS;
    TesterCalibrationSetting* setting = m_pTCal->GetCalibrationSetting(model, calib_id);
    
    
    // o͔g`̃ZbgAbvEo
    CHK_FATAL_ERROR(
        m_pTesterInterface->WaveSetup(setting->fsel, setting->calib_id), 
        __MESG_WAVE_SETUP);
    CHK_FATAL_ERROR(
        m_pTesterInterface->WaveStart(), __MESG_WAVE_OUT_START);
    
    // fobOʗp
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE, 
        "DefaultGain=%.1lf(dB) PgaGain=%.1lf(dB) -> SetGain=%.1lf(dB)\n", 
        (f32)INPUT_TEST_DECIBEL, m_CurrentPgaGainF32, INPUT_TEST_DECIBEL - m_CurrentPgaGainF32);
    UpdateDisplay();
    
    // Amp ʏ팟荂߂ɐݒ肷
    // AAPGA Gain ɕ␳l܂Ăꍇ́A̕ij
    f32 setAmpGainDecibel = INPUT_TEST_DECIBEL - m_CurrentPgaGainF32;
    nn::mic::SetAmpGain( setAmpGainDecibel*2 - 10.5*2 );
    
    m_InfoWnd->Printf("\f");
    m_InfoWnd->Printf("FSEL = %X  CALIB ID = %X\n", setting->fsel, setting->calib_id);
    m_InfoWnd->Printf("CTR GAIN      : %4.1lf[dB]\n", (f32)INPUT_TEST_DECIBEL);
    m_InfoWnd->Printf("PGA GAIN      : %4.1lf[dB]\n", m_CurrentPgaGainF32);
    m_InfoWnd->Printf("AMP THRESHOLD : %d", INPUT_TEST_THRESHOLD);
    UpdateDisplay();
    
    // TvOJn
    GetAmplitudeAve(256, 10, &m_AmpImput, &status);
    
    sys::ATTR_TEXT_COLOR color;
    
    // Uȏł true
    if( m_AmpImput > INPUT_TEST_THRESHOLD )
    {
        m_TestResult.m_Result = true;
        color = sys::ATTR_COLOR_WHITE;
    }
    else
    {
        m_TestResult.m_Result = false;
        color = sys::ATTR_COLOR_RED;
        
    }
    
    // ʕ\
    LogPrintf(m_DebugWnd, color, "Amp Imput=%d\n", m_AmpImput);
    UpdateDisplay();
    
    // TvO~
    m_pMicLib->StopSampling();
    
    // M~
    CHK_FATAL_ERROR(m_pTesterInterface->WaveStop(), __MESG_WAVE_OUT_STOP);
    
    delete pTestCodec;
    delete m_pTesterInterface;
    
    // fobOp
#if MIC_TESTER_DEBUGGER==1
    MicTesterWait(2000);
#endif
    
    if( m_TestResult.m_Result )
    {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_GREEN, "passed!\n");
    }
    else
    {
        ExecuteWriteData2SD();
        ExecuteFinalize();
        
        // Oɏo
        sprintf( m_TestResult.m_String, s_ProductionLogString );
    }
    
    return m_TestResult.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: }CNx

  Args: Ȃ

  Rtns: Lu[V^s
---------------------------------------------------------------------------*/
bool MicTester::ExecuteCalibratePgaGain( void )
{
    m_TestResult.m_Result = false;
    
    //C[hݒ莞̂݃Lu[V
    uji::seq::Config config;
    if( config.Get().TestMode != uji::seq::pl::LINE )
    {
        return true;		// I
    }
    
    // Hƌ̉ʂXV
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_CYAN, "@ CALIBRATE MIC PGA GAIN\n");
    m_InfoWnd->Printf("\f");
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/MicTesting.jpg");
    UpdateDisplay();

    // Lu[V{
    int model    = m_pTCal->MODEL_CTR;
    int calib_id = m_pTCal->CALIBRATE_CTR_SENS;
    m_TestResult.m_Result = CalibratePgaGainCore(m_pTCal->GetCalibrationSetting(model, calib_id));
    
    // ʕ\
    sys::ATTR_TEXT_COLOR color = (( m_TestResult.m_Result ) ? sys::ATTR_COLOR_WHITE : sys::ATTR_COLOR_RED );
    LogPrintf(m_DebugWnd, color, "CAL PGA Gain=%4.1f\n", m_CurrentPgaGainF32);
    UpdateDisplay();
    
    // fobOp
#if MIC_TESTER_DEBUGGER==1
    MicTesterWait(2000);
#endif
    
    if( m_TestResult.m_Result )
    {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_GREEN, "passed!\n");
    }
    else
    {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_RED, "It failed to calibrate.\n");
        UpdateDisplay();
        ExecuteWriteData2SD();
        ExecuteFinalize();
        
        // Oɏo
        sprintf( m_TestResult.m_String, s_ProductionLogString );
    }
    
    return m_TestResult.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: }CNx

  Args: Ȃ

  Rtns: Lu[V^s
---------------------------------------------------------------------------*/
bool MicTester::ExecuteSensitivity( void )
{
    m_TestResult.m_Result = false;
    
    enum enumMicroErrorId
    {
        PASS                 = -1,
        HIGH_SENSITIVITY     =  0,	// x
        LOW_SENSITIVITY      =  1,	// xႢ
        DEFAULT              =  2	// l
    };
    
    enum enumMicroErrorId ret_16 = DEFAULT;
    enum enumMicroErrorId ret_32 = DEFAULT;
    
    u16 ampSensitivity = 0;
    MICPgaGainCalibStatus status = PGA_CALIB_STAT_INITIAL;
    
    const char* __MESG_WAVE_SETUP     = "Function Setup Wave";
    const char* __MESG_WAVE_OUT_START = "Function Start to Send Out Sine-Wave";
    const char* __MESG_WAVE_OUT_STOP  = "Function Stop Sending Sine-Wave";
    
    int sampleDataNum = 256;
    s32 inputAmpMin  = 0;
    s32 inputAmpMax  = 0;
    s32 micData[static_cast<size_t>(sampleDataNum)];
    
    // Hƌ̉ʂXV
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_CYAN, "@ SENSITIVITY TEST\n");
    m_InfoWnd->Printf("\f");
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/MicTesting.jpg");
    UpdateDisplay();
    
    m_pTesterInterface           = new MicTesterInterface;
    codec::TestCodec* pTestCodec = new codec::TestCodec;
    
    // CODEC  MIC PGA Gain Calibration ɏ
    pTestCodec->TestWriteMultiEx_SPI2_MicPgaGainCalibration(&m_CurrentPgaGainHex);
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE, 
        "Current PGA Gain=%02d=%.1lf(dB)\n", m_CurrentPgaGainHex, m_CurrentPgaGainF32);
    UpdateDisplay();
    
    
    // Lu[VݒǍ
    int model    = m_pTCal->MODEL_CTR;
    int calib_id = m_pTCal->CALIBRATE_CTR_SENS;
    TesterCalibrationSetting* setting = m_pTCal->GetCalibrationSetting(model, calib_id);
    
    
    // o͔g`̃ZbgAbvEo
    CHK_FATAL_ERROR(
        m_pTesterInterface->WaveSetup(setting->fsel, setting->calib_id), 
        __MESG_WAVE_SETUP);
    CHK_FATAL_ERROR(
        m_pTesterInterface->WaveStart(), __MESG_WAVE_OUT_START);
    
    // QC̐ݒ
    nn::mic::SetAmpGain(setting->ctrGain);
    
    m_InfoWnd->Printf("\f");
    m_InfoWnd->Printf("FSEL = %X  CALIB ID = %X\n", setting->fsel, setting->calib_id);
    m_InfoWnd->Printf("CTR GAIN      : %4.1lf[dB]\n", static_cast<double>(setting->ctrGain) /2.0 + 10.5);
    m_InfoWnd->Printf("AMP THRESHOLD : %d-%d", SENSITIVITY_THRESHOLD_MIN, SENSITIVITY_THRESHOLD_MAX);
    UpdateDisplay();
    
    // TvOg 16kHz ŃTvOJn
    {
        m_pMicLib->PresetSamplingRate(m_pMicLib->MIC_SAMPLING_RATE_16360);
        
        // TvOJn
        GetAmplitudeAve(256, 50, &ampSensitivity, &status, true, 60000);
        m_AmpSmpl16kHz    = ampSensitivity;
        
        // U臒lł true
             if(m_AmpSmpl16kHz <= SENSITIVITY_THRESHOLD_MIN ) ret_16 = LOW_SENSITIVITY;		// xႷ
        else if(m_AmpSmpl16kHz >= SENSITIVITY_THRESHOLD_MAX ) ret_16 = HIGH_SENSITIVITY;	// x
        else                                                  ret_16 = PASS;				// OK
        
        m_AmpSens = m_AmpSmpl16kHz;
        
        sys::ATTR_TEXT_COLOR color = (( ret_16==PASS ) ? sys::ATTR_COLOR_WHITE : sys::ATTR_COLOR_RED );
        LogPrintf(m_DebugWnd, color, 
            "#1: SmplRate(16kHz) -> Amp=%d\n", m_AmpSmpl16kHz);
        UpdateDisplay();
    }
    
    // TvOg 32kHz ŃTvOJn
    if(ret_16 == PASS)
    {
        m_pMicLib->PresetSamplingRate(m_pMicLib->MIC_SAMPLING_RATE_32730);
        
        // TvOJn
        GetAmplitudeAve(256, 50, &ampSensitivity, &status, true, 60000);
        m_AmpSmpl32kHz    = ampSensitivity;
        
        // U臒lł true
             if(m_AmpSmpl32kHz <= SENSITIVITY_THRESHOLD_MIN ) ret_32 = LOW_SENSITIVITY;		// xႷ
        else if(m_AmpSmpl32kHz >= SENSITIVITY_THRESHOLD_MAX ) ret_32 = HIGH_SENSITIVITY;	// x
        else                                                  ret_32 = PASS;				// OK
        
        m_AmpSens = m_AmpSmpl32kHz;
        
        sys::ATTR_TEXT_COLOR color = (( ret_32==PASS ) ? sys::ATTR_COLOR_WHITE : sys::ATTR_COLOR_RED );
        LogPrintf(m_DebugWnd, color, 
            "#2: SmplRate(32kHz) -> Amp=%d\n", m_AmpSmpl32kHz);
        UpdateDisplay();
    }
    
    // M~
    CHK_FATAL_ERROR(m_pTesterInterface->WaveStop(), __MESG_WAVE_OUT_STOP);
    
    delete pTestCodec;
    delete m_pTesterInterface;
    
    m_TestResult.m_Result = (((ret_16==PASS) && (ret_32==PASS)) ? true : false);
    
    if( false==m_TestResult.m_Result )
    {
             if( ret_16 != PASS )  m_TestResult.m_Micro = ret_16;
        else if( ret_32 != PASS )  m_TestResult.m_Micro = ret_32;
    }
    
    // fobOp
#if MIC_TESTER_DEBUGGER==1
    MicTesterWait(2000);
#endif
    
    if( m_TestResult.m_Result )
    {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_GREEN, "passed!\n");
    }
    else
    {
        ExecuteWriteData2SD();
        ExecuteFinalize();
        
        // Oɏo
        sprintf( m_TestResult.m_String, s_ProductionLogString );
    }
    
    return m_TestResult.m_Result;
}


//============================================================================
//============================================================================
//                                ֐
//============================================================================
//============================================================================
/*---------------------------------------------------------------------------
  Desc: }CN̓dONƉʕ\

  Args: bMsg - bZ[W̕\LtO

  Rtns: I^s
---------------------------------------------------------------------------*/
bool MicTester::MicTester_TurnOnMic( bool bMsg )
{
    bool ret = false;
    
    // CTR}CN̏ƓdI
    m_pMicLib->Initialize();
    ret = m_pMicLib->TurnOnMic();
    
    if( bMsg==true )
    {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_YELLOW, 
            "Turned on the power supply of the microphone.\n");
        UpdateDisplay();
    }
    
    return ret;
}

/*---------------------------------------------------------------------------
  Desc: }CN̓dOFFƉʕ\

  Args: bMsg - bZ[W̕\LtO

  Rtns: I^s
---------------------------------------------------------------------------*/
bool MicTester::MicTester_TurnOffMic( bool bMsg )
{
    bool ret = false;
    
    // CTR}CN̓dItyяI
    ret = m_pMicLib->TurnOffMic();
    m_pMicLib->Finalize();
    
    if( bMsg==true )
    {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_YELLOW, 
            "Turned off the power supply of the microphone.\n");
        UpdateDisplay();
    }
    
    return ret;
}

/*---------------------------------------------------------------------------
  Desc: PGA Gain Calibration XV

  Args: bMsg - bZ[W̕\LtO

  Rtns: I^s
---------------------------------------------------------------------------*/
void MicTester::MicTesterUpdatePgaGain( void )
{
    codec::TestCodec* pTestCodec = new codec::TestCodec;
    
    // CAL ̒lǍ
    nn::drivers::cal::CTR::CodecCalDataCore codecCalDataCore;
    ExecuteGetCalPgaGain( &codecCalDataCore );
    
    m_CurrentPgaGainHex = codecCalDataCore.micGainCalibrateParam;
    m_CurrentPgaGainF32 = pTestCodec->ConvCalibGainHexToF32(m_CurrentPgaGainHex);
    
    // CODEC  MIC PGA Gain Calibration ɏ
    pTestCodec->TestWriteMultiEx_SPI2_MicPgaGainCalibration(&m_CurrentPgaGainHex);
    
    delete pTestCodec;
}

/*---------------------------------------------------------------------------
  Desc: bsq{̃Lu[ṼRA

  Args: setting - Lupݒւ̃|C^

  Rtns: Lu[V^s
---------------------------------------------------------------------------*/
bool MicTester::CalibratePgaGainCore( TesterCalibrationSetting* setting )
{
    bool ret = false;
    
    const char* __MESG_WAVE_SETUP     = "Function Setup Wave";
    const char* __MESG_WAVE_OUT_START = "Function Start to Send Out Sine-Wave";
    const char* __MESG_WAVE_OUT_STOP  = "Function Stop Sending Sine-Wave";
    
    f32 level_req   = 0.f;
    f32 pga_gain    = 0.f;
    u8  pga_gain_Hex = 0;
    u16 amp         = 0;
    int calib_count = 0;
    MICPgaGainCalibStatus status = PGA_CALIB_STAT_INITIAL;

    const int MAX_CALIBRATION_COUNT = 15;

    m_pTesterInterface  = new MicTesterInterface;
    codec::TestCodec* pTestCodec = new codec::TestCodec;
    
    // o͔g`̃ZbgAbvEo
    CHK_FATAL_ERROR(
        m_pTesterInterface->WaveSetup(setting->fsel, setting->calib_id), 
        __MESG_WAVE_SETUP);
    CHK_FATAL_ERROR(
        m_pTesterInterface->WaveStart(), __MESG_WAVE_OUT_START);
    
    // QC̐ݒ
    nn::mic::SetAmpGain(setting->ctrGain);
    
    m_InfoWnd->Printf("\f");
    m_InfoWnd->Printf("FSEL = %X  CALIB ID = %X\n", setting->fsel, setting->calib_id);
    m_InfoWnd->Printf("CTR GAIN      : %4.1lf[dB]\n", static_cast<double>(setting->ctrGain) /2.0 + 10.5);
    m_InfoWnd->Printf("AMP TARGET    : %d(%d)", PGA_GAIN_AMP_TARGET, PGA_GAIN_AMP_MARGIN);    
    UpdateDisplay();

    // 
    pga_gain_Hex = 0x0;
    
    while(1)
    {
        pga_gain_Hex = pTestCodec->ConvCalibGainF32ToHex(pga_gain);
        
        // ϊQCsȒl̏ꍇ
        if (0x47 == pga_gain_Hex)
        {
            LogPrintf(m_DebugWnd, sys::ATTR_COLOR_RED, "- HEX_PGA_GAIN INVALID VALUE ERROR -\n");
            UpdateDisplay();
        }
        
        // PGALu[Vlݒ
        pTestCodec->TestWriteMultiEx_SPI2_MicPgaGainCalibration(&pga_gain_Hex);
        
        // g`𑪒肵Al擾
        level_req = GetPgaGainLevelCtrl(PGA_GAIN_AMP_TARGET, PGA_GAIN_AMP_MARGIN, &amp, &status);
        pga_gain += level_req;
        
        // Lu[Vʂ̕\
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE, "%02d: PGA Gain=%4.1f Amp=%d\n", ++calib_count, pga_gain, amp);
        UpdateDisplay();

        // Lu[Vs
        if ((calib_count > MAX_CALIBRATION_COUNT) || (status == PGA_CALIB_STAT_FATAL_ERROR))
        {
            ret = false;
            break;
        }

        // ␳臒lz̏ꍇ͂肬̒l
        if ( pga_gain < -3.0f ){  pga_gain = -3.0f;  status = PGA_CALIB_STAT_COMPLETE; }
        if ( 6.0f <  pga_gain ){  pga_gain =  6.0f;  status = PGA_CALIB_STAT_COMPLETE; }

        // Lu[V
        if (status == PGA_CALIB_STAT_COMPLETE) 
        {
            // CAL ɏޒl
            s_CodecCalDataCore.micGainCalibrateParam = pTestCodec->ConvCalibGainF32ToHex(pga_gain);
            m_CurrentPgaGainF32 = pga_gain;
            m_CurrentPgaGainHex = pTestCodec->ConvCalibGainF32ToHex(pga_gain);
            ret = true;
            break;
        }
    }

    // M~
    CHK_FATAL_ERROR(m_pTesterInterface->WaveStop(), __MESG_WAVE_OUT_STOP);
    
    delete pTestCodec;
    delete m_pTesterInterface;
    
    return ret;

}

/*---------------------------------------------------------------------------
  Desc: lƖڕWlƂ̍fVxŎZo

  Args: amp_target - ڕW̐Ul
        amp_input  - l

  Rtns: ڕWlׂ̈ɕύXKvȃQCi0.5dBPʁj
---------------------------------------------------------------------------*/
f32 MicTester::MicTester_CalGainDiff(u16 amp_target, u16 amp_input)
{
    f32 gain_target;
    f32 dec;
    f32 diff;
    f64 Dec1stPlace;
    f32 adjustDec1stPlace;

    gain_target = nn::math::FLog10(static_cast<f32>(amp_target)/static_cast<f32>(amp_input)) * 20;

    // o
    dec = nn::math::FFloor(gain_target);

    // _ȉ̐lZo
    Dec1stPlace = gain_target - dec;

    // CODEC͈̒͂̒lɕϊ
    if      ( 0.0 <= Dec1stPlace && Dec1stPlace < 0.3)      adjustDec1stPlace =  0.0;
    else if ( 0.3 <= Dec1stPlace && Dec1stPlace < 0.8)      adjustDec1stPlace =  0.5;
    else if ( 0.8 <= Dec1stPlace && Dec1stPlace < 1.0)      adjustDec1stPlace =  1.0;
    else if (-0.3 <  Dec1stPlace && Dec1stPlace < 0.0)      adjustDec1stPlace =  0.0;
    else if (-0.8 <  Dec1stPlace && Dec1stPlace <= -0.3)    adjustDec1stPlace = -0.5;
    else if (-1.0 <  Dec1stPlace && Dec1stPlace <= -0.8)    adjustDec1stPlace = -1.0;
    else    NN_LOG("CalGainDiff() Error(%f)\n", Dec1stPlace);

    diff = dec + adjustDec1stPlace;
    
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE, "GainTarget=%5.2f -> %5.2f\n", gain_target, diff);
    UpdateDisplay();
    
    return diff;
}

/*---------------------------------------------------------------------------
  Desc: g`𑪒肵AUf[^̍őŏlZo

  Args: samp_data_num  - x̃TvOő肷f[^
        p_amp_max      - Uől̃|C^
        p_amp_min      - Uŏl̃|C^

  Rtns: Lȃf[^𑪒ł(true)/Lȃf[^K萔ȉ(false)
---------------------------------------------------------------------------*/
void MicTester::GetMicSamplingAmpMaxMin(int samp_data_num, s32* p_amp_max, s32* p_amp_min)
{
    s32 micData[static_cast<size_t>(samp_data_num)];

    // Jn
    m_pMicLib->StartSampling();
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));
    
    // TvO
    m_pMicLib->GetMicData(micData, static_cast<size_t>(samp_data_num));
    *p_amp_max = micData[m_pMicLib->m_MaxIndex];
    *p_amp_min = micData[m_pMicLib->m_MinIndex];
    
    // I
    m_pMicLib->StopSampling();
}

/*---------------------------------------------------------------------------
  Desc: g`𑪒肵AUf[^̕ςZo

  Args: samp_data_num       - x̃TvOő肷f[^
        sampling_count      - samp_data_num̑s
        p_amp               - Ũ|C^
        IsThreshChk         - f[^͈͂̃`FbNsH
        InvalidThresholdMax - ͈͂臒li̒l𒴂疳ȒlƂj

  Rtns: Lȃf[^𑪒ł(true)/Lȃf[^K萔ȉ(false)
---------------------------------------------------------------------------*/
bool MicTester::GetMicSamplingAve(int samp_data_num, int sampling_count, u16* p_amp, bool IsThreshChk, u16 InvalidThresholdMax)
{
    u32 amp_sum = 0;
    u32 invalid_amp_sum = 0;
    int i, invalid_count = 0;
    s32 micData[static_cast<size_t>(samp_data_num)];

    // Jn
    m_pMicLib->StartSampling();
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));
    
    // Uf[^̕ςZo
    for(i = 0; i < sampling_count; i++)
    {
        nn::os::Thread::Sleep(
            nn::fnd::TimeSpan::FromMilliSeconds((samp_data_num / 16) + 5));
        
        // TvOĐUZo
        m_pMicLib->GetMicData(micData, static_cast<size_t>(samp_data_num));
        if ((IsThreshChk && (m_pMicLib->m_Amplitude < InvalidThresholdMax)) || !IsThreshChk)
        {
            amp_sum += m_pMicLib->m_Amplitude; 
        }
        else
        {
            invalid_amp_sum += m_pMicLib->m_Amplitude; 
            invalid_count++;
        }        
    }
    
    // I
    m_pMicLib->StopSampling();
    
    if( invalid_count > (sampling_count/5) )    // TvO20%ȏオlłNG
    {
        *p_amp = (u16)(invalid_amp_sum/invalid_count);
        return false;
    }
    else
    {
        *p_amp = (u16)(amp_sum/(sampling_count - invalid_count));
        return true;
    }
}

/*---------------------------------------------------------------------------
  Desc: U𒲂ׂ

  Args: samp_data_num  - x̃TvOő肷f[^
        sampling_count - samp_data_num̑s
        p_amp          - Ũ|C^
        p_status       - Xe[^Xϐ̃|C^
        InvalidThresholdMax - ő臒l

  Rtns: TvOۂԂ
---------------------------------------------------------------------------*/
bool MicTester::GetAmplitudeAve(int samp_data_num, 
                                int sampling_count, 
                                u16* p_amp, 
                                MICPgaGainCalibStatus* p_status, 
                                bool IsThreshChk, 
                                u16 InvalidThresholdMax)
{
    int invalid_samp_count = 0;                         // ͒lɂLłȂf[^Ɣ肳ꂽ
    const int INVALID_SAMPLING_COUNT_MAX    = 5;        // ͒l̔肪̉񐔈ȏ㑱NGƂ
    
    // 
    while(!GetMicSamplingAve(samp_data_num, sampling_count, p_amp, IsThreshChk, InvalidThresholdMax))
    {
        // lȏ㑪肳ꍇ false Ԃ
        if(invalid_samp_count++ > INVALID_SAMPLING_COUNT_MAX)
        {
            *p_status = PGA_CALIB_STAT_FATAL_ERROR;
            return false;
        }
    }
    return true;
}

/*---------------------------------------------------------------------------
  Desc: g`𑪒肵AڕWlɋ߂Â邽߂ɕKvȃQC߂

  Args: amp_target   - ڕW̐Ul
        amp_margin   - ڕWUl̃}[W
        p_amp        - Ũ|C^
        p_status     - Xe[^Xϐ̃|C^

  Rtns: PGAQCLul
---------------------------------------------------------------------------*/
f32 MicTester::GetPgaGainLevelCtrl(u16 amp_target, u16 amp_margin, u16* p_amp, MICPgaGainCalibStatus* p_status)
{
    const f32 PGA_GAIN_CALIB_1_Step_dB      =  0.5f;     // Lu1Step̕ύXŕ␳dBl
    const f32 PGA_GAIN_CALIB_CLAMP          = -3.0f;     // g`NvĂۂɕ␳dBl
    const f32 PGA_GAIN_CALIB_NONEED         =  0.0f;     // Ȃ

    const u16 AMP_CLAMP                     = 65000;    // lȏゾƃNvƂ
    const u16 INVALID_THRESHOLD_MAX         = 62000;    // ͒l臒l
    const int INVALID_SAMPLING_COUNT_MAX    = 5;        // ͒l̔肪̉񐔈ȏ㑱NGƂ

    const u16 invalid_threshold_max         = INVALID_THRESHOLD_MAX;

    int invalid_samp_count = 0;                         // ͒lɂLłȂf[^Ɣ肳ꂽ

    static bool IsThreshChk = false;                    // 񑪒̓f[^͈͂̃`FbN
    if (*p_status == PGA_CALIB_STAT_INITIAL)
    {
        IsThreshChk = false;
    }

    // i150msec{21msec~24̕ρj
    while(!GetMicSamplingAve(256, 24, p_amp, IsThreshChk, invalid_threshold_max))
    {
        // lȏ㑪肳ꍇNGŏI
        if(invalid_samp_count++ > INVALID_SAMPLING_COUNT_MAX)
        {
            *p_status = PGA_CALIB_STAT_FATAL_ERROR;
            return PGA_GAIN_CALIB_NONEED;
        }
    }
    
    // ␳lm肷܂Ń[v
    while (1)
    {  
        switch (*p_status)
        {
        // 񑪒݂̂̏
        case PGA_CALIB_STAT_INITIAL:
            *p_status = PGA_CALIB_STAT_TARGET_ADJUSTMENT;

            // xăNvĂ}CN
            if (*p_amp > AMP_CLAMP)
            {
                return PGA_GAIN_CALIB_CLAMP;                            // -3.0dB
            }
            break;
            
        // ␳ڕWlɑ΂QCZoĒ
        case PGA_CALIB_STAT_TARGET_ADJUSTMENT:
            if (*p_amp < invalid_threshold_max)
            {
                // ȍ~̑łAveZoɖ͈͂̃`FbNs
                // ͖̑ڕWւJAMPsƂȂ̂ŁAXbṼ}[W͕KvȂ
                IsThreshChk = true;
                *p_status = PGA_CALIB_STAT_FINE_ADJUSTMENT;
            }
            return MicTester_CalGainDiff(amp_target, *p_amp);           // ^[Qbgւ̒
            
        // 0.5dB̔
        case PGA_CALIB_STAT_FINE_ADJUSTMENT:
            if ((amp_target - amp_margin) > *p_amp)
            {
                return PGA_GAIN_CALIB_1_Step_dB;                        // +0.5dB
            }
            else if ((amp_target + amp_margin) < *p_amp)
            {   
                return PGA_GAIN_CALIB_1_Step_dB * -1.f;                 // -0.5dB
            }
            else
            {
                *p_status = PGA_CALIB_STAT_COMPLETE;
                return PGA_GAIN_CALIB_NONEED;                           // Lu[V
            }
            
        default:
            NN_LOG("Invalid Status Error\n");
            break;
        }
    }
}

/*---------------------------------------------------------------------------
  Desc: vIG[̃`FbNG[̏

  Args: result  - 
        message - bZ[W

  Rtns: 펞0BG[͖߂܂B
---------------------------------------------------------------------------*/
u32 MicTester::CHK_FATAL_ERROR(u32 result, const char* message)
{
    const u32 REGSPI_R_STATUS_ERROR_CODE_MASK= 0xf0;    
    MICTesterStatus status; 
    
    if (result == MICI_RESULT_SUCCESS)
    {
        return result;   
    }
    
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE, "Result(%Xh)\n", result);        
    LogPrintf(m_DebugWnd, sys::ATTR_COLOR_WHITE, "Message: %s\n", message);        
    
    
    
    status.raw = static_cast<u8>(result & 0xff);   
    // 킪ڑĂȂiJ[hRlN^ڐGsetc.j
    if (status.raw & REGSPI_R_STATUS_ERROR_CODE_MASK == REGSPI_R_STATUS_ERROR_CODE_MASK) {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_RED, "- CARD INTERFACE ERROR -\n");            
    }
    // ~{^ꂽ
    else if (status.STOP_EVENT) {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_RED, "- STOP BUTTON PUSHED -\n");        
    }
    // Lu[VɎs
    else if (status.ERR == MIC_REGSPI_R_STATUS_ERROR_CALIBRATION) {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_RED, "- CALIBRATION FAILED -\n");
        // G[ʂ̕\
        m_JpegDrawer->OpenPicture(L"rom:/jpeg/Fail.jpg");
        UpdateDisplay();          
        while (1) {
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));    
        }        
    }
    // ̑vIG[
    else {
        LogPrintf(m_DebugWnd, sys::ATTR_COLOR_RED, "- FATAL ERROR OCCURRED -\n");        
    }
    
    // G[ʂ̕\
    m_JpegDrawer->OpenPicture(L"rom:/jpeg/FatalError.jpg");
    UpdateDisplay();    

    while (1) {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));    
    }
    
    // ɂ͗܂    
}

//============================================================================
//============================================================================
//                               ʕ`
//============================================================================
//============================================================================
/*---------------------------------------------------------------------------
  Desc: ʍXV
---------------------------------------------------------------------------*/
void MicTester::UpdateDisplay( void )
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);  
    gfx->m_DrawFramework->Clear();
    m_WndManager.DrawDisplay0();
    gfx->m_DrawFramework->SwapBuffers();
    
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    
    // 摜\
    m_JpegDrawer->DrawPicture(NN_GX_DISPLAY1);
    
    m_WndManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
        
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*---------------------------------------------------------------------------
  Desc: OJEgtPrintf
---------------------------------------------------------------------------*/
void MicTester::LogPrintf(sys::TextWindow *wnd, sys::ATTR_TEXT_COLOR color, const char* format, ...)
{    
    sys::ATTR_TEXT_COLOR prev_color = wnd->GetTextColor();
    
    wnd->SetTextColor(sys::ATTR_COLOR_WHITE);
    wnd->Printf("%03d> ", m_LogCount++);

    wnd->SetTextColor(color);
    va_list vlist;
    va_start(vlist, format);
    wnd->VPrintf(format, vlist);    
    va_end(vlist); 
    
    wnd->SetTextColor(prev_color);
}

//============================================================================
//============================================================================
//                           OEf[^o
//============================================================================
//============================================================================

    // ------------------------------------------------------------
    //  SDJ[hf[^o͗p
    // ------------------------------------------------------------
    const char CAL_MIC_TITLE[256] = 
        "Ser.No.,"
        "MacAddress,"
        "StableTime(ms),"
        "Amplitude(Silent),"
        "Amplitude(Input),"
        "PGA Gain(dB),"
        "Amplitude(Sens16kHz),"
        "Amplitude(Sens32kHz),"
        "Result,"
        "\n";
        
/*---------------------------------------------------------------------------
  Desc: f[^o͂܂

  Args: Ȃ

  Rtns: Ȃ
---------------------------------------------------------------------------*/
bool MicTester::ExecuteWriteData2SD( void )
{
    // tO false ̎ SD J[hɃf[^o͂Ȃ
    uji::seq::Config config;
    if( WRITE_DATA_TO_SD == false )
    {
        return true;		// I
    }
    
    string line;
    char strComma[8]            = ",";
    char strStableTime[32]      = "";
    char strAmpSilent[32]       = "";
    char strAmpImput[32]        = "";
    char strMsgPgaGainCAL[16]   = "";
    char strAmpSmpl16kHz[32]    = "";
    char strAmpSmpl32kHz[32]    = "";
    char strMsgResult[8]        = "";
    char strMsgString[80]       = "";
    char strBreak[2]            = "\n";
    
    // p[^o͐
    const wchar_t* MIC_T_SD_DIR   = L"sdmc:/uji/MicTester";
    const wchar_t* MIC_T_SD_PATH  = L"sdmc:/uji/MicTester/MicTester.csv";
    
    
    sprintf(strStableTime,    "%d,",    (int)m_StableTime);
    sprintf(strAmpSilent,     "%d,",    m_AmpSilent);
    sprintf(strAmpImput,      "%d,",    m_AmpImput);
    sprintf(strMsgPgaGainCAL, "%4.1f,", m_CurrentPgaGainF32);
    sprintf(strAmpSmpl16kHz,  "%d,",    m_AmpSmpl16kHz);
    sprintf(strAmpSmpl32kHz,  "%d,",    m_AmpSmpl32kHz);
    
    // 
    if( m_TestResult.m_Result==true ) sprintf(strMsgResult, "PASS");
    else                              sprintf(strMsgResult, "FAIL");
    
    // G[bZ[W
    if( m_TestResult.m_Result==false && strcmp(m_TestResult.m_String, "") != 0 )
    {
        sprintf(strMsgString, " [ %s ]", m_TestResult.m_String);
    }

    line = static_cast<string>(m_SerialNumber)
         + static_cast<string>(strComma)
         + static_cast<string>(m_MacAddress) 
         + static_cast<string>(strComma)
         + static_cast<string>(strStableTime) 
         + static_cast<string>(strAmpSilent) 
         + static_cast<string>(strAmpImput) 
         + static_cast<string>(strMsgPgaGainCAL) 
         + static_cast<string>(strAmpSmpl16kHz) 
         + static_cast<string>(strAmpSmpl32kHz) 
         + static_cast<string>(strMsgResult) 
         + static_cast<string>(strMsgString) 
         + static_cast<string>(strBreak);
         
    nn::Result nnResult;
    
    // SDJ[ho
    if( nn::fs::IsSdmcInserted() )
    {
        // }Eg
        nnResult = nn::fs::MountSdmc();
        if ( nnResult.IsSuccess() )
        {
            // SD ɏo
            if( CreateDirectorySdmc( L"sdmc:/uji" ) == false ) return false;
            if( CreateDirectorySdmc( MIC_T_SD_DIR ) == false ) return false;
            if( WriteData2SD( MIC_T_SD_PATH, line ) == false ) return false;
        }
        else
        {
            sprintf(m_TestResult.m_String, "Level:%d Summary:%d Module:%d", 
                nnResult.GetLevel(), nnResult.GetSummary(), nnResult.GetModule());
            return false;
        }
        NN_UTIL_PANIC_IF_FAILED(nn::fs::Unmount("sdmc:"));
    }
    
    return true;
}

//============================================================================
//============================================================================
//                             SDJ[ho͗p
//============================================================================
//============================================================================
/*---------------------------------------------------------------------------
  Desc: fBNgJȂꍇ͐VK쐬

  Args: path        Ώۃt@C̃tpX

  Rtns: Ȃ
---------------------------------------------------------------------------*/
bool MicTester::CreateDirectorySdmc(const wchar_t* path)
{
    nn::fs::Directory dir;
    nn::Result nnResult = dir.TryInitialize( path );
    
    // fBNgȂꍇ͐VK쐬
    if(nnResult.IsFailure())
    {
        NN_LOG("@ Can't Initialize! So Create Directory... \n");
        
        nnResult = nn::fs::TryCreateDirectory( path );
        
        if(nnResult.IsFailure())
        {
            NN_LOG("* Warning: No Create Directory! Maybe 'sdmc:/uji' is nonexistent.\n");
            return false;
        }
    }
    else
    {
        dir.Finalize();
    }
    return true;
}

/*---------------------------------------------------------------------------
  Desc: Ώۃt@CɃf[^݂܂

  Args: path        Ώۃt@C̃tpX
        strBuf      ރf[^

  Rtns: Ȃ
---------------------------------------------------------------------------*/
bool MicTester::WriteData2SD(const wchar_t* path, string strBuf)
{
    // t@C݂߂̃IuWFNg쐬
    nn::fs::FileStream fos;
    nn::Result nnResult = fos.TryInitialize(path, nn::fs::OPEN_MODE_READ   | 
                                                  nn::fs::OPEN_MODE_WRITE  | 
                                                  nn::fs::OPEN_MODE_CREATE );
    if(nnResult.IsSuccess())
    {
        s64 size = fos.GetSize();
        NN_LOG("FILE_SIZE= %lld\n", size);
        
        if(size == 0)
        {
            // ̂
            fos.Write(CAL_MIC_TITLE, strlen(CAL_MIC_TITLE));
        }
        else
        {
            // ڈȍ~
            fos.Seek( -1, nn::fs::POSITION_BASE_END );
        }
        fos.Write(strBuf.c_str(), strlen(strBuf.c_str()));
        fos.Write("@", 1);
        
        // t@C
        fos.Finalize();
        
        return true;
    }
    else
    {
        // t@C
        fos.Finalize();
        
        return false;
    }
    
}

//============================================================================
//============================================================================
//                               CAL
//============================================================================
//============================================================================
/*---------------------------------------------------------------------------
  Desc: CAL ɏ
---------------------------------------------------------------------------*/
s32 MicTester::ExecuteSetCalPgaGain( u16 param )
{
    using namespace nn::drivers::cal::CTR;
    
    enum ERROR_SEQ {
        PASS        =  0,
        ERROR_GET   = -1,
        ERROR_SET   = -2,
        ERROR_FLUSH = -3
    };
    
    // C[hݒ莞̂ CAL ɏ
    uji::seq::Config config;
    if( config.Get().TestMode != uji::seq::pl::LINE )
    {
        return PASS;		// I
    }
    
    Calibration cal;
    nn::drivers::cal::CTR::CodecCalDataCore codecCalDataCore;
    
    // CAL ̏
    cal.Initialize();
    
    // l̎擾
    if( !cal.Get(&codecCalDataCore,	CAL_DATA_CODEC))         { return ERROR_GET;   }
    
    switch( param )
    {
    case PGA_GAIN: codecCalDataCore.micGainCalibrateParam = 
                       s_CodecCalDataCore.micGainCalibrateParam;
    }
    
    // l̐ݒAt@Cɕۑ
    if( !cal.Set(&codecCalDataCore,	CAL_DATA_CODEC))         { return ERROR_SET;   }
    if( !cal.Flush() )                                       { return ERROR_FLUSH; }
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: CAL Zbg
---------------------------------------------------------------------------*/
s32 MicTester::ExecuteResetCalPgaGain( void )
{
    using namespace nn::drivers::cal::CTR;
    
    enum ERROR_SEQ {
        PASS        =  0,
        ERROR_GET   = -1,
        ERROR_SET   = -2,
        ERROR_FLUSH = -3
    };
    
    Calibration cal;
    nn::drivers::cal::CTR::CodecCalDataCore codecCalDataCore;
    
    // CAL ̏
    cal.Initialize();
    
    // l̎擾
    if( !cal.Get(&codecCalDataCore,	CAL_DATA_CODEC))         { return ERROR_GET;   }
    
    // ftHglZbg
    codecCalDataCore.micGainCalibrateParam = 0;	//nn::cfg::CTR::detail::CODEC_CFG_DEFAULT;
    
    // l̐ݒAt@Cɕۑ
    if( !cal.Set(&codecCalDataCore,	CAL_DATA_CODEC))         { return ERROR_SET;   }
    if( !cal.Flush() )                                       { return ERROR_FLUSH; }
    
    return PASS;
}

/*---------------------------------------------------------------------------
  Desc: CAL ̓Ǎ
---------------------------------------------------------------------------*/
bool MicTester::ExecuteGetCalPgaGain( nn::drivers::cal::CTR::CodecCalDataCore* pc )
{
    using namespace nn::drivers::cal::CTR;
    
    Calibration cal;
    
    // CAL ̏Al̎擾
    cal.Initialize();
    if( !cal.Get( pc, CAL_DATA_CODEC ) ){  return false;  }
    else                                {  return true;   }
}

//============================================================================
//============================================================================
//                             p֐
//============================================================================
//============================================================================
/*---------------------------------------------------------------------------
  Desc: ʂi[
---------------------------------------------------------------------------*/
static void ShiftTestResult( MicTester* p, seq::TestResult &result )
{
    result.m_Micro  = p->m_TestResult.m_Micro;
    sprintf(result.m_String, p->m_TestResult.m_String);
    
    // oϐ
    p->m_TestResult.m_Micro  = 0;
    sprintf(p->m_TestResult.m_String, "");
}

/*---------------------------------------------------------------------------
  Desc: bZ[Wv_NVOpɐ

  dstsrcƓTCYWOi[łobt@pӂĂB
---------------------------------------------------------------------------*/
static void FormToLogMessage( char *dst, const char *src )
{
    const int MAX_LENGTH = 80;

    //ő咷Ƀg~O
    strncpy( dst, src, MAX_LENGTH );
    if( strlen(src) > MAX_LENGTH ) dst[MAX_LENGTH]='\0';

    //\n$ɕϊA,Xy[Xɕϊ
    for( int i=0 ; dst[i]!='\0' ; i++ )
    {
        if( dst[i]=='\n' ) dst[i]='$';
        if( dst[i]==','  ) dst[i]=' ';
    }
}

/*---------------------------------------------------------------------------
  Desc: i}CÑLu[V

  Args: result  - ʊi[ϐ̃|C^

  Rtns: true    - ̃Lu[V{}CNɈڍs
        false   - ̃[huLu[V[hvłA
                  SD̈Ɏw̃t@CtȂ
        
        ̃Lu[V珈͋AĂ܂
---------------------------------------------------------------------------*/
bool TestExecuteCalibrateTester( uji::seq::TestResult &result )
{
    enum _MODE {
        MICTESTER_CALIBRATE = 0,
        MICTEST             = 1
    };
    
    enum enumMicroErrorId
    {
        TESTER_CAL_UNIT_NOTCAL = 0,
        TESTER_NOTCAL_UNIT_CAL = 1,
        
        MICRO_ERROR_NUM        = 2
    };
    
    MicTesterInterface* p  = new MicTesterInterface;
    MICTesterStatus status = p->GetTesterStatus();
    delete p;
    
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    pdl->Initialize();
    int index = pdl->Get_LatestLogEntryIndex( "MicCalib", 0, "CALIBRATOR" );
    pdl->Finalize();
    delete pdl;
    
    if( status.MODE==MICTESTER_CALIBRATE )
    {
#ifdef EVA_MIC_FPC
        // }CNFPĆÃ[ĥ݂Ŕ
        // Lu[Vi͖߂Ă܂j
        MicTesterCalibrator::sRun();
#else
        if( index >= 0 )
        {
            // Lu[Vi͖߂Ă܂j
            MicTesterCalibrator::sRun();
        }
        else
        {
            sprintf(result.m_String, "Tester is powered off, or Tester is calibration mode.");
            result.m_Result = false;
            result.m_Micro  = TESTER_CAL_UNIT_NOTCAL ;
            return result.m_Result;
        }
#endif
    }
    else if( status.MODE==MICTEST )
    {
        if( index >= 0 )
        {
            sprintf(result.m_String, "This assembly is the special calibrator.");
            result.m_Result = false;
            result.m_Micro  = TESTER_NOTCAL_UNIT_CAL ;
            return result.m_Result;
        }
    }
    
    result.m_Result = true;
    return result.m_Result;

}

/*---------------------------------------------------------------------------
  Desc: i}CN평

  Args: result  - ʊi[ϐ̃|C^

  Rtns: true    - OK
        false   - NG
---------------------------------------------------------------------------*/
bool TestExecuteInitialize( uji::seq::TestResult &result )
{
    MicTester* p = MicTester::GetInstance();
    result.m_Result = p->ExecuteInitialize();
    
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: E莞Ԃ̌

  Args: result  - ʊi[ϐ̃|C^

  Rtns: true    - OK
        false   - NG
---------------------------------------------------------------------------*/
bool TestExecuteCtrModeDcOffset( uji::seq::TestResult &result )
{
    MicTester* p = MicTester::GetInstance();
    
    uji::seq::Config config;
    
    // 莞ԌƖ̐Uőŏl
    result.m_Result = p->ExecuteCheckStableTime();
    if( result.m_Result == false ) goto Finalize;
    
    // ̐U
    result.m_Result = p->ExecuteDcOffset();
    if( result.m_Result == false ) goto Finalize;
    
Finalize:
    
    // 
    ShiftTestResult( p, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: }CN̓eXg
        xs̃}CNA͂S}CN؂蕪邽߂̃eXg

  Args: result  - ʊi[ϐ̃|C^

  Rtns: true    - OK
        false   - NG
---------------------------------------------------------------------------*/
bool TestExecuteCtrModeInput( uji::seq::TestResult &result )
{
    MicTester* p = MicTester::GetInstance();
    result.m_Result = p->ExecuteMicInput();
    
    // 
    ShiftTestResult( p, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: }CNx

  Args: result  - ʊi[ϐ̃|C^

  Rtns: true    - OK
        false   - NG
---------------------------------------------------------------------------*/
bool TestExecuteCalibratePgaGain( uji::seq::TestResult &result )
{
    MicTester* p = MicTester::GetInstance();
    result.m_Result = p->ExecuteCalibratePgaGain();
    
    // 
    ShiftTestResult( p, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: }CNx

  Args: result  - ʊi[ϐ̃|C^

  Rtns: true    - OK
        false   - NG
---------------------------------------------------------------------------*/
bool TestExecuteSensitivity( uji::seq::TestResult &result )
{
    MicTester* p = MicTester::GetInstance();
    result.m_Result = p->ExecuteSensitivity();
    
    // 
    ShiftTestResult( p, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: Oef[^SDJ[hɏo͂

  Args: result  - ʊi[ϐ̃|C^

  Rtns: true    - OK
        false   - NG
---------------------------------------------------------------------------*/
bool TestExecuteWriteData2SD( uji::seq::TestResult &result )
{
    MicTester* p = MicTester::GetInstance();
    result.m_Result = p->ExecuteWriteData2SD();
    
    // 
    ShiftTestResult( p, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: CAL  CODEC PGA Gain 

  Args: result  - ʊi[ϐ̃|C^

  Rtns: true    - OK
        false   - NG
---------------------------------------------------------------------------*/
bool TestExecuteSetCalPgaGain( uji::seq::TestResult &result )
{
    MicTester* p = MicTester::GetInstance();
    
    // CAL  CODEC PGA Gain 
    if(p->ExecuteSetCalPgaGain(PGA_GAIN)!=0)
    {
        sprintf(result.m_String, "It failed to set CAL.\n");
        result.m_Result = false;
    }
    else
    {
        result.m_Result = true;
    }
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: i}CNI

  Args: result  - ʊi[ϐ̃|C^

  Rtns: true    - OK
        false   - NG
---------------------------------------------------------------------------*/
bool TestExecuteFinalize( uji::seq::TestResult &result )
{
    MicTester* p = MicTester::GetInstance();
    result.m_Result = p->ExecuteFinalize();
    
    // 
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: OK O
        Hʂ̓RtBO擾
        Hg_TestListSet擾

  Args: result  - ʊi[ϐ̃|C^

  Rtns: true    - OK
        false   - NG
---------------------------------------------------------------------------*/
bool TestExecuteWriteProductionLogOk( uji::seq::TestResult &result )
{
    uji::seq::LogResult  lr;
    uji::seq::Config  *c = new uji::seq::Config;
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();
    
    char resultMessage[80];
    FormToLogMessage( resultMessage, s_ProductionLogString );
    
    pdl->Initialize();
    lr = pdl->Add_1Line( c->Get().TestMode,
                         g_TestListSet[c->GetAlternative().TestList].m_Name,
                         "OK",
                         VERSION_STRING,
                         "",
                         "",
                         "",
                         resultMessage
                       );
    if (lr == uji::seq::LogResultCode::SUCCESS)
    {
        result.m_Result = true;
    }
    else
    {
        result.m_Result = false;
        sprintf( result.m_String, s_ProductionLogString );
    }
    
    delete pdl;
    delete c;

    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc:  OK AOo͌ɏdvȃf[^\֐

  Args: result  - ʊi[ϐ̃|C^

  Rtns: true    - OK
---------------------------------------------------------------------------*/
bool TestExecuteShowMajorVariable( uji::seq::TestResult &result )
{
    MicTester* p = MicTester::GetInstance();
    result.m_Result = p->ExecuteShowMajorVariable();
    
    // 
    ShiftTestResult( p, result );
    return result.m_Result;
}


} // namespace
}
}
