/*--------------------------------------------------------------------------*
 Project:
 File: mic_SamplingGraph.h

*--------------------------------------------------------------------------*/

#ifndef _UJI_EVA_MIC_SAMPLINGGRAPH_H_
#define _UJI_EVA_MIC_SAMPLINGGRAPH_H_

#include <nn/os.h>
#include "mic_Lib.h"
#include "../codec/TestCodec.h"
#include "../sound/TestSound.h"

using namespace uji::sys;

namespace uji {
namespace eva {
    
    enum ParameterCursor
    {
        TYPE  = 0,
        RATE  = 1,
        GAIN  = 2,
        SOUND = 3,
        LOOP  = 4,
        CLAMP = 5,
        POWER = 6,
        PGA_GAIN_CAL = 7,
        
        MIC_PARAMETER_NUM
    };

    const int PARAMETER_WINDOW_STRING_MAX = 33;
    const bool INCREASE = true;
    const bool DECREASE = false;

    void Eva_DrawSamplingGraph();

class MicSamplingGraph
{
public: 
    MicSamplingGraph() : m_IsPlayingSound(false), m_MicPgaGainCal(0.f)
    {
        m_pTs = new sound::TestSound;
        m_pTc = new codec::TestCodec;
    };
    virtual ~MicSamplingGraph()
    {
        delete m_pTs;
        delete m_pTc;
    };
    
    //]pC֐
    void Run();
    

private: 
    //EBhEp֐
    void SetParameterWindow(TextWindow *TWndParam, MicLib *mic, char (*pParam)[PARAMETER_WINDOW_STRING_MAX]);
    void SetResultWindow(TextWindow *TWndResult, MicLib *mic, int maxIndex, s32 max, int minIndex, s32 min);
    void SetManualWindow(TextWindow *TWndManual);
    void SetInfoWindow(TextWindow *TWndInfo);
    
    //oϐ
    bool m_IsPlayingSound;
    f32 m_MicPgaGainCal;
    
    uji::eva::sound::TestSound *m_pTs;
    uji::eva::codec::TestCodec *m_pTc;
    
};

}
}

/* _UJI_EVA_MIC_SAMPLINGGRAPH_H_ */
#endif
