/*--------------------------------------------------------------------------*
 Project:
 File: mic_SamplingGraph.cpp

*--------------------------------------------------------------------------*/
#include <stdio.h>

#include <nn.h>
#include <nn/fs.h>
#include <nn/gx.h>
#include <nn/fnd.h>
#include <nn/mic.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include "mic_SamplingGraph.h"

//#define ArraySizeOf(array) (sizeof(array) / sizeof(array[0]))

using namespace uji;
using namespace uji::sys;
using namespace nn::math;

namespace uji {
namespace eva {
static bool bClampTestFlag = true;
/*!--------------------------------------------------------------------------*
  Desc      p[^EBhEp֐

  Args      *TWndParam
            *mic
            (*pParam)[PARAMETER_WINDOW_STRING_MAX]
  
  Rtns      None.
 *---------------------------------------------------------------------------*/
void MicSamplingGraph::SetParameterWindow(TextWindow *TWndParam, MicLib *mic, char (*pParam)[PARAMETER_WINDOW_STRING_MAX])
{
    TWndParam->SetTitle("Parameter");
    
    u8  gain;
    nn::mic::GetAmpGain(&gain);
    
    //\L[ŕύXp[^
    sprintf(*(pParam+TYPE),  "Type  : %s",                  mic->GetSamplingType());
    sprintf(*(pParam+RATE),  "Rate  : %5.2fkHz",            1/1000.f * mic->GetSamplingRate());
    sprintf(*(pParam+GAIN),  "Gain  : %4.1fdB( %3d/ 119)",  10.5+static_cast<f64>(gain)/2.0f, gain);
    sprintf(*(pParam+SOUND), "Sound : %s",                  mic->GetSoundFileName());
    sprintf(*(pParam+LOOP),  "Loop  : %-3s",                (mic->IsSamplingLoop() ? "ON": "OFF"));
    sprintf(*(pParam+CLAMP), "Clamp : %-3s",                (bClampTestFlag==true ? "ON" : "OFF"));
    sprintf(*(pParam+POWER), "MIC Power : %-3s",            (mic->GetAmp() ? "ON": "OFF"));
    sprintf(*(pParam+PGA_GAIN_CAL), 
                             "PGA Gain Cal : %5.1fdB(%02d:%02Xh)",m_MicPgaGainCal
                             , m_pTc->ConvCalibGainF32ToHex(m_MicPgaGainCal)
                             , m_pTc->ConvCalibGainF32ToHex(m_MicPgaGainCal));

    for(int i=0;i<MIC_PARAMETER_NUM;i++)
    {
        TWndParam->Gotoxy(0,i);
        if(i==mic->m_Cursor)
        {
            //J[\s̃tHgF
            TWndParam->SetTextColor(ATTR_COLOR_YELLOW);
            TWndParam->Printf("* ");
        }
        else
        {
            TWndParam->SetTextColor(ATTR_COLOR_WHITE);
            TWndParam->Printf("  ");
        }

        //str[i]ʕ\
        TWndParam->Printf(*(pParam+i));
    }
    
    
    //\L[ȊÕL[͂ɂĕύXp[^
    TWndParam->Gotoxy(1,MIC_PARAMETER_NUM+1);
    TWndParam->SetTextColor(ATTR_COLOR_WHITE);
    TWndParam->Printf("[            ]");
    TWndParam->Gotoxy(2,MIC_PARAMETER_NUM+1);
    if( mic->IsSampling() )
    {
        TWndParam->SetTextColor(ATTR_COLOR_CYAN);
        TWndParam->Printf("NOW SAMPLING");
    }
    else
    {
        TWndParam->SetTextColor(ATTR_COLOR_RED);
        TWndParam->Printf("NOW STANDBY ");
    }
    
    TWndParam->Gotoxy(15,MIC_PARAMETER_NUM+1);
    TWndParam->SetTextColor(ATTR_COLOR_WHITE);
    TWndParam->Printf("[         ]");
    TWndParam->Gotoxy(16,MIC_PARAMETER_NUM+1);
    if( m_IsPlayingSound )
    {
        TWndParam->SetTextColor(ATTR_COLOR_CYAN);
        TWndParam->Printf("SOUND ON ");
    }
    else
    {
        TWndParam->SetTextColor(ATTR_COLOR_RED);
        TWndParam->Printf("SOUND OFF");
    }
}
/*!--------------------------------------------------------------------------*
  Desc      l\EBhEp֐

  Args      *TWndResult
            *mic
            maxIndex, max
            minIndex, min
  
  Rtns      None.
 *---------------------------------------------------------------------------*/
void MicSamplingGraph::SetResultWindow(TextWindow *TWndResult, MicLib *mic, int maxIndex, s32 max, int minIndex, s32 min)
{
    TWndResult->SetTitle("Result");
    TWndResult->Gotoxy(0,0);
    TWndResult->SetTextColor(ATTR_COLOR_WHITE);
    TWndResult->Printf(" MAX(micData[%3d]): %6ld\n", maxIndex, max);
    TWndResult->Printf(" min(micData[%3d]): %6ld\n", minIndex, min);
    TWndResult->Printf(" AMP :              %6ld\n", mic->m_Amplitude);
    TWndResult->Printf(" SUM :          %10ld\n"   , mic->m_SumMicData);
    TWndResult->Printf(" data num :           %4.0f\n", mic->GetScreenSize().x);
    TWndResult->Printf(" AVERAGE :          %6.0f"
                        , mic->m_SumMicData / mic->GetScreenSize().x);
}
/*!--------------------------------------------------------------------------*
  Desc      }jAEBhEp֐

  Args      TWndManual
  
  Rtns      None.
 *---------------------------------------------------------------------------*/
void MicSamplingGraph::SetManualWindow(TextWindow *TWndManual)
{
    TWndManual->SetTitle("Manual");
    TWndManual->Gotoxy(0,0);
    TWndManual->SetTextColor(ATTR_COLOR_WHITE);
    TWndManual->Printf(" B   : Exit\n");
    TWndManual->Printf(" X   : Sound Start/Pause\n");
    TWndManual->Printf(" Y   : Clamp On/Off\n");
    TWndManual->Printf(" L/R : Turn Down/Up Volume\n");
    TWndManual->Printf(" PLUS/ANALOG  : Change Parameter\n");
}
/*!--------------------------------------------------------------------------*
  Desc      \EBhEp֐

  Args      TWndInfo
  
  Rtns      None.
 *---------------------------------------------------------------------------*/
void MicSamplingGraph::SetInfoWindow(TextWindow *TWndInfo)
{
    TWndInfo->SetTitle("Infomation");
}

/*!--------------------------------------------------------------------------*
  Desc      C֐
 *---------------------------------------------------------------------------*/
void MicSamplingGraph::Run()
{
    u8 setMicPgaGainCal = 0x0;
    
    // 
    MicLib *mic = MicLib::GetInstance();
    mic->Initialize();
    mic->TurnOnMic();
    
    // codecIuWFNg쐬
    m_pTc = new codec::TestCodec;
    //m_pTc->TestReadMultiEx_SPI2_MicPgaGainCalibration();
    //m_MicPgaGainCal = m_pTc->ConvCalibGainHexToF32(m_pTc->m_MicPgaGainCalibration_SPI2);
    
    
    using namespace nn::drivers::cal::CTR;
    
    // CAL ̏Al̎擾
    Calibration cal;
    nn::drivers::cal::CTR::CodecCalDataCore codecCalDataCore;
    cal.Initialize();
    cal.Get( &codecCalDataCore, CAL_DATA_CODEC );
    
    // CODEC  MIC PGA Gain Calibration ɏ
    setMicPgaGainCal = codecCalDataCore.micGainCalibrateParam;
    m_MicPgaGainCal  = m_pTc->ConvCalibGainHexToF32(setMicPgaGainCal);
    m_pTc->TestWriteMultiEx_SPI2_MicPgaGainCalibration(&setMicPgaGainCal);
    
    
    
    // `p O
    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();
    
    // pbh
    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;
    
    // TEh
    uji::eva::sound::CreateInstance();
    int  sndId = -1;
    f64  vol = 1.f;
    
    // }CNTvOJn
    mic->StartSampling();
    
    // }CNTvOOtݒ
    mic->SetSamplingGraphLine(nw::ut::Color8::RED, 2.f);
    mic->SetSamplingGraphScreen();
    
    // ------------------------------------------------------------------------
    //  Set Window
    // ------------------------------------------------------------------------
    const int FONT_SIZE = 12;
    // p[^p
    int PX = 0;
    int PY = 0;
    TextWindow *TWndParam  = new TextWindow( 35, 10, FONT_SIZE );
    (void)mic->m_WindowManager.CreateWindow(TWndParam,  NN_GX_DISPLAY0, PX, PY);
    Size P_Size = TWndParam->GetSize();
    // }jAp
    int MX = 0;
    int MY = P_Size.height+1;
    TextWindow *TWndManual = new TextWindow( 35,  8, FONT_SIZE );
    (void)mic->m_WindowManager.CreateWindow(TWndManual, NN_GX_DISPLAY0, MX, MY);
    Size M_Size = TWndManual->GetSize();
    // l\p
    int RX = P_Size.width+1;
    int RY = 0;
    TextWindow *TWndResult = new TextWindow( 28,  9, FONT_SIZE );
    (void)mic->m_WindowManager.CreateWindow(TWndResult, NN_GX_DISPLAY0, RX, RY);
    Size R_Size = TWndResult->GetSize();
    // \p
    int IX = P_Size.width+1;
    int IY = R_Size.height+1;
    TextWindow *TWndInfo   = new TextWindow( 28,  9, FONT_SIZE );
    (void)mic->m_WindowManager.CreateWindow(TWndInfo,   NN_GX_DISPLAY0, IX, IY);
    Size I_Size = TWndInfo->GetSize();
    
    NN_LOG("[WindowSize](width, height)\n");
    NN_LOG(" Parameter = (%d, %d),", P_Size.width, P_Size.height);
    NN_LOG(" Manual = (%d, %d),", M_Size.width, M_Size.height);
    NN_LOG(" Result = (%d, %d),", R_Size.width, R_Size.height);
    NN_LOG(" Info = (%d, %d)\n", I_Size.width, I_Size.height);
    
    // p[^pEBhEANeBu
    mic->m_WindowManager.SetActiveWindow(TWndParam);
    
    // EChE}l[W̃L[𖳌
    mic->m_WindowManager.SetManagerPadControlFlag(false);
    
    do 
    {
        // pbhǂݍ
        padReader.ReadLatest(&padStatus);
        pad.UpdatePad(padStatus);
        
        // }CNf[^擾
        nn::math::VEC2 screenSize = mic->GetScreenSize();
        s32 micData[static_cast<size_t>(screenSize.x)];
        mic->GetMicData(micData, static_cast<size_t>(screenSize.x));
        
        // PGA Gain Calibration XV
        setMicPgaGainCal = m_pTc->ConvCalibGainF32ToHex(m_MicPgaGainCal);
        m_pTc->TestWriteMultiEx_SPI2_MicPgaGainCalibration(&setMicPgaGainCal);
        /*
        // mFp
        	m_pTc->TestReadMultiEx_SPI2_MicPgaGainCalibration();
        	NN_LOG("%d\n", m_pTc->m_MicPgaGainCalibration_SPI2);
        */
        
        
        //p[^EBhE
        char str[MIC_PARAMETER_NUM][PARAMETER_WINDOW_STRING_MAX];
        SetParameterWindow(TWndParam, mic, str);
        
        //l\EBhE
        SetResultWindow(TWndResult, mic, mic->m_MaxIndex, micData[mic->m_MaxIndex]
                                       , mic->m_MinIndex, micData[mic->m_MinIndex]);
        
        //}jAEBhE
        SetManualWindow(TWndManual);
        
        //\EBhE
        SetInfoWindow(TWndInfo);
        
        
        // ------------------------------------------------------------------------
        //  t
        // ------------------------------------------------------------------------
        uji::eva::SetRenderingTargetPlus(NN_GX_DISPLAY0);
        
        
        //EBhE
        mic->m_WindowManager.UpdatePad(sys::Pad());//ɎgĂȂǂ
        mic->m_WindowManager.Update();
        mic->m_WindowManager.DrawDisplay0();

        
        // SwapBuffer
        gfx->m_DrawFramework->SwapBuffers();
        
        // ------------------------------------------------------------------------
        //  t
        // ------------------------------------------------------------------------
        uji::eva::SetRenderingTargetPlus(NN_GX_DISPLAY1);
        
        
        // }CNTvOOt`
        mic->GetSamplingGraph(micData);
        
        
        // SwapBuffer
        gfx->m_DrawFramework->SwapBuffers();
        
        // ------------------------------------------------------------------------
        //  input key
        // ------------------------------------------------------------------------
        
        //p[^؂ւ
        if(pad.IsButtonRepeat(Pad::BUTTON_UP) || 
           pad.IsButtonRepeat(Pad::BUTTON_EMULATION_UP))
        {
            mic->m_Cursor = mic->ChangeCursor(mic->m_Cursor, MIC_PARAMETER_NUM, DECREASE);
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_DOWN) || 
           pad.IsButtonRepeat(Pad::BUTTON_EMULATION_DOWN))
        {
            mic->m_Cursor = mic->ChangeCursor(mic->m_Cursor, MIC_PARAMETER_NUM, INCREASE);
        }
        
        //p[^̒l؂ւ
        if(pad.IsButtonRepeat(Pad::BUTTON_RIGHT))
        {
            switch( mic->m_Cursor )
            {
                case TYPE:  mic->ChangeType(INCREASE);  break;
                case RATE:  mic->ChangeRate(INCREASE);  break;
                case GAIN:  mic->ChangeGain(INCREASE);  break;
                case LOOP:  mic->SwitchLoop();          break;
                case POWER: mic->SwitchAmp();           break;
                case SOUND: 
                    // Ăꍇ͎~߂
                    if( m_IsPlayingSound )
                    {
                        m_pTs->PlaySound(sndId, &m_IsPlayingSound);
                    }
                    // TEhؑ
                    sndId = mic->ChangeSound(INCREASE);
                    break;
                case PGA_GAIN_CAL: 
                    if(-15.f <= m_MicPgaGainCal && m_MicPgaGainCal < 6.f)
                    {
                        m_MicPgaGainCal += 0.5f;
                    }
                    break;
                case CLAMP:
                    bClampTestFlag==true ? bClampTestFlag=false : bClampTestFlag=true;
                    nn::mic::SetClamp(bClampTestFlag);
                    break;
            }
            mic->StartSampling();
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_LEFT))
        {
            switch( mic->m_Cursor )
            {
                case TYPE:  mic->ChangeType(DECREASE);  break;
                case RATE:  mic->ChangeRate(DECREASE);  break;
                case GAIN:  mic->ChangeGain(DECREASE);  break;
                case LOOP:  mic->SwitchLoop();          break;
                case POWER: mic->SwitchAmp();           break;
                case SOUND: 
                    // Ăꍇ͎~߂
                    if( m_IsPlayingSound )
                    {
                        m_pTs->PlaySound(sndId, &m_IsPlayingSound);
                    }
                    // TEhؑ
                    sndId = mic->ChangeSound(DECREASE);
                    break;
                case PGA_GAIN_CAL: 
                    if(-15.f < m_MicPgaGainCal && m_MicPgaGainCal <= 6.f)
                    {
                        m_MicPgaGainCal -= 0.5f;
                    }
                    break;
                case CLAMP:
                    bClampTestFlag==true ? bClampTestFlag=false : bClampTestFlag=true;
                    nn::mic::SetClamp(bClampTestFlag);
                    break;
            }
            mic->StartSampling();
        }
        
        if(pad.IsButtonRepeat(Pad::BUTTON_EMULATION_RIGHT))
        {
            switch( mic->m_Cursor )
            {
                case TYPE:  mic->ChangeType(INCREASE);      break;
                case RATE:  mic->ChangeRate(INCREASE);      break;
                case GAIN:  mic->ChangeGain(INCREASE, 10);  break;
                case LOOP:  mic->SwitchLoop();              break;
                case POWER: mic->SwitchAmp();               break;
                case SOUND: 
                    // Ăꍇ͎~߂
                    if( m_IsPlayingSound )
                    {
                        m_pTs->PlaySound(sndId, &m_IsPlayingSound);
                    }
                    // TEhؑ
                    sndId = mic->ChangeSound(INCREASE);
                    break;
                case PGA_GAIN_CAL: 
                    if(-15.f <= m_MicPgaGainCal && m_MicPgaGainCal < 6.f)
                    {
                        m_MicPgaGainCal += 0.5f;
                    }
                    break;
                case CLAMP:
                    bClampTestFlag==true ? bClampTestFlag=false : bClampTestFlag=true;
                    nn::mic::SetClamp(bClampTestFlag);
                    break;
            }
            mic->StartSampling();
        }
        if(pad.IsButtonRepeat(Pad::BUTTON_EMULATION_LEFT))
        {
            switch( mic->m_Cursor )
            {
                case TYPE:  mic->ChangeType(DECREASE);      break;
                case RATE:  mic->ChangeRate(DECREASE);      break;
                case GAIN:  mic->ChangeGain(DECREASE, 10);  break;
                case LOOP:  mic->SwitchLoop();              break;
                case POWER: mic->SwitchAmp();               break;
                case SOUND: 
                    // Ăꍇ͎~߂
                    if( m_IsPlayingSound )
                    {
                        m_pTs->PlaySound(sndId, &m_IsPlayingSound);
                    }
                    // TEhؑ
                    sndId = mic->ChangeSound(DECREASE);
                    break;
                case PGA_GAIN_CAL: 
                    if(-15.f < m_MicPgaGainCal && m_MicPgaGainCal <= 6.f)
                    {
                        m_MicPgaGainCal -= 0.5f;
                    }
                    break;
                case CLAMP:
                    bClampTestFlag==true ? bClampTestFlag=false : bClampTestFlag=true;
                    nn::mic::SetClamp(bClampTestFlag);
                    break;
            }
            mic->StartSampling();
        }
        
        // TEhON/OFFinEOmFpj
        if(pad.IsButtonRepeat(Pad::BUTTON_X) && sndId>=0)
        {
            m_pTs->PlaySound(sndId, &m_IsPlayingSound);
            if( m_IsPlayingSound )
            {
                TWndInfo->SetTextColor(ATTR_COLOR_MAGENTA);
                TWndInfo->Printf("> Play Sound.\n");
                TWndInfo->SetTextColor(ATTR_COLOR_WHITE);
                TWndInfo->Printf("> vol = %4.2f\n", vol);
            }
            else
            {
                TWndInfo->SetTextColor(ATTR_COLOR_MAGENTA);
                TWndInfo->Printf("> Stop Sound.\n");
            }
        }
        
        if(pad.IsButtonRepeat(Pad::BUTTON_L) || pad.IsButtonRepeat(Pad::BUTTON_R))
        {
            if(pad.IsButtonRepeat(Pad::BUTTON_R) && (2.0f > vol))
            {
                vol = m_pTs->TurnUpVolume(vol);
            }
            if(pad.IsButtonRepeat(Pad::BUTTON_L) && (vol > 0.1f))
            {
                vol = m_pTs->TurnDownVolume(vol);
            }
            TWndInfo->SetTextColor(ATTR_COLOR_WHITE);
            TWndInfo->Printf("> vol = %4.2f\n", vol);
        }
        
        // Nv ON/OFF
        if(pad.IsButtonRepeat(Pad::BUTTON_Y))
        {
            bClampTestFlag==true ? bClampTestFlag=false : bClampTestFlag=true;
            nn::mic::SetClamp(bClampTestFlag);
            TWndInfo->SetTextColor(ATTR_COLOR_WHITE);
            TWndInfo->Printf("> SetClamp(%d)\n", bClampTestFlag==true ? 1 : 0);
        }
        
    } while(!pad.IsButtonRepeat(sys::Pad::BUTTON_B));
    
    do
    {
        padReader.ReadLatest(&padStatus);
        pad.UpdatePad(padStatus); 
    } while(!pad.IsButtonUp(sys::Pad::BUTTON_B));
    
    // TEhI
    uji::eva::sound::DeleteInstance();
    
    // EChEjiobt@j
    mic->m_WindowManager.DestroyWindow(TWndParam);
    mic->m_WindowManager.DestroyWindow(TWndManual);
    mic->m_WindowManager.DestroyWindow(TWndResult);
    mic->m_WindowManager.DestroyWindow(TWndInfo);
    
    // }CN̏I
    mic->TurnOffMic();
    mic->Finalize();
}


/*!--------------------------------------------------------------------------*
  Desc      TvOOt\
 *---------------------------------------------------------------------------*/
void Eva_DrawSamplingGraph(void)
{
    MicSamplingGraph micsg;
    micsg.Run();
}


} // namespace eva
} // namespace uji
