/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     mic.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 10353 $
 *---------------------------------------------------------------------------*/

#ifndef _UJI_EVA_MIC_LIB_H_
#define _UJI_EVA_MIC_LIB_H_

#include <nn/mic.h>
#include <nn/math.h>
#include <nn/snd.h>
#include "sys_SoundPlayer.h"
#include "sys.h"
#include "sys_GraphicsDrawing.h"

namespace uji{
namespace eva{

#ifndef EVA_WL_AUDIO
const int MIC_BUFFER_SIZE = nn::mic::BUFFER_ALIGNMENT_SIZE;
#else
const int MIC_BUFFER_SIZE = nn::mic::BUFFER_ALIGNMENT_SIZE;// * 16; DFTgp̓RgAEg
#endif
const u8 MIC_GAIN_MAX = 119;
const u8 MIC_GAIN_MIN = 0;

//vCx[g֐
void SetRenderingTargetPlus(const s32 display);
void DrawLine_Y_Reverse(const nn::math::VEC2& p1, const nn::math::VEC2& p2);
u64  PowXN(u32 x, u8 n);
//void WaitMilliSeconds(const f32 time);

// }CN]p{NX
class MicLib
{
public:
    //nn::mic::CTRRs[
    /*--------------------------------------------------
     * @brief   }CÑTvOʂ񋓑
     *--------------------------------------------------*/
    enum SamplingType
    {
        MIC_SAMPLING_TYPE_8BIT         = 0,     //!< Lrbg 8 rbgiȂj̃TvOBo̓f[^͈̔͂ 0 ` 255 ɂȂ܂B 
        MIC_SAMPLING_TYPE_16BIT        = 1,     //!< Lrbg 16 rbgiȂj̃TvOBo̓f[^͈̔͂ 0 ` 65535 ɂȂ܂B 
        MIC_SAMPLING_TYPE_SIGNED_8BIT  = 2,     //!< Lrbg 8 rbgitj̃TvOBo̓f[^͈̔͂ -128 ` 127 ɂȂ܂B 
        MIC_SAMPLING_TYPE_SIGNED_16BIT = 3,     //!< Lrbg 16 rbgitj̃TvOBo̓f[^͈̔͂ -32768 ` 32767 ɂȂ܂B 
        MIC_SAMPLING_TYPE_SUPREMUM     = 4
    };
    //nn::mic::CTRRs[
    /*--------------------------------------------------
     * @brief   }CÑTvO[g񋓑
     *--------------------------------------------------*/
    enum SamplingRate
    {
        MIC_SAMPLING_RATE_32730      = 0,       //!< 32.73kHz
        MIC_SAMPLING_RATE_16360      = 1,       //!< 16.36kHz
        MIC_SAMPLING_RATE_10910      = 2,       //!< 10.91kHz
        MIC_SAMPLING_RATE_8180       = 3,       //!< 8.18kHz
        MIC_SAMPLING_RATE_SUPREMUM   = 4
    };
    
    enum SoundFileName
    {
        NO_SOUND                 = -1,
        LR_SIN_16BIT_1000HZ      = 0,
        L_SIN_16BIT_1000HZ       = 1,
        R_SIN_16BIT_1000HZ       = 2,
        NG_SOUND                 = 3,
        OK_SOUND                 = 4,
        LR_SIN_16BIT_100HZ       = 5,
        LR_SIN_16BIT_200HZ       = 6,
        LR_SIN_16BIT_500HZ       = 7,
        LR_SIN_16BIT_4000HZ      = 8,
        SOUND_FILE_NAME_SUPREMUM = 9
    };
    
public: 
    static MicLib* GetInstance()
    {
        if (m_pInstance == 0)
        {
            m_pInstance = new MicLib;
        }
        return m_pInstance;
    }
    
private: 
    MicLib():m_MaxIndex(0), m_MinIndex(0), m_SumMicData(0), 
              m_Cursor(0), 
              m_SamplingType(MIC_SAMPLING_TYPE_16BIT), 
              m_SamplingRate(MIC_SAMPLING_RATE_16360), 
              m_SndFile(NO_SOUND), 
              m_SamplingOffset(0), 
              m_Delta(0.f), 
              m_Gain(nn::mic::AMP_GAIN_DEFAULT_VALUE), m_Loop(true), 
              m_EnabledMic(false), m_IsSampling(false), 
              m_IsInitializedMic(false), m_IsSettingBuffer(false)
    {
        if (m_pInstance != NULL)
        {
            NW_FATAL_ERROR("TestMic instance already exists.");
        }
        m_pInstance = this;
        
        GetSamplingType();
        GetSamplingRate();
    }
    MicLib( const MicLib &mic );
    MicLib& operator = (const MicLib &mic);
    
    //fXgN^
    ~MicLib(){}
    
public:
    //}CNJn
    void Initialize(void);
    //}CNI
    void Finalize(void);
    //}CNdIIt
    bool TurnOnMic();
    bool TurnOffMic();
    //TvO^Cvƃ[gvZbg
    void PresetSamplingType(SamplingType type);
    void PresetSamplingRate(SamplingRate rate);
    //TvOJnI
    void StartSampling(void);
    void StopSampling(void);
    //}CNTvO
    void GetMicData(s32* pDest, size_t size);
    //}CN̓obt@̎gpʍĐݒ/
    void SetSamplingLength(int);
    void ResetSamplingLength(void);
    //}CNTvOʂ̕`
    void SetSamplingGraphScreen(void);
    void SetSamplingGraphScreen(f32 delta);
    void SetSamplingGraphLine(const nw::ut::Color8 color, const f32 width);
    void GetSamplingGraph(const s32* pDest);
    //p[^ύXp֐
    int ChangeCursor(int i, int paraNum, bool increase);
    void ChangeType(bool increase);
    void ChangeRate(bool increase);
    void ChangeGain(bool increase);
    void ChangeGain(bool increase, u8 accel);
    void SwitchLoop(void);
    void SwitchSampling(void);
    void SwitchAmp(void);
    int  ChangeSound(bool increase);
    bool SwitchPlaySound(void);
    //o[ϐԂ
    nn::math::VEC2 GetScreenSize(void);
    char* GetSamplingType();
    int  GetSamplingRate();
    int  GetSamplingRateId();
    bool IsSamplingLoop(void);
    bool IsSampling(void);
    bool GetAmp(void);
    char* GetSoundFileName(void);
    //bool IsPlaySound(void);

public:
    sys::WindowManager m_WindowManager;
    int     m_MaxIndex;
    int     m_MinIndex;
    s32     m_Amplitude;
    s32     m_SumMicData;
    s32     m_AveMicData;
    int     m_Cursor;
    
private:
    static char m_MicBuffer[MIC_BUFFER_SIZE];
    size_t m_SamplingLength;
    
    SamplingType    m_SamplingType;
    SamplingRate    m_SamplingRate;
    SoundFileName   m_SndFile;
    s32             m_SamplingOffset;
    
    //Ot`TCYύXp
    f32     m_Delta;
    
    //p[^EBhE\p
    char    m_TypeName[50];
    int     m_Rate;
    int     m_RateId;
    u8      m_Gain;
    char    m_SndFileName[50];
    bool    m_Loop;
    
    bool    m_EnabledMic;
    bool    m_IsSampling;
    //bool    m_IsPlayingSound;
    
    bool    m_IsInitializedMic;
    bool    m_IsSettingBuffer;
    
    //Ot`p
    nn::math::VEC2  m_ScreenPos;
    nn::math::VEC2  m_ScreenSize;
    nw::ut::Color8  m_GraphColor;
    f32             m_GraphLineWidth;
    
    // VOgIuWFNgւ̃|C^
    static MicLib* m_pInstance;
};




}   // namespace eva
}   // namespace uji

/* _UJI_EVA_MIC_LIB_H_ */
#endif

/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
